/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.license.service;

import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMenuInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.license.LicenseServiceUtil;
import kd.bos.license.api.ILicenseGrayService;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.license.api.LicenseConfigParseResult;
import kd.bos.license.api.bean.LicenseGrayNotice;
import kd.bos.license.bean.gray.GrayFeatureScheme;
import kd.bos.license.config.gray.LicenseGrayConfigHelper;
import kd.bos.license.pojo.gray.GrayFeatScheApp;
import kd.bos.license.pojo.gray.GrayFeatScheObj;
import kd.bos.license.pojo.gray.GrayFeature;
import kd.bos.license.service.cache.LicenseGrayCache;
import kd.bos.license.util.LicenseGrayFeatureUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.runmode.RunModeServiceHelper;
import kd.bos.util.CollectionUtils;

public class LicenseGrayServiceImpl
implements ILicenseGrayService {
    private static Log logger = LogFactory.getLog(LicenseGrayServiceImpl.class);

    public LicenseCheckResult checkGrayLicense(String entityNum) {
        LicenseCheckResult licenseCheckResult = new LicenseCheckResult();
        if (!this.isEnableGrayLicense()) {
            return null;
        }
        String featureScmNum = LicenseGrayCache.getGrayLicenseFeatureCtrl((String)entityNum);
        logger.debug("LicenseGrayServiceImpl.checkGrayLicense : entityNum={},featureScmNum={}", (Object)entityNum, (Object)featureScmNum);
        if (StringUtils.isBlank((CharSequence)featureScmNum)) {
            return null;
        }
        GrayFeature hasLicGrayFeatureinfo = LicenseGrayCache.getHasLicGrayFeatureinfo((String)featureScmNum);
        if (null != hasLicGrayFeatureinfo) {
            Date now = new Date();
            Date beginDate = hasLicGrayFeatureinfo.getBeginDate();
            Date endDate = hasLicGrayFeatureinfo.getEndDate();
            if (endDate.after(now) && beginDate.before(now)) {
                licenseCheckResult.setHasLicense(Boolean.valueOf(true));
            }
        }
        if (!licenseCheckResult.getHasLicense().booleanValue()) {
            String featureName = "";
            GrayFeatureScheme grayFeatureInfo = LicenseGrayFeatureUtil.getGrayFeatureInfo((String)featureScmNum);
            if (null != grayFeatureInfo) {
                featureName = grayFeatureInfo.getName();
            }
            if (StringUtils.isEmpty((CharSequence)featureName)) {
                featureName = featureScmNum;
            }
            licenseCheckResult.setMsg(String.format(ResManager.loadKDString((String)"\u6ca1\u6709\u201c%1$s\u201d\u7070\u5ea6\u7279\u6027\u8bb8\u53ef\u3002", (String)"LicenseGrayServiceImpl_0", (String)"bos-mservice-license", (Object[])new Object[0]), featureName));
        }
        logger.debug("LicenseGrayServiceImpl.checkGrayLicense : entityNum={},featureScmNum={},hasLicense={} ", new Object[]{entityNum, featureScmNum, licenseCheckResult.getHasLicense()});
        return licenseCheckResult;
    }

    public LicenseGrayNotice getExpiringGrayFeatureNotice(Long userId, String bizObjNumber) {
        return this.getExpiringGrayFeatureNotice(userId, bizObjNumber, bizObjNumber, bizObjNumber);
    }

    public LicenseGrayNotice getExpiringGrayFeatureNotice(Long userId, String bizObjNumber, String appNumber, String cloud) {
        LicenseGrayNotice NO_NOTICE = new LicenseGrayNotice(LicenseGrayNotice.NoticeType.NO_NOTICE, null, null, null);
        if (!this.isEnableGrayLicense()) {
            logger.debug("LicenseGrayServiceImpl.getExpiringGrayFeatureNotice : isEnableGrayLicense=false");
            return NO_NOTICE;
        }
        boolean enableTurnOffGrayNotice = LicenseServiceUtil.isEnableTurnOffGrayNotice();
        if (enableTurnOffGrayNotice) {
            logger.debug("LicenseGrayServiceImpl.getExpiringGrayFeatureNotice : enableTurnOffGrayNotice is true . NO_NOTICE");
            return NO_NOTICE;
        }
        if (!LicenseGrayCache.isGrayLicExpiringSoon()) {
            logger.debug("LicenseGrayServiceImpl.getExpiringGrayFeatureNotice : grayLicExpiringSoon:false");
            return NO_NOTICE;
        }
        Date expiringGrayFeatureEndDate = LicenseGrayCache.getExpiringGrayEndDate((Long)userId, (String)bizObjNumber, (String)appNumber, (String)cloud);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        if (null == expiringGrayFeatureEndDate) {
            logger.debug("LicenseGrayServiceImpl.getExpiringGrayFeatureNotice : date is null . NO_NOTICE");
            return new LicenseGrayNotice(LicenseGrayNotice.NoticeType.NO_NOTICE, null, null, null);
        }
        if (new Date().after(expiringGrayFeatureEndDate)) {
            logger.debug("LicenseGrayServiceImpl.getExpiringGrayFeatureNotice : now after date . EXPIRED");
            return new LicenseGrayNotice(LicenseGrayNotice.NoticeType.EXPIRED, expiringGrayFeatureEndDate, String.format(ResManager.loadKDString((String)"\u8be5\u529f\u80fd\u4e3a\u7070\u5ea6\u8bd5\u7528\u529f\u80fd\uff0c\u8bd5\u7528\u622a\u6b62\u65e5\u671f\u4e3a%1$s\u3002\u76ee\u524d\u5df2\u7ed3\u675f\u8bd5\u7528\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8ba2\u8d2d\u5e76\u4f7f\u7528\u3002", (String)"LicenseGrayServiceImpl_1", (String)"bos-mservice-license", (Object[])new Object[0]), sdf.format(expiringGrayFeatureEndDate)), ResManager.loadKDString((String)"\u7070\u5ea6\u8bb8\u53ef\u5df2\u5230\u671f", (String)"LicenseGrayServiceImpl_4", (String)"bos-mservice-license", (Object[])new Object[0]));
        }
        logger.debug("LicenseGrayServiceImpl.getExpiringGrayFeatureNotice : now before date . UNEXPIRED");
        return new LicenseGrayNotice(LicenseGrayNotice.NoticeType.UNEXPIRED, expiringGrayFeatureEndDate, String.format(ResManager.loadKDString((String)"\u8be5\u529f\u80fd\u4e3a\u7070\u5ea6\u8bd5\u7528\u529f\u80fd\uff0c\u8bd5\u7528\u622a\u6b62\u65e5\u671f\u4e3a%1$s\u3002\u5230\u671f\u540e\uff0c\u8be5\u529f\u80fd\u9700\u8981\u8d2d\u4e70\u624d\u80fd\u4f7f\u7528\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8ba2\u8d2d\u5e76\u4f7f\u7528\u3002", (String)"LicenseGrayServiceImpl_2", (String)"bos-mservice-license", (Object[])new Object[0]), sdf.format(expiringGrayFeatureEndDate)), ResManager.loadKDString((String)"\u7070\u5ea6\u8bb8\u53ef\u5230\u671f\u63d0\u9192", (String)"LicenseGrayServiceImpl_3", (String)"bos-mservice-license", (Object[])new Object[0]));
    }

    public Map<String, String> getLicenseGrayConfig() throws Exception {
        return LicenseGrayConfigHelper.getLicenseGrayConfigImpl();
    }

    public Map<String, Map<String, String>> getAllGrayCloudInfo() {
        if (!this.isEnableGrayLicense()) {
            return Collections.emptyMap();
        }
        Map res = LicenseGrayCache.getAllGrayCloudLabelInfo();
        logger.debug("LicenseGrayServiceImpl.getAllGrayCloudInfo res={}", (Object)res);
        return res;
    }

    public Map<String, Map<String, String>> getGrayCloudInfoByIds(List<String> cloudIds) {
        if (CollectionUtils.isEmpty(cloudIds) || !this.isEnableGrayLicense()) {
            return Collections.emptyMap();
        }
        Map<String, Map<String, String>> grayCloudInfoMap = this.getAllGrayCloudInfo();
        if (grayCloudInfoMap.size() <= 0) {
            return Collections.emptyMap();
        }
        HashMap<String, Map<String, String>> res = new HashMap<String, Map<String, String>>(16);
        for (String cloudId : cloudIds) {
            Map<String, String> cloudInfo = grayCloudInfoMap.get(cloudId);
            if (cloudInfo == null) continue;
            res.put(cloudId, cloudInfo);
        }
        logger.debug("LicenseGrayServiceImpl.getGrayCloudInfoByIds cloudIds={},res={}", cloudIds, res);
        return res;
    }

    public Map<String, Map<String, String>> getAllGrayAppInfo() {
        if (!this.isEnableGrayLicense()) {
            return Collections.emptyMap();
        }
        Map res = LicenseGrayCache.getAllGrayAppLabelInfo();
        logger.debug("LicenseGrayServiceImpl.getAllGrayAppInfo res={}", (Object)res);
        return res;
    }

    public Map<String, Map<String, String>> getGrayAppInfoByNumbers(List<String> appNumbers) {
        if (CollectionUtils.isEmpty(appNumbers) || !this.isEnableGrayLicense()) {
            return Collections.emptyMap();
        }
        Map<String, Map<String, String>> grayAppInfoMap = this.getAllGrayAppInfo();
        if (grayAppInfoMap.size() <= 0) {
            return Collections.emptyMap();
        }
        HashMap<String, Map<String, String>> res = new HashMap<String, Map<String, String>>(16);
        for (String appNumber : appNumbers) {
            Map<String, String> appInfo = grayAppInfoMap.get(appNumber);
            if (appInfo == null) continue;
            res.put(appNumber, appInfo);
        }
        logger.debug("LicenseGrayServiceImpl.getGrayAppInfoByNumbers appNumbers={},res={}", appNumbers, res);
        return res;
    }

    public Map<String, Map<String, Map<String, String>>> getAllGrayObjectInfo() {
        if (!this.isEnableGrayLicense()) {
            return Collections.emptyMap();
        }
        Map appNumber2ObjectNumber2Info = LicenseGrayCache.getAllGrayObjectLabelInfo();
        logger.debug("LicenseGrayServiceImpl.getGrayFeatScheObj appNumber2ObjectNumber2Info={}", (Object)appNumber2ObjectNumber2Info);
        return appNumber2ObjectNumber2Info;
    }

    public Map<String, Map<String, Map<String, String>>> getGrayObjectInfoByAppNumbers(List<String> appNumbers) {
        if (CollectionUtils.isEmpty(appNumbers) || !this.isEnableGrayLicense()) {
            return Collections.emptyMap();
        }
        Map<String, Map<String, Map<String, String>>> appNum2ObjectNumber2Info = this.getAllGrayObjectInfo();
        if (appNum2ObjectNumber2Info.size() <= 0) {
            return Collections.emptyMap();
        }
        HashMap<String, Map<String, Map<String, String>>> res = new HashMap<String, Map<String, Map<String, String>>>(16);
        for (String appNumber : appNumbers) {
            Map<String, Map<String, String>> objectNumber2Info = appNum2ObjectNumber2Info.get(appNumber);
            if (objectNumber2Info == null || objectNumber2Info.size() <= 0) continue;
            res.put(appNumber, objectNumber2Info);
        }
        logger.debug("LicenseGrayServiceImpl.getGrayObjectInfoByAppNumbers appNumbers={},res={}", appNumbers, res);
        return res;
    }

    public Map<String, Map<String, Map<String, String>>> getGrayMenuIdByPublishAppNumbers(List<String> appNumbers) {
        if (CollectionUtils.isEmpty(appNumbers) || !this.isEnableGrayLicense()) {
            return Collections.emptyMap();
        }
        Map<String, Map<String, Map<String, String>>> appNum2ObjectNumber2Info = this.getAllGrayObjectInfo();
        if (appNum2ObjectNumber2Info.size() <= 0) {
            return Collections.emptyMap();
        }
        HashMap<String, Map<String, String>> objectNumber2Info = new HashMap<String, Map<String, String>>();
        for (Map.Entry<String, Map<String, Map<String, String>>> appNum2ObjectNumber2InfoEntry : appNum2ObjectNumber2Info.entrySet()) {
            objectNumber2Info.putAll(appNum2ObjectNumber2InfoEntry.getValue());
        }
        HashMap<String, Map<String, Map<String, String>>> res = new HashMap<String, Map<String, Map<String, String>>>(16);
        Map allAppMenus = AppMetadataCache.getAllAppMenus();
        for (String appNumber : appNumbers) {
            List appMenuInfos = (List)allAppMenus.get(appNumber);
            for (AppMenuInfo appMenuInfo : appMenuInfos) {
                Map info;
                String objectNumber = appMenuInfo.getFormId();
                if (StringUtils.isBlank((CharSequence)objectNumber) || (info = (Map)objectNumber2Info.get(objectNumber)) == null || info.size() == 0) continue;
                Map objectNumber2InfoRes = res.computeIfAbsent(appNumber, k -> new HashMap());
                objectNumber2InfoRes.put(appMenuInfo.getId(), info);
            }
        }
        logger.debug("LicenseGrayServiceImpl.getGrayMenuIdByPublishAppNumbers appNumbers={},res={}", appNumbers, res);
        return res;
    }

    public boolean isEnableGrayLicense() {
        return LicenseServiceUtil.isEnableGrayLicense();
    }

    public LicenseConfigParseResult parseLicenseGrayControlFile(String file) {
        logger.info("LicenseGrayServiceImpl#parseLicenseGrayControlFile:file={}", (Object)file);
        return LicenseGrayConfigHelper.parseLicenseGrayControlFile((String)file);
    }

    public Set<String> getAllGrayAppNumbers() {
        return this.getAllGrayAppNumbers(true, false);
    }

    public Set<String> getAllGrayAppNumbers(boolean ignoreBlack, boolean ignoreOnsale) {
        Map appNumber2GrayFeatScheApp = LicenseGrayCache.getGrayFeatureSchemeApp();
        if (appNumber2GrayFeatScheApp == null || appNumber2GrayFeatScheApp.size() == 0) {
            return Collections.emptySet();
        }
        HashSet<String> res = new HashSet<String>();
        for (Map.Entry entry : appNumber2GrayFeatScheApp.entrySet()) {
            GrayFeatScheApp grayFeatScheApp = (GrayFeatScheApp)entry.getValue();
            String appNum = grayFeatScheApp.getAppNum();
            if (ignoreBlack && ignoreOnsale) {
                res.add(appNum);
                continue;
            }
            if (ignoreBlack && !ignoreOnsale) {
                if (!grayFeatScheApp.getOnSale().booleanValue()) {
                    res.add(appNum);
                    continue;
                }
                res.remove(appNum);
                continue;
            }
            if (!ignoreBlack && ignoreOnsale) {
                if (!grayFeatScheApp.getBlack().booleanValue()) continue;
                res.add(appNum);
                continue;
            }
            if (!grayFeatScheApp.getOnSale().booleanValue() && grayFeatScheApp.getBlack().booleanValue()) {
                res.add(appNum);
                continue;
            }
            if (!grayFeatScheApp.getOnSale().booleanValue()) continue;
            res.remove(appNum);
        }
        logger.debug("LicenseGrayServiceImpl#getAllGrayAppNumbers:res={}", res);
        return res;
    }

    public Set<String> getGrayObjectNumbersByApp(String appNumber) {
        return this.getGrayObjectNumbersByApp(appNumber, true, false);
    }

    public Set<String> getGrayObjectNumbersByApp(String appNumber, boolean ignoreBlack, boolean ignoreOnsale) {
        if (StringUtils.isBlank((CharSequence)appNumber)) {
            return Collections.emptySet();
        }
        Map objNumber2GrayFeatScheObj = LicenseGrayCache.getGrayFeatureSchemeObj();
        if (objNumber2GrayFeatScheObj == null || objNumber2GrayFeatScheObj.size() == 0) {
            return Collections.emptySet();
        }
        HashSet<String> res = new HashSet<String>();
        List entityNumFromBlacklist = RunModeServiceHelper.getEntityNumFromBlacklistBy((String)appNumber);
        for (Map.Entry entry : objNumber2GrayFeatScheObj.entrySet()) {
            GrayFeatScheObj grayFeatScheObj = (GrayFeatScheObj)entry.getValue();
            String objectNumber = grayFeatScheObj.getEntityNum();
            if (!appNumber.equals(grayFeatScheObj.getAppNum()) && !appNumber.equals(grayFeatScheObj.getAppId()) || !entityNumFromBlacklist.contains(objectNumber)) continue;
            if (ignoreBlack && ignoreOnsale) {
                res.add(objectNumber);
                continue;
            }
            if (ignoreBlack && !ignoreOnsale) {
                if (grayFeatScheObj.getOnSale().booleanValue()) continue;
                res.add(objectNumber);
                continue;
            }
            if (!ignoreBlack && ignoreOnsale) {
                if (!grayFeatScheObj.getBlack().booleanValue()) continue;
                res.add(objectNumber);
                continue;
            }
            if (grayFeatScheObj.getOnSale().booleanValue() || !grayFeatScheObj.getBlack().booleanValue()) continue;
            res.add(objectNumber);
        }
        logger.debug("LicenseGrayServiceImpl#getGrayObjectNumbersByApp:res={}", res);
        return res;
    }
}

