/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.license.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.net.URLEncoder;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.MobileBillShowParameter;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.encrypt.Encrypters;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.PermissionControlType;
import kd.bos.entity.gray.MetaGrayInfo;
import kd.bos.entity.param.AppParam;
import kd.bos.exception.ErrorPageCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.framework.gray.GrayStrategy;
import kd.bos.license.NextCloud;
import kd.bos.license.UpdateLicGroupUser;
import kd.bos.license.api.ILicenseService;
import kd.bos.license.api.LicenseAssignLog;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.license.api.RegisterUserLog;
import kd.bos.license.api.bean.CloudUserInfo;
import kd.bos.license.api.bean.ISVProdInfo;
import kd.bos.license.api.bean.LicenseError;
import kd.bos.license.api.bean.LicenseGroupInfo;
import kd.bos.license.api.bean.ProductGroup;
import kd.bos.license.api.bean.SyncLicenseProgressInfo;
import kd.bos.license.bean.LicGroupRuntime;
import kd.bos.license.bean.LicenseCheckLog;
import kd.bos.license.bean.LicenseGroupCtrl;
import kd.bos.license.bean.LicenseSyncDetailLog;
import kd.bos.license.bean.LicenseSyncLog;
import kd.bos.license.bean.UserIndex;
import kd.bos.license.config.LicenseConfigHelper;
import kd.bos.license.config.RSAUtil;
import kd.bos.license.engine.LicenseUserRelEngine;
import kd.bos.license.service.cache.LicenseCache;
import kd.bos.license.service.cache.LicenseCacheMrg;
import kd.bos.license.service.util.LicenseServiceUtil;
import kd.bos.license.util.AddUserLicGroupThread;
import kd.bos.license.util.EncryptUtil;
import kd.bos.license.util.LicGroupRuntimeUtil;
import kd.bos.license.util.LicenseConfigUtil;
import kd.bos.license.util.LicenseExpireUtil;
import kd.bos.license.util.LicenseGroupUtil;
import kd.bos.license.util.LicenseLogUtil;
import kd.bos.license.util.LicenseMCApiUtil;
import kd.bos.license.util.LicenseModuleUtil;
import kd.bos.license.util.LicenseUtil;
import kd.bos.license.util.UserIndexUtil;
import kd.bos.license.util.UserLicGroupUtil;
import kd.bos.list.ListShowParameter;
import kd.bos.list.MobileListShowParameter;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.OpLogAppInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.TransferUtil;
import kd.bos.metagray.MetaGrayService;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.mvc.SessionManager;
import kd.bos.nocode.NoCodeRuntimeService;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.param.service.IParameterHelperService;
import kd.bos.permission.model.AdminInfo;
import kd.bos.service.ServiceFactory;
import kd.bos.service.ServiceSvcFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.devportal.DevVerifyServiceHelper;
import kd.bos.servicehelper.license.LicenseGrayServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.log.LogServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.servicehelper.portal.InitailVersionServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.bos.useragent.util.DeviceType;
import kd.bos.useragent.util.OperatingSystem;
import kd.bos.util.HttpClientUtils;
import kd.bos.workflow.message.api.SmsUsingQuantities;

public class LicenseServiceImpl
implements ILicenseService {
    private static final String ENTITY_BOS_USER = "bos_user";
    private static Log logger = LogFactory.getLog(LicenseServiceImpl.class);
    private static final String ENTITY_REGUSER_LOG = "lic_reguserlog";
    private static final String ENTITY_USERBITMAPINDEX = "lic_userbitmapindex";
    private static final String PROPERTY_OP_NAME = "opname";
    private static final String PROPERTY_OP_DESCRIPTION = "opdescription";
    private static final String PROPERTY_OP_TIME = "optime";
    private static final String PROPERTY_USER = "user";
    private static final int MAX_DATA = 500;
    public static final String SYNCSTATUS = "2";
    public static final String SPLIT = "_SPLIT_";
    private static final String ENTITY_LIC_USER_GROUP = "lic_userlicensegroup";
    private static final String LIC_MODULE = "lic_module";
    private String UPLOAD_REG_USER = ResManager.loadKDString((String)"\u4e0a\u4f20\u6ce8\u518c\u7528\u6237", (String)"LicenseServiceImpl_59", (String)"bos-mservice-license", (Object[])new Object[0]);
    private static final String FMODEL_TYPE_BASE_FORM = "base";
    private static List<String> ignoreModelTypes = Collections.singletonList("base");
    private static String IGNORE_MODEL_PARAM = "parameter";
    private static final String CANCEL = "cancel";
    private static final String ERRORCODE = "errorCode";
    private static final String CANCEL_MESSAGE = "cancelMessage";
    private static final String PROP_PHONE = "phone";
    private static final String PROP_EMAIL = "email";
    private static final String PROP_NAME = "username";
    public static final String ConvPageCacheKey_ConvertOperationResult = "ConvertOperationResult";
    private static final String GROUP_PRO_FSS = "PRO_FSS";
    private static List<String> ignoreAppIds = Arrays.asList("/TSOQUVPJGHJ", "0WQD=94ZN+Q2", "1QZY/LSR+O+B", "1QZXKQR2I87+", "1QZXQ1QM0RHJ", "1QZWXGSDUB/A");
    private static List<String> offlineAppIds = Collections.singletonList("/DNEA3QW/ATD");
    private static final int UDD_GROUP_TOTAL_COUNT = 999999;
    private static List<String> offlineAppIdsByOldVersion = Arrays.asList("2AN7+R08B0/5", "0DUMFA=HL9S1", "101/NKY=9OLA", "eae607fb000152ac", "SE7/UZFDVIE");
    private static final List<String> blackList = Arrays.asList("1", "2", "3", "10");
    private static final Map<String, Float> kingdeeISVMap = Arrays.stream(new Object[][]{{"kingdee", Float.valueOf(4.0f)}, {"gov", Float.valueOf(99.0f)}, {"zwy", Float.valueOf(99.0f)}, {"xn", Float.valueOf(1.0f)}, {"kdxk", Float.valueOf(1.0f)}}).collect(Collectors.toMap(kv -> (String)kv[0], kv -> (Float)kv[1]));
    private static List<String> IGNORE_LICENSE_WHITE_LIST = new ArrayList<String>(64);
    private static List<String> IGNORE_LICENSE_WHITE_XK_LIST = new ArrayList<String>(64);

    @Deprecated
    public static Map<String, String> getGroupInfo() {
        HashMap<String, String> groupInfo = new HashMap<String, String>(45);
        groupInfo.put(SYNCSTATUS, ResManager.loadKDString((String)"\u5458\u5de5\u670d\u52a1\u5168\u5458\u5e94\u7528\u5206\u7ec4", (String)"LicenseServiceImpl_84", (String)"bos-mservice-license", (Object[])new Object[0]));
        groupInfo.put("3", ResManager.loadKDString((String)"\u5546\u65c5\u96c6\u6210\u5206\u7ec4", (String)"LicenseServiceImpl_1", (String)"bos-mservice-license", (Object[])new Object[0]));
        groupInfo.put("4", ResManager.loadKDString((String)"\u8d22\u52a1\u4f1a\u8ba1\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseServiceImpl_2", (String)"bos-mservice-license", (Object[])new Object[0]));
        groupInfo.put("5", ResManager.loadKDString((String)"\u8d22\u52a1\u5171\u4eab\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseServiceImpl_3", (String)"bos-mservice-license", (Object[])new Object[0]));
        groupInfo.put("6", ResManager.loadKDString((String)"\u591a\u6838\u7b97\u4f53\u7cfb\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseServiceImpl_4", (String)"bos-mservice-license", (Object[])new Object[0]));
        groupInfo.put("7", ResManager.loadKDString((String)"\u8d22\u52a1\u591a\u7ec4\u7ec7\u6279\u91cf\u5904\u7406\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseServiceImpl_5", (String)"bos-mservice-license", (Object[])new Object[0]));
        groupInfo.put("8", ResManager.loadKDString((String)"\u667a\u80fdRPA\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseServiceImpl_6", (String)"bos-mservice-license", (Object[])new Object[0]));
        groupInfo.put("9", ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u534f\u540c\u4e91\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseServiceImpl_7", (String)"bos-mservice-license", (Object[])new Object[0]));
        groupInfo.put("10", ResManager.loadKDString((String)"\u6e20\u9053\u4e91\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseServiceImpl_8", (String)"bos-mservice-license", (Object[])new Object[0]));
        groupInfo.put("11", ResManager.loadKDString((String)"\u6d41\u7a0b\u670d\u52a1\u4e91\u5206\u7ec4", (String)"LicenseServiceImpl_9", (String)"bos-mservice-license", (Object[])new Object[0]));
        groupInfo.put("12", ResManager.loadKDString((String)"\u6570\u636e\u670d\u52a1\u4e91\u5206\u7ec4", (String)"LicenseServiceImpl_10", (String)"bos-mservice-license", (Object[])new Object[0]));
        groupInfo.put("13", ResManager.loadKDString((String)"\u5f00\u53d1\u670d\u52a1\u8fd0\u884c\u65f6\u72ec\u7acb\u7248\u5206\u7ec4", (String)"LicenseServiceImpl_11", (String)"bos-mservice-license", (Object[])new Object[0]));
        groupInfo.put("14", ResManager.loadKDString((String)"\u94f6\u4f01\u670d\u52a1\u5206\u7ec4", (String)"LicenseServiceImpl_12", (String)"bos-mservice-license", (Object[])new Object[0]));
        groupInfo.put("15", ResManager.loadKDString((String)"\u8eab\u4efd\u8ba4\u8bc1\u5206\u7ec4", (String)"LicenseServiceImpl_13", (String)"bos-mservice-license", (Object[])new Object[0]));
        groupInfo.put("16", ResManager.loadKDString((String)"\u77ed\u4fe1\u670d\u52a1\u5206\u7ec4", (String)"LicenseServiceImpl_14", (String)"bos-mservice-license", (Object[])new Object[0]));
        groupInfo.put("17", ResManager.loadKDString((String)"\u5730\u4ea7\u9879\u76ee\u4e91\u901a\u7528\u7528\u6237\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseServiceImpl_15", (String)"bos-mservice-license", (Object[])new Object[0]));
        groupInfo.put("18", ResManager.loadKDString((String)"\u5efa\u7b51\u9879\u76ee\u4e91\u901a\u7528\u7528\u6237\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseServiceImpl_85", (String)"bos-mservice-license", (Object[])new Object[0]));
        groupInfo.put("19", ResManager.loadKDString((String)"\u5730\u4ea7\u4f9b\u5e94\u5546\u95e8\u6237\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseServiceImpl_17", (String)"bos-mservice-license", (Object[])new Object[0]));
        groupInfo.put("20", ResManager.loadKDString((String)"\u5458\u5de5HR\u670d\u52a1\u5168\u5458\u5e94\u7528\u5206\u7ec4", (String)"LicenseServiceImpl_18", (String)"bos-mservice-license", (Object[])new Object[0]));
        groupInfo.put("21", ResManager.loadKDString((String)"AI\u8d22\u52a1\u670d\u52a1\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseServiceImpl_19", (String)"bos-mservice-license", (Object[])new Object[0]));
        groupInfo.put("22", ResManager.loadKDString((String)"\u8d44\u91d1\u4e91\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseServiceImpl_20", (String)"bos-mservice-license", (Object[])new Object[0]));
        groupInfo.put("23", ResManager.loadKDString((String)"\u4f01\u4e1a\u7ee9\u6548\u4e91\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseServiceImpl_21", (String)"bos-mservice-license", (Object[])new Object[0]));
        groupInfo.put("24", ResManager.loadKDString((String)"\u9884\u7b97\u63a7\u5236\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseServiceImpl_22", (String)"bos-mservice-license", (Object[])new Object[0]));
        groupInfo.put("25", ResManager.loadKDString((String)"\u4f9b\u5e94\u94fe\u4e91\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseServiceImpl_23", (String)"bos-mservice-license", (Object[])new Object[0]));
        groupInfo.put("26", ResManager.loadKDString((String)"\u8fde\u63a5\u4eac\u4e1c\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseServiceImpl_24", (String)"bos-mservice-license", (Object[])new Object[0]));
        groupInfo.put("27", ResManager.loadKDString((String)"\u91c7\u8d2d\u5546\u57ce\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseServiceImpl_25", (String)"bos-mservice-license", (Object[])new Object[0]));
        groupInfo.put("28", ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u95e8\u6237\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseServiceImpl_26", (String)"bos-mservice-license", (Object[])new Object[0]));
        groupInfo.put("29", ResManager.loadKDString((String)"\u4fc3\u9500\u7ba1\u7406\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseServiceImpl_27", (String)"bos-mservice-license", (Object[])new Object[0]));
        groupInfo.put("30", ResManager.loadKDString((String)"\u8fd4\u5229\u7ba1\u7406\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseServiceImpl_28", (String)"bos-mservice-license", (Object[])new Object[0]));
        groupInfo.put("31", ResManager.loadKDString((String)"\u6838\u5fc3\u4eba\u529b\u4e91\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseServiceImpl_29", (String)"bos-mservice-license", (Object[])new Object[0]));
        groupInfo.put("32", ResManager.loadKDString((String)"\u73a9\u7f8e\u5165\u804c\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseServiceImpl_30", (String)"bos-mservice-license", (Object[])new Object[0]));
        groupInfo.put("33", ResManager.loadKDString((String)"\u85aa\u916c\u798f\u5229\u4e91\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseServiceImpl_31", (String)"bos-mservice-license", (Object[])new Object[0]));
        groupInfo.put("34", ResManager.loadKDString((String)"\u57fa\u7840\u7a0e\u52a1\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseServiceImpl_32", (String)"bos-mservice-license", (Object[])new Object[0]));
        groupInfo.put("35", ResManager.loadKDString((String)"\u5c0f\u7a0e\u79cd\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseServiceImpl_33", (String)"bos-mservice-license", (Object[])new Object[0]));
        groupInfo.put("36", ResManager.loadKDString((String)"\u4e13\u4e1a\u7a0e\u52a1\u4f01\u4e1a\u6240\u5f97\u7a0e\u5206\u7ec4", (String)"LicenseServiceImpl_34", (String)"bos-mservice-license", (Object[])new Object[0]));
        groupInfo.put("37", ResManager.loadKDString((String)"\u4e13\u4e1a\u7a0e\u52a1\u98ce\u9669\u7ba1\u63a7\u5206\u7ec4", (String)"LicenseServiceImpl_35", (String)"bos-mservice-license", (Object[])new Object[0]));
        groupInfo.put("38", ResManager.loadKDString((String)"\u9879\u76ee\u4e91\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseServiceImpl_36", (String)"bos-mservice-license", (Object[])new Object[0]));
        groupInfo.put("39", ResManager.loadKDString((String)"\u5f00\u53d1\u670d\u52a1\u8fd0\u884c\u65f6\u878d\u5408\u7248\u5168\u5458\u5e94\u7528\u5206\u7ec4", (String)"LicenseServiceImpl_37", (String)"bos-mservice-license", (Object[])new Object[0]));
        groupInfo.put("40", ResManager.loadKDString((String)"\u5f00\u53d1\u670d\u52a1\u8fd0\u884c\u65f6\u878d\u5408\u7248\u4e13\u4e1a\u5e94\u7528\u5206\u7ec4", (String)"LicenseServiceImpl_38", (String)"bos-mservice-license", (Object[])new Object[0]));
        groupInfo.put("41", ResManager.loadKDString((String)"\u96c6\u6210\u670d\u52a1\u4e91\u5206\u7ec4", (String)"LicenseServiceImpl_39", (String)"bos-mservice-license", (Object[])new Object[0]));
        groupInfo.put("42", ResManager.loadKDString((String)"\u82f1\u6587\u8bed\u8a00\u5305\u5206\u7ec4", (String)"LicenseServiceImpl_40", (String)"bos-mservice-license", (Object[])new Object[0]));
        groupInfo.put("43", ResManager.loadKDString((String)"\u7e41\u4f53\u8bed\u8a00\u5305\u5206\u7ec4", (String)"LicenseServiceImpl_41", (String)"bos-mservice-license", (Object[])new Object[0]));
        groupInfo.put("44", ResManager.loadKDString((String)"\u4f9b\u5e94\u94fe\u591a\u7ec4\u7ec7\u6279\u91cf\u5904\u7406\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseServiceImpl_42", (String)"bos-mservice-license", (Object[])new Object[0]));
        groupInfo.put("186", ResManager.loadKDString((String)"\u6ce8\u518c\u7528\u6237\u4fe1\u606f\u7531\u4ea7\u54c1\u7aef\u5b9a\u671f\u4e0a\u4f20\u5206\u7ec4", (String)"LicenseServiceImpl_81", (String)"bos-mservice-license", (Object[])new Object[0]));
        groupInfo.put("187", ResManager.loadKDString((String)"\u6ce8\u518c\u7528\u6237\u4fe1\u606f\u4e0d\u4e0a\u4f20\u5206\u7ec4", (String)"LicenseServiceImpl_79", (String)"bos-mservice-license", (Object[])new Object[0]));
        groupInfo.put("96", ResManager.loadKDString((String)"\u4f1a\u8ba1\u7535\u5b50\u6863\u6848\u5f52\u6863\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseServiceImpl_86", (String)"bos-mservice-license", (Object[])new Object[0]));
        groupInfo.put("87", ResManager.loadKDString((String)"\u5176\u4ed6\u7a0e\u79cd\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseServiceImpl_87", (String)"bos-mservice-license", (Object[])new Object[0]));
        groupInfo.put("88", ResManager.loadKDString((String)"\u7a0e\u52a1\u7ba1\u63a7\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseServiceImpl_88", (String)"bos-mservice-license", (Object[])new Object[0]));
        groupInfo.put("89", ResManager.loadKDString((String)"\u8d44\u91d1\u4e91\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseServiceImpl_20", (String)"bos-mservice-license", (Object[])new Object[0]));
        groupInfo.put("93", ResManager.loadKDString((String)"\u8de8\u5883\u94f6\u4f01\u652f\u4ed8\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseServiceImpl_89", (String)"bos-mservice-license", (Object[])new Object[0]));
        groupInfo.put("94", ResManager.loadKDString((String)"\u8d44\u91d1\u4e91\u591a\u7ec4\u7ec7\u6279\u91cf\u5904\u7406\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseServiceImpl_90", (String)"bos-mservice-license", (Object[])new Object[0]));
        groupInfo.put("99", ResManager.loadKDString((String)"\u8425\u9500\u8d39\u7528\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseServiceImpl_91", (String)"bos-mservice-license", (Object[])new Object[0]));
        groupInfo.put("66", ResManager.loadKDString((String)"\u5efa\u7b51\u62db\u6807\u7ba1\u7406\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseServiceImpl_92", (String)"bos-mservice-license", (Object[])new Object[0]));
        groupInfo.put("67", ResManager.loadKDString((String)"\u5efa\u7b51\u4f9b\u5e94\u5546\u95e8\u6237\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseServiceImpl_93", (String)"bos-mservice-license", (Object[])new Object[0]));
        groupInfo.put("68", ResManager.loadKDString((String)"\u667a\u80fd\u6570\u636e\u6d1e\u5bdf\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseServiceImpl_94", (String)"bos-mservice-license", (Object[])new Object[0]));
        groupInfo.put("48", ResManager.loadKDString((String)"\u5f00\u53d1\u670d\u52a1\u8fd0\u884c\u65f6\u878d\u5408\u7248\u5916\u90e8\u5e94\u7528\u5206\u7ec4", (String)"LicenseServiceImpl_95", (String)"bos-mservice-license", (Object[])new Object[0]));
        groupInfo.put("58", ResManager.loadKDString((String)"\u5bf9\u8bdd\u673a\u5668\u4eba\u5e73\u53f0\u5206\u7ec4", (String)"LicenseServiceImpl_96", (String)"bos-mservice-license", (Object[])new Object[0]));
        groupInfo.put("59", ResManager.loadKDString((String)"\u5bf9\u8bdd\u673a\u5668\u4eba\u5e73\u53f0\u8fd0\u884c\u65f6\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseServiceImpl_97", (String)"bos-mservice-license", (Object[])new Object[0]));
        groupInfo.put("60", ResManager.loadKDString((String)"\u82f1\u6587\u8bed\u8a00\u5305", (String)"LicenseServiceImpl_98", (String)"bos-mservice-license", (Object[])new Object[0]));
        groupInfo.put("61", ResManager.loadKDString((String)"\u7e41\u4f53\u8bed\u8a00\u5305", (String)"LicenseServiceImpl_99", (String)"bos-mservice-license", (Object[])new Object[0]));
        groupInfo.put("101", ResManager.loadKDString((String)"\u5ba1\u8ba1\u6587\u4ef6\u5bfc\u51fa\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseServiceImpl_100", (String)"bos-mservice-license", (Object[])new Object[0]));
        groupInfo.put("102", ResManager.loadKDString((String)"\u65b0\u79df\u8d41\u51c6\u5219\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseServiceImpl_101", (String)"bos-mservice-license", (Object[])new Object[0]));
        groupInfo.put("104", ResManager.loadKDString((String)"\u7ba1\u7406\u4f1a\u8ba1\u4e91\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseServiceImpl_102", (String)"bos-mservice-license", (Object[])new Object[0]));
        groupInfo.put("106", ResManager.loadKDString((String)"\u7535\u5b50\u56de\u5355\u670d\u52a1\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseServiceImpl_103", (String)"bos-mservice-license", (Object[])new Object[0]));
        groupInfo.put("111", ResManager.loadKDString((String)"\u751f\u4ea7\u5236\u9020\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseServiceImpl_104", (String)"bos-mservice-license", (Object[])new Object[0]));
        groupInfo.put("116", ResManager.loadKDString((String)"\u8f66\u95f4\u6267\u884c\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseServiceImpl_105", (String)"bos-mservice-license", (Object[])new Object[0]));
        groupInfo.put("121", ResManager.loadKDString((String)"\u5730\u4ea7\u62db\u6807\u667a\u80fd\u6e05\u5355\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseServiceImpl_106", (String)"bos-mservice-license", (Object[])new Object[0]));
        groupInfo.put("122", ResManager.loadKDString((String)"\u5730\u4ea7\u5408\u540c\u667a\u80fd\u6e05\u5355\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseServiceImpl_107", (String)"bos-mservice-license", (Object[])new Object[0]));
        groupInfo.put("123", ResManager.loadKDString((String)"\u5730\u4ea7\u6750\u6599\u516c\u53f8\u91c7\u8d2d\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseServiceImpl_108", (String)"bos-mservice-license", (Object[])new Object[0]));
        groupInfo.put("124", ResManager.loadKDString((String)"\u5730\u4ea7\u4f9b\u5e94\u5546\u5fae\u95e8\u6237\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseServiceImpl_109", (String)"bos-mservice-license", (Object[])new Object[0]));
        groupInfo.put("126", ResManager.loadKDString((String)"\u89c6\u89c9\u8bc6\u522b\u670d\u52a1\u5206\u7ec4", (String)"LicenseServiceImpl_110", (String)"bos-mservice-license", (Object[])new Object[0]));
        groupInfo.put("127", ResManager.loadKDString((String)"\u89c6\u89c9\u8bc6\u522b\u670d\u52a1\u8fd0\u884c\u65f6\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseServiceImpl_111", (String)"bos-mservice-license", (Object[])new Object[0]));
        return groupInfo;
    }

    public Boolean isUserActived(Long userID) {
        Boolean isUserActived = false;
        DynamicObject loadSingle = BusinessDataServiceHelper.loadSingle((Object)userID, (String)ENTITY_BOS_USER);
        isUserActived = loadSingle.getBoolean("isactived");
        return isUserActived;
    }

    public LicenseCheckResult checkUserInGroup(Long userID, Long groupID) {
        Map licenseGroup;
        LicenseCheckResult checkResult = new LicenseCheckResult();
        String productversion = this.getProductVersion();
        if ("1.0".equals(productversion) && this.getModeType() != 2 && this.getModeType() != 4 && Long.compare(groupID, 10000L) <= 0 && !(licenseGroup = LicenseGroupUtil.getLicenseGroup(null)).containsKey(String.valueOf(groupID))) {
            return new LicenseCheckResult(Boolean.valueOf(true), "");
        }
        Boolean hasLicense = false;
        if (userID == null) {
            checkResult.setHasLicense(hasLicense);
            checkResult.setMsg(ResManager.loadKDString((String)"\u7528\u6237ID\u4e3a\u7a7a\u3002", (String)"LicenseServiceImpl_121", (String)"bos-mservice-license", (Object[])new Object[0]));
            return checkResult;
        }
        if (this.isLicenseGroupUDD(groupID)) {
            hasLicense = true;
        } else {
            ArrayList<Long> groupIds = new ArrayList<Long>(1);
            groupIds.add(groupID);
            Set userLicenseGroups = LicenseCache.getUserLicenseGroups((Long)userID, groupIds);
            if (userLicenseGroups != null && userLicenseGroups.contains(groupID.toString())) {
                hasLicense = true;
            } else {
                Map licenseGroup2 = LicenseGroupUtil.getLicenseGroup((String)SYNCSTATUS);
                if (licenseGroup2.containsKey(String.valueOf(groupID))) {
                    hasLicense = true;
                }
            }
        }
        if (hasLicense.booleanValue()) {
            checkResult = this.checkGroupEffective(groupID);
        } else {
            checkResult.setMsg(String.format(ResManager.loadKDString((String)"\u6ca1\u6709\u201c%1$s\u201d\u8bb8\u53ef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"LicenseServiceImpl_144", (String)"bos-mservice-license", (Object[])new Object[0]), this.getGroupName(groupID + "")));
        }
        logger.info("LicenseServiceImpl.checkUserInGroup:userID={},groupID={},hasLicense={},msg={}", new Object[]{userID, groupID, checkResult.getHasLicense(), checkResult.getMsg()});
        return checkResult;
    }

    public LicenseCheckResult checkUserInGroup(Long userID, Long groupID, String bizAppId, String entityTypeId, boolean writeCheckLog) {
        Map licenseGroup;
        String groupName = this.getGroupName(String.valueOf(groupID));
        LicenseCheckResult checkResult = new LicenseCheckResult();
        String productversion = this.getProductVersion();
        if ("1.0".equals(productversion) && this.getModeType() != 2 && this.getModeType() != 4 && Long.compare(groupID, 10000L) <= 0 && !(licenseGroup = LicenseGroupUtil.getLicenseGroup(null)).containsKey(String.valueOf(groupID))) {
            return new LicenseCheckResult(Boolean.valueOf(true), "");
        }
        Boolean hasLicense = false;
        if (userID == null) {
            checkResult.setHasLicense(Boolean.valueOf(false));
            checkResult.setMsg(ResManager.loadKDString((String)"\u7528\u6237ID\u4e3a\u7a7a\u3002", (String)"LicenseServiceImpl_121", (String)"bos-mservice-license", (Object[])new Object[0]));
            return checkResult;
        }
        Date expdate = LicenseCache.getExpireDateByGroup((Long)groupID);
        Date beginDate = LicenseCache.getBeginDateByGroup((Long)groupID);
        if (beginDate == null || expdate == null) {
            this.addLicenseCheckLog(bizAppId, entityTypeId, true, String.format(ResManager.loadKDString((String)"\u79df\u6237\u672a\u8d2d\u4e70\u201c%s\u201d\u8bb8\u53ef\u3002", (String)"LicenseServiceImpl_152", (String)"bos-mservice-license", (Object[])new Object[0]), groupName), "info");
            checkResult.setHasLicense(Boolean.valueOf(false));
            checkResult.setMsg(String.format(ResManager.loadKDString((String)"\u6ca1\u6709\u201c%1$s\u201d\u8bb8\u53ef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"LicenseServiceImpl_144", (String)"bos-mservice-license", (Object[])new Object[0]), groupName));
            return checkResult;
        }
        if (this.isLicenseGroupUDD(groupID)) {
            hasLicense = true;
        } else {
            ArrayList<Long> groupIds = new ArrayList<Long>(1);
            groupIds.add(groupID);
            Set userLicenseGroups = LicenseCache.getUserLicenseGroups((Long)userID, groupIds);
            if (userLicenseGroups != null && userLicenseGroups.contains(groupID.toString())) {
                hasLicense = true;
            } else {
                Map licenseGroup2 = LicenseGroupUtil.getLicenseGroup((String)SYNCSTATUS);
                if (licenseGroup2.containsKey(String.valueOf(groupID))) {
                    hasLicense = true;
                }
            }
        }
        if (hasLicense.booleanValue()) {
            checkResult = this.checkGroupEffective(groupID, groupName, bizAppId, entityTypeId, beginDate, expdate);
        } else {
            this.addLicenseCheckLog(bizAppId, entityTypeId, writeCheckLog, String.format(ResManager.loadKDString((String)"\u7528\u6237\u9700\u8981\u5206\u914d\u201c%s\u201d\u8bb8\u53ef\u5206\u7ec4\u3002", (String)"LicenseServiceImpl_153", (String)"bos-mservice-license", (Object[])new Object[0]), groupName), "info");
            String message = String.format(ResManager.loadKDString((String)"\u6ca1\u6709\u201c%1$s\u201d\u8bb8\u53ef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"LicenseServiceImpl_144", (String)"bos-mservice-license", (Object[])new Object[0]), groupName);
            checkResult.setMsg(message);
        }
        logger.debug("LicenseServiceImpl.checkUserInGroup:userID={},groupID={},hasLicense={},msg={}", new Object[]{userID, groupID, checkResult.getHasLicense(), checkResult.getMsg()});
        return checkResult;
    }

    private String getGroupName(String groupID) {
        String productversion;
        if ("13".equals(groupID) && ("1.0".equals(productversion = this.getProductVersion()) || "1.5".equals(productversion) || "0.1".equals(productversion))) {
            return ResManager.loadKDString((String)"\u5f00\u53d1\u670d\u52a1\u4e91\u5206\u7ec4", (String)"LicenseServiceImpl_46", (String)"bos-mservice-license", (Object[])new Object[0]);
        }
        String groupName = (String)LicenseGroupUtil.getLicenseGroup(null).get(groupID);
        if (StringUtils.isBlank((CharSequence)groupName)) {
            DynamicObject[] load = BusinessDataServiceHelper.load((String)"lic_group", (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(groupID))});
            groupName = load != null && load.length > 0 ? load[0].getLocaleString("name").getLocaleValue() : ResManager.loadKDString((String)"\u5206\u7ec4", (String)"LicenseServiceImpl_47", (String)"bos-mservice-license", (Object[])new Object[0]);
        }
        return groupName;
    }

    public String getProductVersion() {
        Map<String, String> productInfo = this.getProductInfo();
        int modeType = this.getModeType();
        boolean isXk = false;
        if (2 == modeType || 4 == modeType) {
            isXk = true;
        }
        if (productInfo == null) {
            return isXk ? "2.1" : "7.0";
        }
        String productversion = productInfo.get("productversion");
        if (productversion == null) {
            return isXk ? "2.1" : "7.0";
        }
        switch (productversion) {
            case "0.1": 
            case "1.0": 
            case "1.5": {
                productversion = "1.0";
                break;
            }
            default: {
                return productversion;
            }
        }
        return productversion;
    }

    public Long getGroupByHomeCard(String cardID) {
        return 0L;
    }

    public Long getGroupByAppCard(String cardID) {
        return 0L;
    }

    public Long getGroupByMenu(String menuID) {
        return 0L;
    }

    public void addLog(RegisterUserLog regUserLog) {
        if (null == regUserLog) {
            return;
        }
        try {
            DynamicObject appLogObj = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_REGUSER_LOG);
            logger.info("opname:" + regUserLog.getOptName() + "," + PROPERTY_OP_DESCRIPTION + ":" + regUserLog.getOpDescription() + "," + PROPERTY_OP_TIME + ":" + regUserLog.getOpTime() + "," + PROPERTY_USER + ":" + regUserLog.getUserID());
            appLogObj.set(PROPERTY_OP_NAME, (Object)regUserLog.getOptName());
            appLogObj.set(PROPERTY_OP_DESCRIPTION, (Object)regUserLog.getOpDescription());
            appLogObj.set(PROPERTY_OP_TIME, (Object)regUserLog.getOpTime());
            appLogObj.set(PROPERTY_USER, (Object)regUserLog.getUserID());
            DynamicObject[] dataEntities = new DynamicObject[]{appLogObj};
            SaveServiceHelper.save((DynamicObject[])dataEntities);
        }
        catch (Exception e) {
            logger.error("LicenseServiceHelper.addLog error.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLicSyncLog(LicenseSyncLog log) {
        if (null == log) {
            logger.info("LicenseServiceImpl: null LicenseSyncLog do not publish");
            return;
        }
        try {
            List detailLogs = log.getLogs();
            if (detailLogs == null || detailLogs.isEmpty()) {
                return;
            }
            try (MessagePublisher pub = MQFactory.get().createSimplePublisher(FMODEL_TYPE_BASE_FORM, "license_service");){
                pub.publish((Object)log);
            }
            logger.info("LicenseServiceImpl: publish a LicenseSyncLog to mq");
        }
        catch (Exception e) {
            logger.error("LicenseServiceImpl.addLicSyncLog error.", (Throwable)e);
        }
    }

    public LicenseCheckResult checkByAppAndBizObj(String bizAppID, String bizObjID, Long userID) {
        return this.checkByAppAndBizObj(bizAppID, bizObjID, userID, Boolean.FALSE, Boolean.TRUE);
    }

    private LicenseCheckResult checkByAppAndBizObj(String bizAppID, String bizObjID, Long userID, Boolean isIsvProd) {
        return this.checkByAppAndBizObj(bizAppID, bizObjID, userID, isIsvProd, Boolean.FALSE);
    }

    private LicenseCheckResult checkByAppAndBizObj(String bizAppID, String bizObjID, Long userID, Boolean isIsvProd, Boolean isBuildCancelFormShowParameter) {
        LicenseCheckResult licenseCheckResult;
        Float ver;
        LicenseCheckResult checkResult = new LicenseCheckResult();
        if (bizAppID == null || bizObjID == null) {
            checkResult.setHasLicense(Boolean.valueOf(false));
            checkResult.setMsg(ResManager.loadKDString((String)"\u9a8c\u8bc1\u4e0d\u901a\u8fc7\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (String)"LicenseServiceImpl_48", (String)"bos-mservice-license", (Object[])new Object[0]));
            return checkResult;
        }
        this.newLicenseCheckLogInThreadCache(bizAppID, bizObjID, userID);
        if (LicenseCache.isCircuitBreaker((String)"ctrl") && StringUtils.isBlank((CharSequence)LicenseConfigUtil.getRedisVersion((String)LicenseCacheMrg.getType4CtrlGroup()))) {
            checkResult.setHasLicense(Boolean.valueOf(false));
            checkResult.setMsg(ResManager.loadKDString((String)"\u8bb8\u53ef\u4fe1\u606f\u6709\u8bef\uff0c\u529f\u80fd\u6682\u65f6\u65e0\u6cd5\u4f7f\u7528\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"LicenseServiceImpl_165", (String)"bos-mservice-license", (Object[])new Object[0]));
            return checkResult;
        }
        LicenseGroupCtrl licenseGroupCtrl = LicenseCache.getLicenseGroupCtrl((String)bizAppID, (String)bizObjID);
        Set curVersionGroups = licenseGroupCtrl.getCurVersionGroups();
        Set latestVersionGroups = licenseGroupCtrl.getLatestVersionGroups();
        Set modules = licenseGroupCtrl.getModules();
        logger.info("LicenseServiceImpl.checkByAppAndBizObj:bizAppID={},bizObjID={},userID={},isIsvProd={},curVerGroupId={},latestVersionGroups={},modules={}", new Object[]{bizAppID, bizObjID, userID, isIsvProd, curVersionGroups, latestVersionGroups, modules});
        if (curVersionGroups.isEmpty() && latestVersionGroups.isEmpty()) {
            String appId = BizAppServiceHelp.getAppIdByFormNum((String)bizObjID);
            if (bizAppID.equals(appId)) {
                if (isIsvProd.booleanValue()) {
                    return this.checkStandardBOSRunTimeLicense(userID, bizAppID, bizObjID);
                }
                checkResult.setHasLicense(Boolean.valueOf(true));
                checkResult.setMsg(ResManager.loadKDString((String)"\u8be5\u5e94\u7528\u6ca1\u6709\u5206\u7ec4,\u9a8c\u8bc1\u901a\u8fc7", (String)"LicenseServiceImpl_49", (String)"bos-mservice-license", (Object[])new Object[0]));
                LicenseCheckResult licenseCheckResult2 = LicenseGrayServiceHelper.checkGrayLicense((String)bizObjID);
                if (null != licenseCheckResult2 && licenseCheckResult2.getHasLicense().booleanValue() || null == licenseCheckResult2) {
                    return checkResult;
                }
                return licenseCheckResult2;
            }
            return this.checkByAppAndBizObj(appId, bizObjID, userID, isIsvProd, isBuildCancelFormShowParameter);
        }
        String version = this.getProductVersion();
        String moduleName = null;
        if (modules != null && modules.size() > 0) {
            try {
                Map allLicenseModuleName = LicenseModuleUtil.getAllLicenseModuleName();
                StringBuilder moduleNameSB = new StringBuilder();
                HashSet<String> moduleNames = new HashSet<String>(modules.size());
                for (String module : modules) {
                    String name = (String)allLicenseModuleName.get(module);
                    if (StringUtils.isBlank((CharSequence)name)) continue;
                    if (moduleNameSB.length() > 0) {
                        moduleNameSB.append("/");
                    }
                    if (!moduleNames.add(name)) continue;
                    moduleNameSB.append(String.format("\u201c%s\u201d", name));
                }
                moduleName = moduleNameSB.toString();
                if (moduleNameSB.length() == 0) {
                    moduleName = LicenseServiceImpl.getAppName(bizAppID);
                }
            }
            catch (Exception e) {
                logger.error("getModuleNmae error.", (Throwable)e);
                moduleName = LicenseServiceImpl.getAppName(bizAppID);
            }
        } else {
            moduleName = LicenseServiceImpl.getAppName(bizAppID);
        }
        Map licenseGroupMap = LicenseGroupUtil.getLicenseGroup(null);
        Set licenseModules = LicenseCache.getLicenseModules();
        StringJoiner groupNameSJ = new StringJoiner("/");
        boolean isRegGroupCtrl = false;
        boolean isLatestVerCtrl = false;
        int modeType = this.getModeType();
        float moduleCtrlVer = 4.0f;
        String isv = null;
        DynamicObject formMeta = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_formmeta", (String)"number,isv", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)bizObjID)});
        if (formMeta != null && (ver = kingdeeISVMap.get(isv = formMeta.getString("isv"))) != null) {
            moduleCtrlVer = ver.floatValue();
        }
        HashSet groupIds = new HashSet(4);
        if (!curVersionGroups.isEmpty()) {
            groupIds.addAll(curVersionGroups);
        }
        if (!latestVersionGroups.isEmpty()) {
            groupIds.addAll(latestVersionGroups);
            isLatestVerCtrl = true;
        }
        ArrayList<Long> registerGroupIds = new ArrayList<Long>(groupIds.size());
        for (Long groupId : groupIds) {
            DynamicObject group = LicenseCache.getGroupByID((Long)groupId);
            String groupName = (String)licenseGroupMap.get(groupId.toString());
            if (StringUtils.isBlank((CharSequence)groupName)) {
                groupName = group.getString("name");
            }
            groupNameSJ.add(String.format("\u201c%s\u201d", groupName));
            Object type = group.get("type");
            if (SYNCSTATUS.equals(String.valueOf(type))) {
                checkResult = this.checkGroupEffective(groupId, groupName, bizAppID, bizObjID, null, null);
            } else {
                try {
                    isRegGroupCtrl = true;
                    checkResult = this.checkUserInGroup(userID, groupId, bizAppID, bizObjID, true);
                    registerGroupIds.add(groupId);
                    if (checkResult.getHasLicense().booleanValue()) {
                        if (!isIsvProd.booleanValue()) {
                            if (Float.parseFloat(version) >= moduleCtrlVer || modeType != 3) {
                                this.licenseModuleCheck(modules, licenseModules, checkResult, moduleName, bizAppID, bizObjID);
                            } else if (isLatestVerCtrl) {
                                checkResult.setHasLicense(Boolean.FALSE);
                                checkResult.setMsg(String.format(ResManager.loadKDString((String)"\u6ca1\u6709%1$s\u6a21\u5757\u8bb8\u53ef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"LicenseServiceImpl_145", (String)"bos-mservice-license", (Object[])new Object[0]), moduleName));
                            }
                        } else {
                            String type4IsvBizObjProd = LicenseCacheMrg.getType4IsvBizObjProd();
                            String prod = LicenseCacheMrg.getCache((String)type4IsvBizObjProd, (String)bizObjID);
                            if (LicenseCacheMrg.isData((String)prod)) {
                                String type4ModuleCtrlVersion = LicenseCacheMrg.getType4ModuleCtrlVersion();
                                String key = isv + "-" + prod;
                                String ver2 = LicenseCacheMrg.getCache((String)type4ModuleCtrlVersion, (String)key);
                                logger.info("type4ModuleCtrlVersion key " + key + " ver " + ver2);
                                if (LicenseCacheMrg.isData((String)ver2)) {
                                    moduleCtrlVer = Float.parseFloat(ver2);
                                    if (Float.parseFloat(version) >= moduleCtrlVer) {
                                        this.licenseModuleCheck(modules, licenseModules, checkResult, moduleName, bizAppID, bizObjID);
                                    }
                                }
                            }
                        }
                    }
                    if (!checkResult.getHasLicense().booleanValue()) {
                        LicenseServiceImpl.writeLog(bizAppID, bizObjID, checkResult.getMsg());
                    }
                }
                catch (NumberFormatException e) {
                    logger.error((Throwable)e);
                }
            }
            if (!checkResult.getHasLicense().booleanValue()) continue;
            checkResult.setGroupIDs(groupIds);
            return checkResult;
        }
        if (!this.anyGroupEffective(registerGroupIds) && null != (licenseCheckResult = LicenseGrayServiceHelper.checkGrayLicense((String)bizObjID)) && licenseCheckResult.getHasLicense().booleanValue()) {
            return licenseCheckResult;
        }
        checkResult.setHasLicense(Boolean.valueOf(false));
        String message = "";
        message = isRegGroupCtrl && (Float.parseFloat(version) >= moduleCtrlVer || modeType == 2 || modeType == 4 || isLatestVerCtrl) ? String.format(ResManager.loadKDString((String)"\u6ca1\u6709%1s\u4e2d%2s\u6a21\u5757\u8bb8\u53ef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"LicenseServiceImpl_114", (String)"bos-mservice-license", (Object[])new Object[0]), groupNameSJ.toString(), moduleName) : String.format(ResManager.loadKDString((String)"\u6ca1\u6709%1s\u8bb8\u53ef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"LicenseServiceImpl_115", (String)"bos-mservice-license", (Object[])new Object[0]), groupNameSJ.toString());
        checkResult.setMsg(message);
        checkResult.setGroupIDs(groupIds);
        if (isBuildCancelFormShowParameter.booleanValue() && LicenseUtil.showCheckLogForm()) {
            FormShowParameter licCheckLogShowParam = this.buildCancelFormShowParameter(bizAppID, bizObjID, checkResult, Boolean.FALSE);
            checkResult.setCancelFormShowParameter(licCheckLogShowParam.toString());
        }
        return checkResult;
    }

    private boolean anyGroupEffective(List<Long> registerGroupIds) {
        if (registerGroupIds.size() == 0) {
            return false;
        }
        logger.info("LicenseServiceImpl.anyGroupEffective registerGroupIds={}", registerGroupIds);
        for (Long registerGroupId : registerGroupIds) {
            LicenseCheckResult licenseCheckResult = this.checkGroupEffective(registerGroupId);
            if (!licenseCheckResult.getHasLicense().booleanValue()) continue;
            return true;
        }
        return false;
    }

    private static String getAppName(String bizAppID) {
        String appName = "";
        try {
            AppInfo appInfo = AppMetadataCache.getAppInfo((String)bizAppID);
            appName = appInfo.getName().getLocaleValue();
        }
        catch (Exception e) {
            logger.error("cannot find app which id is " + bizAppID, (Throwable)e);
        }
        return appName;
    }

    private void licenseModuleCheck(Set<String> ctrlModulesNumbers, Set<String> buyModulesNumbers, LicenseCheckResult checkResult, String moduleNames, String bizAppID, String bizObjID) {
        String msg;
        boolean hasBuyModule = false;
        boolean moduleValid = false;
        Date now = new Date();
        Map moduleNumber2Name = LicenseModuleUtil.getAllLicenseModuleName();
        for (String ctrlModuleNumber : ctrlModulesNumbers) {
            String moduleName = (String)moduleNumber2Name.get(ctrlModuleNumber);
            if (buyModulesNumbers.contains(ctrlModuleNumber)) {
                hasBuyModule = true;
                Map module2ValidDate = LicenseCache.getLicenseModuleValidDateCache();
                String msg2 = this.checkModuleValid(ctrlModuleNumber, moduleName, module2ValidDate, now);
                if (StringUtils.isBlank((CharSequence)msg2)) {
                    moduleValid = true;
                    break;
                }
                this.addLicenseCheckLog(bizAppID, bizObjID, true, msg2, "info");
                continue;
            }
            this.addLicenseCheckLog(bizAppID, bizObjID, true, String.format(ResManager.loadKDString((String)"\u6ca1\u6709\u8d2d\u4e70\u201c%1$s\u201d\u6a21\u5757\u8bb8\u53ef\u3002", (String)"LicenseServiceImpl_154", (String)"bos-mservice-license", (Object[])new Object[0]), moduleName), "info");
        }
        if (!hasBuyModule) {
            checkResult.setHasLicense(Boolean.FALSE);
            msg = String.format(ResManager.loadKDString((String)"\u6ca1\u6709%1$s\u6a21\u5757\u8bb8\u53ef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"LicenseServiceImpl_145", (String)"bos-mservice-license", (Object[])new Object[0]), moduleNames);
            checkResult.setMsg(msg);
            logger.info(msg);
            return;
        }
        if (!moduleValid) {
            checkResult.setHasLicense(Boolean.FALSE);
            msg = String.format(ResManager.loadKDString((String)"%1$s\u6a21\u5757\u8bb8\u53ef\u4e0d\u5728\u6709\u6548\u671f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"LicenseServiceImpl_147", (String)"bos-mservice-license", (Object[])new Object[0]), moduleNames);
            checkResult.setMsg(msg);
            logger.info(msg);
        }
    }

    private String checkModuleValid(String moduleNumber, String moduleName, Map<String, List<Date[]>> module2ValidDate, Date now) {
        List<Date[]> dates = module2ValidDate.get(moduleNumber.toUpperCase());
        if (CollectionUtils.isEmpty(dates)) {
            return String.format(ResManager.loadKDString((String)"\u6ca1\u6709\u8d2d\u4e70\u201c%1$s\u201d\u6a21\u5757\u8bb8\u53ef\u3002", (String)"LicenseServiceImpl_154", (String)"bos-mservice-license", (Object[])new Object[0]), moduleName);
        }
        for (Date[] date : dates) {
            Date beginDate = date[0];
            Date endDate = date[1];
            if (beginDate != null && endDate != null && beginDate.before(now) && endDate.after(now)) {
                return "";
            }
            if (beginDate != null && !beginDate.before(now)) {
                return String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u8bb8\u53ef\u6a21\u5757\u672a\u751f\u6548\u3002", (String)"LicenseServiceImpl_155", (String)"bos-mservice-license", (Object[])new Object[0]), moduleName);
            }
            if (endDate == null || endDate.after(now)) continue;
            return String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u8bb8\u53ef\u6a21\u5757\u5df2\u8fc7\u671f\u3002", (String)"LicenseServiceImpl_156", (String)"bos-mservice-license", (Object[])new Object[0]), moduleName);
        }
        return "";
    }

    private LicenseCheckResult checkGroupEffective(Long groupId) {
        LicenseCheckResult result = new LicenseCheckResult(Boolean.valueOf(false), String.format(ResManager.loadKDString((String)"\u6ca1\u6709\u201c%1$s\u201d\u8bb8\u53ef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"LicenseServiceImpl_144", (String)"bos-mservice-license", (Object[])new Object[0]), this.getGroupName(groupId.toString())));
        if (LicenseCache.isCircuitBreaker((String)"group")) {
            result.setHasLicense(Boolean.valueOf(false));
            result.setMsg(ResManager.loadKDString((String)"\u8bb8\u53ef\u4fe1\u606f\u6709\u8bef\uff0c\u529f\u80fd\u6682\u65f6\u65e0\u6cd5\u4f7f\u7528\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"LicenseServiceImpl_165", (String)"bos-mservice-license", (Object[])new Object[0]));
            return result;
        }
        Date expdate = LicenseCache.getExpireDateByGroup((Long)groupId);
        Date beginDate = LicenseCache.getBeginDateByGroup((Long)groupId);
        if (beginDate == null || expdate == null) {
            return result;
        }
        int totalNumber = this.getTotalNumber(groupId);
        Date now = new Date();
        if (expdate.after(now) && beginDate.before(now) && totalNumber > 0 && (!DevVerifyServiceHelper.isOEMEnv() || this.checkGroupLicFileEffective(groupId))) {
            result.setHasLicense(Boolean.valueOf(true));
            result.setMsg("");
        }
        logger.info("LicenseServiceImpl.checkGroupEffective:result={},msg={},groupid={},beginDate={},expdate={},current={},total={}", new Object[]{result.getHasLicense(), result.getMsg(), groupId, beginDate, expdate, now, totalNumber});
        return result;
    }

    private LicenseCheckResult checkGroupEffective(Long groupId, String groupName, String bizAppId, String entityTypeId, Date beginDate, Date expdate) {
        LicenseCheckResult result = new LicenseCheckResult(Boolean.valueOf(false), String.format(ResManager.loadKDString((String)"\u6ca1\u6709\u201c%1$s\u201d\u8bb8\u53ef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"LicenseServiceImpl_144", (String)"bos-mservice-license", (Object[])new Object[0]), groupName));
        if (beginDate == null || expdate == null) {
            beginDate = LicenseCache.getBeginDateByGroup((Long)groupId);
            expdate = LicenseCache.getExpireDateByGroup((Long)groupId);
        }
        if (beginDate == null || expdate == null) {
            this.addLicenseCheckLog(bizAppId, entityTypeId, true, String.format(ResManager.loadKDString((String)"\u79df\u6237\u672a\u8d2d\u4e70\u201c%s\u201d\u8bb8\u53ef\u3002", (String)"LicenseServiceImpl_152", (String)"bos-mservice-license", (Object[])new Object[0]), groupName), "info");
            return result;
        }
        int totalNumber = this.getTotalNumber(groupId);
        Date now = new Date();
        Boolean after = expdate.after(now);
        Boolean before = beginDate.before(now);
        if (expdate.after(now) && beginDate.before(now) && totalNumber > 0) {
            if (!DevVerifyServiceHelper.isOEMEnv() || this.checkGroupLicFileEffective(groupId)) {
                result.setHasLicense(Boolean.valueOf(true));
                result.setMsg("");
            }
        } else {
            String message = "";
            if (!after.booleanValue() && before.booleanValue()) {
                message = String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u8bb8\u53ef\u5df2\u8fc7\u671f\u3002", (String)"LicenseServiceImpl_158", (String)"bos-mservice-license", (Object[])new Object[0]), groupName);
            } else if (after.booleanValue() && !before.booleanValue()) {
                message = String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u8bb8\u53ef\u672a\u751f\u6548\u3002", (String)"LicenseServiceImpl_157", (String)"bos-mservice-license", (Object[])new Object[0]), groupName);
            }
            this.addLicenseCheckLog(bizAppId, entityTypeId, true, message, "info");
        }
        logger.info("LicenseServiceImpl.checkGroupEffective:result={},msg={},groupid={},beginDate={},expdate={},current={},total={}", new Object[]{result.getHasLicense(), result.getMsg(), groupId, beginDate, expdate, now, totalNumber});
        return result;
    }

    private boolean checkGroupLicFileEffective(Long groupId) {
        boolean res = false;
        if (groupId == null) {
            return res;
        }
        List prodIdBeginDateEndDates = LicenseCache.getGroupLicFileValidDateCache((Long)groupId);
        if (prodIdBeginDateEndDates == null || prodIdBeginDateEndDates.size() <= 0) {
            return res;
        }
        Date now = new Date();
        for (Object[] prodIdBeginDateEndDate : prodIdBeginDateEndDates) {
            Object beginDate = prodIdBeginDateEndDate[0];
            Object endDate = prodIdBeginDateEndDate[1];
            logger.info("LicenseServiceImpl.checkGroupLicFileEffective:groupId={},beginDate={},endDate={}", new Object[]{groupId, beginDate, endDate});
            if (beginDate == null || endDate == null || !((Date)beginDate).before(now) || !((Date)endDate).after(now)) continue;
            res = true;
            break;
        }
        return res;
    }

    public LicenseCheckResult checkPerformGroup(String groupNumber) {
        Map licenseGroup;
        String bizAppID = "virtuallyBizAppID";
        String bizObjID = "virtuallyBizObjID";
        this.newLicenseCheckLogInThreadCache("virtuallyBizAppID", "virtuallyBizObjID", RequestContext.get().getCurrUserId());
        QFilter groupNumberFilter = new QFilter("number", "=", (Object)groupNumber);
        QFilter[] filters = new QFilter[]{groupNumberFilter};
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"lic_group", (String)"id,name", (QFilter[])filters);
        if (dynamicObject == null) {
            logger.info("LicenseServiceImpl.checkPerformGroup:groupNumber=" + groupNumber);
            this.addLicenseCheckLog(bizAppID, bizObjID, true, String.format(ResManager.loadKDString((String)"\u79df\u6237\u672a\u8d2d\u4e70\u201c%s\u201d\u8bb8\u53ef\u3002", (String)"LicenseServiceImpl_152", (String)"bos-mservice-license", (Object[])new Object[0]), groupNumber), "info");
            LicenseCheckResult checkResult = new LicenseCheckResult(Boolean.valueOf(false), String.format(ResManager.loadKDString((String)"\u8bf7\u8d2d\u4e70%1$s\u8bb8\u53ef\u5206\u7ec4", (String)"LicenseServiceImpl_51", (String)"bos-mservice-license", (Object[])new Object[0]), groupNumber));
            FormShowParameter parameter = this.buildCancelFormShowParameter(bizAppID, bizObjID, checkResult, Boolean.FALSE);
            checkResult.setCancelFormShowParameter(parameter.toString());
            return checkResult;
        }
        Long groupId = dynamicObject.getLong("id");
        String groupName = dynamicObject.getString("name");
        String productversion = this.getProductVersion();
        if ("1.0".equals(productversion) && !(licenseGroup = LicenseGroupUtil.getLicenseGroup(null)).containsKey(String.valueOf(groupId))) {
            return new LicenseCheckResult(Boolean.valueOf(true), "");
        }
        LicenseCheckResult checkResult = this.checkGroupEffective(groupId, groupName, bizAppID, bizObjID, null, null);
        if (!checkResult.getHasLicense().booleanValue()) {
            FormShowParameter parameter = this.buildCancelFormShowParameter(bizAppID, bizObjID, checkResult, Boolean.FALSE);
            checkResult.setCancelFormShowParameter(parameter.toString());
        }
        return checkResult;
    }

    @Deprecated
    public LicenseCheckResult checkUserInBOSRunTimeGroup(Long userID) {
        logger.info("LicenseServiceImpl.checkUserInBOSRunTimeGroup:userID=" + userID);
        LicenseCheckResult result = new LicenseCheckResult(Boolean.valueOf(false), ResManager.loadKDString((String)"\u6ca1\u6709\u5f00\u53d1\u670d\u52a1\u4e91\u5206\u7ec4\u8bb8\u53ef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"LicenseServiceImpl_53", (String)"bos-mservice-license", (Object[])new Object[0]));
        String groupNumber = "CP_DEV";
        QFilter groupNumberFilter = new QFilter("number", "=", (Object)groupNumber);
        QFilter[] filters = new QFilter[]{groupNumberFilter};
        DynamicObject[] group = BusinessDataServiceHelper.load((String)"lic_group", (String)"id,type", (QFilter[])filters);
        if (group != null && group.length > 0) {
            try {
                Long groupID = Long.parseLong(group[0].getPkValue().toString());
                if (this.checkUserInGroup(userID, groupID).getHasLicense().booleanValue()) {
                    return this.checkGroupEffective(groupID);
                }
            }
            catch (NumberFormatException e) {
                logger.error((Throwable)e);
            }
        }
        return result;
    }

    public Map<String, String> getProductInfo() {
        List<Map<String, String>> productInfos = this.getProductInfos();
        if (productInfos == null || productInfos.isEmpty()) {
            return new HashMap<String, String>(0);
        }
        int modeType = this.getModeType();
        boolean isXk = false;
        if (2 == modeType || 4 == modeType) {
            isXk = true;
        }
        for (Map<String, String> map : productInfos) {
            String productId = map.get("prodid");
            String version = map.get("productversion");
            if (("1I6CUBKTC4GZ".equals(productId) || "1I6CUBKTC4GY".equals(productId) && LicenseUtil.compareVersion((String)version, (String)"6.0")) && !isXk) {
                return map;
            }
            if ("1I6COPY94UBO".equals(productId) && !isXk) {
                return map;
            }
            if (!"2D3=SA5XL/93".equals(productId) || !isXk) continue;
            return map;
        }
        return productInfos.get(0);
    }

    public List<Map<String, String>> getProductInfos() {
        ArrayList<Map<String, String>> productInfos = new ArrayList<Map<String, String>>(2);
        HashMap<String, String> productInfo = new HashMap<String, String>(16);
        String isMCStr = System.getProperty("isMC");
        boolean isMC = false;
        if (StringUtils.isNotBlank((CharSequence)isMCStr)) {
            try {
                isMC = Boolean.parseBoolean(isMCStr);
            }
            catch (Exception e) {
                logger.error("getProductInfo isMCStr = " + isMCStr);
            }
        }
        if (isMC) {
            productInfo.put("productversion", "0.1");
            productInfo.put("softwarename", "kingdee eas nextcloud");
            productInfos.add(productInfo);
            return productInfos;
        }
        Map loadFromCache = BusinessDataServiceHelper.loadFromCache((String)"lic_license", (String)"softwarename,type,prodinstcode,product,productno,softwarecode,expdate,productversion,prodid,scenetype", (QFilter[])new QFilter[]{new QFilter("industry", "=", (Object)"Standard")});
        for (Map.Entry entry : loadFromCache.entrySet()) {
            DynamicObject product;
            DynamicObject dynamicObject = (DynamicObject)entry.getValue();
            productInfo = new HashMap(16);
            productInfo.put("prodInstCode", dynamicObject.getString("prodinstcode"));
            String softwareName = dynamicObject.getString("softwarename");
            productInfo.put("softwarename", softwareName);
            productInfo.put("productID", dynamicObject.getString("product"));
            productInfo.put("productNo", dynamicObject.getString("productno"));
            productInfo.put("softwareCode", dynamicObject.getString("softwarecode"));
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            Date expDate = dynamicObject.getDate("expdate");
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(expDate);
            productInfo.put("expdate", sdf.format(dynamicObject.getDate("expdate")));
            if (calendar.get(1) < 2099) {
                productInfo.put("expdateDes", sdf.format(dynamicObject.getDate("expdate")));
            } else {
                productInfo.put("expdateDes", ResManager.loadKDString((String)"\u4e0d\u9650", (String)"LicenseServiceImpl_129", (String)"bos-mservice-license", (Object[])new Object[0]));
            }
            productInfo.put("type", dynamicObject.getString("type"));
            String prodVer = dynamicObject.getString("productversion");
            productInfo.put("productversion", prodVer);
            String productName = ResManager.loadKDString((String)"\u82cd\u7a79", (String)"LicenseServiceImpl_116", (String)"bos-mservice-license", (Object[])new Object[0]);
            if (softwareName.startsWith("kingdee eas nextcloud saas")) {
                productName = ResManager.loadKDString((String)"\u661f\u701a", (String)"LicenseServiceImpl_117", (String)"bos-mservice-license", (Object[])new Object[0]);
            }
            productInfo.put("productName", productName);
            String productId = "";
            if (softwareName.equals("kingdee cloud 5.0 for education")) {
                productId = "1I6COPY94UBO";
            }
            if ((product = dynamicObject.getDynamicObject("prodid")) != null) {
                productId = product.getPkValue().toString();
                productInfo.put("productTag", product.getString("producttag"));
            }
            productInfo.put("prodid", productId);
            productInfo.put("sceneType", dynamicObject.getString("scenetype"));
            productInfos.add(productInfo);
            if (!productId.equals("1I6COPY94UBO") || !(Float.parseFloat(prodVer) < 5.0f)) continue;
            HashMap<String, String> constellation = new HashMap<String, String>(productInfo.size());
            constellation.putAll(productInfo);
            constellation.put("prodid", "1I6CUBKTC4GY");
            constellation.put("productName", ResManager.loadKDString((String)"\u661f\u701a", (String)"LicenseServiceImpl_117", (String)"bos-mservice-license", (Object[])new Object[0]));
            productInfos.add(constellation);
        }
        return productInfos;
    }

    public boolean isCosmic() {
        boolean isSingleOrgManageMode = this.isSingleOrgManageMode();
        return !isSingleOrgManageMode;
    }

    public LicenseCheckResult checkGroup(String groupNumber) {
        return this.checkPerformGroup(groupNumber);
    }

    public LicenseCheckResult checkMutiOrgQuery(String bizAppID, String bizObjID, Long userID) {
        return this.checkGroup(GROUP_PRO_FSS);
    }

    public boolean checkEntityMaxData(String entityId) {
        String sql;
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)entityId);
        String tableName = type.getAlias();
        DBRoute route = new DBRoute(type.getDBRouteKey());
        Integer signText = (Integer)DB.query((DBRoute)route, (String)(sql = "select COUNT(1) from " + tableName), null, (ResultSetHandler)new ResultSetHandler<Integer>(){

            public Integer handle(ResultSet rs) throws Exception {
                Integer info = 0;
                if (rs.next()) {
                    info = rs.getInt(1);
                }
                return info;
            }
        });
        return signText > 500;
    }

    public void deleteUserLic(Set<Long> userIDs) {
        this.deletePubCloudUserLic(userIDs);
    }

    public void disposeDisableUserLic(Set<Long> userIDs) {
        if (CollectionUtils.isEmpty(userIDs)) {
            return;
        }
        boolean enableDeleteDisenableUserLic = LicenseServiceUtil.isEnableDeleteDisenableUserLic();
        if (enableDeleteDisenableUserLic) {
            this.deletePubCloudUserLic(userIDs);
        } else {
            try {
                DynamicObject[] userLicGroups;
                LicenseSyncLog log = new LicenseSyncLog();
                log.setPkId(Long.valueOf(DB.genGlobalLongId()));
                log.setOperation("syncChange");
                List logs = log.getLogs();
                String forbiddenReason = ResManager.loadKDString((String)"\u7528\u6237\u7684\u72b6\u6001\u4e3a\u201c\u7981\u7528\u201d\u3002", (String)"UpdateLicGroupUser_35", (String)"bos-license-business", (Object[])new Object[0]);
                String disableReason = ResManager.loadKDString((String)"\u4eba\u5458\u7684\u72b6\u6001\u4e3a\u201c\u7981\u7528\u201d\u3002", (String)"UpdateLicGroupUser_45", (String)"bos-license-business", (Object[])new Object[0]);
                DynamicObject[] userLicenseGroups = BusinessDataServiceHelper.load((String)ENTITY_LIC_USER_GROUP, (String)"user,group", (QFilter[])new QFilter(PROPERTY_USER, "in", userIDs).toArray());
                HashMap<Long, Integer> deleteUserLicMap = new HashMap<Long, Integer>(16);
                ArrayList<Object> disEnableIds = new ArrayList<Object>(userIDs.size());
                HashSet<Long> userIds = new HashSet<Long>(userIDs.size());
                for (DynamicObject userLicenseGroup : userLicenseGroups) {
                    DynamicObject group = userLicenseGroup.getDynamicObject("group");
                    DynamicObject user = userLicenseGroup.getDynamicObject(PROPERTY_USER);
                    if (group == null || user == null) continue;
                    boolean enable = user.getBoolean("enable");
                    disEnableIds.add(userLicenseGroup.getPkValue());
                    String groupId = group.getPkValue().toString();
                    Integer num = (Integer)deleteUserLicMap.get(Long.valueOf(groupId));
                    deleteUserLicMap.put(Long.valueOf(groupId), num != null ? num + 1 : 1);
                    if (!userIds.add(user.getLong("id"))) continue;
                    LicenseSyncDetailLog licenseSyncDetailLog = new LicenseSyncDetailLog();
                    licenseSyncDetailLog.setUser(user.getString(PROP_NAME));
                    licenseSyncDetailLog.setPhone(user.getString(PROP_PHONE));
                    licenseSyncDetailLog.setEmail(user.getString(PROP_EMAIL));
                    licenseSyncDetailLog.setLogType("3");
                    licenseSyncDetailLog.setOperation(ResManager.loadKDString((String)"\u8bb8\u53ef\u72b6\u6001\u53d8\u66f4", (String)"LicenseServiceImpl_142", (String)"bos-mservice-license", (Object[])new Object[0]));
                    licenseSyncDetailLog.setReason(enable ? forbiddenReason : disableReason);
                    licenseSyncDetailLog.setDescription(ResManager.loadKDString((String)"\u7981\u7528\u4eba\u5458\u81ea\u52a8\u91ca\u653e\u8bb8\u53ef", (String)"LicenseSnapshotEngine_10", (String)"bos-license-business", (Object[])new Object[0]));
                    licenseSyncDetailLog.setSuccess(false);
                    logs.add(licenseSyncDetailLog);
                }
                LicenseLogUtil.addLicSyncLog((LicenseSyncLog)log);
                if (!CollectionUtils.isEmpty(deleteUserLicMap)) {
                    this.updateLicenseDetail(deleteUserLicMap);
                }
                if (!CollectionUtils.isEmpty(disEnableIds)) {
                    SqlBuilder updateSql = new SqlBuilder().append("UPDATE T_LIC_USERLICENSEGROUP SET FSYNCSTATUS = '4',FSTATUS = '0', ", new Object[0]).append("fsynclogid = ", new Object[0]).append(String.valueOf(log.getPkId()), new Object[0]).append(",fassigntime = now() WHERE ", new Object[0]);
                    updateSql.appendIn("FID", disEnableIds);
                    DB.execute((DBRoute)DBRoute.base, (SqlBuilder)updateSql);
                }
                if ((userLicGroups = BusinessDataServiceHelper.load((String)ENTITY_LIC_USER_GROUP, (String)"user,group", (QFilter[])new QFilter(PROPERTY_USER, "in", userIDs).toArray())) == null || userLicGroups.length <= 0) {
                    return;
                }
                HashMap<Long, Set> groupUserMap = new HashMap<Long, Set>(16);
                for (DynamicObject userLicGroup : userLicGroups) {
                    groupUserMap.computeIfAbsent(userLicGroup.getLong("group_id"), k -> new HashSet()).add(userLicGroup.getLong("user_id"));
                }
                Map userIndexListBySet = UserIndexUtil.getUserIndexListBySet(userIDs);
                HashMap<Long, List> grouplicUserRelMap = new HashMap<Long, List>(groupUserMap.size());
                for (Map.Entry entry : groupUserMap.entrySet()) {
                    Long key = (Long)entry.getKey();
                    Set userPKs = (Set)entry.getValue();
                    for (Long userId : userPKs) {
                        UserIndex userIndex = (UserIndex)userIndexListBySet.get(userId);
                        if (userIndex == null || userIndex.getIndex() == 0) continue;
                        grouplicUserRelMap.computeIfAbsent(key, k -> new ArrayList()).add(userIndex.getIndex());
                    }
                }
                LicenseUserRelEngine.removeLicUserGroup(grouplicUserRelMap);
            }
            catch (Exception e) {
                logger.error(String.format("\u901a\u8fc7\u63a5\u53e3\u5220\u9664\u7528\u6237\u8bb8\u53ef\u5206\u7ec4\u5931\u8d25\uff0c\u53ef\u624b\u52a8\u5220\u9664\uff0c\u4eba\u5458id\u4e3a\uff1a%s", JSON.toJSONString(userIDs)), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deletePubCloudUserLic(Set<Long> userIds) {
        if (CollectionUtils.isEmpty(userIds)) {
            return;
        }
        boolean highAvailabilityMode = LicenseUtil.isHighAvailabilityMode();
        Long loginUserId = RequestContext.get().getCurrUserId();
        try (TXHandle tx = TX.required();){
            DynamicObject[] userLicGroups = BusinessDataServiceHelper.load((String)ENTITY_LIC_USER_GROUP, (String)"user,group", (QFilter[])new QFilter(PROPERTY_USER, "in", userIds).toArray());
            if (userLicGroups == null || userLicGroups.length <= 0) {
                return;
            }
            HashMap<Long, Set> groupUserMap = new HashMap<Long, Set>(16);
            for (DynamicObject userLicGroup : userLicGroups) {
                groupUserMap.computeIfAbsent(userLicGroup.getLong("group_id"), k -> new HashSet()).add(userLicGroup.getLong("user_id"));
            }
            DeleteServiceHelper.delete((String)ENTITY_LIC_USER_GROUP, (QFilter[])new QFilter[]{new QFilter(PROPERTY_USER, "in", userIds)});
            if (highAvailabilityMode) {
                HashMap<Long, Integer> userBitMapIndexMap = new HashMap<Long, Integer>(userIds.size());
                DynamicObjectCollection userBitMapIndexCol = QueryServiceHelper.query((String)ENTITY_USERBITMAPINDEX, (String)"id, bitmapindex", (QFilter[])new QFilter("id", "in", userIds).toArray());
                for (DynamicObject userBitMapIndex : userBitMapIndexCol) {
                    userBitMapIndexMap.put(userBitMapIndex.getLong("id"), userBitMapIndex.getInt("bitmapindex"));
                }
                HashMap<Long, List> grouplicUserRelMap = new HashMap<Long, List>(groupUserMap.size());
                for (Map.Entry entry : groupUserMap.entrySet()) {
                    Long key = (Long)entry.getKey();
                    Set userPKs = (Set)entry.getValue();
                    for (Long userId : userPKs) {
                        Integer index = (Integer)userBitMapIndexMap.get(userId);
                        if (index == null || index == 0) continue;
                        grouplicUserRelMap.computeIfAbsent(key, k -> new ArrayList()).add(index);
                    }
                }
                LicenseUserRelEngine.removeLicUserGroup(grouplicUserRelMap);
            }
            HashMap<Long, Integer> deleteUserLicMap = new HashMap<Long, Integer>(16);
            ArrayList<LicenseAssignLog> licenseAssignLogs = new ArrayList<LicenseAssignLog>(16);
            for (DynamicObject userLicGroup : userLicGroups) {
                DynamicObject group = userLicGroup.getDynamicObject("group");
                DynamicObject user = userLicGroup.getDynamicObject(PROPERTY_USER);
                if (group == null || user == null) continue;
                String groupId = group.getPkValue().toString();
                LicenseAssignLog licenseAssignLog = new LicenseAssignLog(TimeServiceHelper.now(), loginUserId, (Long)user.getPkValue(), ResManager.loadKDString((String)"\u8c03\u7528\u63a5\u53e3\u91ca\u653e\u8bb8\u53ef", (String)"LicenseServiceImpl_137", (String)"bos-mservice-license", (Object[])new Object[0]), 0, 1, Long.valueOf(Long.parseLong(groupId)), true);
                licenseAssignLogs.add(licenseAssignLog);
                Integer num = (Integer)deleteUserLicMap.get(Long.valueOf(groupId));
                deleteUserLicMap.put(Long.valueOf(groupId), num != null ? num + 1 : 1);
            }
            this.addAssignLogs(licenseAssignLogs);
            if (!deleteUserLicMap.isEmpty()) {
                this.updateLicenseDetail(deleteUserLicMap);
            }
        }
    }

    private void updateLicenseDetail(Map<Long, Integer> deleteUserLicMap) {
        String selectFields = "softwarename,productno,type,activedate,expdate,industry,productversion,lic_licensedetail.group,lic_licensedetail.totalcount,lic_licensedetail.assignedcount,lic_licensedetail.remaincount";
        DynamicObject[] licenses = BusinessDataServiceHelper.load((String)"lic_license", (String)selectFields, (QFilter[])new QFilter[0]);
        if (null == licenses) {
            return;
        }
        for (DynamicObject license : licenses) {
            DynamicObjectCollection licenseDetails = license.getDynamicObjectCollection("lic_licensedetail");
            for (DynamicObject licenseDetail : licenseDetails) {
                Long groupId;
                Integer deleteNum;
                DynamicObject group = licenseDetail.getDynamicObject("group");
                if (group == null || null == (deleteNum = deleteUserLicMap.get(groupId = Long.valueOf(group.getPkValue().toString())))) continue;
                int remainCount = licenseDetail.getInt("remaincount");
                int count = licenseDetail.getInt("totalcount");
                int newRemainCount = remainCount + deleteNum;
                licenseDetail.set("remaincount", (Object)Math.min(newRemainCount, count));
                int assignedCount = licenseDetail.getInt("assignedcount");
                int newAssignedCount = assignedCount - deleteNum;
                licenseDetail.set("assignedcount", (Object)Math.max(newAssignedCount, 0));
            }
        }
        SaveServiceHelper.save((DynamicObject[])licenses);
    }

    public void addUsers2LicGroupDif(Set<Long> userIDs) {
        if (userIDs == null) {
            return;
        }
        logger.info("addUsers2LicGroupDif size -> " + userIDs.size() + ", userIDs -> " + userIDs);
        userIDs.remove(1L);
        Map load = BusinessDataServiceHelper.loadFromCache((String)"lic_usergroupdif", (String)PROPERTY_USER, (QFilter[])new QFilter[]{new QFilter(PROPERTY_USER, "in", userIDs)});
        Map users = BusinessDataServiceHelper.loadFromCache((String)ENTITY_BOS_USER, (String)"fuid,phone", (QFilter[])new QFilter[]{new QFilter("id", "in", userIDs)});
        HashMap<Object, Long> userID2Uid = new HashMap<Object, Long>(userIDs.size());
        if (users != null) {
            for (DynamicObject user : users.values()) {
                Long uid = user.getLong("fuid");
                if ("0".equals(String.valueOf(uid))) continue;
                Long userID = user.getLong("id");
                userID2Uid.put(userID, uid);
            }
        }
        if (load != null && load.size() > 0) {
            for (DynamicObject dynamicObject : load.values()) {
                DynamicObject user = dynamicObject.getDynamicObject(PROPERTY_USER);
                if (user == null) continue;
                userIDs.remove(user.getPkValue());
            }
        }
        if (!userIDs.isEmpty()) {
            MainEntityType type = EntityMetadataCache.getDataEntityType((String)"lic_usergroupdif");
            Object[] dynamicObjects = new DynamicObject[userIDs.size()];
            int i = 0;
            for (Long userID : userIDs) {
                DynamicObject licGroupDif = new DynamicObject((DynamicObjectType)type);
                licGroupDif.set(PROPERTY_USER, (Object)userID);
                licGroupDif.set("uid", userID2Uid.get(userID));
                dynamicObjects[i++] = licGroupDif;
            }
            SaveServiceHelper.save((IDataEntityType)type, (Object[])dynamicObjects);
            logger.info("addUsers2LicGroupDif success : " + dynamicObjects.length);
        }
    }

    public List<Long> addUserListByGroupNum(String groupNumber, List<Long> userIds) {
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"lic_group", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)groupNumber)});
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            return new ArrayList<Long>();
        }
        Object groupId = dynamicObjects[0].getPkValue();
        return this.addUserListByGroupId(groupId, userIds);
    }

    public List<Long> addUserListByGroupId(Object groupId, List<Long> userIds) {
        return this.addUserListByGroupId(groupId, userIds, 100000L);
    }

    public List<Long> addUserListByGroupId(Object groupId, List<Long> userIds, Long legalPersonID) {
        return this.addUserListByGroupId(groupId, userIds, legalPersonID, 4);
    }

    public List<Long> addUserListByGroupId(Object groupId, List<Long> userIds, Long legalPersonID, int licenseFrom) {
        logger.info("groupId:" + groupId + ",userIds:" + userIds + ",orgId:" + legalPersonID + ",licenseFrom:" + licenseFrom);
        String groupIdStr = String.valueOf(groupId);
        Long groupIdL = null;
        try {
            groupIdL = Long.parseLong(groupIdStr);
        }
        catch (Exception e) {
            return Collections.EMPTY_LIST;
        }
        HashSet<Long> groupIdLs = new HashSet<Long>(1);
        groupIdLs.add(groupIdL);
        if (CollectionUtils.isEmpty(userIds)) {
            return new ArrayList<Long>(0);
        }
        HashSet<Long> userIdLs = new HashSet<Long>(userIds.size());
        for (Long userId : userIds) {
            userIdLs.add(userId);
        }
        List licenseErrors = UserLicGroupUtil.addUserGroupsById(userIdLs, groupIdLs, (Long)legalPersonID, (int)licenseFrom, (boolean)true);
        if (!CollectionUtils.isEmpty((Collection)licenseErrors)) {
            for (LicenseError licenseError : licenseErrors) {
                userIds.remove(licenseError.getId());
            }
        }
        return userIds;
    }

    private void updateLicDetail(Object groupId, int newAssignedCount) {
        String selectFields = "lic_licensedetail.group,lic_licensedetail.remaincount, lic_licensedetail.assignedcount, lic_licensedetail.totalcount";
        QFilter groupFilter = new QFilter("lic_licensedetail.group", "=", groupId);
        DynamicObject license = BusinessDataServiceHelper.loadSingle((String)"lic_license", (String)selectFields, (QFilter[])groupFilter.toArray());
        if (null == license) {
            return;
        }
        DynamicObjectCollection licDetails = license.getDynamicObjectCollection("lic_licensedetail");
        for (DynamicObject licDetail : licDetails) {
            if (!groupId.toString().equals(licDetail.getDynamicObject("group").getPkValue().toString())) continue;
            int assignedCount = licDetail.getInt("assignedcount");
            int remainCount = licDetail.getInt("remaincount");
            licDetail.set("assignedcount", (Object)(newAssignedCount + assignedCount));
            licDetail.set("remaincount", (Object)(remainCount - newAssignedCount));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{license});
            break;
        }
    }

    private int getRemainCount(Long groupId, boolean isPubCloud, Long legalPerson) {
        if (LicenseUtil.isHighAvailabilityMode()) {
            Map groupAssign = LicenseUserRelEngine.getLicAllocateNumberByGroupIds(Collections.singletonList(groupId));
            if (CollectionUtils.isEmpty((Map)groupAssign)) {
                return 0;
            }
            return LicenseServiceHelper.getTotalNumber((Object)groupId) - (Integer)groupAssign.get(groupId);
        }
        boolean enableLegalPersonAssign = LicenseServiceUtil.isEnableLegalPersonAssign();
        QFilter groupFilter = new QFilter("lic_licensedetail.group", "=", (Object)groupId);
        DynamicObject license = BusinessDataServiceHelper.loadSingle((String)"lic_license", (String)"lic_licensedetail.group,lic_licensedetail.remaincount", (QFilter[])groupFilter.toArray());
        if (null == license) {
            return 0;
        }
        int remain = 0;
        DynamicObjectCollection licDetails = license.getDynamicObjectCollection("lic_licensedetail");
        for (DynamicObject licDetail : licDetails) {
            DynamicObjectCollection userGroup;
            if (!groupId.toString().equals(licDetail.getDynamicObject("group").getPkValue().toString())) continue;
            remain = licDetail.getInt("remaincount");
            QFilter filter = new QFilter("group", "=", (Object)groupId);
            filter.and("syncstatus", "<>", (Object)"1");
            if (enableLegalPersonAssign) {
                DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"lic_legalassign", (String)"assignednum, usednum", (QFilter[])new QFilter("group", "=", (Object)groupId).and("org", "=", (Object)legalPerson).toArray());
                if (dynamicObject == null) {
                    return 0;
                }
                int assign = dynamicObject.getInt("assignednum");
                int used = dynamicObject.getInt("usednum");
                int last = assign - used;
                remain = Integer.min(remain, last);
                filter.and("org", "=", (Object)legalPerson);
            }
            if ((userGroup = QueryServiceHelper.query((String)ENTITY_LIC_USER_GROUP, (String)"id", (QFilter[])filter.toArray())) == null || userGroup.isEmpty()) continue;
            return remain - userGroup.size();
        }
        return remain;
    }

    public List<CloudUserInfo> getCloudUserInfo() {
        DynamicObject[] objects;
        DynamicObject[] dynamicObjectArray;
        LicenseSyncLog licenseSyncLog = new LicenseSyncLog();
        HashSet<String> prodInstCodes = new HashSet<String>(4);
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"lic_license", (String)"prodinstcode", null);
        if (load == null) {
            return Collections.emptyList();
        }
        for (DynamicObject dynamicObject : load) {
            prodInstCodes.add(dynamicObject.getString("prodinstcode"));
        }
        HashSet<Long> userIds = new HashSet<Long>(1024);
        HashSet<Long> toRemoveUid = new HashSet<Long>(16);
        DynamicObject[] needUpload = BusinessDataServiceHelper.load((String)ENTITY_LIC_USER_GROUP, (String)PROPERTY_USER, (QFilter[])new QFilter[]{new QFilter("syncstatus", "=", (Object)SYNCSTATUS)});
        if (needUpload != null && needUpload.length > 0) {
            for (DynamicObject dynamicObject : needUpload) {
                DynamicObject user = dynamicObject.getDynamicObject(PROPERTY_USER);
                if (user == null || !this.notInBlackList(user.getPkValue().toString())) continue;
                userIds.add(Long.parseLong(user.getPkValue().toString()));
            }
        }
        if ((dynamicObjectArray = BusinessDataServiceHelper.load((String)ENTITY_LIC_USER_GROUP, (String)PROPERTY_USER, (QFilter[])new QFilter[]{new QFilter("user.enable", "=", (Object)"0").or(new QFilter("user.isforbidden", "=", (Object)"1")), new QFilter("syncstatus", "in", (Object)new String[]{"1", SYNCSTATUS})})) != null && dynamicObjectArray.length > 0) {
            for (DynamicObject dynamicObject : dynamicObjectArray) {
                DynamicObject user = dynamicObject.getDynamicObject(PROPERTY_USER);
                if (user == null || !this.notInBlackList(user.getPkValue().toString())) continue;
                userIds.add(Long.parseLong(user.getPkValue().toString()));
            }
        }
        if ((objects = BusinessDataServiceHelper.load((String)"lic_usergroupdif", (String)"user,uid", null)) != null && objects.length > 0) {
            for (DynamicObject dynamicObject : objects) {
                DynamicObject user = dynamicObject.getDynamicObject(PROPERTY_USER);
                if (user == null) {
                    long uid = dynamicObject.getLong("uid");
                    if (uid == 0L) continue;
                    toRemoveUid.add(uid);
                    continue;
                }
                userIds.add(Long.parseLong(user.getPkValue().toString()));
            }
        }
        ArrayList<CloudUserInfo> cloudUsers = new ArrayList<CloudUserInfo>(1024);
        for (Long uid : toRemoveUid) {
            CloudUserInfo cloudUserInfo = new CloudUserInfo();
            cloudUserInfo.setIs_delete(1);
            cloudUserInfo.setStatus(0);
            cloudUserInfo.setUid(uid.longValue());
            DynamicObject[] instDetails = new ArrayList(2);
            for (String prodInstCode : prodInstCodes) {
                HashMap<String, String> detail = new HashMap<String, String>(2);
                detail.put("prod_inst_code", prodInstCode);
                detail.put("prod_group", "");
                instDetails.add(detail);
            }
            cloudUserInfo.setInstDetail((List)instDetails);
            cloudUsers.add(cloudUserInfo);
        }
        String selectField = "group.number, syncstatus, user.id, user.number, user.phone,user.usertype, user.birthday, user.email, user.name, user.enable, user.fuid, user.gender, user.username";
        DynamicObject[] userGroup = BusinessDataServiceHelper.load((String)ENTITY_LIC_USER_GROUP, (String)selectField, (QFilter[])new QFilter[]{new QFilter(PROPERTY_USER, "in", userIds)});
        HashMap<Long, Map<String, Object>> user2Group = new HashMap<Long, Map<String, Object>>();
        for (DynamicObject dynamicObject : userGroup) {
            DynamicObject group;
            DynamicObject user = dynamicObject.getDynamicObject(PROPERTY_USER);
            if (user == null || (group = dynamicObject.getDynamicObject("group")) == null) continue;
            Map<String, Object> map = new HashMap();
            String groupStr = null;
            if (user2Group.containsKey(user.getPkValue())) {
                map = (Map)user2Group.get(user.getPkValue());
                groupStr = map.get("group").toString() + ";";
            }
            if (groupStr == null) {
                groupStr = group.getString("number");
                userIds.remove(user.getPkValue());
            } else {
                groupStr = groupStr + group.getString("number");
            }
            map.put("group", groupStr);
            this.analysisDBUser(user2Group, user, map, licenseSyncLog);
            userIds.remove(Long.parseLong(user.getPkValue().toString()));
        }
        this.addCloudUserInfos(cloudUsers, user2Group, prodInstCodes);
        if (!userIds.isEmpty()) {
            Map<Long, Map<String, Object>> userInfo = this.getUserInfoFromDB(userIds, new HashMap<String, DynamicObject>(userIds.size()), licenseSyncLog);
            cloudUsers.addAll(LicenseServiceImpl.getCloudUser(userInfo, null, prodInstCodes));
        }
        return cloudUsers;
    }

    public List<CloudUserInfo> getCloudUserInfo(String prodInstCode) {
        DynamicObject[] objects;
        HashSet<Long> toRemoveUid = new HashSet<Long>();
        HashSet<Long> userIds = new HashSet<Long>();
        LicenseSyncLog licenseSyncLog = new LicenseSyncLog();
        DynamicObject[] needUpload = BusinessDataServiceHelper.load((String)ENTITY_LIC_USER_GROUP, (String)PROPERTY_USER, (QFilter[])new QFilter[]{new QFilter("syncstatus", "<>", (Object)"1")});
        if (needUpload != null && needUpload.length > 0) {
            for (DynamicObject dynamicObject : needUpload) {
                DynamicObject user = dynamicObject.getDynamicObject(PROPERTY_USER);
                if (user == null) continue;
                if (user.getBoolean("enable")) {
                    userIds.add(Long.parseLong(user.getPkValue() + ""));
                    continue;
                }
                String uid = user.getString("fuid");
                if ("0".equals(uid)) continue;
                toRemoveUid.add(Long.parseLong(uid));
            }
        }
        ArrayList<CloudUserInfo> cloudUsers = new ArrayList<CloudUserInfo>(16);
        for (DynamicObject dynamicObject : objects = BusinessDataServiceHelper.load((String)"lic_usergroupdif", (String)"user,uid", null)) {
            DynamicObject user = dynamicObject.getDynamicObject(PROPERTY_USER);
            if (user == null) continue;
            if (!user.getBoolean("enable") && dynamicObject.getLong("uid") != 0L) {
                toRemoveUid.add(dynamicObject.getLong("uid"));
                continue;
            }
            if (!this.notInBlackList(user.getPkValue().toString())) continue;
            userIds.add(Long.parseLong(user.getPkValue().toString()));
        }
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)ENTITY_BOS_USER, (String)"number,fuid,phone,birthday,email,name,gender,username,usertype", (QFilter[])new QFilter[]{new QFilter("fuid", "in", toRemoveUid)});
        List logs = licenseSyncLog.getLogs();
        for (DynamicObject user : dynamicObjects) {
            String pgender;
            String fuid;
            String username;
            DynamicObject[] cloudUserInfo = new CloudUserInfo();
            cloudUserInfo.setPhone(user.getString(PROP_PHONE));
            String mid = user.getString("number");
            if ("0".equals(mid)) {
                mid = user.getString(PROP_PHONE);
            }
            cloudUserInfo.setMid("");
            if (mid != null && mid.trim().length() > 0 && !"null".equals(mid)) {
                cloudUserInfo.setMid(mid);
            }
            cloudUserInfo.setBirthday("");
            try {
                Date birthday = user.getDate("birthday");
                if (birthday != null) {
                    String dateStr = String.valueOf(birthday.getTime());
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                    String baseDataString = sdf.format(Long.parseLong(dateStr));
                    cloudUserInfo.setBirthday(baseDataString);
                }
            }
            catch (Exception e) {
                logger.error("LicenseServiceImpl.getCloudUserInfo : e = " + e);
            }
            cloudUserInfo.setEmail("");
            if (StringUtils.isNotBlank((CharSequence)user.getString(PROP_EMAIL))) {
                cloudUserInfo.setEmail(user.getString(PROP_EMAIL));
            }
            if (StringUtils.isBlank((CharSequence)(username = user.getString(PROP_NAME))) && StringUtils.isBlank((CharSequence)(username = user.getString(PROP_PHONE)))) {
                username = user.getString(PROP_EMAIL);
            }
            cloudUserInfo.setErp_account(username);
            cloudUserInfo.setName("");
            String name = user.getLocaleString("name").getLocaleValue();
            if (name == null) {
                String strInfo = String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%1$s\u7684\u7528\u6237\u5728\u5f53\u524d\u8bed\u8a00(%2$s)\u4e0b\u6ca1\u6709\u540d\u79f0,\u6b64\u7528\u6237\u65e0\u6cd5\u540c\u6b65,\u8bf7\u4fee\u6539\u7528\u6237\u4fe1\u606f", (String)"LicenseServiceImpl_54", (String)"bos-mservice-license", (Object[])new Object[0]), user.getString("number"), RequestContext.get().getLang());
                logger.info("LicenseServiceImpl.getCloudUserInfo:" + strInfo);
                LicenseServiceHelper.addLog((String)this.UPLOAD_REG_USER, (String)strInfo);
                LicenseSyncDetailLog licenseSyncDetailLog = new LicenseSyncDetailLog();
                licenseSyncDetailLog.setLogType("1");
                licenseSyncDetailLog.setOperation(this.UPLOAD_REG_USER);
                licenseSyncDetailLog.setDescription(strInfo);
                licenseSyncDetailLog.setSuccess(false);
                logs.add(licenseSyncDetailLog);
                continue;
            }
            if (name != null && name.trim().length() > 0 && !"null".equals(name)) {
                cloudUserInfo.setName(name);
            }
            if ((fuid = user.getString("fuid")) != null && fuid.trim().length() > 0) {
                try {
                    long uidNum = Long.parseLong(fuid);
                    cloudUserInfo.setUid(uidNum);
                }
                catch (NumberFormatException e) {
                    cloudUserInfo.setUid(0L);
                }
            }
            int gender = "1".equalsIgnoreCase(pgender = user.getString("gender")) ? 0 : (SYNCSTATUS.equalsIgnoreCase(pgender) ? 1 : 0);
            cloudUserInfo.setGender(gender);
            cloudUserInfo.setIs_delete(1);
            cloudUserInfo.setStatus(0);
            cloudUserInfo.setDepartment("");
            cloudUserInfo.setIdno("");
            int removeNetWork = LicenseServiceImpl.getRemoveNetWork(user.getString("usertype"));
            cloudUserInfo.setIs_remove_network(removeNetWork);
            cloudUsers.add((CloudUserInfo)cloudUserInfo);
            if (StringUtils.isNotBlank((CharSequence)user.getString("fuid"))) {
                toRemoveUid.remove(Long.parseLong(user.getString("fuid")));
                continue;
            }
            if (!StringUtils.isNotBlank((CharSequence)user.getString(PROP_PHONE))) continue;
            try {
                toRemoveUid.remove(Long.parseLong(user.getString(PROP_PHONE)));
            }
            catch (NumberFormatException e) {
                logger.error("toRemoveUid.remove: number = " + user.getString("number"));
            }
        }
        this.addLicSyncLog(licenseSyncLog);
        for (Long uid : toRemoveUid) {
            CloudUserInfo cloudUserInfo = new CloudUserInfo();
            cloudUserInfo.setIs_delete(1);
            cloudUserInfo.setStatus(0);
            cloudUserInfo.setMid(uid + "");
            cloudUsers.add(cloudUserInfo);
        }
        Set<Long> curLicGroup = this.getCurLicGroup(prodInstCode);
        String selectField = "group.number, syncstatus, user.id, user.number, user.phone,user.usertype, user.birthday, user.email, user.name, user.enable, user.fuid, user.gender, user.username";
        DynamicObject[] userGroup = BusinessDataServiceHelper.load((String)ENTITY_LIC_USER_GROUP, (String)selectField, (QFilter[])new QFilter[]{new QFilter(PROPERTY_USER, "in", userIds)});
        HashMap<Long, Map<String, Object>> user2Group = new HashMap<Long, Map<String, Object>>();
        for (DynamicObject dynamicObject : userGroup) {
            DynamicObject group;
            DynamicObject user = dynamicObject.getDynamicObject(PROPERTY_USER);
            if (user == null || (group = dynamicObject.getDynamicObject("group")) == null || !curLicGroup.contains(group.getLong("id"))) continue;
            Map<String, Object> map = new HashMap();
            String groupStr = null;
            if (user2Group.containsKey(user.getPkValue())) {
                map = (Map)user2Group.get(user.getPkValue());
                groupStr = map.get("group").toString() + ";";
            }
            if (groupStr == null) {
                groupStr = group.getString("number");
                userIds.remove(user.getPkValue());
            } else {
                groupStr = groupStr + group.getString("number");
            }
            map.put("group", groupStr);
            this.analysisDBUser(user2Group, user, map, licenseSyncLog);
            userIds.remove(Long.parseLong(user.getPkValue().toString()));
        }
        this.addCloudUserInfos(cloudUsers, user2Group, Collections.singleton(prodInstCode));
        if (!userIds.isEmpty()) {
            Map<Long, Map<String, Object>> userInfo = this.getUserInfoFromDB(userIds, new HashMap<String, DynamicObject>(userIds.size()), licenseSyncLog);
            cloudUsers.addAll(LicenseServiceImpl.getCloudUser(userInfo, null, Collections.singleton(prodInstCode)));
        }
        return cloudUsers;
    }

    private Set<Long> getCurLicGroup(String prodInstCode) {
        String sql = "select ld.fgroupid groupid FROM t_lic_licensedetail ld INNER JOIN t_lic_license l ON l.fid = ld.fid WHERE l.fprodinstcode = '" + prodInstCode + "'";
        Set groupIds = (Set)DB.query((DBRoute)DBRoute.base, (String)sql, k -> {
            HashSet<Long> groupSet = new HashSet<Long>(16);
            while (k.next()) {
                groupSet.add(k.getLong("groupid"));
            }
            return groupSet;
        });
        return groupIds;
    }

    private boolean notInBlackList(String userId) {
        return !blackList.contains(userId);
    }

    private static List<CloudUserInfo> getCloudUser(Map<Long, Map<String, Object>> user2Group, Map<String, Map<String, ProductGroup>> userLicGroup, Set<String> prodInstCodes) {
        ArrayList<CloudUserInfo> cloudUsers = new ArrayList<CloudUserInfo>(user2Group.size());
        String sql = "select tll.fprodinstcode instcode, tlg.fnumber groupNum from t_lic_license tll inner join t_lic_licensedetail tlld on tll.fid = tlld.fid inner join t_lic_group tlg on tlld.fgroupid = tlg.fid ";
        Map groupInst = (Map)DB.query((DBRoute)DBRoute.base, (String)sql, k -> {
            HashMap<String, String> groupInstMap = new HashMap<String, String>(32);
            while (k.next()) {
                groupInstMap.put(k.getString("groupNum"), k.getString("instcode"));
            }
            return groupInstMap;
        });
        for (Map.Entry<Long, Map<String, Object>> entry : user2Group.entrySet()) {
            String[] groupArray;
            Map<String, ProductGroup> mpGroups;
            CloudUserInfo cloudUserInfo = new CloudUserInfo();
            Map<String, Object> map = entry.getValue();
            if (!map.containsKey(PROP_PHONE) || map.get(PROP_PHONE) == null) continue;
            cloudUserInfo.setPhone(map.get(PROP_PHONE).toString());
            if (!map.containsKey("number") || map.get("number") == null) continue;
            String mid = map.get("number").toString();
            cloudUserInfo.setMid("");
            if (!"0".equals(mid) && mid != null && mid.trim().length() > 0 && !"null".equals(mid)) {
                cloudUserInfo.setMid(mid);
            }
            Object birthday = map.get("birthday");
            cloudUserInfo.setBirthday("");
            if (birthday != null) {
                try {
                    String dateStr = String.valueOf(((Date)birthday).getTime());
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                    String baseDataString = sdf.format(Long.parseLong(dateStr));
                    cloudUserInfo.setBirthday(baseDataString);
                }
                catch (Exception e) {
                    logger.error("birthday:" + birthday);
                }
            }
            cloudUserInfo.setEmail("");
            if (!map.containsKey(PROP_EMAIL) || map.get(PROP_EMAIL) == null) continue;
            String email = map.get(PROP_EMAIL).toString();
            if (email != null && email.trim().length() > 0 && !"null".equals(email)) {
                cloudUserInfo.setEmail(email);
            }
            if (!map.containsKey(PROP_NAME) || map.get(PROP_NAME) == null) continue;
            String username = map.get(PROP_NAME).toString();
            if (StringUtils.isBlank((CharSequence)username) && StringUtils.isBlank((CharSequence)(username = map.get(PROP_PHONE).toString()))) {
                username = map.get(PROP_EMAIL).toString();
            }
            cloudUserInfo.setErp_account(username);
            cloudUserInfo.setName("");
            if (!map.containsKey("name") || map.get("name") == null) continue;
            String name = map.get("name").toString();
            if (name != null && name.trim().length() > 0 && !"null".equals(name)) {
                cloudUserInfo.setName(name);
            }
            if (!map.containsKey("isdisenable") || map.get("isdisenable") == null || !map.containsKey("isforbidden") || map.get("isforbidden") == null) continue;
            boolean forBidden = Boolean.parseBoolean(map.get("isforbidden").toString());
            boolean disenable = Boolean.parseBoolean(map.get("isdisenable").toString());
            cloudUserInfo.setStatus(forBidden ? 0 : 1);
            cloudUserInfo.setIs_delete(forBidden ? 1 : 0);
            cloudUserInfo.setProd_group("");
            if (!map.containsKey("group") && map.get("group") == null) continue;
            String groupStr = map.get("group").toString();
            if (!(groupStr == null || groupStr.trim().length() <= 0 || "null".equals(groupStr) || forBidden || disenable)) {
                cloudUserInfo.setProd_group(groupStr);
            }
            cloudUserInfo.setMpGroups(null);
            Map<String, ProductGroup> map2 = mpGroups = userLicGroup == null ? null : userLicGroup.get(entry.getKey().toString());
            if (mpGroups != null && !forBidden && !disenable) {
                cloudUserInfo.setMpGroups(mpGroups);
            }
            ArrayList instDetails = new ArrayList(2);
            HashMap<String, String> instCodeGroupStr = new HashMap<String, String>(4);
            if (!(groupStr == null || groupStr.trim().length() <= 0 || "null".equals(groupStr) || forBidden || disenable)) {
                for (String groupNum : groupArray = groupStr.split(";")) {
                    String instCode = (String)groupInst.get(groupNum);
                    if (instCode == null) continue;
                    String instGroupStr = (String)instCodeGroupStr.get(instCode);
                    instGroupStr = instGroupStr == null ? groupNum : instGroupStr + ";" + groupNum;
                    instCodeGroupStr.put(instCode, instGroupStr);
                }
            }
            groupArray = prodInstCodes.iterator();
            while (groupArray.hasNext()) {
                String instCode = groupArray.next();
                HashMap<String, String> detail = new HashMap<String, String>(2);
                detail.put("prod_inst_code", instCode);
                String instGroupStr = (String)instCodeGroupStr.get(instCode);
                if (instGroupStr == null) {
                    instGroupStr = "";
                }
                detail.put("prod_group", instGroupStr);
                instDetails.add(detail);
            }
            cloudUserInfo.setInstDetail(instDetails);
            if (!map.containsKey("fuid") && map.get("fuid") != null) continue;
            String fuid = map.get("fuid").toString();
            if (fuid != null && fuid.trim().length() > 0) {
                try {
                    long uidNum = Long.parseLong(fuid);
                    cloudUserInfo.setUid(uidNum);
                }
                catch (NumberFormatException e) {
                    cloudUserInfo.setUid(0L);
                }
            }
            if (!map.containsKey("gender") && map.get("gender") != null) continue;
            String pgender = map.get("gender").toString();
            int gender = "1".equalsIgnoreCase(pgender) ? 0 : (SYNCSTATUS.equalsIgnoreCase(pgender) ? 1 : 0);
            cloudUserInfo.setGender(gender);
            cloudUserInfo.setDepartment("");
            cloudUserInfo.setIdno("");
            int removeNetWork = LicenseServiceImpl.getRemoveNetWork(map.get("usertype"));
            cloudUserInfo.setIs_remove_network(removeNetWork);
            cloudUsers.add(cloudUserInfo);
        }
        return cloudUsers;
    }

    private static int getRemoveNetWork(Object userType) {
        String[] types;
        if (StringUtils.isBlank((Object)userType)) {
            return 1;
        }
        for (String type : types = userType.toString().split(",")) {
            if (!"1".equals(type)) continue;
            return 0;
        }
        return 1;
    }

    public Map<String, Object> syncUserGroup() {
        return this.syncUserGroup(LicenseUtil.isHighAvailabilityMode());
    }

    public Map<String, Object> syncUserGroup(boolean isTest) {
        UpdateLicGroupUser updateToCloud = new UpdateLicGroupUser();
        return updateToCloud.synUserToCloud(isTest);
    }

    public Map<String, Object> syncUserGroup(Set<Long> userIds) {
        return this.syncUserGroup(LicenseUtil.isHighAvailabilityMode());
    }

    private void addCloudUserInfos(List<CloudUserInfo> cloudUserInfos, Map<Long, Map<String, Object>> user2Group, Set<String> prodInstCodes) {
        HashMap<String, HashMap<String, ProductGroup>> userLicGroup = null;
        for (Map.Entry<Long, Map<String, Object>> entry : user2Group.entrySet()) {
            Map<String, Object> value = entry.getValue();
            String userId = entry.getKey().toString();
            String groupStr = value.get("group").toString();
            ProductGroup pgoup = new ProductGroup(groupStr);
            pgoup.setValid(true);
            HashMap<String, ProductGroup> productGroupMap = new HashMap<String, ProductGroup>(1);
            productGroupMap.put(groupStr, pgoup);
            if (userLicGroup == null) {
                userLicGroup = new HashMap<String, HashMap<String, ProductGroup>>(1);
            }
            userLicGroup.put(userId, productGroupMap);
        }
        cloudUserInfos.addAll(LicenseServiceImpl.getCloudUser(user2Group, userLicGroup, prodInstCodes));
    }

    private Map<Long, Map<String, Object>> getUserInfoFromDB(Set<Long> userIds, Map<String, DynamicObject> erpAccUserMap, LicenseSyncLog licenseSyncLog) {
        DynamicObject[] users = BusinessDataServiceHelper.load((String)ENTITY_BOS_USER, (String)"phone,number,birthday,email,name,enable,fuid,gender,username,usertype,isregisted,isforbidden", (QFilter[])new QFilter[]{new QFilter("id", "in", userIds)});
        HashMap<Long, Map<String, Object>> userInfo = new HashMap<Long, Map<String, Object>>(userIds.size());
        for (DynamicObject user : users) {
            HashMap<String, Object> map = new HashMap<String, Object>(16);
            map.put("group", "");
            this.analysisDBUser(userInfo, user, map, licenseSyncLog);
            String email = user.getString(PROP_EMAIL);
            String phone = user.getString(PROP_PHONE);
            String account = user.getString(PROP_NAME);
            if (StringUtils.isEmpty((CharSequence)account)) {
                account = StringUtils.isNotEmpty((CharSequence)phone) ? phone : email;
            }
            erpAccUserMap.put(account, user);
        }
        return userInfo;
    }

    private void analysisDBUser(Map<Long, Map<String, Object>> userInfo, DynamicObject user, Map<String, Object> map, LicenseSyncLog licenseSyncLog) {
        map.put(PROP_PHONE, user.getString(PROP_PHONE));
        map.put("number", user.getString("number"));
        map.put("birthday", user.getDate("birthday"));
        map.put(PROP_EMAIL, user.getString(PROP_EMAIL));
        String name = user.getLocaleString("name").getLocaleValue();
        if (name == null) {
            String strInfo = String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%1$s\u7684\u7528\u6237\u5728\u5f53\u524d\u8bed\u8a00(%2$s)\u4e0b\u6ca1\u6709\u540d\u79f0,\u6b64\u7528\u6237\u65e0\u6cd5\u540c\u6b65,\u8bf7\u4fee\u6539\u7528\u6237\u4fe1\u606f", (String)"LicenseServiceImpl_54", (String)"bos-mservice-license", (Object[])new Object[0]), user.getString("number"), RequestContext.get().getLang());
            logger.info("LicenseServiceImpl.getCloudUserInfo:" + strInfo);
            LicenseServiceHelper.addLog((String)this.UPLOAD_REG_USER, (String)strInfo);
            LicenseSyncDetailLog licenseSyncDetailLog = new LicenseSyncDetailLog();
            licenseSyncDetailLog.setLogType("1");
            licenseSyncDetailLog.setOperation(this.UPLOAD_REG_USER);
            licenseSyncDetailLog.setDescription(strInfo);
            licenseSyncDetailLog.setSuccess(false);
            List logs = licenseSyncLog.getLogs();
            logs.add(licenseSyncDetailLog);
            return;
        }
        map.put("name", name);
        map.put("isforbidden", !user.getBoolean("enable"));
        map.put("isdisenable", user.getBoolean("isforbidden"));
        map.put("fuid", user.getLong("fuid"));
        map.put("gender", user.getString("gender"));
        map.put(PROP_NAME, user.getString(PROP_NAME));
        map.put("usertype", user.getString("usertype"));
        userInfo.put(Long.parseLong(user.getPkValue().toString()), map);
    }

    public Map<String, Object> getActiveCode(String phone) {
        HashMap<String, Object> obj = new HashMap<String, Object>();
        if ("administrator".equals(phone)) {
            obj.put("success", false);
            obj.put("msg", ResManager.loadKDString((String)"administrator\u4e0d\u80fd\u6fc0\u6d3b", (String)"LicenseServiceImpl_70", (String)"bos-mservice-license", (Object[])new Object[0]));
            return obj;
        }
        String url = NextCloud.CLOUD_URL + "clouderp/account/vcode";
        boolean success = false;
        int reSendTime = 60;
        try {
            Map map;
            long t1 = System.currentTimeMillis();
            DynamicObject[] user = BusinessDataServiceHelper.load((String)ENTITY_BOS_USER, (String)"fuid", (QFilter[])new QFilter[]{new QFilter(PROP_PHONE, "=", (Object)phone), new QFilter("number", "!=", (Object)"administrator")});
            if (user == null || user.length == 0) {
                obj.put("success", success);
                obj.put("msg", String.format(ResManager.loadKDString((String)"\u672a\u627e\u5230\u624b\u673a\u53f7\u4e3a%1$s\u7684\u7528\u6237", (String)"LicenseServiceImpl_71", (String)"bos-mservice-license", (Object[])new Object[0]), phone));
                return obj;
            }
            String uid = user[0].getString("fuid");
            String prodInstId = this.getProductInfo().get("prodInstCode");
            String s = NextCloud.CLIENT_ID + NextCloud.CLIENT_SECRET + uid + prodInstId + phone + t1;
            String signiture = TransferUtil.sha1((String)s);
            String returnValue = HttpClientUtils.get((String)(url = url + "?client_id=" + NextCloud.CLIENT_ID + "&uid=" + URLEncoder.encode(uid, "utf-8") + "&prod_inst_code=" + URLEncoder.encode(prodInstId, "utf-8") + "&timestamp=" + t1 + "&phone=" + phone + "&signiture=" + signiture));
            if (returnValue != null && returnValue.length() > 0 && (map = (Map)JSONObject.parseObject((String)returnValue, Map.class)).get("errcode") != null) {
                if ("0".equals(String.valueOf(map.get("errcode")))) {
                    success = true;
                    if (map.get("resend_in") != null) {
                        reSendTime = Integer.parseInt(String.valueOf(map.get("resend_in")));
                    }
                } else {
                    obj.put("error", map.get("description"));
                    obj.put(ERRORCODE, map.get("errcode"));
                }
            }
        }
        catch (Exception e) {
            logger.error("LicenseServiceImpl.getActiveCode : e = " + e);
        }
        obj.put("success", success);
        obj.put("vCodeTime", reSendTime * 1000);
        return obj;
    }

    public boolean verifyCloudCode(String phone, String vcode) {
        if ("administrator".equals(phone)) {
            return false;
        }
        String url = NextCloud.CLOUD_URL + "clouderp/account/vcode/verifying";
        try {
            Map map;
            long t1 = System.currentTimeMillis();
            Object[] user = BusinessDataServiceHelper.load((String)ENTITY_BOS_USER, (String)"fuid,isactived", (QFilter[])new QFilter[]{new QFilter(PROP_PHONE, "=", (Object)phone), new QFilter("number", "!=", (Object)"administrator")});
            if (user == null || user.length == 0) {
                return false;
            }
            String uid = user[0].getString("fuid");
            String prodInstId = this.getProductInfo().get("prodInstCode");
            String s = NextCloud.CLIENT_ID + NextCloud.CLIENT_SECRET + uid + prodInstId + phone + vcode + t1;
            String signiture = TransferUtil.sha1((String)s);
            url = url + "?client_id=" + NextCloud.CLIENT_ID + "&uid=" + URLEncoder.encode(uid, "utf-8") + "&prod_inst_code=" + URLEncoder.encode(prodInstId, "utf-8") + "&vcode=" + vcode + "&timestamp=" + t1 + "&phone=" + phone + "&signiture=" + signiture;
            String returnValue = HttpClientUtils.get((String)url);
            logger.info("verifyCloudCode : s={},url={},returnValue={}", new Object[]{s, url, returnValue});
            if (returnValue != null && returnValue.length() > 0 && (map = (Map)JSONObject.parseObject((String)returnValue, Map.class)).get("errcode") != null && "0".equals(String.valueOf(map.get("errcode")))) {
                user[0].set("isactived", (Object)true);
                SaveServiceHelper.save((IDataEntityType)user[0].getDataEntityType(), (Object[])user);
                return true;
            }
        }
        catch (Exception e) {
            logger.error("verifyCode error == ", (Throwable)e);
        }
        return false;
    }

    public Map<String, Object> validateLicDate() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Map loadFromCache = BusinessDataServiceHelper.loadFromCache((String)"lic_license", (String)"expdate", (QFilter[])new QFilter[]{new QFilter("industry", "=", (Object)"Standard")});
        Iterator iterator = loadFromCache.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            DynamicObject dynamicObject = (DynamicObject)entry.getValue();
            Date date = dynamicObject.getDate("expdate");
            if (date.after(new Date())) {
                result.put("expire", false);
                try {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                    String dayAfter = LicenseServiceImpl.getSpecifiedDayBefore(sdf.format(date));
                    date = sdf.parse(dayAfter);
                    if (date.before(new Date())) {
                        result.put("msg", ResManager.loadKDString((String)"\u8bb8\u53ef\u5269\u4f59\u65f6\u95f4\u5df2\u4e0d\u8db330\u5929", (String)"LicenseServiceImpl_73", (String)"bos-mservice-license", (Object[])new Object[0]));
                    }
                    return result;
                }
                catch (ParseException e) {
                    logger.error("LicenseServiceImpl.validateLicDate : e = " + e);
                    result.put("expire", false);
                    result.put("msg", ResManager.loadKDString((String)"\u7cfb\u7edf\u5f02\u5e38", (String)"LicenseServiceImpl_60", (String)"bos-mservice-license", (Object[])new Object[0]));
                    return result;
                }
            }
            result.put("expire", true);
            return result;
        }
        result.put("expire", true);
        return result;
    }

    public static String getSpecifiedDayBefore(String specifiedDay) {
        Calendar c = Calendar.getInstance();
        Date date = c.getTime();
        try {
            date = new SimpleDateFormat("yy-MM-dd").parse(specifiedDay);
        }
        catch (ParseException e) {
            logger.error("LicenseServiceImpl.getSpecifiedDayBefore : e = " + e);
        }
        c.setTime(date);
        int day = c.get(5);
        c.set(5, day - 30);
        return new SimpleDateFormat("yyyy-MM-dd").format(c.getTime());
    }

    public String getUploadRegUserProgress() {
        return LicenseCache.getUploadRegUserProgress();
    }

    public void updateUploadRegUserProgress(boolean inSync, int hasSyncNum, int syncTotal, boolean isUpdateSuccess, boolean isDownloadSuccess, boolean inUpdate, boolean inDownload) {
        SyncLicenseProgressInfo oldInfo = LicenseServiceHelper.getUploadRegUserProgress();
        SyncLicenseProgressInfo info = new SyncLicenseProgressInfo(inSync, hasSyncNum, syncTotal, isUpdateSuccess, isDownloadSuccess, inUpdate, inDownload, oldInfo.getDownloadMsg(), oldInfo.getUpdateMsg());
        String uploadRegUserProgress = SerializationUtils.toJsonString((Object)info);
        LicenseCache.updateUploadRegUserProgress((String)uploadRegUserProgress);
    }

    public void setUploadRegUserMsg(String downloadMsg, String updateMsg) {
        LicenseServiceUtil.setUploadRegUserMsg(downloadMsg, updateMsg);
    }

    public void reLoadLicenseCache() {
        LicenseCacheMrg.clearCache((String)LicenseCacheMrg.getType4UserLicenseGroups());
    }

    public Map<String, Object> addUsersLicGroupByBizAppAndBizObj(List<Long> userIds, Map<String, List<String>> bizAppAndObjInfo) {
        HashMap<String, Object> result = new HashMap<String, Object>(1);
        try {
            if (LicenseServiceImpl.isEnablePermTolicense()) {
                AddUserLicGroupThread thread = new AddUserLicGroupThread(userIds, bizAppAndObjInfo);
                ThreadPools.executeOnceIncludeRequestContext((String)"addUsersLicGroup", (Runnable)thread);
            }
        }
        catch (Exception e) {
            logger.error("Get isEnablePermToLicense error.Default enable", (Throwable)e);
        }
        result.put("success", Boolean.TRUE);
        return result;
    }

    public Map<String, Object> addUserLicGroupByBizAppAndBizObj(Long userId, Map<String, List<String>> bizAppAndObjInfo) {
        return this.addUsersLicGroupByBizAppAndBizObj(Collections.singletonList(userId), bizAppAndObjInfo);
    }

    public boolean removeUserLicGroupById(Long userId, Set<Long> groupId) {
        if (CollectionUtils.isEmpty(groupId)) {
            return true;
        }
        logger.info("\u7528\u6237id:" + userId + "\u79fb\u9664\u5206\u7ec4:" + groupId);
        HashSet userIds = new HashSet(1);
        groupId.add(userId);
        return !CollectionUtils.isEmpty((Collection)UserLicGroupUtil.deleteUserGroupByGroupId(userIds, groupId, null));
    }

    public boolean removeUserLicGroupByNum(Long userId, Set<String> groupNum) {
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"lic_group", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "in", groupNum)});
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            return false;
        }
        HashSet<Long> groupId = new HashSet<Long>();
        for (DynamicObject dynamicObject : dynamicObjects) {
            Object pkValue;
            if (dynamicObject == null || (pkValue = dynamicObject.getPkValue()) == null) continue;
            groupId.add(Long.parseLong(pkValue.toString()));
        }
        return this.removeUserLicGroupById(userId, groupId);
    }

    public boolean clearUserLicGroup(Long userId) {
        QFilter userFilter = new QFilter(PROPERTY_USER, "=", (Object)userId);
        QFilter syncStatus = new QFilter("syncstatus", "!=", (Object)SYNCSTATUS);
        try (TXHandle h = TX.required();){
            try {
                LicenseCacheMrg.clearCache((String)LicenseCacheMrg.getType4UserLicenseGroups(), (String)(userId + ""));
                HashSet<Long> userIDs = new HashSet<Long>();
                userIDs.add(userId);
                this.deleteUserLic(userIDs);
                DeleteServiceHelper.delete((String)ENTITY_LIC_USER_GROUP, (QFilter[])new QFilter[]{userFilter, syncStatus});
            }
            catch (Exception e) {
                h.markRollback();
                boolean bl = false;
                if (h != null) {
                    if (var5_5 != null) {
                        try {
                            h.close();
                        }
                        catch (Throwable throwable) {
                            var5_5.addSuppressed(throwable);
                        }
                    } else {
                        h.close();
                    }
                }
                return bl;
            }
        }
        return true;
    }

    public void deleteUserLicGroup(Set<Long> userID, Boolean deleteSyncGroup) {
        if (deleteSyncGroup == null || deleteSyncGroup.booleanValue()) {
            this.deletePubCloudUserLic(userID);
        }
    }

    public static void writeLog(String bizAppId, String bizObjId, String opDescription) {
        OpLogAppInfo appLogInfo = new OpLogAppInfo();
        long userId = RequestContext.get().getCurrUserId();
        MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge("\u8bb8\u53ef\u6821\u9a8c", "LicenseServiceImpl_77", "bos-mservice-license");
        appLogInfo.setOpName("licenseCheck", opNameBridge);
        appLogInfo.setUserID(Long.valueOf(userId));
        appLogInfo.setOrgID(Long.valueOf(RequestContext.get().getOrgId()));
        appLogInfo.setOpTime(new Date());
        appLogInfo.setBizAppID(bizAppId);
        appLogInfo.setBizObjID(bizObjId);
        appLogInfo.setClientType(RequestContext.get().getClient());
        appLogInfo.setClientIP(RequestContext.get().getLoginIP());
        LogServiceHelper.addLog((AppLogInfo)appLogInfo);
    }

    public boolean isTemporaryLicense() {
        Map cache = LicenseCache.getTempLicenseCache();
        String isTemLic = (String)cache.get("isTemLic");
        return "1".equals(isTemLic);
    }

    private int getTotalNumber(Object groupId, boolean noNeedUpdateCache) {
        int totalCountStr = 0;
        String groupStr = String.valueOf(groupId);
        Map groupRumtimeInfosById = LicGroupRuntimeUtil.getGroupRumtimeInfosById(Collections.singletonList(groupStr));
        if (CollectionUtils.isEmpty((Map)groupRumtimeInfosById) || null == groupRumtimeInfosById.get(groupStr)) {
            logger.info("LicenseServiceImpl.getTotalNumber groupId={}\uff0ctotalCountStr={}", groupId, (Object)totalCountStr);
            return 0;
        }
        LicGroupRuntime licGroupRuntime = (LicGroupRuntime)groupRumtimeInfosById.get(groupStr);
        totalCountStr = licGroupRuntime.getTotalNumber();
        logger.info("LicenseServiceImpl.getTotalNumber groupId={}\uff0ctotalCountStr={}", groupId, (Object)totalCountStr);
        return totalCountStr;
    }

    public int getTotalNumber(Object groupId) {
        return this.getTotalNumber(groupId, false);
    }

    public int getTotalNumberNoUpdateCache(Object groupId) {
        return this.getTotalNumber(groupId, true);
    }

    public String checkAppInLicenseCtrl(String appId) {
        return LicenseCache.checkAppInLicenseCtrl((String)appId);
    }

    private LicenseCheckResult checkAppEntityInLicenseCtrl(String bizAppId, String entityTypeId) {
        LicenseCheckResult res = new LicenseCheckResult(Boolean.valueOf(true), "");
        if (StringUtils.isBlank((CharSequence)bizAppId) || StringUtils.isBlank((CharSequence)entityTypeId)) {
            res.setHasLicense(Boolean.valueOf(false));
            return res;
        }
        LicenseGroupCtrl licenseGroupCtrl = LicenseCache.getLicenseGroupCtrl((String)bizAppId, (String)entityTypeId);
        Set curVersionGroups = licenseGroupCtrl.getCurVersionGroups();
        String sourceBizAppId = BizAppServiceHelp.getAppIdByFormNum((String)entityTypeId);
        if (bizAppId.equals(sourceBizAppId)) {
            if (CollectionUtils.isEmpty((Collection)curVersionGroups)) {
                res.setHasLicense(Boolean.valueOf(false));
                res.setMsg(ResManager.loadKDString((String)"\u8be5\u8868\u5355\u4e0d\u5728\u5f53\u524d\u5e94\u7528\u7684\u8bb8\u53ef\u8303\u56f4\u5185\uff0c\u8bf7\u8054\u7cfb\u4ea7\u54c1\u5382\u5546\u3002", (String)"LicenseServiceImpl_151", (String)"bos-mservice-license", (Object[])new Object[0]));
            }
            return res;
        }
        if (CollectionUtils.isEmpty((Collection)curVersionGroups)) {
            return this.checkAppEntityInLicenseCtrl(sourceBizAppId, entityTypeId);
        }
        return res;
    }

    private boolean checkBuyLicenseGroup(Long groupId) {
        Date expireDate = LicenseCache.getExpireDateByGroup((Long)groupId);
        Date beginDate = LicenseCache.getBeginDateByGroup((Long)groupId);
        return expireDate != null && beginDate != null;
    }

    public LicenseCheckResult checkLicenseRight(Long userId, String bizAppId, String entityTypeId) {
        LicenseCheckResult checkResult = null;
        String isv = "";
        DynamicObject formMeta = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_formmeta", (String)"number,isv", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)entityTypeId)});
        if (formMeta != null) {
            isv = formMeta.getString("isv");
        }
        if ("kingdee".equals(isv)) {
            try {
                String md5Data = RSAUtil.getMD5Checksum((String)(isv + entityTypeId));
                DynamicObject metaSignObj = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_metasign", (String)"sign", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)entityTypeId)});
                if (metaSignObj == null) {
                    logger.info("entityTypeId:" + entityTypeId + "\u627e\u4e0d\u5230\u7b7e\u540d\u4fe1\u606f\u3002");
                } else {
                    String sign = metaSignObj.getString("sign");
                    if (!this.verify(md5Data, LicenseServiceImpl.getVerifyPubKey(), sign)) {
                        logger.info("entityTypeId:" + entityTypeId + "\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25\u3002");
                    }
                }
            }
            catch (Exception e) {
                logger.error("LicenseServiceImpl.checkLicenseRight verify error.", (Throwable)e);
            }
        }
        if (!kingdeeISVMap.containsKey(isv)) {
            boolean isIsvPord;
            logger.info("checkLicenseRight isCustomForm:" + entityTypeId);
            if (DevVerifyServiceHelper.isOEMEnv()) {
                checkResult = this.checkAppEntityInLicenseCtrl(bizAppId, entityTypeId);
                boolean buyLicGroup = this.checkBuyLicenseGroup(13L);
                if (!checkResult.getHasLicense().booleanValue() && !buyLicGroup) {
                    return checkResult;
                }
            }
            checkResult = (isIsvPord = this.checkIsvProd(isv)) ? this.checkIsvProdLicense(userId, bizAppId, entityTypeId) : this.checkStandardBOSRunTimeLicense(userId, bizAppId, entityTypeId);
        } else {
            checkResult = this.checkByAppAndBizObj(bizAppId, entityTypeId, userId, Boolean.FALSE);
        }
        return checkResult;
    }

    private void addLicenseCheckLog(String bizAppId, String entityTypeId, boolean writeCheckLog, String message, String logLevel) {
        if (!writeCheckLog || !LicenseUtil.showCheckLogForm()) {
            return;
        }
        LicenseCheckLog licenseCheckLog = (LicenseCheckLog)ThreadCache.get((Object)String.format("%s_%s", RequestContext.get().getCurrUserId(), entityTypeId));
        if (licenseCheckLog == null) {
            logger.info("LicenseServiceImpl#addLicenseCheckLog:bizAppId={},entityTypeId={},message={},logLevel={}", new Object[]{bizAppId, entityTypeId, message, logLevel});
            return;
        }
        licenseCheckLog.addLog(message, logLevel);
    }

    public void checkLicenseRight(FormShowParameter formShowParameter, Map<String, Object> ret) {
        String appgroup;
        MetaGrayService mgs;
        List list;
        Long userId = RequestContext.get().getCurrUserId();
        String appId = formShowParameter.getCheckRightAppId();
        String entityTypeId = LicenseServiceImpl.getEntityTypeId(formShowParameter);
        String formId = formShowParameter.getFormId();
        logger.info("checkLicenseRight:userId=" + userId + ",appId=" + appId + ",entityTypeId=" + entityTypeId + ",formId=" + formId);
        FormShowParameter parentShowParameter = SessionManager.getCurrent().getFormShowParameter(formShowParameter.getParentPageId());
        List<String> f7List = Arrays.asList("bos_listf7", "bos_treelistf7", "bos_templatetreelistf7", "bos_moblistf7", "bos_mobtreelistf7", "bos_customlistf7");
        if (f7List.contains(formId)) {
            return;
        }
        if (this.isCustomCardInHomePage(formShowParameter, parentShowParameter, entityTypeId)) {
            return;
        }
        if (LicenseServiceImpl.isIgnoreLicense(formShowParameter, parentShowParameter, entityTypeId, 0)) {
            logger.debug("checkLicenseRight#isIgnoreLicense");
            return;
        }
        String bizAppId = null;
        if (StringUtils.isBlank((CharSequence)appId)) {
            FormConfig fc = FormMetadataCache.getFormConfig((String)entityTypeId);
            bizAppId = StringUtils.isBlank((CharSequence)fc.getBizAppNumber()) ? BizAppServiceHelp.getAppIdByFormNum((String)entityTypeId) : BizAppServiceHelp.getAppIdByAppNumber((String)fc.getBizAppNumber());
        } else {
            AppInfo app = AppMetadataCache.getAppInfo((String)appId);
            bizAppId = app.getId();
        }
        LicenseCheckResult checkResult = null;
        boolean hasLicenseRight = true;
        Map map = GrayStrategy.getUserAppGroup((String)String.valueOf(RequestContext.get().getCurrUserId()), (String)RequestContext.get().getAccountId());
        if (map.containsKey(appId) && !CollectionUtils.isEmpty((Collection)(list = (mgs = new MetaGrayService()).getGrayInfoByGroup(appgroup = (String)map.get(appId))))) {
            for (MetaGrayInfo mg : list) {
                if (!entityTypeId.equals(mg.getNumber())) continue;
                return;
            }
        }
        this.newLicenseCheckLogInThreadCache(bizAppId, entityTypeId, userId);
        if (formShowParameter instanceof MobileBillShowParameter || formShowParameter instanceof MobileListShowParameter || formShowParameter instanceof MobileFormShowParameter) {
            checkResult = this.checkLicenseRight(userId, bizAppId, formId);
        }
        if (checkResult == null || checkResult.getGroupIDs().isEmpty()) {
            checkResult = this.checkLicenseRight(userId, bizAppId, entityTypeId);
        }
        if (checkResult != null) {
            hasLicenseRight = checkResult.getHasLicense();
        }
        if (!hasLicenseRight) {
            ret.put(CANCEL, Boolean.TRUE);
            ret.put(ERRORCODE, ErrorPageCode.ERROR_403);
            if (checkResult != null) {
                ret.put(CANCEL_MESSAGE, checkResult.getMsg());
                if (LicenseUtil.showCheckLogForm()) {
                    FormShowParameter licCheckLogShowParam = this.buildCancelFormShowParameter(bizAppId, entityTypeId, checkResult, Boolean.TRUE);
                    ret.put("cancelFormShowParameter", licCheckLogShowParam.toString());
                }
            } else {
                ret.put(CANCEL_MESSAGE, "");
            }
        }
    }

    private FormShowParameter buildCancelFormShowParameter(String bizAppId, String entityTypeId, LicenseCheckResult checkResult, Boolean isSaveLicenseCheckLog) {
        MobileFormShowParameter licCheckLogShowParam;
        if (this.isMobilForm(entityTypeId)) {
            licCheckLogShowParam = new MobileFormShowParameter();
            HashMap<String, String> param = new HashMap<String, String>(2);
            param.put("position", "center");
            licCheckLogShowParam.getOpenStyle().setCustParam(param);
            licCheckLogShowParam.setFormId("lic_licchecknotice_m");
        } else {
            licCheckLogShowParam = new FormShowParameter();
            licCheckLogShowParam.setFormId("lic_licchecknotice");
        }
        licCheckLogShowParam.getOpenStyle().setShowType(ShowType.Modal);
        LicenseCheckLog licenseCheckLog = (LicenseCheckLog)ThreadCache.get((Object)String.format("%s_%s", RequestContext.get().getCurrUserId(), entityTypeId));
        ArrayList messages = new ArrayList();
        if (licenseCheckLog != null && licenseCheckLog.getLogs().size() > 0) {
            Set checkLogDetails = licenseCheckLog.getLogs();
            checkLogDetails.forEach(logDetail -> messages.add(logDetail.getMessage()));
        }
        licCheckLogShowParam.setCustomParam("messages", messages);
        licCheckLogShowParam.setCustomParam("cancelmessage", (Object)checkResult.getMsg());
        if (isSaveLicenseCheckLog.booleanValue()) {
            licCheckLogShowParam.setCustomParam("licchecklogid", (Object)String.valueOf(this.saveLicenseCheckLog(bizAppId, entityTypeId, checkResult)));
        }
        return licCheckLogShowParam;
    }

    private boolean isMobilForm(String entityTypeId) {
        String modelType;
        String userAgent = RequestContext.get().getUserAgent();
        OperatingSystem operatingSystem = OperatingSystem.parseUserAgentString((String)userAgent);
        DeviceType deviceType = operatingSystem.getDeviceType();
        logger.debug("LicenseServiceImpl#isMobilForm:deviceType={}", (Object)deviceType);
        if (DeviceType.MOBILE.equals((Object)deviceType)) {
            return true;
        }
        if (StringUtils.isBlank((CharSequence)entityTypeId)) {
            return false;
        }
        try {
            modelType = FormMetadataCache.getFormConfig((String)entityTypeId).getModelType();
        }
        catch (Exception e) {
            logger.error("LicenseServiceImpl#isMobilForm fail", (Throwable)e);
            return false;
        }
        logger.debug("LicenseServiceImpl#isMobilForm:modelType={}", (Object)modelType);
        return modelType.contains("mobile");
    }

    private long saveLicenseCheckLog(String bizAppId, String entityTypeId, LicenseCheckResult checkResult) {
        LicenseCheckLog licenseCheckLog = (LicenseCheckLog)ThreadCache.get((Object)String.format("%s_%s", RequestContext.get().getCurrUserId(), entityTypeId));
        long id = DB.genLongId((String)"t_lic_licchecklog");
        licenseCheckLog.setId(Long.valueOf(id));
        licenseCheckLog.setCancelMessage(checkResult.getMsg());
        LicenseLogUtil.addLicCheckLog((LicenseCheckLog)licenseCheckLog);
        return id;
    }

    private void newLicenseCheckLogInThreadCache(String bizAppID, String bizObjID, Long userID) {
        LicenseCheckLog licenseCheckLog = (LicenseCheckLog)ThreadCache.get((Object)String.format("%s_%s", userID, bizObjID), () -> new LicenseCheckLog());
        licenseCheckLog.setBizAppId(bizAppID);
        licenseCheckLog.setBizObjId(bizObjID);
    }

    private boolean isCustomCardInHomePage(FormShowParameter formShowParameter, FormShowParameter parentShowParameter, String entityTypeId) {
        boolean isCustomCardInHomePage = false;
        if (parentShowParameter == null) {
            return false;
        }
        try {
            boolean isInHomePage = false;
            String parentFormId = parentShowParameter.getFormId();
            if ("pc_main_console".equals(parentFormId) || "home_page".equals(parentFormId)) {
                isInHomePage = true;
            } else {
                String appId = parentShowParameter.getAppId();
                if (StringUtils.isNotBlank((CharSequence)appId)) {
                    AppInfo appInfo = AppMetadataCache.getAppInfo((String)appId);
                    if (appInfo == null) {
                        return false;
                    }
                    String homeNum = appInfo.getHomeNum();
                    isInHomePage = homeNum.equals(parentFormId);
                }
            }
            if (isInHomePage) {
                DynamicObject formMetadata = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_formmeta", (String)"inheritpath", (QFilter[])new QFilter("number", "=", (Object)entityTypeId).toArray());
                if (formMetadata == null) {
                    return false;
                }
                String inheritpath = formMetadata.getString("inheritpath");
                isCustomCardInHomePage = inheritpath.contains("/910EZ6ZX680");
            }
        }
        catch (Exception e) {
            logger.error("\u5224\u65ad\u662f\u5426\u95e8\u6237\u9996\u9875/\u5e94\u7528\u9996\u9875\u7684\u81ea\u5b9a\u4e49\u5361\u7247\u65f6\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
        }
        return isCustomCardInHomePage;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private LicenseCheckResult checkIsvProdLicense(Long userId, String bizAppId, String entityTypeId) {
        String groupId;
        Long groupID;
        String[] groupIDs;
        LicenseCheckResult checkResult = new LicenseCheckResult();
        if (LicenseCache.isCircuitBreaker((String)"isvCtrl")) {
            checkResult.setHasLicense(Boolean.valueOf(false));
            checkResult.setMsg(ResManager.loadKDString((String)"\u8bb8\u53ef\u4fe1\u606f\u6709\u8bef\uff0c\u529f\u80fd\u6682\u65f6\u65e0\u6cd5\u4f7f\u7528\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"LicenseServiceImpl_165", (String)"bos-mservice-license", (Object[])new Object[0]));
            return checkResult;
        }
        String isv = "";
        try {
            AppInfo appInfo = AppMetadataCache.getAppInfo((String)bizAppId);
            isv = appInfo.getIsv();
        }
        catch (Exception e) {
            logger.error("App not found : appId=" + bizAppId, (Throwable)e);
        }
        logger.info("checkLicenseRight isv:" + isv);
        if (!"kingdee".equals(isv)) return this.checkByAppAndBizObj(bizAppId, entityTypeId, userId, Boolean.TRUE);
        String group = LicenseServiceHelper.checkAppInLicenseCtrl((String)bizAppId);
        logger.info("checkLicenseRight group:" + group);
        if (!StringUtils.isNotBlank((CharSequence)group)) return this.checkByAppAndBizObj(bizAppId, entityTypeId, userId, Boolean.TRUE);
        String[] stringArray = groupIDs = group.split(";");
        int n = stringArray.length;
        for (int i = 0; i < n && !(checkResult = this.checkUserInGroup(userId, groupID = Long.valueOf(Long.parseLong(groupId = stringArray[i])), bizAppId, entityTypeId, false)).getHasLicense().booleanValue(); ++i) {
        }
        if (checkResult == null) return checkResult;
        if (checkResult.getHasLicense() == false) return checkResult;
        return this.checkByAppAndBizObj(bizAppId, entityTypeId, userId, Boolean.TRUE);
    }

    public int getModeType() {
        int modeType = 0;
        Object enablemultiorg = null;
        try {
            enablemultiorg = SystemParamServiceHelper.loadPublicParameterFromCache((String)"enablemultiorg");
        }
        catch (Exception e) {
            logger.warn("\u83b7\u53d6\u2018\u542f\u7528\u591a\u7ec4\u7ec7\u2019\u53c2\u6570\u5f02\u5e38\u3002", (Throwable)e);
        }
        if (enablemultiorg != null) {
            modeType = 4;
            return modeType;
        }
        modeType = LicenseCache.getModelType();
        if (modeType > 0) {
            return modeType;
        }
        modeType = 3;
        return modeType;
    }

    private LicenseCheckResult checkStandardBOSRunTimeLicense(Long userId, String bizAppId, String entityTypeId) {
        LicenseCheckResult checkResult = new LicenseCheckResult(Boolean.TRUE, "");
        boolean noCodeBill = ((NoCodeRuntimeService)ServiceFactory.getService(NoCodeRuntimeService.class)).isNoCodeBill(entityTypeId);
        if (noCodeBill) {
            return checkResult;
        }
        AppInfo appInfo = AppMetadataCache.getAppInfo((String)bizAppId);
        if (entityTypeId.equals(appInfo.getHomeNum())) {
            return checkResult;
        }
        int modeType = this.getModeType();
        if (modeType == 2 || modeType == 4) {
            return this.checkDevLicenseV4(userId, bizAppId, entityTypeId);
        }
        String productversion = (String)LicenseServiceHelper.getProductInfo().get("productversion");
        if (productversion == null) {
            productversion = "5.0";
        }
        if ("0.1".equals(productversion) || "1.5".equals(productversion) || "1.0".equals(productversion)) {
            productversion = "1.0";
        } else if ("0.2".equals(productversion)) {
            productversion = "2.0";
        }
        logger.info("checkLicenseRight productversion:" + productversion);
        switch (productversion) {
            case "1.0": {
                checkResult = LicenseServiceHelper.checkUserInBOSRunTimeGroup((Long)userId);
                break;
            }
            case "2.0": 
            case "0.2": 
            case "3.0": 
            case "0.3": {
                checkResult = LicenseServiceImpl.checkLicenseV2(userId, bizAppId);
                break;
            }
            default: {
                checkResult = this.checkDevLicenseV4(userId, bizAppId, entityTypeId);
            }
        }
        return checkResult;
    }

    private boolean checkIsvProd(String isv) {
        boolean isIsvPord = false;
        List isvProdList = LicenseCache.getAllISVProd();
        Set<String> isvInfos = this.getIsvInfo();
        for (ISVProdInfo isvProdInfo : isvProdList) {
            String isvNumber = isvProdInfo.getIsvNumber();
            if (isIsvPord || !StringUtils.isNotBlank((CharSequence)isvNumber) || !isvNumber.equalsIgnoreCase(isv)) continue;
            isIsvPord = true;
        }
        if (!isIsvPord) {
            for (String isvInfo : isvInfos) {
                if (null == isvInfo || !isvInfo.equalsIgnoreCase(isv)) continue;
                throw new KDBizException(ResManager.loadKDString((String)"\u7ecf\u68c0\u9a8cISV\u4ea7\u54c1\u4fe1\u606f\u88ab\u4ece\u6570\u636e\u5e93\u4e2d\u4fee\u6539\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"LicenseServiceImpl_141", (String)"bos-mservice-license", (Object[])new Object[0]));
            }
        }
        return isIsvPord;
    }

    private Set<String> getIsvInfo() {
        String accountId = null;
        try {
            accountId = RequestContext.get().getAccountId();
        }
        catch (Exception e) {
            logger.warn("\u4e0a\u4e0b\u6587\u83b7\u53d6\u8d26\u5957ID\u5931\u8d25\uff0c\u6b64\u65f6isv\u4f19\u4f34\u5224\u65ad\u4ee5\u6570\u636e\u5e93\u4e3a\u51c6\u3002");
        }
        if (null == accountId) {
            return Collections.EMPTY_SET;
        }
        String isvInfo = "isv_info_" + accountId;
        String isv = System.getProperty(isvInfo);
        logger.info(isvInfo + "\uff1a" + isv);
        if (StringUtils.isBlank((CharSequence)isv)) {
            return Collections.EMPTY_SET;
        }
        return (Set)SerializationUtils.fromJsonString((String)this.getRealIsvInfoString(isv), Set.class);
    }

    private String getRealIsvInfoString(String isv) {
        if (Encrypters.isEncrypted((String)isv)) {
            isv = Encrypters.decode((String)isv);
        }
        return isv;
    }

    private static LicenseCheckResult checkLicenseV2(Long userId, String bizAppId) {
        LicenseCheckResult checkResult = new LicenseCheckResult(Boolean.FALSE, ResManager.loadKDString((String)"\u65e0\u8bb8\u53ef", (String)"LicenseServiceImpl_118", (String)"bos-mservice-license", (Object[])new Object[0]));
        Long groupID = 0L;
        String isv = "";
        boolean isAllUserApp = false;
        try {
            AppInfo appInfo = AppMetadataCache.getAppInfo((String)bizAppId);
            isv = appInfo.getIsv();
            isAllUserApp = appInfo.isAllUserApp();
        }
        catch (Exception e) {
            logger.error("App not found : appId=" + bizAppId, (Throwable)e);
        }
        logger.info("checkLicenseV2 isv:" + isv);
        if ("kingdee".equals(isv)) {
            String group = LicenseServiceHelper.checkAppInLicenseCtrl((String)bizAppId);
            logger.info("checkLicenseV2 group:" + group);
            if (StringUtils.isNotBlank((CharSequence)group)) {
                String userType;
                String[] userTypeArr;
                DynamicObject user;
                String groupId;
                String[] groupIDs;
                String[] stringArray = groupIDs = group.split(";");
                int n = stringArray.length;
                for (int i = 0; i < n && !(checkResult = LicenseServiceHelper.checkUserInGroup((Long)userId, (Long)(groupID = Long.valueOf(Long.parseLong(groupId = stringArray[i]))))).getHasLicense().booleanValue(); ++i) {
                }
                if (ignoreAppIds.contains(bizAppId) && (user = BusinessDataServiceHelper.loadSingleFromCache((Object)userId, (String)ENTITY_BOS_USER)) != null && (userTypeArr = (userType = user.getString("usertype")).split(",")) != null) {
                    for (int i = 0; i < userTypeArr.length; ++i) {
                        if (!"3".equals(userTypeArr[i])) continue;
                        return checkResult;
                    }
                }
                if (checkResult != null && checkResult.getHasLicense().booleanValue()) {
                    groupID = isAllUserApp ? Long.valueOf(39L) : Long.valueOf(40L);
                    checkResult = LicenseServiceHelper.checkUserInGroup((Long)userId, (Long)groupID);
                    if (checkResult != null && !checkResult.getHasLicense().booleanValue()) {
                        groupID = 13L;
                    } else if (checkResult != null && checkResult.getHasLicense().booleanValue()) {
                        return checkResult;
                    }
                } else {
                    groupID = 13L;
                }
            } else {
                groupID = 13L;
            }
        } else {
            groupID = 13L;
        }
        return LicenseServiceHelper.checkUserInGroup((Long)userId, (Long)groupID);
    }

    private LicenseCheckResult checkDevLicenseV4(Long userId, String bizAppId, String entityTypeId) {
        LicenseCheckResult checkResult = null;
        AppInfo appInfo = null;
        String isv = "";
        try {
            appInfo = AppMetadataCache.getAppInfo((String)bizAppId);
            isv = appInfo.getIsv();
        }
        catch (Exception e) {
            logger.error("App not found : appId=" + bizAppId, (Throwable)e);
        }
        logger.info("checkDevLicenseV4 isv:" + isv);
        String assignLicenseMessage = "";
        if ("kingdee".equals(isv)) {
            String group = LicenseServiceHelper.checkAppInLicenseCtrl((String)bizAppId);
            logger.info("checkDevLicenseV4 group:" + group);
            int modeType = this.getModeType();
            if (StringUtils.isNotBlank((CharSequence)group) || offlineAppIds.contains(bizAppId) || offlineAppIdsByOldVersion.contains(bizAppId) && !InitailVersionServiceHelper.isInitailVersion((int)6) && 2 != modeType && 4 != modeType) {
                String productVersion;
                String userType;
                String[] userTypeArr;
                DynamicObject user;
                if (StringUtils.isNotBlank((CharSequence)group)) {
                    String groupId;
                    Long groupID;
                    String[] groupIDs;
                    String[] stringArray = groupIDs = group.split(";");
                    int n = stringArray.length;
                    for (int i = 0; i < n && !(checkResult = this.checkUserInGroup(userId, groupID = Long.valueOf(Long.parseLong(groupId = stringArray[i])), bizAppId, entityTypeId, false)).getHasLicense().booleanValue(); ++i) {
                    }
                    assignLicenseMessage = this.buildAssignLicenseMessage(groupIDs);
                }
                if (checkResult != null && checkResult.getHasLicense().booleanValue() && ignoreAppIds.contains(bizAppId) && (user = BusinessDataServiceHelper.loadSingleFromCache((Object)userId, (String)ENTITY_BOS_USER)) != null && (userTypeArr = (userType = user.getString("usertype")).split(",")) != null) {
                    for (int i = 0; i < userTypeArr.length; ++i) {
                        if (!"3".equals(userTypeArr[i])) continue;
                        return checkResult;
                    }
                }
                if (!(null != checkResult && checkResult.getHasLicense().booleanValue() || !offlineAppIds.contains(bizAppId) && (!offlineAppIdsByOldVersion.contains(bizAppId) || InitailVersionServiceHelper.isInitailVersion((int)6)) || LicenseUtil.compareVersion((String)"6.0", (String)(productVersion = this.getProductVersion())))) {
                    if (null == checkResult) {
                        checkResult = new LicenseCheckResult();
                    }
                    checkResult.setHasLicense(Boolean.valueOf(true));
                }
                if (checkResult != null && checkResult.getHasLicense().booleanValue()) {
                    checkResult = LicenseServiceHelper.checkPerformGroup((String)"CP_DEVB");
                }
                if (checkResult != null && checkResult.getHasLicense().booleanValue()) {
                    DynamicObject[] load = BusinessDataServiceHelper.load((String)"lic_stddevcfg", (String)"bizobject,status", null);
                    int totalNumber = LicenseServiceHelper.getTotalNumber((Object)252L);
                    int formCount = LicenseServiceImpl.getFormCount();
                    logger.info("checkDevLicenseV4.getFormCount : " + formCount);
                    if (load != null && formCount <= totalNumber) {
                        HashSet<String> enableEntities = new HashSet<String>(load.length);
                        HashSet<String> disableEntities = new HashSet<String>(load.length);
                        for (DynamicObject obj : load) {
                            DynamicObject bizObj = obj.getDynamicObject("bizobject");
                            if (bizObj == null) continue;
                            String entityNumber = bizObj.getString("number");
                            if ("true".equals(obj.getString("status"))) {
                                enableEntities.add(entityNumber);
                                continue;
                            }
                            disableEntities.add(entityNumber);
                        }
                        if (!enableEntities.contains(entityTypeId) && disableEntities.contains(entityTypeId)) {
                            checkResult.setHasLicense(Boolean.FALSE);
                            checkResult.setMsg(ResManager.loadKDString((String)"\u8bb8\u53ef\u9a8c\u8bc1\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u68c0\u67e5\u201c\u5f00\u53d1\u670d\u52a1\u8fd0\u884c\u65f6-\u878d\u5408\u7248\u201d\u914d\u7f6e\u4e2d\u662f\u5426\u6709\u8be5\u4e8c\u5f00\u8868\u5355\uff0c\u6216\u5f53\u524d\u7528\u6237\u662f\u5426\u5df2\u6dfb\u52a0\u5230\u201c\u5f00\u53d1\u670d\u52a1\u8fd0\u884c\u65f6-\u72ec\u7acb\u7248\u201d\u4e2d\u3002", (String)"LicenseServiceImpl_143", (String)"bos-mservice-license", (Object[])new Object[0]));
                        } else if (!enableEntities.contains(entityTypeId)) {
                            checkResult.setHasLicense(Boolean.FALSE);
                            checkResult.setMsg(ResManager.loadKDString((String)"\u201c\u5f00\u53d1\u670d\u52a1\u8fd0\u884c\u65f6-\u878d\u5408\u7248\u201d\u4e2d\u672a\u914d\u7f6e\u8be5\u5e94\u7528\u8868\u5355\uff0c\u6216\u6ca1\u6709\u201c\u5f00\u53d1\u670d\u52a1\u8fd0\u884c\u65f6-\u72ec\u7acb\u7248\u201d\u8bb8\u53ef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"LicenseServiceImpl_122", (String)"bos-mservice-license", (Object[])new Object[0]));
                        }
                    } else if (formCount > totalNumber) {
                        checkResult.setHasLicense(Boolean.FALSE);
                        String message = ResManager.loadKDString((String)"\u8bb8\u53ef\u9a8c\u8bc1\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u68c0\u67e5\u201c\u5f00\u53d1\u670d\u52a1\u8fd0\u884c\u65f6-\u878d\u5408\u7248\u201d\u914d\u7f6e\u4e2d\u7684\u8868\u5355\u603b\u6570\u662f\u5426\u5df2\u8d85\u8fc7\u8d2d\u4e70\u7684\u6570\u91cf\uff0c\u6216\u5f53\u524d\u7528\u6237\u662f\u5426\u5df2\u6dfb\u52a0\u5230\u201c\u5f00\u53d1\u670d\u52a1\u8fd0\u884c\u65f6-\u72ec\u7acb\u7248\u201d\u4e2d\u3002", (String)"LicenseServiceImpl_146", (String)"bos-mservice-license", (Object[])new Object[0]);
                        checkResult.setMsg(message);
                    } else {
                        checkResult.setHasLicense(Boolean.FALSE);
                        String message = ResManager.loadKDString((String)"\u201c\u5f00\u53d1\u670d\u52a1\u8fd0\u884c\u65f6-\u878d\u5408\u7248\u201d\u4e2d\u672a\u914d\u7f6e\u8be5\u5e94\u7528\u8868\u5355\uff0c\u6216\u6ca1\u6709\u201c\u5f00\u53d1\u670d\u52a1\u8fd0\u884c\u65f6-\u72ec\u7acb\u7248\u201d\u8bb8\u53ef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"LicenseServiceImpl_122", (String)"bos-mservice-license", (Object[])new Object[0]);
                        checkResult.setMsg(message);
                    }
                } else {
                    checkResult = null;
                }
            }
        }
        if (checkResult != null && checkResult.getHasLicense().booleanValue()) {
            return checkResult;
        }
        LicenseCheckResult checkUserInDEVPGroup = this.checkUserInGroup(userId, 13L, bizAppId, entityTypeId, false);
        this.setLicenseCheckLog(bizAppId, entityTypeId, appInfo, assignLicenseMessage, checkResult, checkUserInDEVPGroup);
        if (checkResult != null && (checkUserInDEVPGroup != null && !checkUserInDEVPGroup.getHasLicense().booleanValue() || checkUserInDEVPGroup == null)) {
            return checkResult;
        }
        return checkUserInDEVPGroup;
    }

    private void setLicenseCheckLog(String bizAppId, String entityTypeId, AppInfo appInfo, String assignLicenseMessage, LicenseCheckResult checkResult, LicenseCheckResult checkUserInDEVPGroup) {
        if (checkResult == null || !checkResult.getHasLicense().booleanValue() || checkUserInDEVPGroup == null || !checkUserInDEVPGroup.getHasLicense().booleanValue()) {
            boolean buyCP_DEVB = this.checkBuyLicenseGroup(252L);
            boolean buyCP_DEV = this.checkBuyLicenseGroup(13L);
            if (buyCP_DEVB) {
                String msg1 = String.format(ResManager.loadKDString((String)"\u8868\u5355\u6240\u5c5e\u5e94\u7528\u201c%s\u201d\u9700\u8981\u5728\u53ef\u878d\u5408\u5e94\u7528\u8303\u56f4\u5185\uff1b", (String)"LicenseServiceImpl_159", (String)"bos-mservice-license", (Object[])new Object[0]), appInfo.getName());
                String msg2 = !StringUtils.isBlank((CharSequence)assignLicenseMessage) ? assignLicenseMessage : ResManager.loadKDString((String)"\u7528\u6237\u9700\u8981\u5206\u914d\u8868\u5355\u6240\u5c5e\u5e94\u7528\u5bf9\u5e94\u7684\u8bb8\u53ef\u5206\u7ec4", (String)"LicenseServiceImpl_160", (String)"bos-mservice-license", (Object[])new Object[0]);
                String msg3 = ResManager.loadKDString((String)"\u8868\u5355\u9700\u8981\u52a0\u5165\u5230\u201c\u5f00\u53d1\u670d\u52a1\u878d\u5408\u7248\u8bb8\u53ef\u914d\u7f6e\u5217\u8868\u4e2d\u201d\uff1b\uff08\u53ef\u878d\u5408\u5e94\u7528\u7684\u67e5\u770b\u8def\u5f84\u4e3a\uff1a\u8bb8\u53ef\u5206\u7ec4\u660e\u7ec6-\u5f00\u53d1\u670d\u52a1\u878d\u5408\u7248\u8868\u5355\u914d\u7f6e-\u67e5\u770b\u53ef\u878d\u5408\u5e94\u7528\u3002\uff09", (String)"LicenseServiceImpl_161", (String)"bos-mservice-license", (Object[])new Object[0]);
                String message = String.format("%s%s%s", msg1, msg2, msg3);
                this.addLicenseCheckLog(bizAppId, entityTypeId, true, message, "info");
            }
            if (buyCP_DEV) {
                this.addLicenseCheckLog(bizAppId, entityTypeId, true, ResManager.loadKDString((String)"\u7528\u6237\u9700\u8981\u5206\u914d\u201c\u5f00\u53d1\u670d\u52a1\u8fd0\u884c\u65f6-\u72ec\u7acb\u7248\u201d\u8bb8\u53ef\u5206\u7ec4\u3002", (String)"LicenseServiceImpl_162", (String)"bos-mservice-license", (Object[])new Object[0]), "info");
            }
        }
    }

    private String buildAssignLicenseMessage(String[] groupIDs) {
        StringJoiner sj = new StringJoiner(ResManager.loadKDString((String)"\u6216", (String)"LicenseServiceImpl_164", (String)"bos-mservice-license", (Object[])new Object[0]));
        Arrays.stream(groupIDs).forEach(groupID -> sj.add(String.format("\u201c%s\u201d", this.getGroupName((String)groupID))));
        return String.format(ResManager.loadKDString((String)"\u7528\u6237\u9700\u8981\u5206\u914d%s\u8bb8\u53ef\u5206\u7ec4\uff1b", (String)"LicenseServiceImpl_163", (String)"bos-mservice-license", (Object[])new Object[0]), sj.toString());
    }

    private static int getFormCount() {
        return (Integer)DB.query((DBRoute)DBRoute.base, (String)"select fid,fstatus from t_lic_standdevconfig", rs -> {
            int i = 0;
            while (rs.next()) {
                if (!"true".equals(rs.getString("fstatus"))) continue;
                ++i;
            }
            return i;
        });
    }

    public String sign(String data, String privateKey) {
        try {
            return RSAUtil.sign((String)data, (String)privateKey);
        }
        catch (Exception e) {
            logger.error("LicenseServiceImpl.sign\u7b7e\u540d\u5931\u8d25", (Throwable)e);
            return "";
        }
    }

    public boolean verify(String data, String publicKey, String sign) {
        try {
            return RSAUtil.verify((String)data, (String)publicKey, (String)sign);
        }
        catch (Exception e) {
            logger.info("LicenseServiceImpl.verif\u9a8c\u7b7e\u5931\u8d25" + e.getMessage());
            return false;
        }
    }

    public String getPubTenantType() {
        String cachekey;
        String type = "tenant_type_" + RequestContext.get().getTenantId();
        String tenantType = LicenseCacheMrg.getCache((String)type, (String)(cachekey = "tenant_type"));
        if (StringUtils.isBlank((CharSequence)tenantType)) {
            try {
                tenantType = this.getTenantTypeFromMc();
            }
            catch (Exception e) {
                logger.error(String.format("\u83b7\u53d6\u73af\u5883\u90e8\u7f72\u65b9\u5f0f\u5f02\u5e38\uff0c%s", e.getMessage()), (Throwable)e);
            }
            tenantType = "public".equals(tenantType) ? Boolean.TRUE.toString() : Boolean.FALSE.toString();
            LicenseCacheMrg.putCache((String)type, (String)cachekey, (String)tenantType);
        }
        return tenantType;
    }

    private void notifyMcUpdateLic() {
        String tenantId = RequestContext.get().getTenantId();
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("tenantId", tenantId);
        String clusterName = System.getProperty("clusterName");
        param.put("envNumber", clusterName);
        String mcServer = System.getProperty("mc.server.url");
        String mcLoadLicUrl = mcServer + "/kapi/app/mc/updateLicensefromEASCloud";
        String notifyResult = null;
        try {
            notifyResult = LicenseMCApiUtil.notifyMcUpdateLicFile();
            JSONObject result = JSON.parseObject((String)notifyResult);
            Object code = result.get((Object)"errorcode");
            if (code == null || Integer.parseInt(code.toString()) != 100) {
                logger.error(String.format("\u8c03\u7528MC\u63a5\u53e3\u66f4\u65b0\u8bb8\u53ef\u65f6\u5f02\u5e38\uff0c\u63a5\u53e3CODE\u4e3a\uff1a%s, \u8bf7\u6c42\u5730\u5740\u4e3a\uff1a%s\uff0c\u8bf7\u6c42\u53c2\u6570\u4e3a\uff1a%s\uff0c\u8fd4\u56de\u503c\u4e3a\uff1a%s", code, mcLoadLicUrl, JSON.toJSONString(param), notifyResult));
                throw new KDBizException(ResManager.loadKDString((String)"\u4eceMC\u83b7\u53d6\u670d\u52a1\u90e8\u7f72\u65b9\u5f0f\u5f02\u5e38", (String)"LicenseServiceImpl_80", (String)"bos-mservice-license", (Object[])new Object[0]));
            }
        }
        catch (Exception e) {
            logger.error(String.format("\u8c03\u7528MC\u63a5\u53e3\u66f4\u65b0\u8bb8\u53ef\u65f6\u5f02\u5e38, \u8bf7\u6c42\u5730\u5740\u4e3a\uff1a%s\uff0c\u8bf7\u6c42\u53c2\u6570\u4e3a\uff1a%s\uff0c\u8fd4\u56de\u503c\u4e3a\uff1a%s", mcLoadLicUrl, JSON.toJSONString(param), notifyResult));
            throw new KDBizException(ResManager.loadKDString((String)"\u4eceMC\u83b7\u53d6\u670d\u52a1\u90e8\u7f72\u65b9\u5f0f\u5f02\u5e38", (String)"LicenseServiceImpl_80", (String)"bos-mservice-license", (Object[])new Object[0]));
        }
    }

    private String getTenantTypeFromMc() {
        String tenantId = RequestContext.get().getTenantId();
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("tenantId", tenantId);
        String mcServer = System.getProperty("mc.server.url");
        String downloadLicUrl = mcServer + "/kapi/app/mc/getlicensebytenantid";
        param.remove("envNumber");
        String value = null;
        try {
            value = LicenseMCApiUtil.getEncryptLicFileFromMc();
            JSONObject licJson = JSON.parseObject((String)value);
            Integer errorCode = licJson.getInteger("errorcode");
            if (errorCode != null && Integer.parseInt(errorCode.toString()) == 100) {
                JSONObject license;
                JSONObject content;
                String tenantType;
                JSONArray licenses;
                Object dataJson = licJson.get((Object)"data");
                String licenseData = String.valueOf(dataJson);
                if (Encrypters.isEncrypted((String)licenseData)) {
                    licenseData = Encrypters.decode((String)licenseData);
                }
                if (!CollectionUtils.isEmpty((Collection)(licenses = JSON.parseArray((String)licenseData))) && StringUtils.isNotBlank((CharSequence)(tenantType = (content = (license = licenses.getJSONObject(0)).getJSONObject("content")).getString("tenantType")))) {
                    return tenantType;
                }
            }
            logger.error(String.format("\u4eceMC\u4e0b\u8f7d\u8bb8\u53ef\u65f6\u5f02\u5e38,\u63a5\u53e3code\u4e3a\uff1a%s, \u8bf7\u6c42\u5730\u5740\u4e3a\uff1a%s\uff0c\u8bf7\u6c42\u53c2\u6570\u4e3a\uff1a%s\uff0c\u8fd4\u56de\u503c\u4e3a\uff1a%s", errorCode, downloadLicUrl, JSON.toJSONString(param), value));
        }
        catch (Exception e) {
            logger.error(String.format("\u4eceMC\u4e0b\u8f7d\u8bb8\u53ef\u65f6\u5f02\u5e38, \u8bf7\u6c42\u5730\u5740\u4e3a\uff1a%s\uff0c\u8bf7\u6c42\u53c2\u6570\u4e3a\uff1a%s\uff0c\u8fd4\u56de\u503c\u4e3a\uff1a%s", downloadLicUrl, JSON.toJSONString(param), value));
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u4eceMC\u83b7\u53d6\u670d\u52a1\u90e8\u7f72\u65b9\u5f0f\u5f02\u5e38", (String)"LicenseServiceImpl_80", (String)"bos-mservice-license", (Object[])new Object[0]));
    }

    private static Object getParameterFromCache(String key) {
        AppParam appParam = new AppParam();
        appParam.setAppId("83bfebc8000037ac");
        appParam.setViewType("15");
        appParam.setOrgId(Long.valueOf(((IParameterHelperService)ServiceSvcFactory.getService(IParameterHelperService.class)).getParamRootOrgId()));
        appParam.setActBookId(Long.valueOf(0L));
        Map paramMap = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam);
        return paramMap == null ? null : paramMap.get(key);
    }

    private static boolean isEnableSysParam(String sysParamKey) {
        Object isEnable = LicenseServiceImpl.getParameterFromCache(sysParamKey);
        return isEnable != null && Boolean.parseBoolean(isEnable.toString());
    }

    private static boolean isEnablePermTolicense() {
        return LicenseServiceImpl.isEnableSysParam("enablepermtolic");
    }

    private static boolean isEnableAutoAssignAllUserLic() {
        return LicenseServiceImpl.isEnableSysParam("autoassignalluserlic");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<Long, String> getHasBoughtLicGroup() {
        HashMap<Long, String> licenseGroup = new HashMap<Long, String>(32);
        String sql = "SELECT g.FID ID, gl.fNAME NAME FROM T_LIC_GROUP g INNER JOIN T_LIC_GROUP_L gl ON ( gl.FID = g.FID AND gl.FLOCALEID = 'zh_CN' ) INNER JOIN T_LIC_LICENSEDETAIL ld ON ld.FGROUPID = g.fid WHERE ld.ftotalCount > 0";
        try (DataSet dataSet = DB.queryDataSet((String)"LicenseServiceImpl.getHasBoughtRegLicGroup", (DBRoute)DBRoute.base, (String)sql);){
            Object licGroupName;
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Long licGroupId = row.getLong("ID");
                licGroupName = row.getString("NAME");
                licenseGroup.put(licGroupId, (String)licGroupName);
            }
            Map<String, String> info = this.getProductInfo();
            String productversion = info.get("productversion");
            if (productversion == null) {
                licGroupName = licenseGroup;
                return licGroupName;
            }
            if (!productversion.equals("0.1") && !productversion.equals("1.0")) {
                if (!productversion.equals("1.5")) return licenseGroup;
            }
            Map licenseGroupV1 = LicenseGroupUtil.getLicenseGroupV1((String)"1");
            Iterator iterator = licenseGroup.keySet().iterator();
            while (iterator.hasNext()) {
                Long key = (Long)iterator.next();
                if (!licenseGroupV1.containsKey(key.toString())) continue;
                licenseGroup.put(key, (String)licenseGroupV1.get(key.toString()));
            }
            return licenseGroup;
        }
        catch (Exception e) {
            logger.error("LicenseServiceImpl.getHasBoughtLicGroup method error", (Throwable)e);
        }
        return licenseGroup;
    }

    public Set<String> getHasBoughtBizApp() {
        Map<Long, String> hasBoughtLicGroup = this.getHasBoughtLicGroup();
        QFilter filter = new QFilter("licgroup", "in", hasBoughtLicGroup.keySet());
        DynamicObjectCollection bizAppCol = QueryServiceHelper.query((String)"lic_appgroup", (String)"bizapp", (QFilter[])new QFilter[]{filter});
        if (bizAppCol == null || bizAppCol.isEmpty()) {
            return new HashSet<String>(0);
        }
        HashSet<String> result = new HashSet<String>(bizAppCol.size());
        for (DynamicObject bizAppObj : bizAppCol) {
            result.add(bizAppObj.getString("bizapp"));
        }
        return result;
    }

    public Set<String> getAvailableApps() {
        String key;
        String cacheType = LicenseCacheMrg.getType4AvailableApp();
        String availableAppCacheStr = LicenseCacheMrg.getCache((String)cacheType, (String)(key = "AvailableApp" + RequestContext.get().getAccountId()));
        if (StringUtils.isNotBlank((CharSequence)availableAppCacheStr)) {
            return (Set)SerializationUtils.fromJsonString((String)availableAppCacheStr, Set.class);
        }
        DynamicObjectCollection appWhiteList = QueryServiceHelper.query((String)"lic_appwhitelist", (String)"bizapp", null);
        if (appWhiteList == null || appWhiteList.isEmpty()) {
            return this.getHasBoughtBizApp();
        }
        HashSet<String> result = new HashSet<String>(appWhiteList.size());
        for (DynamicObject appObj : appWhiteList) {
            result.add(appObj.getString("bizapp"));
        }
        result.addAll(this.getHasBoughtBizApp());
        LicenseCacheMrg.putCache((String)cacheType, (String)key, (String)SerializationUtils.toJsonString(result));
        return result;
    }

    public int getRemainNumber(Object groupId) {
        logger.info("LicenseServiceImpl.getRemainNumber() - groupId : " + groupId);
        if (groupId == null) {
            return 0;
        }
        Long groupIdL = Long.valueOf(groupId.toString());
        Integer remainCount = 0;
        if (!LicenseCache.isCtrlAmountIgnoreTime()) {
            Map licAllocateNumberByGroupIds = LicenseUserRelEngine.getLicAllocateNumberByGroupIds(Collections.singletonList(groupIdL));
            return this.getTotalNumber(groupId) - (Integer)licAllocateNumberByGroupIds.get(groupIdL);
        }
        String sql = "select fremaincount from t_lic_licensedetail where fgroupid = ? ";
        remainCount = (Integer)DB.query((DBRoute)DBRoute.base, (String)sql, (Object[])new Object[]{groupIdL}, k -> {
            int remain = 0;
            while (k.next()) {
                remain = k.getInt("fremaincount");
            }
            return remain;
        });
        Integer need = (Integer)DB.query((DBRoute)DBRoute.base, (String)"select count(1) ucount from t_lic_userlicensegroup where fgroupid = ? and fsyncstatus = '2' ", (Object[])new Object[]{groupIdL}, k -> {
            int count = 0;
            while (k.next()) {
                count = k.getInt("ucount");
            }
            return count;
        });
        if (remainCount - need > 0) {
            return remainCount - need;
        }
        return 0;
    }

    public String getLicenseType() {
        String softwareName;
        if (Boolean.getBoolean("isMC")) {
            return "";
        }
        String waterMark = this.getWaterMark();
        if (!StringUtils.isBlank((CharSequence)waterMark)) {
            return waterMark;
        }
        Map<String, String> productInfo = this.getProductInfo();
        if (productInfo != null && "kingdee cloud 5.0 for education".equals(softwareName = productInfo.get("softwarename"))) {
            return ResManager.loadKDString((String)"\u6559\u5b66\u7248\u8bb8\u53ef", (String)"LicenseServiceImpl_130", (String)"bos-mservice-license", (Object[])new Object[0]);
        }
        return "";
    }

    private boolean isShowWatermark() {
        Map cache = LicenseCache.getTempLicenseCache();
        String isTemLic = (String)cache.get("isTemLic");
        String isShowWaterMark = (String)cache.get("isShowWaterMark");
        if ("1".equals(isTemLic) && StringUtils.isNotBlank((CharSequence)isShowWaterMark) && "0".equals(isShowWaterMark)) {
            return false;
        }
        return "1".equals(isTemLic);
    }

    private String getWaterMark() {
        String waterMark;
        Map cache = LicenseCache.getTempLicenseCache();
        String isShowWaterMark = (String)cache.get("isShowWaterMark");
        if (StringUtils.isBlank((CharSequence)isShowWaterMark) || "0".equals(isShowWaterMark)) {
            return "";
        }
        String sceneType = (String)cache.get("sceneType");
        if (StringUtils.isBlank((CharSequence)sceneType)) {
            return "";
        }
        switch (sceneType) {
            case "DEV": {
                waterMark = ResManager.loadKDString((String)"\u5f00\u53d1\u73af\u5883", (String)"LicenseServiceImpl_148", (String)"bos-mservice-license", (Object[])new Object[0]);
                break;
            }
            case "SIT": {
                waterMark = ResManager.loadKDString((String)"\u96c6\u6210\u6d4b\u8bd5\u73af\u5883", (String)"LicenseServiceImpl_149", (String)"bos-mservice-license", (Object[])new Object[0]);
                break;
            }
            case "UAT": {
                waterMark = ResManager.loadKDString((String)"\u7528\u6237\u9a8c\u6536\u6d4b\u8bd5\u73af\u5883", (String)"LicenseServiceImpl_150", (String)"bos-mservice-license", (Object[])new Object[0]);
                break;
            }
            case "TEMP": {
                waterMark = ResManager.loadKDString((String)"\u4e34\u65f6\u8bb8\u53ef", (String)"LicenseServiceImpl_83", (String)"bos-mservice-license", (Object[])new Object[0]);
                break;
            }
            case "PRD": {
                waterMark = "";
                break;
            }
            default: {
                waterMark = "";
            }
        }
        return waterMark;
    }

    public Set<String> getLicenseModules() {
        return LicenseCache.getLicenseModules();
    }

    public LicenseCheckResult checkLicenseModules(String bizAppId) {
        logger.info("LicenseServiceImpl.checkLicenseModules() bizAppId : " + bizAppId);
        LicenseCheckResult result = new LicenseCheckResult(Boolean.FALSE, "");
        Set<String> licenseModules = this.getLicenseModules();
        if (licenseModules == null || licenseModules.isEmpty() || !licenseModules.contains(bizAppId)) {
            AppInfo appInfo = null;
            try {
                try {
                    appInfo = AppMetadataCache.getAppInfo((String)bizAppId);
                }
                catch (Exception e) {
                    appInfo = AppMetadataCache.getAppInfo((String)bizAppId.toLowerCase(Locale.ENGLISH));
                }
            }
            catch (Exception e) {
                logger.error("\u7f16\u7801/ID\u4e3a" + bizAppId + "\u7684\u5e94\u7528\u4e0d\u5b58\u5728\u3002", (Throwable)e);
            }
            String appName = bizAppId;
            if (appInfo != null) {
                appName = appInfo.getName().getLocaleValue();
            }
            result.setMsg(String.format(ResManager.loadKDString((String)"\u65e0%1$s\u5e94\u7528\u6a21\u5757\u8bb8\u53ef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"LicenseServiceImpl_119", (String)"bos-mservice-license", (Object[])new Object[0]), appName));
        } else {
            result.setHasLicense(Boolean.TRUE);
        }
        return result;
    }

    public void addAssignLog(LicenseAssignLog LicenseAssignLog2) {
        this.addAssignLogs(Collections.singletonList(LicenseAssignLog2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAssignLogs(List<LicenseAssignLog> LicenseAssignLogs) {
        if (null != LicenseAssignLogs && !LicenseAssignLogs.isEmpty()) {
            try (MessagePublisher pub = MQFactory.get().createSimplePublisher(FMODEL_TYPE_BASE_FORM, "license_service");){
                int maxMQPulishCount = LicenseUtil.getMaxMQPulishCount();
                int maxSize = maxMQPulishCount / 100;
                for (int i = 0; i < LicenseAssignLogs.size(); i += maxSize) {
                    int end = Math.min(LicenseAssignLogs.size(), i + maxSize);
                    List<LicenseAssignLog> subAssignLogs = LicenseAssignLogs.subList(i, end);
                    pub.publish(subAssignLogs);
                }
            }
        }
    }

    private static String getVerifyPubKey() {
        return EncryptUtil.getKey((String)"LicenseConfigPublicKey_METADATA");
    }

    public String encrypt(String plaintext) {
        return LicenseConfigHelper.StringToEncryString((String)plaintext);
    }

    public String decrypt(String ciphertext) {
        return LicenseConfigHelper.EncryStringToString((String)ciphertext);
    }

    public Date getExpireDateByGroup(Long groupId) {
        return LicenseCache.getExpireDateByGroup((Long)groupId);
    }

    public List<Map<String, Object>> getLicenseExpireNotice() {
        ArrayList<Map<String, Object>> msgs = new ArrayList<Map<String, Object>>(2);
        boolean isExpire = false;
        String langName = RequestContext.get().getLang().name();
        StringBuilder sql = new StringBuilder();
        sql.append("select tll.fexpdate expire_date, tlil.fname fname, tll.fproductid productId, tli.fid prodid , tli.fprodname prodname, tll.fproductversion prodver ");
        sql.append("from t_lic_license tll ");
        sql.append("left join t_lic_isvprod tli on tll.fprodid = tli.fid ");
        sql.append("left join t_lic_isvprod_l tlil on tli.fid = tlil.fid ");
        sql.append(String.format(" and tlil.flocaleid = '%s' ", langName));
        sql.append(" order by expire_date asc ");
        boolean hasLic = false;
        try (DataSet expireDataAndName = DB.queryDataSet((String)"select_expire_date", (DBRoute)DBRoute.basedata, (String)sql.toString());){
            while (expireDataAndName.hasNext()) {
                hasLic = true;
                Row row = expireDataAndName.next();
                Timestamp expDate = row.getTimestamp("expire_date");
                String prodid = row.getString("prodid");
                String name = row.getString("fname");
                String version = row.getString("prodver");
                int toExpireDays = LicenseExpireUtil.differentDays((Date)new Date(), (Date)expDate);
                this.addMsg(msgs, null == name ? row.getString("prodname") : name, toExpireDays);
                if (!"1I6COPY94UBO".equals(prodid) || !(Float.parseFloat(version) < 5.0f)) continue;
                this.addMsg(msgs, ResManager.loadKDString((String)"\u91d1\u8776\u4e91\u00b7\u661f\u701a", (String)"LicenseServiceImpl_127", (String)"bos-mservice-license", (Object[])new Object[0]), toExpireDays);
            }
        }
        catch (Exception e) {
            logger.error("GetLicenseExpireNotice throw Exception", (Throwable)e);
        }
        if (!CollectionUtils.isEmpty(msgs) && (Integer)((Map)msgs.get(msgs.size() - 1)).get("days") < 0) {
            isExpire = true;
        }
        if (!hasLic) {
            HashMap<String, Object> result = new HashMap<String, Object>(3);
            result.put("msg", ResManager.loadKDString((String)"\u672a\u8d2d\u4e70\u8bb8\u53ef\uff0c\u8bf7\u5148\u8d2d\u4e70\u8bb8\u53ef\u5e76\u8fdb\u884c\u540c\u6b65\u3002", (String)"LicenseServiceImpl_125", (String)"bos-mservice-license", (Object[])new Object[0]));
            result.put("overTime", false);
            result.put("days", 0);
            msgs.add(result);
        }
        if (isExpire || !hasLic) {
            return msgs;
        }
        AdminInfo administratorInfo = LicenseExpireUtil.getAdministratorInfo();
        if (null == administratorInfo || !administratorInfo.getUserid().equals(RequestContext.get().getCurrUserId())) {
            return new ArrayList<Map<String, Object>>(2);
        }
        return msgs;
    }

    private void addMsg(List<Map<String, Object>> msgs, String name, int expireDays) {
        HashMap<String, Object> result = new HashMap<String, Object>(3);
        if (expireDays < 0) {
            result.put("msg", ResManager.loadKDString((String)"%s\u8bb8\u53ef\u5df2\u5230\u671f\uff0c\u8bf7\u5c3d\u5feb\u8d2d\u4e70\u3002\u5230\u671f\u540e\uff0c\u60a8\u4ecd\u53ef\u767b\u5f55\uff0c\u4f46\u65e0\u6cd5\u4f7f\u7528\u53d7\u8bb8\u53ef\u63a7\u5236\u7684\u529f\u80fd\u3002", (String)"LicenseServiceImpl_123", (String)"bos-mservice-license", (Object[])new Object[]{name}));
        } else if (expireDays == 0) {
            result.put("msg", ResManager.loadKDString((String)"%s\u8bb8\u53ef\u4eca\u5929\u5230\u671f\uff0c\u8bf7\u53ca\u65f6\u7eed\u8d39\u3002", (String)"LicenseServiceImpl_128", (String)"bos-mservice-license", (Object[])new Object[]{name}));
        } else if (expireDays <= 30) {
            result.put("msg", String.format(ResManager.loadKDString((String)"%1$s\u8bb8\u53ef\u8fd8\u6709%2$s\u5929\u5230\u671f\uff0c\u8bf7\u53ca\u65f6\u7eed\u8d39\u3002", (String)"LicenseServiceImpl_124", (String)"bos-mservice-license", (Object[])new Object[0]), name, expireDays));
        }
        result.put("overTime", true);
        result.put("days", expireDays);
        msgs.add(result);
    }

    public boolean updateLicGroupAssignCount(Map<Long, Integer> groupIdAndCount) {
        if (CollectionUtils.isEmpty(groupIdAndCount)) {
            return false;
        }
        logger.info("\u7279\u6027\u5206\u7ec4\u53cd\u5199 groupIdAndCount : " + groupIdAndCount);
        try {
            DynamicObject[] load;
            for (DynamicObject dynamicObject : load = BusinessDataServiceHelper.load((String)"lic_license", (String)"lic_licensedetail.assignedcount,lic_licensedetail.group,lic_licensedetail.totalcount,lic_licensedetail.group.type,lic_licensedetail.remaincount", null)) {
                DynamicObjectCollection licenseDetails = dynamicObject.getDynamicObjectCollection("lic_licensedetail");
                for (DynamicObject licenseDetail : licenseDetails) {
                    Object groupType = licenseDetail.get("group.type");
                    if (null == groupType || !SYNCSTATUS.equals(groupType)) continue;
                    Long groupId = (Long)licenseDetail.get("group.id");
                    Integer count = groupIdAndCount.get(groupId);
                    Object total = licenseDetail.get("totalcount");
                    if (null == count || null == total) continue;
                    Integer totalcount = Integer.valueOf(total.toString());
                    int remainCount = totalcount - count;
                    if (count > totalcount) {
                        logger.warn("\u8bb8\u53ef\u5206\u7ec4\uff08id\uff1a" + groupId + "\uff09\u5df2\u5206\u914d\u6570\u5927\u4e8e\u603b\u6570" + total);
                        remainCount = 0;
                    }
                    licenseDetail.set("assignedcount", (Object)count);
                    licenseDetail.set("remaincount", (Object)remainCount);
                }
            }
            SaveServiceHelper.save((DynamicObject[])load);
            return true;
        }
        catch (Exception e) {
            logger.error("\u53cd\u5199\u8bb8\u53ef\u8be6\u60c5\u51fa\u9519", (Throwable)e);
            return false;
        }
    }

    private static boolean isIgnoreLicense(FormShowParameter showParameter, FormShowParameter parentShowParameter, String entityTypeId, int count) {
        String modelType;
        if (null == showParameter) {
            return false;
        }
        PermissionControlType permControlType = EntityMetadataCache.getPermissionControlType((String)entityTypeId);
        if (permControlType != null) {
            long currUserId = RequestContext.get().getCurrUserId();
            if (permControlType.isAnonymousUserControl() && (currUserId == -1L || currUserId == 0L)) {
                return true;
            }
        }
        if (ignoreModelTypes.contains(modelType = FormMetadataCache.getFormConfig((String)entityTypeId).getModelType())) {
            return true;
        }
        if (IGNORE_MODEL_PARAM.equals(modelType) && null != parentShowParameter && ("bos_param_console".equals(parentShowParameter.getFormId()) || "bos_parameterconsole".equals(parentShowParameter.getFormId()) || "bos_billparamset".equals(parentShowParameter.getFormId()))) {
            return true;
        }
        if ("lic_updatelicense".equals(showParameter.getFormId())) {
            return true;
        }
        if ("lic_licchecknotice".equals(entityTypeId) || "lic_licchecknotice_m".equals(entityTypeId)) {
            return true;
        }
        Object param = showParameter.getCustomParam("isIgnoreLicense");
        Boolean isIgnoreLicense = param instanceof String ? Boolean.valueOf("true".equals(param)) : (Boolean)param;
        if (isIgnoreLicense != null && isIgnoreLicense.booleanValue()) {
            String scene = (String)showParameter.getCustomParam("scene");
            if ("wf_mbillsummary_cfg".equals(scene)) {
                return true;
            }
            if (IGNORE_LICENSE_WHITE_LIST.contains(entityTypeId)) {
                return true;
            }
            if (parentShowParameter != null) {
                String parentFormId = parentShowParameter.getFormId();
                if (IGNORE_LICENSE_WHITE_LIST.contains(parentFormId)) {
                    return true;
                }
                if ("bos_ctbotp_lookuptracker".equals(parentFormId)) {
                    return true;
                }
                if ("botp_lookuptracker".equals(parentFormId)) {
                    return true;
                }
                if ("botp_convertop".equals(parentFormId) && showParameter instanceof ListShowParameter) {
                    return true;
                }
                if (LicenseServiceImpl.isPush(showParameter, parentShowParameter, entityTypeId)) {
                    return true;
                }
                if ("gl_voucher".equals(parentFormId) || "gl_voucher".equals(entityTypeId)) {
                    return true;
                }
                if ("gl_vchralt_form".equals(parentFormId) || "gl_vchralt_form".equals(entityTypeId)) {
                    return true;
                }
            }
        }
        if (parentShowParameter != null) {
            String parentFormId = parentShowParameter.getFormId();
            if ("ide_formdesigner".equals(parentFormId) || "bos_devp_pagepreview".equals(parentFormId) || "bos_devportal_bizpagelist".equals(parentFormId) || "bos_mobilepreview".equals(parentFormId) || "bos_devpn_formdesign".equals(parentFormId) || "devpn_formpreview".equals(parentFormId) || "bos_devn_appdetail".equals(parentFormId) || "bos_bizextpreview".equals(parentFormId) || IGNORE_LICENSE_WHITE_XK_LIST.contains(parentFormId)) {
                return true;
            }
            if (++count >= 3) {
                return false;
            }
            try {
                showParameter = parentShowParameter;
                parentShowParameter = SessionManager.getCurrent().getFormShowParameter(parentShowParameter.getParentPageId());
                return LicenseServiceImpl.isIgnoreLicense(showParameter, parentShowParameter, entityTypeId, count);
            }
            catch (Exception e) {
                logger.error("Get ParentShowParameter Exception.", (Throwable)e);
            }
        }
        return false;
    }

    private static boolean isPush(FormShowParameter showParameter, FormShowParameter parentShowParameter, String entityTypeId) {
        if (parentShowParameter == null) {
            return false;
        }
        IFormView parentView = SessionManager.getCurrent().getViewNoPlugin(parentShowParameter.getPageId());
        if (parentView == null) {
            return false;
        }
        IPageCache pageCache = (IPageCache)parentView.getService(IPageCache.class);
        String convertResultJson = pageCache.get(ConvPageCacheKey_ConvertOperationResult);
        return StringUtils.isNotBlank((CharSequence)convertResultJson);
    }

    private static String getEntityTypeId(FormShowParameter showParameter) {
        String formId;
        String entityTypeId = null;
        entityTypeId = showParameter instanceof ListShowParameter ? (StringUtils.isBlank((CharSequence)(formId = ((ListShowParameter)showParameter).getBillFormId())) ? showParameter.getFormId() : FormMetadataCache.getFormConfig((String)formId).getEntityTypeId()) : (showParameter instanceof BillShowParameter || showParameter instanceof MobileFormShowParameter || showParameter instanceof MobileBillShowParameter ? showParameter.getFormConfig().getEntityTypeId() : showParameter.getFormId());
        return entityTypeId;
    }

    public Map<String, Date> getGroupTimeRange(Long groupId) {
        HashMap<String, Date> result = new HashMap(2);
        if (null == groupId || groupId == 0L) {
            String sql = "select factivedate BEGINDATE,fexpdate ENDDATE from t_lic_license";
            result = (Map)DB.query((DBRoute)DBRoute.base, (String)sql, (ResultSetHandler)new ResultSetHandler<Map<String, Date>>(){

                public Map<String, Date> handle(ResultSet rs) throws Exception {
                    HashMap<String, Date> resultMap = new HashMap<String, Date>(2);
                    if (rs.next()) {
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        String beginDateStr = rs.getString("BEGINDATE");
                        String endDateStr = rs.getString("ENDDATE");
                        resultMap.put("beginDate", sdf.parse(beginDateStr));
                        resultMap.put("expireDate", sdf.parse(endDateStr));
                    }
                    return resultMap;
                }
            });
            return result;
        }
        String sql = "SELECT ld.fbegindate BEGINDATE, ld.fenddate ENDDATE FROM T_LIC_LICENSEDETAIL ld INNER JOIN T_LIC_LICENSE l ON l.FID = ld.FID AND ld.fgroupid = " + groupId;
        result = (Map)DB.query((DBRoute)DBRoute.base, (String)sql, (ResultSetHandler)new ResultSetHandler<Map<String, Date>>(){

            public Map<String, Date> handle(ResultSet rs) throws Exception {
                HashMap<String, Date> resultMap = new HashMap<String, Date>(2);
                if (rs.next()) {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    String beginDateStr = rs.getString("BEGINDATE");
                    String endDateStr = rs.getString("ENDDATE");
                    resultMap.put("beginDate", sdf.parse(beginDateStr));
                    resultMap.put("expireDate", sdf.parse(endDateStr));
                }
                return resultMap;
            }
        });
        return result;
    }

    public void addUserAllUserLicGroup(List<Long> userIds) {
        if (!LicenseServiceImpl.isEnableAutoAssignAllUserLic()) {
            return;
        }
        if (userIds == null || userIds.isEmpty()) {
            return;
        }
        logger.info("addUserAllUserLicGroup userIds- " + userIds);
        List alluserlicegroups = (List)LicenseServiceImpl.getParameterFromCache("alluserlicegroup");
        HashSet<Long> groupIdSet = new HashSet<Long>(2);
        for (HashMap group : alluserlicegroups) {
            Map groupInfo = (Map)group.get("fbasedataid");
            Long groupId = Long.valueOf(groupInfo.get("id").toString());
            groupIdSet.add(groupId);
        }
        AddUserLicGroupThread thread = new AddUserLicGroupThread(userIds, groupIdSet.toArray(new Long[0]));
        ThreadPools.executeOnceIncludeRequestContext((String)"addUsersLicGroup", (Runnable)thread);
    }

    public boolean isSingleOrgManageMode() {
        boolean isSingleOrgManageMode = false;
        int modeType = this.getModeType();
        if (modeType == 1) {
            isSingleOrgManageMode = true;
            return isSingleOrgManageMode;
        }
        if (modeType != 4) {
            isSingleOrgManageMode = false;
            return isSingleOrgManageMode;
        }
        Object enablemultiorg = SystemParamServiceHelper.loadPublicParameterFromCache((String)"enablemultiorg");
        if (enablemultiorg == null || enablemultiorg instanceof String && StringUtils.isEmpty((CharSequence)((String)enablemultiorg))) {
            isSingleOrgManageMode = false;
            return isSingleOrgManageMode;
        }
        if (enablemultiorg instanceof Boolean && !((Boolean)enablemultiorg).booleanValue()) {
            isSingleOrgManageMode = true;
            return isSingleOrgManageMode;
        }
        isSingleOrgManageMode = false;
        return isSingleOrgManageMode;
    }

    public List<LicenseError> addUserGroupById(Set<Long> userIds, Set<Long> groupIds, Long legalPersonID) {
        return UserLicGroupUtil.addUserGroupsById(userIds, groupIds, (Long)legalPersonID);
    }

    public List<LicenseError> deleteUserGroupById(Set<Long> userIds, Set<Long> groupIds, Long legalPersonID) {
        return UserLicGroupUtil.deleteUserGroupByGroupId(userIds, groupIds, (Long)legalPersonID);
    }

    public Map<Long, Integer> getUsedQuantityByGroups(List<Long> groupIds) {
        if (groupIds == null || groupIds.isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        boolean highAvailabilityMode = LicenseUtil.isHighAvailabilityMode();
        boolean isCtrlAmountLic = LicenseCache.isCtrlAmountIgnoreTime();
        boolean isPubTenantType = Boolean.parseBoolean(this.getPubTenantType());
        Map<Long, Integer> result = groupIds.stream().collect(Collectors.toMap(k -> k, v -> 0, (k, v) -> k));
        DynamicObject[] licenses = BusinessDataServiceHelper.load((String)"lic_license", (String)"group, assignedCount", null);
        if (licenses == null || licenses.length == 0) {
            return result;
        }
        HashSet<Long> registerGroupSet = new HashSet<Long>(groupIds.size());
        for (DynamicObject license : licenses) {
            DynamicObjectCollection licensedetails = license.getDynamicObjectCollection("lic_licensedetail");
            for (DynamicObject licensedetail : licensedetails) {
                DynamicObject groupObj = licensedetail.getDynamicObject("group");
                Long groupId = groupObj.getLong("id");
                if (!groupIds.contains(groupId)) continue;
                if (groupObj.getString("type").equals("1")) {
                    registerGroupSet.add(groupId);
                }
                int assignCount = licensedetail.getInt("assignedCount");
                result.put(groupId, assignCount);
            }
        }
        if (highAvailabilityMode) {
            if (isCtrlAmountLic || isPubTenantType) {
                result.putAll(LicenseGroupUtil.getCurAccountAssignByGroupIds(registerGroupSet.stream().map(String::valueOf).collect(Collectors.toList())));
            } else {
                result.putAll(LicenseUserRelEngine.getLicAllocateNumberByGroupIds(new ArrayList(registerGroupSet)));
            }
        }
        return result;
    }

    public Object getLicenseConfig() {
        return LicenseConfigHelper.getLicenseConfigImpl();
    }

    public List<Map<String, String>> getProdInfosByGroup(String groupNumber) {
        if (groupNumber == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Map<String, String>> productInfos = new ArrayList<Map<String, String>>(2);
        Map loadFromCache = BusinessDataServiceHelper.loadFromCache((String)"lic_license", (String)"softwarename,type,prodinstcode,product,productno,softwarecode,expdate,productversion,prodid", (QFilter[])new QFilter[]{new QFilter("lic_licensedetail.group.number", "=", (Object)groupNumber)});
        for (Map.Entry entry : loadFromCache.entrySet()) {
            DynamicObject product;
            DynamicObject dynamicObject = (DynamicObject)entry.getValue();
            HashMap<String, String> productInfo = new HashMap<String, String>(16);
            productInfo.put("prodInstCode", dynamicObject.getString("prodinstcode"));
            String softwareName = dynamicObject.getString("softwarename");
            productInfo.put("softwarename", softwareName);
            productInfo.put("productID", dynamicObject.getString("product"));
            productInfo.put("productNo", dynamicObject.getString("productno"));
            productInfo.put("softwareCode", dynamicObject.getString("softwarecode"));
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            Date expDate = dynamicObject.getDate("expdate");
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(expDate);
            productInfo.put("expdate", sdf.format(dynamicObject.getDate("expdate")));
            if (calendar.get(1) < 2099) {
                productInfo.put("expdateDes", sdf.format(dynamicObject.getDate("expdate")));
            } else {
                productInfo.put("expdateDes", ResManager.loadKDString((String)"\u4e0d\u9650", (String)"LicenseServiceImpl_129", (String)"bos-mservice-license", (Object[])new Object[0]));
            }
            productInfo.put("type", dynamicObject.getString("type"));
            String prodVer = dynamicObject.getString("productversion");
            productInfo.put("productversion", prodVer);
            String productName = ResManager.loadKDString((String)"\u82cd\u7a79", (String)"LicenseServiceImpl_116", (String)"bos-mservice-license", (Object[])new Object[0]);
            if (softwareName.startsWith("kingdee eas nextcloud saas")) {
                productName = ResManager.loadKDString((String)"\u661f\u701a", (String)"LicenseServiceImpl_117", (String)"bos-mservice-license", (Object[])new Object[0]);
            }
            productInfo.put("productName", productName);
            String productId = "";
            if (softwareName.equals("kingdee cloud 5.0 for education")) {
                productId = "1I6COPY94UBO";
            }
            if ((product = dynamicObject.getDynamicObject("prodid")) != null) {
                productId = product.getPkValue().toString();
            }
            productInfo.put("prodid", productId);
            productInfos.add(productInfo);
        }
        return productInfos;
    }

    private boolean isLicenseGroupUDD(Long groupID) {
        return 999999 == this.getTotalNumber(groupID);
    }

    public boolean isIsv(String entityTypeId) {
        if (StringUtils.isBlank((CharSequence)entityTypeId)) {
            return false;
        }
        String isv = "";
        DynamicObject formMeta = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_formmeta", (String)"number,isv", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)entityTypeId)});
        if (formMeta != null) {
            isv = formMeta.getString("isv");
        }
        return this.checkIsvProd(isv);
    }

    public Map<Long, LicenseGroupInfo> getSubscribedGroupInfo(List<Long> groupIds) {
        HashMap<Long, LicenseGroupInfo> result = new HashMap<Long, LicenseGroupInfo>(CollectionUtils.isEmpty(groupIds) ? 16 : groupIds.size());
        DynamicObject[] licenses = BusinessDataServiceHelper.load((String)"lic_license", (String)"group,totalcount,assignedcount", null);
        if (licenses == null || licenses.length == 0) {
            return result;
        }
        HashSet<Long> registerGroupSet = new HashSet<Long>(result.size());
        String noLimitStr = ResManager.loadKDString((String)"\u4e0d\u9650", (String)"LicenseServiceImpl_129", (String)"bos-mservice-license", (Object[])new Object[0]);
        for (DynamicObject license : licenses) {
            DynamicObjectCollection licenseDetailDoc = license.getDynamicObjectCollection("lic_licensedetail");
            for (DynamicObject licenseDetailObj : licenseDetailDoc) {
                DynamicObject groupObj = licenseDetailObj.getDynamicObject("group");
                if (groupObj == null) continue;
                Long groupId = groupObj.getLong("id");
                if (!CollectionUtils.isEmpty(groupIds) && !groupIds.contains(groupId)) continue;
                if (groupObj.getString("type").equals("1")) {
                    registerGroupSet.add(groupId);
                }
                LicenseGroupInfo licenseGroupInfo = result.computeIfAbsent(groupId, k -> new LicenseGroupInfo());
                licenseGroupInfo.setId(groupId);
                licenseGroupInfo.setName(groupObj.getLocaleString("name").getLocaleValue());
                licenseGroupInfo.setType(groupObj.getString("type"));
                long totalCount = 0L;
                long assignCount = 0L;
                long remainCount = 0L;
                if ("16".equals(String.valueOf(groupId))) {
                    long total = licenseDetailObj.getLong("totalcount");
                    totalCount = total * 10000L;
                    SmsUsingQuantities smsUsingQuantitySummary = MessageCenterServiceHelper.getSmsUsingQuantitySummary();
                    Long successSum = smsUsingQuantitySummary.getSuccessSum();
                    if (null != successSum) {
                        assignCount = successSum;
                    }
                    if ((remainCount = totalCount - assignCount) < 0L) {
                        remainCount = 0L;
                    }
                } else {
                    totalCount = licenseDetailObj.getLong("totalcount");
                    remainCount = totalCount - (assignCount = licenseDetailObj.getLong("assignedcount"));
                    if (remainCount < 0L) {
                        remainCount = 0L;
                    }
                }
                licenseGroupInfo.setTotalCount(Long.valueOf(totalCount));
                licenseGroupInfo.setUsedCount(Long.valueOf(assignCount));
                licenseGroupInfo.setRemainCount(Long.valueOf(remainCount));
                boolean isLicenseGroupUDD = 999999L == totalCount;
                licenseGroupInfo.setUDD(Boolean.valueOf(isLicenseGroupUDD));
                licenseGroupInfo.setTotalCountStr(isLicenseGroupUDD ? noLimitStr : "");
                licenseGroupInfo.setUsedCountStr(isLicenseGroupUDD ? "-" : "");
                licenseGroupInfo.setRemainCountStr(isLicenseGroupUDD ? noLimitStr : "");
            }
        }
        Map groupId2AssignCount = LicenseUserRelEngine.getLicAllocateNumberByGroupIds(new ArrayList(registerGroupSet));
        for (Map.Entry entry : result.entrySet()) {
            Long groupID = (Long)entry.getKey();
            Integer assignCount = (Integer)groupId2AssignCount.get(groupID);
            if (assignCount == null) continue;
            Long assignCountLong = Long.parseLong(String.valueOf(assignCount));
            LicenseGroupInfo licenseGroupInfo = (LicenseGroupInfo)entry.getValue();
            long remainCount = licenseGroupInfo.getTotalCount() - assignCountLong;
            if (remainCount < 0L) {
                remainCount = 0L;
            }
            licenseGroupInfo.setUsedCount(assignCountLong);
            licenseGroupInfo.setRemainCount(Long.valueOf(remainCount));
        }
        return result;
    }

    public FormShowParameter buildNoticeFormShowParameter(String title, List<String> details) {
        MobileFormShowParameter licCheckLogShowParam;
        if (this.isMobilForm(null)) {
            licCheckLogShowParam = new MobileFormShowParameter();
            HashMap<String, String> param = new HashMap<String, String>(2);
            param.put("position", "center");
            licCheckLogShowParam.getOpenStyle().setCustParam(param);
            licCheckLogShowParam.setFormId("lic_licchecknotice_m");
        } else {
            licCheckLogShowParam = new FormShowParameter();
            licCheckLogShowParam.setFormId("lic_licchecknotice");
        }
        licCheckLogShowParam.getOpenStyle().setShowType(ShowType.Modal);
        if (StringUtils.isBlank((CharSequence)title)) {
            title = ResManager.loadKDString((String)"\u6ca1\u6709\u8bb8\u53ef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"LicenseServiceImpl_166", (String)"bos-mservice-license", (Object[])new Object[0]);
        }
        licCheckLogShowParam.setCustomParam("cancelmessage", (Object)title);
        if (!CollectionUtils.isEmpty(details)) {
            licCheckLogShowParam.setCustomParam("messages", details);
        }
        return licCheckLogShowParam;
    }

    static {
        IGNORE_LICENSE_WHITE_XK_LIST.add("moa_wftreelist");
        IGNORE_LICENSE_WHITE_XK_LIST.add("moa_wflist_mob");
        IGNORE_LICENSE_WHITE_XK_LIST.add("moa_wfapprovalpagedetail");
        IGNORE_LICENSE_WHITE_XK_LIST.add("moa_wflookuptrackdetail");
        IGNORE_LICENSE_WHITE_XK_LIST.add("qcmp_homepage");
        IGNORE_LICENSE_WHITE_XK_LIST.add("osr_homepage");
        IGNORE_LICENSE_WHITE_XK_LIST.add("barcm_scanedit_nosrc_m");
        IGNORE_LICENSE_WHITE_XK_LIST.add("barcm_scanedit_src_m");
        IGNORE_LICENSE_WHITE_XK_LIST.add("barcm_scanexcqty_m");
        IGNORE_LICENSE_WHITE_XK_LIST.add("mscm_routepage");
        IGNORE_LICENSE_WHITE_LIST.add("wf_msg_center");
        IGNORE_LICENSE_WHITE_LIST.add("wf_msg_content");
        IGNORE_LICENSE_WHITE_LIST.add("wf_apphome_new");
        IGNORE_LICENSE_WHITE_LIST.add("wf_approvalpage_bac");
        IGNORE_LICENSE_WHITE_LIST.add("wf_approvalpageview_bac");
        IGNORE_LICENSE_WHITE_LIST.add("wf_approvalbill");
        IGNORE_LICENSE_WHITE_LIST.add("wf_approvalbillmob");
        IGNORE_LICENSE_WHITE_LIST.add("wf_approvalpagemobile_bac");
        IGNORE_LICENSE_WHITE_LIST.add("wf_approvalpage_mob");
        IGNORE_LICENSE_WHITE_LIST.add("wf_approvalmobileview_bac");
        IGNORE_LICENSE_WHITE_LIST.add("wf_approvalpageview_mob");
        IGNORE_LICENSE_WHITE_LIST.add("wf_approvaldealpagemobile");
        IGNORE_LICENSE_WHITE_LIST.add("wf_approvalopiniondet_mob");
        IGNORE_LICENSE_WHITE_LIST.add("wf_approvalprogresspage");
        IGNORE_LICENSE_WHITE_LIST.add("wf_approvalrejectmobile");
        IGNORE_LICENSE_WHITE_LIST.add("wf_feedbackmobile");
        IGNORE_LICENSE_WHITE_LIST.add("wf_viewflowchartmobile");
        IGNORE_LICENSE_WHITE_LIST.add("wf_openbills");
        IGNORE_LICENSE_WHITE_LIST.add("wf_testinginput");
        IGNORE_LICENSE_WHITE_LIST.add("wf_approvalpageud_tile");
        IGNORE_LICENSE_WHITE_LIST.add("wf_approvalpageud_tifull");
        IGNORE_LICENSE_WHITE_LIST.add("wf_approvalpageud_float");
        IGNORE_LICENSE_WHITE_LIST.add("wf_approvalpageud_flofull");
        IGNORE_LICENSE_WHITE_LIST.add("wf_approvalbill_view");
        IGNORE_LICENSE_WHITE_LIST.add("wf_approvalbillmob_view");
        IGNORE_LICENSE_WHITE_LIST.add("bpm_apphome_grid");
        IGNORE_LICENSE_WHITE_LIST.add("bpm_billrelation_graph");
        IGNORE_LICENSE_WHITE_LIST.add("bpm_viewflowchart");
        IGNORE_LICENSE_WHITE_LIST.add("task_approval_spilt");
        IGNORE_LICENSE_WHITE_LIST.add("task_quality_docheck");
        IGNORE_LICENSE_WHITE_LIST.add("task_quality_dorectify");
        IGNORE_LICENSE_WHITE_LIST.add("task_quality_doreview");
        IGNORE_LICENSE_WHITE_LIST.add("task_approve");
        IGNORE_LICENSE_WHITE_LIST.add("eb_relevanceanalyze");
        IGNORE_LICENSE_WHITE_LIST.add("eb_relexecuterecord");
        IGNORE_LICENSE_WHITE_LIST.add("eb_relexecuterecord_nbg");
        IGNORE_LICENSE_WHITE_LIST.add("eb_bgavailbalance");
    }
}

