/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.license.util;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.form.FormMetadataCache;
import kd.bos.license.api.ILicenseService;
import kd.bos.license.api.LicenseAssignLog;
import kd.bos.license.bean.LicenseGroupCtrl;
import kd.bos.license.service.cache.LicenseCache;
import kd.bos.license.service.util.LicenseServiceUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class AddUserLicGroupThread
implements Runnable {
    private static final Log logger = LogFactory.getLog(AddUserLicGroupThread.class);
    private static final String ISV_KINGDEE = "kingdee";
    private List<Long> userIds = null;
    private Map<String, List<String>> bizAppAndObjInfo = null;
    private Long[] groupIds = null;
    private int source;

    public AddUserLicGroupThread(List<Long> userIds, Map<String, List<String>> bizAppAndObjInfo) {
        this.userIds = userIds;
        this.bizAppAndObjInfo = bizAppAndObjInfo;
        this.source = 1;
    }

    public AddUserLicGroupThread(List<Long> userIds, Long[] groupIds) {
        this.userIds = userIds;
        this.groupIds = groupIds;
        this.source = 5;
    }

    @Override
    public void run() {
        if (this.userIds == null || this.userIds.isEmpty()) {
            return;
        }
        if (this.groupIds == null || this.groupIds.length == 0) {
            this.groupIds = this.computeGroupIds();
        }
        if (this.groupIds == null || this.groupIds.length == 0) {
            return;
        }
        boolean enableLegalPersonAssign = LicenseServiceUtil.isEnableLegalPersonAssign();
        if (enableLegalPersonAssign) {
            long userId = RequestContext.get().getCurrUserId();
            List adminChargeOrg = PermissionServiceHelper.getAdminChargeOrgs((Long)userId);
            List corporateOrg = OrgUnitServiceHelper.getCorporateOrg((boolean)false);
            ArrayList<Long> ids = new ArrayList<Long>(corporateOrg.size());
            for (Map map : corporateOrg) {
                Long id = (Long)map.get("id");
                if (!adminChargeOrg.contains(id)) continue;
                ids.add(id);
            }
            if (ids.size() == 1) {
                for (Long groupId : this.groupIds) {
                    ILicenseService service = (ILicenseService)ServiceFactory.getService(ILicenseService.class);
                    service.addUserListByGroupId((Object)groupId, this.userIds, (Long)ids.get(0), this.source);
                }
            } else {
                ArrayList<LicenseAssignLog> licenseAssignLogs = new ArrayList<LicenseAssignLog>(this.userIds.size());
                Date now = TimeServiceHelper.now();
                for (Long user : this.userIds) {
                    for (Long groupId : this.groupIds) {
                        LicenseAssignLog log = new LicenseAssignLog(now, Long.valueOf(userId), user, ResManager.loadKDString((String)"\u7cfb\u7edf\u65e0\u6cd5\u786e\u5b9a\u6cd5\u4eba\u7ec4\u7ec7", (String)"AddUserLicGroupThread_0", (String)"bos-mservice-license", (Object[])new Object[0]), groupId, false);
                        log.setOperateType(this.source);
                        log.setOperate(0);
                        licenseAssignLogs.add(log);
                    }
                }
                ILicenseService service = (ILicenseService)ServiceFactory.getService(ILicenseService.class);
                service.addAssignLogs(licenseAssignLogs);
            }
            return;
        }
        for (Long groupId : this.groupIds) {
            ILicenseService service = (ILicenseService)ServiceFactory.getService(ILicenseService.class);
            service.addUserListByGroupId((Object)groupId, this.userIds, Long.valueOf(100000L), this.source);
        }
    }

    private Long[] computeGroupIds() {
        logger.info("Add user license by permission task start!");
        if (this.bizAppAndObjInfo == null || this.bizAppAndObjInfo.isEmpty()) {
            return new Long[0];
        }
        Map licCtrl = BusinessDataServiceHelper.loadFromCache((String)"lic_licensegroupctrl", (String)"group,bizapp,bizobject", null);
        if (licCtrl == null || licCtrl.isEmpty()) {
            logger.info("\u8bb8\u53ef\u5206\u7ec4\u548c\u6743\u9650\u6811\u7684\u5e94\u7528\u5206\u7ec4\u548c\u4e1a\u52a1\u5bf9\u8c61\u4fe1\u606f\u67e5\u8be2\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002");
            return new Long[0];
        }
        HashMap<String, Set> licCtrlMap = new HashMap<String, Set>(licCtrl.size());
        HashMap<String, Long> appGroupMap = new HashMap<String, Long>(16);
        for (DynamicObject ctrl : licCtrl.values()) {
            String key = ctrl.getString("bizapp_id") + "_" + ctrl.getString("bizobject_id");
            DynamicObject group = ctrl.getDynamicObject("group");
            if (group == null) continue;
            Long groupId = (Long)group.getPkValue();
            licCtrlMap.computeIfAbsent(key, k -> new HashSet()).add(groupId);
            appGroupMap.put(ctrl.getString("bizapp_id"), (Long)group.getPkValue());
        }
        HashSet<Long> groupIdSet = new HashSet<Long>(16);
        HashSet<String> info = new HashSet<String>(16);
        String productVersionCurr = LicenseServiceHelper.getProductVersion();
        String productVersionLatest = "7.0";
        boolean isLatestEnv = productVersionLatest.equalsIgnoreCase(productVersionCurr);
        for (Map.Entry<String, List<String>> entry : this.bizAppAndObjInfo.entrySet()) {
            String bizAppId = entry.getKey();
            AppInfo appInfo = AppMetadataCache.getAppInfo((String)bizAppId);
            boolean isAllUserApp = appInfo.isAllUserApp();
            String isv = appInfo.getIsv();
            List<String> bizObjs = entry.getValue();
            for (String bizObj : bizObjs) {
                String key = bizAppId + "_" + bizObj;
                boolean add = info.add(key);
                if (!add) continue;
                Set licCtrlGroupIds = (Set)licCtrlMap.get(key);
                if (licCtrlGroupIds != null && licCtrlGroupIds.size() == 1) {
                    groupIdSet.addAll(licCtrlGroupIds);
                    continue;
                }
                try {
                    LicenseGroupCtrl licenseGroupCtrl;
                    Set latestVersionGroups;
                    boolean isCustomForm = FormMetadataCache.getFormConfig((String)bizObj).isCustomForm();
                    Long groupID = (Long)appGroupMap.get(bizAppId);
                    if (groupID == null && !isLatestEnv && (latestVersionGroups = (licenseGroupCtrl = LicenseCache.getLicenseGroupCtrl((String)bizAppId, (String)bizObj)).getLatestVersionGroups()) != null && latestVersionGroups.size() > 0) {
                        groupIdSet.addAll(latestVersionGroups);
                    }
                    if (!ISV_KINGDEE.equals(isv) && isCustomForm) {
                        groupIdSet.add(13L);
                        continue;
                    }
                    if (ISV_KINGDEE.equals(isv) && isCustomForm && isAllUserApp) {
                        groupIdSet.add(39L);
                        groupIdSet.add(groupID);
                        continue;
                    }
                    if (!ISV_KINGDEE.equals(isv) || !isCustomForm || isAllUserApp) continue;
                    groupIdSet.add(40L);
                    groupIdSet.add(groupID);
                }
                catch (Exception e) {
                    logger.error(bizObj + "\u4e1a\u52a1\u5bf9\u8c61\u5206\u914d\u4e8c\u5f00\u8bb8\u53ef\u5f02\u5e38", (Throwable)e);
                }
            }
        }
        return groupIdSet.toArray(new Long[0]);
    }
}

