/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.license;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.license.api.bean.CloudUserInfo;
import kd.bos.license.api.bean.ProductGroup;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.util.FileNameUtils;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.ss.util.RegionUtil;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExportAllUserHelper {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.permission.util.cloud.ExportAllUserHelper");
    private static final int DATAROWSTARTINDEX = 8;
    private int dataRowCount = 0;
    private int groupColumnStartIndex = 0;
    private List<String> lsLicenseGroupNumberName = null;

    public ExportAllUserHelper(String exportFilePath) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execute() throws Exception {
        try (XSSFWorkbook workbook = null;){
            workbook = new XSSFWorkbook();
            Sheet sheet = workbook.createSheet();
            this.fillHeader(sheet);
            this.fillData(sheet);
            String string = this.writeToFile((Workbook)workbook);
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeAllUserGroup(List<CloudUserInfo> data) throws Exception {
        try (XSSFWorkbook workbook = null;){
            workbook = new XSSFWorkbook();
            Sheet sheet = workbook.createSheet();
            this.fillHeader(sheet);
            this.fillData(sheet, data, true, true);
            this.writeToFile((Workbook)workbook);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execute(List<CloudUserInfo> data) throws Exception {
        try (XSSFWorkbook workbook = null;){
            workbook = new XSSFWorkbook();
            Sheet sheet = workbook.createSheet();
            this.fillHeader(sheet);
            this.fillData(sheet, data);
            String string = this.writeToFile((Workbook)workbook);
            return string;
        }
    }

    private void fillHeader(Sheet wsheet) {
        List<Map<String, Object>> columnModel = this.getColumnModel();
        int columnIndex = this.fillUserInfoHeader(wsheet, columnModel);
        this.fillLicenseGroupHeader(wsheet, columnIndex);
    }

    private int fillUserInfoHeader(Sheet wsheet, List<Map<String, Object>> columnModel) {
        Row row1 = wsheet.getRow(0);
        if (row1 == null) {
            row1 = wsheet.createRow(0);
        }
        Cell cell1 = row1.createCell(0);
        cell1.setCellValue(ResManager.loadKDString((String)"\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u8bf7\u52ff\u5bf9\u6a21\u677f\u683c\u5f0f\u505a\u4efb\u4f55\u8c03\u6574\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014", (String)"ExportAllUserHelper_0", (String)"bos-license-business", (Object[])new Object[0]));
        Row row2 = wsheet.getRow(1);
        if (row2 == null) {
            row2 = wsheet.createRow(1);
        }
        cell1 = row2.createCell(0);
        cell1.setCellValue(ResManager.loadKDString((String)"1.\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff0c10\u4e2a\u6c49\u5b57\u4ee5\u5185", (String)"ExportAllUserHelper_1", (String)"bos-license-business", (Object[])new Object[0]));
        Row row3 = wsheet.getRow(2);
        if (row3 == null) {
            row3 = wsheet.createRow(2);
        }
        cell1 = row3.createCell(0);
        cell1.setCellValue(ResManager.loadKDString((String)"2.\u624b\u673a\u3001ERP\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u5e76\u4e14\u4e0d\u80fd\u91cd\u590d", (String)"ExportAllUserHelper_2", (String)"bos-license-business", (Object[])new Object[0]));
        Row row4 = wsheet.getRow(3);
        if (row4 == null) {
            row4 = wsheet.createRow(3);
        }
        cell1 = row4.createCell(0);
        cell1.setCellValue(ResManager.loadKDString((String)"3.\u60a8\u53ef\u4ee5\u6279\u91cf\u7ed9\u7528\u6237\u8bbe\u5b9a\u5206\u7ec4\uff0c\u5206\u7ec4\u503c\u4e3a\u201c\u662f\u201d\u8868\u793a\u5206\u914d\u7528\u6237\u5230\u76f8\u5e94\u5206\u7ec4\uff0c\u4e3a\u201c\u5426\u201d\u6216\u4e3a\u7a7a\u8868\u793a\u4e0d\u5206\u914d\u7528\u6237\u5230\u8be5\u7ec4", (String)"ExportAllUserHelper_3", (String)"bos-license-business", (Object[])new Object[0]));
        Row row5 = wsheet.getRow(4);
        if (row5 == null) {
            row5 = wsheet.createRow(4);
        }
        cell1 = row5.createCell(0);
        cell1.setCellValue(ResManager.loadKDString((String)"4.\u60a8\u53ef\u4ee5\u6279\u91cf\u4fee\u6539\u7528\u6237\u4fe1\u606f\uff0c\u4ece\u5206\u7ec4\u4e2d\u79fb\u9664\u7528\u6237\uff0c\u79fb\u9664\u503c\u4e3a\u201c\u662f\u8868\u793a\u7528\u6237\u5c06\u88ab\u4ece\u8be5\u5206\u7ec4\u79fb\u9664\uff0c\u4e3a\u201c\u5426\u201d\u4e3a\u7a7a\u5219\u4e0d\u5904\u7406", (String)"ExportAllUserHelper_4", (String)"bos-license-business", (Object[])new Object[0]));
        Row row6 = wsheet.getRow(5);
        if (row6 == null) {
            row6 = wsheet.createRow(5);
        }
        cell1 = row6.createCell(0);
        cell1.setCellValue(ResManager.loadKDString((String)"\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u8bf7\u52ff\u5bf9\u6a21\u677f\u683c\u5f0f\u505a\u4efb\u4f55\u8c03\u6574\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014", (String)"ExportAllUserHelper_0", (String)"bos-license-business", (Object[])new Object[0]));
        Row firstRow = wsheet.getRow(6);
        if (firstRow == null) {
            firstRow = wsheet.createRow(6);
        }
        Cell cell = null;
        CellRangeAddress region = null;
        Workbook workbook = wsheet.getWorkbook();
        CellStyle cellStyle = workbook.createCellStyle();
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        cellStyle.setFillForegroundColor(HSSFColor.HSSFColorPredefined.PALE_BLUE.getIndex());
        int index = 0;
        for (Map<String, Object> item : columnModel) {
            cell = firstRow.createCell(index);
            cell.setCellStyle(cellStyle);
            cell.setCellValue(item.get("name").toString());
            region = new CellRangeAddress(6, 7, index, index);
            wsheet.addMergedRegion(region);
            Integer width = (Integer)item.get("width");
            if (width != null) {
                wsheet.setColumnWidth(index, width.intValue());
            }
            RegionUtil.setBorderBottom((BorderStyle)BorderStyle.THIN, (CellRangeAddress)region, (Sheet)wsheet);
            RegionUtil.setBorderLeft((BorderStyle)BorderStyle.THIN, (CellRangeAddress)region, (Sheet)wsheet);
            RegionUtil.setBorderRight((BorderStyle)BorderStyle.THIN, (CellRangeAddress)region, (Sheet)wsheet);
            RegionUtil.setBorderTop((BorderStyle)BorderStyle.THIN, (CellRangeAddress)region, (Sheet)wsheet);
            ++index;
        }
        return index;
    }

    private void fillLicenseGroupHeader(Sheet wsheet, int columnIndex) {
        int index;
        Row secondRow;
        List<Map<String, Object>> licenseGroup = this.getLicenseGroup();
        Row firstRow = wsheet.getRow(6);
        if (firstRow == null) {
            firstRow = wsheet.createRow(6);
        }
        if ((secondRow = wsheet.getRow(7)) == null) {
            secondRow = wsheet.createRow(7);
        }
        Cell cell = null;
        CellStyle cellStyle = wsheet.getWorkbook().createCellStyle();
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        cellStyle.setFillForegroundColor(HSSFColor.HSSFColorPredefined.YELLOW.getIndex());
        cellStyle.setBorderBottom(BorderStyle.THIN);
        cellStyle.setBorderLeft(BorderStyle.THIN);
        cellStyle.setBorderTop(BorderStyle.THIN);
        cellStyle.setBorderRight(BorderStyle.THIN);
        this.groupColumnStartIndex = index = columnIndex;
        for (Map<String, Object> item : licenseGroup) {
            cell = firstRow.createCell(index);
            cell.setCellStyle(cellStyle);
            cell.setCellValue(item.get("number").toString());
            cell = secondRow.createCell(index);
            cell.setCellStyle(cellStyle);
            cell.setCellValue(item.get("name").toString());
            Integer width = (Integer)item.get("width");
            if (width != null) {
                wsheet.setColumnWidth(index, width.intValue());
            }
            ++index;
        }
    }

    private void fillData(Sheet wsheet, List<CloudUserInfo> data) throws Exception {
        this.fillData(wsheet, data, false, false);
    }

    private void fillData(Sheet wsheet, List<CloudUserInfo> dataMap, boolean isExportActive, boolean isExportAll) throws Exception {
        if (dataMap == null) {
            dataMap = LicenseServiceHelper.getCloudUserInfo();
        }
        ArrayList<Map<String, String>> exportData = new ArrayList<Map<String, String>>();
        HashMap<String, String> map = null;
        String group = "";
        String genderAlias = "";
        for (CloudUserInfo u : dataMap) {
            int gender;
            map = new HashMap<String, String>();
            map.put("userNumber", u.getErp_account());
            map.put("userName", u.getName());
            map.put("personNumber", null);
            if (isExportAll) {
                map.put("deptName", u.getDepartment());
            }
            genderAlias = 0 == (gender = u.getGender()) ? ResManager.loadKDString((String)"\u7537", (String)"ExportAllUserHelper_5", (String)"bos-license-business", (Object[])new Object[0]) : (1 == gender ? ResManager.loadKDString((String)"\u5973", (String)"ExportAllUserHelper_6", (String)"bos-license-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4fdd\u5bc6", (String)"ExportAllUserHelper_7", (String)"bos-license-business", (Object[])new Object[0]));
            map.put("gender", genderAlias);
            map.put("birthday", u.getBirthday());
            map.put("email", u.getEmail());
            map.put("phone", u.getPhone());
            map.put("position", u.getPosition());
            if (u.getIs_delete() == 1) {
                map.put("is_delete", ResManager.loadKDString((String)"\u662f", (String)"ExportAllUserHelper_8", (String)"bos-license-business", (Object[])new Object[0]));
            } else {
                map.put("is_delete", ResManager.loadKDString((String)"\u5426", (String)"ExportAllUserHelper_9", (String)"bos-license-business", (Object[])new Object[0]));
            }
            if (u.getStatus() == 0) {
                map.put("status", ResManager.loadKDString((String)"\u662f", (String)"ExportAllUserHelper_8", (String)"bos-license-business", (Object[])new Object[0]));
            } else {
                map.put("status", ResManager.loadKDString((String)"\u5426", (String)"ExportAllUserHelper_9", (String)"bos-license-business", (Object[])new Object[0]));
            }
            group = u.getProd_group();
            if (group == null) {
                exportData.add(map);
                continue;
            }
            String[] groups = group.split(";");
            if (groups == null) {
                exportData.add(map);
                continue;
            }
            int len = groups.length;
            for (int i = 0; i < len; ++i) {
                if (isExportActive) {
                    if (u.getMpGroups() == null) break;
                    ProductGroup pg = (ProductGroup)u.getMpGroups().get(groups[i]);
                    if (pg != null && pg.isValid()) {
                        map.put(groups[i], "Active_YES");
                        continue;
                    }
                    map.put(groups[i], "Active_NO");
                    continue;
                }
                map.put(groups[i], ResManager.loadKDString((String)"\u662f", (String)"ExportAllUserHelper_8", (String)"bos-license-business", (Object[])new Object[0]));
            }
            exportData.add(map);
        }
        List<Map<String, Object>> columnModel = this.getColumnModel();
        this.fillDataToExcel(wsheet, exportData, columnModel);
        this.setLicenseGroupValidation(wsheet);
    }

    private void fillData(Sheet wsheet) throws Exception {
        this.fillData(wsheet, null);
    }

    private void fillDataToExcel(Sheet wsheet, List<Map<String, String>> noCloudUserData, List<Map<String, Object>> columnModel) {
        Row row = null;
        Cell cell = null;
        Workbook workbook = wsheet.getWorkbook();
        CellStyle cellStyle = workbook.createCellStyle();
        DataFormat fmt = workbook.createDataFormat();
        cellStyle.setDataFormat(fmt.getFormat("@"));
        int index = 0;
        columnModel.addAll(this.getLicenseGroup());
        for (Map<String, String> item : noCloudUserData) {
            row = wsheet.createRow(8 + index);
            item.put("index", String.valueOf(index + 1));
            int columnIndex = 0;
            String columnNumber = null;
            for (Map<String, Object> column : columnModel) {
                columnNumber = (String)column.get("number");
                cell = row.createCell(columnIndex);
                ++columnIndex;
                cell.setCellValue(item.get(columnNumber));
                cell.setCellStyle(cellStyle);
            }
            ++index;
            ++this.dataRowCount;
        }
    }

    private void setLicenseGroupValidation(Sheet sheet) {
        String[] validation = new String[]{"yes", "no"};
        int firstRow = 8;
        int endRow = firstRow + this.dataRowCount;
        int firstCol = this.groupColumnStartIndex;
        int endCol = firstCol + this.getLicenseGroup().size();
        this.setExcelValidation(sheet, validation, firstRow, endRow, firstCol, endCol);
    }

    private void setExcelValidation(Sheet sheet, String[] textlist, int firstRow, int endRow, int firstCol, int endCol) {
        new CellRangeAddressList(firstRow, endRow, firstCol, endCol);
    }

    private String writeToFile(Workbook workbook) throws IOException {
        FileService service = FileServiceFactory.getAttachmentFileService();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        workbook.write((OutputStream)os);
        byte[] data = os.toByteArray();
        TempFileCache tempFile = CacheFactory.getCommonCacheFactory().getTempFileCache();
        LocalDate now = LocalDate.now();
        StringBuilder fileName = new StringBuilder();
        fileName.append(ResManager.loadKDString((String)"\u5bfc\u51fa\u5217\u8868_\u7528\u6237\u8bb8\u53ef\u5206\u7ec4_", (String)"ExportAllUserHelper_10", (String)"bos-license-business", (Object[])new Object[0]));
        fileName.append(String.format("%02d%02d", now.getMonthValue(), now.getDayOfMonth()));
        fileName.append(".xlsx");
        String url = tempFile.saveAsUrl(fileName.toString(), data, 300);
        RequestContext ctx = RequestContext.getOrCreate();
        String path = FileNameUtils.getExportFileName((String)ctx.getTenantId(), (String)ctx.getAccountId(), (String)"83bfebc8000037ac", (String)("18QCB4INQ9EO" + UUID.randomUUID().toString()), (String)fileName.toString());
        url = service.upload(new FileItem(fileName.toString(), path, tempFile.getInputStream(url)));
        return UrlService.getAttachmentFullUrl((String)url);
    }

    private List<Map<String, Object>> getColumnModel() {
        ArrayList<Map<String, Object>> columnModel = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> item = new HashMap<String, Object>();
        item.put("number", "index");
        item.put("name", ResManager.loadKDString((String)"\u5e8f\u53f7", (String)"ExportAllUserHelper_11", (String)"bos-license-business", (Object[])new Object[0]));
        columnModel.add(item);
        int jobWidth = 3000;
        item = new HashMap();
        item.put("number", "personNumber");
        item.put("name", ResManager.loadKDString((String)"\u5de5\u53f7", (String)"ExportAllUserHelper_12", (String)"bos-license-business", (Object[])new Object[0]));
        item.put("width", jobWidth);
        columnModel.add(item);
        item = new HashMap();
        item.put("number", "userName");
        item.put("name", ResManager.loadKDString((String)"*\u59d3\u540d", (String)"ExportAllUserHelper_13", (String)"bos-license-business", (Object[])new Object[0]));
        columnModel.add(item);
        item = new HashMap();
        item.put("number", "gender");
        item.put("name", ResManager.loadKDString((String)"\u6027\u522b", (String)"ExportAllUserHelper_14", (String)"bos-license-business", (Object[])new Object[0]));
        columnModel.add(item);
        int birWidth = 4000;
        item = new HashMap();
        item.put("number", "birthday");
        item.put("name", ResManager.loadKDString((String)"\u51fa\u751f\u65e5\u671f", (String)"ExportAllUserHelper_15", (String)"bos-license-business", (Object[])new Object[0]));
        item.put("width", birWidth);
        columnModel.add(item);
        int idWidth = 5000;
        item = new HashMap();
        item.put("number", "idCardNO");
        item.put("name", ResManager.loadKDString((String)"\u8eab\u4efd\u8bc1\u53f7", (String)"ExportAllUserHelper_16", (String)"bos-license-business", (Object[])new Object[0]));
        item.put("width", idWidth);
        columnModel.add(item);
        item = new HashMap();
        item.put("number", "phone");
        item.put("name", ResManager.loadKDString((String)"*\u624b\u673a", (String)"ExportAllUserHelper_17", (String)"bos-license-business", (Object[])new Object[0]));
        item.put("width", birWidth);
        columnModel.add(item);
        item = new HashMap();
        item.put("number", "email");
        item.put("name", ResManager.loadKDString((String)"\u90ae\u7bb1", (String)"ExportAllUserHelper_18", (String)"bos-license-business", (Object[])new Object[0]));
        columnModel.add(item);
        item = new HashMap();
        item.put("number", "deptName");
        item.put("name", ResManager.loadKDString((String)"\u6240\u5728\u90e8\u95e8", (String)"ExportAllUserHelper_19", (String)"bos-license-business", (Object[])new Object[0]));
        columnModel.add(item);
        item = new HashMap();
        item.put("number", "position");
        item.put("name", ResManager.loadKDString((String)"\u804c\u4f4d", (String)"ExportAllUserHelper_20", (String)"bos-license-business", (Object[])new Object[0]));
        item.put("width", idWidth);
        columnModel.add(item);
        item = new HashMap();
        item.put("number", "userNumber");
        item.put("name", ResManager.loadKDString((String)"*ERP\u8d26\u53f7", (String)"ExportAllUserHelper_21", (String)"bos-license-business", (Object[])new Object[0]));
        item.put("width", 4000);
        columnModel.add(item);
        item = new HashMap();
        item.put("number", "cloudUuId");
        item.put("name", ResManager.loadKDString((String)"\u4e91\u901a\u884c\u8bc1ID(\u8bf7\u52ff\u586b\u5199)", (String)"ExportAllUserHelper_22", (String)"bos-license-business", (Object[])new Object[0]));
        item.put("width", idWidth);
        columnModel.add(item);
        item = new HashMap();
        item.put("number", "status");
        item.put("name", ResManager.loadKDString((String)"\u662f\u5426\u7981\u7528", (String)"ExportAllUserHelper_23", (String)"bos-license-business", (Object[])new Object[0]));
        item.put("width", 4000);
        columnModel.add(item);
        item = new HashMap();
        item.put("number", "is_delete");
        item.put("name", ResManager.loadKDString((String)"\u662f\u5426\u5220\u9664", (String)"ExportAllUserHelper_24", (String)"bos-license-business", (Object[])new Object[0]));
        item.put("width", birWidth);
        columnModel.add(item);
        return columnModel;
    }

    public List<Map<String, Object>> getLicenseGroup() {
        int defaultWidth = 5000;
        if (this.lsLicenseGroupNumberName == null) {
            try {
                DynamicObject[] load = BusinessDataServiceHelper.load((String)"lic_group", (String)"", (QFilter[])new QFilter[]{new QFilter("type", "=", (Object)"1")});
                this.lsLicenseGroupNumberName = new ArrayList<String>(load.length);
                for (DynamicObject dynamicObject : load) {
                    this.lsLicenseGroupNumberName.add(dynamicObject.getString("number") + ";" + dynamicObject.getString("name"));
                }
            }
            catch (Exception e) {
                logger.error((Object)"\u67e5\u8be2\u8bb8\u53ef\u5206\u7ec4\u5f02\u5e38", (Throwable)e);
                this.lsLicenseGroupNumberName = new ArrayList<String>();
            }
        }
        ArrayList<Map<String, Object>> group = new ArrayList<Map<String, Object>>(this.lsLicenseGroupNumberName.size());
        for (int i = 0; i < this.lsLicenseGroupNumberName.size(); ++i) {
            HashMap<String, Object> item = new HashMap<String, Object>();
            String[] strNumName = this.lsLicenseGroupNumberName.get(i).split(";");
            item.put("number", strNumName[0]);
            item.put("name", strNumName[1]);
            item.put("width", defaultWidth);
            group.add(item);
        }
        return group;
    }

    public int getDataRowStartIndex() {
        return 8;
    }

    public int getGroupColumnStartIndex() {
        return this.groupColumnStartIndex;
    }
}

