/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.license;

import java.time.LocalDate;
import java.util.LinkedList;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.operation.DeleteServiceHelper;

public class LicenceSyncLogCleaningTask
extends AbstractTask {
    private static Log logger = LogFactory.getLog(LicenceSyncLogCleaningTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        String sql = "select t.fday from t_lic_licensesynclogclean t where fid is not null ";
        int day = (Integer)DB.query((DBRoute)DBRoute.base, (String)sql, null, r -> {
            if (r.next()) {
                return r.getInt("fday");
            }
            return 90;
        });
        LocalDate localDate = LocalDate.now();
        LocalDate endDate = localDate.minusDays(day);
        ORM orm = ORM.create();
        QFilter endDateFilter = new QFilter("operatedate", "<=", (Object)endDate);
        QFilter[] qFilters = new QFilter[]{endDateFilter};
        DynamicObjectCollection collection = orm.query("lic_licensesynclog", "id", qFilters);
        LinkedList<Long> logId = new LinkedList<Long>();
        for (DynamicObject dynamicObject : collection) {
            long id = dynamicObject.getLong("id");
            logId.add(id);
        }
        try (TXHandle tx = TX.required();){
            try {
                DeleteServiceHelper.delete((String)"lic_licensesynclog", (QFilter[])qFilters);
                qFilters = new QFilter[]{new QFilter("taskid", "in", logId)};
                DeleteServiceHelper.delete((String)"lic_licensesyncdetail", (QFilter[])qFilters);
            }
            catch (Exception e) {
                logger.error("LicenceSyncLogCleaningTask" + e.getMessage());
                tx.markRollback();
            }
        }
    }
}

