/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.license;

import com.alibaba.fastjson.JSONObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.util.HttpClientUtils;
import org.apache.log4j.Logger;

public class NextCloud {
    private static final int BYTE_LEN = 8096;
    private static final int READ_TIME = 3600000;
    private static final int DEFAULT_READ_TIME = 60000;
    private static final int DEFAULT_CONNECT_TIME = 30000;
    private static final int SYSTEM_SLEEP_TIME = 1000;
    private static final String APPEND_TIMESTAMP = "&timestamp=";
    private static final String APPEND_SIGNITURE = "&signiture=";
    private static final String APPEND_EMAIL = "&email=";
    private static final String APPEND_PHONE = "&phone=";
    private static final String APPEND_PRODINSTCODE = "&prod_inst_code=";
    private static final String APPEND_UID = "&uid=";
    private static final String APPEND_CLIENTID = "client_id=";
    public static final int SUCCESS_CODE = 0;
    private static Logger logger = Logger.getLogger(NextCloud.class);
    public static final String CLOUD_URL = NextCloud.getBaseUrl();
    public static final String CLIENT_ID = NextCloud.getCloudClientId();
    public static final String CLIENT_SECRET = NextCloud.getClientSecret();
    private static final String BINDQUERY_URL = CLOUD_URL + "kderp/binding";
    private static final String BINDINGPAGE_URL = CLOUD_URL + "kderp/binding/page";
    public static final String CALLBACK_URL = "kderp/page/callback";
    private static final String ACCESSTOKEN_URL = CLOUD_URL + "kderp/access_token";
    public static final String CLOUDERPACCESSTOKEN_URL = CLOUD_URL + "clouderp/access_token";
    private static final String ENCODE = "utf-8";
    private static final String ACTIVECODE_URL = CLOUD_URL + "clouderp/account/vcode";
    private static final String VERIFYCODE_URL = CLOUD_URL + "clouderp/account/vcode/verifying";
    private static final String LICENSE_URL = CLOUD_URL + "kdproduct/prod_instance/licence/download";
    private static final String LICENE_BUILD_URL = CLOUD_URL + "kdproduct/prod_instance/license/build";
    private static final String LICENSE_PROCESSS_URL = CLOUD_URL + "kdproduct/prod_instance/license/build_process";
    private static final String AUTH_USER_ACCESSTOKEN_URL = CLOUD_URL + "auth/user/access_token";
    private static final String LICENSE_PRO_VERIFY_URL = CLOUD_URL + "kdproduct/prod_instance/group_member/verify";
    private static final String GET_STRATEGY_URL = CLOUD_URL + "passport/enterprise/config";
    private static final String AUTH_USER_AUTH_CODE = CLOUD_URL + "auth/user/auth_code";

    private static String getBaseUrl() {
        String cloudUrl = System.getProperty("url");
        if (StringUtils.isEmpty((CharSequence)cloudUrl)) {
            cloudUrl = "http://api.kingdee.com/";
        } else if (!cloudUrl.endsWith("/")) {
            cloudUrl = cloudUrl + '/';
        }
        return cloudUrl;
    }

    private static String getCloudClientId() {
        String cloudId = System.getProperty("clientId");
        if (StringUtils.isEmpty((CharSequence)cloudId)) {
            cloudId = "201230";
        }
        return cloudId;
    }

    private static String getClientSecret() {
        String clientSecret = System.getProperty("clientSecret");
        if (StringUtils.isEmpty((CharSequence)clientSecret)) {
            logger.error((Object)"clientSecret\u4e3a\u7a7a\uff0c\u4f1a\u5bfc\u81f4\u8fde\u63a5\u7528\u6237\u5e73\u53f0\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5mc\u914d\u7f6e");
            return "";
        }
        return clientSecret;
    }

    public static JSONObject getActiveCode(String uid, String prod_inst_code, String phone, String email) throws Exception {
        long timestamp = System.currentTimeMillis();
        StringBuilder sha1Param = new StringBuilder();
        sha1Param.append(CLIENT_ID);
        sha1Param.append(CLIENT_SECRET);
        sha1Param.append(uid);
        sha1Param.append(prod_inst_code);
        sha1Param.append(phone);
        sha1Param.append(email);
        sha1Param.append(timestamp);
        String signiture = NextCloud.sha1(sha1Param.toString());
        StringBuilder sb = new StringBuilder();
        sb.append(APPEND_CLIENTID).append(CLIENT_ID).append(APPEND_UID).append(uid).append(APPEND_PRODINSTCODE).append(prod_inst_code).append(APPEND_PHONE).append(phone).append(APPEND_EMAIL).append(email).append(APPEND_SIGNITURE).append(signiture).append(APPEND_TIMESTAMP).append(timestamp);
        return NextCloud.doGet(ACTIVECODE_URL, sb.toString());
    }

    public static JSONObject verifyCode(String uid, String prod_inst_code, String phone, String email, String vcode) throws Exception {
        long timestamp = System.currentTimeMillis();
        StringBuilder sha1Param = new StringBuilder();
        sha1Param.append(CLIENT_ID);
        sha1Param.append(CLIENT_SECRET);
        sha1Param.append(uid);
        sha1Param.append(prod_inst_code);
        sha1Param.append(phone);
        sha1Param.append(email);
        sha1Param.append(vcode);
        sha1Param.append(timestamp);
        String signiture = NextCloud.sha1(sha1Param.toString());
        JSONObject o = new JSONObject();
        o.put("client_id", (Object)CLIENT_ID);
        o.put("uid", (Object)uid);
        o.put("prod_inst_code", (Object)prod_inst_code);
        o.put("phone", (Object)phone);
        o.put("vcode", (Object)vcode);
        o.put("timestamp", (Object)(timestamp + ""));
        o.put("signiture", (Object)signiture);
        StringBuilder sb = new StringBuilder();
        sb.append(APPEND_CLIENTID).append(CLIENT_ID).append(APPEND_UID).append(uid).append(APPEND_PRODINSTCODE).append(prod_inst_code).append(APPEND_PHONE).append(phone).append(APPEND_EMAIL).append(email).append("&vcode=").append(vcode).append(APPEND_SIGNITURE).append(signiture).append(APPEND_TIMESTAMP).append(timestamp);
        return NextCloud.doGet(VERIFYCODE_URL, sb.toString());
    }

    public static JSONObject bindQuery(String userId, String userNumber, String product_code, String software_code) throws Exception {
        try {
            String param = NextCloud.string2Param(userId, userNumber, product_code, software_code);
            return NextCloud.doGet(BINDQUERY_URL, param);
        }
        catch (Exception e) {
            logger.error((Object)"NextCloud.bindQuery \u5f02\u5e38", (Throwable)e);
            throw e;
        }
    }

    public static String bindingPage(String userId, String userNumber, String product_code, String software_code) throws Exception {
        String param = NextCloud.string2Param(userId, userNumber, product_code, software_code);
        return BINDINGPAGE_URL + "?" + param;
    }

    @Deprecated
    public static JSONObject getUserAccessToken(String userName, String password) throws Exception {
        return null;
    }

    public static JSONObject getUserAuthCode(String accessToken) throws Exception {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("&access_token=").append(accessToken);
            return NextCloud.doGet(AUTH_USER_AUTH_CODE, sb.toString());
        }
        catch (Exception e) {
            logger.error((Object)"NextCloud.getUserAuthCode \u5f02\u5e38", (Throwable)e);
            return null;
        }
    }

    public static JSONObject getLicenseProVerify(String access_token, String prod_inst_code) throws Exception {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("access_token=").append(access_token).append(APPEND_PRODINSTCODE).append(prod_inst_code);
            return NextCloud.doGet(LICENSE_PRO_VERIFY_URL, sb.toString());
        }
        catch (Exception e) {
            logger.error((Object)"NextCloud.getLicenseProVerify \u5f02\u5e38", (Throwable)e);
            return null;
        }
    }

    public static JSONObject accessToken(String userId, String userNumber, String product_code, String software_code) throws Exception {
        try {
            String param = NextCloud.string2Param(userId, userNumber, product_code, software_code);
            return NextCloud.doGet(ACCESSTOKEN_URL, param);
        }
        catch (Exception e) {
            logger.error((Object)"NextCloud.accessToken \u5f02\u5e38", (Throwable)e);
            return null;
        }
    }

    public static JSONObject cloudErpAccessToken(String uId, String prod_inst_code) throws Exception {
        try {
            String param = NextCloud.string3Param(uId, prod_inst_code);
            return NextCloud.doGet(CLOUDERPACCESSTOKEN_URL, param);
        }
        catch (Exception e) {
            logger.error((Object)"NextCloud.cloudErpAccessToken \u5f02\u5e38", (Throwable)e);
            return null;
        }
    }

    private static String string3Param(String uId, String prod_inst_code) throws Exception {
        long timestamp = new Date().getTime() / 1000L;
        StringBuilder sha1Param = new StringBuilder();
        sha1Param.append(CLIENT_ID);
        sha1Param.append(CLIENT_SECRET);
        sha1Param.append(uId);
        sha1Param.append(prod_inst_code);
        sha1Param.append(timestamp);
        String signiture = NextCloud.sha1(sha1Param.toString());
        StringBuilder paramSB = new StringBuilder();
        paramSB.append(APPEND_CLIENTID);
        paramSB.append(CLIENT_ID);
        paramSB.append(APPEND_UID);
        paramSB.append(URLEncoder.encode(uId, ENCODE));
        paramSB.append(APPEND_PRODINSTCODE);
        paramSB.append(URLEncoder.encode(prod_inst_code, ENCODE));
        paramSB.append(APPEND_TIMESTAMP);
        paramSB.append(timestamp);
        paramSB.append(APPEND_SIGNITURE);
        paramSB.append(signiture);
        return paramSB.toString();
    }

    private static String string2Param(String userId, String userNumber, String product_code, String software_code) throws Exception {
        long timestamp = System.currentTimeMillis();
        StringBuilder sha1Param = new StringBuilder();
        sha1Param.append(CLIENT_ID);
        sha1Param.append(CLIENT_SECRET);
        sha1Param.append(userId);
        sha1Param.append(userNumber);
        if (product_code != null) {
            sha1Param.append(product_code);
        }
        sha1Param.append(software_code);
        sha1Param.append(timestamp);
        String signiture = NextCloud.sha1(sha1Param.toString());
        StringBuilder paramSB = new StringBuilder();
        paramSB.append(APPEND_CLIENTID);
        paramSB.append(CLIENT_ID);
        paramSB.append("&euid=");
        paramSB.append(URLEncoder.encode(userId, ENCODE));
        paramSB.append("&ename=");
        paramSB.append(URLEncoder.encode(userNumber, ENCODE));
        if (product_code != null) {
            paramSB.append("&product_code=");
            paramSB.append(URLEncoder.encode(product_code, ENCODE));
        }
        paramSB.append("&software_code=");
        paramSB.append(URLEncoder.encode(software_code, ENCODE));
        paramSB.append(APPEND_TIMESTAMP);
        paramSB.append(timestamp);
        paramSB.append(APPEND_SIGNITURE);
        paramSB.append(signiture);
        return paramSB.toString();
    }

    public static void downloadLicense(String prod_inst_code, String filePath) throws Exception {
        String url = LICENSE_URL + "?is_zip=1&prod_inst_code=" + prod_inst_code + "&client_id=" + CLIENT_ID + "&client_secret=" + CLIENT_SECRET;
        String buildUrl = LICENE_BUILD_URL + "?prod_inst_code=" + prod_inst_code + "&client_id=" + CLIENT_ID + "&client_secret=" + CLIENT_SECRET;
        String processUrl = LICENSE_PROCESSS_URL + "?prod_inst_code=" + prod_inst_code + "&client_id=" + CLIENT_ID + "&client_secret=" + CLIENT_SECRET + "&job_id=";
        String job_id = "";
        String responseBody = "";
        while (true) {
            if (0 == NextCloud.getCode(responseBody = NextCloud.httpClient(buildUrl)) && !StringUtils.isEmpty((CharSequence)(job_id = NextCloud.getJobId(responseBody)))) break;
            try {
                Thread.sleep(1000L);
            }
            catch (Exception e) {
                logger.error((Object)"NextCloud.downloadLicense \u5f02\u5e381", (Throwable)e);
            }
        }
        logger.error((Object)(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>request bulid license \u6210\u529f\uff01\u4efb\u52a1id:" + job_id));
        processUrl = processUrl + job_id;
        while (true) {
            if (0 == NextCloud.getCode(responseBody = NextCloud.httpClient(processUrl)) && 2 == NextCloud.getStatus(responseBody)) break;
            try {
                Thread.sleep(1000L);
            }
            catch (Exception e) {
                logger.error((Object)"NextCloud.downloadLicense \u5f02\u5e381", (Throwable)e);
            }
        }
        logger.error((Object)(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>bulid license \u5b8c\u6210\uff01\u4efb\u52a1id:" + job_id));
        NextCloud.downloadFile(url, filePath);
    }

    private static int getCode(String resultStr) {
        Map<?, ?> resultMap = NextCloud.paraseExecResult(resultStr);
        if (resultMap == null) {
            return 1;
        }
        if (resultMap.get("code") != null) {
            return Integer.parseInt(String.valueOf(resultMap.get("code")));
        }
        return Integer.parseInt(String.valueOf(resultMap.get("errcode")));
    }

    public static Map<?, ?> paraseExecResult(String execResult) {
        return JSONObject.parseObject((String)execResult);
    }

    private static String getJobId(String resultStr) {
        Map<?, ?> resultMap = NextCloud.paraseExecResult(resultStr);
        Map<?, ?> resultMap1 = null;
        if (resultMap.get("data") != null) {
            resultMap1 = NextCloud.paraseExecResult(resultMap.get("data").toString());
        }
        if (resultMap1 == null) {
            return "";
        }
        if (resultMap1.get("job_id") != null) {
            return String.valueOf(resultMap1.get("job_id"));
        }
        return "";
    }

    private static int getStatus(String resultStr) {
        Map<?, ?> resultMap = NextCloud.paraseExecResult(resultStr);
        Map<?, ?> resultMap1 = null;
        if (resultMap.get("data") != null) {
            resultMap1 = NextCloud.paraseExecResult(resultMap.get("data").toString());
        }
        if (resultMap1 == null) {
            return 0;
        }
        if (resultMap1.get("status") != null) {
            return Integer.parseInt(String.valueOf(resultMap1.get("status")));
        }
        return 0;
    }

    private static Map<String, String> getHttpRequestHeader() {
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Content-type", "application/x-www-form-urlencoded;charset=UTF-8");
        return header;
    }

    private static String httpClient(String url) {
        Map body = null;
        try {
            String post = HttpClientUtils.post((String)url, NextCloud.getHttpRequestHeader(), body);
            return post;
        }
        catch (IOException e) {
            logger.error((Object)("NextCloud.httpClient: url = " + url));
            logger.error((Object)("NextCloud.httpClient: e = " + e));
            return null;
        }
    }

    private static void downloadFile(String url, String filePath) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JSONObject doGet(String url, String param) throws Exception {
        StringBuilder result = new StringBuilder();
        BufferedReader in = null;
        HttpURLConnection conn = null;
        try {
            String line;
            String urlName = url + "?" + param;
            URL realUrl = new URL(urlName);
            conn = (HttpURLConnection)realUrl.openConnection();
            conn.setConnectTimeout(30000);
            conn.setReadTimeout(60000);
            conn.setRequestProperty("accept", "*/*");
            conn.setRequestProperty("Accept-Charset", ENCODE);
            conn.setRequestProperty("connection", "Keep-Alive");
            conn.setRequestProperty("user-agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1)");
            conn.connect();
            in = new BufferedReader(new InputStreamReader(conn.getInputStream(), ENCODE));
            while ((line = in.readLine()) != null) {
                result.append(line);
            }
        }
        catch (Exception e) {
            logger.error((Object)"NextCloud.doGet \u5f02\u5e38", (Throwable)e);
            JSONObject jSONObject = null;
            return jSONObject;
        }
        finally {
            try {
                if (conn != null) {
                    conn.disconnect();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
        }
        return JSONObject.parseObject((String)new String(result.toString().getBytes(ENCODE), ENCODE));
    }

    public static String sha1(String data) throws Exception {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            digest.update(data.getBytes(ENCODE));
            byte[] messageDigest = digest.digest();
            StringBuilder hexString = new StringBuilder();
            for (int i = 0; i < messageDigest.length; ++i) {
                String shaHex = String.format("%02X", messageDigest[i]);
                if (shaHex.length() < 2) {
                    hexString.append(0);
                }
                hexString.append(shaHex);
            }
            return hexString.toString();
        }
        catch (NoSuchAlgorithmException e) {
            logger.error((Object)"NextCloud.sha1 NoSuchAlgorithmException", (Throwable)e);
            throw e;
        }
    }

    public static JSONObject getComnnicationStrategy(String prod_inst_code) throws Exception {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append(APPEND_CLIENTID).append(CLIENT_ID).append("&client_secret=").append(CLIENT_SECRET).append(APPEND_PRODINSTCODE).append(prod_inst_code);
            return NextCloud.doGet(GET_STRATEGY_URL, sb.toString());
        }
        catch (Exception e) {
            logger.error((Object)"NextCloud.getComnnicationStrategy Exception", (Throwable)e);
            throw e;
        }
    }
}

