/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.license;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.license.SynUserToCloudUtils;
import kd.bos.license.api.bean.CloudUserInfo;
import kd.bos.license.api.bean.SyncLicenseProgressInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.util.ExceptionUtils;

public abstract class PagingExecuteHandler {
    private static Log logger = LogFactory.getLog(PagingExecuteHandler.class);
    private String productInstanceID = null;
    private int count = 0;
    public static final String RESULT = "result";
    public static final String CONT_COUNT = "count";
    public static final String ERRCODE = "errcode";
    public static final String DESCRIPTION = "description";

    public String getProductInstanceID() {
        return this.productInstanceID;
    }

    public void setProductInstanceID(String productInstanceID) {
        this.productInstanceID = productInstanceID;
    }

    public final Map<String, String> exec(List<CloudUserInfo> pagingData) {
        return this.exec(pagingData, true);
    }

    public final Map<String, String> exec(List<CloudUserInfo> pagingData, boolean uploadProgress) {
        StringBuilder result = new StringBuilder();
        StringBuilder res = new StringBuilder();
        result.append(" [ProductInstanceID] : ").append(this.productInstanceID).append('\n').append(" [exec operate is] : ").append(this.getClass().getName()).append('\n').append(" [exec start time] : ").append(this.formatDate(new Date())).append('\n').append(" [operate data is] : ").append(pagingData.size()).append('\n');
        if (100 < pagingData.size()) {
            int pageNumber = 100;
            int totalCount = pagingData.size();
            int totalPage = totalCount / pageNumber;
            if (totalCount % pageNumber > 0) {
                ++totalPage;
            }
            for (int pageNo = 0; pageNo < totalPage; ++pageNo) {
                int fromIndex = pageNo * pageNumber;
                int toIndex = (pageNo + 1) * pageNumber;
                if (toIndex > totalCount) {
                    toIndex = totalCount;
                }
                List<CloudUserInfo> pageData = pagingData.subList(fromIndex, toIndex);
                long startTime = System.currentTimeMillis();
                String execResult = this.retryExecSync(result, pageNo, pageData, startTime, uploadProgress);
                long endTime = System.currentTimeMillis();
                res.append(execResult).append(' ').append(" [execute page  : ").append(pageNo).append(" ]").append(" [execute result errorcode ] : ").append(SynUserToCloudUtils.getReturnErrcode(execResult)).append('\n').append(" [execute result des ] : ").append(SynUserToCloudUtils.getReturnDes(execResult)).append('\n');
            }
        } else {
            long startTime = System.currentTimeMillis();
            String nonce = this.retryExecSync(result, 1, pagingData, startTime, uploadProgress);
            res.append(nonce).append(' ');
            result.append(" [execute result errorcode ] : ").append(SynUserToCloudUtils.getReturnErrcode(nonce)).append('\n');
            result.append(" [execute result des ] : ").append(SynUserToCloudUtils.getReturnDes(nonce)).append('\n');
        }
        result.append(" [exec end time] :").append(this.formatDate(new Date()));
        logger.info("PagingExecuteHandler.exec:pagingData={},result={}", (Object)SynUserToCloudUtils.convertToJsonString(pagingData), (Object)result.toString());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(RESULT, res.toString());
        map.put(CONT_COUNT, String.valueOf(this.count));
        return map;
    }

    public String retryExecSync(StringBuilder result, int pageNo, List<CloudUserInfo> pageData, long startTime) {
        return this.retryExecSync(result, pageNo, pageData, startTime, true);
    }

    private String retryExecSync(StringBuilder result, int pageNo, List<CloudUserInfo> pageData, long startTime, boolean uploadProgress) {
        String execResult = this.doPaging(pageData);
        if (pageData == null || pageData.isEmpty()) {
            logger.debug("PagingExecuteHandler.retryExecSync : pageData is null");
            return execResult;
        }
        if (!this.isFromCloud(execResult)) {
            throw new KDException(new ErrorCode("404", ResManager.loadKDString((String)"\u65e0\u6cd5\u8bbf\u95ee\u4f01\u4e1a\u5e73\u53f0\uff0c\u8bf7\u68c0\u67e5\u7f51\u7edc\u8bbe\u7f6e\u3002", (String)"PagingExecuteHandler_0", (String)"bos-license-business", (Object[])new Object[0])), new Object[0]);
        }
        int errcode = SynUserToCloudUtils.getErrorCode(execResult);
        if (4006 == errcode) {
            throw new KDException(new ErrorCode(errcode + "", SynUserToCloudUtils.getReturnDes(execResult)), new Object[0]);
        }
        if (1534 == errcode || 500 == errcode) {
            throw new KDException(new ErrorCode(errcode + "", ResManager.loadKDString((String)"\u7f51\u7edc\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"PagingExecuteHandler_1", (String)"bos-license-business", (Object[])new Object[0])), new Object[0]);
        }
        String key = SynUserToCloudUtils.getSyncResultKey(execResult);
        if (StringUtils.isBlank((CharSequence)key)) {
            throw new KDException(new ErrorCode("404", ResManager.loadKDString((String)"\u65e0\u6cd5\u8bbf\u95ee\u4f01\u4e1a\u5e73\u53f0\uff0c\u8bf7\u68c0\u67e5\u7f51\u7edc\u8bbe\u7f6e\u3002", (String)"PagingExecuteHandler_0", (String)"bos-license-business", (Object[])new Object[0])), new Object[0]);
        }
        String synResult = SynUserToCloudUtils.getSynResult(key);
        String returnErrcode = SynUserToCloudUtils.getReturnErrcode(synResult);
        int reCount = 0;
        while (!("0".equals(returnErrcode) || "500".equals(returnErrcode) || "4006".equals(returnErrcode) || reCount >= 2)) {
            try {
                ++reCount;
                Thread.sleep(1000L);
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            }
            synResult = SynUserToCloudUtils.getSynResult(key);
            returnErrcode = SynUserToCloudUtils.getReturnErrcode(synResult);
        }
        if (reCount >= 2 || "500".equals(returnErrcode)) {
            throw new KDException(new ErrorCode(returnErrcode + "", ResManager.loadKDString((String)"\u7f51\u7edc\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"PagingExecuteHandler_1", (String)"bos-license-business", (Object[])new Object[0])), new Object[0]);
        }
        if ("4006".equals(returnErrcode)) {
            throw new KDException(new ErrorCode(returnErrcode + "", SynUserToCloudUtils.getReturnDes(execResult)), new Object[0]);
        }
        if (errcode == 0) {
            this.count += pageData.size();
        }
        result.append(" [retry execute page  : ").append(pageNo).append(" ]").append("\n");
        if (uploadProgress) {
            SyncLicenseProgressInfo info = LicenseServiceHelper.getUploadRegUserProgress();
            if (info.getHasSyncNum() + pageData.size() == info.getSyncTotal()) {
                LicenseServiceHelper.updateUploadRegUserProgress((boolean)true, (int)(info.getHasSyncNum() + pageData.size()), (int)info.getSyncTotal(), (boolean)false, (boolean)false, (boolean)false, (boolean)true);
            } else {
                LicenseServiceHelper.updateUploadRegUserProgress((boolean)true, (int)(info.getHasSyncNum() + pageData.size()), (int)info.getSyncTotal(), (boolean)false, (boolean)false, (boolean)false, (boolean)false);
            }
        }
        SynUserToCloudUtils.addSyncResultKeyToCacheByExecString(execResult);
        return execResult;
    }

    private boolean isFromCloud(String data) {
        try {
            Map<?, ?> result = SynUserToCloudUtils.paraseExecResult(data);
            if (result != null && result.containsKey(ERRCODE) && result.containsKey(DESCRIPTION)) {
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    abstract String doPaging(List<CloudUserInfo> var1);

    private String formatDate(Date date) {
        return SynUserToCloudUtils.formatDateToString(date, "yyyy-MM-dd HH:mm:ss");
    }

    private String assmbleLogFileNamePrefix(List<CloudUserInfo> pagingData) {
        CloudUserInfo userInfo;
        String defaultLogFileName = "pageData";
        if (pagingData != null && pagingData.size() > 0 && 0 == (userInfo = pagingData.get(0)).getStatus()) {
            defaultLogFileName = "disableUserPageData";
        }
        return defaultLogFileName;
    }
}

