/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.license;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.license.UpdateLicGroupUser;
import kd.bos.license.api.bean.CloudUserInfo;
import kd.bos.license.bean.LicenseSyncLog;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;

public class SynUserToCloud {
    private static Log logger = LogFactory.getLog(SynUserToCloud.class);

    public static Map<String, List<CloudUserInfo>> assembleCloudUserInfo() throws Exception {
        HashMap<String, List<CloudUserInfo>> dataInfo = new HashMap<String, List<CloudUserInfo>>(1);
        DynamicObject[] licenses = BusinessDataServiceHelper.load((String)"lic_license", (String)"prodinstcode", null);
        if (licenses == null || licenses.length <= 0) {
            return dataInfo;
        }
        List cloudUsers = LicenseServiceHelper.getCloudUserInfo();
        String prodInstCode = licenses[0].getString("prodinstcode");
        dataInfo.put(prodInstCode, cloudUsers);
        return dataInfo;
    }

    public static Map<String, List<CloudUserInfo>> assembleCloudUserInfo(boolean isExport, LicenseSyncLog licenseSyncLog) throws Exception {
        HashMap<String, List<CloudUserInfo>> dataInfo = new HashMap<String, List<CloudUserInfo>>(1);
        DynamicObject[] licenses = BusinessDataServiceHelper.load((String)"lic_license", (String)"prodinstcode", null);
        if (!(isExport || licenses != null && licenses.length != 0)) {
            try {
                boolean success = new UpdateLicGroupUser().downloadAndUpdateLicUser(true, licenseSyncLog, false);
                if (!success) {
                    logger.error("SynUserToCloud : assembleCloudUserInfo\u7b2c\u4e00\u6b21\u66f4\u65b0\u5931\u8d25");
                    return dataInfo;
                }
                licenses = BusinessDataServiceHelper.load((String)"lic_license", (String)"prodinstcode", null);
            }
            catch (Exception e) {
                logger.error("SynUserToCloud : assembleCloudUserInfo\u66f4\u65b0\u5931\u8d25 : " + e);
                throw e;
            }
        }
        if (licenses == null || licenses.length <= 0) {
            return dataInfo;
        }
        List cloudUsers = LicenseServiceHelper.getCloudUserInfo();
        String prodInstCode = licenses[0].getString("prodinstcode");
        dataInfo.put(prodInstCode, cloudUsers);
        return dataInfo;
    }
}

