/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.license;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.exception.KDException;
import kd.bos.license.NextCloud;
import kd.bos.license.SyncUserToCloudExecuteHandler;
import kd.bos.license.api.bean.CloudUserInfo;
import kd.bos.license.api.bean.CloudUserSyncDetailResultInfo;
import kd.bos.license.service.cache.LicenseCache;
import kd.bos.org.history.UserHistoryUtils;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.HttpClientUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public final class SynUserToCloudUtils {
    private static final Logger logger = Logger.getLogger(SynUserToCloudUtils.class);
    private static ConcurrentHashMap<String, Object> resultCacheKey = new ConcurrentHashMap();

    public static List<String> syncUserToCloud(Map<String, List<CloudUserInfo>> syncData) throws KDException {
        return SynUserToCloudUtils.syncUserToCloud(syncData, true);
    }

    public static List<String> syncUserToCloud(Map<String, List<CloudUserInfo>> syncData, boolean uploadProgress) throws KDException {
        int synDataSize = syncData.size();
        ArrayList<String> results = new ArrayList<String>(synDataSize);
        boolean hasPutCache = false;
        SyncUserToCloudExecuteHandler pagingHandler = new SyncUserToCloudExecuteHandler();
        for (Map.Entry<String, List<CloudUserInfo>> entry : syncData.entrySet()) {
            List<CloudUserInfo> value = entry.getValue();
            if (!hasPutCache && uploadProgress) {
                LicenseServiceHelper.updateUploadRegUserProgress((boolean)true, (int)0, (int)(synDataSize * value.size()), (boolean)false, (boolean)false, (boolean)false, (boolean)false);
                hasPutCache = true;
            }
            String productInstanceID = entry.getKey();
            LicenseCache.updateProductInstance(productInstanceID);
            results.add(JSONObject.toJSONString(pagingHandler.exec(value, uploadProgress)));
        }
        return results;
    }

    public static String getSyncResultKey(String resultStr) {
        Map<?, ?> map = SynUserToCloudUtils.paraseExecResult(resultStr);
        JSONObject obj = map == null ? null : map.get("data");
        if (null == obj) {
            return "";
        }
        return String.valueOf(obj.get((Object)"key"));
    }

    public static int getErrorCode(String resultStr) {
        Map<?, ?> map = SynUserToCloudUtils.paraseExecResult(resultStr);
        return Integer.parseInt(String.valueOf(map == null ? "0" : (map.get("errcode") == null ? "0" : map.get("errcode"))));
    }

    public static Map<?, ?> paraseExecResult(String execResult) {
        return JSONObject.parseObject((String)execResult);
    }

    public static boolean isSynComplete(String key) {
        String resultStr = SynUserToCloudUtils.getSynResult(key);
        return 0 == SynUserToCloudUtils.getErrorCode(resultStr);
    }

    public static boolean isImportingOrgmember(String execResult) {
        return 1534 == SynUserToCloudUtils.getErrorCode(execResult);
    }

    public static boolean isWaitTimeOut(long startTime, long endTime) {
        return endTime - startTime > 5000L;
    }

    public static ConcurrentHashMap<String, Object> getSimpleCache() {
        return resultCacheKey;
    }

    public static void clearSyncResultCacheKey() {
        String accountId = CacheKeyUtil.getAcctId();
        String key2 = null;
        for (String key2 : resultCacheKey.keySet()) {
            if (!key2.startsWith(accountId)) continue;
            resultCacheKey.remove(key2);
        }
    }

    public static List<JSONObject> getSyncResultList() {
        ConcurrentHashMap<String, Object> cache = SynUserToCloudUtils.getSimpleCache();
        Set cacheKeySet = cache.keySet();
        ArrayList<JSONObject> resultTotal = new ArrayList<JSONObject>();
        String accountId = CacheKeyUtil.getAcctId();
        for (String key : cacheKeySet) {
            key = key.replace(accountId, "");
            resultTotal.addAll(SynUserToCloudUtils.assembleSyncResultData(key));
        }
        return resultTotal;
    }

    public static Set<Long> pubCloudRegisterUser(Map<String, DynamicObject> erpAccUserMap, Set<Long> userIds) {
        Map<String, String> config = SynUserToCloudUtils.getCloudConfig();
        String cloudServerUrl = SynUserToCloudUtils.assembleUrl(config, "kdproduct/prod_instance/member/sync_result_success");
        Map<String, String> param = SynUserToCloudUtils.assembleGetReqCommonParam();
        ArrayList<DynamicObject> needUpdateUsers = new ArrayList<DynamicObject>(userIds.size());
        ArrayList<Long> needUpdateUserIds = new ArrayList<Long>(userIds.size());
        ConcurrentHashMap<String, Object> cache = SynUserToCloudUtils.getSimpleCache();
        Set cacheKeySet = cache.keySet();
        String accountId = CacheKeyUtil.getAcctId();
        for (String key : cacheKeySet) {
            JSONObject json;
            JSONArray array;
            key = key.replace(accountId, "");
            param.put("key", key);
            String url = SynUserToCloudUtils.appendUrlParam(cloudServerUrl, param);
            long startTime = System.currentTimeMillis();
            String synResult = SynUserToCloudUtils.executeHttpGet(url, param);
            boolean isApiTimeOut = false;
            while (!SynUserToCloudUtils.getErrCode(synResult).equals(0)) {
                try {
                    if (System.currentTimeMillis() - startTime > 300000L) {
                        isApiTimeOut = true;
                        break;
                    }
                    Thread.sleep(1000L);
                    synResult = SynUserToCloudUtils.executeHttpGet(url, param);
                }
                catch (Exception e) {
                    logger.error((Object)"\u6ce8\u518c\u7528\u6237\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25", (Throwable)e);
                }
            }
            if (isApiTimeOut || CollectionUtils.isEmpty((Collection)(array = (json = JSONObject.parseObject((String)synResult)).getJSONArray("data")))) continue;
            for (Object data : array) {
                JSONObject uidInfo = JSONObject.parseObject((String)data.toString());
                String erpAccount = uidInfo.getString("erp_account");
                DynamicObject user = erpAccUserMap.remove(erpAccount);
                if (user == null) continue;
                user.set("fuid", (Object)uidInfo.getInteger("uid"));
                user.set("isregisted", (Object)Boolean.TRUE);
                needUpdateUsers.add(user);
                needUpdateUserIds.add(Long.valueOf(user.getPkValue().toString()));
            }
        }
        SaveServiceHelper.save((DynamicObject[])needUpdateUsers.toArray(new DynamicObject[0]));
        UserHistoryUtils.saveUserHistory(needUpdateUserIds);
        SynUserToCloudUtils.clearSyncResultCacheKey();
        for (Long id : needUpdateUserIds) {
            userIds.remove(id);
        }
        return userIds;
    }

    private static Integer getErrCode(String synResult) {
        if (StringUtils.isEmpty((CharSequence)synResult)) {
            return Integer.MAX_VALUE;
        }
        JSONObject json = JSONObject.parseObject((String)synResult);
        return json.getInteger("errcode");
    }

    public static CloudUserSyncDetailResultInfo getSyncResultInfo(String key) {
        String json = SynUserToCloudUtils.getSynResult(key);
        logger.error((Object)("SynUserToCloudUtils.getSyncResultInfo : json = " + json));
        return (CloudUserSyncDetailResultInfo)JSONObject.parseObject((String)json, CloudUserSyncDetailResultInfo.class);
    }

    public static List<JSONObject> assembleSyncResultData(String key) {
        CloudUserSyncDetailResultInfo res = SynUserToCloudUtils.getSyncResultInfo(key);
        List resultlist = res.getData();
        String json = JSONObject.toJSONString((Object)resultlist);
        List _data = JSONObject.parseArray((String)json, JSONObject.class);
        ArrayList<JSONObject> avliableData = new ArrayList<JSONObject>();
        JSONObject o = null;
        if (_data != null) {
            int size = _data.size();
            for (int i = 0; i < size; ++i) {
                o = (JSONObject)_data.get(i);
                o.put("gender", (Object)SynUserToCloudUtils.convetGenderValueToAlias(o));
                o.put("status", (Object)SynUserToCloudUtils.convetStatusValueToAlias(o));
                o.put("is_delete", (Object)SynUserToCloudUtils.convetIsDeleteValueToAlias(o));
                avliableData.add(o);
            }
        }
        return avliableData;
    }

    private static String convetGenderValueToAlias(JSONObject obj) {
        int gender = Integer.parseInt(String.valueOf(obj.get((Object)"gender")));
        String alias = "";
        if (0 == gender) {
            alias = ResManager.loadKDString((String)"\u7537", (String)"SynUserToCloudUtils_0", (String)"bos-license-business", (Object[])new Object[0]);
        } else if (1 == gender) {
            alias = ResManager.loadKDString((String)"\u5973", (String)"SynUserToCloudUtils_1", (String)"bos-license-business", (Object[])new Object[0]);
        } else if (2 == gender) {
            alias = ResManager.loadKDString((String)"\u4fdd\u5bc6", (String)"SynUserToCloudUtils_2", (String)"bos-license-business", (Object[])new Object[0]);
        }
        return alias;
    }

    private static String convetStatusValueToAlias(JSONObject obj) {
        int status = Integer.parseInt(String.valueOf(obj.get((Object)"status")));
        String alias = "";
        if (0 == status) {
            alias = ResManager.loadKDString((String)"\u7981\u7528", (String)"SynUserToCloudUtils_3", (String)"bos-license-business", (Object[])new Object[0]);
        } else if (1 == status) {
            alias = ResManager.loadKDString((String)"\u6b63\u5e38", (String)"SynUserToCloudUtils_4", (String)"bos-license-business", (Object[])new Object[0]);
        }
        return alias;
    }

    private static String convetIsDeleteValueToAlias(JSONObject obj) {
        int status = Integer.parseInt(String.valueOf(obj.get((Object)"is_delete")));
        String alias = "";
        if (0 == status) {
            alias = ResManager.loadKDString((String)"\u5426", (String)"SynUserToCloudUtils_5", (String)"bos-license-business", (Object[])new Object[0]);
        } else if (1 == status) {
            alias = ResManager.loadKDString((String)"\u662f", (String)"SynUserToCloudUtils_6", (String)"bos-license-business", (Object[])new Object[0]);
        }
        return alias;
    }

    public static void addSyncResultKeyToCacheByExecString(String execResult) {
        String value = SynUserToCloudUtils.getSyncResultKey(execResult);
        if (!StringUtils.isEmpty((CharSequence)value)) {
            SynUserToCloudUtils.addSyncResultKeyToCache(value, value);
        }
    }

    public static void addSyncResultKeyToCache(String key, String value) {
        String newKey = CacheKeyUtil.getAcctId() + key;
        resultCacheKey.put(newKey, value);
    }

    public static String getSynResult(String key) {
        Map<String, String> config = SynUserToCloudUtils.getCloudConfig();
        Map<String, String> param = SynUserToCloudUtils.assembleGetReqCommonParam();
        param.put("key", key);
        String url = SynUserToCloudUtils.appendUrlParam(SynUserToCloudUtils.assembleUrl(config, "kdproduct/prod_instance/member/sync_result"), param);
        String result = "";
        result = SynUserToCloudUtils.executeHttpGet(url, param);
        while (result == null || result != null && result.indexOf("\"description\": \"Importing member\"") > 0) {
            try {
                Thread.sleep(200L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            result = SynUserToCloudUtils.executeHttpGet(url, param);
        }
        return result;
    }

    public static String getSync(String key) {
        Map<String, String> config = SynUserToCloudUtils.getCloudConfig();
        Map<String, String> param = SynUserToCloudUtils.assembleGetReqCommonParam();
        param.put("key", key);
        String url = SynUserToCloudUtils.appendUrlParam(SynUserToCloudUtils.assembleUrl(config, "kdproduct/member/sync/data"), param);
        return SynUserToCloudUtils.executeHttpGet(url, param);
    }

    public static Map<String, String> getCommonParam(Map<String, String> config) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("client_id", config.get("cloud.client.id"));
        map.put("client_secret", config.get("cloud.client.secret"));
        String productInstanceID = LicenseCache.getProductInstance();
        map.put("prod_inst_code", productInstanceID);
        return map;
    }

    public static Map<String, String> assembleParamData(Map<String, String> config, List<CloudUserInfo> pageData) {
        Map<String, String> param = SynUserToCloudUtils.getCommonParam(config);
        param.put("data", SynUserToCloudUtils.convertToJsonString(pageData));
        return param;
    }

    public static Map<String, String> assembleUpdateUserStatusParamData(Map<String, String> config, List<CloudUserInfo> pageData) {
        Map<String, String> param = SynUserToCloudUtils.getCommonParam(config);
        CloudUserInfo cloudUser = null;
        StringBuilder disableUIdStr = new StringBuilder();
        StringBuilder enableUIdStr = new StringBuilder();
        int size = pageData.size();
        for (int i = 0; i < size; ++i) {
            cloudUser = pageData.get(i);
            if (cloudUser.getUid() == 0L) continue;
            if (1 == cloudUser.getStatus()) {
                enableUIdStr.append(cloudUser.getUid()).append(',');
                continue;
            }
            disableUIdStr.append(cloudUser.getUid()).append(',');
        }
        if (enableUIdStr.length() > 0) {
            enableUIdStr.deleteCharAt(enableUIdStr.length() - 1);
        }
        if (disableUIdStr.length() > 0) {
            disableUIdStr.deleteCharAt(disableUIdStr.length() - 1);
        }
        param.put("disable", disableUIdStr.toString());
        param.put("enable", enableUIdStr.toString());
        return param;
    }

    public static String convertToJsonString(List<CloudUserInfo> obj) {
        return JSONObject.toJSONString(obj);
    }

    public static String assembleUrl(Map<String, String> config, String api) {
        String url = config.get("cloud.server.url");
        String executeUrl = url.endsWith("/") ? url + api : url + "/" + api;
        return executeUrl;
    }

    public static String executeHttpPost(String url, Map<String, Object> param) {
        return SynUserToCloudUtils.doExecuteHttpPost(url, param);
    }

    public static String executeHttpGet(String url, Map<String, String> param) {
        return SynUserToCloudUtils.doExecuteHttpGet(url, param);
    }

    public static String executeHttpPut(String url, Map<String, String> param) {
        return SynUserToCloudUtils.doExecuteHttpPut(url, param);
    }

    public static String doExecuteHttpPut(String url, Map<String, String> param) {
        try {
            String put = HttpClientUtils.putjson((String)url, SynUserToCloudUtils.getHttpRequestHeader(), (String)JSONObject.toJSONString(param));
            return put;
        }
        catch (Exception e) {
            logger.error((Object)("SynUserToCloudUtils.doExecuteHttpPut : url = " + url + " , param = " + param), (Throwable)e);
            return null;
        }
    }

    public static String doExecuteHttpGet(String url, Map<String, String> param) {
        StringBuilder urlStr = new StringBuilder(url);
        try {
            boolean isFirst = true;
            for (Map.Entry<String, String> entry : param.entrySet()) {
                if (isFirst) {
                    urlStr.append('?').append(entry.getKey()).append('=').append(entry.getValue());
                } else {
                    urlStr.append('&').append(entry.getKey()).append('=').append(entry.getValue());
                }
                isFirst = false;
            }
            return HttpClientUtils.get((String)urlStr.toString());
        }
        catch (Exception e) {
            logger.error((Object)("SynUserToCloudUtils.doExecuteHttpGet : userUrl = " + urlStr + " , param = " + param), (Throwable)e);
            return null;
        }
    }

    public static String doExecuteHttpPost(String url, Map<String, Object> param) {
        try {
            String post = HttpClientUtils.post((String)url, SynUserToCloudUtils.getHttpRequestHeader(), param, (int)1800000, (int)1800000);
            logger.info((Object)("SynUserToCloudUtils.doExecuteHttpPost() response : " + post));
            return post;
        }
        catch (Exception e) {
            logger.error((Object)("SynUserToCloudUtils.doExecuteHttpPost : url = " + url + " , param = " + param), (Throwable)e);
            return null;
        }
    }

    public static Map<String, String> getHttpRequestHeader() {
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Content-type", "application/x-www-form-urlencoded;charset=UTF-8");
        return header;
    }

    public static Map<String, String> getHttpRequestJsonHeader() {
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Content-type", "application/json");
        return header;
    }

    public static String appendUrlParam(String url, Map<String, String> param) {
        if (url == null || param.isEmpty()) {
            return url;
        }
        StringBuilder newUrl = new StringBuilder(url);
        if (url.indexOf(63) == -1) {
            newUrl.append('?');
        } else {
            newUrl.append('&');
        }
        for (Map.Entry<String, String> entry : param.entrySet()) {
            String name = entry.getKey();
            String value = entry.getValue();
            newUrl.append(name);
            newUrl.append('=');
            newUrl.append(value);
            newUrl.append('&');
        }
        return newUrl.toString();
    }

    public static Map<String, String> getCloudConfig() {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("cloud.server.url", NextCloud.CLOUD_URL);
        config.put("cloud.client.id", NextCloud.CLIENT_ID);
        config.put("cloud.client.secret", NextCloud.CLIENT_SECRET);
        config.put("club.server.url", "http://clubtest.kingdee.com");
        return config;
    }

    public static Map<String, String> findCloudUserFromLocalLicenseFile(JSONArray localcloudUsers, String localUserNumber) {
        JSONObject object = null;
        HashMap<String, String> localFileUserMap = new HashMap<String, String>();
        if (localcloudUsers == null) {
            return localFileUserMap;
        }
        int size = localcloudUsers.size();
        for (int i = 0; i < size; ++i) {
            object = localcloudUsers.getJSONObject(i);
            String cloudName = object.getString("cloudName");
            String cloudUuId = object.getString("cloudUuId");
            String erpNumber = object.getString("erpNumber");
            String group = object.getString("group");
            if (!localUserNumber.equals(erpNumber)) continue;
            localFileUserMap.put("cloudName", cloudName);
            localFileUserMap.put("cloudUuId", cloudUuId);
            localFileUserMap.put("erpNumber", erpNumber);
            localFileUserMap.put("group", group);
            break;
        }
        return localFileUserMap;
    }

    public static String downloadLicense() {
        File file = null;
        String fileName = "";
        try {
            fileName = String.valueOf(System.currentTimeMillis());
            file = File.createTempFile(fileName, ".zip");
            String filePath = file.getPath();
            String url = SynUserToCloudUtils.assembleDownloadLicenseUrl();
            try {
                SynUserToCloudUtils.doDownloadLicense(url, filePath);
            }
            catch (Exception e) {
                logger.error((Object)("SynUserToCloudUtils.downloadLicense : filePath = " + filePath), (Throwable)e);
            }
            return filePath;
        }
        catch (IOException e) {
            logger.error((Object)("SynUserToCloudUtils.downloadLicense : file = " + fileName), (Throwable)e);
            return "";
        }
    }

    public static String assembleDownloadLicenseUrl() {
        Map<String, String> config = SynUserToCloudUtils.getCloudConfig();
        Map<String, String> dowloadParam = SynUserToCloudUtils.assembleGetReqCommonParam();
        dowloadParam.put("is_zip", "1");
        String url = SynUserToCloudUtils.appendUrlParam(SynUserToCloudUtils.assembleUrl(config, "kdproduct/prod_instance/licence/download"), dowloadParam);
        return url;
    }

    public static Map<String, String> assembleGetReqCommonParam() {
        Map<String, String> config = SynUserToCloudUtils.getCloudConfig();
        HashMap<String, String> getReqParam = new HashMap<String, String>();
        getReqParam.put("client_id", config.get("cloud.client.id"));
        getReqParam.put("client_secret", config.get("cloud.client.secret"));
        String productInstanceID = LicenseCache.getProductInstance();
        if (productInstanceID != null) {
            getReqParam.put("prod_inst_code", productInstanceID);
        }
        return getReqParam;
    }

    private static boolean doDownloadLicense(String url, String filePath) throws Exception {
        boolean flag = true;
        InputStream in = null;
        HttpURLConnection conn = null;
        try (FileOutputStream out = new FileOutputStream(filePath);){
            logger.debug((Object)("download license url: " + url));
            URL realUrl = new URL(url);
            conn = (HttpURLConnection)realUrl.openConnection();
            conn.setConnectTimeout(3000);
            conn.setReadTimeout(3600000);
            conn.setRequestProperty("accept", "*/*");
            conn.setRequestProperty("Accept-Charset", "utf-8");
            conn.setRequestProperty("connection", "Keep-Alive");
            conn.setRequestProperty("user-agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1)");
            conn.connect();
            in = conn.getInputStream();
            if (conn.getContentType().indexOf("text") > -1) {
                throw new Exception("download fail");
            }
            byte[] b = new byte[8096];
            int i = 0;
            while ((i = in.read(b)) != -1) {
                ((OutputStream)out).write(b, 0, i);
                out.flush();
            }
        }
        catch (Exception e) {
            flag = false;
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            try {
                if (conn != null) {
                    conn.disconnect();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ex) {
                logger.error((Object)("doDownloadLicense.IOException ex : " + ex));
            }
        }
        return flag;
    }

    @Deprecated
    @NotNull
    public static String getTempFilePath() {
        return "";
    }

    public static boolean removeTempFile(String path) {
        boolean flag = true;
        File file = new File(path);
        if (file.exists()) {
            flag = file.delete();
        }
        return flag;
    }

    @Deprecated
    public static void writeSyncLog(String logContent) {
        String logFile = SynUserToCloudUtils.assembleLogFile();
        SynUserToCloudUtils.doWriteLog(logContent, logFile);
    }

    @Deprecated
    public static void writeSyncLog(String logContent, String fileName) {
        String logFile = SynUserToCloudUtils.assembleLogFile(fileName);
        SynUserToCloudUtils.doWriteLog(logContent, logFile);
    }

    @Deprecated
    public static void writeCloudParamLog() {
        String logFile = SynUserToCloudUtils.getTempFilePath() + File.separator + "cloud_user_cfg.log";
        Map<String, String> config = SynUserToCloudUtils.getCloudConfig();
        String downloadLicenseUrl = SynUserToCloudUtils.assembleDownloadLicenseUrl();
        StringBuilder builder = new StringBuilder();
        builder.append("[runtime cfg:]").append('\n');
        builder.append("[c_i:]").append(config.get("cloud.client.id")).append('\n');
        builder.append("[c_s:]").append(config.get("cloud.client.secret")).append('\n');
        String productInstanceID = LicenseCache.getProductInstance();
        builder.append("[pic:]").append(productInstanceID).append('\n');
        builder.append("[downloadLicenseUrl:]").append(downloadLicenseUrl).append('\n');
        SynUserToCloudUtils.doWriteLog(builder.toString(), logFile);
    }

    @Deprecated
    public static void writeSyncResultLog(String logContent) {
        String logFile = SynUserToCloudUtils.getTempFilePath() + File.separator + "syncResult.log";
        SynUserToCloudUtils.doWriteLog(logContent, logFile);
    }

    @Deprecated
    public static String assembleLogFile(String fileName) {
        return "";
    }

    @Deprecated
    public static String assembleLogFile() {
        return "";
    }

    protected static void doWriteLog(String logContent, String logFile) {
        try (FileOutputStream out = new FileOutputStream(logFile);){
            ((OutputStream)out).write(logContent.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            logger.error((Object)("SynUserToCloudUtils.doWriteLog : e = " + e));
        }
    }

    public static Map<?, ?> paraseRequestResult(String requestResult) {
        JSONObject obj = JSONObject.parseObject((String)requestResult);
        return obj;
    }

    public static String getReturnErrcode(String requestResult) {
        Map<?, ?> obj = SynUserToCloudUtils.paraseRequestResult(requestResult);
        if (null == obj) {
            return "";
        }
        return String.valueOf(obj.get("errcode"));
    }

    public static String getReturnDes(String requestResult) {
        Map<?, ?> obj = SynUserToCloudUtils.paraseRequestResult(requestResult);
        if (null == obj) {
            return "";
        }
        Object descriptionCn = obj.get("description_cn");
        String descriptionStr = null;
        if (null != descriptionCn) {
            descriptionStr = String.valueOf(descriptionCn);
        }
        if (StringUtils.isBlank(descriptionStr)) {
            descriptionStr = String.valueOf(obj.get("description"));
        }
        return descriptionStr;
    }

    public static String formatDateToString(Date date, String pattern) {
        String dateString = "";
        if (date != null) {
            SimpleDateFormat sdf = new SimpleDateFormat(pattern);
            dateString = sdf.format(date);
        }
        return dateString;
    }
}

