/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.license;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.license.api.ILicenseService;
import kd.bos.license.api.LicenseAssignLog;
import kd.bos.license.bean.LicenseSyncDetailLog;
import kd.bos.license.bean.LicenseSyncLog;
import kd.bos.license.bean.User;
import kd.bos.license.bean.updatelic.UserLicenseGroup;
import kd.bos.license.util.LicenseGroupUtil;
import kd.bos.license.util.LicenseUpdateUtil;
import kd.bos.license.util.LicenseUtil;
import kd.bos.license.util.UserUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.ServiceFactory;

public class UpdateLicCom {
    private static Log logger = LogFactory.getLog(UpdateLicCom.class);
    private LicenseSyncLog licenseSyncLog = new LicenseSyncLog();
    private List<UserLicenseGroup> errorData = null;
    private Set<Long> assignUserIds = new HashSet<Long>(16);
    private boolean isPublic = false;
    private boolean isCtrlAmount = false;
    private boolean isHighAvailabilityMode = LicenseUtil.isHighAvailabilityMode();
    private boolean isTest;
    private String logType = "3";
    private String operation;
    private String userTable = "t_lic_userlicensegroup";

    public UpdateLicCom() {
    }

    public UpdateLicCom(LicenseSyncLog licenseSyncLog, boolean isPublic, boolean isCtrlAmount, boolean isHighAvailabilityMode, boolean isTest) {
        this.licenseSyncLog = licenseSyncLog;
        this.isPublic = isPublic;
        this.isCtrlAmount = isCtrlAmount;
        this.isHighAvailabilityMode = isHighAvailabilityMode;
        this.isTest = isTest;
    }

    public UpdateLicCom(List<UserLicenseGroup> errorData, LicenseSyncLog licenseSyncLog, boolean isPublic, boolean isCtrlAmount, boolean isHighAvailabilityMode, boolean isTest) {
        this.errorData = errorData;
        this.licenseSyncLog = licenseSyncLog;
        this.isPublic = isPublic;
        this.isCtrlAmount = isCtrlAmount;
        this.isHighAvailabilityMode = isHighAvailabilityMode;
        this.isTest = isTest;
    }

    public LicenseSyncLog getLicenseSyncLog() {
        return this.licenseSyncLog;
    }

    public void setLicenseSyncLog(LicenseSyncLog licenseSyncLog) {
        this.licenseSyncLog = licenseSyncLog;
    }

    public List<UserLicenseGroup> getErrorData() {
        return this.errorData;
    }

    public void setErrorData(List<UserLicenseGroup> errorData) {
        this.errorData = errorData;
    }

    public Set<Long> getAssignUserIds() {
        return this.assignUserIds;
    }

    public void setAssignUserIds(Set<Long> assignUserIds) {
        this.assignUserIds = assignUserIds;
    }

    public boolean isPublic() {
        return this.isPublic;
    }

    public void setPublic(boolean aPublic) {
        this.isPublic = aPublic;
    }

    public boolean isCtrlAmount() {
        return this.isCtrlAmount;
    }

    public void setCtrlAmount(boolean ctrlAmount) {
        this.isCtrlAmount = ctrlAmount;
    }

    public boolean isHighAvailabilityMode() {
        return this.isHighAvailabilityMode;
    }

    public void setHighAvailabilityMode(boolean highAvailabilityMode) {
        this.isHighAvailabilityMode = highAvailabilityMode;
    }

    public boolean isTest() {
        return this.isTest;
    }

    public void setTest(boolean test) {
        this.isTest = test;
    }

    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public String getLogType() {
        return this.logType;
    }

    public void setLogType(String logType) {
        this.logType = logType;
    }

    public UpdateLicCom(List<UserLicenseGroup> errorData, Set<Long> assignUserIds, List<Object> assignGroupIds, boolean isPublic, boolean isCtrlAmount, boolean isHighAvailabilityMode) {
        this.errorData = errorData;
        this.assignUserIds = assignUserIds;
        this.isPublic = isPublic;
        this.isCtrlAmount = isCtrlAmount;
        this.isHighAvailabilityMode = isHighAvailabilityMode;
    }

    public void checkAssignData() {
        if (this.isTest) {
            this.userTable = "t_lic_userlicgroup_trial";
        }
        LicenseUpdateUtil.initLicenseSyncLog((LicenseSyncLog)this.licenseSyncLog);
        List logs = this.licenseSyncLog.getLogs();
        if (null != this.errorData) {
            this.addLogsAndChangeDBData();
            return;
        }
        this.errorData = new ArrayList<UserLicenseGroup>(16);
        if (CollectionUtils.isEmpty(this.assignUserIds)) {
            DB.query((DBRoute)DBRoute.base, (String)"select fuserid userId, fgroupid groupId from t_lic_userlicensegroup where fsyncstatus in ('1','2')", rs -> {
                while (rs.next()) {
                    this.assignUserIds.add(rs.getLong("userId"));
                }
                return null;
            });
        }
        if (CollectionUtils.isEmpty(this.assignUserIds)) {
            return;
        }
        List userListBySet = UserUtil.getUserListBySet(this.assignUserIds);
        HashMap<Long, User> userInfoMap = new HashMap<Long, User>(userListBySet.size());
        for (User user : userListBySet) {
            userInfoMap.put(user.getUserId(), user);
        }
        SqlBuilder queryAssignGroupUserSql = new SqlBuilder().append("select fid userGroupId,fuserid userId,fgroupid groupId,fsyncstatus status from ", new Object[0]).append(this.userTable, new Object[0]).append(" where fsyncstatus in ('1','2')", new Object[0]);
        try (DataSet assignGroupUser = DB.queryDataSet((String)"queryAssignGroupUser", (DBRoute)DBRoute.base, (SqlBuilder)queryAssignGroupUserSql);){
            Map licenseGroup = LicenseGroupUtil.getLicenseGroup((String)"2");
            Map allGroupIdAndName = LicenseGroupUtil.getAllGroupIdAndName(null);
            ArrayList<UserLicenseGroup> allUserGroups = new ArrayList<UserLicenseGroup>(16);
            Map uniqueCharacteristic = LicenseUtil.getUniqueCharacteristic();
            String fieldNum = (String)uniqueCharacteristic.get("fieldNum");
            for (Row row : assignGroupUser) {
                if (null == row) continue;
                UserLicenseGroup userLicenseGroup = new UserLicenseGroup();
                userLicenseGroup.setId(row.getLong("userGroupId"));
                Long groupId = row.getLong("groupId");
                Long userId = row.getLong("userId");
                if (null == userId) continue;
                User user = (User)userInfoMap.get(userId);
                if (null == user) {
                    user = new User();
                }
                userLicenseGroup.setUserId(userId);
                userLicenseGroup.setUserName(user.getUserName());
                userLicenseGroup.setUserPhone(user.getPhone());
                userLicenseGroup.setUserEmail(user.getEmail());
                userLicenseGroup.setUserEnable(user.isEnable());
                userLicenseGroup.setUserFoebidden(user.isForbidden());
                userLicenseGroup.setGroupId(groupId);
                userLicenseGroup.setGroupName((String)allGroupIdAndName.get(groupId));
                allUserGroups.add(userLicenseGroup);
            }
            for (UserLicenseGroup userGroup : allUserGroups) {
                if (!this.releaseFeatureGroupUserLic(userGroup, licenseGroup.keySet()) && !this.releaseDiasbleUserLic(userGroup) && !this.releaseForbiddenUserLic(userGroup)) continue;
            }
        }
        catch (Exception e) {
            logger.error("checkAssignData error.", (Throwable)e);
        }
        this.addLogsAndChangeDBData();
    }

    private boolean releaseFeatureGroupUserLic(UserLicenseGroup userLicenseGroup, Set<String> featureGroupIds) {
        if (null == userLicenseGroup || CollectionUtils.isEmpty(featureGroupIds)) {
            return false;
        }
        return featureGroupIds.contains(userLicenseGroup.getGroupId().toString()) ? this.errorData.add(this.setErrorMessage(userLicenseGroup, ResManager.loadKDString((String)"%s\u4e3a\u7279\u6027\u5206\u7ec4\uff0c\u65e0\u9700\u5206\u914d\u3002", (String)"UserLicGroupUtil_10", (String)"bos-license-business", (Object[])new Object[]{userLicenseGroup.getGroupName()}))) : false;
    }

    private boolean releaseDiasbleUserLic(UserLicenseGroup userLicenseGroup) {
        if (null == userLicenseGroup) {
            return false;
        }
        return !userLicenseGroup.isUserEnable() ? this.errorData.add(this.setErrorMessage(userLicenseGroup, ResManager.loadKDString((String)"\u4eba\u5458\u7684\u72b6\u6001\u4e3a\u201c\u7981\u7528\u201d\u3002", (String)"UpdateLicGroupUser_45", (String)"bos-license-business", (Object[])new Object[0]))) : false;
    }

    private boolean releaseForbiddenUserLic(UserLicenseGroup userLicenseGroup) {
        if (null == userLicenseGroup) {
            return false;
        }
        return userLicenseGroup.isUserFoebidden() ? this.errorData.add(this.setErrorMessage(userLicenseGroup, ResManager.loadKDString((String)"\u7528\u6237\u7684\u72b6\u6001\u4e3a\u201c\u7981\u7528\u201d\u3002", (String)"UpdateLicGroupUser_35", (String)"bos-license-business", (Object[])new Object[0]))) : false;
    }

    private boolean releaseUniqueCharacteristicErrorUserLic(UserLicenseGroup userLicenseGroup, String fieldNum) {
        if (null == userLicenseGroup || StringUtils.isBlank((CharSequence)fieldNum)) {
            return false;
        }
        if ("username".equals(fieldNum) && StringUtils.isBlank((CharSequence)userLicenseGroup.getGroupName()) || "email".equals(fieldNum) && StringUtils.isBlank((CharSequence)userLicenseGroup.getUserEmail()) || "phone".equals(fieldNum) && StringUtils.isBlank((CharSequence)userLicenseGroup.getUserPhone())) {
            return this.errorData.add(this.setErrorMessage(userLicenseGroup, String.format(ResManager.loadKDString((String)"\u7528\u6237\u7684%1$s\u4e3a\u7a7a\u3002", (String)"LicenseSnapshotEngine_28", (String)"bos-license-business", (Object[])new Object[0]), fieldNum)));
        }
        return false;
    }

    private UserLicenseGroup setErrorMessage(UserLicenseGroup userLicenseGroup, String message) {
        if (null == userLicenseGroup) {
            return userLicenseGroup;
        }
        userLicenseGroup.setMessage(message);
        return userLicenseGroup;
    }

    private void releaseDataSet(DataSet dataSet) {
        if (null == dataSet) {
            return;
        }
        dataSet.close();
    }

    private void addLogsAndChangeDBData() {
        if (CollectionUtils.isEmpty(this.errorData)) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)this.operation)) {
            this.operation = ResManager.loadKDString((String)"\u66f4\u65b0\u8bb8\u53ef\u6587\u4ef6", (String)"LicenseSnapshotEngine_0", (String)"bos-license-business", (Object[])new Object[0]);
        }
        ArrayList<LicenseAssignLog> licenseAssignLogs = new ArrayList<LicenseAssignLog>(10);
        List logs = this.licenseSyncLog.getLogs();
        Long loginUserId = RequestContext.get().getCurrUserId();
        HashSet<Long> userIds = new HashSet<Long>(16);
        ArrayList<Long> params = new ArrayList<Long>(16);
        for (UserLicenseGroup errorUserGroup : this.errorData) {
            params.add(errorUserGroup.getId());
            Long userId = errorUserGroup.getUserId();
            if (userIds.add(userId)) {
                LicenseSyncDetailLog licenseSyncDetailLog = new LicenseSyncDetailLog();
                licenseSyncDetailLog.setUser(errorUserGroup.getUserName());
                licenseSyncDetailLog.setPhone(errorUserGroup.getUserPhone());
                licenseSyncDetailLog.setEmail(errorUserGroup.getUserEmail());
                licenseSyncDetailLog.setLogType(this.logType);
                licenseSyncDetailLog.setOperation(this.operation);
                licenseSyncDetailLog.setReason(errorUserGroup.getMessage());
                licenseSyncDetailLog.setDescription(errorUserGroup.getMessage());
                licenseSyncDetailLog.setSuccess(false);
                logs.add(licenseSyncDetailLog);
            }
            LicenseAssignLog licenseAssignLog = new LicenseAssignLog(errorUserGroup.getAssigntime(), loginUserId, userId, errorUserGroup.getMessage(), 0, 1, errorUserGroup.getGroupId(), true);
            licenseAssignLogs.add(licenseAssignLog);
        }
        SqlBuilder updateSql = new SqlBuilder();
        Long pkId = this.licenseSyncLog.getPkId();
        updateSql.append("update ", new Object[0]).append(this.userTable, new Object[0]).append(" set fsyncstatus = '3',fstatus = '0',fassigntime = now(),fsynclogid = ", new Object[0]).append(String.valueOf(pkId), new Object[0]).append(" where ", new Object[0]).appendIn("fid", params);
        DB.execute((DBRoute)DBRoute.base, (SqlBuilder)updateSql);
        if (!this.isTest) {
            ILicenseService service = (ILicenseService)ServiceFactory.getService(ILicenseService.class);
            service.addAssignLogs(licenseAssignLogs);
        }
    }
}

