/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.license;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.encrypt.Encrypters;
import kd.bos.entity.api.ApiResult;
import kd.bos.license.SynUserToCloudUtils;
import kd.bos.license.UpdateLicGroupUser;
import kd.bos.license.bean.LicenseSyncLog;
import kd.bos.license.engine.LicenseSnapshotEngine;
import kd.bos.license.service.cache.LicenseCache;
import kd.bos.license.service.cache.LicenseCacheMrg;
import kd.bos.license.service.cache.LicenseLocaleCache;
import kd.bos.license.util.LicenseExpireUtil;
import kd.bos.license.util.LicenseMCApiUtil;
import kd.bos.license.util.LicenseUpdateUtil;
import kd.bos.license.util.LicenseUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.productsetting.ProductSettingServiceHelper;

public class UpdateLicenseApi
implements IBillWebApiPlugin {
    private static final Log logger = LogFactory.getLog(UpdateLicenseApi.class);
    private static final String LOCALE_CACHE_PRODUCT = "ProductInfo";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ApiResult doCustomService(Map<String, Object> params) {
        HashMap<String, String> result = new HashMap<String, String>(2);
        String userId = RequestContext.get().getUserId();
        if (userId == null || Long.parseLong(userId) <= 0L) {
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            StringBuilder stackTraceStr = new StringBuilder();
            for (int i = 0; i < stackTrace.length; ++i) {
                stackTraceStr.append(stackTrace[i].toString()).append("\r\n");
            }
            logger.error("Guestuser stackTrace--" + stackTraceStr);
        }
        LicenseServiceHelper.addLog((String)ResManager.loadKDString((String)"\u66f4\u65b0\u8bb8\u53ef", (String)"UpdateLicenseApi_0", (String)"bos-license-business", (Object[])new Object[0]), (String)String.format(ResManager.loadKDString((String)"\u7528\u6237ID\u4e3a%1$s\u7684\u7528\u6237\u901a\u8fc7webapi\u89e6\u53d1\u8bb8\u53ef\u66f4\u65b0\u3002", (String)"UpdateLicenseApi_1", (String)"bos-license-business", (Object[])new Object[0]), userId));
        boolean isTest = LicenseUtil.isHighAvailabilityMode();
        LicenseSyncLog licenseSyncLog = new LicenseSyncLog();
        boolean circuitBreaker = LicenseCache.isCircuitBreaker("ctrl");
        if (!LicenseCache.requireWriteLock() && !circuitBreaker) {
            logger.info("\u5f53\u524d\u6709\u7ba1\u7406\u5458\u6b63\u5728\u6d4f\u89c8\u8bd5\u7b97\u7ed3\u679c\uff0c\u83b7\u53d6\u5199\u9501\u5931\u8d25");
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u5f53\u524d\u6709\u7ba1\u7406\u5458\u6b63\u5728\u6d4f\u89c8\u8bd5\u7b97\u7ed3\u679c,\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"UpdateLicenseApi_5", (String)"bos-license-business", (Object[])new Object[0]));
        }
        TXHandle h = TX.requiresNew((String)"UpdateLicenseApi");
        try (DLock dlock = DLock.createReentrant((String)"UserLicenseGroups");){
            dlock.lock();
            String encryptLicFileFromMc = LicenseMCApiUtil.getEncryptLicFileFromMc();
            Map parseObject = LicenseMCApiUtil.JsonToMap((String)encryptLicFileFromMc);
            if (parseObject == null) {
                ApiResult apiResult = ApiResult.fail((String)ResManager.loadKDString((String)"\u8c03\u7528\u7ba1\u7406\u4e2d\u5fc3\u83b7\u53d6\u8bb8\u53ef\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a\u3002", (String)"UpdateLicenseApi_3", (String)"bos-license-business", (Object[])new Object[0]));
                return apiResult;
            }
            Object errorCode = parseObject.get("errorcode");
            logger.info("UpdateLicenseApi.downloadLicUpdateLicUser:getLic_errorcode = " + errorCode);
            if (errorCode != null && Integer.parseInt(errorCode.toString()) == 100) {
                Object dataJson = parseObject.get("data");
                String licenseData = String.valueOf(dataJson);
                if (Encrypters.isEncrypted((String)licenseData)) {
                    licenseData = Encrypters.decode((String)licenseData);
                }
                List dataList = (List)JSONObject.parseObject((String)licenseData, List.class);
                logger.info("LicenseData : " + LicenseUtil.removeAllRegUsers((String)licenseData));
                boolean publicType = LicenseUpdateUtil.isPublicType((String)encryptLicFileFromMc);
                UpdateLicGroupUser updateLicGroupUser = new UpdateLicGroupUser();
                updateLicGroupUser.updateDataInfo(dataList, false, licenseSyncLog, isTest);
                String licSnapshot = null;
                LicenseCache.generateTrialRedisMap();
                if (publicType && !LicenseUpdateUtil.isBlankLicense() && LicenseUpdateUtil.isBlankSnapshot()) {
                    LicenseSnapshotEngine.backUp();
                }
                if (!circuitBreaker && LicenseUpdateUtil.isNeedShowUpdateWindows() && !publicType) {
                    ApiResult apiResult = ApiResult.success(result);
                    return apiResult;
                }
                licSnapshot = (String)DB.query((DBRoute)DBRoute.base, (String)"select FDATA from T_LIC_Snapshot where fistrial = '1'", k -> {
                    if (k.next()) {
                        return k.getString("FDATA");
                    }
                    return null;
                });
                LicenseSnapshotEngine.restoreSnap(licSnapshot, false);
                LicenseUpdateUtil.clearTrialTable();
                LicenseCacheMrg.clearCache(LicenseCacheMrg.getTypeLicenseTrialRedisMap(), RequestContext.get().getAccountId());
                LicenseExpireUtil.updateExpireNoticeStatus();
                LicenseLocaleCache.remove(LOCALE_CACHE_PRODUCT);
                SynUserToCloudUtils.clearSyncResultCacheKey();
                this.updateTenantType(dataList);
                ProductSettingServiceHelper.clearAllCache();
            }
            LicenseServiceHelper.addLog((String)ResManager.loadKDString((String)"\u66f4\u65b0\u8bb8\u53ef", (String)"UpdateLicenseApi_0", (String)"bos-license-business", (Object[])new Object[0]), (String)String.format(ResManager.loadKDString((String)"\u7528\u6237ID\u4e3a%1$s\u7684\u7528\u6237\u901a\u8fc7webapi\u89e6\u53d1\u8bb8\u53ef\u66f4\u65b0\u3002", (String)"UpdateLicenseApi_1", (String)"bos-license-business", (Object[])new Object[0]), userId));
            licenseSyncLog.setSuccess(true);
            result.put("isSuccess", Boolean.TRUE.toString());
            result.put("msg", "");
            return ApiResult.success(result);
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u7ba1\u7406\u4e2d\u5fc3\u83b7\u53d6\u8bb8\u53ef\u63a5\u53e3\u5f02\u5e38", (Throwable)e);
            h.markRollback();
            result.put("isSuccess", Boolean.FALSE.toString());
            result.put("msg", e.getMessage());
            return ApiResult.success(result);
        }
        finally {
            h.close();
            LicenseCache.releaseWriteLock();
        }
    }

    private void updateTenantType(List<?> dataList) {
        try {
            if (dataList == null || dataList.isEmpty()) {
                logger.debug("\u8bb8\u53ef\u6587\u4ef6\u6570\u636e\u4e3a\u7a7a\uff0c\u89e3\u6790\u7cfb\u7edf\u90e8\u7f72\u65b9\u5f0f\u5931\u8d25\u3002");
                return;
            }
            Object dataMapJson = dataList.get(0);
            JSONObject jsonObject = JSON.parseObject((String)dataMapJson.toString());
            JSONObject content = jsonObject.getJSONObject("content");
            String tenantType = content.getString("tenantType");
            if (StringUtils.isBlank((CharSequence)tenantType)) {
                tenantType = "private";
            }
            String type = "tenant_type_" + RequestContext.get().getTenantId();
            String key = "tenant_type";
            if ("public".equals(tenantType)) {
                LicenseCacheMrg.putCache(type, key, Boolean.TRUE.toString());
            } else if ("private".equals(tenantType)) {
                LicenseCacheMrg.putCache(type, key, Boolean.FALSE.toString());
            }
            logger.info(String.format("\u8bb8\u53ef\u6587\u4ef6\u4e2d\u8fd4\u56de\u7684\u7cfb\u7edf\u90e8\u7f72\u65b9\u5f0f\u4e3a\uff1a%s", tenantType));
        }
        catch (Exception e) {
            logger.error(String.format("\u4ece\u8bb8\u53ef\u6587\u4ef6\u89e3\u6790\u90e8\u7f72\u65b9\u5f0f\u5931\u8d25\uff0c\u6570\u636e\u4e3a\uff1a%s", JSONObject.toJSONString(dataList)) + e.getMessage());
        }
    }
}

