/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.license.api;

import java.io.Serializable;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiMapping;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

@ApiController(value="bos", desc="\u6cd5\u4eba\u516c\u53f8\u8bb8\u53ef\u5206\u914dAPI")
@ApiMapping(value="/license")
public class LicenseLegalPersonAllocate
implements Serializable {
    private static final Log logger = LogFactory.getLog(LicenseLegalPersonAllocate.class);
    private static final String ENTITY_LIC_LEGALASSIGN = "lic_legalassign";

    @ApiPostMapping(value="/legalPersonAllocate", desc="\u6cd5\u4eba\u516c\u53f8\u8bb8\u53ef\u5206\u914dAPI")
    public CustomApiResult<Boolean> legalPersonAllocate(@ApiParam(value="\u6cd5\u4eba\u516c\u53f8ID", required=true) @ApiParam(value="\u6cd5\u4eba\u516c\u53f8ID", required=true) Long legalPersonId, @ApiParam(value="\u8bb8\u53ef\u5206\u7ec4ID", required=true) @ApiParam(value="\u8bb8\u53ef\u5206\u7ec4ID", required=true) Long groupId, @ApiParam(value="\u5206\u914d\u6570\u91cf", required=true) @ApiParam(value="\u5206\u914d\u6570\u91cf", required=true) int allocateCount) {
        if (legalPersonId == null || groupId == null || allocateCount < 0) {
            return CustomApiResult.fail((String)"", (String)ResManager.loadKDString((String)"\u6cd5\u4eba\u516c\u53f8\u8bb8\u53ef\u5206\u914d\u4fe1\u606f\u6709\u8bef", (String)"LicenseLegalPersonAllocate_0", (String)"bos-license-business", (Object[])new Object[0]));
        }
        long currUserId = RequestContext.get().getCurrUserId();
        boolean isRootAdmin = PermissionServiceHelper.isAdminUser((long)currUserId, (String)"10");
        if (!isRootAdmin) {
            logger.debug("\u5f53\u524d\u7528\u6237\u6ca1\u6709\u6cd5\u4eba\u516c\u53f8\u8bb8\u53ef\u5206\u914d\u7684\u6743\u9650\uff0c\u5f53\u524d\u7528\u6237ID\uff1a" + currUserId);
            return CustomApiResult.fail((String)"", (String)ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u6cd5\u4eba\u516c\u53f8\u8bb8\u53ef\u5206\u914d\u7684\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (String)"LicenseLegalPersonAllocate_1", (String)"bos-license-business", (Object[])new Object[0]));
        }
        return this.saveLegalPersonAllocate(legalPersonId, groupId, allocateCount);
    }

    private CustomApiResult saveLegalPersonAllocate(Long legalPersonId, Long groupId, int allocateCount) {
        DynamicObject[] legalAssignObjs = BusinessDataServiceHelper.load((String)ENTITY_LIC_LEGALASSIGN, (String)"org, assignednum, usednum", (QFilter[])new QFilter("group", "=", (Object)groupId).toArray());
        int totalNumber = LicenseServiceHelper.getTotalNumber((Object)groupId);
        if ((legalAssignObjs == null || legalAssignObjs.length == 0) && allocateCount > totalNumber) {
            return CustomApiResult.fail((String)"", (String)ResManager.loadKDString((String)"\u8bbe\u7f6e\u7684\u201c\u5206\u914d\u8bb8\u53ef\u6570\u201d\u5927\u4e8e\u5f53\u524d\u5206\u7ec4\u7684\u8bb8\u53ef\u6570\u91cf\uff0c\u4fdd\u5b58\u5931\u8d25\u3002", (String)"LicenseLegalPersonAllocate_2", (String)"bos-license-business", (Object[])new Object[0]));
        }
        DynamicObject current = null;
        int assigned = 0;
        for (DynamicObject legalAssignObj : legalAssignObjs) {
            long orgId = legalAssignObj.getLong("org_id");
            if (legalPersonId.equals(orgId)) {
                current = legalAssignObj;
                continue;
            }
            assigned += legalAssignObj.getInt("assignednum");
        }
        if (allocateCount + assigned <= totalNumber) {
            if (current == null) {
                current = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_LIC_LEGALASSIGN);
                current.set("org", (Object)legalPersonId);
                current.set("group", (Object)groupId);
                current.set("usednum", (Object)0);
            } else {
                int usednum = current.getInt("usednum");
                if (usednum > allocateCount) {
                    return CustomApiResult.fail((String)"", (String)ResManager.loadKDString((String)"\u201c\u5df2\u4f7f\u7528\u8bb8\u53ef\u6570\u201d\u5927\u4e8e\u201c\u5206\u914d\u8bb8\u53ef\u6570\u201d,\u4fdd\u5b58\u5931\u8d25\u3002", (String)"LicenseLegalPersonAllocate_3", (String)"bos-license-business", (Object[])new Object[0]));
                }
            }
        } else {
            return CustomApiResult.fail((String)"", (String)ResManager.loadKDString((String)"\u8bbe\u7f6e\u7684\u201c\u5206\u914d\u8bb8\u53ef\u6570\u201d\u5927\u4e8e\u5f53\u524d\u5206\u7ec4\u7684\u8bb8\u53ef\u6570\u91cf\uff0c\u4fdd\u5b58\u5931\u8d25\u3002", (String)"LicenseLegalPersonAllocate_4", (String)"bos-license-business", (Object[])new Object[0]));
        }
        current.set("assignednum", (Object)allocateCount);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{current});
        return CustomApiResult.success((Object)Boolean.TRUE);
    }
}

