/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.license.config;

import java.nio.charset.StandardCharsets;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import kd.bos.license.util.EncryptUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import org.apache.commons.codec.binary.Hex;

public class AESUtil {
    private static final Log logger = LogFactory.getLog(AESUtil.class);
    private static final String KEY_ALGORITHM = "AES";
    private static final String DEFAULT_CIPHER_ALGORITHM = "AES/GCM/PKCS5Padding";

    public static String encrypt(String plaintext) {
        try {
            Cipher cipher = Cipher.getInstance(DEFAULT_CIPHER_ALGORITHM);
            cipher.init(1, AESUtil.getSecretKey());
            byte[] iv = cipher.getIV();
            assert (iv.length == 12);
            byte[] encryptData = cipher.doFinal(plaintext.getBytes());
            assert (encryptData.length == plaintext.getBytes().length + 16);
            byte[] message = new byte[12 + plaintext.getBytes().length + 16];
            System.arraycopy(iv, 0, message, 0, 12);
            System.arraycopy(encryptData, 0, message, 12, encryptData.length);
            return new String(Hex.encodeHex((byte[])message)).toUpperCase();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String decrypt(String cipherText) {
        try {
            byte[] content = Hex.decodeHex((char[])cipherText.toCharArray());
            if (content.length < 28) {
                throw new IllegalArgumentException();
            }
            GCMParameterSpec params = new GCMParameterSpec(128, content, 0, 12);
            Cipher cipher = Cipher.getInstance(DEFAULT_CIPHER_ALGORITHM);
            cipher.init(2, (Key)AESUtil.getSecretKey(), params);
            byte[] decryptData = cipher.doFinal(content, 12, content.length - 12);
            return new String(decryptData);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private static String getSecret() {
        String secret = EncryptUtil.getKey((String)"LicenseAESSecret");
        if (StringUtils.isNotEmpty((String)secret)) {
            return secret;
        }
        return "";
    }

    private static SecretKeySpec getSecretKey() {
        return new SecretKeySpec(AESUtil.getSecret().getBytes(StandardCharsets.UTF_8), KEY_ALGORITHM);
    }
}

