/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.license.config;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import kd.bos.license.config.AppBizObjGroupCollection;
import kd.bos.license.config.ConfigParseException;
import kd.bos.license.config.IConfigElement;
import kd.bos.license.config.ValidateResult;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class LicenseConfig
implements IConfigElement,
Serializable {
    private static final long serialVersionUID = 925701064047291618L;
    private static final String ROOTELEMENT = "licenseconfig";
    private static final String ROOTELEMENT_ATTR_VERSION = "version";
    private static final String SUBELEMENT_APPBIZOBJGROUPMAPS = "appBizObjGroupMaps";
    private String version = "";
    private AppBizObjGroupCollection appBizObjGroupCol = new AppBizObjGroupCollection();
    private AppBizObjGroupCollection LatestappBizObjGroupCol = new AppBizObjGroupCollection();

    public static LicenseConfig createByFileSystem(String filePath) throws ConfigParseException {
        File file = new File(filePath);
        if (!file.exists() || file.isDirectory()) {
            throw new ConfigParseException("target file is not exsit or is not a file");
        }
        try {
            SAXReader reader = new SAXReader();
            Document doc = reader.read(file);
            Element rootElement = doc.getRootElement();
            LicenseConfig def = new LicenseConfig();
            return (LicenseConfig)def.parse(rootElement);
        }
        catch (Exception e) {
            throw new ConfigParseException(e);
        }
    }

    public static LicenseConfig createByInputStream(InputStream inputStream) throws ConfigParseException {
        try {
            SAXReader reader = new SAXReader();
            Document doc = reader.read(inputStream);
            Element rootElement = doc.getRootElement();
            LicenseConfig def = new LicenseConfig();
            return (LicenseConfig)def.parse(rootElement);
        }
        catch (Exception e) {
            throw new ConfigParseException(e);
        }
    }

    public static LicenseConfig createByString(String xml) throws ConfigParseException {
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(xml.getBytes("utf-8"));
            return LicenseConfig.createByInputStream(inputStream);
        }
        catch (IOException e) {
            throw new ConfigParseException(e);
        }
    }

    public static LicenseConfig createByString(byte[] xml) throws ConfigParseException {
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(xml);
            return LicenseConfig.createByInputStream(inputStream);
        }
        catch (Exception e) {
            throw new ConfigParseException(e);
        }
    }

    @Override
    public Element toElement() {
        Element root = DocumentHelper.createElement((String)ROOTELEMENT);
        root.addAttribute(ROOTELEMENT_ATTR_VERSION, this.version);
        root.add(this.appBizObjGroupCol.toElement());
        return root;
    }

    @Override
    public IConfigElement parse(Element element) throws ConfigParseException {
        this.version = element.attributeValue(ROOTELEMENT_ATTR_VERSION).trim();
        Element appBizobjGroupsMapElement = element.element(SUBELEMENT_APPBIZOBJGROUPMAPS);
        this.appBizObjGroupCol = new AppBizObjGroupCollection(this, appBizobjGroupsMapElement);
        return this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String toXML() throws ConfigParseException {
        try (StringWriter stringWriter = new StringWriter();){
            Element element = this.toElement();
            Document doc = DocumentHelper.createDocument((Element)element);
            OutputFormat format = OutputFormat.createPrettyPrint();
            XMLWriter writer = new XMLWriter((Writer)stringWriter, format);
            writer.write(doc);
            writer.close();
            String string = stringWriter.toString();
            return string;
        }
        catch (IOException e) {
            throw new ConfigParseException(e);
        }
    }

    public String getversion() {
        return this.version;
    }

    @Override
    public ValidateResult validate() {
        return new ValidateResult();
    }

    @Override
    public IConfigElement getParent() {
        return null;
    }

    public AppBizObjGroupCollection getAppBizObjGroupCol() {
        return this.appBizObjGroupCol;
    }

    public void setAppBizObjGroupCol(AppBizObjGroupCollection appBizObjGroupCol) {
        this.appBizObjGroupCol = appBizObjGroupCol;
    }

    @Deprecated
    public AppBizObjGroupCollection getAppBizObjGroupColV4() {
        return this.LatestappBizObjGroupCol;
    }

    @Deprecated
    public void setAppBizObjGroupColV4(AppBizObjGroupCollection appBizObjGroupCol) {
        this.LatestappBizObjGroupCol = appBizObjGroupCol;
    }

    public AppBizObjGroupCollection getLastestAppBizObjGroupCol() {
        return this.LatestappBizObjGroupCol;
    }

    public void setLastestAppBizObjGroupCol(AppBizObjGroupCollection appBizObjGroupCol) {
        this.LatestappBizObjGroupCol = appBizObjGroupCol;
    }
}

