/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.license.config;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.security.MessageDigest;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.license.api.bean.ISVProdInfo;
import kd.bos.license.config.AppBizObjGroupCollection;
import kd.bos.license.config.AppBizObjGroupInfo;
import kd.bos.license.config.CryptoAlgorithm;
import kd.bos.license.config.LicenseConfig;
import kd.bos.license.config.OneTimePadUtil;
import kd.bos.license.config.RSA;
import kd.bos.license.config.RSAUtil;
import kd.bos.license.service.cache.LicenseCache;
import kd.bos.license.service.cache.LicenseCacheMrg;
import kd.bos.license.util.EncryptUtil;
import kd.bos.license.util.LicenseDefauleDataUtil;
import kd.bos.license.util.LicenseUtil;
import kd.bos.log.api.AppLogInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.devportal.DevVerifyServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.log.LogServiceHelper;
import kd.bos.util.CollectionUtils;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.xml.sax.InputSource;

public class LicenseConfigHelper {
    private static final Log logger = LogFactory.getLog(LicenseConfigHelper.class);
    private static final String LICENSEGROUPENTITY = "lic_group";
    private static final String ENTITY_PRODUCT = "lic_isvprod";
    private static final CryptoAlgorithm ca = new RSACryptoAlgorithm();

    public static LicenseConfig getLicenseConfig() {
        Object licenseConfig = DispatchServiceHelper.invokeBOSService((String)"basedata", (String)"ILicenseService", (String)"getLicenseConfig", (Object[])new Object[0]);
        if (licenseConfig instanceof LicenseConfig) {
            return (LicenseConfig)licenseConfig;
        }
        logger.error("\u5fae\u670d\u52a1\u8c03\u7528\u83b7\u53d6\u63a7\u5236\u6e05\u5355\u5931\u8d25");
        return null;
    }

    public static LicenseConfig getLicenseConfigImpl() {
        LicenseConfig config = new LicenseConfig();
        String productVersion = "7.0";
        boolean isOEM = DevVerifyServiceHelper.isOEMEnv();
        int modelType = LicenseServiceHelper.getModeType();
        boolean xkKitModel = false;
        if (isOEM) {
            String version = null;
            List productInfos = LicenseServiceHelper.getProductInfos();
            if (!CollectionUtils.isEmpty((Collection)productInfos)) {
                Iterator iterator = productInfos.iterator();
                while (iterator.hasNext()) {
                    Map productInfo = (Map)iterator.next();
                    String productversion = (String)productInfo.get("productversion");
                    if (null != version && !LicenseUtil.compareVersion((String)productversion, (String)version)) continue;
                    version = productversion;
                }
            }
            if (null != version) {
                productVersion = version;
            }
        } else {
            productVersion = LicenseServiceHelper.getProductVersion();
        }
        if (4 == modelType || 2 == modelType) {
            xkKitModel = 0 != LicenseServiceHelper.getTotalNumber((Object)"2057507009338585088");
        }
        List<String> fileNames = LicenseConfigHelper.getLicenseControlListFileName(modelType, productVersion, xkKitModel);
        for (String fileName : fileNames) {
            try {
                String encryText = LicenseConfigHelper.readLicenseConfig(fileName);
                byte[] xml = LicenseConfigHelper.EncryStringToByte(encryText);
                config.getAppBizObjGroupCol().addAll(LicenseConfig.createByString(xml).getAppBizObjGroupCol());
            }
            catch (Exception e) {
                logger.error("License getLicenseConfig Error : Can't parse license configfile,please check!" + e);
                if (4 != modelType) continue;
                throw new KDException(BosErrorCode.configNotFound, new Object[]{"License getLicenseConfig Error : Can't parse license configfile,please check!"});
            }
        }
        try {
            config.setLastestAppBizObjGroupCol(LicenseConfigHelper.getLatestLicCtrlCol(modelType, productVersion, xkKitModel));
        }
        catch (Exception e) {
            logger.error("\u89e3\u6790\u6700\u65b0\u7248\u672c\u7684\u8bb8\u53ef\u63a7\u5236\u6e05\u5355\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
            throw new KDException(BosErrorCode.configNotFound, new Object[]{"Latest licenseconfig file not found "});
        }
        try {
            config.getAppBizObjGroupCol().addAll(LicenseConfigHelper.getAllIsvPordAppBizObjGroupCol());
            LicenseCache.clearCircuitBreaker("isvCtrl");
        }
        catch (Exception e) {
            logger.error("\u89e3\u6790ISV\u8bb8\u53ef\u63a7\u5236\u6e05\u5355\u4fe1\u606f\u5f02\u5e38,isv license config file parse error.", (Throwable)e);
            AppLogInfo appLogInfo = new AppLogInfo();
            appLogInfo.setBizAppID("83bfebc8000037ac");
            appLogInfo.setBizObjID("lic_license");
            appLogInfo.setOpDescription(ResManager.loadKDString((String)"\u52a0\u8f7dISV\u63a7\u5236\u6e05\u5355\u5931\u8d25\uff0c\u8be6\u60c5\u8bf7\u67e5\u770bmonitor\u65e5\u5fd7\uff0c\u5173\u952e\u5b57\uff1alicense config\u3002", (String)"LicenseConfigHelper_6", (String)"bos-license-business", (Object[])new Object[0]));
            appLogInfo.setOpName(ResManager.loadKDString((String)"\u52a0\u8f7dISV\u63a7\u5236\u6e05\u5355", (String)"LicenseConfigHelper_7", (String)"bos-license-business", (Object[])new Object[0]));
            LogServiceHelper.addLog((AppLogInfo)appLogInfo);
            LicenseCacheMrg.putCache(LicenseCacheMrg.getLicenseCircuitBreakerType(), "isvCtrl", "DATA_LOADED");
        }
        return config;
    }

    private static AppBizObjGroupCollection getLatestLicCtrlCol(int modelType, String productVersion, boolean xkKitModel) {
        LicenseConfig config = new LicenseConfig();
        ArrayList fileNames = new ArrayList(16);
        if (modelType == 3 && !productVersion.equals("7.0")) {
            fileNames.addAll((Collection)LicenseDefauleDataUtil.LICENSE_CONFIGFILE_PATH_MAP.get("7.0"));
        }
        if (modelType == 4 || modelType == 2) {
            fileNames.addAll(LicenseDefauleDataUtil.getXkLicConfigFileName((int)modelType, (String)productVersion, (boolean)xkKitModel));
        }
        for (String fileName : fileNames) {
            try {
                String encryText = LicenseConfigHelper.readLicenseConfig(fileName);
                byte[] xml = LicenseConfigHelper.EncryStringToByte(encryText);
                config.getAppBizObjGroupCol().addAll(LicenseConfig.createByString(xml).getAppBizObjGroupCol());
            }
            catch (Exception e) {
                logger.error("\u52a0\u8f7dLatest\u8bb8\u53ef\u63a7\u5236\u6e05\u5355\u5931\u8d25\uff0c\u63a7\u4ef6\u6e05\u5355\u6587\u4ef6\u540d\u4e3a\uff1a" + fileName, (Throwable)e);
                if (4 != modelType) continue;
                throw new KDException(BosErrorCode.configNotFound, new Object[]{fileName + " not found. "});
            }
        }
        return config.getAppBizObjGroupCol();
    }

    /*
     * Exception decompiling
     */
    private static String readLicenseConfig(String fileName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static List<String> getLicenseControlListFileName(int modelType, String productVersion, boolean xkKitMModel) {
        if (modelType == 2 || modelType == 4) {
            return LicenseDefauleDataUtil.getXkLicConfigFileName((int)modelType, (String)productVersion, (boolean)xkKitMModel);
        }
        List configs = (List)LicenseDefauleDataUtil.LICENSE_CONFIGFILE_PATH_MAP.get(productVersion);
        if (CollectionUtils.isEmpty((Collection)configs)) {
            configs = (List)LicenseDefauleDataUtil.LICENSE_CONFIGFILE_PATH_MAP.get("7.0");
        }
        return configs;
    }

    private static AppBizObjGroupCollection getAllIsvPordAppBizObjGroupCol() {
        logger.info("getAllIsvPordAppBizObjGroupCol()");
        AppBizObjGroupCollection isvPordAppBizObjGroupCol = new AppBizObjGroupCollection();
        List<ISVProdInfo> isvProds = LicenseCache.getAllISVProd();
        if (isvProds == null || isvProds.isEmpty()) {
            return isvPordAppBizObjGroupCol;
        }
        String groupSql = "select fid, fnumber from t_lic_group";
        Map groupNumberIdMap = (Map)DB.query((DBRoute)DBRoute.base, (String)groupSql, (ResultSetHandler)new ResultSetHandler<Map<String, String>>(){

            public Map<String, String> handle(ResultSet rs) throws Exception {
                HashMap<String, String> groupNumberIdMap = new HashMap<String, String>(16);
                while (rs.next()) {
                    String id = rs.getString("fid");
                    String number = rs.getString("fnumber");
                    groupNumberIdMap.put(number, id);
                }
                return groupNumberIdMap;
            }
        });
        for (ISVProdInfo isvProd : isvProds) {
            AppBizObjGroupCollection isvPordAppBizObjGroups = LicenseConfigHelper.getAllIsvPordAppBizObjGroups(isvProd, groupNumberIdMap);
            if (isvPordAppBizObjGroups == null || isvPordAppBizObjGroups.isEmpty()) continue;
            isvPordAppBizObjGroupCol.addAll(isvPordAppBizObjGroups);
        }
        return isvPordAppBizObjGroupCol;
    }

    private static AppBizObjGroupCollection getAllIsvPordAppBizObjGroups(ISVProdInfo isvProd, Map<String, String> groupNumberIdMap) {
        AppBizObjGroupCollection isvPordAppBizObjGroupCol = new AppBizObjGroupCollection();
        String prodNumber = isvProd.getProdNumber();
        String licModelFileName = "licenseModel_" + prodNumber + ".config";
        String licCtrlFileName = "licenseControl_" + prodNumber + ".config";
        logger.info("prodNumber:{},licModelFileName:{},licCtrlFileName:{} ", new Object[]{prodNumber, licModelFileName, licCtrlFileName});
        String signData = LicenseConfigHelper.getSignData(licCtrlFileName);
        String licModelFileStr = LicenseConfigHelper.getLicModelFileStr(licModelFileName);
        Boolean isValided = LicenseConfigHelper.verifyLicCtrl(licModelFileName, signData, prodNumber);
        if (!isValided.booleanValue()) {
            logger.error("ISV\u4ea7\u54c1\u8bb8\u53ef\u63a7\u5236\u6a21\u578b\u6587\u4ef6\u9a8c\u7b7e\u5931\u8d25\uff0cISV\u4ea7\u54c1\u8bb8\u53ef\u63a7\u5236\u6a21\u578b\u6587\u4ef6\uff1a " + licModelFileName + ", \u7b7e\u540d: " + signData);
            throw new KDException(BosErrorCode.configParseException, new Object[]{ResManager.loadKDString((String)"ISV\u4ea7\u54c1\u8bb8\u53ef\u63a7\u5236\u6a21\u578b\u6587\u4ef6\u9a8c\u7b7e\u5931\u8d25\uff0cISV\u4ea7\u54c1\u8bb8\u53ef\u63a7\u5236\u6a21\u578b\u6587\u4ef6\uff1a %1$s, \u7b7e\u540d: %2$s", (String)"LicenseConfigHelper_0", (String)"bos-license-business", (Object[])new Object[0]), licModelFileName, signData});
        }
        try (StringReader reader = new StringReader(licModelFileStr);){
            HashMap<String, AppInfo> allAppInfo;
            HashMap<String, String> appNumbers = AppMetadataCache.getAppNumbers();
            if (null == appNumbers) {
                appNumbers = new HashMap<String, String>(0);
            }
            if (null == (allAppInfo = AppMetadataCache.getAllAppInfo())) {
                allAppInfo = new HashMap<String, AppInfo>(0);
            }
            InputSource source = new InputSource(reader);
            SAXReader saxReader = SAXReader.createDefault();
            Document document = saxReader.read(source);
            Element rootElement = document.getRootElement();
            List AppBizObjGroupMapList = rootElement.element("AppBizObjGroupMaps").elements("AppBizObjGroupMap");
            String appID = null;
            String bizObjID = null;
            String groupID = null;
            String moduleNumber = null;
            AppBizObjGroupInfo appBizObjGroupInfo = null;
            HashMap<String, String> bizObj2Prod = new HashMap<String, String>(AppBizObjGroupMapList.size());
            for (Element element : AppBizObjGroupMapList) {
                try {
                    appID = element.attribute("BizModule").getValue();
                    appID = LicenseConfigHelper.getAppId(appID, appNumbers, allAppInfo);
                    bizObjID = element.attribute("ObjectId").getValue();
                    groupID = element.attribute("ApplicationGroupId").getValue();
                    if (groupNumberIdMap != null && groupNumberIdMap.get(groupID) != null) {
                        groupID = groupNumberIdMap.get(groupID);
                    }
                    moduleNumber = "";
                    if (element.attribute("SubModule") != null) {
                        moduleNumber = element.attribute("SubModule").getValue();
                    }
                    appBizObjGroupInfo = new AppBizObjGroupInfo();
                    appBizObjGroupInfo.setAppID(appID);
                    appBizObjGroupInfo.setBizObjID(bizObjID);
                    appBizObjGroupInfo.setGroupID(groupID);
                    appBizObjGroupInfo.setModuleID(moduleNumber);
                    isvPordAppBizObjGroupCol.add(appBizObjGroupInfo);
                    bizObj2Prod.put(bizObjID, prodNumber);
                }
                catch (Exception e) {
                    logger.error("ISV Product LicenseCtrl appID: " + appID + ", bizObjID: " + bizObjID + ", groupID: " + groupID + ", moduleNumber: " + moduleNumber + ", parse Error.", (Throwable)e);
                }
            }
            String type4IsvBizObjProd = LicenseCacheMrg.getType4IsvBizObjProd();
            LicenseCacheMrg.putCache(type4IsvBizObjProd, bizObj2Prod);
            Element moduleCtrl = rootElement.element("ModuleCtrl");
            if (moduleCtrl != null) {
                String isv = moduleCtrl.attributeValue("Isv");
                String version = moduleCtrl.attributeValue("Version");
                String key = isv + "-" + prodNumber;
                String type4LicenseModuleCtrlVersion = LicenseCacheMrg.getType4ModuleCtrlVersion();
                LicenseCacheMrg.putCache(type4LicenseModuleCtrlVersion, key, version);
            }
        }
        catch (Exception e) {
            logger.error("\u89e3\u6790" + licModelFileName + "ISV\u63a7\u5236\u6e05\u5355\u5f02\u5e38", (Throwable)e);
            throw new KDException(BosErrorCode.configParseException, new Object[]{licModelFileName + " parse error"});
        }
        return isvPordAppBizObjGroupCol;
    }

    private static String getAppId(String appIdOrNumber, @NotNull Map<String, String> appNumbers, @NotNull Map<String, AppInfo> allAppInfo) {
        if (appNumbers.isEmpty()) {
            AppInfo appInfo = AppMetadataCache.getAppInfo((String)appIdOrNumber);
            if (appInfo != null) {
                appIdOrNumber = appInfo.getId();
            }
            return appIdOrNumber;
        }
        String appNumber = appNumbers.get(appIdOrNumber);
        if (kd.bos.util.StringUtils.isEmpty((String)appNumber)) {
            AppInfo appInfo = allAppInfo.get(appIdOrNumber);
            if (null == appInfo) {
                logger.error("allAppInfo \u4e2d\u65e0\u7f16\u7801\u4e3a" + appIdOrNumber + "\u7684\u5e94\u7528\uff0c\u53ef\u80fd\u662f\u73af\u5883\u4e2d\u65e0\u6b64\u5143\u6570\u636e\u3002");
                appInfo = AppMetadataCache.getAppInfo((String)appIdOrNumber);
            }
            return null == appInfo ? appIdOrNumber : appInfo.getId();
        }
        return appIdOrNumber;
    }

    private static String getLicModelFileStr(String licModelFileName) {
        StringBuilder sb = new StringBuilder();
        try (InputStream in = LicenseConfig.class.getResourceAsStream('/' + licModelFileName);
             BufferedReader reader = new BufferedReader(new InputStreamReader(in));){
            String str = null;
            while (kd.bos.util.StringUtils.isNotEmpty((String)(str = reader.readLine()))) {
                sb.append(str);
            }
        }
        catch (Exception e) {
            logger.error("\u8bfb\u53d6" + licModelFileName + "ISV\u4ea7\u54c1\u8bb8\u53ef\u63a7\u5236\u6a21\u578b\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
            throw new KDException(BosErrorCode.configNotFound, new Object[]{"can't found " + licModelFileName});
        }
        String licModelFileStr = sb.toString();
        if (kd.bos.util.StringUtils.isEmpty((String)licModelFileStr)) {
            logger.info(licModelFileName + "\u8bfb\u53d6\u5230\u7684xml\u5b57\u7b26\u4e32\u4e3a\u7a7a");
            throw new KDException(BosErrorCode.configParseException, new Object[]{String.format(ResManager.loadKDString((String)"%1$s\u8bfb\u53d6\u5230\u7684xml\u5b57\u7b26\u4e32\u4e3a\u7a7a", (String)"LicenseConfigHelper_2", (String)"bos-license-business", (Object[])new Object[0]), licModelFileName)});
        }
        return licModelFileStr;
    }

    private static Boolean verifyLicCtrl(String licModelFileName, String signData, String productNumber) {
        Boolean isValided = Boolean.FALSE;
        String md5 = LicenseConfigHelper.getMD5Checksum(licModelFileName);
        String publicKey = LicenseConfigHelper.getPubKey(productNumber);
        logger.info("md5:{},publicKey:{},signData:{}", new Object[]{md5, publicKey, signData});
        try {
            isValided = RSAUtil.verify(md5, publicKey, signData);
        }
        catch (Exception e) {
            logger.error("ISV\u4ea7\u54c1\u8bb8\u53ef\u63a7\u5236\u6a21\u578b\u6587\u4ef6\u9a8c\u7b7e\u5f02\u5e38", (Throwable)e);
            isValided = Boolean.FALSE;
        }
        return isValided;
    }

    private static String getPubKey(String productNumber) {
        if ("GDF".equals(productNumber)) {
            return EncryptUtil.getKey((String)"LicenseConfigPublicKey_GDF");
        }
        if ("AMDM".equals(productNumber)) {
            return EncryptUtil.getKey((String)"LicenseConfigPublicKey_AMDM");
        }
        if (StringUtils.contains((CharSequence)productNumber, (CharSequence)"xn_lsm")) {
            return EncryptUtil.getKey((String)"LicenseConfigPublicKey_XN_LSM");
        }
        if (StringUtils.contains((CharSequence)productNumber, (CharSequence)"kingdee_cosmicrpa_cloud")) {
            return EncryptUtil.getKey((String)"LicenseConfigPublicKey_COSMICRPA");
        }
        return EncryptUtil.getKey((String)"LicenseConfigPublicKey_COMMON_ISV");
    }

    public static byte[] createChecksum(String filename) throws Exception {
        try (InputStream in = LicenseConfig.class.getResourceAsStream('/' + filename);){
            int numRead;
            byte[] buffer = new byte[1024];
            MessageDigest complete = MessageDigest.getInstance(new String(new char[]{'M', 'D', '5'}));
            do {
                if ((numRead = in.read(buffer)) <= 0) continue;
                complete.update(buffer, 0, numRead);
            } while (numRead != -1);
            byte[] byArray = complete.digest();
            return byArray;
        }
    }

    public static String getMD5Checksum(String filename) {
        StringBuilder result = new StringBuilder();
        try {
            byte[] b = LicenseConfigHelper.createChecksum(filename);
            for (int i = 0; i < b.length; ++i) {
                result.append(Integer.toString((b[i] & 0xFF) + 256, 16).substring(1));
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return result.toString();
    }

    private static String getSignData(String licCtrlFileName) {
        String signData = null;
        StringBuilder sb = new StringBuilder();
        try (InputStream in = LicenseConfig.class.getResourceAsStream('/' + licCtrlFileName);
             BufferedReader reader = new BufferedReader(new InputStreamReader(in));){
            String str = null;
            while (kd.bos.util.StringUtils.isNotEmpty((String)(str = reader.readLine()))) {
                sb.append(str);
            }
        }
        catch (Exception e) {
            logger.error("\u8bfb\u53d6" + licCtrlFileName + "ISV\u63a7\u5236\u6e05\u5355\u5f02\u5e38", (Throwable)e);
            throw new KDException(BosErrorCode.configNotFound, new Object[]{"can't found " + licCtrlFileName});
        }
        String xmlString = sb.toString();
        if (kd.bos.util.StringUtils.isEmpty((String)xmlString)) {
            logger.info(licCtrlFileName + "\u8bfb\u53d6\u5230\u7684xml\u5b57\u7b26\u4e32\u4e3a\u7a7a");
            throw new KDException(BosErrorCode.configParseException, new Object[]{String.format(ResManager.loadKDString((String)"%1$s\u8bfb\u53d6\u5230\u7684xml\u5b57\u7b26\u4e32\u4e3a\u7a7a", (String)"LicenseConfigHelper_2", (String)"bos-license-business", (Object[])new Object[0]), licCtrlFileName)});
        }
        try (StringReader reader = new StringReader(xmlString);){
            InputSource source = new InputSource(reader);
            SAXReader saxReader = new SAXReader();
            Document doc = saxReader.read(source);
            Element root = doc.getRootElement();
            Element element = root.element("Sign");
            signData = element.attributeValue("SignData");
        }
        catch (Exception e) {
            logger.error("\u89e3\u6790" + licCtrlFileName + "ISV\u63a7\u5236\u6e05\u5355\u5f02\u5e38", (Throwable)e);
            throw new KDException(BosErrorCode.configParseException, new Object[]{String.format(ResManager.loadKDString((String)"\u89e3\u6790%1$sISV\u63a7\u5236\u6e05\u5355\u5f02\u5e38", (String)"LicenseConfigHelper_3", (String)"bos-license-business", (Object[])new Object[0]), licCtrlFileName)});
        }
        if (kd.bos.util.StringUtils.isEmpty((String)signData)) {
            logger.error(licCtrlFileName + "\u7b7e\u540d\u6570\u636e\u4e3a\u7a7a");
            throw new KDException(BosErrorCode.configParseException, new Object[]{String.format(ResManager.loadKDString((String)"%1$s\u7b7e\u540d\u6570\u636e\u4e3a\u7a7a", (String)"LicenseConfigHelper_5", (String)"bos-license-business", (Object[])new Object[0]), licCtrlFileName)});
        }
        return signData;
    }

    public static String EncryStringToString(String encry) {
        String s = (String)OneTimePadUtil.processXml2Object(encry);
        byte[] datas = ca.decrypt(s.getBytes());
        String encryString = new String(datas);
        Arrays.fill(datas, (byte)0);
        return encryString;
    }

    public static byte[] EncryStringToByte(String encry) {
        try {
            return EncryptUtil.unzipString((byte[])EncryptUtil.decryptString((String)encry));
        }
        catch (Exception e) {
            logger.error("\u8bb8\u53ef\u63a7\u5236\u6e05\u5355\u89e3\u5bc6\u5931\u8d25", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static String StringToEncryString(String text) {
        return OneTimePadUtil.processObject2Xml(new String(ca.encrypt(text.getBytes())));
    }

    private static class RSACryptoAlgorithm
    implements CryptoAlgorithm {
        private RSACryptoAlgorithm() {
        }

        @Override
        public byte[] encrypt(byte[] bytes) {
            return OneTimePadUtil.xor(bytes, RSA.pkey().getBytes());
        }

        @Override
        public byte[] decrypt(byte[] bytes) {
            return OneTimePadUtil.xor(bytes, RSA.pkey().getBytes());
        }
    }
}

