/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.license.config;

import java.io.ByteArrayOutputStream;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import org.apache.commons.codec.binary.Base64;

public class RSAUtil {
    private static final int MAX_ENCRYPT_BLOCK = 117;
    private static final int MAX_DECRYPT_BLOCK = 128;
    private static final String KEY_ALGORITHM = "RSA";
    private static final String KEY_ALG_SIGN = "MD5withRSA";

    public static String sign(String data, String privateKey) throws Exception {
        Signature signature = Signature.getInstance(KEY_ALG_SIGN);
        signature.initSign((PrivateKey)RSAUtil.getPrivateKey(privateKey));
        signature.update(data.getBytes("UTF-8"));
        return Base64.encodeBase64String((byte[])signature.sign());
    }

    public static boolean verify(String data, String publicKey, String sign) throws Exception {
        Signature signature = Signature.getInstance(KEY_ALG_SIGN);
        signature.initVerify((PublicKey)RSAUtil.getPublicKey(publicKey));
        signature.update(data.getBytes("UTF-8"));
        return signature.verify(Base64.decodeBase64((byte[])sign.getBytes("UTF-8")));
    }

    @Deprecated
    public static String publicEncrypt(String data, String publicKey) throws Exception {
        return RSAUtil.encrypt(data, RSAUtil.getPublicKey(publicKey));
    }

    @Deprecated
    public static String privateDecrypt(String data, String privateKey) throws Exception {
        return RSAUtil.decrypt(data, RSAUtil.getPrivateKey(privateKey));
    }

    @Deprecated
    public static String privateEncrypt(String data, String privateKey) throws Exception {
        return RSAUtil.encrypt(data, RSAUtil.getPrivateKey(privateKey));
    }

    @Deprecated
    public static String publicDecrypt(String data, String publicKey) throws Exception {
        return RSAUtil.decrypt(data, RSAUtil.getPublicKey(publicKey));
    }

    private static String encrypt(String data, Key key) throws Exception {
        Cipher cipher = Cipher.getInstance("RSA/ECB/OAEPWITHSHA-256ANDMGF1PADDING");
        cipher.init(1, key);
        int inputLen = data.getBytes("UTF-8").length;
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            int offset = 0;
            int i = 0;
            while (inputLen - offset > 0) {
                byte[] cache = inputLen - offset > 117 ? cipher.doFinal(data.getBytes("UTF-8"), offset, 117) : cipher.doFinal(data.getBytes("UTF-8"), offset, inputLen - offset);
                out.write(cache, 0, cache.length);
                offset = ++i * 117;
            }
            byte[] encryptedData = out.toByteArray();
            String string = Base64.encodeBase64String((byte[])encryptedData);
            return string;
        }
    }

    private static String decrypt(String data, Key key) throws Exception {
        Cipher cipher = Cipher.getInstance("RSA/ECB/OAEPWITHSHA-256ANDMGF1PADDING");
        cipher.init(2, key);
        byte[] dataBytes = Base64.decodeBase64((String)data);
        int inputLen = dataBytes.length;
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            int offset = 0;
            int i = 0;
            while (inputLen - offset > 0) {
                byte[] cache = inputLen - offset > 128 ? cipher.doFinal(dataBytes, offset, 128) : cipher.doFinal(dataBytes, offset, inputLen - offset);
                out.write(cache, 0, cache.length);
                offset = ++i * 128;
            }
            byte[] decryptedData = out.toByteArray();
            String string = new String(decryptedData, "UTF-8");
            return string;
        }
    }

    private static String byte2hex(byte[] b) {
        StringBuilder str = new StringBuilder();
        String zero = "0";
        for (int n = 0; b != null && n < b.length; ++n) {
            String tmp = Integer.toHexString(b[n] & 0xFF);
            if (tmp.length() == 1) {
                str.append(zero);
            }
            str.append(tmp);
        }
        return str.toString();
    }

    public static KeyPair getKeyPair() throws Exception {
        KeyPairGenerator generator = KeyPairGenerator.getInstance(KEY_ALGORITHM);
        generator.initialize(2048);
        return generator.generateKeyPair();
    }

    public static String getPrivateKey(KeyPair keyPair) {
        return RSAUtil.byte2hex(keyPair.getPrivate().getEncoded());
    }

    public static String getPublicKey(KeyPair keyPair) {
        return RSAUtil.byte2hex(keyPair.getPublic().getEncoded());
    }

    private static Key getPrivateKey(String privateKey) throws Exception {
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        byte[] decodedKey = Base64.decodeBase64((byte[])privateKey.getBytes("UTF-8"));
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(decodedKey);
        return keyFactory.generatePrivate(keySpec);
    }

    public static byte[] createChecksum(String data) throws Exception {
        MessageDigest complete = MessageDigest.getInstance(new String(new char[]{'M', 'D', '5'}));
        complete.update(data.getBytes(), 0, data.length());
        return complete.digest();
    }

    public static byte[] createChecksum(String data, String algorithm) throws Exception {
        MessageDigest complete = MessageDigest.getInstance(algorithm);
        complete.update(data.getBytes(), 0, data.length());
        return complete.digest();
    }

    public static String getMD5Checksum(String data) {
        StringBuilder result = new StringBuilder();
        try {
            byte[] b = RSAUtil.createChecksum(data, new String(new char[]{'M', 'D', '5'}));
            for (int i = 0; i < b.length; ++i) {
                result.append(Integer.toString((b[i] & 0xFF) + 256, 16).substring(1));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result.toString();
    }

    public static String getSHA256Checksum(String data) {
        StringBuilder result = new StringBuilder();
        try {
            byte[] b = RSAUtil.createChecksum(data, new String(new char[]{'S', 'H', 'A', '2', '5', '6'}));
            for (int i = 0; i < b.length; ++i) {
                result.append(Integer.toString((b[i] & 0xFF) + 256, 16).substring(1));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result.toString();
    }

    private static Key getPublicKey(String publicKey) throws Exception {
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        byte[] decodedKey = Base64.decodeBase64((byte[])publicKey.getBytes("UTF-8"));
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(decodedKey);
        return keyFactory.generatePublic(keySpec);
    }
}

