/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.license.config;

import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import kd.bos.exception.KDBizException;
import kd.bos.license.config.HashAlgorithm;

class Utils {
    private static final String CHARSET = "ISO8859-1";
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    Utils() {
    }

    static String encode(byte[] bytes) {
        if (bytes == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder(bytes.length * 2);
        for (int i = 0; i < bytes.length; ++i) {
            sb.append(Utils.encode(bytes[i]));
        }
        return sb.toString();
    }

    static char[] encode(byte b) {
        return new char[]{hexDigit[b >> 4 & 0xF], hexDigit[b & 0xF]};
    }

    static int hexToInt(byte[] bytes) {
        return Integer.parseInt(new String(bytes), 16);
    }

    static char[] intToHex(int i) {
        char[] array = new char[]{hexDigit[i >> 12 & 0xF], hexDigit[i >> 8 & 0xF], hexDigit[i >> 4 & 0xF], hexDigit[i & 0xF]};
        return array;
    }

    static int power(int m, int n) {
        return (int)Math.pow(m, n);
    }

    static Date parseDate(String str) throws ParseException {
        return sdf.parse(str);
    }

    static String formatDate(Date date) {
        return sdf.format(date);
    }

    static String hash(HashAlgorithm ha, String source) {
        try {
            return Utils.encode(ha.hash(source.getBytes(CHARSET)));
        }
        catch (UnsupportedEncodingException ex) {
            throw new KDBizException("UnsupportedEncodingException:" + ex.getMessage());
        }
    }

    static long getMillis(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.getTimeInMillis();
    }

    static Date addDate(Date date, int day) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(Utils.getMillis(date) + (long)day * 24L * 3600L * 1000L);
        return c.getTime();
    }

    static String hexStr2Str(String hexStr) {
        String str = "0123456789ABCDEF";
        char[] hexs = hexStr.toCharArray();
        byte[] bytes = new byte[hexStr.length() / 2];
        for (int i = 0; i < bytes.length; ++i) {
            int n = str.indexOf(hexs[2 * i]) * 16;
            bytes[i] = (byte)((n += str.indexOf(hexs[2 * i + 1])) & 0xFF);
        }
        String rs = "";
        try {
            rs = new String(bytes, "UTF-8");
        }
        catch (Exception e) {
            throw new KDBizException("Source is uncorrect!");
        }
        return rs;
    }

    static byte[] decode(String source) {
        int length = source.length();
        if (length % 2 != 0) {
            throw new KDBizException("source is uncorrect");
        }
        byte[] bytes = new byte[length / 2];
        for (int i = 0; i < length; ++i) {
            byte src;
            String highBinary = String.valueOf(source.charAt(i));
            String lowBinary = String.valueOf(source.charAt(++i));
            int high = Integer.parseInt(highBinary, 16);
            int low = Integer.parseInt(lowBinary, 16);
            byte highByte = (byte)(high << 4);
            bytes[(i - 1) / 2] = src = (byte)(highByte | low);
        }
        return bytes;
    }

    static byte[] arrayCopyOf(byte[] original, int newLength) {
        byte[] copy = new byte[newLength];
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }

    static byte[] arrayCopyOfRange(byte[] original, int from, int to) {
        int newLength = to - from;
        if (newLength < 0) {
            throw new IllegalArgumentException(from + " > " + to);
        }
        byte[] copy = new byte[newLength];
        System.arraycopy(original, from, copy, 0, Math.min(original.length - from, newLength));
        return copy;
    }
}

