/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.license.db.gray;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.license.constant.GrayLicApplyStatusEnum;
import kd.bos.license.pojo.gray.GrayFeature;
import kd.bos.license.util.LicenseUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class GrayLicenseDao {
    private static Log logger = LogFactory.getLog(GrayLicenseDao.class);

    public List<GrayFeature> updateGrayFeatureByLicFile(JSONArray data) {
        if (data == null || data.size() <= 0) {
            logger.info("\u7070\u5ea6\u8bb8\u53ef\u7279\u6027\u4e3a\u7a7a\u3002");
            return null;
        }
        ArrayList<GrayFeature> grayFeatures = new ArrayList<GrayFeature>(16);
        Map grayLicMap = BusinessDataServiceHelper.loadFromCache((String)"lic_grayfeature", null);
        HashMap<String, Object> featureNumber2GrayLicObj = new HashMap<String, Object>(grayLicMap.size());
        HashMap<String, Object> needChangeStatuFeatures = new HashMap<String, Object>(16);
        for (Map.Entry entry : grayLicMap.entrySet()) {
            DynamicObject grayLicObj = (DynamicObject)entry.getValue();
            DynamicObject dynamicObject = grayLicObj.getDynamicObject("grayfeature");
            if (dynamicObject == null) continue;
            String featureNumber = dynamicObject.getString("number");
            String status = grayLicObj.getString("status");
            if (GrayLicApplyStatusEnum.Success.toString().equals(status)) {
                grayLicObj.set("status", (Object)GrayLicApplyStatusEnum.Suspend.toString());
                needChangeStatuFeatures.put(featureNumber, grayLicObj);
            }
            if (StringUtils.isBlank((CharSequence)featureNumber)) continue;
            featureNumber2GrayLicObj.put(featureNumber, grayLicObj);
        }
        HashMap<String, DynamicObject> featureNumber2FeatureObj = new HashMap<String, DynamicObject>(16);
        Map featureMap = BusinessDataServiceHelper.loadFromCache((String)"lic_grayfeaturescheme", null);
        for (Map.Entry entry : featureMap.entrySet()) {
            DynamicObject schemeObj = (DynamicObject)entry.getValue();
            featureNumber2FeatureObj.put(schemeObj.getString("number"), schemeObj);
        }
        Object licFileObject = data.get(0);
        JSONObject jSONObject = JSONObject.parseObject((String)licFileObject.toString());
        JSONObject content = jSONObject.getJSONObject("content");
        if (content.isEmpty()) {
            return null;
        }
        this.checkGrayLic(jSONObject);
        JSONArray features = content.getJSONArray("features");
        if (features.isEmpty()) {
            return null;
        }
        ArrayList<Object> grayLicObjs = new ArrayList<Object>(features.size());
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"lic_grayfeature");
        for (Object feature : features) {
            JSONObject featureJsonObject = null;
            try {
                featureJsonObject = JSONObject.parseObject((String)feature.toString());
                String featureNumber = featureJsonObject.getString("number");
                String msg = this.checkFeature(featureNumber2FeatureObj, featureJsonObject);
                if (StringUtils.isNotBlank((CharSequence)msg)) {
                    logger.info("\u66f4\u65b0\u6570\u636e\u5e93\u7070\u5ea6\u8bb8\u53ef\uff0c\u7279\u6027\u7f16\u7801\u4e3a\uff1a{}\u8df3\u8fc7\uff0c\u539f\u56e0\uff1a{}", (Object)featureNumber, (Object)msg);
                    continue;
                }
                needChangeStatuFeatures.remove(featureNumber);
                DynamicObject grayLicObj = (DynamicObject)featureNumber2GrayLicObj.get(featureNumber);
                DynamicObject featureSchObj = (DynamicObject)featureNumber2FeatureObj.get(featureNumber);
                Long featureSchId = featureSchObj.getLong("id");
                if (grayLicObj == null) {
                    grayLicObj = new DynamicObject((DynamicObjectType)dataEntityType);
                    grayLicObj.set("grayfeature", featureNumber2FeatureObj.get(featureNumber));
                }
                Date startDate = featureJsonObject.getDate("startDate");
                Date endDate = featureJsonObject.getDate("endDate");
                grayLicObj.set("applicationdate", (Object)featureJsonObject.getDate("applyDate"));
                grayLicObj.set("begindate", (Object)LicenseUtil.getDateStartTime((Date)startDate));
                grayLicObj.set("enddate", (Object)LicenseUtil.getDateEndTime((Date)endDate));
                grayLicObj.set("status", (Object)GrayLicApplyStatusEnum.Success.toString());
                grayLicObjs.add(grayLicObj);
                grayFeatures.add(new GrayFeature(featureNumber, featureSchId, startDate, endDate));
                logger.info("\u66f4\u65b0\u6570\u636e\u5e93\u7070\u5ea6\u8bb8\u53ef\uff1anumber={},applicationdate={},begindate={},enddate={}", new Object[]{featureNumber, featureJsonObject.getString("applyDate"), featureJsonObject.getString("startDate"), featureJsonObject.getString("endDate")});
            }
            catch (Exception e) {
                logger.error("LicFileFeatureDataError-- featureJsonObject : " + featureJsonObject, (Throwable)e);
                if (!(e instanceof KDException) || !BosErrorCode.configNotFound.getCode().equals(((KDException)e).getErrorCode().getCode())) continue;
                throw e;
            }
        }
        for (Map.Entry needChangeStatuFeature : needChangeStatuFeatures.entrySet()) {
            grayLicObjs.add(needChangeStatuFeature.getValue());
        }
        if (grayLicObjs.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])grayLicObjs.toArray(new DynamicObject[grayLicObjs.size()]));
        }
        return grayFeatures;
    }

    private void checkGrayLic(JSONObject licFileJsonObject) {
        JSONObject content = licFileJsonObject.getJSONObject("content");
        if (content == null) {
            return;
        }
        String softwareCodeInLicFile = content.getString("softwareCode");
        Map productInfo = LicenseServiceHelper.getProductInfo();
        String softwareCodeInProduct = "";
        if (StringUtils.isBlank((CharSequence)softwareCodeInLicFile) || productInfo == null || StringUtils.isBlank((CharSequence)(softwareCodeInProduct = (String)productInfo.get("softwareCode"))) || !softwareCodeInLicFile.equals(softwareCodeInProduct)) {
            logger.info("updateGrayFeatureByLicFile#checkGrayLic:tidInMc={},tidInDb={}", (Object)softwareCodeInLicFile, (Object)softwareCodeInProduct);
            throw new KDBizException(ResManager.loadKDString((String)"\u5ba2\u6237\u8f6f\u4ef6\u7279\u5f81\u7801\u5339\u914d\u9519\u8bef\uff0c\u8bf7\u5728\u7ba1\u7406\u4e2d\u5fc3\u9009\u62e9\u6b63\u786e\u7684\u7070\u5ea6\u8bb8\u53ef\u6587\u4ef6\u5bfc\u5165\u3002", (String)"GrayLicenseDao_0", (String)"bos-license-business", (Object[])new Object[0]));
        }
    }

    private String checkFeature(Map<String, DynamicObject> featureNumber2FeatureObj, JSONObject featureJsonObject) {
        Date applyDate;
        Date endDate;
        StringBuilder msg = new StringBuilder();
        String featureNumber = featureJsonObject.getString("number");
        DynamicObject featureSchObj = featureNumber2FeatureObj.get(featureNumber);
        if (featureSchObj == null) {
            throw new KDException(BosErrorCode.configNotFound, new Object[]{featureNumber + " not find."});
        }
        Date startDate = featureJsonObject.getDate("startDate");
        if (startDate == null) {
            msg.append(ResManager.loadKDString((String)"\u7070\u5ea6\u8bb8\u53ef\u6587\u4ef6\u4e2d\uff0c\u8bb8\u53ef\u79df\u8d41\u8d77\u59cb\u65f6\u95f4\u4e3a\u7a7a\u3002", (String)"GrayLicenseDao_1", (String)"bos-license-business", (Object[])new Object[0]));
        }
        if ((endDate = featureJsonObject.getDate("endDate")) == null) {
            msg.append(ResManager.loadKDString((String)"\u7070\u5ea6\u8bb8\u53ef\u6587\u4ef6\u4e2d\uff0c\u8bb8\u53ef\u79df\u8d41\u7ed3\u675f\u65f6\u95f4\u4e3a\u7a7a\u3002", (String)"GrayLicenseDao_2", (String)"bos-license-business", (Object[])new Object[0]));
        }
        if ((applyDate = featureJsonObject.getDate("applyDate")) == null) {
            msg.append(ResManager.loadKDString((String)"\u7070\u5ea6\u8bb8\u53ef\u6587\u4ef6\u4e2d\uff0c\u8bb8\u53ef\u7533\u8bf7\u65f6\u95f4\u4e3a\u7a7a\u3002", (String)"GrayLicenseDao_3", (String)"bos-license-business", (Object[])new Object[0]));
        }
        return msg.toString();
    }
}

