/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.license.engine;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.dc.utils.MCDBUtil;
import kd.bos.dc.utils.SQLUtils;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.license.LicenseServiceUtil;
import kd.bos.license.LicenseUpdateService;
import kd.bos.license.UpdateLicCom;
import kd.bos.license.api.ILicenseService;
import kd.bos.license.api.LicenseAssignLog;
import kd.bos.license.bean.LicenseSyncDetailLog;
import kd.bos.license.bean.LicenseSyncLog;
import kd.bos.license.bean.updatelic.UserLicenseGroup;
import kd.bos.license.config.AESUtil;
import kd.bos.license.engine.LicenseUserRelEngine;
import kd.bos.license.pojo.LicenseDetailSnapshot;
import kd.bos.license.pojo.LicenseGeneralSnapshot;
import kd.bos.license.pojo.LicenseGroupAppSnapshot;
import kd.bos.license.pojo.LicenseSnapshot;
import kd.bos.license.service.cache.LicenseCache;
import kd.bos.license.service.cache.LicenseCacheMrg;
import kd.bos.license.util.LicGroupRuntimeUtil;
import kd.bos.license.util.LicModuleRuntimeUtil;
import kd.bos.license.util.LicenseEnvironmentUtil;
import kd.bos.license.util.LicenseGroupUtil;
import kd.bos.license.util.LicenseLogUtil;
import kd.bos.license.util.LicenseUpdateUtil;
import kd.bos.license.util.LicenseUtil;
import kd.bos.license.util.UserIndexUtil;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.OpLogAppInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.ErrorCodeUtils;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.log.LogServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.HttpClientUtils;

public class LicenseSnapshotEngine {
    private static final String PROP_GROUP = "group";
    private static final String PROP_PHONE = "phone";
    private static final String PROP_EMAIL = "email";
    private static final String PROP_NAME = "username";
    private static final String PROP_SYNCSTATUS = "syncstatus";
    private static final String PROP_STATUS = "status";
    private static final String ENTITY_USERLICGROUP = "lic_userlicensegroup";
    private static final String ENTITY_SNAPSHOT = "lic_snapshot";
    private static final String REDUCE_COUNT = "reduce_count";
    private static final String REDUCE_MODULE = "reduce_module";
    private static final Log logger = LogFactory.getLog(LicenseSnapshotEngine.class);

    public static boolean backUpTrial() {
        return LicenseSnapshotEngine.backUp(Boolean.TRUE);
    }

    public static boolean backUp() {
        return LicenseSnapshotEngine.backUp(Boolean.FALSE);
    }

    public static boolean backUpSystem() {
        return LicenseSnapshotEngine.backUp(Boolean.FALSE);
    }

    private static boolean backUp(Boolean isTrial) {
        if (isTrial == null) {
            return false;
        }
        String licenseTable = "t_lic_license";
        String licenseDetailTable = "t_lic_licensedetail";
        String licenseGroupAppsTable = "t_lic_licensegroupapps";
        String userLicenseGroupTable = "t_lic_userlicensegroup";
        String isTrialStr = "0";
        if (isTrial.booleanValue()) {
            licenseTable = "t_lic_license_trial";
            licenseDetailTable = "t_lic_licdetail_trial";
            licenseGroupAppsTable = "t_lic_licgroupapps_trial";
            userLicenseGroupTable = "t_lic_userlicgroup_trial";
            isTrialStr = "1";
        }
        try (DLock dlock = DLock.create((String)("LicenseSnapShot_" + RequestContext.get().getAccountId()));){
            dlock.lock();
            StringBuilder sql = new StringBuilder().append("SELECT tll.ftid,tll.fid fid,tll.ftype ftype,tll.fprodinstcode fprodinstcode,tll.fproductid fproductid,tll.fproductno fproductno,tll.fsoftwarecode fsoftwarecode,tll.findustry findustry,").append("tll.fproductversion fproductversion,tll.factivedate factivedate,tll.fexpdate fexpdate,tll.fsoftwarename fsoftwarename,tll.fprodid fprodid,tll.fname fname,tll.fscenetype fscenetype,tlld.fentryid fentryid,tlld.fgroupid fgroupid,").append("tlld.ftotalcount ftotalcount,tlld.fassignedcount fassignedcount,tlld.fremaincount fremaincount,tlld.fbegindate fbegindate,tlld.fenddate fenddate,tllga.fbizappid fbizappid,tllga.fmodulebegindate,tllga.fmoduleenddate,tlm.fnumber fmodulenumber from ").append(licenseTable).append(" tll LEFT JOIN ").append(licenseDetailTable).append(" tlld on tll.fid = tlld.fid LEFT JOIN ").append(licenseGroupAppsTable).append(" tllga ON tllga.fentryid = tlld.fentryid ").append(" LEFT join t_lic_module tlm on tlm.fid = tllga.fmoduleid");
            List licenseGeneralSnapshotList = (List)DB.query((DBRoute)DBRoute.base, (String)sql.toString(), k -> {
                ArrayList<LicenseSnapshot> licenseSnapshotList = new ArrayList<LicenseSnapshot>(4);
                HashMap<Long, LicenseSnapshot> licenseSnapshotMap = new HashMap<Long, LicenseSnapshot>(4);
                HashMap<Long, LicenseDetailSnapshot> licenseDetailSnapshotMap = new HashMap<Long, LicenseDetailSnapshot>(16);
                HashSet<String> appSet = new HashSet<String>(16);
                appSet.add(null);
                appSet.add("0");
                appSet.add("");
                appSet.add(" ");
                while (k.next()) {
                    java.sql.Date moduleEndDate;
                    String entryIdStr;
                    long id = k.getLong("fid");
                    LicenseSnapshot licenseSnapshot = (LicenseSnapshot)licenseSnapshotMap.get(id);
                    if (licenseSnapshot == null) {
                        String type = k.getString("ftype");
                        String prodInstCode = k.getString("fprodinstcode");
                        String productId = k.getString("fproductid");
                        String productNo = k.getString("fproductno");
                        String softwareCode = k.getString("fsoftwarecode");
                        String industry = k.getString("findustry");
                        String productVersion = k.getString("fproductversion");
                        java.sql.Date activeDate = k.getDate("factivedate");
                        java.sql.Date expDate = k.getDate("fexpdate");
                        String softwareName = k.getString("fsoftwarename");
                        String prodId = k.getString("fprodid");
                        String name = k.getString("fname");
                        String tid = k.getString("ftid");
                        licenseSnapshot = new LicenseSnapshot(id, type, prodInstCode, productId, productNo, softwareCode, industry, productVersion, (Date)activeDate, (Date)expDate, softwareName, prodId, name, tid);
                        licenseSnapshot.setSceneType(k.getString("fscenetype"));
                        licenseSnapshotMap.put(id, licenseSnapshot);
                        licenseSnapshotList.add(licenseSnapshot);
                    }
                    if (kd.bos.util.StringUtils.isEmpty((String)(entryIdStr = k.getString("fentryid")))) continue;
                    long entryId = Long.parseLong(entryIdStr);
                    LicenseDetailSnapshot licenseDetailSnapshot = (LicenseDetailSnapshot)licenseDetailSnapshotMap.get(entryId);
                    if (licenseDetailSnapshot == null) {
                        long groupId = k.getLong("fgroupid");
                        int totalCount = k.getInt("ftotalcount");
                        int assignCount = k.getInt("fassignedcount");
                        int remainCount = k.getInt("fremaincount");
                        java.sql.Date beginDate = k.getDate("fbegindate");
                        java.sql.Date endDate = k.getDate("fenddate");
                        licenseDetailSnapshot = new LicenseDetailSnapshot(groupId, totalCount, assignCount, remainCount, beginDate, endDate);
                        licenseDetailSnapshotMap.put(entryId, licenseDetailSnapshot);
                        licenseSnapshot.getDetailSnapshotList().add(licenseDetailSnapshot);
                    }
                    String appId = k.getString("fbizappid");
                    String moduleNum = k.getString("fmodulenumber");
                    if (!appSet.add(appId) && !appSet.add(moduleNum)) continue;
                    java.sql.Date moduleBeginDate = k.getDate("fmodulebegindate");
                    if (moduleBeginDate == null) {
                        moduleBeginDate = k.getDate("fbegindate");
                    }
                    if ((moduleEndDate = k.getDate("fmoduleenddate")) == null) {
                        moduleEndDate = k.getDate("fenddate");
                    }
                    licenseDetailSnapshot.getAppSnapshotList().add(new LicenseGroupAppSnapshot(appId, moduleNum, moduleBeginDate, moduleEndDate));
                }
                return licenseSnapshotList;
            });
            LicenseGeneralSnapshot snapshot = new LicenseGeneralSnapshot();
            snapshot.setLicenseSnapshots(licenseGeneralSnapshotList);
            Map<String, String> cache = LicenseCacheMrg.getCache(LicenseCacheMrg.getType4isTemporaryLicenseTrial());
            snapshot.setTempLic("1".equals(cache.get("isTemLic")));
            snapshot.setShowWaterMark(!"0".equals(cache.get("isShowWaterMark")));
            snapshot.setSceneType(cache.get("sceneType"));
            DB.execute((DBRoute)DBRoute.base, (String)"DELETE FROM T_LIC_Snapshot WHERE FSNAPSHOTTYPE = ?", (Object[])new Object[]{isTrialStr});
            String encrypt = AESUtil.encrypt(SerializationUtils.toJsonString((Object)snapshot));
            DB.execute((DBRoute)DBRoute.base, (String)"INSERT INTO T_LIC_Snapshot(FID, FDATA, FCREATETIME, FISTRIAL, FSNAPSHOTTYPE) VALUES (?, ?, ?, ?, ?)", (Object[])new Object[]{DB.genLongId((String)"T_LIC_Snapshot"), encrypt, new Date(), isTrialStr, isTrialStr});
        }
        catch (Exception e) {
            logger.error("License Snapshot Generate Fail.", (Throwable)e);
            return false;
        }
        if (!isTrial.booleanValue()) {
            if (LicenseServiceUtil.isEnableLegalPersonAssign()) {
                LicenseUpdateService.computeLegalPersonAssign();
            }
            OpLogAppInfo appLogInfo = new OpLogAppInfo();
            appLogInfo.setBizAppID("83bfebc8000037ac");
            appLogInfo.setBizObjID(ENTITY_SNAPSHOT);
            MultiLangEnumBridge opDescBridge = new MultiLangEnumBridge("\u8bb8\u53ef\u5feb\u7167\u5907\u4efd\u6210\u529f", "LicenseSnapshotEngine_11", "bos-license-business");
            appLogInfo.setOpDesc(opDescBridge, new String[0]);
            MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge("\u5feb\u7167\u5907\u4efd", "LicenseSnapshotEngine_12", "bos-license-business");
            appLogInfo.setOpName("snapshotBackup", opNameBridge);
            LogServiceHelper.addLog((AppLogInfo)appLogInfo);
        }
        return true;
    }

    private static Map<String, String> getAllModules() {
        return (Map)DB.query((DBRoute)DBRoute.base, (String)"select fid, fnumber from t_lic_module", k -> {
            HashMap<String, String> result = new HashMap<String, String>(1024);
            while (k.next()) {
                result.put(k.getString("fnumber"), k.getString("fid"));
            }
            return result;
        });
    }

    public static boolean restoreTrial() {
        return LicenseSnapshotEngine.restore(Boolean.TRUE, null, true);
    }

    public static boolean restore() {
        return LicenseSnapshotEngine.restore(Boolean.FALSE, null, true);
    }

    public static boolean restoreTrial(List<UserLicenseGroup> errorData, boolean isPublish) {
        return LicenseSnapshotEngine.restore(Boolean.TRUE, errorData, isPublish);
    }

    private static boolean restore(Boolean isTrial, List<UserLicenseGroup> errorData, boolean isPublish) {
        Map restoreResult;
        String sql = "select FDATA from T_LIC_Snapshot where fsnapshottype = '0'";
        if (isTrial.booleanValue()) {
            sql = "select FDATA from T_LIC_Snapshot where fsnapshottype = '1'";
        }
        if (null == (restoreResult = (Map)DB.query((DBRoute)DBRoute.base, (String)sql, k -> {
            HashMap<String, Object> result = new HashMap<String, Object>(2);
            if (k.next()) {
                String data = k.getString("FDATA");
                result.put("data", data);
                boolean isSucc = LicenseSnapshotEngine.restoreSnap(data, isPublish, errorData);
                result.put("success", isSucc);
                return result;
            }
            return result;
        })) || restoreResult.isEmpty()) {
            return false;
        }
        String data = (String)restoreResult.get("data");
        Object success = restoreResult.get("success");
        if (null == success || !((Boolean)success).booleanValue()) {
            return false;
        }
        DeleteServiceHelper.delete((String)ENTITY_SNAPSHOT, (QFilter[])new QFilter("snapshottype", "=", (Object)"2").toArray());
        DynamicObject snapshot = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_SNAPSHOT);
        snapshot.set("createtime", (Object)TimeServiceHelper.now());
        snapshot.set("data", (Object)data);
        snapshot.set("istrial", (Object)"0");
        snapshot.set("snapshottype", (Object)"2");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{snapshot});
        return true;
    }

    private static boolean restoreSnap(String data, boolean isPublish, List<UserLicenseGroup> errorData) {
        LicenseSyncLog log = new LicenseSyncLog();
        log.setPkId(Long.valueOf(DB.genGlobalLongId()));
        log.setOperation(ResManager.loadKDString((String)"\u66f4\u65b0\u8bb8\u53ef", (String)"LicenseSnapshotEngine_13", (String)"bos-license-business", (Object[])new Object[0]));
        List logs = log.getLogs();
        if (kd.bos.util.StringUtils.isEmpty((String)data)) {
            LicenseSyncDetailLog licenseSyncDetailLog = new LicenseSyncDetailLog();
            licenseSyncDetailLog.setLogType("3");
            licenseSyncDetailLog.setOperation(ResManager.loadKDString((String)"\u66f4\u65b0\u8bb8\u53ef\u6587\u4ef6", (String)"LicenseSnapshotEngine_0", (String)"bos-license-business", (Object[])new Object[0]));
            licenseSyncDetailLog.setDescription(ResManager.loadKDString((String)"\u8bb8\u53ef\u5907\u4efd\u4e3a\u7a7a", (String)"LicenseSnapshotEngine_14", (String)"bos-license-business", (Object[])new Object[0]));
            licenseSyncDetailLog.setSuccess(false);
            logs.add(licenseSyncDetailLog);
            LicenseLogUtil.addLicSyncLog((LicenseSyncLog)log);
            return false;
        }
        LicenseGeneralSnapshot snapshot = null;
        HashMap<String, String> map = new HashMap<String, String>(2);
        try (TXHandle h = TX.required((String)"lic_snapshot_restore");){
            try (DLock dlock = DLock.createReentrant((String)"lic_snapshot_restore");){
                String srcVer;
                dlock.lock();
                Map<String, String> allModules = LicenseSnapshotEngine.getAllModules();
                String ctrlAmountGroupType = "3";
                boolean isCtrlAmountLicense = false;
                HashMap<Long, Integer> groupSum = new HashMap<Long, Integer>(32);
                map.put("s", data);
                String snapshotStr = AESUtil.decrypt(data);
                try {
                    snapshot = (LicenseGeneralSnapshot)SerializationUtils.fromJsonString((String)snapshotStr, LicenseGeneralSnapshot.class);
                }
                catch (Exception e) {
                    snapshot = (LicenseGeneralSnapshot)JSON.parseObject((String)snapshotStr, LicenseGeneralSnapshot.class);
                }
                boolean isTempLic = snapshot.isTempLic();
                boolean isShowWaterMark = snapshot.isShowWaterMark();
                String sceneType = kd.bos.util.StringUtils.isBlank((String)snapshot.getSceneType()) && isTempLic ? "TEMP" : snapshot.getSceneType();
                List<LicenseSnapshot> licenseSnapshots = snapshot.getLicenseSnapshots();
                if (licenseSnapshots == null || licenseSnapshots.isEmpty()) {
                    throw new KDBizException("License snapshot is null or empty.");
                }
                String desVer = srcVer = LicenseServiceHelper.getProductVersion();
                ArrayList<DynamicObject> licenses = new ArrayList<DynamicObject>(licenseSnapshots.size());
                for (LicenseSnapshot licenseSnapshot : licenseSnapshots) {
                    DynamicObject license = BusinessDataServiceHelper.newDynamicObject((String)"lic_license");
                    license.set("id", (Object)licenseSnapshot.getId());
                    license.set("type", (Object)licenseSnapshot.getType());
                    license.set("prodinstcode", (Object)licenseSnapshot.getProdinstcode());
                    license.set("product", (Object)licenseSnapshot.getProductid());
                    license.set("productno", (Object)licenseSnapshot.getProductno());
                    license.set("softwarecode", (Object)licenseSnapshot.getSoftwarecode());
                    license.set("industry", (Object)licenseSnapshot.getIndustry());
                    String productVersion = licenseSnapshot.getProductversion();
                    license.set("productversion", (Object)productVersion);
                    license.set("name", (Object)licenseSnapshot.getName());
                    String softwareName = licenseSnapshot.getSoftwarename();
                    license.set("softwarename", (Object)softwareName);
                    String prodid = licenseSnapshot.getProdid();
                    license.set("prodid", (Object)prodid);
                    if ("1I6COPY94UBO".equals(prodid) || "1I6CUBKTC4GY".equals(prodid)) {
                        desVer = productVersion;
                    }
                    license.set("activedate", (Object)licenseSnapshot.getActivedate());
                    license.set("expdate", (Object)LicenseSnapshotEngine.parseObject2EndDate(licenseSnapshot.getExpdate()));
                    String tid = licenseSnapshot.getTid();
                    if (kd.bos.util.StringUtils.isNotEmpty((String)tid)) {
                        license.set("tid", (Object)tid);
                    }
                    license.set("scenetype", (Object)licenseSnapshot.getSceneType());
                    licenses.add(license);
                    List<LicenseDetailSnapshot> detailSnapshotList = licenseSnapshot.getDetailSnapshotList();
                    if (detailSnapshotList == null || detailSnapshotList.isEmpty()) continue;
                    DynamicObjectCollection licensedetailCol = license.getDynamicObjectCollection("lic_licensedetail");
                    DynamicObjectType licenseDetailType = licensedetailCol.getDynamicObjectType();
                    for (LicenseDetailSnapshot licenseDetailSnapshot : detailSnapshotList) {
                        long groupId = licenseDetailSnapshot.getGroupId();
                        if (0L == groupId) continue;
                        DynamicObject licensedetail = new DynamicObject(licenseDetailType);
                        licensedetail.set(PROP_GROUP, (Object)groupId);
                        if (groupId == 186L || groupId == 187L) {
                            isCtrlAmountLicense = true;
                            if (groupId == 187L) {
                                ctrlAmountGroupType = "1";
                            } else if (!ctrlAmountGroupType.equals("1")) {
                                ctrlAmountGroupType = "2";
                                LicenseSnapshotEngine.putLicExpireTimeCache();
                            }
                        }
                        int totalcount = licenseDetailSnapshot.getTotalcount();
                        groupSum.put(groupId, totalcount);
                        licensedetail.set("totalcount", (Object)totalcount);
                        licensedetail.set("assignedcount", (Object)licenseDetailSnapshot.getAssignedcount());
                        licensedetail.set("remaincount", (Object)licenseDetailSnapshot.getRemaincount());
                        licensedetail.set("begindate", (Object)licenseDetailSnapshot.getBegindate());
                        licensedetail.set("enddate", (Object)LicenseSnapshotEngine.parseObject2EndDate(licenseDetailSnapshot.getEnddate()));
                        licensedetailCol.add((Object)licensedetail);
                        List<LicenseGroupAppSnapshot> appSnapshotList = licenseDetailSnapshot.getAppSnapshotList();
                        if (appSnapshotList == null || appSnapshotList.isEmpty()) continue;
                        DynamicObjectCollection licensegroupapps = licensedetail.getDynamicObjectCollection("licensegroupapps");
                        DynamicObjectType licGroupAppsType = licensegroupapps.getDynamicObjectType();
                        for (LicenseGroupAppSnapshot licenseGroupAppSnapshot : appSnapshotList) {
                            Date moduleEndDate;
                            String bizapp = licenseGroupAppSnapshot.getBizapp();
                            String module = allModules.get(licenseGroupAppSnapshot.getModule());
                            if (kd.bos.util.StringUtils.isEmpty((String)module) && kd.bos.util.StringUtils.isNotEmpty((String)bizapp)) {
                                throw new KDBizException("module is null but bizapp is not null.");
                            }
                            DynamicObject licGroupAppObj = new DynamicObject(licGroupAppsType);
                            licGroupAppObj.set("bizapp", (Object)bizapp);
                            licGroupAppObj.set("module", (Object)module);
                            Date moduleBeginDate = licenseGroupAppSnapshot.getModuleBeginDate();
                            if (moduleBeginDate == null) {
                                moduleBeginDate = licensedetail.getDate("begindate");
                            }
                            if ((moduleEndDate = licenseGroupAppSnapshot.getModuleEndDate()) == null) {
                                moduleEndDate = licensedetail.getDate("enddate");
                            }
                            if (moduleEndDate != null) {
                                moduleEndDate = LicenseSnapshotEngine.parseObject2EndDate(moduleEndDate);
                            }
                            licGroupAppObj.set("modulebegindate", (Object)moduleBeginDate);
                            licGroupAppObj.set("moduleenddate", (Object)moduleEndDate);
                            licensegroupapps.add((Object)licGroupAppObj);
                        }
                    }
                }
                LicenseSnapshotEngine.clearLicenseData();
                SaveServiceHelper.save((DynamicObject[])licenses.toArray(new DynamicObject[0]));
                if (Float.parseFloat(desVer) >= 4.0f && Float.parseFloat(srcVer) < 4.0f && !srcVer.equals(desVer)) {
                    LicenseSnapshotEngine.updateUserLicenseData4V4();
                }
                boolean isPubTenantType = Boolean.parseBoolean(LicenseServiceHelper.getPubTenantType());
                UpdateLicCom updateLicCom = new UpdateLicCom(errorData, log, isPubTenantType, isCtrlAmountLicense, true, false);
                updateLicCom.checkAssignData();
                if (isCtrlAmountLicense) {
                    Map<Long, Integer> groupAssign = LicenseSnapshotEngine.updateUser4CtrlAmountLic(groupSum, true, log);
                    String updateSQL = "update t_lic_licensedetail set fassignedcount = ?,fremaincount = ? where fgroupid = ?";
                    ArrayList<Object[]> paramsList = new ArrayList<Object[]>(groupAssign.size());
                    for (Map.Entry<Long, Integer> entry : groupAssign.entrySet()) {
                        Integer assignCount = entry.getValue();
                        Long groupId = entry.getKey();
                        Integer totalCount = (Integer)groupSum.get(groupId);
                        if (null == totalCount || null == assignCount) continue;
                        Object[] param = new Object[]{assignCount, totalCount - assignCount, groupId};
                        paramsList.add(param);
                    }
                    DB.executeBatch((DBRoute)DBRoute.base, (String)updateSQL, paramsList);
                } else {
                    LicenseSnapshotEngine.updateUserLicGroupStatus(groupSum, true, log);
                }
                DataEntityCacheManager cacheManager = new DataEntityCacheManager((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"lic_license"));
                cacheManager.removeByDt();
                LicenseSnapshotEngine.disposeStandardDevConfig(groupSum);
                LicenseCacheMrg.clearAllCache();
                LicenseEnvironmentUtil.reloadRedisCache(data);
                LicGroupRuntimeUtil.reloadRedisCache(data);
                LicenseSnapshotEngine.updateCurAccountBitMap();
                LicModuleRuntimeUtil.reloadRedisCache(data);
                LicenseCache.reloadCtrlGroup();
                LicenseSyncDetailLog licenseSyncDetailLog = new LicenseSyncDetailLog();
                licenseSyncDetailLog.setLogType("3");
                licenseSyncDetailLog.setOperation(ResManager.loadKDString((String)"\u66f4\u65b0\u8bb8\u53ef\u6587\u4ef6", (String)"LicenseSnapshotEngine_0", (String)"bos-license-business", (Object[])new Object[0]));
                licenseSyncDetailLog.setDescription(ResManager.loadKDString((String)"\u66f4\u65b0\u8bb8\u53ef\u6587\u4ef6\u6210\u529f", (String)"LicenseSnapshotEngine_15", (String)"bos-license-business", (Object[])new Object[0]));
                licenseSyncDetailLog.setSuccess(true);
                logs.add(licenseSyncDetailLog);
                log.setSuccess(true);
                LicenseLogUtil.addLicSyncLog((LicenseSyncLog)log);
                OpLogAppInfo appLogInfo = new OpLogAppInfo();
                appLogInfo.setUserID(Long.valueOf(RequestContext.get().getCurrUserId()));
                appLogInfo.setBizAppID("83bfebc8000037ac");
                appLogInfo.setBizObjID(ENTITY_SNAPSHOT);
                MultiLangEnumBridge opDescBridge = new MultiLangEnumBridge("\u8bb8\u53ef\u66f4\u65b0\u6210\u529f", "LicenseSnapshotEngine_16", "bos-license-business");
                appLogInfo.setOpDesc(opDescBridge, new String[0]);
                MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge("\u66f4\u65b0\u8bb8\u53ef", "LicenseSnapshotEngine_13", "bos-license-business");
                appLogInfo.setOpName("updateLicense", opNameBridge);
                appLogInfo.setOrgID(Long.valueOf(RequestContext.get().getOrgId()));
                LogServiceHelper.addLog((AppLogInfo)appLogInfo);
            }
            catch (Exception e) {
                logger.error("License Snapshot Restore Fail.", (Throwable)e);
                LicenseCacheMrg.clearAllCache();
                LicenseCacheMrg.clearCache(LicenseCacheMrg.getLicEnvironmentalType());
                LicenseCacheMrg.clearCache(LicenseCacheMrg.getLicGroupRuntimeType());
                LicenseCacheMrg.clearCache(LicenseCacheMrg.getLicModuelRuntimeType());
                h.markRollback();
                log.setSuccess(false);
                log.setDescription(ResManager.loadKDString((String)"\u8bb8\u53ef\u66f4\u65b0\u5931\u8d25", (String)"LicenseSnapshotEngine_17", (String)"bos-license-business", (Object[])new Object[0]));
                LicenseSyncDetailLog licenseSyncDetailLog = new LicenseSyncDetailLog();
                licenseSyncDetailLog.setLogType("3");
                licenseSyncDetailLog.setOperation(ResManager.loadKDString((String)"\u66f4\u65b0\u8bb8\u53ef\u6587\u4ef6", (String)"LicenseSnapshotEngine_0", (String)"bos-license-business", (Object[])new Object[0]));
                String message = e.getMessage();
                if (null != message && message.length() > 255) {
                    message = message.substring(0, 255);
                }
                licenseSyncDetailLog.setDescription(String.format(ResManager.loadKDString((String)"\u8bb8\u53ef\u66f4\u65b0\u5931\u8d25%1$s", (String)"LicenseSnapshotEngine_27", (String)"bos-license-business", (Object[])new Object[0]), message));
                licenseSyncDetailLog.setSuccess(false);
                logs.add(licenseSyncDetailLog);
                LicenseLogUtil.addLicSyncLog((LicenseSyncLog)log);
                boolean ctrlAmountGroupType = false;
                if (h != null) {
                    if (var8_10 != null) {
                        try {
                            h.close();
                        }
                        catch (Throwable throwable) {
                            var8_10.addSuppressed(throwable);
                        }
                    } else {
                        h.close();
                    }
                }
                return ctrlAmountGroupType;
            }
        }
        if (!isPublish) {
            return true;
        }
        try {
            String json = JSONObject.toJSONString(map);
            String contextPath = RequestContext.get().getClientFullContextPath();
            if (contextPath.lastIndexOf("/") != contextPath.length() - 1) {
                contextPath = contextPath + "/";
            }
            String curAccountId = RequestContext.get().getAccountId();
            String tenantId = RequestContext.get().getTenantId();
            List accounts = AccountUtils.getAllAccounts((String)tenantId);
            Map<String, String> header = LicenseSnapshotEngine.getHttpRequestJsonHeader();
            for (Account account : accounts) {
                String accountId = account.getAccountId();
                if (accountId.equals(curAccountId)) continue;
                String accessToken = LicenseUtil.getAccessToken4LicApi((String)contextPath, (String)tenantId, (String)accountId);
                header.put("access_token", accessToken);
                String url = String.format("%skapi/v2/base/license/updateBySnapshot?accountId=%s", contextPath, accountId);
                String response = HttpClientUtils.postjson((String)url, header, (String)json, (int)300000, (int)500000);
                logger.info("accountId:" + accountId + ",response:" + response);
            }
        }
        catch (Exception exception) {
            logger.error("\u63a8\u9001\u5230\u5176\u5b83\u6570\u636e\u4e2d\u5fc3\u5931\u8d25", (Throwable)exception);
        }
        return true;
    }

    public static boolean restoreSnap(String data, boolean isPublish) {
        boolean success = LicenseSnapshotEngine.restoreSnap(data, isPublish, null);
        if (success) {
            DeleteServiceHelper.delete((String)ENTITY_SNAPSHOT, (QFilter[])new QFilter("snapshottype", "=", (Object)"2").toArray());
            DynamicObject snapshot = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_SNAPSHOT);
            snapshot.set("createtime", (Object)TimeServiceHelper.now());
            snapshot.set("data", (Object)data);
            snapshot.set("istrial", (Object)"0");
            snapshot.set("snapshottype", (Object)"2");
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{snapshot});
        }
        return success;
    }

    private static void disposeStandardDevConfig(Map<Long, Integer> groupAll) {
        DynamicObject[] licStddevcfgs;
        int count = 0;
        if (null != groupAll) {
            Integer total = groupAll.get(252L);
            int n = count = null == total ? 0 : Integer.parseInt(total.toString());
        }
        if (null == (licStddevcfgs = BusinessDataServiceHelper.load((String)"lic_stddevcfg", (String)"bizobject,modifytime,status,comment", (QFilter[])new QFilter[]{new QFilter(PROP_STATUS, "=", (Object)"true")}, (String)"modifytime")) || licStddevcfgs.length == 0) {
            return;
        }
        String errorMessage = REDUCE_COUNT;
        if (count <= 0) {
            errorMessage = REDUCE_MODULE;
        }
        ArrayList<DynamicObject> reConfigs = new ArrayList<DynamicObject>(16);
        for (DynamicObject licStddevcfg : licStddevcfgs) {
            if (--count >= 0) continue;
            licStddevcfg.set(PROP_STATUS, (Object)"false");
            licStddevcfg.set("comment", (Object)errorMessage);
            reConfigs.add(licStddevcfg);
        }
        if (CollectionUtils.isNotEmpty(reConfigs)) {
            SaveServiceHelper.save((DynamicObject[])reConfigs.toArray(new DynamicObject[0]));
        }
    }

    private static void updateTempLicCache(boolean isTemporaryLicense, boolean isShowWaterMark, String sceneType) {
        try {
            String type4isTemporaryLicense = LicenseCacheMrg.getType4isTemporaryLicense();
            HashMap<String, String> cacheMap = new HashMap<String, String>(2);
            cacheMap.put("isTemLic", isTemporaryLicense ? "1" : "0");
            cacheMap.put("isShowWaterMark", isShowWaterMark ? "1" : "0");
            cacheMap.put("sceneType", sceneType == null ? "" : sceneType);
            LicenseCacheMrg.putCache(type4isTemporaryLicense, cacheMap);
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0\u4e34\u65f6\u8bb8\u53ef\u7f13\u5b58\u6807\u8bb0\u5f02\u5e38", (Throwable)e);
        }
    }

    private static void updateUserLicenseData4V4() {
        String sql;
        LicenseServiceHelper.addLog((String)ResManager.loadKDString((String)"\u540c\u6b65\u8bb8\u53ef", (String)"LicenseSnapshotEngine_18", (String)"bos-license-business", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u6267\u884c4.0\u8bb8\u53ef\u6570\u636e\u5347\u7ea7", (String)"LicenseSnapshotEngine_19", (String)"bos-license-business", (Object[])new Object[0]));
        try {
            sql = "DELETE FROM T_LIC_USERLICENSEGROUPBAK";
            DB.execute((DBRoute)DBRoute.base, (String)sql);
            sql = "INSERT INTO T_LIC_USERLICENSEGROUPBAK(FID, FUSERID, FGROUPID, FSYNCSTATUS, FORGID) SELECT FID, FUSERID, FGROUPID, FSYNCSTATUS, FORGID FROM T_LIC_USERLICENSEGROUP ";
            DB.execute((DBRoute)DBRoute.base, (String)sql);
        }
        catch (Exception e) {
            logger.error("LicenseUpdateService.updateUserLicenseData4V4() error", (Throwable)e);
            LicenseServiceHelper.addLog((String)ResManager.loadKDString((String)"\u540c\u6b65\u8bb8\u53ef", (String)"LicenseSnapshotEngine_18", (String)"bos-license-business", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u6267\u884c4.0\u8bb8\u53ef\u6570\u636e\u5347\u7ea7\u524d\u7684\u6570\u636e\u5907\u4efd\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u7528\u6237\u8bb8\u53ef\u5206\u7ec4\u6570\u636e\u3002", (String)"LicenseSnapshotEngine_20", (String)"bos-license-business", (Object[])new Object[0]));
        }
        try {
            sql = "UPDATE T_LIC_USERLICENSEGROUP SET FGROUPID = 13, FSYNCSTATUS = '2', FSTATUS = '0' WHERE FGROUPID = 40 ";
            DB.execute((DBRoute)DBRoute.base, (String)sql);
            sql = "UPDATE T_LIC_USERLICENSEGROUP SET FGROUPID = 401, FSYNCSTATUS = '2', FSTATUS = '0' WHERE FGROUPID IN(4, 5, 23, 104, 89, 25, 111, 116) ";
            DB.execute((DBRoute)DBRoute.base, (String)sql);
            sql = "UPDATE T_LIC_USERLICENSEGROUP SET FGROUPID = 406, FSYNCSTATUS = '2', FSTATUS = '0' WHERE FGROUPID IN(34, 87, 88) ";
            DB.execute((DBRoute)DBRoute.base, (String)sql);
            sql = "UPDATE T_LIC_USERLICENSEGROUP SET FGROUPID = 412, FSYNCSTATUS = '2', FSTATUS = '0' WHERE FGROUPID = 9 AND FUSERID IN (SELECT FID FROM T_SEC_USER WHERE (FUSERTYPE = '3' ) OR (FUSERTYPE LIKE '3,%') OR (FUSERTYPE LIKE '%,3') OR (FUSERTYPE LIKE '%,3,%')) ";
            DB.execute((DBRoute)DBRoute.base, (String)sql);
            sql = "DELETE FROM T_LIC_USERLICENSEGROUP WHERE FID NOT IN (SELECT FID FROM (SELECT MIN(FID) FID FROM T_LIC_USERLICENSEGROUP GROUP BY FUSERID, FGROUPID)T) ";
            DB.execute((DBRoute)DBRoute.base, (String)sql);
        }
        catch (Exception e) {
            logger.error("LicenseUpdateService.updateUserLicenseData4V4() error", (Throwable)e);
            LicenseServiceHelper.addLog((String)ResManager.loadKDString((String)"\u540c\u6b65\u8bb8\u53ef", (String)"LicenseSnapshotEngine_18", (String)"bos-license-business", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u6267\u884c4.0\u8bb8\u53ef\u6570\u636e\u5347\u7ea7\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u7528\u6237\u8bb8\u53ef\u5206\u7ec4\u6570\u636e\u3002", (String)"LicenseSnapshotEngine_21", (String)"bos-license-business", (Object[])new Object[0]));
        }
    }

    private static Map<String, String> getHttpRequestJsonHeader() {
        HashMap<String, String> header = new HashMap<String, String>(4);
        header.put("Content-type", "application/json");
        header.put("charset", "utf-8");
        return header;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void updateUserLicGroupStatus(Map<Long, Integer> groupAll, boolean isManual, LicenseSyncLog log) {
        Object account2222222;
        String tenantId = RequestContext.get().getTenantId();
        String curAccountId = RequestContext.get().getAccountId();
        List accounts = AccountUtils.getAllAccounts((String)tenantId);
        if (CollectionUtils.isEmpty((Collection)accounts)) {
            logger.error("null == accounts \u83b7\u53d6\u4e0d\u5230\u662f\u6570\u636e\u4e2d\u5fc3\uff0c\u66f4\u65b0\u5206\u7ec4\u72b6\u6001\u5f02\u5e38\u3002");
            return;
        }
        String characteristic = (String)LicenseUtil.getUniqueCharacteristic().get("field");
        String characteristicNum = (String)LicenseUtil.getUniqueCharacteristic().get("fieldNum");
        if (accounts.size() < 2) {
            LicenseSnapshotEngine.updateUser4CtrlAmountLic(groupAll, isManual, log);
            return;
        }
        Map licenseGroup = LicenseGroupUtil.getLicenseGroup(null);
        Map<Long, String> groupIdAndName = licenseGroup.entrySet().stream().collect(Collectors.toMap(entry -> Long.parseLong((String)entry.getKey()), Map.Entry::getValue));
        Map groupIdAndNumber = LicenseGroupUtil.getAllGroupIdAndNumber();
        List logs = log.getLogs();
        HashMap<Long, LinkedList> groupAnduserLicDatas = new HashMap<Long, LinkedList>(16);
        HashMap<Long, Set> groupAndUserCharacteristics = new HashMap<Long, Set>(16);
        HashSet<Long> noGroup = new HashSet<Long>(16);
        for (Object account2222222 : accounts) {
            boolean bl = account2222222.getAccountId().equals(curAccountId);
            Properties dataBaseProperties = AccountUtils.getTenantDBInfo((Account)account2222222);
            Connection conn = null;
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                conn = MCDBUtil.getConnection((Account)account2222222, (Properties)dataBaseProperties);
                String sql = "SELECT ubi.fbitmapindex fbitmapindex, tlu.fid fid, tlu.fuserid fuserid, tlu.fgroupid fgroupid, tlu.forgid forgid, tlu.fassigntime fassigntime, tsu.fphone fphone, tsu.femail femail, tsuu.fusername fusername from t_lic_userlicensegroup tlu inner join t_lic_userbitmapindex ubi on ubi.fid = tlu.fuserid inner join t_sec_user tsu on tsu.fid = tlu.fuserid inner join t_sec_user_u tsuu on tsuu.fid = tsu.fid where tsu.fenable = '1' and tsuu.fisforbidden = '0' and tlu.fsyncstatus in ('1','2') order by tlu.fassigntime ";
                pstmt = conn.prepareStatement(sql);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    HashMap<String, Object> userLicGroup = new HashMap<String, Object>(8);
                    long userLicGroupId = rs.getLong("fid");
                    String userCharacteristic = rs.getString(characteristic);
                    if (StringUtils.isNotBlank((CharSequence)userCharacteristic)) {
                        userCharacteristic = DB.genStringId((String)"t_lic_group");
                    }
                    userLicGroup.put("id", userLicGroupId);
                    long groupId = rs.getLong("fgroupid");
                    userLicGroup.put("userid", rs.getLong("fuserid"));
                    userLicGroup.put("groupid", rs.getLong("fgroupid"));
                    userLicGroup.put("orgid", groupId);
                    userLicGroup.put("assigntime", rs.getDate("fassigntime"));
                    userLicGroup.put("characteristic", userCharacteristic);
                    userLicGroup.put("bitmapindex", rs.getInt("fbitmapindex"));
                    groupAnduserLicDatas.computeIfAbsent(groupId, k -> new LinkedList()).add(userLicGroup);
                    groupAndUserCharacteristics.computeIfAbsent(groupId, k -> new HashSet()).add(userCharacteristic);
                    if (!bl || groupAll.containsKey(groupId)) continue;
                    noGroup.add(groupId);
                }
            }
            catch (SQLException sqlExp) {
                try {
                    logger.error((Throwable)sqlExp);
                    throw new KDException((Throwable)sqlExp, BosErrorCode.sQLConnection, new Object[]{ErrorCodeUtils.getDBIntralError() + ErrorCodeUtils.getSlipSignerror() + sqlExp.getMessage()});
                    catch (Exception exp) {
                        logger.error((Throwable)exp);
                        throw new KDException((Throwable)exp, BosErrorCode.sQLConnection, new Object[]{ErrorCodeUtils.getDBIntralError() + ErrorCodeUtils.getSlipSignerror() + exp.getMessage()});
                    }
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, pstmt, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
        }
        String updateUserLicStatus = "UPDATE t_lic_userlicensegroup set FSYNCSTATUS = '1', FSTATUS = '1' WHERE fsyncstatus  in('1','2') AND FSTATUS = '0' ";
        DB.execute((DBRoute)DBRoute.base, (String)updateUserLicStatus);
        for (Map.Entry entry2 : groupAll.entrySet()) {
            HashSet userCharacteristics;
            Long groupId = (Long)entry2.getKey();
            Integer sum = (Integer)entry2.getValue();
            LinkedList userLicGroupList = (LinkedList)groupAnduserLicDatas.get(groupId);
            if (null == userLicGroupList) {
                userLicGroupList = new LinkedList();
            }
            if (null == (userCharacteristics = (HashSet)groupAndUserCharacteristics.get(groupId))) {
                userCharacteristics = new HashSet(16);
            }
            if (userCharacteristics.size() <= sum) continue;
            Comparator comparator = Comparator.nullsLast(Long::compareTo);
            userLicGroupList.sort((map1, map2) -> {
                Long id1 = (Long)map1.get("id");
                Long id2 = (Long)map2.get("id");
                return comparator.compare(id1, id2);
            });
            HashSet<Integer> successUserBitMapIdxs = new HashSet<Integer>(sum);
            for (Map map : userLicGroupList) {
                Integer userBitMapindex = (Integer)map.get("bitmapindex");
                if (successUserBitMapIdxs.size() >= sum) break;
                successUserBitMapIdxs.add(userBitMapindex);
            }
            if (CollectionUtils.isEmpty(successUserBitMapIdxs)) {
                SqlBuilder updateStatus = new SqlBuilder().append("UPDATE t_lic_userlicensegroup SET FSYNCSTATUS = '3', FSTATUS = '0',fsynclogid = " + log.getPkId() + ",fassigntime = now() ", new Object[0]).append(" where fgroupid = " + groupId, new Object[0]);
                DB.execute((DBRoute)DBRoute.base, (SqlBuilder)updateStatus);
            } else {
                ArrayList<Long> successUsers = new ArrayList<Long>(successUserBitMapIdxs.size());
                Map userIdListBySet = UserIndexUtil.getUserIdListBySet(successUserBitMapIdxs);
                for (Long userId : userIdListBySet.values()) {
                    successUsers.add(userId);
                }
                try (DataSet queryAssignData = DB.queryDataSet((String)"queryAssignData", (DBRoute)DBRoute.base, (String)("select fid,fuserid userId from t_lic_userlicensegroup where fgroupid = " + groupId));){
                    HashSet<Long> errorPkId = new HashSet<Long>(16);
                    while (queryAssignData.hasNext()) {
                        Row next = queryAssignData.next();
                        if (successUsers.contains(next.getLong("userId"))) continue;
                        errorPkId.add(next.getLong("fid"));
                    }
                    if (!CollectionUtils.isEmpty(errorPkId)) {
                        LicenseUpdateUtil.updateLicAssignDataError((Long)log.getPkId(), new ArrayList(errorPkId));
                    }
                }
            }
            String opDescription = String.format(ResManager.loadKDString((String)"%1$s\u7ad9\u70b9\u6570\u4e0d\u8db3\u3002", (String)"LicenseSnapshotEngine_22", (String)"bos-license-business", (Object[])new Object[0]), groupIdAndName.get(groupId) + "(" + (String)groupIdAndNumber.get(groupId) + ")");
            LicenseServiceHelper.addLog((String)ResManager.loadKDString((String)"\u66f4\u65b0\u8bb8\u53ef", (String)"LicenseSnapshotEngine_13", (String)"bos-license-business", (Object[])new Object[0]), (String)opDescription);
            LicenseSyncDetailLog licenseSyncDetailLog = new LicenseSyncDetailLog();
            licenseSyncDetailLog.setLogType("3");
            licenseSyncDetailLog.setOperation("reduceTotal");
            licenseSyncDetailLog.setDescription(opDescription);
            licenseSyncDetailLog.setSuccess(false);
            logs.add(licenseSyncDetailLog);
        }
        if (CollectionUtils.isEmpty(noGroup)) {
            return;
        }
        account2222222 = noGroup.iterator();
        while (true) {
            if (!account2222222.hasNext()) {
                SqlBuilder updateStatusSql = new SqlBuilder();
                updateStatusSql.append("UPDATE ", new Object[0]).append(" T_LIC_USERLICENSEGROUP ", new Object[0]).append(" set FSYNCSTATUS = '3',FSTATUS = '0',fsynclogid = ", new Object[0]).append(log.getPkId() + " ", new Object[0]).append(" WHERE ", new Object[0]).appendIn("fgroupid", noGroup.toArray());
                DB.execute((DBRoute)DBRoute.base, (SqlBuilder)updateStatusSql);
                return;
            }
            Long l = (Long)account2222222.next();
            LicenseSyncDetailLog licenseSyncDetailLog = new LicenseSyncDetailLog();
            licenseSyncDetailLog.setLogType("3");
            licenseSyncDetailLog.setOperation("reduceGroup");
            licenseSyncDetailLog.setReason(String.format(ResManager.loadKDString((String)"%1$s\uff08%2$s\uff09\u672a\u8d2d\u4e70\u3002", (String)"LicenseSnapshotEngine_6", (String)"bos-license-business", (Object[])new Object[0]), groupIdAndName.get(l), groupIdAndNumber.get(l)));
            licenseSyncDetailLog.setSuccess(false);
            logs.add(licenseSyncDetailLog);
        }
    }

    private static void updateCurAccountBitMap() {
        String sql = "select fgroupid, fuserid from t_lic_userlicensegroup where fsyncstatus = '1' ";
        DB.query((DBRoute)DBRoute.base, (String)sql, k -> {
            HashSet<Long> userIds = new HashSet<Long>(1024);
            HashMap<Long, Set> groupUserMap = new HashMap<Long, Set>(16);
            while (k.next()) {
                long userId = k.getLong("fuserid");
                userIds.add(userId);
                groupUserMap.computeIfAbsent(k.getLong("fgroupid"), kt -> new HashSet()).add(userId);
            }
            Map<Long, Integer> userBitMapIndex = LicenseUserRelEngine.getUserBitMapIndex(userIds);
            HashMap<Long, List<Integer>> licUserRelMap = new HashMap<Long, List<Integer>>(groupUserMap.size());
            for (Map.Entry entry : groupUserMap.entrySet()) {
                Long groupId = (Long)entry.getKey();
                for (Long userId : (Set)entry.getValue()) {
                    Integer index = userBitMapIndex.get(userId);
                    if (null == index) continue;
                    licUserRelMap.computeIfAbsent(groupId, v -> new ArrayList()).add(userBitMapIndex.get(userId));
                }
            }
            LicenseUserRelEngine.resetCurrAccountLicUserRelBit(licUserRelMap);
            return true;
        });
    }

    private static void clearLicenseData() {
        String sql = "DELETE FROM T_LIC_LICENSE";
        try {
            DB.execute((DBRoute)DBRoute.base, (String)sql);
        }
        catch (Exception e) {
            logger.error("LicenseSnapshotEngine.clearLicenseData error", (Throwable)e);
        }
        sql = "DELETE FROM T_LIC_LICENSEDETAIL";
        try {
            DB.execute((DBRoute)DBRoute.base, (String)sql);
        }
        catch (Exception e) {
            logger.error("LicenseSnapshotEngine.clearLicenseData error", (Throwable)e);
        }
        sql = "DELETE FROM T_LIC_LICENSEGROUPAPPS ";
        try {
            DB.execute((DBRoute)DBRoute.base, (String)sql);
        }
        catch (Exception e) {
            logger.error("LicenseSnapshotEngine.clearLicenseData error", (Throwable)e);
        }
    }

    private static Date parseObject2EndDate(Date date) {
        Calendar cal = Calendar.getInstance();
        try {
            cal.setTime(date);
            cal.set(11, 23);
            cal.set(12, 59);
            cal.set(13, 59);
        }
        catch (Exception e) {
            logger.error("\u65e5\u671f\u8f6c\u6362\u5f02\u5e38", (Throwable)e);
        }
        return cal.getTime();
    }

    private static Map<Long, Integer> updateUser4CtrlAmountLic(Map<Long, Integer> groupAll, boolean isManual, LicenseSyncLog log) {
        List logs = log.getLogs();
        if (groupAll.isEmpty()) {
            DB.execute((DBRoute)DBRoute.base, (String)("UPDATE t_lic_userlicensegroup set FSYNCSTATUS = '3', FSTATUS = '0',fsynclogid = " + log.getPkId() + ",fassigntime = now()"));
            if (isManual) {
                String opDescription = ResManager.loadKDString((String)"\u8bb8\u53ef\u4e2d\u65e0\u53ef\u5206\u914d\u5206\u7ec4\u3002", (String)"UpdateLicGroupUser_46", (String)"bos-license-business", (Object[])new Object[0]);
                LicenseServiceHelper.addLog((String)ResManager.loadKDString((String)"\u66f4\u65b0\u8bb8\u53ef", (String)"LicenseSnapshotEngine_13", (String)"bos-license-business", (Object[])new Object[0]), (String)opDescription);
                LicenseSyncDetailLog licenseSyncDetailLog = new LicenseSyncDetailLog();
                licenseSyncDetailLog.setLogType("3");
                licenseSyncDetailLog.setOperation(ResManager.loadKDString((String)"\u66f4\u65b0\u8bb8\u53ef", (String)"LicenseSnapshotEngine_13", (String)"bos-license-business", (Object[])new Object[0]));
                licenseSyncDetailLog.setDescription(opDescription);
                licenseSyncDetailLog.setSuccess(false);
                logs.add(licenseSyncDetailLog);
            }
            return Collections.emptyMap();
        }
        Map licenseGroup = LicenseGroupUtil.getLicenseGroup(null);
        Map<Long, String> groupIdAndName = licenseGroup.entrySet().stream().collect(Collectors.toMap(entry -> Long.parseLong((String)entry.getKey()), Map.Entry::getValue));
        Map<Long, Integer> groupCount = groupIdAndName.keySet().stream().collect(Collectors.toMap(key -> key, key -> 0));
        Map groupIdAndNumber = LicenseGroupUtil.getAllGroupIdAndNumber();
        String updateUserLicStatus = "UPDATE t_lic_userlicensegroup set FSYNCSTATUS = '1', FSTATUS = '1' WHERE fsyncstatus  in('1','2') AND FSTATUS = '0' ";
        DB.execute((DBRoute)DBRoute.base, (String)updateUserLicStatus);
        HashSet reduceModuleGruopIds = new HashSet(groupAll.size());
        HashMap<Long, Integer> overRangeGroupIdAndOverCountMap = new HashMap<Long, Integer>(16);
        String sql = "SELECT tlu.fgroupid fgroupid, count(1) fcount from t_lic_userlicensegroup tlu where tlu.fsyncstatus = '1' GROUP BY tlu.fgroupid ";
        Map groupAssign = (Map)DB.query((DBRoute)DBRoute.base, (String)sql, k -> {
            HashMap<Long, Integer> groupAssigned = new HashMap<Long, Integer>(16);
            while (k.next()) {
                long fgroupId = k.getLong("fgroupid");
                reduceModuleGruopIds.add(fgroupId);
                groupAssigned.put(fgroupId, k.getInt("fcount"));
            }
            return groupAssigned;
        });
        for (Map.Entry<Long, Integer> entry2 : groupAll.entrySet()) {
            Long groupId = entry2.getKey();
            reduceModuleGruopIds.remove(groupId);
            int sumCount = entry2.getValue();
            int assignCount = groupAssign.getOrDefault(groupId, 0);
            groupCount.put(groupId, Integer.min(sumCount, assignCount));
            if (assignCount <= sumCount) continue;
            overRangeGroupIdAndOverCountMap.put(groupId, assignCount - sumCount);
            if (!isManual) continue;
            String opDescription = String.format(ResManager.loadKDString((String)"%1$s\u7ad9\u70b9\u6570\u4e0d\u8db3\u3002", (String)"LicenseSnapshotEngine_22", (String)"bos-license-business", (Object[])new Object[0]), groupIdAndName.get(groupId) + "(" + (String)groupIdAndNumber.get(groupId) + ")");
            LicenseServiceHelper.addLog((String)ResManager.loadKDString((String)"\u66f4\u65b0\u8bb8\u53ef", (String)"LicenseSnapshotEngine_13", (String)"bos-license-business", (Object[])new Object[0]), (String)opDescription);
            LicenseSyncDetailLog licenseSyncDetailLog = new LicenseSyncDetailLog();
            licenseSyncDetailLog.setLogType("3");
            licenseSyncDetailLog.setOperation("reduceTotal");
            licenseSyncDetailLog.setDescription(opDescription);
            licenseSyncDetailLog.setSuccess(false);
            logs.add(licenseSyncDetailLog);
        }
        try {
            if (CollectionUtils.isNotEmpty(reduceModuleGruopIds)) {
                SqlBuilder noGroupGroupAssignDataSql = new SqlBuilder();
                noGroupGroupAssignDataSql.append("update t_lic_userlicensegroup set fsyncstatus = '3',fstatus = '0',fsynclogid = " + log.getPkId() + ",fassigntime = now()", new Object[0]).append(" where ", new Object[0]).appendIn("fgroupid", reduceModuleGruopIds.toArray());
                DB.execute((DBRoute)DBRoute.base, (SqlBuilder)noGroupGroupAssignDataSql);
                LicenseSyncDetailLog licenseSyncDetailLog = new LicenseSyncDetailLog();
                for (Long groupId : reduceModuleGruopIds) {
                    licenseSyncDetailLog.setLogType("3");
                    licenseSyncDetailLog.setOperation("reduceGroup");
                    licenseSyncDetailLog.setReason(String.format(ResManager.loadKDString((String)"%1$s\uff08%2$s\uff09\u672a\u8d2d\u4e70\u3002", (String)"LicenseSnapshotEngine_6", (String)"bos-license-business", (Object[])new Object[0]), groupIdAndName.get(groupId), groupIdAndNumber.get(groupId)));
                    licenseSyncDetailLog.setDescription(ResManager.loadKDString((String)"\u5904\u7406\u53ea\u63a7\u5236\u6570\u91cf\u8bb8\u53ef\u7528\u6237\u4fe1\u606f", (String)"LicenseSnapshotEngine_5", (String)"bos-license-business", (Object[])new Object[0]));
                    licenseSyncDetailLog.setSuccess(false);
                    logs.add(licenseSyncDetailLog);
                }
            }
            if (!overRangeGroupIdAndOverCountMap.isEmpty()) {
                ArrayList errorIds = new ArrayList(16);
                for (Map.Entry groupInfo : overRangeGroupIdAndOverCountMap.entrySet()) {
                    Integer overCount = (Integer)groupInfo.getValue();
                    Long groupId = (Long)groupInfo.getKey();
                    if (null == overCount || overCount <= 0 || null == groupId) continue;
                    SqlBuilder selectTopSql = new SqlBuilder();
                    selectTopSql.append("select top ", new Object[0]);
                    selectTopSql.append(String.valueOf(overCount), new Object[0]);
                    selectTopSql.append(" fid from ", new Object[0]);
                    selectTopSql.append("t_lic_userlicensegroup", new Object[0]);
                    selectTopSql.append(" where fgroupid = ", new Object[0]).append(String.valueOf(groupId), new Object[0]).append(" and ", new Object[0]);
                    selectTopSql.append(" fsyncstatus = '1' ", new Object[0]);
                    selectTopSql.append(" order by fassigntime desc ", new Object[0]);
                    DB.query((DBRoute)DBRoute.base, (SqlBuilder)selectTopSql, k -> {
                        HashSet<Long> result = new HashSet<Long>(16);
                        while (k.next()) {
                            result.add(k.getLong("fid"));
                        }
                        errorIds.addAll(result);
                        return result;
                    });
                }
                LicenseUpdateUtil.updateLicAssignDataError((Long)log.getPkId(), errorIds);
            }
        }
        catch (Exception e) {
            logger.error("UpdateLicGroupUser.updateUser4CtrlAmountLic \u66f4\u65b0\u7528\u6237\u8bb8\u53ef\u5206\u7ec4\u72b6\u6001\u5f02\u5e38", (Throwable)e);
            String opDescription = ResManager.loadKDString((String)"\u66f4\u65b0\u7528\u6237\u8bb8\u53ef\u5206\u7ec4\u72b6\u6001\u5f02\u5e38\u3002", (String)"LicenseSnapshotEngine_23", (String)"bos-license-business", (Object[])new Object[0]);
            log.setDescription(opDescription);
            log.setSuccess(false);
            throw new KDBizException(opDescription);
        }
        return groupCount;
    }

    private static void updateLicSyncStatus(Set<Long> successIdSet) {
        if (CollectionUtils.isEmpty(successIdSet)) {
            return;
        }
        SqlBuilder updateSql = new SqlBuilder().append("UPDATE t_lic_userlicensegroup SET FSYNCSTATUS = '1', FSTATUS = '1' WHERE ", new Object[0]);
        updateSql.appendIn("FID", new ArrayList<Long>(successIdSet));
        DB.execute((DBRoute)DBRoute.base, (SqlBuilder)updateSql);
    }

    private static void releaseFeatureGroupUserLic(LicenseSyncLog licenseSyncLog, String logType) {
        List logs = licenseSyncLog.getLogs();
        String selectFeatureGroupSql = "select fid from t_lic_group where ftype ='2' ";
        HashSet featureGroupIds = new HashSet(110);
        DB.query((DBRoute)DBRoute.base, (String)selectFeatureGroupSql, k -> {
            while (k.next()) {
                featureGroupIds.add(k.getLong("fid"));
            }
            return true;
        });
        if (CollectionUtils.isNotEmpty(featureGroupIds)) {
            SqlBuilder sql = new SqlBuilder();
            sql.append("UPDATE t_lic_userlicensegroup SET FSYNCSTATUS = '3',FSTATUS = '0',fsynclogid = " + licenseSyncLog.getPkId() + ",fassigntime = now() WHERE ", new Object[0]);
            sql.appendIn("fgroupid", new ArrayList(featureGroupIds));
            DB.execute((DBRoute)DBRoute.base, (SqlBuilder)sql);
        }
    }

    private static void releaseUniqueCharacteristicErrorUserLic(LicenseSyncLog licenseSyncLog, String logType, String operation) {
        try {
            List logs = licenseSyncLog.getLogs();
            ArrayList<LicenseAssignLog> licenseAssignLogs = new ArrayList<LicenseAssignLog>(10);
            Map uniqueCharacteristic = LicenseUtil.getUniqueCharacteristic();
            String fieldNum = (String)uniqueCharacteristic.get("fieldNum");
            String reason = String.format(ResManager.loadKDString((String)"\u7528\u6237\u7684%1$s\u4e3a\u7a7a\u3002", (String)"LicenseSnapshotEngine_28", (String)"bos-license-business", (Object[])new Object[0]), fieldNum);
            DynamicObject[] load = BusinessDataServiceHelper.load((String)ENTITY_USERLICGROUP, (String)"user,group", (QFilter[])new QFilter[]{new QFilter("user." + fieldNum, "=", (Object)" ").or(new QFilter("user." + fieldNum, "is null", (Object)"")), new QFilter(PROP_SYNCSTATUS, "in", (Object)new String[]{"1", "2"})});
            if (null == load || load.length == 0) {
                return;
            }
            ArrayList<Object> errorId = new ArrayList<Object>(16);
            HashSet<Object> userId = new HashSet<Object>(16);
            Long loginUserId = RequestContext.get().getCurrUserId();
            for (DynamicObject dynamicObject : load) {
                DynamicObject user = dynamicObject.getDynamicObject("user");
                DynamicObject group = dynamicObject.getDynamicObject(PROP_GROUP);
                errorId.add(dynamicObject.getPkValue());
                if (user == null) {
                    errorId.add(dynamicObject.getPkValue());
                    continue;
                }
                if (userId.add(user.getPkValue())) {
                    LicenseSyncDetailLog licenseSyncDetailLog = new LicenseSyncDetailLog();
                    licenseSyncDetailLog.setUser(user.getString(PROP_NAME));
                    licenseSyncDetailLog.setPhone(user.getString(PROP_PHONE));
                    licenseSyncDetailLog.setEmail(user.getString(PROP_EMAIL));
                    licenseSyncDetailLog.setLogType(logType);
                    licenseSyncDetailLog.setOperation(operation);
                    licenseSyncDetailLog.setReason(reason);
                    licenseSyncDetailLog.setDescription(reason);
                    licenseSyncDetailLog.setSuccess(false);
                    logs.add(licenseSyncDetailLog);
                }
                LicenseAssignLog licenseAssignLog = new LicenseAssignLog(TimeServiceHelper.now(), loginUserId, (Long)user.getPkValue(), reason, 0, 1, (Long)group.getPkValue(), true);
                licenseAssignLogs.add(licenseAssignLog);
            }
            if (CollectionUtils.isNotEmpty(licenseAssignLogs)) {
                ILicenseService service = (ILicenseService)ServiceFactory.getService(ILicenseService.class);
                service.addAssignLogs(licenseAssignLogs);
            }
            SqlBuilder sql = new SqlBuilder();
            sql.append("UPDATE T_LIC_USERLICENSEGROUP SET FSYNCSTATUS = '3', FSTATUS = '0' ,fsynclogid = " + licenseSyncLog.getPkId() + " ,fassigntime  = now() WHERE ", new Object[0]);
            sql.appendIn("FID", errorId);
            if (CollectionUtils.isNotEmpty(errorId)) {
                DB.execute((DBRoute)DBRoute.base, (SqlBuilder)sql);
            }
        }
        catch (Exception e) {
            logger.error("handle blank data error.", (Throwable)e);
        }
    }

    private static void releaseDiasbleUserLic(LicenseSyncLog licenseSyncLog, String logType, String operation) {
        List logs = licenseSyncLog.getLogs();
        ArrayList<LicenseAssignLog> licenseAssignLogs = new ArrayList<LicenseAssignLog>(10);
        Long loginUserId = RequestContext.get().getCurrUserId();
        HashSet<Object> deleteLicSet = new HashSet<Object>(10);
        boolean enableDeleteDisenableUserLic = LicenseServiceUtil.isEnableDeleteDisenableUserLic();
        String forbiddenReason = ResManager.loadKDString((String)"\u7528\u6237\u7684\u72b6\u6001\u4e3a\u201c\u7981\u7528\u201d\u3002", (String)"UpdateLicGroupUser_35", (String)"bos-license-business", (Object[])new Object[0]);
        String disableReason = ResManager.loadKDString((String)"\u4eba\u5458\u7684\u72b6\u6001\u4e3a\u201c\u7981\u7528\u201d\u3002", (String)"UpdateLicGroupUser_45", (String)"bos-license-business", (Object[])new Object[0]);
        DynamicObject[] load = BusinessDataServiceHelper.load((String)ENTITY_USERLICGROUP, (String)"user,group", (QFilter[])new QFilter[]{new QFilter("user.enable", "=", (Object)Character.valueOf('0')).or(new QFilter("user.isforbidden", "=", (Object)Character.valueOf('1'))), new QFilter(PROP_SYNCSTATUS, "in", (Object)new String[]{"1", "2"})});
        if (null == load || load.length == 0) {
            return;
        }
        HashSet<Object> userId = new HashSet<Object>(10);
        for (DynamicObject dynamicObject : load) {
            DynamicObject user = dynamicObject.getDynamicObject("user");
            DynamicObject group = dynamicObject.getDynamicObject(PROP_GROUP);
            if (user == null || group == null) continue;
            boolean enable = user.getBoolean("enable");
            deleteLicSet.add(dynamicObject.getPkValue());
            if (userId.add(user.getPkValue())) {
                LicenseSyncDetailLog licenseSyncDetailLog = new LicenseSyncDetailLog();
                licenseSyncDetailLog.setUser(user.getString(PROP_NAME));
                licenseSyncDetailLog.setPhone(user.getString(PROP_PHONE));
                licenseSyncDetailLog.setEmail(user.getString(PROP_EMAIL));
                licenseSyncDetailLog.setLogType(logType);
                licenseSyncDetailLog.setOperation(operation);
                licenseSyncDetailLog.setReason(enable ? forbiddenReason : disableReason);
                if (enableDeleteDisenableUserLic) {
                    licenseSyncDetailLog.setDescription(ResManager.loadKDString((String)"\u7981\u7528\u4eba\u5458\u81ea\u52a8\u91ca\u653e\u8bb8\u53ef", (String)"LicenseSnapshotEngine_10", (String)"bos-license-business", (Object[])new Object[0]));
                    licenseSyncDetailLog.setSuccess(false);
                }
                logs.add(licenseSyncDetailLog);
            }
            if (!enableDeleteDisenableUserLic) continue;
            LicenseAssignLog licenseAssignLog = new LicenseAssignLog(TimeServiceHelper.now(), loginUserId, (Long)user.getPkValue(), ResManager.loadKDString((String)"\u7981\u7528\u4eba\u5458\u81ea\u52a8\u91ca\u653e\u8bb8\u53ef", (String)"LicenseSnapshotEngine_10", (String)"bos-license-business", (Object[])new Object[0]), 0, 1, (Long)group.getPkValue(), true);
            licenseAssignLogs.add(licenseAssignLog);
        }
        if (CollectionUtils.isNotEmpty(licenseAssignLogs)) {
            ILicenseService service = (ILicenseService)ServiceFactory.getService(ILicenseService.class);
            service.addAssignLogs(licenseAssignLogs);
        }
        SqlBuilder sql = new SqlBuilder();
        if (enableDeleteDisenableUserLic) {
            sql.append("DELETE FROM T_LIC_USERLICENSEGROUP WHERE ", new Object[0]);
        } else {
            sql.append("UPDATE T_LIC_USERLICENSEGROUP SET FSYNCSTATUS = '4', FSTATUS = '0' ,fsynclogid = " + licenseSyncLog.getPkId() + " ,fassigntime  = now() WHERE ", new Object[0]);
        }
        sql.appendIn("FID", new ArrayList(deleteLicSet));
        if (CollectionUtils.isNotEmpty(deleteLicSet)) {
            DB.execute((DBRoute)DBRoute.base, (SqlBuilder)sql);
        }
    }

    private static void putLicExpireTimeCache() {
        Date create = TimeServiceHelper.now();
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(create);
        ((Calendar)calendar).add(2, 3);
        String isCtrlAmount = LicenseCacheMrg.getType4IsCtrlAmount();
        LicenseCacheMrg.putCache(isCtrlAmount, "temtime", String.valueOf(calendar.getTime().getTime()));
    }
}

