/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.license.gray;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.exception.KDBizException;
import kd.bos.license.constant.GrayLicApplyStatusEnum;
import kd.bos.license.service.cache.LicenseGrayCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.devportal.grayblacklist.bean.GrayAppBLInfo;
import kd.bos.metadata.devportal.grayblacklist.bean.GrayCloudBLInfo;
import kd.bos.metadata.devportal.grayblacklist.bean.GrayEntityBLInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.runmode.GrayBlackListServiceHelper;
import kd.bos.util.CollectionUtils;

public class UpdateGrayBlackList {
    private static Log logger = LogFactory.getLog(UpdateGrayBlackList.class);

    public void saveBlackListByFeatures(List<String> features) {
        DynamicObject[] schemeDoc;
        if (CollectionUtils.isEmpty(features)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7279\u6027\u7f16\u7801\u4e3a\u7a7a\u3002", (String)"UpdateGrayBlackList_0", (String)"bos-license-business", (Object[])new Object[0]));
        }
        QFilter featureNumberFilter = new QFilter("grayfeature.number", "in", features);
        DynamicObjectCollection grayFeatureDoc = QueryServiceHelper.query((String)"lic_grayfeature", (String)"grayfeature.number,status", (QFilter[])featureNumberFilter.toArray());
        if (CollectionUtils.isNotEmpty((Collection)grayFeatureDoc)) {
            HashMap<String, DynamicObject> number2GrayFeature = new HashMap<String, DynamicObject>(grayFeatureDoc.size());
            for (DynamicObject grayFeatureObj : grayFeatureDoc) {
                number2GrayFeature.put(grayFeatureObj.getString("grayfeature.number"), grayFeatureObj);
            }
            Iterator<String> iterator = features.iterator();
            while (iterator.hasNext()) {
                String feature = iterator.next();
                if (!number2GrayFeature.containsKey(feature)) continue;
                DynamicObject grayFeatureObj = (DynamicObject)number2GrayFeature.get(feature);
                String status = grayFeatureObj.getString("status");
                if (!GrayLicApplyStatusEnum.Success.toString().equals(status) && !GrayLicApplyStatusEnum.Suspend.toString().equals(status)) continue;
                iterator.remove();
            }
        }
        if (CollectionUtils.isEmpty(features)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u8981\u52a0\u5165\u9ed1\u540d\u5355\u7684\u7279\u6027\u3002", (String)"UpdateGrayBlackList_1", (String)"bos-license-business", (Object[])new Object[0]));
        }
        int product = LicenseServiceHelper.getModeType() == 4 ? 2 : 1;
        ArrayList<GrayCloudBLInfo> grayCloudInfos = new ArrayList<GrayCloudBLInfo>(3);
        ArrayList<GrayAppBLInfo> grayAppInfos = new ArrayList<GrayAppBLInfo>(3);
        ArrayList<GrayEntityBLInfo> grayEntityInfos = new ArrayList<GrayEntityBLInfo>(3);
        String select = "number,gray_cloud,cloud_name,isblack_cloud,gray_app,app_name,isblack_app,gray_object,object_name,app,isblack_obj";
        QFilter filter = new QFilter("number", "in", features);
        QFilter[] filters = new QFilter[]{filter};
        for (DynamicObject graySchemeObj : schemeDoc = BusinessDataServiceHelper.load((String)"lic_grayfeaturescheme", (String)select, (QFilter[])filters)) {
            Object cloudEntry2;
            DynamicObjectCollection grayCloudDoc = graySchemeObj.getDynamicObjectCollection("gray_cloud");
            for (Object cloudEntry2 : grayCloudDoc) {
                if (!cloudEntry2.getBoolean("isblack_cloud")) continue;
                GrayCloudBLInfo cloudBLInfo = new GrayCloudBLInfo(cloudEntry2.getString("cloud_name.number"), Integer.valueOf(product));
                cloudBLInfo.setId(cloudEntry2.getString("cloud_name.id"));
                grayCloudInfos.add(cloudBLInfo);
            }
            DynamicObjectCollection grayAppDoc = graySchemeObj.getDynamicObjectCollection("gray_app");
            cloudEntry2 = grayAppDoc.iterator();
            while (cloudEntry2.hasNext()) {
                DynamicObject appEntry = (DynamicObject)cloudEntry2.next();
                if (!appEntry.getBoolean("isblack_app")) continue;
                GrayAppBLInfo grayAppBLInfo = new GrayAppBLInfo(appEntry.getString("app_name.number"), Integer.valueOf(product));
                grayAppBLInfo.setId(appEntry.getString("app_name.id"));
                grayAppInfos.add(grayAppBLInfo);
            }
            DynamicObjectCollection formDoc = graySchemeObj.getDynamicObjectCollection("gray_object");
            for (DynamicObject formEntry : formDoc) {
                if (!formEntry.getBoolean("isblack_obj")) continue;
                GrayEntityBLInfo grayEntityBLInfo = new GrayEntityBLInfo(formEntry.getString("object_name.number"), Integer.valueOf(product), formEntry.getString("app.number"));
                grayEntityBLInfo.setId(formEntry.getString("object_name.number"));
                grayEntityInfos.add(grayEntityBLInfo);
            }
        }
        Map saveCloudBlackListRes = null;
        Map saveAppBlackListRes = null;
        Map saveEntityBlackListRes = null;
        if (grayCloudInfos.size() > 0) {
            saveCloudBlackListRes = GrayBlackListServiceHelper.saveCloudBlackListNoCheck(grayCloudInfos);
        }
        if (grayAppInfos.size() > 0) {
            saveAppBlackListRes = GrayBlackListServiceHelper.saveAppBlackListNoCheck(grayAppInfos);
        }
        if (grayEntityInfos.size() > 0) {
            saveEntityBlackListRes = GrayBlackListServiceHelper.saveEntityBlackListNoCheck(grayEntityInfos);
        }
        LicenseGrayCache.clearAllGrayFeatureInfo();
        logger.info("UpdateGrayBlackList#saveBlackListByFeatures:saveCloudBlackListRes={},saveAppBlackListRes={},saveEntityBlackListRes={}", new Object[]{saveCloudBlackListRes, saveAppBlackListRes, saveEntityBlackListRes});
    }

    public void deleteBlackListByFeatureIds(List<Object> deleteGrayFeatureIds) {
        ArrayList deleteGrayCloudInfos = new ArrayList(3);
        SqlBuilder queryCloudSql = new SqlBuilder();
        queryCloudSql.append("select fcloudid,fcloudnum,fproduct,fisblack from t_lic_grayfeatschecld where", new Object[0]);
        queryCloudSql.appendIn("fid", deleteGrayFeatureIds);
        DB.query((DBRoute)DBRoute.basedata, (SqlBuilder)queryCloudSql, resultSet -> {
            while (resultSet.next()) {
                if (!resultSet.getBoolean("fisblack")) continue;
                deleteGrayCloudInfos.add(new GrayCloudBLInfo(resultSet.getString("fcloudnum"), Integer.valueOf(resultSet.getInt("fproduct"))));
            }
            return null;
        });
        ArrayList deleteGrayAppInfos = new ArrayList(3);
        SqlBuilder queryAppSql = new SqlBuilder();
        queryAppSql.append("select fappid,fappnum,fproduct,fisblack from t_lic_grayfeatscheapp where", new Object[0]);
        queryAppSql.appendIn("fid", deleteGrayFeatureIds);
        DB.query((DBRoute)DBRoute.basedata, (SqlBuilder)queryAppSql, resultSet -> {
            while (resultSet.next()) {
                if (!resultSet.getBoolean("fisblack")) continue;
                deleteGrayAppInfos.add(new GrayAppBLInfo(resultSet.getString("fappnum"), Integer.valueOf(resultSet.getInt("fproduct"))));
            }
            return null;
        });
        ArrayList deleteGrayObjectInfos = new ArrayList(3);
        SqlBuilder queryObjectSql = new SqlBuilder();
        queryObjectSql.append("select fappid,fappnum,fentityid,fentitynum,fproduct,fisblack from t_lic_grayfeatscheobj where", new Object[0]);
        queryObjectSql.appendIn("fid", deleteGrayFeatureIds);
        DB.query((DBRoute)DBRoute.basedata, (SqlBuilder)queryObjectSql, resultSet -> {
            while (resultSet.next()) {
                if (!resultSet.getBoolean("fisblack")) continue;
                deleteGrayObjectInfos.add(new GrayEntityBLInfo(resultSet.getString("fentitynum"), Integer.valueOf(resultSet.getInt("fproduct")), resultSet.getString("fappnum")));
            }
            return null;
        });
        if (deleteGrayCloudInfos.size() > 0) {
            GrayBlackListServiceHelper.deleteCloudBlackList(deleteGrayCloudInfos);
        }
        if (deleteGrayAppInfos.size() > 0) {
            GrayBlackListServiceHelper.deleteAppBlackList(deleteGrayAppInfos);
        }
        if (deleteGrayObjectInfos.size() > 0) {
            GrayBlackListServiceHelper.deleteEntityBlackList(deleteGrayObjectInfos);
        }
    }

    public void deleteBlackListByFeatures(List<String> features) {
        DynamicObject[] schemeDoc;
        if (CollectionUtils.isEmpty(features)) {
            logger.info("UpdateGrayBlackList#deleteBlackListByFeatures features is empty");
            return;
        }
        ArrayList<GrayCloudBLInfo> grayCloudInfos = new ArrayList<GrayCloudBLInfo>(3);
        ArrayList<GrayAppBLInfo> grayAppInfos = new ArrayList<GrayAppBLInfo>(3);
        ArrayList<GrayEntityBLInfo> grayEntityInfos = new ArrayList<GrayEntityBLInfo>(3);
        String select = "number,gray_cloud,cloud_name,isblack_cloud,gray_app,app_name,isblack_app,gray_object,object_name,app,isblack_obj";
        QFilter filter = new QFilter("number", "in", features);
        QFilter[] filters = new QFilter[]{filter};
        for (DynamicObject graySchemeObj : schemeDoc = BusinessDataServiceHelper.load((String)"lic_grayfeaturescheme", (String)select, (QFilter[])filters)) {
            Object cloudEntry2;
            DynamicObjectCollection grayCloudDoc = graySchemeObj.getDynamicObjectCollection("gray_cloud");
            for (Object cloudEntry2 : grayCloudDoc) {
                if (!cloudEntry2.getBoolean("isblack_cloud")) continue;
                GrayCloudBLInfo cloudBLInfo = new GrayCloudBLInfo(cloudEntry2.getString("cloud_name.number"), Integer.valueOf(1));
                grayCloudInfos.add(cloudBLInfo);
            }
            DynamicObjectCollection grayAppDoc = graySchemeObj.getDynamicObjectCollection("gray_app");
            cloudEntry2 = grayAppDoc.iterator();
            while (cloudEntry2.hasNext()) {
                DynamicObject appEntry = (DynamicObject)cloudEntry2.next();
                if (!appEntry.getBoolean("isblack_app")) continue;
                GrayAppBLInfo grayAppBLInfo = new GrayAppBLInfo(appEntry.getString("app_name.number"), Integer.valueOf(1));
                grayAppInfos.add(grayAppBLInfo);
            }
            DynamicObjectCollection formDoc = graySchemeObj.getDynamicObjectCollection("gray_object");
            for (DynamicObject formEntry : formDoc) {
                if (!formEntry.getBoolean("isblack_obj")) continue;
                GrayEntityBLInfo grayEntityBLInfo = new GrayEntityBLInfo(formEntry.getString("object_name.number"), Integer.valueOf(1), formEntry.getString("app.number"));
                grayEntityInfos.add(grayEntityBLInfo);
            }
        }
        Map deleteCloudBlackListRes = null;
        Map deleteAppBlackListRes = null;
        Map deleteEntityBlackListRes = null;
        if (grayCloudInfos.size() > 0) {
            deleteCloudBlackListRes = GrayBlackListServiceHelper.deleteCloudBlackList(grayCloudInfos);
        }
        if (grayAppInfos.size() > 0) {
            deleteAppBlackListRes = GrayBlackListServiceHelper.deleteAppBlackList(grayAppInfos);
        }
        if (grayEntityInfos.size() > 0) {
            deleteEntityBlackListRes = GrayBlackListServiceHelper.deleteEntityBlackList(grayEntityInfos);
        }
        logger.info("UpdateGrayBlackList#deleteBlackListByFeatures:deleteCloudBlackListRes={},deleteAppBlackListRes={},deleteEntityBlackListRes={}", new Object[]{deleteCloudBlackListRes, deleteAppBlackListRes, deleteEntityBlackListRes});
    }
}

