/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.license.gray;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dlock.DLock;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.license.db.gray.GrayLicenseDao;
import kd.bos.license.gray.UpdateGrayBlackList;
import kd.bos.license.pojo.gray.GrayFeature;
import kd.bos.license.service.cache.LicenseCacheMrg;
import kd.bos.license.service.cache.LicenseGrayCache;
import kd.bos.license.service.cache.LicenseGrayCacheMrg;
import kd.bos.license.util.LicenseGrayUpdateStatusUtil;
import kd.bos.license.util.LicenseMCApiUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class UpdateGrayLicense {
    private static Log logger = LogFactory.getLog(UpdateGrayLicense.class);
    private Map<String, String> result = new HashMap<String, String>(2);
    private static final String API_RESPONSE_KEY_ERROR_CODE = "errorcode";
    private static final String API_RESPONSE_KEY_DESCRIPTION = "description";
    private static final int SUCCESS_CODE = 100;

    private Map<String, String> fail(String msg) {
        this.result.put("success", "false");
        this.result.put("msg", msg);
        return this.result;
    }

    private Map<String, String> failWithConfirm(String msg) {
        this.result.put("success", "false");
        this.result.put("msg", msg);
        this.result.put("showconfirm", "true");
        return this.result;
    }

    private Map<String, String> success(String msg) {
        this.result.put("success", "true");
        this.result.put("msg", msg);
        return this.result;
    }

    public Map<String, String> downloadAndUpdateGrayLicense(String updateType, boolean mcUpdateGrayLicense) {
        String response;
        logger.info("downloadAndUpdateGrayLicense\uff1a\u5f00\u59cb\u4e0b\u8f7d\u5e76\u66f4\u65b0\u7070\u5ea6\u8bb8\u53ef\uff0cupdateType={}", (Object)updateType);
        if (mcUpdateGrayLicense) {
            try {
                LicenseMCApiUtil.notifyMCUpdateGrayLic();
            }
            catch (Exception e) {
                logger.error("downloadAndUpdateGrayLicense\uff1a\u901a\u77e5\u7ba1\u7406\u4e2d\u5fc3\u66f4\u65b0\u7070\u5ea6\u8bb8\u53ef\u5931\u8d25", (Throwable)e);
            }
        }
        try {
            response = LicenseMCApiUtil.getGrayLicFileFromMc();
        }
        catch (Exception e) {
            logger.error("downloadAndUpdateGrayLicense\uff1a\u4ece\u7ba1\u7406\u4e2d\u5fc3\u4e0b\u8f7d\u7070\u5ea6\u8bb8\u53ef\u5931\u8d25", (Throwable)e);
            return this.fail(e.getMessage());
        }
        JSONObject jsonResponse = JSONObject.parseObject((String)response);
        if (jsonResponse == null) {
            return this.fail(ResManager.loadKDString((String)"\u4ece\u7ba1\u7406\u4e2d\u5fc3\u4e0b\u8f7d\u7070\u5ea6\u8bb8\u53ef\u5931\u8d25\uff0c\u8bf7\u6c42\u8fd4\u56de\u7a7a\u3002", (String)"UpdateGrayLicense_0", (String)"bos-license-business", (Object[])new Object[0]));
        }
        String errorCode = jsonResponse.getString(API_RESPONSE_KEY_ERROR_CODE);
        String description = jsonResponse.getString(API_RESPONSE_KEY_DESCRIPTION);
        if (errorCode == null || Integer.parseInt(errorCode) != 100) {
            logger.info("downloadAndUpdateGrayLicense\uff1a\u4ece\u7ba1\u7406\u4e2d\u5fc3\u4e0b\u8f7d\u7070\u5ea6\u8bb8\u53ef\u5931\u8d25\uff0cerrorCode={}\uff0cdescription={}", (Object)errorCode, (Object)description);
            return this.fail(String.format(ResManager.loadKDString((String)"\u4ece\u7ba1\u7406\u4e2d\u5fc3\u4e0b\u8f7d\u7070\u5ea6\u8bb8\u53ef\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s", (String)"UpdateGrayLicense_1", (String)"bos-license-business", (Object[])new Object[0]), description));
        }
        JSONArray data = jsonResponse.getJSONArray("data");
        logger.info("downloadAndUpdateGrayLicense\uff1adata={}", (Object)data);
        if (data == null || data.size() <= 0) {
            try {
                this.clearCacheAndTerminateGrayFeature();
            }
            catch (Exception e) {
                logger.error("downloadAndUpdateGrayLicense\uff1a\u7070\u5ea6\u8bb8\u53ef\u4e3a\u7a7a\u65f6\u66f4\u65b0\u5f02\u5e38\u3002", (Throwable)e);
            }
            return this.fail(ResManager.loadKDString((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u672a\u83b7\u53d6\u5230\u7070\u5ea6\u8bb8\u53ef\u6587\u4ef6\u3002", (String)"UpdateGrayLicense_2", (String)"bos-license-business", (Object[])new Object[0]));
        }
        try (DLock dlock = DLock.createReentrant((String)"UserLicenseGroups");){
            dlock.lock();
            List<GrayFeature> grayFeatures = this.updateGrayFeatureInDB(data);
            this.updateGrayFeatureCache(grayFeatures);
            this.releaseBlackList(grayFeatures);
        }
        catch (Exception e) {
            logger.error("downloadAndUpdateGrayLicense\uff1a\u89e3\u6790\u7070\u5ea6\u8bb8\u53ef\u5931\u8d25", (Throwable)e);
            if (e instanceof KDException && BosErrorCode.configNotFound.getCode().equals(((KDException)e).getErrorCode().getCode())) {
                return this.failWithConfirm(e.getMessage());
            }
            return this.fail(e.getMessage());
        }
        return this.success(ResManager.loadKDString((String)"\u7070\u5ea6\u8bb8\u53ef\u66f4\u65b0\u6210\u529f\u3002", (String)"UpdateGrayLicense_3", (String)"bos-license-business", (Object[])new Object[0]));
    }

    private void releaseBlackList(List<GrayFeature> grayFeatures) {
        ArrayList<String> successFeatures = new ArrayList<String>();
        grayFeatures.forEach(e -> successFeatures.add(e.getGraySchemeNumber()));
        UpdateGrayBlackList updateGrayBlackList = new UpdateGrayBlackList();
        if (successFeatures.size() > 0) {
            updateGrayBlackList.deleteBlackListByFeatures(successFeatures);
        }
    }

    private void clearCacheAndTerminateGrayFeature() {
        LicenseGrayCache.clearAllCache();
        LicenseGrayUpdateStatusUtil.terminateGrayFeature();
    }

    private void updateGrayFeatureCache(List<GrayFeature> data) {
        if (null == data) {
            throw new KDException(ResManager.loadKDString((String)"\u7070\u5ea6\u8bb8\u53ef\u6587\u4ef6\u683c\u5f0f\u5f02\u5e38\uff0c\u6682\u505c\u66f4\u65b0\u3002\u8bf7\u68c0\u67e5\u7070\u5ea6\u8bb8\u53ef\u6587\u4ef6\u3002", (String)"UpdateGrayLicense_4", (String)"bos-license-business", (Object[])new Object[0]));
        }
        if (!data.isEmpty()) {
            Map<String, String> grayFeatures = LicenseGrayCache.newGrayCacheMap(16);
            for (GrayFeature feature : data) {
                String grayFeatureStr = SerializationUtils.toJsonString((Object)feature);
                grayFeatures.put(String.valueOf(feature.getGraySchemeId()), grayFeatureStr);
                grayFeatures.put(feature.getGraySchemeNumber(), grayFeatureStr);
            }
            LicenseGrayCache.clearAllCache();
            LicenseCacheMrg.putCache(LicenseGrayCacheMrg.getTypeGrayFeatureInfo(), grayFeatures);
        }
    }

    private List<GrayFeature> updateGrayFeatureInDB(JSONArray data) {
        GrayLicenseDao grayFeatureDao = new GrayLicenseDao();
        return grayFeatureDao.updateGrayFeatureByLicFile(data);
    }
}

