/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.license.pojo.gray;

import java.util.Calendar;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.util.StringUtils;

public class GrayFeature {
    private String graySchemeNumber;
    private Long graySchemeId;
    private Date beginDate;
    private Date endDate;
    private Boolean valid;
    private Boolean onsale;

    public GrayFeature() {
    }

    public GrayFeature(String graySchemeNumber, Long graySchemeId, Date beginDate, Date endDate) {
        this.graySchemeNumber = graySchemeNumber;
        this.graySchemeId = graySchemeId;
        this.beginDate = this.checkAndChangeBeginDate(beginDate);
        this.endDate = this.checkAndChangeEndDate(endDate);
    }

    public GrayFeature(String graySchemeNumber, Long graySchemeId, Date beginDate, Date endDate, Boolean valid, Boolean onsale) {
        this.graySchemeNumber = graySchemeNumber;
        this.graySchemeId = graySchemeId;
        this.beginDate = beginDate;
        this.endDate = endDate;
        this.valid = valid;
        this.onsale = onsale;
    }

    public static GrayFeature build(DynamicObject grayFeatureDyn, DynamicObject grayFeatureSchemeDyn, Boolean onsale) {
        GrayFeature grayFeature = new GrayFeature();
        grayFeature.setGraySchemeNumber(grayFeatureSchemeDyn.getString("number"));
        grayFeature.setGraySchemeId(grayFeatureSchemeDyn.getLong("id"));
        grayFeature.setBeginDate(grayFeatureDyn.getDate("begindate"));
        grayFeature.setEndDate(grayFeatureDyn.getDate("enddate"));
        grayFeature.setOnsale(onsale);
        return grayFeature;
    }

    public String getGraySchemeNumber() {
        return this.graySchemeNumber;
    }

    public void setGraySchemeNumber(String graySchemeNumber) {
        if (StringUtils.isBlank((String)graySchemeNumber)) {
            throw new KDException(BosErrorCode.paramError, new Object[]{"GrayFeature setGraySchemeNumber error. graySchemeNumber is blank , graySchemeId is " + this.graySchemeId});
        }
        this.graySchemeNumber = graySchemeNumber;
    }

    public Long getGraySchemeId() {
        return this.graySchemeId;
    }

    public void setGraySchemeId(Long graySchemeId) {
        if (null == graySchemeId) {
            throw new KDException(BosErrorCode.paramError, new Object[]{"GrayFeature setGraySchemeId error. graySchemeId is null , graySchemeNumber is " + this.graySchemeNumber});
        }
        this.graySchemeId = graySchemeId;
    }

    public Date getBeginDate() {
        return this.beginDate;
    }

    public void setBeginDate(Date beginDate) {
        this.beginDate = this.checkAndChangeBeginDate(beginDate);
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = this.checkAndChangeEndDate(endDate);
    }

    private Date checkAndChangeBeginDate(Date beginDate) {
        try {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(beginDate);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            return calendar.getTime();
        }
        catch (Exception e) {
            throw new KDException(BosErrorCode.paramError, "GrayFeature checkAndChangeBeginDate error. beginDate is " + beginDate + "graySchemeNumber is " + this.graySchemeNumber, (Throwable)e);
        }
    }

    private Date checkAndChangeEndDate(Date endDate) {
        try {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(endDate);
            calendar.set(11, 23);
            calendar.set(12, 59);
            calendar.set(13, 59);
            return calendar.getTime();
        }
        catch (Exception e) {
            throw new KDException(BosErrorCode.paramError, "GrayFeature checkAndChangeEndDate error. endDate is " + endDate + "graySchemeNumber is " + this.graySchemeNumber, (Throwable)e);
        }
    }

    public Boolean getValid() {
        return this.valid;
    }

    public void setValid(Boolean valid) {
        this.valid = valid;
    }

    public Boolean getOnsale() {
        return this.onsale;
    }

    public void setOnsale(Boolean onsale) {
        this.onsale = onsale;
    }
}

