/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.license.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.license.bean.LicGroupRuntime;
import kd.bos.license.bean.LicModuleRuntime;
import kd.bos.license.bean.RangeDate;
import kd.bos.license.config.AESUtil;
import kd.bos.license.engine.LicenseUserRelEngine;
import kd.bos.license.pojo.LicenseDetailSnapshot;
import kd.bos.license.pojo.LicenseGeneralSnapshot;
import kd.bos.license.pojo.LicenseGroupAppSnapshot;
import kd.bos.license.pojo.LicenseSnapshot;
import kd.bos.license.service.cache.LicenseCache;
import kd.bos.license.service.cache.LicenseCacheMrg;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import org.roaringbitmap.RoaringBitmap;

public class LicenseBitMapUpgradeService
implements IUpgradeService {
    private static Log logger = LogFactory.getLog(LicenseBitMapUpgradeService.class);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        String licenseTable = "t_lic_license";
        String licenseDetailTable = "t_lic_licensedetail";
        String licenseGroupAppsTable = "t_lic_licensegroupapps";
        try (DLock dlock = DLock.create((String)("LicenseSnapShot_" + RequestContext.get().getAccountId()));){
            dlock.lock();
            StringBuilder sql = new StringBuilder().append("SELECT tll.ftid,tll.fid fid,tll.ftype ftype,tll.fprodinstcode fprodinstcode,tll.fproductid fproductid,tll.fproductno fproductno,tll.fsoftwarecode fsoftwarecode,tll.findustry findustry,").append("tll.fproductversion fproductversion,tll.factivedate factivedate,tll.fexpdate fexpdate,tll.fsoftwarename fsoftwarename,tll.fprodid fprodid,tll.fname fname,tll.fscenetype fscenetype,tlld.fentryid fentryid,tlld.fgroupid fgroupid,").append("tlld.ftotalcount ftotalcount,tlld.fassignedcount fassignedcount,tlld.fremaincount fremaincount,tlld.fbegindate fbegindate,tlld.fenddate fenddate,tllga.fbizappid fbizappid,tllga.fmodulebegindate,tllga.fmoduleenddate,tlm.fnumber fmodulenumber from ").append(licenseTable).append(" tll LEFT JOIN ").append(licenseDetailTable).append(" tlld on tll.fid = tlld.fid LEFT JOIN ").append(licenseGroupAppsTable).append(" tllga ON tllga.fentryid = tlld.fentryid ").append(" LEFT join t_lic_module tlm on tlm.fid = tllga.fmoduleid");
            List licenseGeneralSnapshotList = (List)DB.query((DBRoute)DBRoute.base, (String)sql.toString(), k -> {
                ArrayList<LicenseSnapshot> licenseSnapshotList = new ArrayList<LicenseSnapshot>(4);
                HashMap<Long, LicenseSnapshot> licenseSnapshotMap = new HashMap<Long, LicenseSnapshot>(4);
                HashMap<Long, LicenseDetailSnapshot> licenseDetailSnapshotMap = new HashMap<Long, LicenseDetailSnapshot>(16);
                HashSet<String> appSet = new HashSet<String>(16);
                appSet.add(null);
                appSet.add("0");
                appSet.add("");
                appSet.add(" ");
                while (k.next()) {
                    Date moduleEndDate;
                    String entryIdStr;
                    long id = k.getLong("fid");
                    LicenseSnapshot licenseSnapshot = (LicenseSnapshot)licenseSnapshotMap.get(id);
                    if (licenseSnapshot == null) {
                        String type = k.getString("ftype");
                        String prodInstCode = k.getString("fprodinstcode");
                        String productId = k.getString("fproductid");
                        String productNo = k.getString("fproductno");
                        String softwareCode = k.getString("fsoftwarecode");
                        String industry = k.getString("findustry");
                        String productVersion = k.getString("fproductversion");
                        Date activeDate = k.getDate("factivedate");
                        Date expDate = k.getDate("fexpdate");
                        String softwareName = k.getString("fsoftwarename");
                        String prodId = k.getString("fprodid");
                        String name = k.getString("fname");
                        String tid = k.getString("ftid");
                        licenseSnapshot = new LicenseSnapshot(id, type, prodInstCode, productId, productNo, softwareCode, industry, productVersion, (java.util.Date)activeDate, (java.util.Date)expDate, softwareName, prodId, name, tid);
                        licenseSnapshot.setSceneType(k.getString("fscenetype"));
                        licenseSnapshotMap.put(id, licenseSnapshot);
                        licenseSnapshotList.add(licenseSnapshot);
                    }
                    if (StringUtils.isEmpty((CharSequence)(entryIdStr = k.getString("fentryid")))) continue;
                    long entryId = Long.parseLong(entryIdStr);
                    LicenseDetailSnapshot licenseDetailSnapshot = (LicenseDetailSnapshot)licenseDetailSnapshotMap.get(entryId);
                    if (licenseDetailSnapshot == null) {
                        long groupId = k.getLong("fgroupid");
                        int totalCount = k.getInt("ftotalcount");
                        int assignCount = k.getInt("fassignedcount");
                        int remainCount = k.getInt("fremaincount");
                        Date beginDate = k.getDate("fbegindate");
                        Date endDate = k.getDate("fenddate");
                        licenseDetailSnapshot = new LicenseDetailSnapshot(groupId, totalCount, assignCount, remainCount, beginDate, endDate);
                        licenseDetailSnapshotMap.put(entryId, licenseDetailSnapshot);
                        licenseSnapshot.getDetailSnapshotList().add(licenseDetailSnapshot);
                    }
                    String appId = k.getString("fbizappid");
                    String moduleNum = k.getString("fmodulenumber");
                    if (!appSet.add(appId) && !appSet.add(moduleNum)) continue;
                    Date moduleBeginDate = k.getDate("fmodulebegindate");
                    if (moduleBeginDate == null) {
                        moduleBeginDate = k.getDate("fbegindate");
                    }
                    if ((moduleEndDate = k.getDate("fmoduleenddate")) == null) {
                        moduleEndDate = k.getDate("fenddate");
                    }
                    licenseDetailSnapshot.getAppSnapshotList().add(new LicenseGroupAppSnapshot(appId, moduleNum, moduleBeginDate, moduleEndDate));
                }
                return licenseSnapshotList;
            });
            LicenseGeneralSnapshot snapshot = new LicenseGeneralSnapshot();
            snapshot.setLicenseSnapshots(licenseGeneralSnapshotList);
            Map<String, String> cache = LicenseCacheMrg.getCache(LicenseCacheMrg.getType4isTemporaryLicense());
            snapshot.setTempLic("1".equals(cache.get("isTemLic")));
            snapshot.setShowWaterMark(!"0".equals(cache.get("isShowWaterMark")));
            snapshot.setSceneType(cache.get("sceneType"));
            DB.execute((DBRoute)DBRoute.base, (String)"DELETE FROM T_LIC_Snapshot WHERE FSNAPSHOTTYPE = ?", (Object[])new Object[]{"2"});
            String data = AESUtil.encrypt(SerializationUtils.toJsonString((Object)snapshot));
            if (StringUtils.isBlank((CharSequence)data)) {
                throw new KDException("please check jdk aes-256\u3002");
            }
            DB.execute((DBRoute)DBRoute.base, (String)"INSERT INTO T_LIC_Snapshot(FID, FDATA, FCREATETIME, FISTRIAL, FSNAPSHOTTYPE) VALUES (?, ?, ?, ?, ?)", (Object[])new Object[]{DB.genLongId((String)"T_LIC_Snapshot"), data, new java.util.Date(), "0", "2"});
            this.reloadGroupRunTime(data);
            this.reloadModuleRuntime(data);
        }
        catch (Exception ex) {
            logger.error("LicenseBitMapUpgradeService before.", (Throwable)ex);
            result.setErrorInfo(ex.getMessage());
            result.setSuccess(false);
        }
        return result;
    }

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try {
            String sql = "select a.fgroupid, a.fuserid from t_lic_userlicensegroup a inner join t_lic_group b on a.fgroupid = b.fid where a.fsyncstatus = '1' and b.ftype = '1' order by a.fid";
            DB.query((DBRoute)DBRoute.base, (String)sql, k -> {
                HashSet<Long> userIds = new HashSet<Long>(1024);
                HashMap<Long, Set> groupUserMap = new HashMap<Long, Set>(16);
                Map<Long, Integer> remainCountMap = LicenseCache.getGroupTotal();
                if (null == remainCountMap || remainCountMap.isEmpty()) {
                    return false;
                }
                while (k.next()) {
                    long userId = k.getLong("fuserid");
                    long groupId = k.getLong("fgroupid");
                    Integer reCount = remainCountMap.get(groupId);
                    if (null == reCount || reCount <= 0) continue;
                    remainCountMap.put(groupId, reCount - 1);
                    userIds.add(userId);
                    groupUserMap.computeIfAbsent(groupId, kt -> new HashSet()).add(userId);
                }
                Map<Long, Integer> userBitMapIndex = LicenseUserRelEngine.getUserBitMapIndex(userIds);
                HashMap<Long, List<Integer>> licUserRelMap = new HashMap<Long, List<Integer>>(groupUserMap.size());
                for (Map.Entry entry : groupUserMap.entrySet()) {
                    Long groupId = (Long)entry.getKey();
                    for (Long userId : (Set)entry.getValue()) {
                        Integer index = userBitMapIndex.get(userId);
                        if (null == index) continue;
                        licUserRelMap.computeIfAbsent(groupId, v -> new ArrayList()).add(userBitMapIndex.get(userId));
                    }
                }
                this.reloadBitMap(licUserRelMap);
                return true;
            });
        }
        catch (Exception ex) {
            logger.error("LicenseBitMapUpgradeService after.", (Throwable)ex);
            result.setErrorInfo(ex.getMessage());
            result.setSuccess(false);
        }
        return result;
    }

    private void reloadGroupRunTime(String licenseData) {
        LicenseGeneralSnapshot snapshot = null;
        if (StringUtils.isBlank((CharSequence)licenseData)) {
            return;
        }
        String snapshotStr = AESUtil.decrypt(licenseData);
        try {
            snapshot = (LicenseGeneralSnapshot)SerializationUtils.fromJsonString((String)snapshotStr, LicenseGeneralSnapshot.class);
        }
        catch (Exception e) {
            snapshot = (LicenseGeneralSnapshot)JSON.parseObject((String)snapshotStr, LicenseGeneralSnapshot.class);
        }
        if (null == snapshot) {
            return;
        }
        HashMap allGroupIdAndNumber = new HashMap(16);
        HashMap<String, String> redisResult = new HashMap<String, String>(16);
        DB.query((DBRoute)DBRoute.base, (String)"select fid groupId ,fnumber groupNum from t_lic_group ", rs -> {
            while (rs.next()) {
                allGroupIdAndNumber.put(rs.getLong("groupId"), rs.getString("groupNum"));
            }
            return null;
        });
        List<LicenseSnapshot> licenseSnapshots = snapshot.getLicenseSnapshots();
        if (licenseSnapshots == null) {
            licenseSnapshots = new ArrayList<LicenseSnapshot>(16);
        }
        for (LicenseSnapshot licenseSnapshot : licenseSnapshots) {
            java.util.Date licActivedate = licenseSnapshot.getActivedate();
            java.util.Date licExpdate = licenseSnapshot.getExpdate();
            List<LicenseDetailSnapshot> detailSnapshotList = licenseSnapshot.getDetailSnapshotList();
            if (CollectionUtils.isEmpty(detailSnapshotList)) continue;
            for (LicenseDetailSnapshot licenseDetailSnapshot : detailSnapshotList) {
                long groupId = licenseDetailSnapshot.getGroupId();
                String groupNumber = (String)allGroupIdAndNumber.get(groupId);
                if (StringUtils.isBlank((CharSequence)groupNumber)) continue;
                int totalcount = licenseDetailSnapshot.getTotalcount();
                java.util.Date groupBegindate = licenseDetailSnapshot.getBegindate();
                java.util.Date groupEnddate = licenseDetailSnapshot.getEnddate();
                String groupStr = String.valueOf(groupId);
                ArrayList<RangeDate> rangeDates = new ArrayList<RangeDate>(1);
                rangeDates.add(new RangeDate(groupBegindate, groupEnddate));
                LicGroupRuntime licGroupRuntime = new LicGroupRuntime(Long.valueOf(groupId), groupNumber, totalcount, rangeDates, licActivedate, licExpdate);
                redisResult.put(groupStr, SerializationUtils.toJsonString((Object)licGroupRuntime));
            }
        }
        String version = DB.genStringId((String)"");
        redisResult.put("version", version);
        LicenseCacheMrg.clearCache(LicenseCacheMrg.getLicGroupRuntimeType());
        LicenseCacheMrg.putCache(LicenseCacheMrg.getLicGroupRuntimeType(), redisResult);
        LicenseCache.clearCircuitBreaker("group");
        logger.info("LicenseBitMapUpgradeService.reloadRedisCache putRedisCache. data : {}", redisResult);
    }

    private void reloadModuleRuntime(String licenseData) {
        LicenseGeneralSnapshot snapshot = null;
        if (StringUtils.isBlank((CharSequence)licenseData)) {
            return;
        }
        String snapshotStr = AESUtil.decrypt(licenseData);
        try {
            snapshot = (LicenseGeneralSnapshot)SerializationUtils.fromJsonString((String)snapshotStr, LicenseGeneralSnapshot.class);
        }
        catch (Exception e) {
            snapshot = (LicenseGeneralSnapshot)JSON.parseObject((String)snapshotStr, LicenseGeneralSnapshot.class);
        }
        if (null == snapshot) {
            return;
        }
        HashMap<String, String> redisResult = new HashMap<String, String>(16);
        HashMap<String, LicModuleRuntime> result = new HashMap<String, LicModuleRuntime>(16);
        List<LicenseSnapshot> licenseSnapshots = snapshot.getLicenseSnapshots();
        if (licenseSnapshots == null) {
            licenseSnapshots = new ArrayList<LicenseSnapshot>(16);
        }
        HashMap<String, String> appNumToModuleNum = new HashMap<String, String>(16);
        for (LicenseSnapshot licenseSnapshot : licenseSnapshots) {
            List<LicenseDetailSnapshot> detailSnapshotList = licenseSnapshot.getDetailSnapshotList();
            if (CollectionUtils.isEmpty(detailSnapshotList)) continue;
            for (LicenseDetailSnapshot licenseDetailSnapshot : detailSnapshotList) {
                List<LicenseGroupAppSnapshot> appSnapshotList = licenseDetailSnapshot.getAppSnapshotList();
                if (CollectionUtils.isEmpty(appSnapshotList)) continue;
                for (LicenseGroupAppSnapshot licenseGroupAppSnapshot : appSnapshotList) {
                    String moduleNumber;
                    if (null == licenseGroupAppSnapshot || StringUtils.isBlank((CharSequence)(moduleNumber = licenseGroupAppSnapshot.getModule()))) continue;
                    appNumToModuleNum.put(moduleNumber.toLowerCase(Locale.ENGLISH), moduleNumber);
                    java.util.Date moduleBeginDate = licenseGroupAppSnapshot.getModuleBeginDate();
                    java.util.Date moduleEndDate = licenseGroupAppSnapshot.getModuleEndDate();
                    ArrayList<RangeDate> rangeDates = new ArrayList<RangeDate>(1);
                    rangeDates.add(new RangeDate(moduleBeginDate, moduleEndDate));
                    LicModuleRuntime licModuleRuntime = new LicModuleRuntime(moduleNumber, rangeDates);
                    result.put(moduleNumber, licModuleRuntime);
                    redisResult.put(moduleNumber, SerializationUtils.toJsonString((Object)licModuleRuntime));
                }
            }
        }
        if (!appNumToModuleNum.isEmpty()) {
            DB.query((DBRoute)DBRoute.meta, (String)"select fid appId, fnumber appNum from t_meta_bizapp;", rs -> {
                while (rs.next()) {
                    String appId = rs.getString("appId");
                    String number = rs.getString("appNum");
                    LicModuleRuntime licModuleNumRuntime = (LicModuleRuntime)result.get(appNumToModuleNum.get(number));
                    if (null == licModuleNumRuntime) continue;
                    LicModuleRuntime licappIdRuntime = new LicModuleRuntime(appId, licModuleNumRuntime.getRangeDates());
                    result.put(appId, licappIdRuntime);
                    redisResult.put(appId, SerializationUtils.toJsonString((Object)licappIdRuntime));
                }
                return null;
            });
        }
        String version = DB.genStringId((String)"");
        redisResult.put("version", version);
        LicenseCacheMrg.clearCache(LicenseCacheMrg.getLicModuelRuntimeType());
        LicenseCacheMrg.putCache(LicenseCacheMrg.getLicModuelRuntimeType(), redisResult);
        LicenseCacheMrg.clearCache(LicenseCacheMrg.getLicenseCircuitBreakerType(), "module");
        logger.info("LicModuleRuntimeUtil.reloadRedisCache putRedisCache end . data : {}", redisResult);
    }

    private void reloadBitMap(Map<Long, List<Integer>> licUserRelMap) {
        if (CollectionUtils.isEmpty(licUserRelMap)) {
            return;
        }
        List<Map<String, Object>> userRelInfos = this.generateLicUserRelInfo(licUserRelMap);
        java.util.Date now = TimeServiceHelper.now();
        ArrayList params = new ArrayList(userRelInfos.size());
        userRelInfos.forEach(e -> params.add(new Object[]{DB.genGlobalLongId(), e.get("groupId"), e.get("byte"), e.get("sign"), now}));
        try (TXHandle tx = TX.required((String)"save_or_update_lic_rel_bit_tx");){
            try {
                DB.execute((DBRoute)DBRoute.base, (String)"delete from T_LIC_GroupBitMap;");
                DB.executeBatch((DBRoute)DBRoute.base, (String)"insert into T_LIC_GroupBitMap (fid, fgroupid, fbitmap, fsign, fcreatetime) values (?, ?, ?, ?, ?);", params);
            }
            catch (Exception e2) {
                tx.markRollback();
                logger.error("\u5b58\u50a8\u4f4d\u56fe\u4fe1\u606f\u5f02\u5e38", (Throwable)e2);
                throw e2;
            }
            HashMap<Long, RoaringBitmap> bitMap = new HashMap<Long, RoaringBitmap>(16);
            for (Map<String, Object> info : userRelInfos) {
                byte[] bytes = (byte[])info.get("byte");
                Long groupId = (Long)info.get("groupId");
                RequestContext context = RequestContext.get();
                String currAccountId = context.getAccountId();
                RoaringBitmap roaringBitMap = LicenseUserRelEngine.desRoaringBitmapByteArr(bytes, currAccountId, groupId);
                bitMap.put(groupId, roaringBitMap);
            }
            LicenseBitMapUpgradeService.updateCache(bitMap, LicenseCacheMrg.getType4UserGroupBitMap());
        }
    }

    private List<Map<String, Object>> generateLicUserRelInfo(Map<Long, List<Integer>> licUserRelMap) {
        HashMap<String, String> signMap = new HashMap<String, String>(licUserRelMap.size());
        ArrayList<Map<String, Object>> licUserRelInfos = new ArrayList<Map<String, Object>>(licUserRelMap.size());
        for (Map.Entry<Long, List<Integer>> entry : licUserRelMap.entrySet()) {
            int[] nArray = entry.getValue().stream().mapToInt(v -> v).toArray();
            RoaringBitmap bit = RoaringBitmap.bitmapOf((int[])nArray);
            bit.runOptimize();
            byte[] bytes = LicenseUserRelEngine.serRoaringBitmap(bit);
            HashMap<String, Object> map = new HashMap<String, Object>(16);
            map.put("groupId", entry.getKey());
            map.put("byte", bytes);
            licUserRelInfos.add(map);
            String digest = Arrays.stream(bit.toArray()).mapToObj(String::valueOf).collect(Collectors.joining(""));
            signMap.put(String.valueOf(entry.getKey()), digest);
        }
        JSONObject data = this.generateSignature(signMap);
        for (Map map : licUserRelInfos) {
            String sign = data.getString(String.valueOf(map.get("groupId")));
            if (StringUtils.isBlank((CharSequence)sign)) {
                throw new KDBizException("generateSignature sign is Blank. ");
            }
            map.put("sign", sign);
        }
        return licUserRelInfos;
    }

    private JSONObject generateSignature(Map<String, String> signMap) {
        JSONObject signJson = null;
        String sql = "select fid from t_perm_encryptionscheme where fnumber = 'LICENCE-SIGNATURE' ";
        try (DataSet data = DB.queryDataSet((String)"queryLicenseScheme", (DBRoute)DBRoute.base, (String)sql);){
            if (data != null && !data.isEmpty()) {
                Long schemeId = data.next().getLong("fid");
                signJson = PermissionServiceHelper.generateSignature(signMap, (long)schemeId);
            }
        }
        if (null == signJson) {
            throw new KDBizException("PermissionServiceHelper.generateSignature get signJson is null.");
        }
        String accountId = RequestContext.get().getAccountId();
        if (signJson.getBooleanValue("success")) {
            JSONObject data = signJson.getJSONObject("data");
            if (Objects.nonNull(data)) {
                return data;
            }
            throw new KDException("PermissionServiceHelper.generateSignature get data is null.");
        }
        String msg = signJson.getString("description");
        KDBizException e = new KDBizException(msg);
        logger.error(String.format("\u6570\u636e\u4e2d\u5fc3\u3010%s\u3011\u8bb8\u53ef\u52a0\u7b7e\u5931\u8d25...", accountId), (Throwable)e);
        throw e;
    }

    private static void updateCache(Map<Long, RoaringBitmap> bitMap, String type) {
        HashMap<String, String> cacheData = new HashMap<String, String>(bitMap.size());
        for (Map.Entry<Long, RoaringBitmap> entry : bitMap.entrySet()) {
            byte[] bytes = LicenseUserRelEngine.serRoaringBitmap(entry.getValue());
            cacheData.put(String.valueOf(entry.getKey()), new String(bytes, StandardCharsets.ISO_8859_1));
        }
        cacheData.put("VERSION", DB.genStringId((String)""));
        LicenseCacheMrg.putCache(type, cacheData);
    }
}

