/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.license.service;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.license.config.AESUtil;
import kd.bos.license.pojo.LicenseDetailSnapshot;
import kd.bos.license.pojo.LicenseGeneralSnapshot;
import kd.bos.license.pojo.LicenseGroupAppSnapshot;
import kd.bos.license.pojo.LicenseSnapshot;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;

public class LicenseGroupModuleValidDateUpgradeService
implements IUpgradeService {
    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try {
            this.upgradeGroupModuleValidDate("lic_license");
            this.upgradeGroupModuleValidDate("lic_license_trial");
            this.upgradeSnapshotGroupModuleValidDate();
            result.setSuccess(true);
        }
        catch (Exception ex) {
            result.setErrorInfo(ex.getMessage());
            result.setSuccess(false);
        }
        return result;
    }

    private void upgradeSnapshotGroupModuleValidDate() {
        String querySql = "select fid,fdata from t_lic_snapshot;";
        ArrayList updateParams = new ArrayList(2);
        DB.query((DBRoute)DBRoute.base, (String)querySql, resultSet -> {
            boolean isValidDateNull = false;
            while (resultSet.next()) {
                String snapshotStr;
                LicenseGeneralSnapshot snapshot;
                List<LicenseSnapshot> licenseSnapshots;
                String data = resultSet.getString("fdata");
                if (StringUtils.isBlank((CharSequence)data) || (licenseSnapshots = (snapshot = (LicenseGeneralSnapshot)SerializationUtils.fromJsonString((String)(snapshotStr = AESUtil.decrypt(data)), LicenseGeneralSnapshot.class)).getLicenseSnapshots()) == null || licenseSnapshots.isEmpty()) continue;
                for (LicenseSnapshot licenseSnapshot : licenseSnapshots) {
                    List<LicenseDetailSnapshot> detailSnapshotList = licenseSnapshot.getDetailSnapshotList();
                    if (detailSnapshotList == null || detailSnapshotList.isEmpty()) continue;
                    for (LicenseDetailSnapshot licenseDetailSnapshot : detailSnapshotList) {
                        List<LicenseGroupAppSnapshot> appSnapshotList = licenseDetailSnapshot.getAppSnapshotList();
                        if (appSnapshotList == null || appSnapshotList.isEmpty()) continue;
                        Date groupBeginDate = licenseDetailSnapshot.getBegindate();
                        Date groupEndDate = licenseDetailSnapshot.getEnddate();
                        for (LicenseGroupAppSnapshot licenseGroupAppSnapshot : appSnapshotList) {
                            if (licenseGroupAppSnapshot.getModuleBeginDate() == null) {
                                licenseGroupAppSnapshot.setModuleBeginDate(groupBeginDate);
                                isValidDateNull = true;
                            }
                            if (licenseGroupAppSnapshot.getModuleEndDate() != null) continue;
                            licenseGroupAppSnapshot.setModuleEndDate(groupEndDate);
                            isValidDateNull = true;
                        }
                    }
                }
                snapshotStr = SerializationUtils.toJsonString((Object)snapshot);
                data = AESUtil.encrypt(snapshotStr);
                if (!isValidDateNull) continue;
                Object[] param = new Object[]{data, resultSet.getLong("fid")};
                updateParams.add(param);
            }
            return true;
        });
        if (updateParams.size() > 0) {
            String updateSql = "update t_lic_snapshot set fdata = ? where fid = ?;";
            DB.executeBatch((DBRoute)DBRoute.base, (String)updateSql, updateParams);
        }
    }

    private void upgradeGroupModuleValidDate(String entityId) {
        String groupTable = "t_lic_licensedetail";
        String moduleTable = "t_lic_licensegroupapps";
        if ("lic_license_trial".equalsIgnoreCase(entityId)) {
            groupTable = "t_lic_licdetail_trial";
            moduleTable = "t_lic_licgroupapps_trial";
        }
        String querySql = String.format("select ld.fbegindate,ld.fenddate,lga.fdetailid,lga.fmodulebegindate,lga.fmoduleenddate from %s ld inner join %s lga on ld.fentryid = lga.fentryid;", groupTable, moduleTable);
        ArrayList updateParams = new ArrayList();
        DB.query((DBRoute)DBRoute.base, (String)querySql, resultSet -> {
            while (resultSet.next()) {
                Timestamp moduleBeginDate = resultSet.getTimestamp("fmodulebegindate");
                Timestamp moduleEndDate = resultSet.getTimestamp("fmoduleenddate");
                if (moduleBeginDate != null && moduleEndDate != null) continue;
                Object[] param = new Object[]{resultSet.getTimestamp("fbegindate"), resultSet.getTimestamp("fenddate"), resultSet.getLong("fdetailid")};
                updateParams.add(param);
            }
            return true;
        });
        if (updateParams.size() > 0) {
            String updateSql = String.format("update %s set fmodulebegindate = ?,fmoduleenddate = ? where fdetailid = ?;", moduleTable);
            DB.executeBatch((DBRoute)DBRoute.base, (String)updateSql, updateParams);
        }
    }
}

