/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.license.service.cache;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Properties;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.dc.utils.MCDBUtil;
import kd.bos.dc.utils.SQLUtils;
import kd.bos.dlock.DLock;
import kd.bos.encrypt.Encrypters;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.license.LicenseUpdateService;
import kd.bos.license.UpdateLicGroupUser;
import kd.bos.license.api.bean.ISVProdInfo;
import kd.bos.license.bean.LicGroupRuntime;
import kd.bos.license.bean.LicModuleRuntime;
import kd.bos.license.bean.LicenseGroupCtrl;
import kd.bos.license.bean.LicenseGroupInfo;
import kd.bos.license.bean.LicenseGroupType;
import kd.bos.license.bean.LicenseSyncLog;
import kd.bos.license.bean.RangeDate;
import kd.bos.license.bean.UserIndex;
import kd.bos.license.config.AESUtil;
import kd.bos.license.config.AppBizObjGroupCollection;
import kd.bos.license.config.AppBizObjGroupInfo;
import kd.bos.license.engine.LicenseUserRelEngine;
import kd.bos.license.pojo.LicGroupCtrlDB;
import kd.bos.license.pojo.LicenseGeneralSnapshot;
import kd.bos.license.service.cache.LicenseCacheMrg;
import kd.bos.license.util.LicGroupRuntimeUtil;
import kd.bos.license.util.LicModuleRuntimeUtil;
import kd.bos.license.util.LicenseConfigUtil;
import kd.bos.license.util.LicenseDefauleDataUtil;
import kd.bos.license.util.LicenseEnvironmentUtil;
import kd.bos.license.util.LicenseGroupUtil;
import kd.bos.license.util.LicenseMCApiUtil;
import kd.bos.license.util.LicenseUtil;
import kd.bos.license.util.UserIndexUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.ErrorCodeUtils;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.roaringbitmap.RoaringBitmap;

public class LicenseCache {
    private static Log logger = LogFactory.getLog(LicenseCache.class);
    public static final String LIC_GROUP = "lic_group";
    public static final String LIC_CTRL_GROUP = "lic_licensegroupctrl";
    public static final String USER_LIC_GROUP = "lic_userlicensegroup";
    public static final String LIC_ISV_PROD = "lic_isvprod";
    private static final String ENTITY_USER_TIAL = "lic_userlicgroup_trial";
    private static final String ENTITY_USER = "lic_userlicensegroup";
    private static final String ENTITY_SNAPSHOT = "lic_snapshot";
    private static final String LIC_MODULE = "lic_module";
    private static final String MCTEMPORARYLICENSE = "MCTEMPORARYLICENSE";
    private static final List<String> ignoreTenantIds = Arrays.asList("asiasymbol", "bigdata", "cqswhyfls", "dxgt", "hexie", "hlsjy", "hnxtkg", "jlsgroup", "joru", "kangyu", "lockin", "luenmei", "luenmeilz", "sxjhjt", "sxlqjt", "tgjt", "tjjzzb", "yaduo", "yidatf", "zycangqiong");

    public static List<Map<String, Object>> getAllGroup() {
        ArrayList<Map<String, Object>> allGroup = new ArrayList<Map<String, Object>>();
        String type = LicenseCacheMrg.getType4Group();
        Map<String, String> allGroupMap = LicenseCacheMrg.getCache(type);
        if (allGroupMap != null && allGroupMap.size() > 0) {
            Map groupMap = null;
            for (String value : allGroupMap.values()) {
                groupMap = (Map)SerializationUtils.fromJsonString((String)value, Map.class);
                allGroup.add(groupMap);
            }
        } else {
            DynamicObject[] groups = BusinessDataServiceHelper.load((String)LIC_GROUP, (String)"id, number, name", null);
            HashMap<String, Object> groupMap = null;
            String groupStr = null;
            for (DynamicObject group : groups) {
                groupMap = new HashMap<String, Object>();
                groupMap.put("id", group.getPkValue());
                groupMap.put("number", group.getString("number"));
                groupMap.put("name", group.getString("name"));
                allGroup.add(groupMap);
                groupStr = SerializationUtils.toJsonString(groupMap);
                LicenseCacheMrg.putCache(type, group.getString("number"), groupStr);
            }
        }
        return allGroup;
    }

    @Deprecated
    public static Long getGroupID(String bizAppID, String bizObjID) {
        Set<Long> groups = LicenseCache.getGroups(bizAppID, bizObjID);
        if (groups == null || groups.isEmpty()) {
            return 0L;
        }
        return new ArrayList<Long>(groups).get(0);
    }

    @Deprecated
    public static Set<Long> getGroups(String bizAppID, String bizObjID) {
        String[] groupIds;
        String appGroupStr;
        String key = bizAppID + bizObjID;
        String productVersion = LicenseServiceHelper.getProductVersion();
        boolean isPreviousLicense = "2.0".equals(productVersion) || "3.0".equals(productVersion) || "4.0".equals(productVersion);
        String groupIdStr = LicenseConfigUtil.getCurrLicenseConfig(key);
        if (isPreviousLicense && StringUtils.isEmpty((CharSequence)groupIdStr) && StringUtils.isBlank((CharSequence)(appGroupStr = LicenseCache.checkAppInLicenseCtrl(bizAppID)))) {
            groupIdStr = LicenseConfigUtil.getLatestLicenseConfig(key);
        }
        if (StringUtils.isEmpty((CharSequence)groupIdStr)) {
            logger.info("key : " + key + " group cache is null");
            return new HashSet<Long>(0);
        }
        HashSet<Long> result = new HashSet<Long>(2);
        for (String groupId : groupIds = groupIdStr.split(";")) {
            String[] arr = groupId.split("_");
            result.add(Long.parseLong(arr[0]));
        }
        return result;
    }

    public static boolean isUpdateLicByBitMap() {
        return !StringUtils.isBlank(LicenseCacheMrg.getCache(LicenseCacheMrg.getUpdateLicByBitMapType()));
    }

    public static LicenseGroupCtrl getLicenseGroupCtrl(String bizAppID, String bizObjID) {
        String appGroupStr;
        LicenseGroupCtrl licenseGroupCtrl = new LicenseGroupCtrl();
        String key = bizAppID + bizObjID;
        boolean isLatest = false;
        String productVersion = LicenseServiceHelper.getProductVersion();
        boolean isPreviousLicense = LicenseDefauleDataUtil.OLD_LIC_VERSION_SET.contains(productVersion);
        String groupIdModuleStr = LicenseConfigUtil.getCurrLicenseConfig(key);
        if (isPreviousLicense && StringUtils.isEmpty((CharSequence)groupIdModuleStr) && StringUtils.isBlank((CharSequence)(appGroupStr = LicenseCache.checkAppInLicenseCtrl(bizAppID)))) {
            groupIdModuleStr = LicenseConfigUtil.getLatestLicenseConfig(key);
            isLatest = true;
        }
        if (StringUtils.isEmpty((CharSequence)groupIdModuleStr)) {
            return licenseGroupCtrl;
        }
        String[] groupIdModules = groupIdModuleStr.split(";");
        String groupId = null;
        String module = null;
        for (String groupIdModule : groupIdModules) {
            module = null;
            if (groupIdModule != null && groupIdModule.contains("_")) {
                groupId = groupIdModule.substring(0, groupIdModule.indexOf("_"));
                module = groupIdModule.substring(groupIdModule.indexOf("_") + 1);
            } else {
                groupId = groupIdModule;
            }
            if (isLatest) {
                if (groupId != null) {
                    licenseGroupCtrl.getLatestVersionGroups().add(Long.parseLong(groupId));
                }
            } else if (groupId != null) {
                licenseGroupCtrl.getCurVersionGroups().add(Long.parseLong(groupId));
            }
            if (!StringUtils.isNotEmpty(module)) continue;
            licenseGroupCtrl.getModules().add(module);
        }
        return licenseGroupCtrl;
    }

    public static boolean isCircuitBreaker(String type) {
        String key = String.format("%s%s%s", "LicenseCache#isCircuitBreakerFromThreadCache_", type, RequestContext.get().getAccountId());
        return (Boolean)ThreadCache.get((Object)key, () -> !StringUtils.isBlank((CharSequence)LicenseCacheMrg.getCache(LicenseCacheMrg.getLicenseCircuitBreakerType(), type)));
    }

    public static void clearCircuitBreaker(String type) {
        String key = String.format("%s%s%s", "LicenseCache#isCircuitBreakerFromThreadCache_", type, RequestContext.get().getAccountId());
        ThreadCache.remove((Object)key);
        LicenseCacheMrg.clearCache(LicenseCacheMrg.getLicenseCircuitBreakerType(), type);
    }

    /*
     * Exception decompiling
     */
    public static void reloadCtrlGroup() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static List<LicGroupCtrlDB> updateLicCtrlListCache(AppBizObjGroupCollection appBizObjGroupCollection, Set<String> allLicCtrlSet, boolean isLatestLicCtrl) {
        Map<String, String> info;
        String licenseGroupConfig;
        String type = isLatestLicCtrl ? LicenseCacheMrg.getLatestTypeCtrlGroup() : LicenseCacheMrg.getType4CtrlGroup();
        String string = licenseGroupConfig = isLatestLicCtrl ? LicenseCacheMrg.getLatestTypeLicenseGroupConfig() : LicenseCacheMrg.getType4LicenseGroupConfig();
        if (appBizObjGroupCollection == null || appBizObjGroupCollection.isEmpty()) {
            LicenseCacheMrg.clearCache(type);
            LicenseCacheMrg.putCache(type, "DATA_LOADED", "DATA_LOADED");
            LicenseCacheMrg.clearCache(licenseGroupConfig);
            LicenseCacheMrg.putCache(licenseGroupConfig, "DATA_LOADED", "DATA_LOADED");
            return Collections.EMPTY_LIST;
        }
        ArrayList<LicGroupCtrlDB> groupCtrlList = new ArrayList<LicGroupCtrlDB>(appBizObjGroupCollection.size());
        HashMap<String, Set<String>> infoMap = new HashMap<String, Set<String>>(16);
        HashMap<String, Set<String>> configMap = new HashMap<String, Set<String>>(16);
        Map<String, DynamicObject> allMmodules = LicenseCache.getAllModulesFromDB();
        HashMap<String, String> bizAppId2Nums = new HashMap<String, String>(1024);
        DynamicObjectCollection allBizApps = BizAppServiceHelp.getAllBizApps();
        if (allBizApps != null && !allBizApps.isEmpty()) {
            for (DynamicObject bizapp : allBizApps) {
                bizAppId2Nums.put(bizapp.getString("id"), bizapp.getString("number"));
            }
        }
        for (Object o : appBizObjGroupCollection) {
            AppBizObjGroupInfo appBizObjGroupInfo = (AppBizObjGroupInfo)o;
            String appId = appBizObjGroupInfo.getAppID();
            String bizObjId = appBizObjGroupInfo.getBizObjID();
            String groupId = appBizObjGroupInfo.getGroupID();
            String moduleNumber = appBizObjGroupInfo.getModule();
            DynamicObject module = LicenseCache.getModule(appId, groupId, moduleNumber, allMmodules, bizAppId2Nums);
            if (StringUtils.isEmpty((CharSequence)moduleNumber) && module != null) {
                moduleNumber = module.getString("number");
            }
            logger.debug("LicenseCtrl info appId: " + appId + ", bizObjId: " + bizObjId + ", groupId: " + groupId + ", moduleNumber: " + moduleNumber);
            String licCtrl = String.join((CharSequence)"", appId, bizObjId, groupId, moduleNumber);
            if (allLicCtrlSet.contains(licCtrl)) continue;
            configMap.computeIfAbsent(appId + bizObjId, k -> new HashSet(1)).add(groupId + "_" + moduleNumber);
            infoMap.computeIfAbsent(appId, k -> new HashSet(1)).add(groupId);
            allLicCtrlSet.add(licCtrl);
            LicGroupCtrlDB licGroupCtrlDB = null;
            try {
                licGroupCtrlDB = new LicGroupCtrlDB(appId, bizObjId, Long.valueOf(groupId), null == module ? Long.valueOf(0L) : (Long)module.getPkValue());
            }
            catch (Exception e) {
                logger.error("LicGroupCtrlDB error. appId: " + appId + ", bizObjId: " + bizObjId + ", groupId: " + groupId);
            }
            if (null == licGroupCtrlDB) continue;
            groupCtrlList.add(licGroupCtrlDB);
        }
        Map<String, String> config = LicenseCache.generateCacheDataByCtrlMap(configMap);
        if (!CollectionUtils.isEmpty(config)) {
            LicenseCacheMrg.clearCache(type);
            LicenseCacheMrg.putCache(type, config);
            LicenseCacheMrg.setVersion(LicenseCacheMrg.getTypeLicenseConfigVersion(type), DB.genStringId((String)""));
        }
        if (!CollectionUtils.isEmpty(info = LicenseCache.generateCacheDataByCtrlMap(infoMap))) {
            LicenseCacheMrg.clearCache(licenseGroupConfig);
            LicenseCacheMrg.putCache(licenseGroupConfig, info);
            LicenseCacheMrg.setVersion(LicenseCacheMrg.getTypeLicenseConfigVersion(licenseGroupConfig), DB.genStringId((String)""));
        }
        return groupCtrlList;
    }

    private static Map<String, DynamicObject> getAllModulesFromDB() {
        HashMap<String, DynamicObject> result = new HashMap<String, DynamicObject>(512);
        DynamicObject[] load = BusinessDataServiceHelper.load((String)LIC_MODULE, (String)"number", null);
        if (load == null || load.length == 0) {
            return result;
        }
        for (DynamicObject module : load) {
            result.put(module.getString("number").toUpperCase(Locale.ENGLISH), module);
        }
        return result;
    }

    private static DynamicObject getModule(String appId, String groupId, String moduleNumber, Map<String, DynamicObject> allModules, Map<String, String> bizAppId2Nums) {
        if (StringUtils.isBlank((CharSequence)moduleNumber) && !StringUtils.isBlank((CharSequence)(moduleNumber = bizAppId2Nums.get(appId)))) {
            moduleNumber = moduleNumber.toUpperCase(Locale.ENGLISH);
        }
        if (StringUtils.isBlank((CharSequence)moduleNumber)) {
            return null;
        }
        DynamicObject module = allModules.get(moduleNumber.toUpperCase(Locale.ENGLISH));
        if (module == null) {
            LocaleString moduleName = null;
            AppInfo appInfo = null;
            try {
                appInfo = AppMetadataCache.getAppInfoByNumber((String)moduleNumber.toLowerCase(Locale.ENGLISH));
            }
            catch (Exception e) {
                logger.error("\u7f16\u7801\u4e3a" + moduleNumber + "\u7684\u5e94\u7528\u627e\u4e0d\u5230", (Throwable)e);
            }
            moduleName = appInfo == null ? new LocaleString(moduleNumber) : appInfo.getName();
            module = BusinessDataServiceHelper.newDynamicObject((String)LIC_MODULE);
            module.set("id", (Object)DB.genGlobalLongId());
            module.set("number", (Object)moduleNumber);
            module.set("name", (Object)moduleName);
            module.set("group", (Object)groupId);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{module});
            allModules.put(moduleNumber.toUpperCase(Locale.ENGLISH), module);
        }
        return module;
    }

    private static Map<String, String> generateCacheDataByCtrlMap(Map<String, Set<String>> licenseCtrlMap) {
        HashMap<String, String> result = new HashMap<String, String>(licenseCtrlMap.size());
        for (Map.Entry<String, Set<String>> entry : licenseCtrlMap.entrySet()) {
            String groupIdStr = String.join((CharSequence)";", (Iterable<? extends CharSequence>)entry.getValue());
            result.put(entry.getKey(), groupIdStr);
        }
        result.put("DATA_LOADED", "DATA_LOADED");
        return result;
    }

    public static String checkAppInLicenseCtrl(String appId) {
        Map<String, String> map = LicenseConfigUtil.getCurrAppConfig();
        return map.get(appId);
    }

    private static Map<String, String> getAPPLicenseConfig() {
        String licenseGroupConfig = LicenseCacheMrg.getType4LicenseGroupConfig();
        Map<String, String> map = LicenseCacheMrg.getCache(licenseGroupConfig);
        String productVersion = (String)LicenseServiceHelper.getProductInfo().get("productversion");
        boolean isPreviousLicense = LicenseDefauleDataUtil.OLD_LIC_VERSION_SET.contains(productVersion);
        if (isPreviousLicense && CollectionUtils.isEmpty(map)) {
            map = LicenseCacheMrg.getCache(LicenseCacheMrg.getLatestTypeLicenseGroupConfig());
        }
        return map;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Set<String> getAllControlApps() {
        Map<String, String> map = LicenseCache.getAPPLicenseConfig();
        if (!CollectionUtils.isEmpty(map)) return map.keySet();
        DLock dl = DLock.create((String)"AppInLicenseCtrl");
        dl.lock();
        try {
            map = LicenseCache.getAPPLicenseConfig();
            if (CollectionUtils.isEmpty(map) && !LicenseCache.isCircuitBreaker("ctrl")) {
                LicenseCache.reloadCtrlGroup();
                map = LicenseCache.getAPPLicenseConfig();
            }
        }
        finally {
            dl.unlock();
        }
        if (!CollectionUtils.isEmpty(map)) return map.keySet();
        return Collections.EMPTY_SET;
    }

    public static DynamicObject getGroupByID(Long groupID) {
        DynamicObject group = null;
        ArrayList<String> groupIds = new ArrayList<String>(1);
        groupIds.add(String.valueOf(groupID));
        Map groupInfoMap = LicenseGroupUtil.getLicenseGroupInfos(groupIds);
        if (CollectionUtils.isEmpty((Map)groupInfoMap)) {
            group = QueryServiceHelper.queryOne((String)LIC_GROUP, (String)"id, number, name, type", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)groupID)});
            return group;
        }
        LicenseGroupInfo licenseGroupInfo = (LicenseGroupInfo)groupInfoMap.get(String.valueOf(groupID));
        if (null == licenseGroupInfo) {
            group = QueryServiceHelper.queryOne((String)LIC_GROUP, (String)"id, number, name, type", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)groupID)});
            return group;
        }
        group = BusinessDataServiceHelper.newDynamicObject((String)LIC_GROUP);
        group.set("id", (Object)licenseGroupInfo.getId());
        group.set("number", (Object)licenseGroupInfo.getNumber());
        group.set("name", (Object)licenseGroupInfo.getName());
        LicenseGroupType type = licenseGroupInfo.getType();
        group.set("type", (Object)(LicenseGroupType.REUSER == type ? "1" : "2"));
        return group;
    }

    public static Set<String> getUserLicenseGroups(Long userID, List<Long> groupIds) {
        if (userID == null || userID.equals(0L) || userID.equals(-1L) || CollectionUtils.isEmpty(groupIds)) {
            return Collections.emptySet();
        }
        if (LicenseCache.isCircuitBreaker("bitMap")) {
            return Collections.emptySet();
        }
        HashSet<String> userLicenseGroups = new HashSet<String>(16);
        Map userIndexListBySet = UserIndexUtil.getUserIndexListBySet(Collections.singleton(userID));
        if (CollectionUtils.isEmpty((Map)userIndexListBySet)) {
            return Collections.emptySet();
        }
        int index = ((UserIndex)userIndexListBySet.get(userID)).getIndex();
        Map<Long, RoaringBitmap> currLicRelBitByVersionMode = LicenseUserRelEngine.getCurrLicRelBitByVersionMode(groupIds);
        if (CollectionUtils.isEmpty(currLicRelBitByVersionMode)) {
            logger.error("getUserLicenseGroups: allroaringBitmap is Empty. return empty;");
            return Collections.emptySet();
        }
        for (Map.Entry<Long, RoaringBitmap> currLicRelBitByVersionModeDatas : currLicRelBitByVersionMode.entrySet()) {
            Long groupId = currLicRelBitByVersionModeDatas.getKey();
            RoaringBitmap bit = currLicRelBitByVersionModeDatas.getValue();
            if (null == bit || !bit.contains(index)) continue;
            userLicenseGroups.add(String.valueOf(groupId));
        }
        logger.debug("LicenseCache.getUserLicenseGroups:GroupCacheuserID :userID={},index={},userLicenseGroups={}", new Object[]{userID, index, userLicenseGroups});
        return userLicenseGroups;
    }

    @Deprecated
    public static Set<String> getUserLicenseGroups(Long userID) {
        HashSet<String> userLicenseGroups = new HashSet<String>(16);
        if (userID == null || userID.equals(0L) || userID.equals(-1L)) {
            return Collections.emptySet();
        }
        if (LicenseCache.isCircuitBreaker("bitMap")) {
            return Collections.emptySet();
        }
        Map userIndexListBySet = UserIndexUtil.getUserIndexListBySet(Collections.singleton(userID));
        if (CollectionUtils.isEmpty((Map)userIndexListBySet)) {
            return Collections.emptySet();
        }
        int index = ((UserIndex)userIndexListBySet.get(userID)).getIndex();
        Map<Long, RoaringBitmap> currLicRelBitByVersionMode = LicenseUserRelEngine.getCurrLicRelBitByVersionMode(null);
        if (CollectionUtils.isEmpty(currLicRelBitByVersionMode)) {
            logger.error("getUserLicenseGroups: allroaringBitmap is Empty. return empty;");
            return Collections.emptySet();
        }
        for (Map.Entry<Long, RoaringBitmap> currLicRelBitByVersionModeDatas : currLicRelBitByVersionMode.entrySet()) {
            Long groupId = currLicRelBitByVersionModeDatas.getKey();
            RoaringBitmap bit = currLicRelBitByVersionModeDatas.getValue();
            if (null == bit || !bit.contains(index)) continue;
            userLicenseGroups.add(String.valueOf(groupId));
        }
        logger.info("LicenseCache.getUserLicenseGroups -- GroupCacheuserID : " + userLicenseGroups + " -- userID : " + userID);
        return userLicenseGroups;
    }

    private static void downloadAndUpdateLic(boolean isHighAvailabilityMode, LicenseSyncLog licenseSyncLog) {
        UpdateLicGroupUser updateLicGroupUser = new UpdateLicGroupUser();
        boolean updateLicenseResult = false;
        try {
            updateLicenseResult = updateLicGroupUser.downloadAndUpdateLicUser(true, licenseSyncLog, isHighAvailabilityMode);
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0\u8bb8\u53ef\u5f02\u5e38", (Throwable)e);
        }
        if (null != licenseSyncLog) {
            licenseSyncLog.setOperator(Long.valueOf(-10000L));
        }
        if (!updateLicenseResult) {
            logger.error("\u66f4\u65b0\u8bb8\u53ef\u5f02\u5e38");
            throw new KDBizException(ResManager.loadKDString((String)"\u66f4\u65b0\u8bb8\u53ef\u5f02\u5e38", (String)"LicenseCache_0", (String)"bos-license-business", (Object[])new Object[0]));
        }
    }

    public static void reLoadLicenseCache() {
        LicenseCache.reloadLicenseDetailCache();
    }

    public static void reloadLicenseDetailCache() {
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"lic_license", (String)"lic_licensedetail.group,lic_licensedetail.totalcount", null);
        String licenseDetailType = LicenseCacheMrg.getType4LicenseDetail();
        HashMap<String, String> licenseDetail = new HashMap<String, String>(16);
        if (load == null || load.length == 0) {
            return;
        }
        for (DynamicObject licenseObj : load) {
            DynamicObjectCollection detail = licenseObj.getDynamicObjectCollection("lic_licensedetail");
            for (DynamicObject detailGroup : detail) {
                DynamicObject group = detailGroup.getDynamicObject("group");
                if (null == group) continue;
                licenseDetail.put(detailGroup.getDynamicObject("group").getPkValue().toString(), detailGroup.getString("totalcount"));
            }
        }
        licenseDetail.put("DATA_LOADED", "DATA_LOADED");
        LicenseCacheMrg.clearCache(licenseDetailType);
        LicenseCacheMrg.putCache(licenseDetailType, licenseDetail);
    }

    public static String getUploadRegUserProgress() {
        String uploadRegUserProgress = null;
        String cachekey = "uploadRegUserProgress";
        String type = LicenseCacheMrg.getType4UploadRegUserProgress();
        uploadRegUserProgress = LicenseCacheMrg.getCache(type, cachekey);
        return uploadRegUserProgress;
    }

    public static void updateUploadRegUserProgress(String uploadRegUserProgress) {
        String cachekey = "uploadRegUserProgress";
        String type = LicenseCacheMrg.getType4UploadRegUserProgress();
        LicenseCacheMrg.putCache(type, cachekey, uploadRegUserProgress);
    }

    public static boolean isCtrlAmount() {
        if (ignoreTenantIds.contains(RequestContext.get().getTenantId())) {
            return true;
        }
        boolean isCtrlAmount = false;
        ArrayList<String> groupIds = new ArrayList<String>(2);
        groupIds.add("186");
        groupIds.add("187");
        Map<String, LicGroupRuntime> groupRumtimeInfosById = LicGroupRuntimeUtil.getGroupRumtimeInfosById(groupIds);
        if (CollectionUtils.isEmpty(groupRumtimeInfosById)) {
            return isCtrlAmount;
        }
        if (groupRumtimeInfosById.containsKey("187")) {
            isCtrlAmount = true;
        } else if (groupRumtimeInfosById.containsKey("186")) {
            isCtrlAmount = true;
        }
        if (isCtrlAmount) {
            logger.info("LicenseCache.isCtrlAmount is true");
        }
        return isCtrlAmount;
    }

    public static boolean isCtrlAmountIgnoreTime() {
        return LicenseCache.isCtrlAmount();
    }

    public static void updateProductInstance(String productInstance) {
        String cachekey = "productInstance";
        String type = LicenseCacheMrg.getType4ProductInstance();
        LicenseCacheMrg.putCache(type, cachekey, productInstance);
    }

    public static String getProductInstance() {
        String productInstance = null;
        String cachekey = "productInstance";
        String type = LicenseCacheMrg.getType4ProductInstance();
        productInstance = LicenseCacheMrg.getCache(type, cachekey);
        return productInstance;
    }

    public static List<ISVProdInfo> getAllISVProd() {
        String selectFeild = "prodnumber, prodname, isvnumber, isvname, version";
        DynamicObjectCollection isvProds = QueryServiceHelper.query((String)LIC_ISV_PROD, (String)selectFeild, null);
        if (isvProds != null && !isvProds.isEmpty()) {
            ArrayList<ISVProdInfo> allISVProd = new ArrayList<ISVProdInfo>(isvProds.size());
            ISVProdInfo isvPordInfo = null;
            for (DynamicObject isvPord : isvProds) {
                isvPordInfo = new ISVProdInfo();
                isvPordInfo.setProdNumber(isvPord.getString("prodnumber"));
                isvPordInfo.setProdName(isvPord.getString("prodname"));
                isvPordInfo.setIsvNumber(isvPord.getString("isvnumber"));
                isvPordInfo.setIsvName(isvPord.getString("isvname"));
                isvPordInfo.setVersion(isvPord.getString("version"));
                if ("kingdee".equals(isvPord.getString("isvnumber"))) continue;
                allISVProd.add(isvPordInfo);
            }
            return allISVProd;
        }
        return new ArrayList<ISVProdInfo>(0);
    }

    public static void updateAllISVProd(List<ISVProdInfo> allISVProd) {
        CacheConfigInfo info = new CacheConfigInfo();
        info.setTimeout(3600);
        info.setMaxMemSize(300);
        LocalMemoryCache localCache = CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache(RequestContext.get().getAccountId(), "license", info);
        localCache.put("ALL_ISV_PROD", allISVProd);
    }

    public static int getModelType() {
        String modeType = LicenseEnvironmentUtil.getModeType();
        try {
            return Integer.parseInt(modeType);
        }
        catch (Exception e) {
            logger.error("modeType is not int.modeType : " + modeType);
            return 3;
        }
    }

    public static void clearCache4AvailableApp() {
        LicenseCacheMrg.clearCache(LicenseCacheMrg.getType4AvailableApp());
    }

    public static void clearCache4Group() {
        LicenseCacheMrg.clearCache(LicenseCacheMrg.getType4GroupByID());
    }

    public static void clearLicUpdateCache() {
        LicenseCacheMrg.clearCache(LicenseCacheMrg.getTypeLicUpdate());
    }

    public static void clearCircuitBreakerCache() {
        LicenseCacheMrg.clearCache(LicenseCacheMrg.getLicenseCircuitBreakerType());
    }

    public static Set<String> getLicenseModules() {
        if (LicenseCache.isCircuitBreaker("module")) {
            return Collections.EMPTY_SET;
        }
        Map<String, LicModuleRuntime> allModuleRuntimeInfos = LicModuleRuntimeUtil.getAllModuleRuntimeInfos();
        if (CollectionUtils.isEmpty(allModuleRuntimeInfos)) {
            return Collections.EMPTY_SET;
        }
        return allModuleRuntimeInfos.keySet();
    }

    public static Set<String> reloadLicenseModules() {
        String sql = " SELECT m.fnumber fnumber FROM T_LIC_LICENSEGROUPAPPS l inner join t_lic_module m on l.fmoduleid = m.fid ";
        Set licenseModules = (Set)DB.query((DBRoute)DBRoute.base, (String)sql, (ResultSetHandler)new ResultSetHandler<Set<String>>(){

            public Set<String> handle(ResultSet rs) throws Exception {
                HashSet<String> modules = new HashSet<String>(16);
                HashSet<String> bizAppNum = new HashSet<String>(16);
                while (rs.next()) {
                    String moduleNum = rs.getString("fnumber");
                    modules.add(moduleNum);
                    bizAppNum.add(moduleNum.toLowerCase(Locale.ENGLISH));
                }
                if (!bizAppNum.isEmpty()) {
                    DynamicObject[] load = BusinessDataServiceHelper.load((String)"bos_devportal_bizapp", (String)"number", (QFilter[])new QFilter("number", "in", bizAppNum).toArray());
                    if (load == null || load.length == 0) {
                        return modules;
                    }
                    for (DynamicObject appObj : load) {
                        String appId = appObj.getPkValue().toString();
                        modules.add(appId);
                    }
                }
                return modules;
            }
        });
        String type4LicenseModules = LicenseCacheMrg.getType4LicenseModules();
        LicenseCacheMrg.putCache(type4LicenseModules, type4LicenseModules, SerializationUtils.toJsonString((Object)licenseModules));
        return licenseModules;
    }

    public static Date getExpireDateByGroup(Long groupId) {
        if (groupId == null) {
            return (Date)DB.query((DBRoute)DBRoute.base, (String)"select fexpdate expdate from t_lic_license ", rs -> rs.next() ? LicenseUtil.getDateEndTime((Date)rs.getDate("expdate")) : TimeServiceHelper.now());
        }
        String groupIdStr = String.valueOf(groupId);
        Map<String, LicGroupRuntime> groupRumtimeInfosById = LicGroupRuntimeUtil.getGroupRumtimeInfosById(Collections.singletonList(groupIdStr));
        if (CollectionUtils.isEmpty(groupRumtimeInfosById) || null == groupRumtimeInfosById.get(groupIdStr)) {
            logger.debug("LicenseCache.getExpireDateByGroup:groupId={},dateStr={}", (Object)groupId, null);
            return null;
        }
        LicGroupRuntime licGroupRuntime = groupRumtimeInfosById.get(groupIdStr);
        List rangeDateList = licGroupRuntime.getRangeDateList();
        if (CollectionUtils.isEmpty((Collection)rangeDateList)) {
            logger.debug("LicenseCache.getExpireDateByGroup:groupId={},dateStr={}", (Object)groupId, null);
            return null;
        }
        RangeDate rangeDate = (RangeDate)rangeDateList.get(0);
        if (null == rangeDate) {
            logger.debug("LicenseCache.getExpireDateByGroup:groupId={},dateStr={}", (Object)groupId, null);
            return null;
        }
        Date endDate = rangeDate.getEndDate();
        logger.debug("LicenseCache.getExpireDateByGroup:groupId={},dateStr={}", (Object)groupId, (Object)endDate);
        return endDate;
    }

    public static String reloadExpireDateCache(Long groupId) {
        String sql = "SELECT ld.FGROUPID FGROUPID, ld.FENDDATE FENDDATE, l.FEXPDATE FEXPDATE FROM T_LIC_LICENSEDETAIL ld INNER JOIN T_LIC_LICENSE l ON l.FID = ld.FID ";
        Map result = (Map)DB.query((DBRoute)DBRoute.base, (String)sql, (ResultSetHandler)new ResultSetHandler<Map<String, String>>(){

            public Map<String, String> handle(ResultSet rs) throws Exception {
                HashMap<String, String> groupExpDate = new HashMap<String, String>(16);
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                while (rs.next()) {
                    String groupId = rs.getString("FGROUPID");
                    Date date = rs.getDate("FENDDATE");
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(date);
                    calendar.set(11, 23);
                    calendar.set(12, 59);
                    calendar.set(13, 59);
                    date = calendar.getTime();
                    groupExpDate.put(groupId, sdf.format(date));
                    date = rs.getDate("FEXPDATE");
                    calendar.setTime(date);
                    calendar.set(11, 23);
                    calendar.set(12, 59);
                    calendar.set(13, 59);
                    date = calendar.getTime();
                    groupExpDate.put("0", sdf.format(date));
                }
                return groupExpDate;
            }
        });
        result.put("DATA_LOADED", "DATA_LOADED");
        String type4LicenseExpireDate = LicenseCacheMrg.getType4LicenseExpireDate();
        LicenseCacheMrg.clearCache(type4LicenseExpireDate);
        LicenseCacheMrg.putCache(type4LicenseExpireDate, result);
        return (String)result.get(groupId.toString());
    }

    public static Date getBeginDateByGroup(Long groupId) {
        if (groupId == null) {
            return (Date)DB.query((DBRoute)DBRoute.base, (String)"select factivedate begindate from t_lic_license ", rs -> rs.next() ? LicenseUtil.getDateEndTime((Date)rs.getDate("begindate")) : TimeServiceHelper.now());
        }
        String groupIdStr = String.valueOf(groupId);
        Map<String, LicGroupRuntime> groupRumtimeInfosById = LicGroupRuntimeUtil.getGroupRumtimeInfosById(Collections.singletonList(groupIdStr));
        if (CollectionUtils.isEmpty(groupRumtimeInfosById) || null == groupRumtimeInfosById.get(groupIdStr)) {
            logger.debug("LicenseCache.getBeginDateByGroup:groupId={},dateStr={}", (Object)groupId, null);
            return null;
        }
        LicGroupRuntime licGroupRuntime = groupRumtimeInfosById.get(groupIdStr);
        List rangeDateList = licGroupRuntime.getRangeDateList();
        if (CollectionUtils.isEmpty((Collection)rangeDateList)) {
            logger.debug("LicenseCache.getBeginDateByGroup:groupId={},dateStr={}", (Object)groupId, null);
            return null;
        }
        RangeDate rangeDate = (RangeDate)rangeDateList.get(0);
        if (null == rangeDate) {
            logger.debug("LicenseCache.getBeginDateByGroup:groupId={},dateStr={}", (Object)groupId, null);
            return null;
        }
        Date endDate = rangeDate.getBeginDate();
        logger.debug("LicenseCache.getBeginDateByGroup:groupId={},dateStr={}", (Object)groupId, (Object)endDate);
        return endDate;
    }

    public static String reloadBeginDateCache(Long groupId) {
        String sql = "SELECT ld.FGROUPID FGROUPID, ld.FBEGINDATE FBEGINDATE, l.FACTIVEDATE FACTIVEDATE FROM T_LIC_LICENSEDETAIL ld INNER JOIN T_LIC_LICENSE l ON l.FID = ld.FID ";
        Map result = (Map)DB.query((DBRoute)DBRoute.base, (String)sql, (ResultSetHandler)new ResultSetHandler<Map<String, String>>(){

            public Map<String, String> handle(ResultSet rs) throws Exception {
                HashMap<String, String> groupBeginDate = new HashMap<String, String>(16);
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                while (rs.next()) {
                    String groupId = rs.getString("FGROUPID");
                    Date date = rs.getDate("FBEGINDATE");
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(date);
                    calendar.set(11, 0);
                    calendar.set(12, 0);
                    calendar.set(13, 0);
                    date = calendar.getTime();
                    groupBeginDate.put(groupId, sdf.format(date));
                    date = rs.getDate("FACTIVEDATE");
                    calendar.setTime(date);
                    calendar.set(11, 0);
                    calendar.set(12, 0);
                    calendar.set(13, 0);
                    date = calendar.getTime();
                    groupBeginDate.put("0", sdf.format(date));
                }
                return groupBeginDate;
            }
        });
        result.put("DATA_LOADED", "DATA_LOADED");
        String type4LicenseBeginDate = LicenseCacheMrg.getType4LicenseBeginDate();
        LicenseCacheMrg.clearCache(type4LicenseBeginDate);
        LicenseCacheMrg.putCache(type4LicenseBeginDate, result);
        return (String)result.get(groupId.toString());
    }

    public static Map<String, String> getLicenseCtrl() {
        String type4CtrlGroup = LicenseCacheMrg.getType4CtrlGroup();
        return LicenseCacheMrg.getCache(type4CtrlGroup);
    }

    public static int getMaxUserBitMapIndex() {
        int maxUserBitMapIndex = LicenseCacheMrg.getMaxUserBitMapIndex();
        if (0 == maxUserBitMapIndex) {
            try (DLock dLock = DLock.create((String)("MAXUSERBITMAPINDEX_" + RequestContext.get().getTenantId()));){
                dLock.lock();
                maxUserBitMapIndex = LicenseCacheMrg.getMaxUserBitMapIndex();
                if (0 == maxUserBitMapIndex) {
                    maxUserBitMapIndex = LicenseCache.getMaxIndexFromDB() + 1;
                    LicenseCache.setMaxUserBitMapIndex(maxUserBitMapIndex);
                }
            }
            catch (Exception e) {
                logger.error("GenerateUserIndexCache error.", (Throwable)e);
                throw new KDBizException(ResManager.loadKDString((String)"\u52a0\u8f7d\u7528\u6237\u4f4d\u56fe\u4e0b\u6807\u7f13\u5b58\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"LicenseCache_2", (String)"bos-license-business", (Object[])new Object[0]));
            }
        }
        return maxUserBitMapIndex;
    }

    private static int getMaxIndexFromDB() {
        String tenantId = RequestContext.get().getTenantId();
        List accounts = AccountUtils.getAllAccounts((String)tenantId);
        int maxIndex = 0;
        for (Account account : accounts) {
            ResultSet rs;
            PreparedStatement pstmt;
            Connection conn;
            block6: {
                Properties dataBaseProperties = AccountUtils.getTenantDBInfo((Account)account);
                if (dataBaseProperties == null) {
                    logger.error(ErrorCodeUtils.getDBIntralError());
                    throw new KDException(BosErrorCode.configNotFound, new Object[]{ErrorCodeUtils.getDBIntralError()});
                }
                conn = null;
                pstmt = null;
                rs = null;
                try {
                    conn = MCDBUtil.getConnection((Account)account, (Properties)dataBaseProperties);
                    String sql = "select max(fbitmapindex) maxIndex from t_lic_userbitmapindex";
                    pstmt = conn.prepareStatement(sql);
                    rs = pstmt.executeQuery();
                    if (!rs.next()) break block6;
                    int bitmapIndex = rs.getInt("maxIndex");
                    maxIndex = maxIndex > bitmapIndex ? maxIndex : bitmapIndex;
                }
                catch (Exception exp) {
                    try {
                        logger.error((Throwable)exp);
                        throw new KDException((Throwable)exp, BosErrorCode.sQLConnection, new Object[]{ErrorCodeUtils.getDBIntralError() + ErrorCodeUtils.getSlipSignerror() + exp.getMessage()});
                    }
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(rs, pstmt, (Connection)conn);
                        throw throwable;
                    }
                }
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
        }
        return maxIndex;
    }

    public static void IncrMaxUserBitMapIndex() {
        LicenseCacheMrg.IncrMaxUserBitMapIndex();
    }

    public static void IncrStepMaxUserBitMapIndex(int step) {
        LicenseCacheMrg.IncrStepMaxUserBitMapIndex(step);
    }

    public static void setMaxUserBitMapIndex(int value) {
        LicenseCacheMrg.setMaxUserBitMapIndex(value);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean requireWriteLock() {
        if (!LicenseUtil.isHighAvailabilityMode()) {
            return true;
        }
        try (DLock dlock = DLock.create((String)("requireWriteLock" + RequestContext.get().getAccountId()));){
            dlock.lock();
            String type = LicenseCacheMrg.getTypeLicUpdate();
            String write = LicenseCacheMrg.getCache(type, "write");
            if (StringUtils.isNotEmpty((CharSequence)write)) {
                boolean bl = false;
                return bl;
            }
            String pageIdsStr = LicenseCacheMrg.getCache(type, "read");
            if (StringUtils.isEmpty((CharSequence)pageIdsStr)) {
                LicenseCacheMrg.putCache(type, "write", "true");
                boolean bl = true;
                return bl;
            }
            String[] pageIds = pageIdsStr.split("separator");
            StringBuilder pageIdSB = new StringBuilder();
            boolean isFirst = true;
            for (String pageId : pageIds) {
                if (!SessionManager.getCurrent().existView(pageId)) continue;
                pageIdSB.append(isFirst ? pageId : "separator" + pageId);
                isFirst = false;
            }
            LicenseCacheMrg.putCache(type, "read", pageIdSB.toString());
            boolean bl = StringUtils.isEmpty((CharSequence)pageIdSB);
            return bl;
        }
        catch (Exception e) {
            logger.info("\u83b7\u53d6\u8bb8\u53ef\u66f4\u65b0\u5199\u9501\u5f02\u5e38,\u4e3a\u4e86\u4e0d\u5f71\u54cd\u4e1a\u52a1\uff0c\u6309\u7167\u65e0\u9501\u5904\u7406", (Object)e);
            return true;
        }
    }

    public static void releaseWriteLock() {
        if (!LicenseUtil.isHighAvailabilityMode()) {
            return;
        }
        try (DLock dlock = DLock.create((String)("releaseWriteLock" + RequestContext.get().getAccountId()));){
            dlock.lock();
            String type = LicenseCacheMrg.getTypeLicUpdate();
            LicenseCacheMrg.clearCache(type, "write");
        }
    }

    public static void releaseReadLock(String pageId) {
        if (!LicenseUtil.isHighAvailabilityMode()) {
            return;
        }
        try (DLock dlock = DLock.create((String)("releaseReadLock" + RequestContext.get().getAccountId()));){
            dlock.lock();
            String type = LicenseCacheMrg.getTypeLicUpdate();
            String pageIdsStr = LicenseCacheMrg.getCache(type, "read");
            if (StringUtils.isNotEmpty((CharSequence)pageIdsStr)) {
                String[] pageIds = pageIdsStr.split("separator");
                StringBuilder pageIdSB = new StringBuilder();
                boolean isFirst = true;
                for (String pageIdStr : pageIds) {
                    if (pageIdStr.equals(pageId) || !SessionManager.getCurrent().existView(pageId)) continue;
                    pageIdSB.append(isFirst ? pageId : "separator" + pageId);
                    isFirst = false;
                }
                LicenseCacheMrg.putCache(type, "read", pageIdSB.toString());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean requireReadLock(String pageId) {
        if (!LicenseUtil.isHighAvailabilityMode()) {
            return true;
        }
        try (DLock dlock = DLock.create((String)("requireReadLock" + RequestContext.get().getAccountId()));){
            dlock.lock();
            String type = LicenseCacheMrg.getTypeLicUpdate();
            String write = LicenseCacheMrg.getCache(type, "write");
            if (StringUtils.isNotEmpty((CharSequence)write)) {
                boolean bl2 = false;
                return bl2;
            }
            String pageIdsStr = LicenseCacheMrg.getCache(type, "read");
            if (StringUtils.isEmpty((CharSequence)pageIdsStr)) {
                LicenseCacheMrg.putCache(type, "read", pageId);
            } else {
                LicenseCacheMrg.putCache(type, "read", pageIdsStr + "separator" + pageId);
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            logger.info("\u83b7\u53d6\u8bb8\u53ef\u66f4\u65b0\u8bfb\u9501\u5f02\u5e38,\u4e3a\u4e86\u4e0d\u5f71\u54cd\u4e1a\u52a1\uff0c\u6309\u7167\u65e0\u9501\u5904\u7406", (Object)e);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generateTrialRedisMap() {
        HashSet<Long> userIds = new HashSet<Long>(16);
        HashMap<Long, Set> groupAndUser = new HashMap<Long, Set>(32);
        HashMap<Long, Set> groupAndIndex = new HashMap<Long, Set>(32);
        DataSet userGroupTrial = null;
        try {
            userGroupTrial = DB.queryDataSet((String)"selectUserGroupTrial", (DBRoute)DBRoute.base, (String)"select fuserid userId,fgroupid groupId from T_LIC_USERLICGROUP_TRIAL where fstatus ='1'");
            if (null == userGroupTrial || userGroupTrial.isEmpty()) {
                logger.info("\u8bd5\u7b97\u8868\u4e3a\u7a7a\uff0c\u53ef\u80fd\u5df2\u7ecf\u5931\u8d25\uff0c\u4e3a\u4e86\u663e\u793a\u6570\u636e\u7684\u51c6\u786e\u8bfb\u53d6\u975e\u8bd5\u7b97\u8868\u4e2d\u7684\u6570\u636e\u751f\u6210\u8bd5\u7b97\u4f4d\u56fe");
                userGroupTrial = DB.queryDataSet((String)"selectUserGroup", (DBRoute)DBRoute.base, (String)"select fuserid userId,fgroupid groupId from T_LIC_USERLICENSEGROUP where fstatus ='1'");
            }
            if (null == userGroupTrial || userGroupTrial.isEmpty()) {
                logger.info("\u65e0\u53ef\u7528\u5206\u914d\u6570\u636e");
            } else {
                while (userGroupTrial.hasNext()) {
                    Row userGroup = userGroupTrial.next();
                    Long userId = userGroup.getLong("userId");
                    Long l = userGroup.getLong("groupId");
                    groupAndUser.computeIfAbsent(l, k -> new HashSet()).add(userId);
                    userIds.add(userId);
                }
            }
        }
        finally {
            if (null != userGroupTrial) {
                userGroupTrial.close();
            }
        }
        Map<Long, Integer> userBitMapIndex = LicenseUserRelEngine.getUserBitMapIndex(userIds);
        for (Map.Entry entry : groupAndUser.entrySet()) {
            Long groupId = (Long)entry.getKey();
            Set users = (Set)entry.getValue();
            for (Long user : users) {
                Integer index = userBitMapIndex.get(user);
                if (index == null) continue;
                groupAndIndex.computeIfAbsent(groupId, k -> new HashSet()).add(index);
            }
        }
        String type = LicenseCacheMrg.getTypeLicenseTrialRedisMap();
        LicenseCacheMrg.putCache(type, RequestContext.get().getAccountId(), JSON.toJSONString(groupAndIndex));
    }

    public static Map<String, Integer> getUserIndexFromCache(List<String> characteristics) {
        if (characteristics == null) {
            return Collections.EMPTY_MAP;
        }
        String type4LicenseUserIndex = LicenseCacheMrg.getType4LicenseUserIndex();
        Map<String, String> userIndexCache = LicenseCacheMrg.getCache(type4LicenseUserIndex);
        if (userIndexCache == null || userIndexCache.isEmpty()) {
            try {
                DLock dLock = DLock.create((String)("GENERATEUSERINDEXCACHE_" + RequestContext.get().getTenantId()));
                Object object = null;
                try {
                    dLock.lock();
                    userIndexCache = LicenseCacheMrg.getCache(type4LicenseUserIndex);
                    if (userIndexCache == null || userIndexCache.isEmpty()) {
                        userIndexCache = LicenseCache.reloadUserIndexCache();
                    }
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (dLock != null) {
                        if (object != null) {
                            try {
                                dLock.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            dLock.close();
                        }
                    }
                }
            }
            catch (Exception e) {
                logger.error("GenerateUserIndexCache error.", (Throwable)e);
                throw new KDBizException(ResManager.loadKDString((String)"\u52a0\u8f7d\u7528\u6237\u4f4d\u56fe\u4e0b\u6807\u7f13\u5b58\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"LicenseCache_2", (String)"bos-license-business", (Object[])new Object[0]));
            }
        }
        HashMap<String, Integer> result = new HashMap<String, Integer>(characteristics.size());
        for (String characteristic : characteristics) {
            String indexStr = userIndexCache.get(characteristic);
            if (indexStr == null) {
                indexStr = "0";
            }
            result.put(characteristic, Integer.valueOf(indexStr));
        }
        return result;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Map<String, String> reloadUserIndexCache() {
        String property = (String)LicenseUtil.getUniqueCharacteristic().get("field");
        String sql = "select fid,fphone,femail,fusername,fbitmapindex from t_lic_userbitmapindex";
        String tenantId = RequestContext.get().getTenantId();
        List accounts = AccountUtils.getAllAccounts((String)tenantId);
        HashMap<String, String> result = new HashMap<String, String>(1024);
        Iterator iterator = accounts.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                String type4LicenseUserIndex = LicenseCacheMrg.getType4LicenseUserIndex();
                LicenseCacheMrg.putCache(type4LicenseUserIndex, result);
                LicenseCacheMrg.putCache(type4LicenseUserIndex, "DATA_LOADED", "DATA_LOADED");
                return result;
            }
            Account account = (Account)iterator.next();
            Properties dataBaseProperties = AccountUtils.getTenantDBInfo((Account)account);
            Connection conn = null;
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                conn = MCDBUtil.getConnection((Account)account, (Properties)dataBaseProperties);
                pstmt = conn.prepareStatement("select fid,fphone,femail,fusername,fbitmapindex from t_lic_userbitmapindex");
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    String uniqueVal = rs.getString(property);
                    if (StringUtils.isBlank((CharSequence)uniqueVal)) continue;
                    result.put(uniqueVal, rs.getString("fbitmapindex"));
                }
            }
            catch (SQLException sqlExp) {
                try {
                    logger.error((Throwable)sqlExp);
                    throw new KDException((Throwable)sqlExp, BosErrorCode.sQLConnection, new Object[]{ErrorCodeUtils.getDBIntralError() + ErrorCodeUtils.getSlipSignerror() + sqlExp.getMessage()});
                    catch (Exception exp) {
                        logger.error((Throwable)exp);
                        throw new KDException((Throwable)exp, BosErrorCode.sQLConnection, new Object[]{ErrorCodeUtils.getDBIntralError() + ErrorCodeUtils.getSlipSignerror() + exp.getMessage()});
                    }
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, pstmt, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
        }
    }

    public static void addUserIndex(Map<String, Integer> userIndexCache) {
        if (userIndexCache == null) {
            return;
        }
        String type4LicenseUserIndex = LicenseCacheMrg.getType4LicenseUserIndex();
        Map<String, String> userIndexCacheFromCache = LicenseCacheMrg.getCache(type4LicenseUserIndex);
        if (userIndexCacheFromCache == null || userIndexCacheFromCache.isEmpty()) {
            try (DLock dLock = DLock.create((String)("GENERATEUSERINDEXCACHE_" + RequestContext.get().getTenantId()));){
                dLock.lock();
                userIndexCacheFromCache = LicenseCacheMrg.getCache(type4LicenseUserIndex);
                if (userIndexCacheFromCache == null || userIndexCacheFromCache.isEmpty()) {
                    userIndexCacheFromCache = LicenseCache.reloadUserIndexCache();
                }
            }
            catch (Exception e) {
                logger.error("GenerateUserIndexCache error.", (Throwable)e);
                throw new KDBizException(ResManager.loadKDString((String)"\u52a0\u8f7d\u7528\u6237\u4f4d\u56fe\u4e0b\u6807\u7f13\u5b58\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"LicenseCache_2", (String)"bos-license-business", (Object[])new Object[0]));
            }
        }
        for (Map.Entry<String, Integer> entry : userIndexCache.entrySet()) {
            userIndexCacheFromCache.put(entry.getKey(), entry.getValue().toString());
        }
        LicenseCacheMrg.putCache(type4LicenseUserIndex, userIndexCacheFromCache);
        String type4LicenseIndexUser = LicenseCacheMrg.getType4LicenseIndexUser();
        Map<String, String> indexUserCache = LicenseCacheMrg.getCache(type4LicenseIndexUser);
        if (indexUserCache == null || indexUserCache.isEmpty()) {
            try (DLock dLock = DLock.create((String)("GENERATEINDEXUSERCACHE_" + RequestContext.get().getTenantId()));){
                dLock.lock();
                indexUserCache = LicenseCacheMrg.getCache(type4LicenseIndexUser);
                if (indexUserCache == null || indexUserCache.isEmpty()) {
                    indexUserCache = LicenseCache.reloadUserCharacteristicsIndexCache();
                }
            }
            catch (Exception e) {
                logger.error("GenerateIndexUserCache error.", (Throwable)e);
                throw new KDBizException(ResManager.loadKDString((String)"\u52a0\u8f7d\u7528\u6237\u4f4d\u56fe\u4e0b\u6807\u7f13\u5b58\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"LicenseCache_2", (String)"bos-license-business", (Object[])new Object[0]));
            }
        }
        for (Map.Entry<String, Integer> entry : userIndexCache.entrySet()) {
            indexUserCache.put(entry.getValue().toString(), entry.getKey());
        }
        LicenseCacheMrg.putCache(type4LicenseIndexUser, indexUserCache);
    }

    @Deprecated
    public static Map<Integer, String> getUserCharacteristicsFromCache(List<Integer> indexs) {
        if (indexs == null) {
            return Collections.EMPTY_MAP;
        }
        String type4LicenseIndexUser = LicenseCacheMrg.getType4LicenseIndexUser();
        Map<String, String> indexUserCache = LicenseCacheMrg.getCache(type4LicenseIndexUser);
        if (indexUserCache == null || indexUserCache.isEmpty()) {
            try {
                DLock dLock = DLock.create((String)("GENERATEINDEXUSERCACHE_" + RequestContext.get().getTenantId()));
                Object object = null;
                try {
                    dLock.lock();
                    indexUserCache = LicenseCacheMrg.getCache(type4LicenseIndexUser);
                    if (indexUserCache == null || indexUserCache.isEmpty()) {
                        indexUserCache = LicenseCache.reloadUserCharacteristicsIndexCache();
                    }
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (dLock != null) {
                        if (object != null) {
                            try {
                                dLock.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            dLock.close();
                        }
                    }
                }
            }
            catch (Exception e) {
                logger.error("GenerateIndexUserCache error.", (Throwable)e);
                throw new KDBizException(ResManager.loadKDString((String)"\u52a0\u8f7d\u7528\u6237\u4f4d\u56fe\u4e0b\u6807\u7f13\u5b58\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"LicenseCache_2", (String)"bos-license-business", (Object[])new Object[0]));
            }
        }
        HashMap<Integer, String> result = new HashMap<Integer, String>(indexs.size());
        for (Integer index : indexs) {
            String characteristicStr = indexUserCache.get(String.valueOf(index));
            if (characteristicStr == null) continue;
            result.put(index, characteristicStr);
        }
        return result;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Map<String, String> reloadUserCharacteristicsIndexCache() {
        String property = (String)LicenseUtil.getUniqueCharacteristic().get("field");
        String sql = "select fid,fphone,femail,fusername,fbitmapindex from t_lic_userbitmapindex";
        String tenantId = RequestContext.get().getTenantId();
        List accounts = AccountUtils.getAllAccounts((String)tenantId);
        HashMap<String, String> result = new HashMap<String, String>(1024);
        Iterator iterator = accounts.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                String type4LicenseIndexUser = LicenseCacheMrg.getType4LicenseIndexUser();
                LicenseCacheMrg.putCache(type4LicenseIndexUser, result);
                LicenseCacheMrg.putCache(type4LicenseIndexUser, "DATA_LOADED", "DATA_LOADED");
                return result;
            }
            Account account = (Account)iterator.next();
            Properties dataBaseProperties = AccountUtils.getTenantDBInfo((Account)account);
            Connection conn = null;
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                conn = MCDBUtil.getConnection((Account)account, (Properties)dataBaseProperties);
                pstmt = conn.prepareStatement("select fid,fphone,femail,fusername,fbitmapindex from t_lic_userbitmapindex");
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    result.put(rs.getString("fbitmapindex"), rs.getString(property));
                }
            }
            catch (SQLException sqlExp) {
                try {
                    logger.error((Throwable)sqlExp);
                    throw new KDException((Throwable)sqlExp, BosErrorCode.sQLConnection, new Object[]{ErrorCodeUtils.getDBIntralError() + ErrorCodeUtils.getSlipSignerror() + sqlExp.getMessage()});
                    catch (Exception exp) {
                        logger.error((Throwable)exp);
                        throw new KDException((Throwable)exp, BosErrorCode.sQLConnection, new Object[]{ErrorCodeUtils.getDBIntralError() + ErrorCodeUtils.getSlipSignerror() + exp.getMessage()});
                    }
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, pstmt, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
        }
    }

    public static Map<Long, Integer> getGroupTotal() {
        Map<String, LicGroupRuntime> allGroupRumtimeInfos = LicGroupRuntimeUtil.getAllGroupRumtimeInfos();
        if (CollectionUtils.isEmpty(allGroupRumtimeInfos)) {
            return Collections.EMPTY_MAP;
        }
        HashMap<Long, Integer> result = new HashMap<Long, Integer>(16);
        for (Map.Entry<String, LicGroupRuntime> info : allGroupRumtimeInfos.entrySet()) {
            LicGroupRuntime licGroupRuntime = info.getValue();
            String groupId = info.getKey();
            if (null == licGroupRuntime || StringUtils.isBlank((CharSequence)groupId)) continue;
            result.put(Long.parseLong(groupId), licGroupRuntime.getTotalNumber());
        }
        return result;
    }

    public static Map<String, String> getTempLicenseCache() {
        HashMap<String, String> cacheMap = new HashMap<String, String>(3);
        cacheMap.put("isTemLic", LicenseEnvironmentUtil.isTemLic() ? "1" : "0");
        cacheMap.put("isShowWaterMark", LicenseEnvironmentUtil.isShowWaterMark() ? "1" : "0");
        cacheMap.put("sceneType", LicenseEnvironmentUtil.getSceneType());
        return cacheMap;
    }

    private static Map<String, String> reloadTemporaryLicenseCache() {
        String sceneType;
        boolean isTemporaryLicense = false;
        boolean isShowWaterMark = false;
        try {
            DynamicObjectCollection snapshotDoc = QueryServiceHelper.query((String)ENTITY_SNAPSHOT, (String)"data, snapshottype", null);
            if (LicenseUtil.isHighAvailabilityMode() && snapshotDoc != null && snapshotDoc.size() > 0) {
                snapshotDoc.sort((o1, o2) -> {
                    int type1 = Integer.parseInt(o1.getString("snapshottype"));
                    int type2 = Integer.parseInt(o2.getString("snapshottype"));
                    return type1 - type2;
                });
                String data = ((DynamicObject)snapshotDoc.get(snapshotDoc.size() - 1)).getString("data");
                String snapshotStr = AESUtil.decrypt(data);
                LicenseGeneralSnapshot snapshot = (LicenseGeneralSnapshot)SerializationUtils.fromJsonString((String)snapshotStr, LicenseGeneralSnapshot.class);
                isTemporaryLicense = snapshot.isTempLic();
                isShowWaterMark = snapshot.isShowWaterMark();
                sceneType = StringUtils.isBlank((CharSequence)snapshot.getSceneType()) && isTemporaryLicense ? "TEMP" : snapshot.getSceneType();
            } else {
                PriorityQueue<String> sceneTypePriorityQueue = LicenseUpdateService.buildSceneTypePriorityQueue();
                Map parseObject = LicenseMCApiUtil.JsonToMap((String)LicenseMCApiUtil.getEncryptLicFileFromMc());
                Object dataJson = parseObject.get("data");
                String licenseData = String.valueOf(dataJson);
                if (Encrypters.isEncrypted((String)licenseData)) {
                    licenseData = Encrypters.decode((String)licenseData);
                }
                logger.info("LicenseData : " + LicenseUtil.removeAllRegUsers((String)licenseData));
                List dataList = (List)JSONObject.parseObject((String)licenseData, List.class);
                for (Object dataMapJson : dataList) {
                    boolean showWatermark;
                    JSONObject jsonObject = JSON.parseObject((String)dataMapJson.toString());
                    JSONObject content = jsonObject.getJSONObject("content");
                    Object source = content.get((Object)"source");
                    boolean isFromKBC = source != null && source.toString().contains("KBC");
                    isTemporaryLicense = isTemporaryLicense || MCTEMPORARYLICENSE.equals(content.get((Object)"regUsers")) || LicenseUpdateService.isTrial((Map<String, Object>)content, isFromKBC);
                    Object showWatermarkObj = content.get((Object)"showWatermark");
                    boolean bl = showWatermark = showWatermarkObj == null || Boolean.parseBoolean(showWatermarkObj.toString());
                    if (!showWatermark) continue;
                    isShowWaterMark = true;
                    String tempSceneType = isTemporaryLicense ? "TEMP" : content.getString("sceneType");
                    sceneTypePriorityQueue.add(tempSceneType);
                    logger.info("LicenseCache#reloadTemporaryLicenseCache:sceneType={}", (Object)content.getString("sceneType"));
                }
                logger.info("LicenseCache#reloadTemporaryLicenseCache#sceneTypePriorityQueue={}", (Object)sceneTypePriorityQueue.toString());
                sceneType = sceneTypePriorityQueue.poll();
                if (isShowWaterMark && "PRD".equals(sceneType)) {
                    isShowWaterMark = false;
                }
            }
        }
        catch (Exception e) {
            logger.error("LicenseCache.reloadTemporaryLicenseCache get license failed.", (Throwable)e);
            return Collections.EMPTY_MAP;
        }
        String type4isTemporaryLicense = LicenseCacheMrg.getType4isTemporaryLicense();
        HashMap<String, String> cacheMap = new HashMap<String, String>(2);
        cacheMap.put("isTemLic", isTemporaryLicense ? "1" : "0");
        cacheMap.put("isShowWaterMark", isShowWaterMark ? "1" : "0");
        cacheMap.put("sceneType", sceneType == null ? "" : sceneType);
        LicenseCacheMrg.putCache(type4isTemporaryLicense, cacheMap);
        return cacheMap;
    }

    public static void clearLicenseModuleValidDateCache() {
        String type4ModuleValidDate = LicenseCacheMrg.getType4ModuleValidDate();
        LicenseCacheMrg.clearCache(type4ModuleValidDate);
    }

    public static Map<String, List<Date[]>> getLicenseModuleValidDateCache() {
        if (LicenseCache.isCircuitBreaker("module")) {
            return Collections.EMPTY_MAP;
        }
        Map<String, LicModuleRuntime> allModuleRuntimeInfos = LicModuleRuntimeUtil.getAllModuleRuntimeInfos();
        if (CollectionUtils.isEmpty(allModuleRuntimeInfos)) {
            return Collections.EMPTY_MAP;
        }
        HashMap<String, List<Date[]>> result = new HashMap<String, List<Date[]>>(16);
        for (Map.Entry<String, LicModuleRuntime> info : allModuleRuntimeInfos.entrySet()) {
            RangeDate rangeDate;
            List rangeDates;
            String key = info.getKey();
            LicModuleRuntime licModuleRuntime = info.getValue();
            if (null == licModuleRuntime || null == (rangeDates = licModuleRuntime.getRangeDates()) || null == (rangeDate = (RangeDate)rangeDates.get(0))) continue;
            ArrayList<Date[]> dates = new ArrayList<Date[]>(1);
            dates.add(new Date[]{rangeDate.getBeginDate(), rangeDate.getEndDate()});
            result.put(key, dates);
        }
        return result;
    }

    public static Map<String, List<Date[]>> reloadModuleValidDateCache() {
        String sql = "select lm.fnumber,ld.fbegindate,ld.fenddate,lga.fmodulebegindate,lga.fmoduleenddate  from t_lic_licensedetail ld inner join t_lic_licensegroupapps lga on ld.fentryid = lga.fentryid INNER JOIN t_lic_module lm ON lga.fmoduleid = lm.fid;";
        HashMap<String, List<Date[]>> res = new HashMap<String, List<Date[]>>(16);
        HashMap<String, String> module2ValidDate = new HashMap<String, String>(16);
        DB.query((DBRoute)DBRoute.base, (String)sql, rs -> {
            while (rs.next()) {
                Date endDate;
                String moduleNumber = rs.getString("fnumber").toUpperCase();
                Date beginDate = rs.getDate("fmodulebegindate");
                if (beginDate == null) {
                    beginDate = rs.getDate("fbegindate");
                }
                if ((endDate = rs.getDate("fmoduleenddate")) == null) {
                    endDate = rs.getDate("fenddate");
                }
                if (beginDate == null || endDate == null) {
                    logger.info("module {} begindate or enddate is empty", (Object)moduleNumber);
                    continue;
                }
                beginDate = LicenseUtil.getDateStartTime((Date)beginDate);
                endDate = LicenseUtil.getDateEndTime((Date)endDate);
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String beginStr = dateFormat.format(beginDate);
                String endStr = dateFormat.format(endDate);
                String existBeginEnd = (String)module2ValidDate.get(moduleNumber);
                if (StringUtils.isBlank((CharSequence)existBeginEnd)) {
                    module2ValidDate.put(moduleNumber, String.format("%s_%s;", beginStr, endStr));
                } else {
                    module2ValidDate.put(moduleNumber, String.format("%s_%s", existBeginEnd, beginStr, endStr));
                }
                List dates = res.computeIfAbsent(moduleNumber, v -> new ArrayList());
                Date[] beginEndDate = new Date[]{beginDate, endDate};
                dates.add(beginEndDate);
            }
            return true;
        });
        String type4ModuleValidDate = LicenseCacheMrg.getType4ModuleValidDate();
        LicenseCacheMrg.clearCache(type4ModuleValidDate);
        LicenseCacheMrg.putCache(type4ModuleValidDate, module2ValidDate);
        return res;
    }

    public static List<Object[]> getGroupLicFileValidDateCache(Long groupId) {
        String groupIdStr = String.valueOf(groupId);
        ArrayList<Object[]> res = new ArrayList<Object[]>(16);
        Map<String, LicGroupRuntime> groupRumtimeInfosById = LicGroupRuntimeUtil.getGroupRumtimeInfosById(Collections.singleton(groupIdStr));
        if (CollectionUtils.isEmpty(groupRumtimeInfosById)) {
            return res;
        }
        LicGroupRuntime licGroupRuntime = groupRumtimeInfosById.get(groupIdStr);
        if (null == licGroupRuntime) {
            return res;
        }
        Date licBeginDate = licGroupRuntime.getLicBeginDate();
        Date licEndDate = licGroupRuntime.getLicEndDate();
        res.add(new Object[]{licBeginDate, licEndDate});
        return res;
    }

    public static String reloadGroupLicFileValidDateCache(Long groupId) {
        String sql = "SELECT ld.FGROUPID FGROUPID, l.FPRODID FPRODID, l.FACTIVEDATE FACTIVEDATE,l.FEXPDATE FEXPDATE FROM T_LIC_LICENSEDETAIL ld INNER JOIN T_LIC_LICENSE l ON l.FID = ld.FID ";
        HashMap<String, String> prodId2ValidDateStr = new HashMap<String, String>(8);
        DB.query((DBRoute)DBRoute.base, (String)sql, rs -> {
            while (rs.next()) {
                String groupIdStr = rs.getString("fgroupid");
                String prodId = rs.getString("fprodid");
                Date beginDate = rs.getDate("factivedate");
                Date endDate = rs.getDate("fexpdate");
                if (prodId == null || beginDate == null || endDate == null) {
                    logger.info("LicenseCache.reloadGroupLicFileValidDateCache:prodId={},beginDate={},endDate={}", new Object[]{prodId, beginDate, endDate});
                    continue;
                }
                beginDate = LicenseUtil.getDateStartTime((Date)beginDate);
                endDate = LicenseUtil.getDateEndTime((Date)endDate);
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String beginStr = dateFormat.format(beginDate);
                String endStr = dateFormat.format(endDate);
                String beginStr_EndStr = (String)prodId2ValidDateStr.get(groupIdStr);
                if (StringUtils.isBlank((CharSequence)beginStr_EndStr)) {
                    prodId2ValidDateStr.put(groupIdStr, String.format("%s_%s_%s;", prodId, beginStr, endStr));
                    continue;
                }
                prodId2ValidDateStr.put(groupIdStr, String.format("%s%s_%s_%s;", beginStr_EndStr, prodId, beginStr, endStr));
            }
            return true;
        });
        String type4LicFileValidDate = LicenseCacheMrg.getType4GroupLicFileValidDate();
        LicenseCacheMrg.clearCache(type4LicFileValidDate);
        LicenseCacheMrg.putCache(type4LicFileValidDate, prodId2ValidDateStr);
        return (String)prodId2ValidDateStr.get(groupId.toString());
    }
}

