/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.license.service.cache;

import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;

public class LicenseCacheMrg {
    private static Log logger = LogFactory.getLog(LicenseCacheMrg.class);
    private static final String LICENSE = "LICENSE";
    private static DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("LICENSE", new DistributeCacheHAPolicy(true, true));
    private static final int TIME_OUT_DAYS = 365;
    private static final String BS_LICENSE = "LICENSE_";
    public static final String GROUP = "LICENSE_GROUP";
    public static final String GROUP_ID = "LICENSE_GROUP_ID";
    public static final String USER_GROUPS = "LICENSE_USER_GROUPS";
    public static final String LICENSE_CTRLCONFIG = "LICENSE_LICENSE_CTRLCONFIG";
    public static final String CTRL_GROUP = "LICENSE_CTRL_GROUP";
    public static final String UPLOAD_REG_USER_PROGRESS = "LICENSE_UPLOAD_REG_USER_PROGRESS";
    public static final String LICENSE_DETAIL = "LICENSE_LICENSE_DETAIL";
    public static final String LICENSE_CHECKCODE = "LICENSE_LICENSE_CHECKCODE";
    public static final String PRODUCT_INSTANCE = "LICENSE_PRODUCT_INSTANCE";
    public static final String LICENSE_ISTEMPORARYLICENSE = "LICENSE_LICENSE_ISTEMPORARYLICENSE";
    public static final String LICENSE_ISTEMPORARYLICENSE_TRIAL = "LICENSE_LICENSE_ISTEMPORARYLICENSE_TRIAL";
    public static final String LICENSE_ISCTRLAMOUNT = "LICENSE_LICENSE_ISCTRLAMOUNT";
    public static final String LICENSE_MODE_TYPE = "LICENSE_MODE_TYPE";
    public static final String LICENSE_AVAILABLEAPP = "LICENSE_LICENSE_AVAILABLEAPP";
    public static final String LICENSE_BEGINDATE = "LICENSE_LICENSE_BEGINDATE";
    public static final String LICENSE_EXPIREDATE = "LICENSE_LICENSE_EXPIREDATE";
    public static final String LICENSE_MODULES = "LICENSE_LICENSE_MODULES";
    private static final String LICENSE_USERINDEX = "LICENSE_USERINDEX";
    private static final String LICENSE_INDEXUSER = "LICENSE_INDEXUSER";
    public static final String LICENSE_USERMAXBITMAPINDEX = "LICENSE_USERMAXBITMAPINDEX";
    public static final String LICENSE_USERGROUPBITMAP = "LICENSE_USERGROUPBITMAP";
    public static final String LICENSE_UPDATEING = "LICENSE_UPDATEING";
    public static final String LICENSE_TRIAL_REDISMAP = "LICENSE_TRIAL_REDISMAP";
    public static final String LICENSE_MODULE_CTRL_VERSION = "LICENSE_MODULE_CTRL_VERSION";
    public static final String LICENSE_MODULE_VALID_DATE = "LICENSE_MODULE_VALID_DATE";
    public static final String LICENSE_GROUP_LICFILE_VALID_DATE = "LICENSE_GROUP_LICFILE_VALID_DATE";
    public static final String LICENSE_ISV_BIZ_OBJ_PROD = "LICENSE_ISV_BIZ_OBJ_PROD";
    public static final String LICENSE_CIRCUITBREAKER = "LICENSE_CIRCUIT_BREAK";
    public static final String LICENSE_ENVIRONMENT = "LICENSE_Environment";
    public static final String LICENSE_RUNTIMEGROUP = "LICENSE_groupRuntime";
    public static final String LICENSE_RUNTIMEMODULE = "LICENSE_moduleRuntime";
    public static final String LICENSE_UPDATELIC_BITMAP = "LICENSE_UPDATE_BITMAPP";
    private static final String ENTITY_SNAPSHOT = "lic_snapshot";
    public static final String LOADED = "DATA_LOADED";

    private static String getAcctId() {
        String acctenantId = CacheKeyUtil.getAcctId();
        if (acctenantId == null || acctenantId.length() == 0) {
            throw new RuntimeException(ResManager.loadKDString((String)"\u5f53\u524d\u79df\u6237\u4e3a\u7a7a.", (String)"LicenseCacheMrg_0", (String)"bos-license-business", (Object[])new Object[0]));
        }
        return acctenantId;
    }

    private static String getTenantId() {
        return Instance.getClusterName() + "." + RequestContext.get().getTenantId();
    }

    public static String getUpdateLicByBitMapType() {
        return LICENSE_UPDATELIC_BITMAP + LicenseCacheMrg.getAcctId();
    }

    public static String getLicEnvironmentalType() {
        return LICENSE_ENVIRONMENT + LicenseCacheMrg.getAcctId();
    }

    public static String getLicGroupRuntimeType() {
        return LICENSE_RUNTIMEGROUP + LicenseCacheMrg.getAcctId();
    }

    public static String getLicModuelRuntimeType() {
        return LICENSE_RUNTIMEMODULE + LicenseCacheMrg.getAcctId();
    }

    public static String getLicenseCircuitBreakerType() {
        return LICENSE_CIRCUITBREAKER + LicenseCacheMrg.getAcctId();
    }

    public static String getTypeLicenseConfigVersion(String redisType) {
        return redisType + "_VERSION";
    }

    public static String getTypeLicUpdate() {
        return "LICENSE_UPDATEING_" + LicenseCacheMrg.getAcctId();
    }

    public static String getType4UserMaxBitMapIndex() {
        return LICENSE_USERMAXBITMAPINDEX + LicenseCacheMrg.getTenantId();
    }

    public static String getType4UserGroupBitMap() {
        return LicenseCacheMrg.getType4UserGroupBitMap(RequestContext.get().getAccountId());
    }

    public static String getType4UserGroupBitMap(String accountId) {
        return String.format("%s%s.%s", LICENSE_USERGROUPBITMAP, Instance.getClusterName(), accountId);
    }

    public static String getType4Group() {
        return "LICENSE_GROUP_" + LicenseCacheMrg.getAcctId();
    }

    public static String getType4GroupByID() {
        return "LICENSE_GROUP_ID_" + LicenseCacheMrg.getAcctId();
    }

    public static String getType4UserLicenseGroups() {
        return "LICENSE_USER_GROUPS_" + LicenseCacheMrg.getAcctId();
    }

    public static String getType4UserLicenseGroupsOriginal() {
        return "LICENSE_USER_GROUPS_" + LicenseCacheMrg.getAcctId();
    }

    public static String getType4LicenseGroupConfig() {
        return "LICENSE_LICENSE_CTRLCONFIG_" + LicenseCacheMrg.getAcctId();
    }

    public static String getType4LicenseGroupConfigOriginal() {
        return "LICENSE_LICENSE_CTRLCONFIG_" + LicenseCacheMrg.getAcctId();
    }

    @Deprecated
    public static String getV4Type4LicenseGroupConfig() {
        return LicenseCacheMrg.getType4LicenseGroupConfig() + "_v4";
    }

    @Deprecated
    public static String getV4Type4LicenseGroupConfigOriginal() {
        return LicenseCacheMrg.getType4LicenseGroupConfig() + "_v4";
    }

    public static String getLatestTypeLicenseGroupConfig() {
        return LicenseCacheMrg.getType4LicenseGroupConfig() + "_vlatest";
    }

    public static String getLatestTypeLicenseGroupConfigOriginal() {
        return LicenseCacheMrg.getType4LicenseGroupConfig() + "_vlatest";
    }

    @Deprecated
    public static String getV4Type4CtrlGroup() {
        return LicenseCacheMrg.getType4CtrlGroup() + "_v4";
    }

    public static String getType4CtrlGroup() {
        return "LICENSE_CTRL_GROUP_" + LicenseCacheMrg.getAcctId();
    }

    public static String getType4CtrlGroupOriginal() {
        return "LICENSE_CTRL_GROUP_" + LicenseCacheMrg.getAcctId();
    }

    public static String getLatestTypeCtrlGroup() {
        return LicenseCacheMrg.getType4CtrlGroupOriginal() + "_Vlatest";
    }

    public static String getLatestTypeCtrlGroupOriginal() {
        return LicenseCacheMrg.getType4CtrlGroup() + "_Vlatest";
    }

    public static String getType4UploadRegUserProgress() {
        return "LICENSE_UPLOAD_REG_USER_PROGRESS_" + LicenseCacheMrg.getAcctId();
    }

    public static String getType4LicenseDetail() {
        return "LICENSE_LICENSE_DETAIL_" + LicenseCacheMrg.getAcctId();
    }

    public static String getType4LicenseDetailOriginal() {
        return "LICENSE_LICENSE_DETAIL_" + LicenseCacheMrg.getAcctId();
    }

    public static String getType4CheckCode() {
        return "LICENSE_LICENSE_CHECKCODE_" + LicenseCacheMrg.getAcctId();
    }

    public static String getType4isTemporaryLicense() {
        return "LICENSE_LICENSE_ISTEMPORARYLICENSE_" + LicenseCacheMrg.getAcctId();
    }

    public static String getType4isTemporaryLicenseTrial() {
        return "LICENSE_LICENSE_ISTEMPORARYLICENSE_TRIAL_" + LicenseCacheMrg.getAcctId();
    }

    public static String getType4ProductInstance() {
        return "LICENSE_PRODUCT_INSTANCE_" + LicenseCacheMrg.getAcctId();
    }

    public static String getType4IsCtrlAmount() {
        return "LICENSE_LICENSE_ISCTRLAMOUNT_" + LicenseCacheMrg.getAcctId();
    }

    public static String getType4ModeType() {
        return "LICENSE_MODE_TYPE_" + LicenseCacheMrg.getAcctId();
    }

    public static String getType4AvailableApp() {
        return "LICENSE_LICENSE_AVAILABLEAPP_" + LicenseCacheMrg.getAcctId();
    }

    public static String getType4LicenseBeginDate() {
        return "LICENSE_LICENSE_BEGINDATE_" + LicenseCacheMrg.getAcctId();
    }

    public static String getType4LicenseBeginDateOriginal() {
        return "LICENSE_LICENSE_BEGINDATE_" + LicenseCacheMrg.getAcctId();
    }

    public static String getType4LicenseExpireDate() {
        return "LICENSE_LICENSE_EXPIREDATE_" + LicenseCacheMrg.getAcctId();
    }

    public static String getType4LicenseExpireDateOriginal() {
        return "LICENSE_LICENSE_EXPIREDATE_" + LicenseCacheMrg.getAcctId();
    }

    public static String getType4LicenseModules() {
        return "LICENSE_LICENSE_MODULES_" + LicenseCacheMrg.getAcctId();
    }

    public static String getType4LicenseModulesOriginal() {
        return "LICENSE_LICENSE_MODULES_" + LicenseCacheMrg.getAcctId();
    }

    public static String getTypeLicenseTrialRedisMap() {
        return "LICENSE_TRIAL_REDISMAP_" + LicenseCacheMrg.getTenantId();
    }

    public static String getType4LicenseUserIndex() {
        return "LICENSE_USERINDEX_" + LicenseCacheMrg.getTenantId();
    }

    public static String getType4LicenseIndexUser() {
        return "LICENSE_INDEXUSER_" + LicenseCacheMrg.getTenantId();
    }

    public static String getType4ModuleCtrlVersion() {
        return "LICENSE_MODULE_CTRL_VERSION_" + LicenseCacheMrg.getAcctId();
    }

    public static String getType4ModuleValidDate() {
        return "LICENSE_MODULE_VALID_DATE_" + LicenseCacheMrg.getAcctId();
    }

    public static String getType4GroupLicFileValidDate() {
        return "LICENSE_GROUP_LICFILE_VALID_DATE_" + LicenseCacheMrg.getAcctId();
    }

    public static String getType4IsvBizObjProd() {
        return "LICENSE_ISV_BIZ_OBJ_PROD_" + LicenseCacheMrg.getAcctId();
    }

    public static void clearAllCache() {
        logger.info("LicenseCache.clearAllCache.");
        cache.removeType(LicenseCacheMrg.getType4Group());
        cache.removeType(LicenseCacheMrg.getType4LicenseDetail());
        cache.removeType(LicenseCacheMrg.getType4CtrlGroup());
        cache.removeType(LicenseCacheMrg.getType4LicenseGroupConfig());
        cache.removeType(LicenseCacheMrg.getType4UserLicenseGroups());
        cache.removeType(LicenseCacheMrg.getType4AvailableApp());
        cache.removeType(LicenseCacheMrg.getType4LicenseExpireDate());
        cache.removeType(LicenseCacheMrg.getType4LicenseModules());
        cache.removeType(LicenseCacheMrg.getType4ModuleValidDate());
        cache.removeType(LicenseCacheMrg.getType4GroupLicFileValidDate());
    }

    public static void clearCache(String type) {
        logger.info("LicenseCache.clearCache type : " + type);
        cache.removeType(type);
    }

    public static void clearCache(String type, String key) {
        logger.info("LicenseCache.clearCache type : " + type + " key : " + key);
        cache.remove(type, key);
    }

    public static void clearCacheWithPrefix(String type, String keyPrefix) {
        List cacheKeysWithPrefix = cache.getKeysWithPrefix(type, keyPrefix);
        if (cacheKeysWithPrefix != null && !cacheKeysWithPrefix.isEmpty()) {
            for (String key : cacheKeysWithPrefix) {
                LicenseCacheMrg.clearCache(type, key);
            }
        }
    }

    public static String getSingleCache(String type) {
        return (String)cache.get(type);
    }

    public static String getCache(String type, String key) {
        return (String)cache.get(type, key);
    }

    public static List<String> getCache(String type, String[] keys) {
        return cache.get(type, keys);
    }

    public static void putCache(String type, String key, String value) {
        cache.put(type, key, value, 365, TimeUnit.DAYS);
    }

    public static void putCache(String type, Map<String, String> values) {
        cache.put(type, values, 365, TimeUnit.DAYS);
    }

    public static void setVersion(String type, String version) {
        cache.put(type, (Object)version, 365, TimeUnit.DAYS);
    }

    public static Map<String, String> getCache(String type) {
        return cache.getAll(type);
    }

    public static void loaded(String type, String key) {
        cache.put(type, key, LOADED, 365, TimeUnit.DAYS);
    }

    public static boolean isData(String value) {
        if (value == null || value.length() == 0 || "null".equalsIgnoreCase(value)) {
            return false;
        }
        return !value.equals(LOADED);
    }

    public static boolean isLoaded(String value) {
        return value != null && value.length() != 0 && !"null".equalsIgnoreCase(value);
    }

    public static String getVersion(String type) {
        return (String)cache.get(type);
    }

    public static int getMaxUserBitMapIndex() {
        String type4UserBitMapIndex = LicenseCacheMrg.getType4UserMaxBitMapIndex();
        String value = (String)cache.get(type4UserBitMapIndex);
        return StringUtils.isEmpty((String)value) ? 0 : Integer.parseInt(value);
    }

    public static void IncrMaxUserBitMapIndex() {
        String type4UserBitMapIndex = LicenseCacheMrg.getType4UserMaxBitMapIndex();
        cache.inc(type4UserBitMapIndex);
    }

    public static void IncrStepMaxUserBitMapIndex(int step) {
        String type4UserBitMapIndex = LicenseCacheMrg.getType4UserMaxBitMapIndex();
        cache.incrBy(type4UserBitMapIndex, step);
    }

    public static void setMaxUserBitMapIndex(int value) {
        String type4UserBitMapIndex = LicenseCacheMrg.getType4UserMaxBitMapIndex();
        cache.put(type4UserBitMapIndex, (Object)String.valueOf(value));
    }
}

