/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.license.service.cache;

import java.util.Map;
import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class LicenseConfigLocalCache {
    static Log logger = LogFactory.getLog(LicenseConfigLocalCache.class);
    private static final CacheConfigInfo info = new CacheConfigInfo();
    private static final String REGION = "LicenseConfigLocalCache";
    private static final String VERSION_CURR_LICENSECONFIG = "VERSION_CURR_LICENSECONFIG";
    private static final String VERSION_LATESET_LICENSECONFIG = "VERSION_LATEST_LICENSECONFIG";
    private static final String VERSION_CURR_LICENSEAPPCONFIG = "VERSION_CURR_LICENSEAPPCONFIG";
    private static final String VERSION_LATEST_LICENSEAPPCONFIG = "VERSION_LATEST_LICENSEAPPCONFIG";
    private static final String LICENSECONFIG_CURRCTRL = "LICENSECONFIG_CURRCTRL";
    private static final String LICENSECONFIG_LATESTCTRL = "LICENSECONFIG_LATESTCTRL";
    private static final String CURR_APP_CONFIG = "LICENSECONFIG_CURR_APP_CONFIG";
    private static final String LATEST_APP_CONFIG = "LICENSECONFIG_LATEST_APP_CONFIG";

    public static void clear() {
        LicenseConfigLocalCache.getLocalCache().clear();
    }

    private static LocalMemoryCache getLocalCache() {
        return CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache(REGION, RequestContext.get().getAccountId(), info);
    }

    public static String getCurrCtrlVersion() {
        return LicenseConfigLocalCache.getVersion(VERSION_CURR_LICENSECONFIG);
    }

    public static String getLatestCtrlVersion() {
        return LicenseConfigLocalCache.getVersion(VERSION_LATESET_LICENSECONFIG);
    }

    public static String getCurrAppCtrlVersion() {
        return LicenseConfigLocalCache.getVersion(VERSION_CURR_LICENSEAPPCONFIG);
    }

    public static String getLatestAppCtrlVersion() {
        return LicenseConfigLocalCache.getVersion(VERSION_LATEST_LICENSEAPPCONFIG);
    }

    public static String getVersion(String type) {
        return (String)LicenseConfigLocalCache.getLocalCache().get(type + RequestContext.get().getAccountId());
    }

    public static void putCurrCtrlVersion(String version) {
        LicenseConfigLocalCache.putVersion(VERSION_CURR_LICENSECONFIG, version);
    }

    public static void putLatestCtrlVersion(String version) {
        LicenseConfigLocalCache.putVersion(VERSION_LATESET_LICENSECONFIG, version);
    }

    public static void putCurrAppCtrlVersion(String version) {
        LicenseConfigLocalCache.putVersion(VERSION_CURR_LICENSEAPPCONFIG, version);
    }

    public static void putLatestAppCtrlVersion(String version) {
        LicenseConfigLocalCache.putVersion(VERSION_LATEST_LICENSEAPPCONFIG, version);
    }

    private static void putVersion(String type, String version) {
        if (null == version) {
            return;
        }
        LicenseConfigLocalCache.getLocalCache().put(type + RequestContext.get().getAccountId(), (Object)version);
    }

    public static Map<String, String> getCurrCtrlConfig() {
        return (Map)LicenseConfigLocalCache.getLocalCache().get(LICENSECONFIG_CURRCTRL + RequestContext.get().getAccountId());
    }

    public static void putCurrCtrlConfig(Map<String, String> currCtrlConfig) {
        LicenseConfigLocalCache.getLocalCache().put(LICENSECONFIG_CURRCTRL + RequestContext.get().getAccountId(), currCtrlConfig);
    }

    public static Map<String, String> getLatestCtrlConfig() {
        return (Map)LicenseConfigLocalCache.getLocalCache().get(LICENSECONFIG_LATESTCTRL + RequestContext.get().getAccountId());
    }

    public static void putLatestCtrlConfig(Map<String, String> latestCtrlConfig) {
        LicenseConfigLocalCache.getLocalCache().put(LICENSECONFIG_LATESTCTRL + RequestContext.get().getAccountId(), latestCtrlConfig);
    }

    public static Map<String, String> getCurrAPPConfig() {
        return (Map)LicenseConfigLocalCache.getLocalCache().get(CURR_APP_CONFIG + RequestContext.get().getAccountId());
    }

    public static void putCurrAPPConfig(Map<String, String> currAPPConfig) {
        LicenseConfigLocalCache.getLocalCache().put(CURR_APP_CONFIG + RequestContext.get().getAccountId(), currAPPConfig);
    }

    public static Map<String, String> getLatestAPPConfig() {
        return (Map)LicenseConfigLocalCache.getLocalCache().get(LATEST_APP_CONFIG + RequestContext.get().getAccountId());
    }

    public static void putLatestAPPConfig(Map<String, String> latestAPPConfig) {
        LicenseConfigLocalCache.getLocalCache().put(LATEST_APP_CONFIG + RequestContext.get().getAccountId(), latestAPPConfig);
    }

    static {
        info.setTimeout(43200);
        info.setMaxItemSize(10000);
    }
}

