/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.license.service.cache;

import com.alibaba.fastjson.JSONObject;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.license.bean.LicGroupRuntime;
import kd.bos.license.bean.LicenseGroupCtrl;
import kd.bos.license.bean.RangeDate;
import kd.bos.license.bean.gray.GrayFeatureScheme;
import kd.bos.license.config.gray.LicenseGrayConfigHelper;
import kd.bos.license.constant.GrayLicApplyStatusEnum;
import kd.bos.license.gray.UpdateGrayLicense;
import kd.bos.license.pojo.gray.GrayFeatScheApp;
import kd.bos.license.pojo.gray.GrayFeatScheCld;
import kd.bos.license.pojo.gray.GrayFeatScheObj;
import kd.bos.license.pojo.gray.GrayFeature;
import kd.bos.license.service.cache.LicenseCache;
import kd.bos.license.service.cache.LicenseCacheMrg;
import kd.bos.license.service.cache.LicenseGrayCacheMrg;
import kd.bos.license.service.cache.LicenseGrayLocalCache;
import kd.bos.license.util.BloomFilter;
import kd.bos.license.util.LicGroupRuntimeUtil;
import kd.bos.license.util.LicenseGrayFeatureUtil;
import kd.bos.license.util.LicenseUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.license.LicenseServiceHelper;

public class LicenseGrayCache {
    private static Log logger = LogFactory.getLog(LicenseGrayCache.class);
    private static final String GRAY_FEATURE_CONFIG = "T_LIC_GRAYLICGROUPCTRL";
    private static final String GRAY_FEATURE_SCHE = "lic_grayfeaturescheme";

    public static boolean isImportedGrayLic() {
        Boolean importedGrayLic = LicenseGrayLocalCache.isImportedGrayLic();
        if (null == importedGrayLic) {
            try (DLock dlock = DLock.createReentrant((String)"LicenseGrayImported");){
                dlock.lock();
                importedGrayLic = LicenseGrayLocalCache.isImportedGrayLic();
                if (null == importedGrayLic) {
                    importedGrayLic = LicenseGrayCache.reloadImportedGrayLic();
                }
            }
            catch (Exception e) {
                logger.error("LicenseGrayCache.isImportedGrayLic error , return false.", (Throwable)e);
                return false;
            }
        }
        return importedGrayLic;
    }

    public static boolean isGrayLicExpiringSoon() {
        boolean importedGrayLic = LicenseGrayCache.isImportedGrayLic();
        if (!importedGrayLic) {
            return false;
        }
        Boolean isGrayLicExpiringSoon = LicenseGrayLocalCache.isGrayLicExpiringSoon();
        if (null == isGrayLicExpiringSoon) {
            try (DLock dlock = DLock.createReentrant((String)"LicenseGrayExpiringSoon");){
                dlock.lock();
                isGrayLicExpiringSoon = LicenseGrayLocalCache.isGrayLicExpiringSoon();
                if (null == isGrayLicExpiringSoon) {
                    isGrayLicExpiringSoon = LicenseGrayCache.reloadGrayLicExpiringSoon();
                }
            }
            catch (Exception e) {
                logger.error("LicenseGrayCache.isGrayLicExpiringSoon error , return false.", (Throwable)e);
                return false;
            }
        }
        return isGrayLicExpiringSoon;
    }

    public static BloomFilter getNumbersExpired() {
        Map<String, Object> licenseGrayRemind = LicenseGrayLocalCache.getLicenseGrayRemind();
        if (CollectionUtils.isEmpty(licenseGrayRemind)) {
            return null;
        }
        java.util.Date time = (java.util.Date)licenseGrayRemind.get("time");
        if (0 == LicenseUtil.differentDays((java.util.Date)new java.util.Date(), (java.util.Date)time)) {
            return (BloomFilter)licenseGrayRemind.get("filter");
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean addNumbersExpired(String filterKey) {
        if (StringUtils.isBlank((CharSequence)filterKey)) {
            return false;
        }
        try (DLock dlock = DLock.createReentrant((String)"addNumbersExpired");){
            dlock.lock();
            BloomFilter numbersExpired = LicenseGrayCache.getNumbersExpired();
            if (null != numbersExpired && numbersExpired.contains(filterKey)) {
                boolean bl = false;
                return bl;
            }
            BloomFilter numbersFilter = LicenseGrayCache.getGLicNoticeRecord();
            HashMap<String, Object> licenseGrayRemind = new HashMap<String, Object>(16);
            licenseGrayRemind.put("time", new java.util.Date());
            licenseGrayRemind.put("filter", numbersFilter);
            if (numbersFilter.contains(filterKey)) {
                LicenseGrayLocalCache.replaceRemindGrayLic(licenseGrayRemind);
                boolean bl = false;
                return bl;
            }
            numbersFilter.add(filterKey);
            HashMap<String, String> licenseGrayRemindRedis = new HashMap<String, String>(16);
            licenseGrayRemindRedis.put("time", new SimpleDateFormat("yyyy-MM-dd").format(new java.util.Date()));
            licenseGrayRemindRedis.put("filter", numbersFilter.serializeToString());
            String typeGrayLicNoticeRecord = LicenseGrayCacheMrg.getTypeGrayLicNoticeRecord();
            LicenseGrayCacheMrg.clearCache(typeGrayLicNoticeRecord);
            LicenseGrayCacheMrg.putCache(typeGrayLicNoticeRecord, licenseGrayRemindRedis);
            LicenseGrayLocalCache.replaceRemindGrayLic(licenseGrayRemind);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            logger.error("addNumbersExpired error.", (Throwable)e);
            return false;
        }
    }

    public static java.util.Date getExpiringGrayEndDate(Long userId, String bizObjNumber, String appNumber, String cloud) {
        Map<String, GrayFeatScheObj> objNumber2GrayFeatScheObj;
        GrayFeatScheObj grayFeatScheObj;
        logger.debug("getExpiringGrayFeatureEndDate --userId:" + userId + " ,bizObjId:" + bizObjNumber + " ,appNumber:" + appNumber + " ,cloud:" + cloud);
        if (null == userId || StringUtils.isBlank((CharSequence)bizObjNumber) || StringUtils.isBlank((CharSequence)appNumber) || StringUtils.isBlank((CharSequence)cloud)) {
            return null;
        }
        String filterKey = null;
        String grayFeatureSchNum = null;
        Map<String, GrayFeatScheCld> cloudId2GrayFeatScheCld = LicenseGrayCache.getGrayFeatScheCld();
        for (Map.Entry<String, GrayFeatScheCld> entry : cloudId2GrayFeatScheCld.entrySet()) {
            GrayFeatScheCld grayFeatScheCld = entry.getValue();
            if (!grayFeatScheCld.getBlack().booleanValue() || !grayFeatScheCld.equalCloud(cloud)) continue;
            filterKey = appNumber;
            grayFeatureSchNum = grayFeatScheCld.getGraySchemeNumber();
            logger.debug("LicenseGrayCache#getExpiringGrayEndDate grayFeatScheCld:filterKey={},grayFeatScheCld={}", (Object)filterKey, (Object)JSONObject.toJSONString((Object)grayFeatScheCld));
            break;
        }
        Map<String, GrayFeatScheApp> appNumber2GrayFeatScheApp = LicenseGrayCache.getGrayFeatScheApp();
        for (Map.Entry entry : appNumber2GrayFeatScheApp.entrySet()) {
            GrayFeatScheApp grayFeatScheApp = (GrayFeatScheApp)entry.getValue();
            if (filterKey != null) {
                if (!grayFeatScheApp.equalApp(appNumber) || !grayFeatScheApp.getOnSale().booleanValue()) continue;
                logger.debug("LicenseGrayCache#getExpiringGrayEndDate grayFeatScheApp:filterKey={},grayFeatScheApp={}", (Object)filterKey, (Object)JSONObject.toJSONString((Object)grayFeatScheApp));
                return null;
            }
            if (!grayFeatScheApp.getBlack().booleanValue() || !grayFeatScheApp.equalApp(appNumber)) continue;
            if (grayFeatScheApp.getOnSale().booleanValue()) {
                logger.debug("LicenseGrayCache#getExpiringGrayEndDate grayFeatScheApp:filterKey={},grayFeatScheApp={}", (Object)filterKey, (Object)JSONObject.toJSONString((Object)grayFeatScheApp));
                return null;
            }
            filterKey = appNumber;
            grayFeatureSchNum = grayFeatScheApp.getGraySchemeNumber();
            logger.debug("LicenseGrayCache#getExpiringGrayEndDate grayFeatScheApp:filterKey={},grayFeatScheApp={}", (Object)filterKey, (Object)JSONObject.toJSONString((Object)grayFeatScheApp));
            break;
        }
        if (filterKey == null && (grayFeatScheObj = (objNumber2GrayFeatScheObj = LicenseGrayCache.getGrayFeatScheObj()).get(bizObjNumber)) != null && grayFeatScheObj.getBlack().booleanValue()) {
            Set<Long> groupIds = LicenseGrayCache.getLicenseCtrlGroupIdsByAppEntity(appNumber, bizObjNumber);
            if (grayFeatScheObj.getOnSale().booleanValue()) {
                if (CollectionUtils.isEmpty(groupIds)) {
                    logger.debug("LicenseGrayCache#getExpiringGrayEndDate grayFeatScheObj:groupIds is empty,grayFeatScheObj={}", groupIds, (Object)JSONObject.toJSONString((Object)grayFeatScheObj));
                    return null;
                }
                if (LicenseGrayCache.anyGroupEffective(groupIds)) {
                    logger.debug("LicenseGrayCache#getExpiringGrayEndDate grayFeatScheObj:groupIds={},grayFeatScheObj={}", groupIds, (Object)JSONObject.toJSONString((Object)grayFeatScheObj));
                    return null;
                }
            } else {
                logger.debug("LicenseGrayCache#getExpiringGrayEndDate grayFeatScheObj:groupIds={},grayFeatScheObj={}", groupIds, (Object)JSONObject.toJSONString((Object)grayFeatScheObj));
                filterKey = bizObjNumber;
                grayFeatureSchNum = grayFeatScheObj.getGraySchemeNumber();
            }
        }
        if (StringUtils.isBlank(grayFeatureSchNum)) {
            return null;
        }
        java.util.Date expireDate = LicenseGrayCache.getExpireDateByFeatureId(grayFeatureSchNum);
        if (null == expireDate) {
            return null;
        }
        logger.debug("LicenseGrayCache#getExpiringGrayEndDate:grayFeatureSchNum={},expireDate={},filterKey={}", new Object[]{grayFeatureSchNum, expireDate, filterKey});
        filterKey = filterKey + userId;
        int n = LicenseUtil.differentDays((java.util.Date)new java.util.Date(), (java.util.Date)expireDate);
        if (n <= 7 && n >= 0) {
            BloomFilter numbersExpired = LicenseGrayCache.getNumbersExpired();
            if (null != numbersExpired && numbersExpired.contains(filterKey)) {
                return null;
            }
            if (!LicenseGrayCache.addNumbersExpired(filterKey)) {
                return null;
            }
            return expireDate;
        }
        if (n < 0) {
            return expireDate;
        }
        return null;
    }

    private static boolean isAppOnsale(GrayFeatScheApp grayFeatScheApp) {
        return grayFeatScheApp.getOnSale() != false || StringUtils.isNotBlank((CharSequence)LicenseServiceHelper.checkAppInLicenseCtrl((String)grayFeatScheApp.getAppId()));
    }

    private static boolean anyGroupEffective(Set<Long> groupIds) {
        java.util.Date now = new java.util.Date();
        ArrayList<String> groupStrIds = new ArrayList<String>(groupIds.size());
        groupIds.forEach(id -> groupStrIds.add(String.valueOf(id)));
        Map<String, LicGroupRuntime> groupStrId2LicGroupRuntime = LicGroupRuntimeUtil.getGroupRumtimeInfosById(groupStrIds);
        for (Map.Entry<String, LicGroupRuntime> entry : groupStrId2LicGroupRuntime.entrySet()) {
            LicGroupRuntime licGroupRuntime = entry.getValue();
            List rangeDateList = licGroupRuntime.getRangeDateList();
            if (CollectionUtils.isEmpty((Collection)rangeDateList)) continue;
            for (RangeDate rangeDate : rangeDateList) {
                java.util.Date beginDate = rangeDate.getBeginDate();
                java.util.Date endDate = rangeDate.getEndDate();
                if (beginDate == null || endDate == null || !beginDate.before(now) || !endDate.after(now)) continue;
                logger.debug("LicenseGrayCache.anyGroupEffective:licGroupRuntime={}", (Object)licGroupRuntime);
                return true;
            }
        }
        return false;
    }

    public static String getGrayLicenseFeatureCtrl(String bizObjNumber) {
        String featureSchemeNum;
        if (StringUtils.isBlank((CharSequence)bizObjNumber)) {
            return null;
        }
        String type = LicenseGrayCacheMrg.getGrayLicTypeCtrl();
        String dataLoaded = LicenseGrayCacheMrg.getCache(type, "DATA_LOADED");
        if (StringUtils.isBlank((CharSequence)dataLoaded)) {
            try (DLock dlock = DLock.createReentrant((String)"getGrayLicenseFeatureCtrl");){
                dlock.lock();
                dataLoaded = LicenseGrayCacheMrg.getCache(type, "DATA_LOADED");
                if (StringUtils.isBlank((CharSequence)dataLoaded)) {
                    LicenseGrayCache.reloadGrayLicenseCtrlGroup();
                }
            }
            catch (Exception e) {
                logger.error("LicenseGrayCache.getGrayLicenseFeatureCtrl error.", (Throwable)e);
            }
        }
        if (StringUtils.isBlank((CharSequence)(featureSchemeNum = LicenseGrayCacheMrg.getCache(type, bizObjNumber)))) {
            return null;
        }
        return featureSchemeNum;
    }

    public static java.util.Date getExpireDateByFeatureId(String featureSchIdOrNum) {
        if (StringUtils.isBlank((CharSequence)featureSchIdOrNum)) {
            return null;
        }
        GrayFeature hasLicGrayFeatureinfo = LicenseGrayCache.getHasLicGrayFeatureinfo(featureSchIdOrNum);
        if (null == hasLicGrayFeatureinfo) {
            logger.debug("LicenseGrayCacheMrg.getExpireDateByFeatureId:expDateStr is null");
            return null;
        }
        return hasLicGrayFeatureinfo.getEndDate();
    }

    public static java.util.Date getBeginDateByFeatureId(Long featureSchemeId) {
        if (featureSchemeId == null) {
            return null;
        }
        GrayFeature hasLicGrayFeatureinfo = LicenseGrayCache.getHasLicGrayFeatureinfo(String.valueOf(featureSchemeId));
        if (null == hasLicGrayFeatureinfo) {
            return null;
        }
        return hasLicGrayFeatureinfo.getEndDate();
    }

    public static GrayFeature getHasLicGrayFeatureinfo(String featureIdAndNum) {
        if (StringUtils.isEmpty((CharSequence)featureIdAndNum)) {
            return null;
        }
        String type = LicenseGrayCacheMrg.getTypeGrayFeatureInfo();
        String dataLoaded = LicenseGrayCacheMrg.getCache(type, "DATA_LOADED");
        String grayFeatureStr = "";
        if (StringUtils.isBlank((CharSequence)dataLoaded)) {
            try (DLock dlock = DLock.createReentrant((String)"getHasLicGrayFeatureinfo");){
                dlock.lock();
                dataLoaded = LicenseGrayCacheMrg.getCache(type, "DATA_LOADED");
                if (StringUtils.isBlank((CharSequence)dataLoaded)) {
                    LicenseGrayCache.reloadHasLicGrayFeatureInfo();
                    grayFeatureStr = LicenseGrayCacheMrg.getCache(type, featureIdAndNum);
                }
            }
            catch (Exception e) {
                logger.error("LicenseGrayCache.getAllHasLicGrayFeatureinfo error.", (Throwable)e);
            }
        } else {
            grayFeatureStr = LicenseGrayCacheMrg.getCache(type, featureIdAndNum);
        }
        logger.debug("LicenseGrayCacheMrg.getHasLicGrayFeatureinfo : featureIdAndNum={},grayFeatureStr={}", (Object)featureIdAndNum, (Object)grayFeatureStr);
        if (!StringUtils.isEmpty((CharSequence)grayFeatureStr)) {
            return (GrayFeature)SerializationUtils.fromJsonString((String)grayFeatureStr, GrayFeature.class);
        }
        return null;
    }

    public static BloomFilter getGLicNoticeRecord() {
        BloomFilter bloomFilter = new BloomFilter();
        String typeGrayLicNoticeRecord = LicenseGrayCacheMrg.getTypeGrayLicNoticeRecord();
        Map<String, String> filterAndDate = LicenseGrayCacheMrg.getCache(typeGrayLicNoticeRecord);
        if (CollectionUtils.isEmpty(filterAndDate)) {
            return bloomFilter;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            java.util.Date date = sdf.parse(filterAndDate.get("time"));
            if (0 == LicenseUtil.differentDays((java.util.Date)new java.util.Date(), (java.util.Date)date)) {
                return BloomFilter.deserializeFromString((String)filterAndDate.get("filter"));
            }
            LicenseGrayCacheMrg.clearCache(typeGrayLicNoticeRecord);
        }
        catch (Exception e) {
            LicenseGrayCacheMrg.clearCache(typeGrayLicNoticeRecord);
            logger.warn("date parse error.", (Throwable)e);
        }
        return bloomFilter;
    }

    public static Map<String, String> newGrayCacheMap(int size) {
        HashMap<String, String> map = new HashMap<String, String>(size);
        map.put("DATA_LOADED", "DATA_LOADED");
        return map;
    }

    private static void reloadHasLicGrayFeatureInfo() {
        boolean isSuccess = true;
        try {
            UpdateGrayLicense updateGrayLicense = new UpdateGrayLicense();
            Map<String, String> updateResult = updateGrayLicense.downloadAndUpdateGrayLicense(null, true);
            if (CollectionUtils.isEmpty(updateResult) || !Boolean.parseBoolean(updateResult.get("success"))) {
                isSuccess = false;
            }
        }
        catch (Exception e) {
            isSuccess = false;
            logger.error((Throwable)e);
        }
        if (!isSuccess) {
            Map<String, String> grayFeatures = LicenseGrayCache.newGrayCacheMap(16);
            LicenseCacheMrg.putCache(LicenseGrayCacheMrg.getTypeGrayFeatureInfo(), grayFeatures);
        }
    }

    private static void reloadGrayLicenseCtrlGroup() {
        Map allFeatureNumberInfos;
        Throwable throwable;
        TXHandle h;
        Map<String, String> licenseGrayConfig;
        block22: {
            block23: {
                block24: {
                    licenseGrayConfig = LicenseGrayConfigHelper.getLicenseGrayConfig();
                    if (null == licenseGrayConfig) {
                        logger.error("reloadGrayLicenseCtrlGroup : licenseGrayConfig is null.");
                        licenseGrayConfig = new HashMap<String, String>(16);
                    }
                    licenseGrayConfig.put("DATA_LOADED", "DATA_LOADED");
                    String grayLicTypeCtrl = LicenseGrayCacheMrg.getGrayLicTypeCtrl();
                    LicenseGrayCacheMrg.clearCache(grayLicTypeCtrl);
                    LicenseGrayCacheMrg.putCache(grayLicTypeCtrl, licenseGrayConfig);
                    h = TX.requiresNew();
                    throwable = null;
                    licenseGrayConfig.remove("DATA_LOADED");
                    String truncateTableSql = " truncate table T_LIC_GRAYLICGROUPCTRL;";
                    DB.execute((DBRoute)DBRoute.basedata, (String)truncateTableSql);
                    allFeatureNumberInfos = LicenseGrayFeatureUtil.getAllFeatureNumberInfos();
                    if (!CollectionUtils.isEmpty((Map)allFeatureNumberInfos)) break block22;
                    if (h == null) break block23;
                    if (throwable == null) break block24;
                    try {
                        h.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block23;
                }
                h.close();
            }
            return;
        }
        try {
            try {
                MainEntityType dataEntityType;
                ArrayList<Object[]> params = new ArrayList<Object[]>(16);
                for (Map.Entry<String, String> config : licenseGrayConfig.entrySet()) {
                    String objectNum = config.getKey();
                    String featureNum = config.getValue();
                    GrayFeatureScheme grayFeatureScheme = (GrayFeatureScheme)allFeatureNumberInfos.get(featureNum);
                    if (null == grayFeatureScheme) {
                        logger.warn("reloadGrayLicenseCtrlGroup : not find featureNum : " + featureNum);
                        continue;
                    }
                    Object[] param = new Object[]{DB.genLongId((String)GRAY_FEATURE_CONFIG), objectNum, grayFeatureScheme.getId()};
                    params.add(param);
                }
                if (!CollectionUtils.isEmpty(params)) {
                    String insertSql = " insert into T_LIC_GRAYLICGROUPCTRL (fid,fbizobjectid,fschemeid) values (?,?,?);";
                    DB.executeBatch((DBRoute)DBRoute.basedata, (String)insertSql, params);
                }
                if (null != (dataEntityType = EntityMetadataCache.getDataEntityType((String)"lic_grayfeature"))) {
                    BusinessDataServiceHelper.removeCache((DynamicObjectType)dataEntityType);
                }
            }
            catch (Exception e) {
                logger.error("\u4fdd\u5b58\u7070\u5ea6\u8bb8\u53ef\u63a7\u5236\u6e05\u5355\u5230\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
                h.markRollback();
            }
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        catch (Throwable throwable4) {
            throw throwable4;
        }
        finally {
            if (h != null) {
                if (throwable != null) {
                    try {
                        h.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                } else {
                    h.close();
                }
            }
        }
    }

    private static boolean reloadGrayLicExpiringSoon() {
        boolean isExpiringSoon = (Boolean)DB.query((DBRoute)DBRoute.base, (String)"select fenddate endDate from t_lic_grayfeature where fenddate is not null", rs -> {
            while (rs.next()) {
                Date endDate = rs.getDate("endDate");
                int days = LicenseUtil.differentDays((java.util.Date)new java.util.Date(), (java.util.Date)endDate);
                if (days > 7) continue;
                return true;
            }
            return false;
        });
        logger.debug("reloadGrayLicExpiringSoon:" + isExpiringSoon);
        LicenseGrayLocalCache.setGrayLicExpiringSoon(isExpiringSoon);
        return isExpiringSoon;
    }

    private static boolean reloadImportedGrayLic() {
        boolean isImported = (Boolean)DB.query((DBRoute)DBRoute.base, (String)"select fid from t_lic_grayfeature where fstatus = '10' ", rs -> rs.next());
        logger.debug("reloadImportedGrayLic --result: " + isImported);
        LicenseGrayLocalCache.setImportedGrayLic(isImported);
        return isImported;
    }

    public static void clearAllCache() {
        LicenseGrayLocalCache.clearImportedGrayLicLocCache();
        LicenseGrayLocalCache.clearIsGrayLicExpiringSoonLocCache();
        LicenseGrayCacheMrg.clearAllCache();
        LicenseGrayCache.clearAllGrayFeatureInfo();
    }

    public static Map<String, GrayFeature> getGrayFeature() {
        Map<String, GrayFeature> number2GrayFeature = LicenseGrayLocalCache.getGrayFeature();
        if (number2GrayFeature == null) {
            try (DLock dl = DLock.createReentrant((String)"LicenseGrayCache.getGrayFeature");){
                dl.lock();
                number2GrayFeature = LicenseGrayLocalCache.getGrayFeature();
                if (number2GrayFeature == null) {
                    LicenseGrayCache.reloadLicenseGrayFeature();
                    number2GrayFeature = LicenseGrayLocalCache.getGrayFeature();
                }
            }
        }
        if (number2GrayFeature != null) {
            return number2GrayFeature;
        }
        return Collections.emptyMap();
    }

    public static Map<String, GrayFeatScheCld> getGrayFeatScheCld() {
        Map<String, GrayFeatScheCld> cloudId2Info = LicenseGrayLocalCache.getGrayFeatScheCld();
        if (cloudId2Info == null) {
            try (DLock dl = DLock.createReentrant((String)"LicenseGrayCache.getGrayFeature");){
                dl.lock();
                cloudId2Info = LicenseGrayLocalCache.getGrayFeatScheCld();
                if (cloudId2Info == null) {
                    LicenseGrayCache.reloadLicenseGrayFeature();
                    cloudId2Info = LicenseGrayLocalCache.getGrayFeatScheCld();
                }
            }
        }
        if (cloudId2Info != null) {
            return cloudId2Info;
        }
        return Collections.emptyMap();
    }

    public static Map<String, GrayFeatScheApp> getGrayFeatScheApp() {
        Map<String, GrayFeatScheApp> appNumber2GrayFeatScheApp = LicenseGrayLocalCache.getGrayFeatScheApp();
        if (appNumber2GrayFeatScheApp == null) {
            try (DLock dl = DLock.createReentrant((String)"LicenseGrayCache.getGrayFeature");){
                dl.lock();
                appNumber2GrayFeatScheApp = LicenseGrayLocalCache.getGrayFeatScheApp();
                if (appNumber2GrayFeatScheApp == null) {
                    LicenseGrayCache.reloadLicenseGrayFeature();
                    appNumber2GrayFeatScheApp = LicenseGrayLocalCache.getGrayFeatScheApp();
                }
            }
        }
        if (appNumber2GrayFeatScheApp != null) {
            return appNumber2GrayFeatScheApp;
        }
        return Collections.emptyMap();
    }

    public static Map<String, GrayFeatScheObj> getGrayFeatScheObj() {
        Map<String, GrayFeatScheObj> objNumber2GrayFeatScheObj = LicenseGrayLocalCache.getGrayFeatScheObj();
        if (objNumber2GrayFeatScheObj == null) {
            try (DLock dl = DLock.createReentrant((String)"LicenseGrayCache.getGrayFeature");){
                dl.lock();
                objNumber2GrayFeatScheObj = LicenseGrayLocalCache.getGrayFeatScheObj();
                if (objNumber2GrayFeatScheObj == null) {
                    LicenseGrayCache.reloadLicenseGrayFeature();
                    objNumber2GrayFeatScheObj = LicenseGrayLocalCache.getGrayFeatScheObj();
                }
            }
        }
        if (objNumber2GrayFeatScheObj != null) {
            return objNumber2GrayFeatScheObj;
        }
        return Collections.emptyMap();
    }

    public static Map<String, Map<String, String>> getAllGrayCloudLabelInfo() {
        Map<String, Map<String, String>> res = LicenseGrayLocalCache.getAllGrayCloudLabelInfo();
        if (res != null) {
            return res;
        }
        Map<String, GrayFeatScheCld> cloud2GrayScheCld = LicenseGrayCache.getGrayFeatScheCld();
        res = new HashMap<String, Map<String, String>>(cloud2GrayScheCld.size());
        if (CollectionUtils.isEmpty(cloud2GrayScheCld)) {
            LicenseGrayLocalCache.putAllGrayCloudLabelInfo(res);
            return res;
        }
        java.util.Date now = new java.util.Date();
        Map<String, GrayFeature> number2GrayFeature = LicenseGrayLocalCache.getGrayFeature();
        for (Map.Entry<String, GrayFeatScheCld> entry : cloud2GrayScheCld.entrySet()) {
            Boolean onsale;
            String grayFeatureNumber;
            GrayFeature grayFeature;
            String cloud = entry.getKey();
            GrayFeatScheCld grayFeatScheCld = entry.getValue();
            if (!grayFeatScheCld.getBlack().booleanValue() || (grayFeature = number2GrayFeature.get(grayFeatureNumber = grayFeatScheCld.getGraySchemeNumber())) == null || (onsale = grayFeature.getOnsale()).booleanValue()) continue;
            HashMap<String, String> cloudLabelInfo = new HashMap<String, String>(2);
            cloudLabelInfo.put("valid", LicenseGrayCache.isDateValid(grayFeature.getBeginDate(), grayFeature.getEndDate(), now));
            res.put(grayFeatScheCld.getCloudId(), cloudLabelInfo);
        }
        LicenseGrayLocalCache.putAllGrayCloudLabelInfo(res);
        return res;
    }

    public static Map<String, Map<String, String>> getAllGrayAppLabelInfo() {
        Map<String, Map<String, String>> res = LicenseGrayLocalCache.getAllGrayAppLabelInfo();
        if (res != null) {
            return res;
        }
        Map<String, GrayFeatScheApp> appNumber2GrayFeatScheApp = LicenseGrayCache.getGrayFeatScheApp();
        res = new HashMap<String, Map<String, String>>(appNumber2GrayFeatScheApp.size());
        if (CollectionUtils.isEmpty(appNumber2GrayFeatScheApp)) {
            LicenseGrayLocalCache.putAllGrayAppLabelInfo(res);
            return res;
        }
        boolean label = true;
        Map<String, GrayFeature> number2GrayFeature = LicenseGrayLocalCache.getGrayFeature();
        java.util.Date now = new java.util.Date();
        for (Map.Entry<String, GrayFeatScheApp> entry : appNumber2GrayFeatScheApp.entrySet()) {
            String grayFeatureNumber;
            GrayFeature grayFeature;
            String appNumber = entry.getKey();
            GrayFeatScheApp grayFeatScheApp = entry.getValue();
            if (!grayFeatScheApp.getBlack().booleanValue() || (grayFeature = number2GrayFeature.get(grayFeatureNumber = grayFeatScheApp.getGraySchemeNumber())) == null) continue;
            Boolean onsale = grayFeature.getOnsale();
            HashMap<String, String> appLabelInfo = new HashMap<String, String>(2);
            appLabelInfo.put("valid", LicenseGrayCache.isDateValid(grayFeature.getBeginDate(), grayFeature.getEndDate(), now));
            if (!onsale.booleanValue()) {
                res.put(grayFeatScheApp.getAppNum(), appLabelInfo);
                continue;
            }
            Map<String, GrayFeatScheObj> objNumber2GrayFeatScheObj = LicenseGrayCache.getGrayFeatScheObj();
            for (GrayFeatScheObj grayFeatScheObj : objNumber2GrayFeatScheObj.values()) {
                if (!grayFeatureNumber.equals(grayFeatScheObj.getGraySchemeNumber()) || StringUtils.isBlank((CharSequence)grayFeatScheApp.getAppId()) || StringUtils.isBlank((CharSequence)grayFeatScheObj.getAppId()) || !grayFeatScheApp.getAppId().equals(grayFeatScheObj.getAppId()) || !grayFeatScheObj.getOnSale().booleanValue()) continue;
                Set<Long> groupIds = LicenseGrayCache.getLicenseCtrlGroupIdsByAppEntity(grayFeatScheObj.getAppId(), grayFeatScheObj.getEntityNum());
                if (CollectionUtils.isEmpty(groupIds)) {
                    label = false;
                    break;
                }
                Long groupID = groupIds.iterator().next();
                if (!LicenseGrayCache.checkGroupEffective(groupID)) continue;
                label = false;
                break;
            }
            if (!label) continue;
            res.put(grayFeatScheApp.getAppNum(), appLabelInfo);
        }
        LicenseGrayLocalCache.putAllGrayAppLabelInfo(res);
        return res;
    }

    private static Set<Long> getLicenseCtrlGroupIdsByAppEntity(String appId, String objectNumber) {
        if (StringUtils.isBlank((CharSequence)appId)) {
            return Collections.emptySet();
        }
        AppInfo appInfo = AppMetadataCache.getAppInfo((String)appId);
        if (appInfo == null) {
            return Collections.emptySet();
        }
        String appIdParam = appId;
        appId = appInfo.getId();
        LicenseGroupCtrl licenseGroupCtrl = LicenseCache.getLicenseGroupCtrl(appId, objectNumber);
        Set curVersionGroups = licenseGroupCtrl.getCurVersionGroups();
        String sourceBizAppId = BizAppServiceHelp.getAppIdByFormNum((String)objectNumber);
        logger.debug("LicenseGrayCache#getLicenseCtrlGroupIdsByAppEntity:appIdParam={},appId={},sourceBizAppId={},objectNumber={},curVersionGroups={}", new Object[]{appIdParam, appId, sourceBizAppId, objectNumber, curVersionGroups});
        if (appId.equals(sourceBizAppId)) {
            return curVersionGroups;
        }
        return LicenseGrayCache.getLicenseCtrlGroupIdsByAppEntity(sourceBizAppId, objectNumber);
    }

    public static Map<String, Map<String, Map<String, String>>> getAllGrayObjectLabelInfo() {
        Map<String, Map<String, Map<String, String>>> appNumber2ObjectNumber2LabelInfo = LicenseGrayLocalCache.getAllGrayObjectLabelInfo();
        if (appNumber2ObjectNumber2LabelInfo != null) {
            return appNumber2ObjectNumber2LabelInfo;
        }
        Map<String, GrayFeatScheObj> objNumber2GrayFeatScheObj = LicenseGrayCache.getGrayFeatScheObj();
        appNumber2ObjectNumber2LabelInfo = new HashMap<String, Map<String, Map<String, String>>>(objNumber2GrayFeatScheObj.size());
        if (CollectionUtils.isEmpty(objNumber2GrayFeatScheObj)) {
            LicenseGrayLocalCache.putAllGrayObjectLabelInfo(appNumber2ObjectNumber2LabelInfo);
            return appNumber2ObjectNumber2LabelInfo;
        }
        java.util.Date now = new java.util.Date();
        for (Map.Entry<String, GrayFeatScheObj> entry : objNumber2GrayFeatScheObj.entrySet()) {
            GrayFeatScheObj grayFeatScheObj = entry.getValue();
            if (!grayFeatScheObj.getBlack().booleanValue()) continue;
            String appNumber = grayFeatScheObj.getAppNum();
            String entityNumber = grayFeatScheObj.getEntityNum();
            Map entityNumber2LabelInfo = appNumber2ObjectNumber2LabelInfo.computeIfAbsent(appNumber, k -> new HashMap(16));
            HashMap<String, String> info = new HashMap<String, String>(2);
            info.put("valid", LicenseGrayCache.isDateValid(grayFeatScheObj.getBeginDate(), grayFeatScheObj.getEndDate(), now));
            if (grayFeatScheObj.getOnSale().booleanValue()) {
                Long groupID;
                Set<Long> groupIds = LicenseGrayCache.getLicenseCtrlGroupIdsByAppEntity(grayFeatScheObj.getAppId(), entityNumber);
                if (CollectionUtils.isEmpty(groupIds) || LicenseGrayCache.checkGroupEffective(groupID = groupIds.iterator().next())) continue;
                entityNumber2LabelInfo.put(entityNumber, info);
                continue;
            }
            entityNumber2LabelInfo.put(entityNumber, info);
        }
        LicenseGrayLocalCache.putAllGrayObjectLabelInfo(appNumber2ObjectNumber2LabelInfo);
        return appNumber2ObjectNumber2LabelInfo;
    }

    private static void reloadLicenseGrayFeature() {
        HashMap<String, GrayFeatScheCld> cloudId2GrayFeatScheCld = new HashMap<String, GrayFeatScheCld>(16);
        HashMap<String, GrayFeatScheApp> appNumber2GrayFeatScheApp = new HashMap<String, GrayFeatScheApp>(16);
        HashMap<String, GrayFeatScheObj> objNumber2GrayFeatScheObj = new HashMap<String, GrayFeatScheObj>(16);
        HashMap<String, GrayFeature> number2GrayFeature = new HashMap<String, GrayFeature>(16);
        QFilter filter = new QFilter("status", "in", Arrays.asList(GrayLicApplyStatusEnum.Success.toString(), GrayLicApplyStatusEnum.Suspend.toString()));
        DynamicObjectCollection grayFeatureDoc = QueryServiceHelper.query((String)"lic_grayfeature", (String)"grayfeature.number,begindate,enddate", (QFilter[])new QFilter[]{filter});
        if (grayFeatureDoc.size() > 0) {
            DynamicObject[] schemeDoc;
            HashMap<String, DynamicObject> number2GrayFeatureDyn = new HashMap<String, DynamicObject>(grayFeatureDoc.size());
            for (DynamicObject grayFeatureDyn : grayFeatureDoc) {
                number2GrayFeatureDyn.put(grayFeatureDyn.getString("grayfeature.number"), grayFeatureDyn);
            }
            java.util.Date now = new java.util.Date();
            QFilter numberIn = new QFilter("number", "in", number2GrayFeatureDyn.keySet());
            String select = "number,gray_cloud,cloud_name,isblack_cloud,product_cloud,gray_app,app_name,isblack_app,product_app,gray_object,object_name,app,isblack_obj,product_entity,onsale";
            for (DynamicObject grayFeatureSchemeDyn : schemeDoc = BusinessDataServiceHelper.load((String)GRAY_FEATURE_SCHE, (String)select, (QFilter[])new QFilter[]{numberIn})) {
                Object cloudEntry2;
                String featureNumber = grayFeatureSchemeDyn.getString("number");
                DynamicObject grayFeatureDyn = (DynamicObject)number2GrayFeatureDyn.get(featureNumber);
                if (grayFeatureDyn == null) continue;
                Boolean onsale = Boolean.FALSE;
                DynamicObjectCollection grayCloudDoc = grayFeatureSchemeDyn.getDynamicObjectCollection("gray_cloud");
                for (Object cloudEntry2 : grayCloudDoc) {
                    String cloudId = cloudEntry2.getString("cloud_name.id");
                    String cloudNumber = cloudEntry2.getString("cloud_name.number");
                    GrayFeatScheCld grayFeatScheCld = GrayFeatScheCld.build(grayFeatureSchemeDyn, (DynamicObject)cloudEntry2, grayFeatureDyn);
                    cloudId2GrayFeatScheCld.put(String.format("%s_%s", cloudId, featureNumber), grayFeatScheCld);
                    cloudId2GrayFeatScheCld.put(String.format("%s_%s", cloudNumber, featureNumber), grayFeatScheCld);
                }
                DynamicObjectCollection grayAppDoc = grayFeatureSchemeDyn.getDynamicObjectCollection("gray_app");
                cloudEntry2 = grayAppDoc.iterator();
                while (cloudEntry2.hasNext()) {
                    DynamicObject appEntry = (DynamicObject)cloudEntry2.next();
                    String appNumber = appEntry.getString("app_name.number");
                    String appId = appEntry.getString("app_name.id");
                    GrayFeatScheApp grayFeatScheApp = GrayFeatScheApp.build(grayFeatureSchemeDyn, appEntry, grayFeatureDyn);
                    appNumber2GrayFeatScheApp.put(String.format("%s_%s", appNumber, featureNumber), grayFeatScheApp);
                    appNumber2GrayFeatScheApp.put(String.format("%s_%s", appId, featureNumber), grayFeatScheApp);
                }
                DynamicObjectCollection formDoc = grayFeatureSchemeDyn.getDynamicObjectCollection("gray_object");
                for (DynamicObject formEntry : formDoc) {
                    String appNumber = formEntry.getString("app.number");
                    String objectNumber = formEntry.getString("object_name.number");
                    GrayFeatScheObj grayFeatScheObj = GrayFeatScheObj.build(grayFeatureSchemeDyn, formEntry, grayFeatureDyn);
                    objNumber2GrayFeatScheObj.put(objectNumber, grayFeatScheObj);
                    if (!formEntry.getBoolean("onsale")) continue;
                    GrayFeatScheApp grayFeatScheApp = (GrayFeatScheApp)appNumber2GrayFeatScheApp.get(String.format("%s_%s", appNumber, featureNumber));
                    grayFeatScheApp.setOnSale(true);
                    onsale = true;
                }
                number2GrayFeature.put(featureNumber, GrayFeature.build(grayFeatureDyn, grayFeatureSchemeDyn, onsale));
            }
        }
        logger.debug("LicenseGrayCache.reloadLicenseGrayFeature cloudId2GrayFeatScheCld={},appNumber2GrayFeatScheApp={},objNumber2GrayFeatScheObj={},number2GrayFeature={}", new Object[]{JSONObject.toJSONString(cloudId2GrayFeatScheCld), JSONObject.toJSONString(appNumber2GrayFeatScheApp), JSONObject.toJSONString(objNumber2GrayFeatScheObj), JSONObject.toJSONString(number2GrayFeature)});
        LicenseGrayLocalCache.putGrayFeatScheCld(cloudId2GrayFeatScheCld);
        LicenseGrayLocalCache.putGrayFeatScheApp(appNumber2GrayFeatScheApp);
        LicenseGrayLocalCache.putGrayFeatScheObj(objNumber2GrayFeatScheObj);
        LicenseGrayLocalCache.putGrayFeature(number2GrayFeature);
    }

    public static void clearAllGrayFeatureInfo() {
        LicenseGrayLocalCache.removeAllGrayCloudInfo();
        LicenseGrayLocalCache.removeAllGrayAppInfo();
        LicenseGrayLocalCache.removeAllGrayObjectInfo();
        LicenseGrayLocalCache.removeGrayFeature();
    }

    private static String isDateValid(java.util.Date beginDate, java.util.Date endDate, java.util.Date targetDate) {
        return LicenseUtil.validDate((java.util.Date)beginDate, (java.util.Date)endDate, (java.util.Date)targetDate) ? "1" : "0";
    }

    private static boolean checkGroupEffective(Long groupId) {
        java.util.Date beginDate = LicenseCache.getBeginDateByGroup(groupId);
        java.util.Date expireDate = LicenseCache.getExpireDateByGroup(groupId);
        if (beginDate == null || expireDate == null) {
            return false;
        }
        int totalNumber = LicenseServiceHelper.getTotalNumber((Object)groupId);
        java.util.Date now = new java.util.Date();
        return expireDate.after(now) && beginDate.before(now) && totalNumber > 0;
    }

    public static Map<String, GrayFeatScheApp> getGrayFeatureSchemeApp() {
        Map<String, GrayFeatScheApp> objNumber2GrayFeatScheObj = LicenseGrayLocalCache.getGrayFeatureSchemeApp();
        if (objNumber2GrayFeatScheObj == null) {
            try (DLock dl = DLock.createReentrant((String)"LicenseGrayCache.getGrayFeatureScheme");){
                dl.lock();
                objNumber2GrayFeatScheObj = LicenseGrayLocalCache.getGrayFeatureSchemeApp();
                if (objNumber2GrayFeatScheObj == null) {
                    LicenseGrayCache.reloadLicenseGrayFeatureScheme();
                    objNumber2GrayFeatScheObj = LicenseGrayLocalCache.getGrayFeatureSchemeApp();
                }
            }
        }
        if (objNumber2GrayFeatScheObj != null) {
            return objNumber2GrayFeatScheObj;
        }
        return Collections.emptyMap();
    }

    public static Map<String, GrayFeatScheObj> getGrayFeatureSchemeObj() {
        Map<String, GrayFeatScheObj> objNumber2GrayFeatScheObj = LicenseGrayLocalCache.getGrayFeatureSchemeObj();
        if (objNumber2GrayFeatScheObj == null) {
            try (DLock dl = DLock.createReentrant((String)"LicenseGrayCache.getGrayFeatureScheme");){
                dl.lock();
                objNumber2GrayFeatScheObj = LicenseGrayLocalCache.getGrayFeatureSchemeObj();
                if (objNumber2GrayFeatScheObj == null) {
                    LicenseGrayCache.reloadLicenseGrayFeatureScheme();
                    objNumber2GrayFeatScheObj = LicenseGrayLocalCache.getGrayFeatureSchemeObj();
                }
            }
        }
        if (objNumber2GrayFeatScheObj != null) {
            return objNumber2GrayFeatScheObj;
        }
        return Collections.emptyMap();
    }

    private static void reloadLicenseGrayFeatureScheme() {
        DynamicObject[] schemeDoc;
        HashMap<String, GrayFeatScheApp> appNumber2GrayFeatScheApp = new HashMap<String, GrayFeatScheApp>(16);
        HashMap<String, GrayFeatScheObj> objNumber2GrayFeatScheObj = new HashMap<String, GrayFeatScheObj>(16);
        String select = "number,gray_cloud,cloud_name,isblack_cloud,product_cloud,gray_app,app_name,isblack_app,product_app,gray_object,object_name,app,isblack_obj,product_entity,onsale";
        for (DynamicObject grayFeatureSchemeDyn : schemeDoc = BusinessDataServiceHelper.load((String)GRAY_FEATURE_SCHE, (String)select, null)) {
            String featureNumber = grayFeatureSchemeDyn.getString("number");
            DynamicObjectCollection grayAppDoc = grayFeatureSchemeDyn.getDynamicObjectCollection("gray_app");
            for (DynamicObject appEntry : grayAppDoc) {
                String appNumber = appEntry.getString("app_name.number");
                String appId = appEntry.getString("app_name.id");
                String product = appEntry.getString("product_app");
                boolean isblack = appEntry.getBoolean("isblack_app");
                GrayFeatScheApp grayFeatScheApp = new GrayFeatScheApp(featureNumber, appId, appNumber, product, isblack, false);
                appNumber2GrayFeatScheApp.put(String.format("%s_%s", appNumber, featureNumber), grayFeatScheApp);
            }
            DynamicObjectCollection formDoc = grayFeatureSchemeDyn.getDynamicObjectCollection("gray_object");
            for (DynamicObject formEntry : formDoc) {
                String objectId = formEntry.getString("object_name.id");
                String objectNumber = formEntry.getString("object_name.number");
                String appId = formEntry.getString("app.id");
                String appNumber = formEntry.getString("app.number");
                String product = formEntry.getString("product_entity");
                boolean isblack = formEntry.getBoolean("isblack_obj");
                boolean onsale = formEntry.getBoolean("onsale");
                GrayFeatScheObj grayFeatScheObj = new GrayFeatScheObj(featureNumber, objectId, objectNumber, appId, appNumber, product, isblack, onsale);
                objNumber2GrayFeatScheObj.put(objectNumber, grayFeatScheObj);
                if (!formEntry.getBoolean("onsale")) continue;
                GrayFeatScheApp grayFeatScheApp = (GrayFeatScheApp)appNumber2GrayFeatScheApp.get(String.format("%s_%s", appNumber, featureNumber));
                grayFeatScheApp.setOnSale(true);
            }
        }
        LicenseGrayLocalCache.putGrayFeatureSchemeApp(appNumber2GrayFeatScheApp);
        LicenseGrayLocalCache.putGrayFeatureSchemeObj(objNumber2GrayFeatScheObj);
    }
}

