/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.license.service.cache;

import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.entity.cache.CacheKeyUtil;

public class LicenseLocaleCache {
    private LicenseLocaleCache() {
    }

    private static LocalMemoryCache getLocalCache(String acctId) {
        CacheConfigInfo info = new CacheConfigInfo();
        info.setTimeout(1200);
        info.setMaxMemSize(10000);
        return CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache(acctId, LicenseLocaleCache.class.getSimpleName(), info);
    }

    public static void remove(String key) {
        LocalMemoryCache localCache = LicenseLocaleCache.getLocalCache(CacheKeyUtil.getAcctId());
        localCache.remove(new String[]{key.toLowerCase()});
    }

    public static void cache(String key, Object value) {
        LocalMemoryCache localCache = LicenseLocaleCache.getLocalCache(CacheKeyUtil.getAcctId());
        localCache.put(key.toLowerCase(), value);
    }

    public static <T> T getCacheData(String key) {
        LocalMemoryCache localCache = LicenseLocaleCache.getLocalCache(CacheKeyUtil.getAcctId());
        return (T)localCache.get(key.toLowerCase());
    }
}

