/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.license.task;

import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDException;
import kd.bos.license.api.bean.SyncLicenseProgressInfo;
import kd.bos.license.service.cache.LicenseCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.MessageHandler;
import kd.bos.schedule.executor.AbstractTask;

public class SyncLicenseTask
extends AbstractTask {
    private static Log logger = LogFactory.getLog(SyncLicenseTask.class);
    private String UPDATELICENSE = ResManager.loadKDString((String)"\u540c\u6b65\u8bb8\u53ef\u4e2d", (String)"SyncLicenseTask_0", (String)"bos-license-business", (Object[])new Object[0]);

    public MessageHandler getMessageHandle() {
        return super.getMessageHandle();
    }

    public void execute(RequestContext requestContext, Map<String, Object> params) throws KDException {
        this.feedbackProgress(0, this.UPDATELICENSE, null);
        try {
            int progress = 0;
            while (true) {
                String regUserProgress;
                if ((regUserProgress = LicenseCache.getUploadRegUserProgress()) == null) {
                    return;
                }
                SyncLicenseProgressInfo licenseProgress = (SyncLicenseProgressInfo)SerializationUtils.fromJsonString((String)regUserProgress, SyncLicenseProgressInfo.class);
                int hasSyncNum = licenseProgress.getHasSyncNum();
                int syncTotal = licenseProgress.getSyncTotal();
                if (syncTotal != 0 && hasSyncNum != 0) {
                    progress = 80 * hasSyncNum / syncTotal;
                }
                if (licenseProgress.isInSync()) {
                    this.feedbackProgress(progress, this.UPDATELICENSE + progress + "%", null);
                } else if (licenseProgress.isInDownload()) {
                    this.feedbackProgress(80, this.UPDATELICENSE + "80%", null);
                } else {
                    if (!licenseProgress.isInUpdate()) {
                        this.feedbackProgress(100, this.UPDATELICENSE + "100%", null);
                        break;
                    }
                    this.feedbackProgress(90, this.UPDATELICENSE + "90%", null);
                }
                Thread.sleep(1000L);
            }
        }
        catch (Exception e) {
            logger.error("\u540c\u6b65\u8bb8\u53ef\u83b7\u53d6\u8fdb\u5ea6\u5931\u8d25\uff0c\u4e0d\u5f71\u54cd\u5177\u4f53\u6267\u884c", (Throwable)e);
        }
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("success", "true");
        this.feedbackCustomdata(result);
    }

    public boolean isSupportReSchedule() {
        return super.isSupportReSchedule();
    }
}

