/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.license.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.license.LicenseServiceUtil;
import kd.bos.license.api.ILicenseService;
import kd.bos.license.api.LicenseAssignLog;
import kd.bos.license.api.bean.LicenseError;
import kd.bos.license.bean.User;
import kd.bos.license.bean.UserIndex;
import kd.bos.license.engine.LicenseUserRelEngine;
import kd.bos.license.service.cache.LicenseCache;
import kd.bos.license.service.cache.LicenseCacheMrg;
import kd.bos.license.util.LicenseGroupUtil;
import kd.bos.license.util.LicenseUtil;
import kd.bos.license.util.UserIndexUtil;
import kd.bos.license.util.UserUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import org.roaringbitmap.RoaringBitmap;

public class UserLicGroupUtil {
    private static Log logger = LogFactory.getLog(UserLicGroupUtil.class);

    private static List<LicenseError> checkGroupData(Collection<Long> groupIds, Map<Long, String> featureGroups, Map<Long, String> groupIdAndNumber, Map<Long, Integer> checkGroupCountResult, Map<Long, String> licenseGroup, boolean enableLegalPersonAssign, Long legalPersonID) {
        if (CollectionUtils.isEmpty(groupIds) || CollectionUtils.isEmpty(featureGroups) || CollectionUtils.isEmpty(groupIdAndNumber) || CollectionUtils.isEmpty(checkGroupCountResult)) {
            return Collections.emptyList();
        }
        ArrayList<LicenseError> errReason = new ArrayList<LicenseError>(groupIds.size());
        Map<Object, Object> allLegalPersonTotal = new HashMap(1);
        if (enableLegalPersonAssign) {
            allLegalPersonTotal = UserLicGroupUtil.getAllLegalPersonTotal(legalPersonID, groupIds);
        }
        for (Long groupId : groupIds) {
            LicenseError licenseError;
            String groupName;
            if (featureGroups.containsKey(groupId)) {
                groupName = featureGroups.get(groupId);
                licenseError = new LicenseError(LicenseError.LicenseErrorType.GROUP, groupId, groupName, groupIdAndNumber.get(groupId), ResManager.loadKDString((String)"%s\u4e3a\u7279\u6027\u5206\u7ec4\uff0c\u65e0\u9700\u5206\u914d\u3002", (String)"UserLicGroupUtil_10", (String)"bos-license-business", (Object[])new Object[]{groupName}));
                errReason.add(licenseError);
                continue;
            }
            if (!(groupIdAndNumber.containsKey(groupId) || !StringUtils.isBlank((CharSequence)(groupName = licenseGroup.get(groupId))) && enableLegalPersonAssign)) {
                licenseError = new LicenseError(LicenseError.LicenseErrorType.GROUP, groupId, groupName, groupIdAndNumber.get(groupId), ResManager.loadKDString((String)"%s\u8bb8\u53ef\u5206\u7ec4\u4e0d\u5b58\u5728\u3002", (String)"UserLicGroupUtil_11", (String)"bos-license-business", (Object[])new Object[]{null == groupName ? "" : groupName}));
                errReason.add(licenseError);
                continue;
            }
            if (!enableLegalPersonAssign || allLegalPersonTotal.containsKey(groupId)) continue;
            LicenseError licenseError2 = new LicenseError(LicenseError.LicenseErrorType.LEGALPERSON, legalPersonID, null, null, ResManager.loadKDString((String)"\u8be5\u6cd5\u4eba\u516c\u53f8\u4e0d\u5b58\u5728\u6216\u672a\u914d\u7f6e%s\u3002", (String)"UserLicGroupUtil_12", (String)"bos-license-business", (Object[])new Object[]{licenseGroup.get(groupId)}));
            errReason.add(licenseError2);
        }
        return errReason;
    }

    private static Map<Long, Integer> getAllLegalPersonTotal(Long legalPersonID, Collection<Long> groupIds) {
        if (null == legalPersonID || CollectionUtils.isEmpty(groupIds)) {
            return Collections.emptyMap();
        }
        HashMap<Long, Integer> result = new HashMap<Long, Integer>(16);
        SqlBuilder sql = new SqlBuilder();
        sql.append("select fgroupid,fassignednum,fusednum from t_lic_legalassign where forgid = ", new Object[0]);
        sql.append(String.valueOf(legalPersonID), new Object[0]);
        sql.append(" and ", new Object[0]);
        sql.appendIn("fgroupid", groupIds.toArray());
        DB.query((DBRoute)DBRoute.base, (SqlBuilder)sql, resultSet -> {
            while (resultSet.next()) {
                result.put(resultSet.getLong("fgroupid"), resultSet.getInt("fassignednum"));
            }
            return null;
        });
        return result;
    }

    private static List<LicenseError> checkUserData(Collection<Long> userIds) {
        if (CollectionUtils.isEmpty(userIds)) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<LicenseError> errReason = new ArrayList<LicenseError>(userIds.size());
        Map uniqueCharacteristic = LicenseUtil.getUniqueCharacteristic();
        List userListBySet = UserUtil.getUserListBySet(new HashSet<Long>(userIds));
        HashSet<Long> existUerIds = new HashSet<Long>(userIds.size());
        if (!CollectionUtils.isEmpty((Collection)userListBySet)) {
            for (User user : userListBySet) {
                existUerIds.add(user.getUserId());
                if (!user.isEnable()) {
                    errReason.add(new LicenseError(LicenseError.LicenseErrorType.USER, user.getUserId(), user.getName(), user.getNumber(), ResManager.loadKDString((String)"\u4eba\u5458\u72b6\u6001\u4e3a\u201c\u7981\u7528\u201d", (String)"UserLicGroupUtil_1", (String)"bos-license-business", (Object[])new Object[0])));
                    continue;
                }
                if (user.isForbidden()) {
                    errReason.add(new LicenseError(LicenseError.LicenseErrorType.USER, user.getUserId(), user.getName(), user.getNumber(), ResManager.loadKDString((String)"\u7528\u6237\u72b6\u6001\u4e3a\u201c\u7981\u7528\u201d", (String)"UserLicGroupUtil_0", (String)"bos-license-business", (Object[])new Object[0])));
                    continue;
                }
                String fieldNum = (String)uniqueCharacteristic.get("fieldNum");
                if (!StringUtils.isBlank((CharSequence)user.getFieldNumData(fieldNum))) continue;
                errReason.add(new LicenseError(LicenseError.LicenseErrorType.USER, user.getUserId(), user.getName(), user.getNumber(), ResManager.loadKDString((String)"%s\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"UserLicGroupUtil_2", (String)"bos-license-business", (Object[])new Object[]{UserLicGroupUtil.conversionUniqueCharacteristic(fieldNum)})));
            }
        }
        for (Long userId : userIds) {
            if (existUerIds.contains(userId)) continue;
            errReason.add(new LicenseError(LicenseError.LicenseErrorType.USER, userId, null, null, ResManager.loadKDString((String)"\u6b64\u7528\u6237\u4e0d\u5b58\u5728", (String)"UserLicGroupUtil_3", (String)"bos-license-business", (Object[])new Object[0])));
        }
        return errReason;
    }

    private static String conversionUniqueCharacteristic(String field) {
        String defaultValue = ResManager.loadKDString((String)"\u624b\u673a\u53f7", (String)"UserLicGroupUtil_4", (String)"bos-license-business", (Object[])new Object[0]);
        if (StringUtils.isBlank((CharSequence)field)) {
            return defaultValue;
        }
        switch (field) {
            case "email": {
                return ResManager.loadKDString((String)"\u90ae\u7bb1\u53f7", (String)"UserLicGroupUtil_5", (String)"bos-license-business", (Object[])new Object[0]);
            }
            case "username": {
                return ResManager.loadKDString((String)"\u7528\u6237\u540d", (String)"UserLicGroupUtil_6", (String)"bos-license-business", (Object[])new Object[0]);
            }
        }
        return defaultValue;
    }

    public static Map<Long, Integer> getGroupReCount(Set<Long> groupIds, Long legalPersonId) {
        if (CollectionUtils.isEmpty(groupIds)) {
            return Collections.emptyMap();
        }
        boolean enableLegalPersonAssign = LicenseServiceUtil.isEnableLegalPersonAssign();
        if (null == legalPersonId && enableLegalPersonAssign) {
            return Collections.emptyMap();
        }
        Map<Long, Integer> groupTotal = LicenseCache.getGroupTotal();
        HashMap<Long, Integer> result = new HashMap<Long, Integer>(groupIds.size());
        if (LicenseCache.isCtrlAmountIgnoreTime()) {
            result.putAll(UserLicGroupUtil.isCtrlCountGetGroupReCount(new ArrayList<Long>(groupIds), groupTotal));
        } else {
            result.putAll(UserLicGroupUtil.highAvailabilityModeGetGroupReCount(new ArrayList<Long>(groupIds), groupTotal));
        }
        if (enableLegalPersonAssign) {
            Map<Long, Integer> groupReCountMap = UserLicGroupUtil.legalPersonGetGroupReCount(groupTotal, legalPersonId, groupIds.toArray());
            for (Map.Entry groupRecount : result.entrySet()) {
                Integer reCount = (Integer)groupRecount.getValue();
                if (reCount == null) continue;
                groupReCountMap.computeIfPresent((Long)groupRecount.getKey(), (key, value) -> reCount.compareTo((Integer)value) < 0 ? reCount : value);
            }
            return groupReCountMap;
        }
        return result;
    }

    public static Map<Long, Integer> legalPersonGetGroupReCount(Map<Long, Integer> groupTotal, Long legalPersonId, Object[] groupIds) {
        if (null == legalPersonId || null == groupIds || groupIds.length == 0) {
            return Collections.emptyMap();
        }
        HashMap<Long, Integer> assignNumMap = new HashMap<Long, Integer>(16);
        for (Object groupId : groupIds) {
            assignNumMap.put((Long)groupId, 0);
        }
        SqlBuilder sql = new SqlBuilder();
        sql.append("SELECT fgroupid,count(1) from t_lic_userlicensegroup where ", new Object[0]);
        sql.appendIn(" fgroupid", groupIds).append(" and ", new Object[0]);
        sql.appendIn(" fsyncstatus", (Object[])new String[]{"1", "2"});
        sql.append(" and forgid = ", new Object[0]).append(String.valueOf(legalPersonId), new Object[0]).append("group by fgroupid", new Object[0]);
        DB.query((DBRoute)DBRoute.base, (SqlBuilder)sql, rs -> {
            while (rs.next()) {
                assignNumMap.put(rs.getLong(1), rs.getInt(2));
            }
            return null;
        });
        HashMap<Long, Integer> result = new HashMap<Long, Integer>(16);
        sql = new SqlBuilder();
        sql.append("select fgroupid,fassignednum,fusednum from t_lic_legalassign where forgid = ", new Object[0]);
        sql.append(String.valueOf(legalPersonId), new Object[0]);
        sql.append(" and ", new Object[0]);
        sql.appendIn("fgroupid", groupIds);
        DB.query((DBRoute)DBRoute.base, (SqlBuilder)sql, resultSet -> {
            while (resultSet.next()) {
                Long groupId = resultSet.getLong("fgroupid");
                int remainNumber = resultSet.getInt("fassignednum") - (Integer)assignNumMap.get(groupId);
                result.put(groupId, remainNumber >= 0 ? remainNumber : 0);
            }
            return null;
        });
        return result;
    }

    private static Map<Long, Integer> isCtrlCountGetGroupReCount(List<Long> groupIds, Map<Long, Integer> groupTotal) {
        if (CollectionUtils.isEmpty(groupIds) || CollectionUtils.isEmpty(groupTotal)) {
            return Collections.emptyMap();
        }
        Map<Long, RoaringBitmap> currAccountData = LicenseUserRelEngine.getLicRelBitFromCurrAccount(groupIds);
        if (CollectionUtils.isEmpty(currAccountData)) {
            return groupIds.stream().collect(Collectors.toMap(item -> item, v -> 0, (oldValue, newValue) -> oldValue));
        }
        HashMap<Long, Integer> result = new HashMap<Long, Integer>(groupIds.size());
        for (Map.Entry<Long, RoaringBitmap> entry : currAccountData.entrySet()) {
            Long groupId = entry.getKey();
            Integer totalCount = groupTotal.get(groupId);
            if (null == totalCount) continue;
            int reCount = totalCount - entry.getValue().getCardinality();
            result.put(groupId, Math.max(reCount, 0));
        }
        return result;
    }

    public static Map<Long, Integer> highAvailabilityModeGetGroupReCount(List<Long> groupIds, Map<Long, Integer> groupTotal) {
        if (CollectionUtils.isEmpty(groupIds) || CollectionUtils.isEmpty(groupTotal)) {
            return Collections.emptyMap();
        }
        HashMap<Long, Integer> result = new HashMap<Long, Integer>(16);
        Map<Long, Integer> groupAssign = LicenseUserRelEngine.getLicAllocateNumberByGroupIds(groupIds);
        boolean isEmptyBitMap = CollectionUtils.isEmpty(groupAssign);
        for (Long groupId : groupIds) {
            Integer totalCount = groupTotal.get(groupId);
            if (null == totalCount) continue;
            Integer assignCount = null;
            if (!isEmptyBitMap) {
                assignCount = groupAssign.get(groupId);
            }
            if (totalCount <= 0) continue;
            result.put(groupId, totalCount - (null == assignCount ? 0 : assignCount));
        }
        return result;
    }

    public static Map<Long, Integer> publicGetGroupReCount(Map<Long, Integer> groupTotal, Object[] groupIds) {
        if (null == groupIds || CollectionUtils.isEmpty(groupTotal)) {
            return Collections.emptyMap();
        }
        return UserLicGroupUtil.highAvailabilityModeGetGroupReCount(Arrays.stream(groupIds).map(o -> (Long)o).collect(Collectors.toList()), groupTotal);
    }

    public static Map<Long, Integer> privateGetGroupReCount(Map<Long, Integer> groupTotal, Object[] groupIds) {
        if (null == groupTotal || groupTotal.size() == 0 || null == groupIds || groupIds.length == 0) {
            return Collections.EMPTY_MAP;
        }
        return UserLicGroupUtil.highAvailabilityModeGetGroupReCount(Arrays.stream(groupIds).map(o -> (Long)o).collect(Collectors.toList()), groupTotal);
    }

    public static List<LicenseError> addUserGroupsById(Set<Long> userIds, Set<Long> groupIds, Long legalPersonID) {
        return UserLicGroupUtil.addUserGroupsById(userIds, groupIds, legalPersonID, 4, true);
    }

    private static List<LicenseError> checkAddUserGroupsByIdInputParameter(Set<Long> userIds, Set<Long> groupIds, Long legalPersonID, boolean enableLegalPersonAssign) {
        ArrayList<LicenseError> result = new ArrayList<LicenseError>(1);
        if (CollectionUtils.isEmpty(userIds)) {
            LicenseError licenseError = new LicenseError(LicenseError.LicenseErrorType.USER, null, null, null, ResManager.loadKDString((String)"\u7528\u6237\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"UserLicGroupUtil_7", (String)"bos-license-business", (Object[])new Object[0]));
            result.add(licenseError);
        } else if (CollectionUtils.isEmpty(groupIds)) {
            LicenseError licenseError = new LicenseError(LicenseError.LicenseErrorType.GROUP, null, null, null, ResManager.loadKDString((String)"\u8bb8\u53ef\u5206\u7ec4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"UserLicGroupUtil_8", (String)"bos-license-business", (Object[])new Object[0]));
            result.add(licenseError);
        } else if (enableLegalPersonAssign && StringUtils.isBlank((Object)legalPersonID)) {
            LicenseError licenseError = new LicenseError(LicenseError.LicenseErrorType.LEGALPERSON, null, null, null, ResManager.loadKDString((String)"\u6cd5\u4eba\u516c\u53f8\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"UserLicGroupUtil_9", (String)"bos-license-business", (Object[])new Object[0]));
            result.add(licenseError);
        }
        return result;
    }

    public static List<LicenseError> addUserGroupsById(Set<Long> userIds, Set<Long> groupIds, Long legalPersonID, int licenseFrom, boolean isRecordLog) {
        boolean enableLegalPersonAssign = LicenseServiceUtil.isEnableLegalPersonAssign();
        List<LicenseError> inputParameterCheckResult = UserLicGroupUtil.checkAddUserGroupsByIdInputParameter(userIds, groupIds, legalPersonID, enableLegalPersonAssign);
        if (!CollectionUtils.isEmpty(inputParameterCheckResult)) {
            return inputParameterCheckResult;
        }
        ArrayList<LicenseError> result = new ArrayList<LicenseError>(16);
        boolean ctrlAmountIgnoreTime = LicenseCache.isCtrlAmountIgnoreTime();
        Map groupIdAndNumber = LicenseGroupUtil.getAllGroupIdAndNumber();
        Map featureGroups = LicenseGroupUtil.getAllGroupIdAndName((String)"2");
        Map licenseGroup = LicenseGroupUtil.getAllGroupIdAndName(null);
        Long loginUserId = RequestContext.get().getCurrUserId();
        String tenantId = RequestContext.get().getTenantId();
        List accounts = AccountUtils.getAllAccounts((String)tenantId);
        ArrayList<LicenseAssignLog> licenseAssignLogs = new ArrayList<LicenseAssignLog>(16);
        Map<Long, Integer> checkGroupCountResult = UserLicGroupUtil.getGroupReCount(groupIds, legalPersonID);
        List<LicenseError> licenseErrors = UserLicGroupUtil.checkGroupData(groupIds, featureGroups, groupIdAndNumber, checkGroupCountResult, licenseGroup, enableLegalPersonAssign, legalPersonID);
        for (LicenseError licenseError : licenseErrors) {
            result.add(licenseError);
            for (Long userId : userIds) {
                LicenseAssignLog licenseAssignLog = new LicenseAssignLog(TimeServiceHelper.now(), loginUserId, userId, licenseError.getErrorReason(), licenseFrom, 0, licenseError.getId(), false);
                licenseAssignLogs.add(licenseAssignLog);
            }
            groupIds.remove(licenseError.getId());
        }
        if (CollectionUtils.isEmpty(groupIds)) {
            if (isRecordLog && !CollectionUtils.isEmpty(licenseAssignLogs)) {
                ILicenseService service2 = (ILicenseService)ServiceFactory.getService(ILicenseService.class);
                service2.addAssignLogs(licenseAssignLogs);
            }
            return result;
        }
        List<LicenseError> checkUserResult = UserLicGroupUtil.checkUserData(userIds);
        if (!checkUserResult.isEmpty()) {
            result.addAll(checkUserResult);
            for (LicenseError userReason : checkUserResult) {
                for (Long groupId : groupIds) {
                    LicenseAssignLog licenseAssignLog = new LicenseAssignLog(TimeServiceHelper.now(), loginUserId, userReason.getId(), userReason.getErrorReason(), licenseFrom, 0, groupId, false);
                    licenseAssignLogs.add(licenseAssignLog);
                }
                userIds.remove(userReason.getId());
            }
        }
        if (userIds.isEmpty()) {
            if (isRecordLog && !CollectionUtils.isEmpty(licenseAssignLogs)) {
                ILicenseService iLicenseService = (ILicenseService)ServiceFactory.getService(ILicenseService.class);
                iLicenseService.addAssignLogs(licenseAssignLogs);
            }
            return result;
        }
        if (enableLegalPersonAssign) {
            Map<Long, Integer> map = UserLicGroupUtil.legalPersonGetGroupReCount(LicenseCache.getGroupTotal(), legalPersonID, groupIds.toArray());
            HashSet<Long> removeGroupIds = new HashSet<Long>(16);
            for (Long groupId : groupIds) {
                Integer reCount = map.get(groupId);
                if (reCount == null || userIds.size() <= reCount) continue;
                String groupName = (String)licenseGroup.get(groupId);
                LicenseError licenseError = new LicenseError(LicenseError.LicenseErrorType.GROUP, groupId, groupName, (String)groupIdAndNumber.get(groupId), ResManager.loadKDString((String)"\u5df2\u7ecf\u8d85\u8fc7%s\u7684\u6700\u5927\u8bb8\u53ef\u6570\u91cf\u3002", (String)"UserLicGroupUtil_17", (String)"bos-license-business", (Object[])new Object[]{groupName}));
                result.add(licenseError);
                removeGroupIds.add(groupId);
                for (Long userId : userIds) {
                    LicenseAssignLog licenseAssignLog = new LicenseAssignLog(TimeServiceHelper.now(), loginUserId, userId, licenseError.getErrorReason(), licenseFrom, 0, groupId, false);
                    licenseAssignLogs.add(licenseAssignLog);
                }
            }
            if (!removeGroupIds.isEmpty()) {
                groupIds.removeAll(removeGroupIds);
            }
        }
        result.addAll(UserLicGroupUtil.addUserGroup(userIds, groupIds, legalPersonID, licenseFrom, isRecordLog, licenseAssignLogs, licenseGroup, groupIdAndNumber));
        if (isRecordLog && !CollectionUtils.isEmpty(licenseAssignLogs)) {
            ILicenseService iLicenseService = (ILicenseService)ServiceFactory.getService(ILicenseService.class);
            iLicenseService.addAssignLogs(licenseAssignLogs);
        }
        return result;
    }

    private static List<LicenseError> addUserGroup(Set<Long> userIds, Set<Long> groupIds, Long legalPersonID, int licenseFrom, boolean isRecordLog, List<LicenseAssignLog> licenseAssignLogs, Map<Long, String> licenseGroup, Map<Long, String> allGroupIdAndNumber) {
        if (CollectionUtils.isEmpty(groupIds) || CollectionUtils.isEmpty(userIds) || null == licenseAssignLogs || LicenseServiceUtil.isEnableLegalPersonAssign() && null == legalPersonID || CollectionUtils.isEmpty(licenseGroup)) {
            return Collections.emptyList();
        }
        ArrayList<LicenseError> result = new ArrayList<LicenseError>(16);
        HashMap<Long, List> successMap = new HashMap<Long, List>(userIds.size());
        HashMap<Long, Set> groupUser = new HashMap<Long, Set>();
        HashMap<Long, Set> userGroup = new HashMap<Long, Set>();
        for (Long groupId : groupIds) {
            for (Long userId : userIds) {
                userGroup.computeIfAbsent(userId, k -> new HashSet()).add(groupId);
                groupUser.computeIfAbsent(groupId, k -> new HashSet()).add(userId);
            }
        }
        HashMap<Long, Set> userGroupExist = new HashMap<Long, Set>();
        HashMap<Long, Set> groupUserExist = new HashMap<Long, Set>();
        HashMap<Long, List> groupAssignLogs = new HashMap<Long, List>(groupIds.size());
        Long loginUserId = RequestContext.get().getCurrUserId();
        boolean isCtrlAmount = LicenseCache.isCtrlAmountIgnoreTime();
        try (TXHandle h = TX.requiresNew();){
            SqlBuilder selectAllUserHasLicense = new SqlBuilder();
            selectAllUserHasLicense.append("select fid id,fuserid userId,fgroupid groupId,forgid orgId,fsyncstatus syncStatus,fstatus status,fassigntime assignTime,flicenseSource licenseSource from t_lic_userlicensegroup where ", new Object[0]);
            selectAllUserHasLicense.appendIn("fuserid", userIds.toArray());
            try (DLock lock = DLock.createReentrant((String)"UserLicenseGroups");
                 DataSet assignInfo = DB.queryDataSet((String)"selectAllUserInLicense", (DBRoute)DBRoute.base, (SqlBuilder)selectAllUserHasLicense);){
                Long groupId;
                lock.lock();
                HashMap<Long, List> dynamicObjectsMap = new HashMap<Long, List>(16);
                HashMap<Long, List> changedAssignData = new HashMap<Long, List>(16);
                HashSet<Long> successIds = new HashSet<Long>(16);
                HashMap<Long, Set> repeatAssignData = new HashMap<Long, Set>(16);
                HashSet<Long> repeatAssignUserId = new HashSet<Long>(16);
                MainEntityType type = EntityMetadataCache.getDataEntityType((String)"lic_userlicensegroup");
                if (null != assignInfo) {
                    while (assignInfo.hasNext()) {
                        Row userGroupInfo = assignInfo.next();
                        if (null == userGroupInfo) continue;
                        Long userId = userGroupInfo.getLong("userId");
                        Long l = userGroupInfo.getLong("groupId");
                        Set groupUserIds = (Set)groupUser.get(l);
                        if (CollectionUtils.isEmpty((Collection)groupUserIds) || !groupUserIds.remove(userId)) continue;
                        Set groupIdsSet = (Set)userGroup.get(userId);
                        if (!CollectionUtils.isEmpty((Collection)groupIdsSet)) {
                            groupIdsSet.remove(l);
                            if (CollectionUtils.isEmpty((Collection)groupIdsSet)) {
                                userGroup.remove(userId);
                            }
                        }
                        if (!"1".equals(userGroupInfo.getString("syncStatus"))) {
                            Object[] changedAssign = new Object[]{"1", "1", licenseFrom, TimeServiceHelper.now(), userGroupInfo.getLong("id")};
                            changedAssignData.computeIfAbsent(l, k -> new ArrayList()).add(changedAssign);
                            successIds.add(userId);
                            userGroupExist.computeIfAbsent(userId, k -> new HashSet()).add(l);
                            groupUserExist.computeIfAbsent(l, k -> new HashSet()).add(userId);
                            LicenseAssignLog licenseAssignLog = new LicenseAssignLog(TimeServiceHelper.now(), loginUserId, userId, "", licenseFrom, 0, l, true);
                            groupAssignLogs.computeIfAbsent(l, k -> new LinkedList()).add(licenseAssignLog);
                            continue;
                        }
                        repeatAssignData.computeIfAbsent(l, k -> new HashSet()).add(userId);
                        repeatAssignUserId.add(userId);
                        LicenseAssignLog licenseAssignLog = new LicenseAssignLog(TimeServiceHelper.now(), loginUserId, userId, ResManager.loadKDString((String)"\u8be5\u7528\u6237\u5df2\u7ecf\u5b58\u5728", (String)"UserLicGroupUtil_16", (String)"bos-license-business", (Object[])new Object[0]), licenseFrom, 0, l, false);
                        groupAssignLogs.computeIfAbsent(l, k -> new LinkedList()).add(licenseAssignLog);
                    }
                }
                if (!CollectionUtils.isEmpty(repeatAssignUserId)) {
                    Map<Long, String[]> userInfos = UserLicGroupUtil.getUserInfos(repeatAssignUserId);
                    for (Map.Entry entry : repeatAssignData.entrySet()) {
                        Long groupId3 = (Long)entry.getKey();
                        Set repeatUserIds = (Set)entry.getValue();
                        for (Object userId : repeatUserIds) {
                            String[] userNameAndNumber = userInfos.get(userId);
                            if (null == userNameAndNumber || userNameAndNumber.length != 2) continue;
                            LicenseError licenseError = new LicenseError(LicenseError.LicenseErrorType.USER, (Long)userId, userNameAndNumber[0], userNameAndNumber[1], ResManager.loadKDString((String)"%s\u4e2d\u5df2\u7ecf\u5b58\u5728\u8be5\u7528\u6237\u3002", (String)"UserLicGroupUtil_15", (String)"bos-license-business", (Object[])new Object[]{licenseGroup.get(groupId3)}));
                            result.add(licenseError);
                        }
                    }
                }
                long rootOrgId = OrgUnitServiceHelper.getRootOrgId();
                for (Map.Entry groupIdAndUserIds : groupUser.entrySet()) {
                    Object userId;
                    Long groupId4 = (Long)groupIdAndUserIds.getKey();
                    Iterator users = (Set)groupIdAndUserIds.getValue();
                    userId = users.iterator();
                    while (userId.hasNext()) {
                        Long user = (Long)userId.next();
                        DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)type);
                        dynamicObject.set("group", (Object)groupId4);
                        dynamicObject.set("user", (Object)user);
                        if (null != legalPersonID && 0L != legalPersonID) {
                            dynamicObject.set("org", (Object)legalPersonID);
                        } else {
                            dynamicObject.set("org", (Object)rootOrgId);
                        }
                        dynamicObject.set("syncstatus", (Object)"1");
                        dynamicObject.set("status", (Object)"1");
                        dynamicObject.set("licensesource", (Object)licenseFrom);
                        dynamicObject.set("assigntime", (Object)TimeServiceHelper.now());
                        successMap.computeIfAbsent(groupId4, k -> new ArrayList()).add(user);
                        dynamicObjectsMap.computeIfAbsent(groupId4, k -> new ArrayList()).add(dynamicObject);
                        successIds.add(user);
                        LicenseAssignLog licenseAssignLog = new LicenseAssignLog(TimeServiceHelper.now(), loginUserId, user, "", licenseFrom, 0, groupId4, true);
                        groupAssignLogs.computeIfAbsent(groupId4, k -> new LinkedList()).add(licenseAssignLog);
                    }
                }
                Map<Long, List<Integer>> map = LicenseUserRelEngine.getLicAllocateUserByGroupIds(new ArrayList<Long>(groupIds));
                Map<Long, Integer> userBitMapIndex = LicenseUserRelEngine.getUserBitMapIndex(successIds);
                HashMap<Long, List<Integer>> licUserRelMap = new HashMap<Long, List<Integer>>(successMap.size());
                for (Map.Entry entry : successMap.entrySet()) {
                    groupId = (Long)entry.getKey();
                    for (Long userId : (List)entry.getValue()) {
                        licUserRelMap.computeIfAbsent(groupId, k -> new ArrayList()).add(userBitMapIndex.get(userId));
                    }
                }
                for (Map.Entry entry : groupUserExist.entrySet()) {
                    groupId = (Long)entry.getKey();
                    for (Long userId : (Set)entry.getValue()) {
                        licUserRelMap.computeIfAbsent(groupId, k -> new ArrayList()).add(userBitMapIndex.get(userId));
                    }
                }
                Iterator it = licUserRelMap.entrySet().iterator();
                while (it.hasNext()) {
                    int totalNumber;
                    Map.Entry licGroupUserIndex = it.next();
                    HashSet<Integer> indexs = new HashSet<Integer>(16);
                    Iterator groupId5 = (Long)licGroupUserIndex.getKey();
                    List userIndexs = (List)licGroupUserIndex.getValue();
                    indexs.addAll(userIndexs);
                    List<Integer> indexsFromCache = map.get(groupId5);
                    if (null != indexsFromCache) {
                        indexs.addAll(indexsFromCache);
                    }
                    if ((totalNumber = LicenseServiceHelper.getTotalNumber(groupId5)) >= indexs.size()) continue;
                    it.remove();
                    changedAssignData.remove(groupId5);
                    dynamicObjectsMap.remove(groupId5);
                    String groupName = licenseGroup.get(groupId5);
                    LicenseError licenseError = new LicenseError(LicenseError.LicenseErrorType.GROUP, groupId5, groupName, allGroupIdAndNumber.get(groupId5), totalNumber == 0 ? ResManager.loadKDString((String)"\u672a\u8d2d\u4e70%s\u3002", (String)"UserLicGroupUtil_21", (String)"bos-license-business", (Object[])new Object[]{groupName}) : ResManager.loadKDString((String)"\u5df2\u7ecf\u8d85\u8fc7%s\u7684\u6700\u5927\u8bb8\u53ef\u6570\u91cf\u3002", (String)"UserLicGroupUtil_17", (String)"bos-license-business", (Object[])new Object[]{groupName}));
                    result.add(licenseError);
                    List assignLogs = (List)groupAssignLogs.remove(groupId5);
                    if (assignLogs == null || assignLogs.isEmpty()) continue;
                    for (LicenseAssignLog assignLog : assignLogs) {
                        assignLog.setStatus(false);
                        assignLog.setOpDescription(totalNumber == 0 ? ResManager.loadKDString((String)"\u672a\u8d2d\u4e70%s\u3002", (String)"UserLicGroupUtil_21", (String)"bos-license-business", (Object[])new Object[]{groupName}) : ResManager.loadKDString((String)"\u5df2\u7ecf\u8d85\u8fc7%s\u7684\u6700\u5927\u8bb8\u53ef\u6570\u91cf\u3002", (String)"UserLicGroupUtil_17", (String)"bos-license-business", (Object[])new Object[]{groupName}));
                    }
                    licenseAssignLogs.addAll(assignLogs);
                }
                LicenseUserRelEngine.addLicUserGroup(licUserRelMap);
                boolean isChanged = false;
                if (!CollectionUtils.isEmpty(changedAssignData)) {
                    ArrayList allQueryDys = new ArrayList(16);
                    for (List parmList : changedAssignData.values()) {
                        allQueryDys.addAll(parmList);
                    }
                    DB.executeBatch((DBRoute)DBRoute.base, (String)"update t_lic_userlicensegroup set fsyncstatus = ?,fstatus = ?,flicensesource = ?,fassigntime = ? where fid = ?", allQueryDys);
                    isChanged = true;
                }
                if (!CollectionUtils.isEmpty(dynamicObjectsMap)) {
                    ArrayList allInsertDys = new ArrayList(16);
                    for (List row : dynamicObjectsMap.values()) {
                        allInsertDys.addAll(row);
                    }
                    int ormMaxObjectsCount = LicenseUtil.getOrmMaxObjectsCount();
                    for (int i = 0; i < allInsertDys.size(); i += ormMaxObjectsCount) {
                        int end = Math.min(allInsertDys.size(), i + ormMaxObjectsCount);
                        Object[] subInsertDys = allInsertDys.subList(i, end).toArray(new Object[0]);
                        SaveServiceHelper.save((IDataEntityType)type, (Object[])subInsertDys);
                    }
                    isChanged = true;
                }
                if (!CollectionUtils.isEmpty(groupAssignLogs) && isRecordLog) {
                    for (Map.Entry data : groupAssignLogs.entrySet()) {
                        licenseAssignLogs.addAll((Collection)data.getValue());
                    }
                }
                if (LicenseServiceUtil.isEnableLegalPersonAssign()) {
                    UserLicGroupUtil.legalPersonCalculateUsedCount(groupIds.toArray(), legalPersonID);
                }
                if (isCtrlAmount && isChanged) {
                    UserLicGroupUtil.publicCalculateUsedCount(groupIds.toArray());
                }
            }
            catch (Exception e) {
                logger.error("kd.bos.license.util.UserLicGroupUtil.addUserGroup occur exception.", (Throwable)e);
                h.markRollback();
                throw new KDBizException(ResManager.loadKDString((String)"\u6dfb\u52a0\u8bb8\u53ef\u51fa\u9519", (String)"UserLicGroupUtil_20", (String)"bos-license-business", (Object[])new Object[0]));
            }
        }
        return result;
    }

    private static Map<Long, String[]> getUserInfos(@NotNull Set<Long> userIds) {
        return (Map)DB.query((DBRoute)DBRoute.base, (SqlBuilder)new SqlBuilder().append("select su.fid id,suu.fusername userName,su.fnumber number from t_sec_user su join t_sec_user_u suu on su.fid = suu.fid where ", new Object[0]).appendIn("su.fid", userIds.toArray()), rs -> {
            HashMap<Long, String[]> userInfos = new HashMap<Long, String[]>(16);
            while (rs.next()) {
                long userId = rs.getLong("id");
                String[] userInfo = new String[]{rs.getString("userName"), rs.getString("number")};
                userInfos.put(userId, userInfo);
            }
            return userInfos;
        });
    }

    private static Runnable addUserLicGroupDif(Set<Long> userIds) {
        return () -> {
            try {
                LicenseServiceHelper.addUsers2LicGroupDif((Set)userIds);
            }
            catch (Exception e) {
                logger.error("\u5f02\u6b65\u8bb0\u5f55\u7528\u6237\u8bb8\u53ef\u5206\u7ec4\u589e\u91cf\u8868\u5f02\u5e38", (Throwable)e);
            }
        };
    }

    private static void deleteUserLicenseGroupCache(Map<Long, Set<Long>> userGroupId) {
        UserLicGroupUtil.changeUserLicenseGroupCache(userGroupId, UserGroupCacheType.DELETE);
    }

    private static void addUserLicenseGroupCache(Map<Long, Set<Long>> userGroupId) {
        UserLicGroupUtil.changeUserLicenseGroupCache(userGroupId, UserGroupCacheType.ADD);
    }

    private static void changeUserLicenseGroupCache(Map<Long, Set<Long>> userGroupId, UserGroupCacheType type) {
        if (CollectionUtils.isEmpty(userGroupId) || null == type) {
            return;
        }
        HashMap<String, String> userGroupCacheMap = new HashMap<String, String>(userGroupId.size());
        String[] keys = (String[])userGroupId.keySet().stream().map(String::valueOf).toArray(String[]::new);
        String userLicGroupType = LicenseCacheMrg.getType4UserLicenseGroups();
        List<String> userLicenseGroup = LicenseCacheMrg.getCache(userLicGroupType, keys);
        for (int i = 0; i < keys.length; ++i) {
            String userIdStr = keys[i];
            Long userId = Long.valueOf(userIdStr);
            String userGroupStr = userLicenseGroup.get(i);
            Set<Object> groupStrSet = null;
            Set<Long> groupLs = userGroupId.get(userId);
            groupStrSet = CollectionUtils.isEmpty(groupLs) ? new HashSet(16) : groupLs.stream().map(String::valueOf).collect(Collectors.toSet());
            if (StringUtils.isNotBlank((CharSequence)userGroupStr)) {
                Set cacheGroups = (Set)SerializationUtils.fromJsonString((String)userGroupStr, Set.class);
                if (type == UserGroupCacheType.ADD) {
                    groupStrSet.addAll(cacheGroups);
                } else if (type == UserGroupCacheType.DELETE) {
                    cacheGroups.removeAll(groupStrSet);
                    groupStrSet = cacheGroups;
                }
            }
            userGroupCacheMap.put(userIdStr, SerializationUtils.toJsonString(groupStrSet));
        }
        if (!CollectionUtils.isEmpty(userGroupCacheMap)) {
            LicenseCacheMrg.putCache(userLicGroupType, userGroupCacheMap);
        }
    }

    private static void publicCalculateUsedCount(Object[] groupIds) {
        if (null == groupIds || groupIds.length == 0) {
            return;
        }
        HashMap<Long, Integer> assignNumMap = new HashMap<Long, Integer>(16);
        for (Object groupId : groupIds) {
            assignNumMap.put((Long)groupId, 0);
        }
        SqlBuilder sql = new SqlBuilder();
        sql.append("SELECT fgroupid,count(1) from t_lic_userlicensegroup where ", new Object[0]);
        sql.appendIn(" fgroupid", groupIds);
        sql.append(" and fsyncstatus = '1' group by fgroupid", new Object[0]);
        DB.query((DBRoute)DBRoute.base, (SqlBuilder)sql, rs -> {
            while (rs.next()) {
                assignNumMap.put(rs.getLong(1), rs.getInt(2));
            }
            return null;
        });
        String updateSql = "UPDATE T_LIC_LICENSEDETAIL set FASSIGNEDCOUNT = ? ,FREMAINCOUNT = FTOTALCOUNT - ? where fgroupid = ?";
        ArrayList<Object[]> sqlPram = new ArrayList<Object[]>(assignNumMap.size());
        for (Map.Entry groupIdAndAssignNum : assignNumMap.entrySet()) {
            Integer assignNum = (Integer)groupIdAndAssignNum.getValue();
            Object[] param = new Object[]{assignNum, assignNum, groupIdAndAssignNum.getKey()};
            sqlPram.add(param);
        }
        DB.executeBatch((DBRoute)DBRoute.base, (String)updateSql, sqlPram);
    }

    public static void legalPersonCalculateUsedCount(Object[] groupIds, Long legalPersonId) {
        if (null == groupIds || groupIds.length == 0 || null == legalPersonId) {
            return;
        }
        HashMap<Long, Integer> assignNumMap = new HashMap<Long, Integer>(16);
        for (Object groupId : groupIds) {
            assignNumMap.put((Long)groupId, 0);
        }
        SqlBuilder sql = new SqlBuilder();
        sql.append("SELECT fgroupid,count(1) from t_lic_userlicensegroup where ", new Object[0]);
        sql.appendIn(" fgroupid", groupIds);
        sql.append(" and fsyncstatus = '1' and forgid = ", new Object[0]).append(String.valueOf(legalPersonId), new Object[0]).append("group by fgroupid", new Object[0]);
        DB.query((DBRoute)DBRoute.base, (SqlBuilder)sql, rs -> {
            while (rs.next()) {
                assignNumMap.put(rs.getLong(1), rs.getInt(2));
            }
            return null;
        });
        String updateSql = "UPDATE T_LIC_LEGALASSIGN set FUSEDNUM = ?  where fgroupid = ? and FORGID = ?";
        ArrayList<Object[]> sqlPram = new ArrayList<Object[]>(assignNumMap.size());
        for (Map.Entry groupIdAndAssignNum : assignNumMap.entrySet()) {
            Integer assignNum = (Integer)groupIdAndAssignNum.getValue();
            Object[] param = new Object[]{assignNum, groupIdAndAssignNum.getKey(), legalPersonId};
            sqlPram.add(param);
        }
        DB.executeBatch((DBRoute)DBRoute.base, (String)updateSql, sqlPram);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<LicenseError> deleteUserGroupByGroupId(Set<Long> userIds, Set<Long> groupIds, Long legalPersonId) {
        DynamicObject[] result = new ArrayList(16);
        if (CollectionUtils.isEmpty(userIds)) {
            LicenseError licenseError = new LicenseError(LicenseError.LicenseErrorType.USER, null, null, null, ResManager.loadKDString((String)"\u7528\u6237\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"UserLicGroupUtil_7", (String)"bos-license-business", (Object[])new Object[0]));
            result.add(licenseError);
            return result;
        }
        if (CollectionUtils.isEmpty(groupIds)) {
            LicenseError licenseError = new LicenseError(LicenseError.LicenseErrorType.GROUP, null, null, null, ResManager.loadKDString((String)"\u8bb8\u53ef\u5206\u7ec4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"UserLicGroupUtil_8", (String)"bos-license-business", (Object[])new Object[0]));
            result.add((LicenseError)licenseError);
            return result;
        }
        Map licenseGroup = LicenseGroupUtil.getAllGroupIdAndName(null);
        boolean enableLegalPersonAssign = LicenseServiceUtil.isEnableLegalPersonAssign();
        if (enableLegalPersonAssign && null == legalPersonId) {
            LicenseError licenseError = new LicenseError(LicenseError.LicenseErrorType.LEGALPERSON, null, null, null, ResManager.loadKDString((String)"\u6cd5\u4eba\u516c\u53f8\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"UserLicGroupUtil_9", (String)"bos-license-business", (Object[])new Object[0]));
            result.add((LicenseError)licenseError);
            return result;
        }
        long loginUserId = RequestContext.get().getCurrUserId();
        ArrayList<LicenseAssignLog> licenseAssignLogs = new ArrayList<LicenseAssignLog>(userIds.size() + 1);
        Throwable throwable = null;
        try (TXHandle h = TX.requiresNew();){
            HashSet<Long> successGroup;
            HashMap<Long, Set> successData;
            HashSet<Object> successId;
            boolean isCtrlAmount;
            HashMap<Long, Set<Long>> groupAndUserId;
            Throwable throwable2;
            DLock dlock;
            block52: {
                DynamicObject[] fail;
                block53: {
                    DynamicObject[] load;
                    dlock = DLock.createReentrant((String)"UserLicenseGroups");
                    throwable2 = null;
                    dlock.lock();
                    HashMap<Long, Set> allDeleteData = new HashMap<Long, Set>();
                    groupAndUserId = new HashMap<Long, Set<Long>>();
                    for (Long groupId : groupIds) {
                        for (Long userId : userIds) {
                            groupAndUserId.computeIfAbsent(groupId, k -> new HashSet()).add(userId);
                            allDeleteData.computeIfAbsent(userId, k -> new HashSet()).add(groupId);
                        }
                    }
                    isCtrlAmount = LicenseCache.isCtrlAmount();
                    successId = new HashSet<Object>(16);
                    successData = new HashMap<Long, Set>(16);
                    HashMap<Long, String[]> failUserInfo = new HashMap<Long, String[]>(16);
                    successGroup = new HashSet<Long>();
                    QFilter[] qFilters = new QFilter[3];
                    qFilters[0] = new QFilter("group", "in", groupIds);
                    qFilters[1] = new QFilter("user", "in", userIds);
                    if (enableLegalPersonAssign) {
                        qFilters[2] = new QFilter("org", "=", (Object)legalPersonId);
                    }
                    if (null != (load = BusinessDataServiceHelper.load((String)"lic_userlicensegroup", (String)"group,user", (QFilter[])qFilters)) && load.length > 0) {
                        for (DynamicObject userGroup : load) {
                            successId.add(userGroup.getPkValue());
                            long groupId = userGroup.getLong("group.id");
                            long userId = userGroup.getLong("user.id");
                            successGroup.add(groupId);
                            successData.computeIfAbsent(userId, k -> new HashSet()).add(groupId);
                            Set groups = (Set)allDeleteData.get(userId);
                            if (!CollectionUtils.isEmpty((Collection)groups)) {
                                groups.remove(groupId);
                                if (CollectionUtils.isEmpty((Collection)groups)) {
                                    allDeleteData.remove(userId);
                                }
                            }
                            LicenseAssignLog licenseAssignLog = new LicenseAssignLog(TimeServiceHelper.now(), Long.valueOf(loginUserId), Long.valueOf(userId), "", 2, 1, Long.valueOf(groupId), true);
                            licenseAssignLogs.add(licenseAssignLog);
                        }
                    }
                    if (!CollectionUtils.isEmpty(allDeleteData)) {
                        fail = BusinessDataServiceHelper.load((String)"bos_user", (String)"id,number,name", (QFilter[])new QFilter("id", "in", userIds).toArray());
                        if (null != fail && fail.length > 0) {
                            for (DynamicObject failUserGroup : fail) {
                                long userId = failUserGroup.getLong("id");
                                String number = failUserGroup.getString("number");
                                String name = failUserGroup.getString("name");
                                failUserInfo.put(userId, new String[]{name, number});
                            }
                        }
                        for (Map.Entry data : allDeleteData.entrySet()) {
                            Long userId = (Long)data.getKey();
                            Set groups = (Set)data.getValue();
                            String[] nameAndNumber = (String[])failUserInfo.get(userId);
                            if (nameAndNumber == null) {
                                result.add(new LicenseError(LicenseError.LicenseErrorType.USER, userId, null, null, ResManager.loadKDString((String)"\u6b64\u7528\u6237\u4e0d\u5b58\u5728", (String)"UserLicGroupUtil_3", (String)"bos-license-business", (Object[])new Object[0])));
                                continue;
                            }
                            for (Long group : groups) {
                                String groupName = (String)licenseGroup.get(group);
                                if (StringUtils.isBlank((CharSequence)groupName)) {
                                    result.add(new LicenseError(LicenseError.LicenseErrorType.GROUP, group, groupName, null, ResManager.loadKDString((String)"%s\u8bb8\u53ef\u5206\u7ec4\u4e0d\u5b58\u5728\u3002", (String)"UserLicGroupUtil_11", (String)"bos-license-business", (Object[])new Object[]{""})));
                                    continue;
                                }
                                if (enableLegalPersonAssign) {
                                    result.add(new LicenseError(LicenseError.LicenseErrorType.USER, userId, nameAndNumber[0], nameAndNumber[1], String.format(ResManager.loadKDString((String)"%1$s\u672a\u5206\u914d%s\u6216\u8be5\u6cd5\u4eba\u516c\u53f8\u4e0b\u4e0d\u5b58\u5728%2$s\u3002", (String)"UserLicGroupUtil_18", (String)"bos-license-business", (Object[])new Object[0]), nameAndNumber[0], groupName, groupName)));
                                    continue;
                                }
                                LicenseError licenseError = new LicenseError(LicenseError.LicenseErrorType.USER, userId, nameAndNumber[0], nameAndNumber[1], String.format(ResManager.loadKDString((String)"%1$s\u672a\u5206\u914d%2$s\u6216\u4e0d\u5b58\u5728\u8be5\u8bb8\u53ef\u5206\u7ec4\u3002", (String)"UserLicGroupUtil_19", (String)"bos-license-business", (Object[])new Object[0]), nameAndNumber[0], groupName));
                                result.add(licenseError);
                            }
                        }
                    }
                    if (!CollectionUtils.isEmpty(successId) && !CollectionUtils.isEmpty(successData)) break block52;
                    fail = result;
                    if (dlock == null) return fail;
                    if (throwable2 == null) break block53;
                    try {
                        dlock.close();
                        return fail;
                    }
                    catch (Throwable throwable22) {
                        throwable2.addSuppressed(throwable22);
                        return fail;
                    }
                }
                dlock.close();
                return fail;
            }
            try {
                DeleteServiceHelper.delete((String)"lic_userlicensegroup", (QFilter[])new QFilter[]{new QFilter("id", "in", successId)});
                if (LicenseServiceUtil.isEnableLegalPersonAssign() && isCtrlAmount) {
                    UserLicGroupUtil.legalPersonCalculateUsedCount(successGroup.toArray(), legalPersonId);
                }
                if (isCtrlAmount) {
                    UserLicGroupUtil.publicCalculateUsedCount(successGroup.toArray());
                }
                UserLicGroupUtil.highAvailabilityModeDeleteLicUserGroup(groupAndUserId, userIds);
                LicenseServiceHelper.addUsers2LicGroupDif(new HashSet(successData.keySet()));
                ILicenseService service = (ILicenseService)ServiceFactory.getService(ILicenseService.class);
                service.addAssignLogs(licenseAssignLogs);
                return result;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            catch (Throwable throwable4) {
                throw throwable4;
            }
            finally {
                if (dlock != null) {
                    if (throwable2 != null) {
                        try {
                            dlock.close();
                        }
                        catch (Throwable throwable5) {
                            throwable2.addSuppressed(throwable5);
                        }
                    } else {
                        dlock.close();
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("deleteUserGroupsById \u5931\u8d25", (Throwable)e);
            h.markRollback();
            throw e;
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
    }

    private static void highAvailabilityModeDeleteLicUserGroup(Map<Long, Set<Long>> groupAndUserIds, Set<Long> userIds) {
        if (CollectionUtils.isEmpty(userIds) && !CollectionUtils.isEmpty(groupAndUserIds)) {
            userIds = new HashSet<Long>(16);
            for (Set<Long> userId : groupAndUserIds.values()) {
                for (Long l : userId) {
                    userIds.add(l);
                }
            }
        }
        if (CollectionUtils.isEmpty(groupAndUserIds) || CollectionUtils.isEmpty(userIds)) {
            return;
        }
        Map userIndexMap = UserIndexUtil.getUserIndexListBySet(userIds);
        HashMap<Long, List<Integer>> grouplicUserRelMap = new HashMap<Long, List<Integer>>(16);
        for (Map.Entry entry : groupAndUserIds.entrySet()) {
            Long groupId = (Long)entry.getKey();
            Set userPKs = (Set)entry.getValue();
            ArrayList<Integer> userIndexs = new ArrayList<Integer>(userPKs.size());
            for (Long userPK : userPKs) {
                UserIndex userIndex = (UserIndex)userIndexMap.get(userPK);
                if (null == userIndex) {
                    userIndexs.add(0);
                    continue;
                }
                int index = userIndex.getIndex();
                userIndexs.add(index);
            }
            grouplicUserRelMap.put(groupId, userIndexs);
        }
        LicenseUserRelEngine.removeLicUserGroup(grouplicUserRelMap);
    }

    public static enum UserGroupCacheType {
        ADD,
        DELETE;

    }
}

