/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.license.LocalCache;

import java.util.Map;
import javax.validation.constraints.NotNull;
import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.context.RequestContext;
import kd.bos.license.bean.LicGroupRuntime;

public class LicGroupRuntimeLocalCache {
    private static final CacheConfigInfo info = new CacheConfigInfo();
    private static final String REGION = "LicGroupRuntimeLocalCache";
    private static final String ALL_LICENSEGROUPINFO_RUNTIME_KEY = "allLicGroupRuntimeInfo";
    private static final String LICENSEGROUPINFO_GROUPID_RUNTIME_KEY = "licGroupRuntimeInfoById";
    private static final String VERSION = "licGroupRuntimeLocalCache_Version";

    private static LocalMemoryCache getLocalCache() {
        return CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache(REGION, RequestContext.get().getAccountId(), info);
    }

    public static void clear() {
        LicGroupRuntimeLocalCache.getLocalCache().clear();
    }

    public static String getVersion() {
        return (String)LicGroupRuntimeLocalCache.getLocalCache().get(VERSION);
    }

    public static void setVersion(String version) {
        if (null == version) {
            return;
        }
        LicGroupRuntimeLocalCache.getLocalCache().put(VERSION, (Object)version);
    }

    public static Map<String, LicGroupRuntime> getAllLicGroupRunTimeInfo() {
        return (Map)LicGroupRuntimeLocalCache.getLocalCache().get(ALL_LICENSEGROUPINFO_RUNTIME_KEY);
    }

    public static void putAllLicenseGroupRunTimeInfo(@NotNull Map<String, LicGroupRuntime> licenseGroupInfos) {
        LicGroupRuntimeLocalCache.getLocalCache().put(ALL_LICENSEGROUPINFO_RUNTIME_KEY, licenseGroupInfos);
    }

    static {
        info.setTimeout(43200);
        info.setMaxItemSize(10000);
    }
}

