/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.license.LocalCache;

import java.util.Map;
import javax.validation.constraints.NotNull;
import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.context.RequestContext;
import kd.bos.license.bean.LicenseGroupInfo;

public class LicenseGroupLocalCache {
    private static final CacheConfigInfo info = new CacheConfigInfo();
    private static final String REGION = "LicenseGroupInfo";
    private static final String ALL_LICENSEGROUPINFO_KEY = "allLicenseGroupinfo";
    private static final String LICENSEGROUPINFO_GROUPID_KEY = "licenseGroupinfoById";

    private static LocalMemoryCache getLocalCache() {
        return CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache(REGION, RequestContext.get().getAccountId(), info);
    }

    public static void clear() {
        LicenseGroupLocalCache.getLocalCache().clear();
    }

    public static Map<String, LicenseGroupInfo> getAllLicGroupInfo() {
        return (Map)LicenseGroupLocalCache.getLocalCache().get(ALL_LICENSEGROUPINFO_KEY);
    }

    public static void putAllLicenseGroupInfo(@NotNull Map<String, LicenseGroupInfo> licenseGroupInfos) {
        LicenseGroupLocalCache.getLocalCache().put(ALL_LICENSEGROUPINFO_KEY, licenseGroupInfos);
    }

    public static Map<String, LicenseGroupInfo> getLicGroupInfoById(@NotNull String groupId) {
        return (Map)LicenseGroupLocalCache.getLocalCache().get("licenseGroupinfoByIdgroupId");
    }

    static {
        info.setTimeout(43200);
        info.setMaxItemSize(10000);
    }
}

