/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.license.LocalCache;

import javax.validation.constraints.NotNull;
import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.context.RequestContext;
import kd.bos.license.LocalCache.limit.FixedSizeMap;
import kd.bos.license.bean.UserIndex;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class UserIndexLocalCache {
    static Log logger = LogFactory.getLog(UserIndexLocalCache.class);
    private static final CacheConfigInfo info = new CacheConfigInfo();
    private static final String REGION = "UserIndexLocalCache";
    public static final String LOAD = "isloaded";
    private static final String All_USER_INDEXS_KEY = "allUserIndexs";

    public static void clear() {
        UserIndexLocalCache.getLocalCache().clear();
    }

    private static LocalMemoryCache getLocalCache() {
        return CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache(REGION, RequestContext.get().getAccountId(), info);
    }

    public static FixedSizeMap<Long, UserIndex> getAllUserIndexs() {
        return (FixedSizeMap)UserIndexLocalCache.getLocalCache().get(All_USER_INDEXS_KEY);
    }

    public static void putAllUserIndexInfo(@NotNull FixedSizeMap<Long, UserIndex> userIndexMap) {
        UserIndexLocalCache.getLocalCache().put(All_USER_INDEXS_KEY, userIndexMap);
    }

    static {
        info.setTimeout(43200);
        info.setMaxItemSize(10000);
    }
}

