/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.license.callable;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.license.bean.UserIndex;
import kd.bos.license.util.UserIndexUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class QueryUserIndex
implements Callable {
    private static Log logger = LogFactory.getLog(QueryUserIndex.class);
    private Set<Long> userIds;
    private CountDownLatch countDownLatch;

    public QueryUserIndex(Set<Long> userIds, CountDownLatch countDownLatch) {
        this.userIds = userIds;
        this.countDownLatch = countDownLatch;
    }

    public Object call() throws Exception {
        try {
            Map<Long, UserIndex> map = UserIndexUtil.getUserIndexInfoByIds(this.userIds);
            return map;
        }
        catch (Exception e) {
            logger.warn("QueryUserIndex.call error.", (Throwable)e);
            throw new KDBizException(new ErrorCode("0", "QueryUserIndex.call error."), new Object[0]);
        }
        finally {
            if (null != this.countDownLatch) {
                this.countDownLatch.countDown();
            }
        }
    }
}

