/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.license.callable;

import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.license.bean.User;
import kd.bos.license.util.UserUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class QueryUserInfo
implements Callable {
    private static Log logger = LogFactory.getLog(QueryUserInfo.class);
    private Set<Long> userIds;
    private CountDownLatch countDownLatch;

    public QueryUserInfo(Set<Long> userIds, CountDownLatch countDownLatch) {
        this.userIds = userIds;
        this.countDownLatch = countDownLatch;
    }

    public Object call() throws Exception {
        try {
            List<User> list = UserUtil.getUserInfoByIds(this.userIds);
            return list;
        }
        catch (Exception e) {
            logger.warn("QueryUserInfo.call error.", (Throwable)e);
            throw new KDBizException(new ErrorCode("0", "QueryUserInfo.call error."), new Object[0]);
        }
        finally {
            if (null != this.countDownLatch) {
                this.countDownLatch.countDown();
            }
        }
    }
}

