/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.license.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.BitSet;
import kd.bos.license.util.EncryptUtil;

public class BloomFilter
implements Serializable {
    private static final int DEFAULT_SIZE = 462963;
    private static final int[] seeds = new int[]{3, 5, 7, 11, 13, 31, 37, 61};
    private BitSet bits = new BitSet(462963);
    private SimpleHash[] func = new SimpleHash[seeds.length];

    public BloomFilter() {
        for (int i = 0; i < seeds.length; ++i) {
            this.func[i] = new SimpleHash(462963, seeds[i]);
        }
    }

    public void add(String value) {
        if (value != null) {
            for (SimpleHash f : this.func) {
                this.bits.set(f.hash(value), true);
            }
        }
    }

    public boolean contains(String value) {
        if (value == null) {
            return false;
        }
        boolean ret = true;
        for (SimpleHash f : this.func) {
            ret = ret && this.bits.get(f.hash(value));
        }
        return ret;
    }

    public String serializeToString() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (ObjectOutputStream out = new ObjectOutputStream(byteArrayOutputStream);){
            out.writeObject(this);
        }
        return EncryptUtil.bytesToHex(byteArrayOutputStream.toByteArray());
    }

    public static BloomFilter deserializeFromString(String serializedString) throws IOException, ClassNotFoundException {
        byte[] data = EncryptUtil.hexStringToByteArray(serializedString);
        try (ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(data));){
            BloomFilter bloomFilter = (BloomFilter)in.readObject();
            return bloomFilter;
        }
    }

    private static class SimpleHash
    implements Serializable {
        private int cap;
        private int seed;

        public SimpleHash(int cap, int seed) {
            this.cap = cap;
            this.seed = seed;
        }

        public int hash(String value) {
            int result = 0;
            int len = value.length();
            for (int i = 0; i < len; ++i) {
                result = this.seed * result + value.charAt(i);
            }
            return this.cap - 1 & result;
        }
    }
}

