/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.license.util;

import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Map;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import javax.crypto.Cipher;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.encrypt.Encrypters;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;

public class EncryptUtil {
    private static final int KEY_SIZE = 2048;
    private static final int BLOCK_SIZE = 190;
    private static final char[] HEX_ARRAY = "0123456789ABCDEF".toCharArray();
    private static final String PRK = "/LicenseConfigPrk.config";
    private static Log logger = LogFactory.getLog(EncryptUtil.class);

    public static String encryBytes(byte[] encry) throws Exception {
        Cipher cipher = Cipher.getInstance("RSA/ECB/OAEPWITHSHA-256ANDMGF1PADDING");
        PublicKey publicKey = EncryptUtil.getPublicKey();
        if (null == publicKey) {
            String errorMessage = ResManager.loadKDString((String)"\u8bfb\u53d6\u516c\u94a5\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5MC\u914d\u7f6e\u3002", (String)"EncryptUtil_0", (String)"bos-license-common", (Object[])new Object[0]);
            throw new KDBizException(new ErrorCode("not_found_pk", errorMessage), new Object[]{errorMessage});
        }
        cipher.init(1, publicKey);
        return EncryptUtil.bytesToHex(EncryptUtil.encrypt(encry, cipher));
    }

    public static String encryString(String encry) throws Exception {
        Cipher cipher = Cipher.getInstance("RSA/ECB/OAEPWITHSHA-256ANDMGF1PADDING");
        PublicKey publicKey = EncryptUtil.getPublicKey();
        if (null == publicKey) {
            String errorMessage = ResManager.loadKDString((String)"\u8bfb\u53d6\u516c\u94a5\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5MC\u914d\u7f6e\u3002", (String)"EncryptUtil_0", (String)"bos-license-common", (Object[])new Object[0]);
            throw new KDBizException(new ErrorCode("not_found_pk", errorMessage), new Object[]{errorMessage});
        }
        cipher.init(1, publicKey);
        return EncryptUtil.bytesToHex(EncryptUtil.encrypt(encry.getBytes(), cipher));
    }

    public static byte[] decryptString(String decrypt) throws Exception {
        Cipher cipher = Cipher.getInstance("RSA/ECB/OAEPWITHSHA-256ANDMGF1PADDING");
        PrivateKey privateKey = EncryptUtil.getPrivateKey();
        if (null == privateKey) {
            String errorMessage = String.format(ResManager.loadKDString((String)"\u8bfb\u53d6\u79c1\u94a5\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5%1$s\u6587\u4ef6\u3002", (String)"EncryptUtil_1", (String)"bos-license-common", (Object[])new Object[0]), PRK);
            throw new KDBizException(new ErrorCode("not_found_prk", errorMessage), new Object[]{errorMessage});
        }
        cipher.init(2, privateKey);
        return EncryptUtil.decrypt(EncryptUtil.hexStringToByteArray(decrypt), cipher);
    }

    private static PublicKey getPublicKey() throws Exception {
        String publicK = System.getProperty("mc_license_public_k");
        if (StringUtils.isEmpty((String)publicK)) {
            return null;
        }
        if (Encrypters.isEncrypted((String)publicK)) {
            publicK = Encrypters.decode((String)publicK);
        }
        byte[] publicKeyBytes = EncryptUtil.hexStringToByteArray(publicK);
        X509EncodedKeySpec pubKeySpec = new X509EncodedKeySpec(publicKeyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        return keyFactory.generatePublic(pubKeySpec);
    }

    private static PrivateKey getPrivateKey() throws Exception {
        String privateKey = EncryptUtil.getKey("LicenseConfigPrivateKey");
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        byte[] privateKeyBytes = EncryptUtil.hexStringToByteArray(privateKey);
        PKCS8EncodedKeySpec privKeySpec = new PKCS8EncodedKeySpec(privateKeyBytes);
        return keyFactory.generatePrivate(privKeySpec);
    }

    /*
     * Exception decompiling
     */
    private static String readLicenseConfig(String fileName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static byte[] encrypt(byte[] data, Cipher cipher) throws Exception {
        if (null == data || data.length == 0 || null == cipher) {
            return new byte[0];
        }
        int blockCount = (data.length - 1) / 190 + 1;
        byte[] result = new byte[blockCount * 256];
        for (int i = 0; i < blockCount; ++i) {
            int from = i * 190;
            int to = Math.min(from + 190, data.length);
            byte[] block = new byte[to - from];
            System.arraycopy(data, from, block, 0, to - from);
            byte[] encryptedBlock = cipher.doFinal(block);
            System.arraycopy(encryptedBlock, 0, result, i * 256, encryptedBlock.length);
        }
        return result;
    }

    private static byte[] decrypt(byte[] data, Cipher cipher) throws Exception {
        if (null == data || data.length == 0 || null == cipher) {
            return new byte[0];
        }
        int blockCount = data.length / 256;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        for (int i = 0; i < blockCount; ++i) {
            int from = i * 256;
            int to = Math.min(from + 256, data.length);
            byte[] block = new byte[to - from];
            System.arraycopy(data, from, block, 0, to - from);
            byte[] decryptedBlock = cipher.doFinal(block);
            out.write(decryptedBlock, 0, decryptedBlock.length);
        }
        byte[] encryptedData = out.toByteArray();
        out.close();
        return encryptedData;
    }

    public static String bytesToHex(byte[] bytes) {
        if (null == bytes || bytes.length == 0) {
            return "";
        }
        char[] hexChars = new char[bytes.length * 2];
        for (int i = 0; i < bytes.length; ++i) {
            int v = bytes[i] & 0xFF;
            hexChars[i * 2] = HEX_ARRAY[v >>> 4];
            hexChars[i * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
        return new String(hexChars);
    }

    public static byte[] hexStringToByteArray(String s) {
        if (StringUtils.isEmpty((String)s)) {
            return new byte[0];
        }
        int len = s.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
        }
        return data;
    }

    public static String getKey(String keyName) {
        String data = EncryptUtil.readLicenseConfig(PRK);
        if (StringUtils.isEmpty((String)data)) {
            return null;
        }
        if (Encrypters.isEncrypted((String)data)) {
            data = Encrypters.decode((String)data);
        }
        Map secretMap = (Map)SerializationUtils.fromJsonString((String)data, Map.class);
        return (String)secretMap.get(keyName);
    }

    public static byte[] zipString(String unzipString) {
        if (StringUtils.isEmpty((String)unzipString)) {
            return new byte[0];
        }
        Deflater deflater = new Deflater(9);
        deflater.setInput(unzipString.getBytes(StandardCharsets.UTF_8));
        deflater.finish();
        byte[] bytes = new byte[512];
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(1024);
        while (!deflater.finished()) {
            int length = deflater.deflate(bytes);
            outputStream.write(bytes, 0, length);
        }
        deflater.end();
        return outputStream.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] unzipString(byte[] decode) {
        if (null == decode || decode.length == 0) {
            return new byte[0];
        }
        Inflater inflater = new Inflater();
        inflater.setInput(decode);
        byte[] bytes = new byte[1024];
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(1024);
        try {
            while (!inflater.finished()) {
                int length = inflater.inflate(bytes);
                outputStream.write(bytes, 0, length);
            }
        }
        catch (DataFormatException e) {
            byte[] byArray = new byte[]{};
            return byArray;
        }
        finally {
            inflater.end();
        }
        return outputStream.toByteArray();
    }
}

