/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.license.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.HttpClientUtils;

public class LicenseDevopsApiUtil {
    private static final Log logger = LogFactory.getLog(LicenseDevopsApiUtil.class);
    private static final String CONFIG_DEVOPS_SERVER_URL = "devops.server.url";
    private static final String URL_GET_GRAY_FEATURES = "/kapi/v2/poa/grayscale/getCustomerFeatureList";
    private static final String ERROR_CODE_SUCCESS = "0";

    public static JSONObject getGrayFeatures(String productCode, String tid) {
        if (StringUtils.isBlank((CharSequence)tid)) {
            logger.warn("getGrayFeatures -- productCode : " + productCode + ",tid : " + tid);
            return new JSONObject();
        }
        HashMap<String, Object> body = new HashMap<String, Object>(8);
        body.put("productCode", productCode);
        body.put("tid", tid);
        logger.info("getGrayFeatures -- productCode : " + productCode + ",tid : " + tid);
        return LicenseDevopsApiUtil.postDevops(URL_GET_GRAY_FEATURES, body);
    }

    private static String getAccessToken() {
        String accessToken;
        Map<String, String> authenticationInfo = LicenseDevopsApiUtil.getAuthenticationInfo(RequestContext.get().getTenantId());
        String domainUrl = authenticationInfo.get("domainUrl");
        String appId = authenticationInfo.get("appid");
        String appSecret = authenticationInfo.get("appSecret");
        String user = authenticationInfo.get("user");
        String accountId = authenticationInfo.get("accountId");
        String tenantId = authenticationInfo.get("tenantId");
        try {
            boolean responseIsNull;
            HashMap<String, String> header = new HashMap<String, String>(2);
            header.put("Content-type", "application/json");
            HashMap<String, String> body = new HashMap<String, String>(8);
            body.put("appId", appId);
            body.put("appSecret", appSecret);
            body.put("tenantid", tenantId);
            body.put("accountId", accountId);
            body.put("language", "zh_CN");
            String responseStr = HttpClientUtils.postjson((String)(domainUrl + "/api/getAppToken.do"), header, (String)JSON.toJSONString(body));
            JSONObject response = JSON.parseObject((String)responseStr);
            boolean bl = responseIsNull = response == null;
            if (responseIsNull || !response.getBoolean("status").booleanValue()) {
                String message = responseIsNull ? "getAppToken response is null." : response.getString("message");
                logger.error(message);
                throw new KDBizException(message);
            }
            Map data = (Map)response.get((Object)"data");
            String appToken = (String)data.get("app_token");
            body.put("user", user);
            body.put("usertype", "UserName");
            body.put("apptoken", appToken);
            body.remove("appId");
            body.remove("appSecret");
            responseStr = HttpClientUtils.postjson((String)(domainUrl + "/api/login.do"), header, (String)JSON.toJSONString(body));
            response = JSON.parseObject((String)responseStr);
            boolean bl2 = responseIsNull = response == null;
            if (responseIsNull || !response.getBoolean("status").booleanValue()) {
                String message = responseIsNull ? "login response is null." : response.getString("message");
                logger.error(message);
                throw new KDBizException(message);
            }
            data = (Map)response.get((Object)"data");
            accessToken = (String)data.get("access_token");
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6token\u5f02\u5e38\u3002", (Throwable)e);
            throw new KDBizException((Throwable)e, new ErrorCode("", ResManager.loadKDString((String)"\u83b7\u53d6token\u5f02\u5e38\u3002", (String)"LicenseDevopsApiUtil_0", (String)"bos-license-common", (Object[])new Object[0])), new Object[0]);
        }
        return accessToken;
    }

    private static Map<String, String> getAuthenticationInfo(String tenantId) {
        String domainUrl = System.getProperty(tenantId + "_" + CONFIG_DEVOPS_SERVER_URL);
        HashMap<String, String> authenticationInfo = new HashMap<String, String>(16);
        if (StringUtils.isBlank((CharSequence)domainUrl)) {
            authenticationInfo.put("domainUrl", "https://devops.kingdee.com:8000");
            authenticationInfo.put("appid", "csp");
            authenticationInfo.put("appSecret", "VoRPp7SmtSxF2uk59818hQ==");
            authenticationInfo.put("user", "administrator");
            authenticationInfo.put("accountId", "1543805405760606521");
            authenticationInfo.put("tenantid", "devops");
        } else {
            authenticationInfo.put("domainUrl", domainUrl);
            authenticationInfo.put("appid", "csp");
            authenticationInfo.put("appSecret", "VoRPp7SmtSxF2uk59818hQ==");
            authenticationInfo.put("user", "administrator");
            authenticationInfo.put("accountId", "1341375828541309952");
            authenticationInfo.put("tenantid", "devops");
        }
        return authenticationInfo;
    }

    private static String getDomainUrl(String tenantId) {
        String domainUrl = System.getProperty(tenantId + "_" + CONFIG_DEVOPS_SERVER_URL);
        if (StringUtils.isBlank((CharSequence)domainUrl)) {
            return "https://devops.kingdee.com:8000";
        }
        return domainUrl;
    }

    private static Map<String, String> buildRequestHeader() {
        HashMap<String, String> header = new HashMap<String, String>(4);
        header.put("Content-type", "application/json");
        header.put("charset", "utf-8");
        return header;
    }

    private static JSONObject postDevops(String api, Map<String, Object> body) {
        Map<String, String> header = LicenseDevopsApiUtil.buildRequestHeader();
        String domainUrl = LicenseDevopsApiUtil.getDomainUrl(RequestContext.get().getTenantId());
        String url = domainUrl + api;
        try {
            JSONObject jsonResponse;
            header.put("access_token", LicenseDevopsApiUtil.getAccessToken());
            String strResponse = HttpClientUtils.postjson((String)url, header, (String)JSONObject.toJSONString(body));
            if (StringUtils.isNotBlank((CharSequence)strResponse) && (jsonResponse = JSON.parseObject((String)strResponse)) != null) {
                boolean isSuccess = jsonResponse.getBoolean("status");
                String errorCode = jsonResponse.getString("errorCode");
                if (isSuccess && ERROR_CODE_SUCCESS.equals(errorCode)) {
                    logger.info("postdevops success url={}", (Object)url);
                    return jsonResponse;
                }
                logger.error(jsonResponse.getString("message"));
                throw new KDBizException(jsonResponse.getString("message"));
            }
        }
        catch (Exception e) {
            logger.error("postdevops exception url=" + url, (Throwable)e);
            throw new KDBizException(e.getMessage());
        }
        return new JSONObject();
    }
}

