/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.license.util;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.PermissionService;
import kd.bos.permission.model.AdminInfo;
import kd.bos.permission.model.AdminType;
import kd.bos.service.ServiceFactory;

public class LicenseExpireUtil {
    private static final Log logger = LogFactory.getLog(LicenseExpireUtil.class);

    public static List<Map<String, Object>> getLicenseExpireDetail() {
        ArrayList<Map<String, Object>> licenseExpireInfos = new ArrayList<Map<String, Object>>(2);
        String langName = RequestContext.get().getLang().name();
        StringBuilder sql = new StringBuilder();
        sql.append("select tll.fexpdate expire_date, tlil.fname fname, tll.fproductid productId, tli.fid prodid , tli.fprodname prodname ,tll.fproductversion version ");
        sql.append("from t_lic_license tll ");
        sql.append("left join t_lic_isvprod tli on tll.fprodid = tli.fid ");
        sql.append("left join t_lic_isvprod_l tlil on tli.fid = tlil.fid ");
        sql.append(String.format(" and tlil.flocaleid = '%s' ", langName));
        sql.append(" order by expire_date asc ");
        try (DataSet expireDataAndName = DB.queryDataSet((String)"select_expire_date", (DBRoute)DBRoute.basedata, (String)sql.toString());){
            while (expireDataAndName.hasNext()) {
                HashMap<String, Object> licenseExpireInfo = new HashMap<String, Object>(4);
                Row row = expireDataAndName.next();
                Date expDate = row.getDate("expire_date");
                int toExpireDays = LicenseExpireUtil.differentDays(new Date(), expDate);
                if (toExpireDays > 30 || toExpireDays < 0) continue;
                String prodid = row.getString("prodid");
                String name = row.getString("fname");
                name = null == name ? row.getString("prodname") : name;
                String productId = row.getString("productId");
                String version = row.getString("version");
                licenseExpireInfo.put("expDate", expDate);
                licenseExpireInfo.put("name", name);
                licenseExpireInfo.put("productId", productId);
                licenseExpireInfo.put("toExpireDays", toExpireDays);
                licenseExpireInfos.add(licenseExpireInfo);
                if (!"1I6COPY94UBO".equals(prodid) || !(Float.parseFloat(version) < 5.0f)) continue;
                HashMap<String, Object> licenseExpireInfoOld = new HashMap<String, Object>(4);
                licenseExpireInfoOld.put("expDate", expDate);
                licenseExpireInfoOld.put("name", ResManager.loadKDString((String)"\u91d1\u8776\u4e91\u00b7\u661f\u701a", (String)"LicenseExpireUtil_7", (String)"bos-license-common", (Object[])new Object[0]));
                licenseExpireInfoOld.put("productId", productId);
                licenseExpireInfoOld.put("toExpireDays", toExpireDays);
                licenseExpireInfos.add(licenseExpireInfoOld);
            }
            ArrayList<Map<String, Object>> arrayList = licenseExpireInfos;
            return arrayList;
        }
    }

    public static int differentDays(Date date1, Date date2) {
        if (date1 == null || date2 == null || date1.compareTo(date2) > 0) {
            return -1;
        }
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(date1);
        Calendar cal2 = Calendar.getInstance();
        cal2.setTime(date2);
        int day1 = cal1.get(6);
        int day2 = cal2.get(6);
        int year1 = cal1.get(1);
        int year2 = cal2.get(1);
        if (year1 == year2) {
            return day2 - day1;
        }
        int timeDistance = 0;
        for (int i = year1; i < year2; ++i) {
            if ((i % 4 != 0 || i % 100 == 0) && i % 400 != 0) {
                timeDistance += 365;
                continue;
            }
            timeDistance += 366;
        }
        return timeDistance + (day2 - day1);
    }

    public static Map<String, Object> getLastExpireData() {
        List<Map<String, Object>> expireDetail = LicenseExpireUtil.getLicenseExpireDetail();
        if (CollectionUtils.isEmpty(expireDetail)) {
            return null;
        }
        return expireDetail.get(0);
    }

    @Deprecated
    public static boolean sendMessage(List<Map<String, Object>> licenseExpireDetail) {
        return false;
    }

    private static String getCustomStr(Collection<?> array, String prefix, String suffix, String split) {
        if (CollectionUtils.isEmpty(array)) {
            return "";
        }
        boolean first = true;
        StringBuilder sqlList = new StringBuilder();
        for (Object one : array) {
            if (first) {
                first = false;
                sqlList.append(prefix).append(one).append(suffix);
                continue;
            }
            sqlList.append(split).append(prefix).append(one).append(suffix);
        }
        return sqlList.toString();
    }

    public static boolean validateExpireNotice(List<Map<String, Object>> licenseExpireDetail) {
        if (CollectionUtils.isEmpty(licenseExpireDetail)) {
            LicenseExpireUtil.updateLicenseExpireStatus(false);
            return false;
        }
        Map<String, Object> firstExpireData = licenseExpireDetail.get(0);
        Map<String, Object> lastExpireData = licenseExpireDetail.get(licenseExpireDetail.size() - 1);
        Date expDate = (Date)firstExpireData.get("expDate");
        int days = LicenseExpireUtil.differentDays(new Date(), expDate);
        if (days > 15 && days % 7 != 2) {
            return false;
        }
        String productId = String.valueOf(firstExpireData.get("productId"));
        String productName = String.valueOf(firstExpireData.get("name"));
        final Date lastExpDate = (Date)lastExpireData.get("expDate");
        boolean isOpenNotice = (Boolean)DB.query((DBRoute)DBRoute.basedata, (String)"select fexpdate,fopennotice from t_lic_expirenotice where fid = 1", (ResultSetHandler)new ResultSetHandler<Boolean>(){

            public Boolean handle(ResultSet resultSet) throws Exception {
                if (resultSet.next()) {
                    Timestamp previousExpDate = resultSet.getTimestamp("fexpdate");
                    if (lastExpDate.compareTo(previousExpDate) > 0) {
                        return true;
                    }
                    return resultSet.getBoolean("fopennotice");
                }
                return true;
            }
        });
        if (isOpenNotice) {
            AdminInfo administratorInfo = LicenseExpireUtil.getAdministratorInfo();
            if (null == administratorInfo) {
                return false;
            }
            DB.execute((DBRoute)DBRoute.basedata, (String)"delete from t_lic_expirenotice ");
            DB.execute((DBRoute)DBRoute.basedata, (String)"insert into t_lic_expirenotice (fid,fproductid,fproductname,fexpdate,fopennotice,frecipient,fnoticetime) values(?,?,?,?,?,?,?)", (Object[])new Object[]{1, productId, productName, new Timestamp(lastExpDate.getTime()), true, administratorInfo.getUserid(), new Timestamp(new Date().getTime())});
        }
        return isOpenNotice;
    }

    public static AdminInfo getAdministratorInfo() {
        List topAdminInfo = ((PermissionService)ServiceFactory.getService(PermissionService.class)).getTopAdminInfo();
        for (AdminInfo adminInfo : topAdminInfo) {
            if (AdminType.Administrator != adminInfo.getAdminType()) continue;
            return adminInfo;
        }
        return null;
    }

    public static boolean getExpireNoticeStatus() {
        return (Boolean)DB.query((DBRoute)DBRoute.basedata, (String)"select  fopennotice from t_lic_expirenotice where fid = 1", (ResultSetHandler)new ResultSetHandler<Boolean>(){

            public Boolean handle(ResultSet resultSet) throws Exception {
                if (resultSet.next()) {
                    return resultSet.getBoolean("fopennotice");
                }
                return false;
            }
        });
    }

    public static boolean updateExpireNoticeStatus() {
        List<Map<String, Object>> licenseExpireDetail = LicenseExpireUtil.getLicenseExpireDetail();
        if (CollectionUtils.isEmpty(licenseExpireDetail)) {
            LicenseExpireUtil.updateLicenseExpireStatus(false);
            return false;
        }
        Map<String, Object> lastExpireData = licenseExpireDetail.get(licenseExpireDetail.size() - 1);
        Map result = (Map)DB.query((DBRoute)DBRoute.basedata, (String)"select fexpdate,fopennotice from t_lic_expirenotice where fid = 1 ", (ResultSetHandler)new ResultSetHandler<Map<String, Object>>(){

            public Map<String, Object> handle(ResultSet resultSet) throws Exception {
                HashMap<String, Object> result = new HashMap<String, Object>(1);
                if (resultSet.next()) {
                    result.put("expDate", resultSet.getTimestamp("fexpdate"));
                    result.put("isOpened", resultSet.getBoolean("fopennotice"));
                    return result;
                }
                return null;
            }
        });
        Date expDate = (Date)lastExpireData.get("expDate");
        if (!CollectionUtils.isEmpty((Map)result) && ((Date)result.get("expDate")).compareTo(expDate) < 0) {
            LicenseExpireUtil.updateLicenseExpireStatus(true);
            String sql = "update t_lic_expirenotice set fexpdate = ? where fid = 1";
            DB.execute((DBRoute)DBRoute.basedata, (String)sql, (Object[])new Object[]{new Timestamp(expDate.getTime())});
            return true;
        }
        return false;
    }

    public static void updateLicenseExpireStatus(boolean isOpened) {
        String sql = "update t_lic_expirenotice set fopennotice = " + (isOpened ? 1 : 0) + " where fid = 1";
        DB.execute((DBRoute)DBRoute.basedata, (String)sql);
    }
}

