/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.license.util;

import com.tongtech.backport.java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.dlock.DLock;
import kd.bos.license.LocalCache.GrayFeatureLocalCache;
import kd.bos.license.bean.gray.GrayFeatureScheme;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;

public class LicenseGrayFeatureUtil {
    private static final Log logger = LogFactory.getLog(LicenseGrayFeatureUtil.class);

    public static Map<String, GrayFeatureScheme> getAllFeatureNumberInfos() {
        Map<String, GrayFeatureScheme> allGrayFeatureInfo = GrayFeatureLocalCache.getAllGrayFeatureInfo();
        if (CollectionUtils.isEmpty(allGrayFeatureInfo)) {
            try (DLock dlock = DLock.createReentrant((String)"getAllFeatureNumberAndId");){
                dlock.lock();
                allGrayFeatureInfo = GrayFeatureLocalCache.getAllGrayFeatureInfo();
                if (CollectionUtils.isEmpty(allGrayFeatureInfo)) {
                    allGrayFeatureInfo = LicenseGrayFeatureUtil.reloadAllFeatureInfo();
                }
            }
            catch (Exception e) {
                logger.error("LicenseGrayFeatureUtil.getAllFeatureNumberAndId error , return emptyMap.", (Throwable)e);
                return Collections.emptyMap();
            }
        }
        return allGrayFeatureInfo;
    }

    private static Map<String, GrayFeatureScheme> reloadAllFeatureInfo() {
        Map allGrayFeatures = (Map)DB.query((DBRoute)DBRoute.base, (String)"select fid featureId,fnumber featureNum, fminversion minVersion, fname featureName , fintroduction featureIntroduct , fdetailurl featureDetailUrl from t_lic_grayfeaturescheme", rs -> {
            HashMap<String, GrayFeatureScheme> result = new HashMap<String, GrayFeatureScheme>(16);
            result.put("isloaded", new GrayFeatureScheme());
            while (rs.next()) {
                GrayFeatureScheme grayFeatureScheme = new GrayFeatureScheme();
                long featureId = rs.getLong("featureId");
                String featureNum = rs.getString("featureNum");
                grayFeatureScheme.setId(featureId);
                grayFeatureScheme.setNumber(featureNum);
                grayFeatureScheme.setMinVersion(rs.getString("minVersion"));
                grayFeatureScheme.setName(rs.getString("featureName"));
                grayFeatureScheme.setIntroduction(rs.getString("featureIntroduct"));
                grayFeatureScheme.setDetailUrl(rs.getString("featureDetailUrl"));
                result.put(featureId + "", grayFeatureScheme);
                result.put(featureNum, grayFeatureScheme);
            }
            return result;
        });
        GrayFeatureLocalCache.putAllGrayFeatureInfo(allGrayFeatures);
        return allGrayFeatures;
    }

    public static GrayFeatureScheme getGrayFeatureInfo(String featureNumOrId) {
        Map<String, GrayFeatureScheme> allFeatureNumberInfos = LicenseGrayFeatureUtil.getAllFeatureNumberInfos();
        return allFeatureNumberInfos.get(featureNumOrId);
    }
}

