/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.license.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bes.mq.util.CollectionUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDException;
import kd.bos.license.bean.gray.GrayFeatureScheme;
import kd.bos.license.util.LicenseDevopsApiUtil;
import kd.bos.license.util.LicenseGrayFeatureUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;

public class LicenseGrayUpdateStatusUtil {
    private static final Log logger = LogFactory.getLog(LicenseGrayUpdateStatusUtil.class);
    private static final String GALAXY = "galaxy";
    private static final String COSMIC = "cosmic";
    private static final String FEATURES = "features";
    private static final String FEATURE_NUMBER = "number";
    private static final String FEATURE_NAME = "name";
    private static final String FEATURE_STATUS = "status";
    private static final String FEATURE_STARTDATESTR = "startDate";
    private static final String FEATURE_ENDDATESTR = "endDate";
    private static final String APPLICATION_DATE = "applyDate";
    private static final String FEATURE_SC_ID = "featureScId";
    private static final String IS_IMPORTED_STATUS = "10";
    private static final String ENTITY_SNAPSHOT = "lic_snapshot";

    public static void updateGrayLicenseStatus() {
        MainEntityType dataEntityType;
        String sql;
        Set<FeatureInfo> LicenseGrayData = null;
        try {
            LicenseGrayData = LicenseGrayUpdateStatusUtil.dataFilterAndCheck(LicenseDevopsApiUtil.getGrayFeatures(LicenseGrayUpdateStatusUtil.getProductCode(), LicenseGrayUpdateStatusUtil.getTid()));
        }
        catch (Exception e) {
            logger.error("updateGrayLicenseStatus --dataFilterAndCheck error", (Throwable)e);
            return;
        }
        if (CollectionUtils.isEmpty(LicenseGrayData)) {
            logger.error("updateGrayLicenseStatus --data is empty.");
            return;
        }
        Map existFeatureInfo = (Map)DB.query((DBRoute)DBRoute.base, (String)"select fschemeid featureScId,fstatus status from t_lic_grayfeature", rs -> {
            HashMap<Long, String> existFeatureInfos = new HashMap<Long, String>(16);
            while (rs.next()) {
                long featureScId = rs.getLong(FEATURE_SC_ID);
                String status = rs.getString(FEATURE_STATUS);
                existFeatureInfos.put(featureScId, status);
            }
            return existFeatureInfos;
        });
        Iterator<FeatureInfo> iterator = LicenseGrayData.iterator();
        ArrayList<Object[]> paramListInsert = new ArrayList<Object[]>(16);
        ArrayList<Object[]> paramListUpdate = new ArrayList<Object[]>(16);
        while (iterator.hasNext()) {
            Object[] param = new Object[4];
            FeatureInfo featureApplyInfo = iterator.next();
            Long featureScId = featureApplyInfo.getFeatureScId();
            String status = (String)existFeatureInfo.get(featureScId);
            String applyStatus = featureApplyInfo.getStatus();
            Date endDate = featureApplyInfo.getEndDate();
            Date applyDate = featureApplyInfo.getApplyDate();
            if (null == status) {
                param = new Object[]{DB.genGlobalLongId(), applyStatus, endDate, applyDate, featureScId, "1"};
                paramListInsert.add(param);
                continue;
            }
            if (!IS_IMPORTED_STATUS.equals(status)) {
                param[0] = applyStatus;
                param[1] = endDate;
                param[2] = applyDate;
                param[3] = featureScId;
                paramListUpdate.add(param);
                continue;
            }
            param[0] = IS_IMPORTED_STATUS;
            param[1] = endDate;
            param[2] = applyDate;
            param[3] = featureScId;
            paramListUpdate.add(param);
        }
        if (!CollectionUtils.isEmpty(paramListInsert)) {
            sql = "insert into t_lic_grayfeature (fid, fstatus, fgrayenddate, fapplicationdate,fschemeid,fremindersign) values(?,?,?,?,?,?)";
            DB.executeBatch((DBRoute)DBRoute.base, (String)sql, paramListInsert);
        }
        if (!CollectionUtils.isEmpty(paramListUpdate)) {
            sql = "update t_lic_grayfeature set fstatus = ?, fgrayenddate = ?, fapplicationdate = ? where fschemeid = ?";
            DB.executeBatch((DBRoute)DBRoute.base, (String)sql, paramListUpdate);
        }
        if (null != (dataEntityType = EntityMetadataCache.getDataEntityType((String)"lic_grayfeature"))) {
            BusinessDataServiceHelper.removeCache((DynamicObjectType)dataEntityType);
        }
    }

    private static Set<FeatureInfo> dataFilterAndCheck(JSONObject parseObject) {
        logger.info("LisenseGrayData: " + parseObject);
        if (null == parseObject) {
            logger.error("dataCheck --parseObject is null. return false");
            return Collections.emptySet();
        }
        Boolean success = parseObject.getBoolean(FEATURE_STATUS);
        if (null != success && success.booleanValue()) {
            Map<String, GrayFeatureScheme> allFeatureNumberInfos = LicenseGrayFeatureUtil.getAllFeatureNumberInfos();
            JSONArray data = (JSONArray)parseObject.get((Object)"data");
            Iterator iterator = data.iterator();
            HashSet<FeatureInfo> result = new HashSet<FeatureInfo>(5);
            String targetSoftwareCode = LicenseGrayUpdateStatusUtil.getTid();
            String targetProductCode = LicenseGrayUpdateStatusUtil.getProductCode();
            while (iterator.hasNext()) {
                JSONObject row = (JSONObject)iterator.next();
                String tid = String.valueOf(row.get((Object)"tid"));
                String productCode = String.valueOf(row.get((Object)"productCode"));
                logger.info("dataFilterAndCheck --tid: " + tid + " productCode: " + productCode);
                if (targetSoftwareCode.equals(tid) && targetProductCode.equals(productCode)) {
                    JSONArray featureInfos = row.getJSONArray(FEATURES);
                    Iterator featureInfosIte = featureInfos.iterator();
                    while (featureInfosIte.hasNext()) {
                        try {
                            JSONObject featureInfoRow = (JSONObject)featureInfosIte.next();
                            String number = featureInfoRow.getString(FEATURE_NUMBER);
                            GrayFeatureScheme grayFeatureScheme = allFeatureNumberInfos.get(number);
                            if (null != grayFeatureScheme && null != grayFeatureScheme.getId()) {
                                result.add(new FeatureInfo(number, featureInfoRow.getString(FEATURE_NAME), featureInfoRow.getString(FEATURE_STATUS), featureInfoRow.getString(FEATURE_STARTDATESTR), featureInfoRow.getString(FEATURE_ENDDATESTR), featureInfoRow.getString(APPLICATION_DATE), grayFeatureScheme.getId()));
                                continue;
                            }
                            logger.warn("LicenseGray--dataCheck : not find featureSc number is " + number + ".");
                        }
                        catch (Exception e) {
                            logger.warn("dataFilterAndCheck --" + e.getMessage(), (Throwable)e);
                        }
                    }
                    continue;
                }
                logger.warn("dataFilterAndCheck --filter dataTid: " + tid + ",tid: " + targetSoftwareCode + "dataProductCode: " + productCode + ",productCode: " + targetProductCode);
            }
            return result;
        }
        logger.error("updateGrayLicenseStatus fail. status: " + success + ", message: " + parseObject.get((Object)"message"));
        return Collections.emptySet();
    }

    public static void terminateGrayFeature() {
        Object[] param = new Object[]{"11", IS_IMPORTED_STATUS};
        String sql = "update t_lic_grayfeature set fstatus = ? where fstatus = ?";
        DB.execute((DBRoute)DBRoute.base, (String)sql, (Object[])param);
    }

    private static String getSoftwareCode() {
        Map productInfo = LicenseServiceHelper.getProductInfo();
        if (productInfo != null && productInfo.get("softwareCode") != null) {
            return (String)productInfo.get("softwareCode");
        }
        return "";
    }

    public static String getTid() {
        Map licenses = BusinessDataServiceHelper.loadFromCache((String)"lic_license", (String)"tid", null);
        if (CollectionUtils.isEmpty((Map)licenses)) {
            return "";
        }
        for (Map.Entry license : licenses.entrySet()) {
            String tid;
            DynamicObject value = (DynamicObject)license.getValue();
            if (null == license || StringUtils.isBlank((CharSequence)(tid = value.getString("tid")))) continue;
            return tid;
        }
        try {
            return LicenseGrayUpdateStatusUtil.getSoftwareCode();
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            return "";
        }
    }

    public static String getProductCode() {
        int modeType = LicenseServiceHelper.getModeType();
        if (2 == modeType || 4 == modeType) {
            return GALAXY;
        }
        return COSMIC;
    }

    private static class FeatureInfo {
        private String number;
        private String name;
        private String status;
        private Date startDate;
        private Date endDate;
        private Date applyDate;
        private Long featureScId;

        public FeatureInfo(String number, String name, String status, String startDate, String endDate, String applyDate, Long featureScId) {
            this.number = this.checkString(number);
            this.name = name;
            this.status = status;
            this.startDate = this.strToDateAndCheck(startDate);
            this.endDate = this.strToDateAndCheck(endDate);
            this.applyDate = this.strToDateAndCheck(applyDate);
            this.featureScId = this.checkLong(featureScId);
        }

        public String getNumber() {
            return this.number;
        }

        public String getName() {
            return this.name;
        }

        public String getStatus() {
            return this.status;
        }

        public Date getStartDate() {
            return this.startDate;
        }

        public Date getEndDate() {
            return this.endDate;
        }

        public Date getApplyDate() {
            return this.applyDate;
        }

        public Long getFeatureScId() {
            return this.featureScId;
        }

        private Long checkLong(Long longData) {
            if (null == longData) {
                throw new KDException("longData is null.");
            }
            return longData;
        }

        private String checkString(String str) {
            if (StringUtils.isBlank((CharSequence)str) || "null".equals(str) || "NULL".equals(str)) {
                throw new KDException("str is blankOrNull.");
            }
            return str;
        }

        private Date strToDateAndCheck(String dateStr) {
            if (StringUtils.isBlank((CharSequence)dateStr) || "null".equals(dateStr) || "NULL".equals(dateStr)) {
                logger.warn("strToDateAndCheck -- dateStr \uff1a" + dateStr);
                return null;
            }
            try {
                String dateStrAccurateRegex = "^\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2}$";
                Pattern patternAccurate = Pattern.compile(dateStrAccurateRegex);
                Matcher matcher = patternAccurate.matcher(dateStr);
                SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
                if (matcher.matches()) {
                    formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                }
                return formatter.parse(dateStr);
            }
            catch (Exception e) {
                logger.warn("strToDateAndCheck error. --dateStr : " + dateStr + " message: " + e.getMessage());
                return null;
            }
        }
    }
}

