/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.license.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.dlock.DLock;
import kd.bos.license.LocalCache.LicenseGroupLocalCache;
import kd.bos.license.bean.GroupVersionInfo;
import kd.bos.license.bean.LicenseGroupInfo;
import kd.bos.license.bean.LicenseGroupType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;

public class LicenseGroupUtil {
    private static final Log logger = LogFactory.getLog(LicenseGroupUtil.class);
    public static final String SPLIT = "_SPLIT_";
    private static final String ENTITY_LIC_GROUP = "lic_group";
    private static final String GROUP_VERSION = "group_version_entity";
    private static final String GROUP_ID = "id";
    private static final String GROUP_NUMBER = "number";
    private static final String GROUP_NAME = "name";
    private static final String GROUP_GROUPDES = "groupdes";
    private static final String GROUP_TYPE = "type";
    private static final String GROUP_ISVNUMBER = "isvprodnumber";
    private static final String GROUP_NAME_VERSION = "name_version";
    private static final String GROUP_GROUPDES_VERSION = "groupdes_version";
    private static final String GROUP_VERSION_VERSION = "version";

    private static Map<String, String> getLicenseGroup(String productVersion, String groupType, boolean isNumberKey) {
        boolean allGroupName;
        if (StringUtils.isBlank((CharSequence)productVersion)) {
            productVersion = LicenseServiceHelper.getProductVersion();
        }
        int modeType = LicenseServiceHelper.getModeType();
        boolean isKdxk = false;
        if (modeType == 2 || modeType == 4) {
            isKdxk = true;
        }
        HashMap<String, String> groupInfos = new HashMap<String, String>(128);
        Map<String, LicenseGroupInfo> allLicGroupInfos = LicenseGroupUtil.getAllVersionLicGroups();
        if (CollectionUtils.isEmpty(allLicGroupInfos)) {
            return groupInfos;
        }
        boolean bl = allGroupName = !"1".equals(groupType) && !"2".equals(groupType);
        if (null == productVersion) {
            productVersion = "7.0";
        }
        Map<String, String> allMemoryGroupName = LicenseGroupUtil.getAllMemoryGroupName(productVersion, groupType);
        for (Map.Entry<String, LicenseGroupInfo> allLicGroupInfoEntry : allLicGroupInfos.entrySet()) {
            List<GroupVersionInfo> groupVersionInfos;
            ILocaleString localName;
            String grouNumber;
            LicenseGroupInfo allLicGroupInfo = allLicGroupInfoEntry.getValue();
            String groupId = allLicGroupInfo.getId();
            String name = grouNumber = allLicGroupInfo.getNumber();
            if (!allGroupName) {
                LicenseGroupType type = allLicGroupInfo.getType();
                if ("1".equals(groupType) && LicenseGroupType.REUSER != type || "2".equals(groupType) && LicenseGroupType.FEATURE != type) continue;
            }
            if (null != (localName = allLicGroupInfo.getName())) {
                String string = StringUtils.isBlank((CharSequence)localName.getLocaleValue()) ? (StringUtils.isBlank((CharSequence)localName.getLocaleValue_zh_CN()) ? name : localName.getLocaleValue_zh_CN()) : (name = localName.getLocaleValue());
            }
            if (isKdxk) {
                groupInfos.put(isNumberKey ? grouNumber : groupId, name);
                continue;
            }
            String memoryName = allMemoryGroupName.get(groupId);
            if (!StringUtils.isBlank((CharSequence)memoryName)) {
                name = memoryName;
            }
            if (CollectionUtils.isEmpty(groupVersionInfos = allLicGroupInfo.getGroupVersionInfos())) {
                groupInfos.put(isNumberKey ? grouNumber : groupId, name);
                continue;
            }
            for (GroupVersionInfo info : groupVersionInfos) {
                ILocaleString nameVersion = info.getName_version();
                String version = info.getVersion();
                if (!productVersion.equals(version) || null == nameVersion) continue;
                name = StringUtils.isBlank((CharSequence)nameVersion.getLocaleValue()) ? (StringUtils.isBlank((CharSequence)nameVersion.getLocaleValue_zh_CN()) ? name : nameVersion.getLocaleValue_zh_CN()) : nameVersion.getLocaleValue();
            }
            groupInfos.put(isNumberKey ? grouNumber : groupId, name);
        }
        return groupInfos;
    }

    public static Map<String, String> getLicenseGroup(String groupType) {
        return LicenseGroupUtil.getLicenseGroup(LicenseServiceHelper.getProductVersion(), groupType, false);
    }

    public static Map<String, String> getLicenseGroup(String productVersion, String groupType) {
        return LicenseGroupUtil.getLicenseGroup(productVersion, groupType, false);
    }

    public static Map<String, String> getLicenseNumAndGroupInfo(String groupType) {
        return LicenseGroupUtil.getLicenseGroup(LicenseServiceHelper.getProductVersion(), groupType, true);
    }

    public static Map<String, String> getAllLicGroupNumberAndId() {
        HashMap<String, String> licGroupNumberAndId = new HashMap<String, String>(200);
        for (Map.Entry<String, LicenseGroupInfo> licGroupIdAndInfos : LicenseGroupUtil.getAllVersionLicGroups().entrySet()) {
            LicenseGroupInfo licGroupInfo = licGroupIdAndInfos.getValue();
            if (null == licGroupInfo) continue;
            licGroupNumberAndId.put(licGroupInfo.getNumber(), licGroupInfo.getId());
        }
        return licGroupNumberAndId;
    }

    public static Map<String, String> getAllLicGroupNumberAndIdFromDB() {
        LicenseGroupLocalCache.clear();
        return LicenseGroupUtil.getAllLicGroupNumberAndId();
    }

    public static Map<String, String> getLicenseGroupDes(String productVersion) {
        if (StringUtils.isBlank((CharSequence)productVersion)) {
            productVersion = LicenseServiceHelper.getProductVersion();
        }
        if (StringUtils.isBlank((CharSequence)productVersion)) {
            productVersion = "7.0";
        }
        HashMap<String, String> groupInfos = new HashMap<String, String>(128);
        Map<String, LicenseGroupInfo> allLicGroupInfos = LicenseGroupUtil.getAllVersionLicGroups();
        if (CollectionUtils.isEmpty(allLicGroupInfos)) {
            return groupInfos;
        }
        for (Map.Entry<String, LicenseGroupInfo> allLicGroupInfoEntry : allLicGroupInfos.entrySet()) {
            List<GroupVersionInfo> groupVersionInfos;
            LicenseGroupInfo allLicGroupInfo = allLicGroupInfoEntry.getValue();
            String groupId = allLicGroupInfo.getId();
            String groupDes = allLicGroupInfo.getGroupdes();
            if (!StringUtils.isBlank((CharSequence)groupDes)) {
                groupDes = LicenseGroupUtil.getHisGroupdes(groupDes);
            }
            if (!CollectionUtils.isEmpty(groupVersionInfos = allLicGroupInfo.getGroupVersionInfos())) {
                for (GroupVersionInfo info : groupVersionInfos) {
                    ILocaleString groupdesVersion = info.getGroupdes_version();
                    String version = info.getVersion();
                    if (!productVersion.equals(version) || null == groupdesVersion) continue;
                    groupDes = StringUtils.isBlank((CharSequence)groupdesVersion.getLocaleValue()) ? (StringUtils.isBlank((CharSequence)groupdesVersion.getLocaleValue_zh_CN()) ? groupDes : groupdesVersion.getLocaleValue_zh_CN()) : groupdesVersion.getLocaleValue();
                }
            }
            if (StringUtils.isBlank((CharSequence)groupDes)) continue;
            groupInfos.put(groupId, groupDes);
        }
        return groupInfos;
    }

    private static Map<String, String> getAllMemoryGroupName(String productVersion, String groupType) {
        HashMap<String, String> groupInfos = new HashMap<String, String>(128);
        switch (productVersion) {
            case "0.1": 
            case "1.0": 
            case "1.5": {
                groupInfos.putAll(LicenseGroupUtil.getLicenseGroupV1(groupType));
                break;
            }
            case "2.0": 
            case "0.2": 
            case "3.0": 
            case "0.3": {
                groupInfos.putAll(LicenseGroupUtil.getLicenseGroupV2(groupType));
                break;
            }
            case "4.0": {
                groupInfos.putAll(LicenseGroupUtil.getLicenseGroupV4(groupType));
                break;
            }
            case "5.0": {
                groupInfos.putAll(LicenseGroupUtil.getLicenseGroupV5(groupType));
                break;
            }
            default: {
                groupInfos.putAll(LicenseGroupUtil.getLicenseGroupV6(groupType));
            }
        }
        return groupInfos;
    }

    public static Map<String, LicenseGroupInfo> getLicenseGroupInfos(List<String> groupIds) {
        Map<String, LicenseGroupInfo> allLicGroupInfos;
        String productVersion;
        boolean isAllGroup = false;
        if (CollectionUtils.isEmpty(groupIds)) {
            isAllGroup = true;
        }
        if (StringUtils.isBlank((CharSequence)(productVersion = LicenseServiceHelper.getProductVersion()))) {
            productVersion = "7.0";
        }
        if (CollectionUtils.isEmpty(allLicGroupInfos = LicenseGroupUtil.getAllVersionLicGroups())) {
            return Collections.emptyMap();
        }
        HashMap<String, LicenseGroupInfo> result = new HashMap<String, LicenseGroupInfo>(16);
        for (Map.Entry<String, LicenseGroupInfo> allLicGroupInfoEntry : allLicGroupInfos.entrySet()) {
            String groupId = allLicGroupInfoEntry.getKey();
            if (!isAllGroup && !groupIds.contains(groupId)) continue;
            LicenseGroupInfo allLicGroupInfo = allLicGroupInfoEntry.getValue();
            LicenseGroupInfo licenseGroupInfo = new LicenseGroupInfo(allLicGroupInfo.getId(), allLicGroupInfo.getNumber(), allLicGroupInfo.getName(), allLicGroupInfo.getGroupdes(), allLicGroupInfo.getType(), allLicGroupInfo.getIsvprodnumber(), null);
            List<GroupVersionInfo> groupVersionInfos = allLicGroupInfo.getGroupVersionInfos();
            if (!CollectionUtils.isEmpty(groupVersionInfos)) {
                for (GroupVersionInfo info : groupVersionInfos) {
                    ILocaleString groupNameVersion = info.getName_version();
                    ILocaleString groupdesVersion = info.getGroupdes_version();
                    String version = info.getVersion();
                    if (productVersion.equals(version) && null != groupdesVersion) {
                        String groupDes;
                        Object object = StringUtils.isBlank((CharSequence)groupdesVersion.getLocaleValue()) ? (StringUtils.isBlank((CharSequence)groupdesVersion.getLocaleValue_zh_CN()) ? null : groupdesVersion.getLocaleValue_zh_CN()) : (groupDes = groupdesVersion.getLocaleValue());
                        if (!StringUtils.isBlank((CharSequence)groupDes)) {
                            licenseGroupInfo.setGroupdes(groupDes);
                        }
                    }
                    if (!productVersion.equals(version) || null == groupNameVersion) continue;
                    licenseGroupInfo.setName(groupNameVersion);
                }
            }
            result.put(groupId, licenseGroupInfo);
        }
        return result;
    }

    private static Map<String, LicenseGroupInfo> getAllVersionLicGroups() {
        Map<String, LicenseGroupInfo> allLicGroupInfo = LicenseGroupLocalCache.getAllLicGroupInfo();
        if (null == allLicGroupInfo) {
            try (DLock dLock = DLock.create((String)"getAllVersionLicGroups");){
                dLock.lock();
                if (null == allLicGroupInfo) {
                    allLicGroupInfo = LicenseGroupUtil.reloadAllLicGroups();
                }
            }
            catch (Exception e) {
                logger.error("getAllVersionLicGroups error.", (Throwable)e);
                allLicGroupInfo = Collections.emptyMap();
            }
        }
        return allLicGroupInfo;
    }

    private static Map<String, LicenseGroupInfo> reloadAllLicGroups() {
        HashMap<String, LicenseGroupInfo> allLicGroupInfo = new HashMap<String, LicenseGroupInfo>(16);
        DynamicObject[] licenseGroupInfos = BusinessDataServiceHelper.load((String)ENTITY_LIC_GROUP, (String)"id,number,groupdes,name,type,isvprodnumber,group_version_entity.version,group_version_entity.name_version,group_version_entity.groupdes_version", null);
        if (null == licenseGroupInfos) {
            return allLicGroupInfo;
        }
        for (DynamicObject licenseGroupInfo : licenseGroupInfos) {
            try {
                LicenseGroupType groupType = LicenseGroupType.FEATURE;
                if ("1".equals(licenseGroupInfo.getString(GROUP_TYPE))) {
                    groupType = LicenseGroupType.REUSER;
                }
                DynamicObjectCollection versionInfos = licenseGroupInfo.getDynamicObjectCollection(GROUP_VERSION);
                ArrayList<GroupVersionInfo> groupVersionInfos = null;
                if (null != versionInfos && !versionInfos.isEmpty()) {
                    groupVersionInfos = new ArrayList<GroupVersionInfo>(16);
                    for (DynamicObject versionInfo : versionInfos) {
                        groupVersionInfos.add(new GroupVersionInfo(versionInfo.getLocaleString(GROUP_NAME_VERSION), versionInfo.getLocaleString(GROUP_GROUPDES_VERSION), versionInfo.getString(GROUP_VERSION_VERSION)));
                    }
                }
                allLicGroupInfo.put(licenseGroupInfo.getString(GROUP_ID), new LicenseGroupInfo(licenseGroupInfo.getString(GROUP_ID), licenseGroupInfo.getString(GROUP_NUMBER), licenseGroupInfo.getLocaleString(GROUP_NAME), licenseGroupInfo.getString(GROUP_GROUPDES), groupType, licenseGroupInfo.getString(GROUP_ISVNUMBER), groupVersionInfos));
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
        }
        LicenseGroupLocalCache.putAllLicenseGroupInfo(allLicGroupInfo);
        return allLicGroupInfo;
    }

    private static String getHisGroupdes(String DBGroupdes) {
        switch (DBGroupdes) {
            case "1": {
                return ResManager.loadKDString((String)"\u6ce8\u518c\u7528\u6237", (String)"LicenseGroupUtil_282", (String)"bos-license-common", (Object[])new Object[0]);
            }
            case "2": {
                return ResManager.loadKDString((String)"\u7279\u6027", (String)"LicenseGroupUtil_277", (String)"bos-license-common", (Object[])new Object[0]);
            }
            case "3": {
                return ResManager.loadKDString((String)"\u5458\u5de5\u6570\u91cf", (String)"LicenseGroupUtil_278", (String)"bos-license-common", (Object[])new Object[0]);
            }
            case "4": {
                return ResManager.loadKDString((String)"\u7a0e\u53f7", (String)"LicenseGroupUtil_279", (String)"bos-license-common", (Object[])new Object[0]);
            }
            case "5": {
                return ResManager.loadKDString((String)"\u7b7e\u7f72\u6b21\u6570", (String)"LicenseGroupUtil_280", (String)"bos-license-common", (Object[])new Object[0]);
            }
            case "6": {
                return ResManager.loadKDString((String)"\u9879\u76ee\u6570\u91cf", (String)"LicenseGroupUtil_281", (String)"bos-license-common", (Object[])new Object[0]);
            }
        }
        return "";
    }

    public static Map<String, String> getHasBoughtRegLicGroup() {
        HashMap<String, String> licenseGroup = new HashMap(16);
        String sql = "SELECT g.FID ID, gl.fNAME NAME FROM T_LIC_GROUP g INNER JOIN T_LIC_GROUP_L gl ON ( gl.FID = g.FID AND gl.FLOCALEID = 'zh_CN' ) INNER JOIN T_LIC_LICENSEDETAIL ld ON ld.FGROUPID = g.fid INNER JOIN T_LIC_LICENSE l on l.fid = ld.fid WHERE g.FTYPE = '1' AND ld.ftotalCount > 0";
        try (DataSet dataSet = DB.queryDataSet((String)"LicenseGroupUtil.getHasBoughtRegLicGroup", (DBRoute)DBRoute.base, (String)sql);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                String licGroupId = row.getString("ID");
                String licGroupName = row.getString("NAME");
                licenseGroup.put(licGroupId, licGroupName);
            }
            Map<String, String> licenseGroupInfo = LicenseGroupUtil.getLicenseGroup(null);
            for (String key : licenseGroup.keySet()) {
                if (!licenseGroupInfo.containsKey(key)) continue;
                licenseGroup.put(key, licenseGroupInfo.get(key));
            }
        }
        catch (Exception e) {
            logger.error("LicenseGroupUtil.getHasBoughtRegLicGroup exception.", (Throwable)e);
            licenseGroup = LicenseGroupUtil.getLicenseGroup("1");
        }
        return licenseGroup;
    }

    public static Map<Long, String> getAllGroupIdAndNumber() {
        HashMap<Long, String> licGroupIdAndNum = new HashMap<Long, String>(200);
        for (Map.Entry<String, LicenseGroupInfo> licGroupIdAndInfos : LicenseGroupUtil.getAllVersionLicGroups().entrySet()) {
            LicenseGroupInfo licGroupInfo = licGroupIdAndInfos.getValue();
            if (null == licGroupInfo) continue;
            try {
                licGroupIdAndNum.put(Long.parseLong(licGroupInfo.getId()), licGroupInfo.getNumber());
            }
            catch (Exception e) {
                logger.error("exist licGroupId is not Long. id\uff1a" + licGroupInfo.getId());
            }
        }
        return licGroupIdAndNum;
    }

    public static Map<Long, String> getAllGroupIdAndName(String type) {
        Map<String, String> licenseGroup = LicenseGroupUtil.getLicenseGroup(type);
        if (CollectionUtils.isEmpty(licenseGroup)) {
            return Collections.EMPTY_MAP;
        }
        return licenseGroup.entrySet().stream().collect(Collectors.toMap(entry -> Long.parseLong((String)entry.getKey()), Map.Entry::getValue, (oldValue, newValue) -> oldValue, HashMap::new));
    }

    public static Map<String, String> getLicenseGroupV1(String groupType) {
        HashMap<String, String> licenseGroup = new HashMap<String, String>(18);
        licenseGroup.put("2", ResManager.loadKDString((String)"\u5458\u5de5\u670d\u52a1\u4e91\u5206\u7ec4", (String)"LicenseGroupUtil_0", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("3", ResManager.loadKDString((String)"\u5546\u65c5\u96c6\u6210\u5206\u7ec4", (String)"LicenseGroupUtil_1", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("4", ResManager.loadKDString((String)"\u8d22\u52a1\u4f1a\u8ba1\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_2", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("5", ResManager.loadKDString((String)"\u8d22\u52a1\u5171\u4eab\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_3", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("6", ResManager.loadKDString((String)"\u591a\u6838\u7b97\u4f53\u7cfb\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_4", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("7", ResManager.loadKDString((String)"\u591a\u7ec4\u7ec7\u6279\u91cf\u5904\u7406\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_5", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("8", ResManager.loadKDString((String)"\u667a\u80fdRPA\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_6", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("9", ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u534f\u540c\u4e91\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_7", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("10", ResManager.loadKDString((String)"\u6e20\u9053\u4e91\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_8", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("11", ResManager.loadKDString((String)"\u6d41\u7a0b\u670d\u52a1\u4e91\u5206\u7ec4", (String)"LicenseGroupUtil_9", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("12", ResManager.loadKDString((String)"\u6570\u636e\u670d\u52a1\u4e91\u5206\u7ec4", (String)"LicenseGroupUtil_10", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("13", ResManager.loadKDString((String)"\u5f00\u53d1\u670d\u52a1\u4e91\u5206\u7ec4", (String)"LicenseGroupUtil_11", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("14", ResManager.loadKDString((String)"\u94f6\u4f01\u670d\u52a1\u5206\u7ec4", (String)"LicenseGroupUtil_12", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("15", ResManager.loadKDString((String)"\u8eab\u4efd\u8ba4\u8bc1\u5206\u7ec4", (String)"LicenseGroupUtil_13", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("16", ResManager.loadKDString((String)"\u77ed\u4fe1\u670d\u52a1\u5206\u7ec4", (String)"LicenseGroupUtil_14", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("17", ResManager.loadKDString((String)"\u5730\u4ea7\u91c7\u8d2d\u4e91\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_15", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("18", ResManager.loadKDString((String)"CR\u9879\u76ee\u7ba1\u7406\u4e91\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_16", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("19", ResManager.loadKDString((String)"\u5730\u4ea7\u4f9b\u5e94\u5546\u95e8\u6237\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_17", (String)"bos-license-common", (Object[])new Object[0]));
        if ("1".equals(groupType)) {
            licenseGroup.remove("3");
            licenseGroup.remove("6");
            licenseGroup.remove("7");
            licenseGroup.remove("8");
            licenseGroup.remove("11");
            licenseGroup.remove("14");
            licenseGroup.remove("15");
            licenseGroup.remove("16");
            licenseGroup.remove("19");
        } else if ("2".equals(groupType)) {
            licenseGroup.remove("2");
            licenseGroup.remove("4");
            licenseGroup.remove("5");
            licenseGroup.remove("9");
            licenseGroup.remove("10");
            licenseGroup.remove("12");
            licenseGroup.remove("13");
            licenseGroup.remove("17");
            licenseGroup.remove("18");
        }
        return licenseGroup;
    }

    public static Map<String, String> getLicenseGroupV2(String groupType) {
        HashMap<String, String> licenseGroup = new HashMap<String, String>(62);
        licenseGroup.put("2", ResManager.loadKDString((String)"\u5458\u5de5\u670d\u52a1\u5168\u5458\u5e94\u7528\u5206\u7ec4", (String)"LicenseGroupUtil_54", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("3", ResManager.loadKDString((String)"\u5546\u65c5\u96c6\u6210\u5206\u7ec4", (String)"LicenseGroupUtil_1", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("4", ResManager.loadKDString((String)"\u8d22\u52a1\u4f1a\u8ba1\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_2", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("5", ResManager.loadKDString((String)"\u8d22\u52a1\u5171\u4eab\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_3", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("6", ResManager.loadKDString((String)"\u591a\u6838\u7b97\u4f53\u7cfb\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_4", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("7", ResManager.loadKDString((String)"\u8d22\u52a1\u591a\u7ec4\u7ec7\u6279\u91cf\u5904\u7406\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_19", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("8", ResManager.loadKDString((String)"\u667a\u80fdRPA\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_6", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("9", ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u534f\u540c\u4e91\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_7", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("10", ResManager.loadKDString((String)"\u6e20\u9053\u4e91\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_8", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("11", ResManager.loadKDString((String)"\u6d41\u7a0b\u670d\u52a1\u4e91\u5206\u7ec4", (String)"LicenseGroupUtil_9", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("12", ResManager.loadKDString((String)"\u6570\u636e\u670d\u52a1\u4e91\u5206\u7ec4", (String)"LicenseGroupUtil_10", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("13", ResManager.loadKDString((String)"\u5f00\u53d1\u670d\u52a1\u8fd0\u884c\u65f6\u72ec\u7acb\u7248\u5206\u7ec4", (String)"LicenseGroupUtil_20", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("14", ResManager.loadKDString((String)"\u94f6\u4f01\u670d\u52a1\u5206\u7ec4", (String)"LicenseGroupUtil_12", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("15", ResManager.loadKDString((String)"\u8eab\u4efd\u8ba4\u8bc1\u5206\u7ec4", (String)"LicenseGroupUtil_13", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("16", ResManager.loadKDString((String)"\u77ed\u4fe1\u670d\u52a1\u5206\u7ec4", (String)"LicenseGroupUtil_14", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("17", ResManager.loadKDString((String)"\u5730\u4ea7\u9879\u76ee\u4e91\u901a\u7528\u7528\u6237\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_55", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("18", ResManager.loadKDString((String)"\u5efa\u7b51\u9879\u76ee\u4e91\u901a\u7528\u7528\u6237\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_21", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("19", ResManager.loadKDString((String)"\u5730\u4ea7\u4f9b\u5e94\u5546\u95e8\u6237\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_17", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("21", ResManager.loadKDString((String)"AI\u8d22\u52a1\u670d\u52a1\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_22", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("23", ResManager.loadKDString((String)"\u4f01\u4e1a\u7ee9\u6548\u4e91\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_23", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("24", ResManager.loadKDString((String)"\u9884\u7b97\u63a7\u5236\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_24", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("25", ResManager.loadKDString((String)"\u4f9b\u5e94\u94fe\u4e91\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_25", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("26", ResManager.loadKDString((String)"\u8fde\u63a5\u4eac\u4e1c\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_26", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("27", ResManager.loadKDString((String)"\u91c7\u8d2d\u5546\u57ce\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_27", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("28", ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u95e8\u6237\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_28", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("29", ResManager.loadKDString((String)"\u4fc3\u9500\u7ba1\u7406\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_29", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("30", ResManager.loadKDString((String)"\u8fd4\u5229\u7ba1\u7406\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_30", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("34", ResManager.loadKDString((String)"\u57fa\u7840\u7a0e\u52a1\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_31", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("38", ResManager.loadKDString((String)"\u9879\u76ee\u4e91\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_32", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("39", ResManager.loadKDString((String)"\u5f00\u53d1\u670d\u52a1\u8fd0\u884c\u65f6\u878d\u5408\u7248\u5168\u5458\u5e94\u7528\u5206\u7ec4", (String)"LicenseGroupUtil_33", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("40", ResManager.loadKDString((String)"\u5f00\u53d1\u670d\u52a1\u8fd0\u884c\u65f6\u878d\u5408\u7248\u4e13\u4e1a\u5e94\u7528\u5206\u7ec4", (String)"LicenseGroupUtil_34", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("41", ResManager.loadKDString((String)"\u96c6\u6210\u670d\u52a1\u4e91\u5206\u7ec4", (String)"LicenseGroupUtil_35", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("44", ResManager.loadKDString((String)"\u4f9b\u5e94\u94fe\u591a\u7ec4\u7ec7\u6279\u91cf\u5904\u7406\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_36", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("186", ResManager.loadKDString((String)"\u6ce8\u518c\u7528\u6237\u4fe1\u606f\u7531\u4ea7\u54c1\u7aef\u5b9a\u671f\u4e0a\u4f20\u5206\u7ec4", (String)"LicenseGroupUtil_37", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("187", ResManager.loadKDString((String)"\u6ce8\u518c\u7528\u6237\u4fe1\u606f\u4e0d\u4e0a\u4f20\u5206\u7ec4", (String)"LicenseGroupUtil_38", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("96", ResManager.loadKDString((String)"\u4f1a\u8ba1\u7535\u5b50\u6863\u6848\u5f52\u6863\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_39", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("87", ResManager.loadKDString((String)"\u5176\u4ed6\u7a0e\u79cd\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_40", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("88", ResManager.loadKDString((String)"\u7a0e\u52a1\u7ba1\u63a7\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_41", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("89", ResManager.loadKDString((String)"\u8d44\u91d1\u4e91\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_42", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("93", ResManager.loadKDString((String)"\u8de8\u5883\u94f6\u4f01\u652f\u4ed8\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_43", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("94", ResManager.loadKDString((String)"\u8d44\u91d1\u4e91\u591a\u7ec4\u7ec7\u6279\u91cf\u5904\u7406\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_44", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("99", ResManager.loadKDString((String)"\u8425\u9500\u8d39\u7528\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_45", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("66", ResManager.loadKDString((String)"\u5efa\u7b51\u62db\u6807\u7ba1\u7406\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_46", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("67", ResManager.loadKDString((String)"\u5efa\u7b51\u4f9b\u5e94\u5546\u95e8\u6237\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_47", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("68", ResManager.loadKDString((String)"\u667a\u80fd\u6570\u636e\u6d1e\u5bdf\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_48", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("48", ResManager.loadKDString((String)"\u5f00\u53d1\u670d\u52a1\u8fd0\u884c\u65f6\u878d\u5408\u7248\u5916\u90e8\u5e94\u7528\u5206\u7ec4", (String)"LicenseGroupUtil_49", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("58", ResManager.loadKDString((String)"\u5bf9\u8bdd\u673a\u5668\u4eba\u5e73\u53f0\u5206\u7ec4", (String)"LicenseGroupUtil_50", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("59", ResManager.loadKDString((String)"\u5bf9\u8bdd\u673a\u5668\u4eba\u5e73\u53f0\u8fd0\u884c\u65f6\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_51", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("60", ResManager.loadKDString((String)"\u82f1\u6587\u8bed\u8a00\u5305", (String)"LicenseGroupUtil_52", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("61", ResManager.loadKDString((String)"\u7e41\u4f53\u8bed\u8a00\u5305", (String)"LicenseGroupUtil_53", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("101", ResManager.loadKDString((String)"\u5ba1\u8ba1\u6587\u4ef6\u5bfc\u51fa\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_56", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("102", ResManager.loadKDString((String)"\u65b0\u79df\u8d41\u51c6\u5219\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_57", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("104", ResManager.loadKDString((String)"\u7ba1\u7406\u4f1a\u8ba1\u4e91\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_58", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("106", ResManager.loadKDString((String)"\u7535\u5b50\u56de\u5355\u670d\u52a1\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_59", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("111", ResManager.loadKDString((String)"\u751f\u4ea7\u5236\u9020\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_60", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("116", ResManager.loadKDString((String)"\u8f66\u95f4\u6267\u884c\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_61", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("121", ResManager.loadKDString((String)"\u5730\u4ea7\u62db\u6807\u667a\u80fd\u6e05\u5355\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_62", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("122", ResManager.loadKDString((String)"\u5730\u4ea7\u5408\u540c\u667a\u80fd\u6e05\u5355\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_63", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("123", ResManager.loadKDString((String)"\u5730\u4ea7\u6750\u6599\u516c\u53f8\u91c7\u8d2d\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_64", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("124", ResManager.loadKDString((String)"\u5730\u4ea7\u4f9b\u5e94\u5546\u5fae\u95e8\u6237\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_65", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("126", ResManager.loadKDString((String)"\u89c6\u89c9\u8bc6\u522b\u670d\u52a1\u5206\u7ec4", (String)"LicenseGroupUtil_66", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("127", ResManager.loadKDString((String)"\u89c6\u89c9\u8bc6\u522b\u670d\u52a1\u8fd0\u884c\u65f6\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_67", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("117", ResManager.loadKDString((String)"\u5730\u4ea7\u91c7\u8d2d\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_68", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("118", ResManager.loadKDString((String)"\u5730\u4ea7\u6210\u672c\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_69", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("120", ResManager.loadKDString((String)"\u5730\u4ea7\u8ba1\u5212\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_70", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("208", ResManager.loadKDString((String)"\u5730\u4ea7\u9879\u76ee\u4e91\u901a\u7528\u7528\u6237\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_55", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("203", ResManager.loadKDString((String)"\u7269\u4e1a\u6536\u8d39\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_71", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("204", ResManager.loadKDString((String)"\u8d44\u4ea7\u8fd0\u8425\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_72", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("222", ResManager.loadKDString((String)"\u5efa\u7b51\u4f9b\u5e94\u5546\u5fae\u95e8\u6237\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_73", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("223", ResManager.loadKDString((String)"\u5efa\u7b51\u5408\u540c\u5355\u7528\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_74", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("224", ResManager.loadKDString((String)"\u5efa\u7b51\u8ba1\u5212\u5355\u7528\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_75", (String)"bos-license-common", (Object[])new Object[0]));
        if ("1".equals(groupType)) {
            licenseGroup.remove("3");
            licenseGroup.remove("6");
            licenseGroup.remove("7");
            licenseGroup.remove("8");
            licenseGroup.remove("11");
            licenseGroup.remove("14");
            licenseGroup.remove("15");
            licenseGroup.remove("16");
            licenseGroup.remove("19");
            licenseGroup.remove("21");
            licenseGroup.remove("24");
            licenseGroup.remove("26");
            licenseGroup.remove("27");
            licenseGroup.remove("28");
            licenseGroup.remove("29");
            licenseGroup.remove("30");
            licenseGroup.remove("34");
            licenseGroup.remove("41");
            licenseGroup.remove("44");
            licenseGroup.remove("186");
            licenseGroup.remove("187");
            licenseGroup.remove("96");
            licenseGroup.remove("87");
            licenseGroup.remove("88");
            licenseGroup.remove("93");
            licenseGroup.remove("94");
            licenseGroup.remove("99");
            licenseGroup.remove("66");
            licenseGroup.remove("67");
            licenseGroup.remove("68");
            licenseGroup.remove("58");
            licenseGroup.remove("59");
            licenseGroup.remove("60");
            licenseGroup.remove("61");
            licenseGroup.remove("101");
            licenseGroup.remove("102");
            licenseGroup.remove("106");
            licenseGroup.remove("121");
            licenseGroup.remove("122");
            licenseGroup.remove("123");
            licenseGroup.remove("124");
            licenseGroup.remove("126");
            licenseGroup.remove("127");
            licenseGroup.remove("222");
        } else if ("2".equals(groupType)) {
            licenseGroup.remove("2");
            licenseGroup.remove("4");
            licenseGroup.remove("5");
            licenseGroup.remove("9");
            licenseGroup.remove("10");
            licenseGroup.remove("12");
            licenseGroup.remove("13");
            licenseGroup.remove("17");
            licenseGroup.remove("18");
            licenseGroup.remove("23");
            licenseGroup.remove("25");
            licenseGroup.remove("38");
            licenseGroup.remove("39");
            licenseGroup.remove("40");
            licenseGroup.remove("48");
            licenseGroup.remove("89");
            licenseGroup.remove("104");
            licenseGroup.remove("111");
            licenseGroup.remove("116");
            licenseGroup.remove("117");
            licenseGroup.remove("118");
            licenseGroup.remove("120");
            licenseGroup.remove("203");
            licenseGroup.remove("204");
            licenseGroup.remove("208");
            licenseGroup.remove("223");
            licenseGroup.remove("224");
        }
        return licenseGroup;
    }

    public static Map<String, String> getLicenseGroupV4(String groupType) {
        HashMap<String, String> licenseGroup = new HashMap<String, String>(62);
        licenseGroup.put("2", ResManager.loadKDString((String)"\u5458\u5de5\u670d\u52a1\u4e91\u5206\u7ec4", (String)"LicenseGroupUtil_0", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("3", ResManager.loadKDString((String)"\u5546\u65c5\u96c6\u6210\u5206\u7ec4", (String)"LicenseGroupUtil_1", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("4", ResManager.loadKDString((String)"\u8d22\u52a1\u4f1a\u8ba1\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_2", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("5", ResManager.loadKDString((String)"\u8d22\u52a1\u5171\u4eab\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_3", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("6", ResManager.loadKDString((String)"\u591a\u6838\u7b97\u4f53\u7cfb\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_4", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("7", ResManager.loadKDString((String)"\u8d22\u52a1\u591a\u7ec4\u7ec7\u6279\u91cf\u5904\u7406\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_19", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("8", ResManager.loadKDString((String)"\u667a\u80fd\u6838\u7b97\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_76", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("9", ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u534f\u540c\u4e91\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_7", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("10", ResManager.loadKDString((String)"\u6e20\u9053\u4e91\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_8", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("11", ResManager.loadKDString((String)"\u6d41\u7a0b\u670d\u52a1\u4e91\u5206\u7ec4", (String)"LicenseGroupUtil_9", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("12", ResManager.loadKDString((String)"\u6570\u636e\u670d\u52a1\u4e91\u5206\u7ec4", (String)"LicenseGroupUtil_10", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("13", ResManager.loadKDString((String)"\u5f00\u53d1\u670d\u52a1\u8fd0\u884c\u65f6-\u72ec\u7acb\u7248", (String)"LicenseGroupUtil_77", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("14", ResManager.loadKDString((String)"\u94f6\u4f01\u670d\u52a1", (String)"LicenseGroupUtil_78", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("15", ResManager.loadKDString((String)"\u8eab\u4efd\u8ba4\u8bc1\u5206\u7ec4", (String)"LicenseGroupUtil_13", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("16", ResManager.loadKDString((String)"\u77ed\u4fe1\u670d\u52a1\u5206\u7ec4", (String)"LicenseGroupUtil_14", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("17", ResManager.loadKDString((String)"\u5730\u4ea7\u9879\u76ee\u4e91\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_123", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("18", ResManager.loadKDString((String)"\u5efa\u7b51\u9879\u76ee\u4e91\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_124", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("19", ResManager.loadKDString((String)"\u5730\u4ea7\u4f9b\u5e94\u5546\u95e8\u6237\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_17", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("21", ResManager.loadKDString((String)"AI\u8d22\u52a1\u670d\u52a1\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_22", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("23", ResManager.loadKDString((String)"\u4f01\u4e1a\u7ee9\u6548\u4e91\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_23", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("24", ResManager.loadKDString((String)"\u9884\u7b97\u63a7\u5236\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_24", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("25", ResManager.loadKDString((String)"\u4f9b\u5e94\u94fe\u4e91\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_25", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("26", ResManager.loadKDString((String)"\u8fde\u63a5\u4eac\u4e1c\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_26", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("27", ResManager.loadKDString((String)"\u91c7\u8d2d\u5546\u57ce\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_27", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("28", ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u95e8\u6237\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_28", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("29", ResManager.loadKDString((String)"\u4fc3\u9500\u7ba1\u7406\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_29", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("30", ResManager.loadKDString((String)"\u8fd4\u5229\u7ba1\u7406\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_30", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("34", ResManager.loadKDString((String)"\u57fa\u7840\u7a0e\u52a1\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_31", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("38", ResManager.loadKDString((String)"\u9879\u76ee\u4e91\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_32", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("39", ResManager.loadKDString((String)"\u5f00\u53d1\u670d\u52a1\u8fd0\u884c\u65f6\u878d\u5408\u7248\u5168\u5458\u5e94\u7528\u5206\u7ec4", (String)"LicenseGroupUtil_33", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("40", ResManager.loadKDString((String)"\u5f00\u53d1\u670d\u52a1\u8fd0\u884c\u65f6\u878d\u5408\u7248\u4e13\u4e1a\u5e94\u7528\u5206\u7ec4", (String)"LicenseGroupUtil_34", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("41", ResManager.loadKDString((String)"\u96c6\u6210\u670d\u52a1\u4e91\u5206\u7ec4", (String)"LicenseGroupUtil_35", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("44", ResManager.loadKDString((String)"\u591a\u7ec4\u7ec7\u6279\u91cf\u5904\u7406", (String)"LicenseGroupUtil_79", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("186", ResManager.loadKDString((String)"\u6ce8\u518c\u7528\u6237\u4fe1\u606f\u7531\u4ea7\u54c1\u7aef\u5b9a\u671f\u4e0a\u4f20\u5206\u7ec4", (String)"LicenseGroupUtil_37", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("187", ResManager.loadKDString((String)"\u6ce8\u518c\u7528\u6237\u4fe1\u606f\u4e0d\u4e0a\u4f20\u5206\u7ec4", (String)"LicenseGroupUtil_38", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("96", ResManager.loadKDString((String)"\u4f1a\u8ba1\u7535\u5b50\u6863\u6848\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_80", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("87", ResManager.loadKDString((String)"\u5176\u4ed6\u7a0e\u79cd\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_40", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("88", ResManager.loadKDString((String)"\u7a0e\u52a1\u7ba1\u63a7\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_41", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("89", ResManager.loadKDString((String)"\u8d44\u91d1\u4e91\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_42", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("93", ResManager.loadKDString((String)"\u8de8\u5883\u94f6\u4f01\u652f\u4ed8\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_43", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("94", ResManager.loadKDString((String)"\u591a\u7ec4\u7ec7\u6279\u91cf\u5904\u7406", (String)"LicenseGroupUtil_79", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("99", ResManager.loadKDString((String)"\u8425\u9500\u8d39\u7528\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_45", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("66", ResManager.loadKDString((String)"\u5efa\u7b51\u62db\u6807\u7ba1\u7406\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_46", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("67", ResManager.loadKDString((String)"\u5efa\u7b51\u4f9b\u5e94\u5546\u95e8\u6237\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_47", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("68", ResManager.loadKDString((String)"\u667a\u80fd\u6570\u636e\u6d1e\u5bdf\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_48", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("48", ResManager.loadKDString((String)"\u5f00\u53d1\u670d\u52a1\u8fd0\u884c\u65f6\u878d\u5408\u7248\u5916\u90e8\u5e94\u7528\u5206\u7ec4", (String)"LicenseGroupUtil_49", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("58", ResManager.loadKDString((String)"\u5bf9\u8bdd\u673a\u5668\u4eba\u5e73\u53f0\u5206\u7ec4", (String)"LicenseGroupUtil_50", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("59", ResManager.loadKDString((String)"\u5bf9\u8bdd\u673a\u5668\u4eba\u5e73\u53f0\u8fd0\u884c\u65f6\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_51", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("60", ResManager.loadKDString((String)"\u82f1\u6587\u8bed\u8a00\u5305", (String)"LicenseGroupUtil_52", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("61", ResManager.loadKDString((String)"\u7e41\u4f53\u8bed\u8a00\u5305", (String)"LicenseGroupUtil_53", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("101", ResManager.loadKDString((String)"\u5ba1\u8ba1\u6587\u4ef6\u5bfc\u51fa\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_56", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("102", ResManager.loadKDString((String)"\u65b0\u79df\u8d41\u51c6\u5219\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_57", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("104", ResManager.loadKDString((String)"\u7ba1\u7406\u4f1a\u8ba1\u4e91\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_58", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("106", ResManager.loadKDString((String)"\u7535\u5b50\u56de\u5355\u670d\u52a1\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_59", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("111", ResManager.loadKDString((String)"\u751f\u4ea7\u5236\u9020\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_60", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("116", ResManager.loadKDString((String)"\u8f66\u95f4\u6267\u884c\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_61", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("121", ResManager.loadKDString((String)"\u5730\u4ea7\u62db\u6807\u667a\u80fd\u6e05\u5355\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_62", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("122", ResManager.loadKDString((String)"\u5730\u4ea7\u5408\u540c\u667a\u80fd\u6e05\u5355\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_63", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("123", ResManager.loadKDString((String)"\u5730\u4ea7\u6750\u6599\u516c\u53f8\u91c7\u8d2d\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_64", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("124", ResManager.loadKDString((String)"\u5730\u4ea7\u4f9b\u5e94\u5546\u5fae\u95e8\u6237\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_65", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("126", ResManager.loadKDString((String)"\u89c6\u89c9\u8bc6\u522b\u670d\u52a1\u5206\u7ec4", (String)"LicenseGroupUtil_66", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("127", ResManager.loadKDString((String)"\u89c6\u89c9\u8bc6\u522b\u670d\u52a1\u8fd0\u884c\u65f6\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_67", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("117", ResManager.loadKDString((String)"\u5730\u4ea7\u91c7\u8d2d\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_68", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("118", ResManager.loadKDString((String)"\u5730\u4ea7\u6210\u672c\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_69", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("120", ResManager.loadKDString((String)"\u5730\u4ea7\u8ba1\u5212\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_70", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("203", ResManager.loadKDString((String)"\u7269\u4e1a\u6536\u8d39\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_71", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("204", ResManager.loadKDString((String)"\u8d44\u4ea7\u8fd0\u8425\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_72", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("222", ResManager.loadKDString((String)"\u5efa\u7b51\u4f9b\u5e94\u5546\u5fae\u95e8\u6237\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_73", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("223", ResManager.loadKDString((String)"\u5efa\u7b51\u5408\u540c\u5355\u7528\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_74", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("224", ResManager.loadKDString((String)"\u5efa\u7b51\u8ba1\u5212\u5355\u7528\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_75", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("301", ResManager.loadKDString((String)"\u5236\u9020\u534f\u540c\u4e91\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_104", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("302", ResManager.loadKDString((String)"\u751f\u4ea7\u76d1\u63a7", (String)"LicenseGroupUtil_105", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("303", ResManager.loadKDString((String)"\u4ea7\u54c1\u670d\u52a1", (String)"LicenseGroupUtil_106", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("304", ResManager.loadKDString((String)"\u7269\u8054\u7f51\u5e73\u53f0\u4e91\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_107", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("401", ResManager.loadKDString((String)"\u8d22\u52a1+\u4f9b\u5e94\u94fe+\u5236\u9020\u5206\u7ec4", (String)"LicenseGroupUtil_81", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("402", ResManager.loadKDString((String)"\u7ed3\u8d26\u76d1\u63a7\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_82", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("403", ResManager.loadKDString((String)"\u94f6\u4f01CA", (String)"LicenseGroupUtil_83", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("404", ResManager.loadKDString((String)"\u5f71\u50cf\u96c6\u6210", (String)"LicenseGroupUtil_84", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("406", ResManager.loadKDString((String)"\u7a0e\u52a1\u4e91\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_85", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("407", ResManager.loadKDString((String)"\u8ba1\u7a0e\u5e95\u7a3f\u670d\u52a1", (String)"LicenseGroupUtil_86", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("408", ResManager.loadKDString((String)"\u51c6\u5165\u534f\u540c", (String)"LicenseGroupUtil_87", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("409", ResManager.loadKDString((String)"\u62a5\u4ef7\u4e0e\u7ade\u4ef7", (String)"LicenseGroupUtil_88", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("410", ResManager.loadKDString((String)"\u6295\u6807\u7ba1\u7406", (String)"LicenseGroupUtil_89", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("411", ResManager.loadKDString((String)"\u5bfb\u6e90\u534f\u540c", (String)"LicenseGroupUtil_90", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("412", ResManager.loadKDString((String)"\u4f9b\u5e94\u534f\u540c\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_91", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("413", ResManager.loadKDString((String)"\u8fde\u63a5\u82cf\u5b81", (String)"LicenseGroupUtil_92", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("414", ResManager.loadKDString((String)"\u8fde\u63a5\u897f\u57df", (String)"LicenseGroupUtil_93", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("415", ResManager.loadKDString((String)"\u8fde\u63a5\u6668\u5149", (String)"LicenseGroupUtil_94", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("416", ResManager.loadKDString((String)"\u94f6\u4f01\u4e92\u8054\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_95", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("417", ResManager.loadKDString((String)"\u79bb\u7ebf\u5f00\u53d1\u5206\u7ec4", (String)"LicenseGroupUtil_96", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("418", ResManager.loadKDString((String)"\u5b9e\u65f6\u5f00\u53d1\u5206\u7ec4", (String)"LicenseGroupUtil_97", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("419", ResManager.loadKDString((String)"\u7b97\u6cd5\u5f00\u53d1\u5206\u7ec4", (String)"LicenseGroupUtil_98", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("420", ResManager.loadKDString((String)"\u6570\u636e\u670d\u52a1\u5206\u7ec4", (String)"LicenseGroupUtil_99", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("421", ResManager.loadKDString((String)"\u6570\u636e\u8d28\u91cf\u5206\u7ec4", (String)"LicenseGroupUtil_100", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("422", ResManager.loadKDString((String)"\u6570\u636e\u5730\u56fe\u5206\u7ec4", (String)"LicenseGroupUtil_101", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("423", ResManager.loadKDString((String)"\u6807\u7b7e\u4e2d\u5fc3\u5206\u7ec4", (String)"LicenseGroupUtil_102", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("252", ResManager.loadKDString((String)"\u5f00\u53d1\u670d\u52a1\u8fd0\u884c\u65f6-\u878d\u5408\u7248", (String)"LicenseGroupUtil_103", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("424", ResManager.loadKDString((String)"\u94a2\u94c1\u4e91\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_108", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("425", ResManager.loadKDString((String)"\u94a2\u94c1\u4e91\u7279\u6027", (String)"LicenseGroupUtil_109", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("426", ResManager.loadKDString((String)"\u6c7d\u8f66\u9500\u552e\u4e91\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_110", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("427", ResManager.loadKDString((String)"\u5171\u4eab\u6d1e\u5bdf\u8f7b\u5e94\u7528\u5206\u7ec4", (String)"LicenseGroupUtil_111", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("428", ResManager.loadKDString((String)"\u667a\u80fd\u5ba2\u670d\u5206\u7ec4", (String)"LicenseGroupUtil_112", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("429", ResManager.loadKDString((String)"\u6ee1\u610f\u5ea6\u7ba1\u7406\u5206\u7ec4", (String)"LicenseGroupUtil_113", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("430", ResManager.loadKDString((String)"\u8d44\u91d1\u6d1e\u5bdf\u8f7b\u5e94\u7528\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_114", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("431", ResManager.loadKDString((String)"\u6536\u6b3e\u8ba4\u9886\u8f7b\u5e94\u7528\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_115", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("432", ResManager.loadKDString((String)"\u79fb\u52a8\u4f9b\u5e94\u5546\u95e8\u6237", (String)"LicenseGroupUtil_116", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("433", ResManager.loadKDString((String)"\u5f00\u7968\u7ba1\u7406\uff08\u5355\u673a\u7248\u7eb8\u7535\u4e00\u4f53\uff09", (String)"LicenseGroupUtil_117", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("434", ResManager.loadKDString((String)"\u5f00\u7968\u7ba1\u7406\uff08\u7535\u5b50\u6258\u7ba1\u53d1\u7968\uff09", (String)"LicenseGroupUtil_118", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("435", ResManager.loadKDString((String)"\u53d1\u7968\u4e91\u6536\u7968\u7279\u6027\u5206\u7ec4", (String)"LicenseGroupUtil_119", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("436", ResManager.loadKDString((String)"\u53d1\u7968\u4e91\u5f00\u7968\u7279\u6027\u5206\u7ec4", (String)"LicenseGroupUtil_120", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("437", ResManager.loadKDString((String)"\u53d1\u7968\u4e91\u5f00\u7968\u77ed\u4fe1\u8bb8\u53ef", (String)"LicenseGroupUtil_121", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("438", ResManager.loadKDString((String)"\u53d1\u7968\u4e91\u6536\u7968\u53d1\u7968\u6821\u9a8c\u6d41\u91cf\u5305", (String)"LicenseGroupUtil_122", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("441", ResManager.loadKDString((String)"\u6d41\u7a0b\u670d\u52a1\u4e91\u6d41\u91cf\u7248\u5206\u7ec4", (String)"LicenseGroupUtil_126", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("442", ResManager.loadKDString((String)"\u8f7b\u62a5\u8868", (String)"LicenseGroupUtil_127", (String)"bos-license-common", (Object[])new Object[0]));
        if ("1".equals(groupType)) {
            licenseGroup.remove("3");
            licenseGroup.remove("6");
            licenseGroup.remove("7");
            licenseGroup.remove("8");
            licenseGroup.remove("11");
            licenseGroup.remove("14");
            licenseGroup.remove("15");
            licenseGroup.remove("16");
            licenseGroup.remove("19");
            licenseGroup.remove("21");
            licenseGroup.remove("24");
            licenseGroup.remove("26");
            licenseGroup.remove("27");
            licenseGroup.remove("28");
            licenseGroup.remove("29");
            licenseGroup.remove("30");
            licenseGroup.remove("34");
            licenseGroup.remove("41");
            licenseGroup.remove("44");
            licenseGroup.remove("186");
            licenseGroup.remove("187");
            licenseGroup.remove("96");
            licenseGroup.remove("87");
            licenseGroup.remove("88");
            licenseGroup.remove("93");
            licenseGroup.remove("94");
            licenseGroup.remove("99");
            licenseGroup.remove("66");
            licenseGroup.remove("67");
            licenseGroup.remove("68");
            licenseGroup.remove("58");
            licenseGroup.remove("59");
            licenseGroup.remove("60");
            licenseGroup.remove("61");
            licenseGroup.remove("101");
            licenseGroup.remove("102");
            licenseGroup.remove("106");
            licenseGroup.remove("121");
            licenseGroup.remove("122");
            licenseGroup.remove("123");
            licenseGroup.remove("124");
            licenseGroup.remove("126");
            licenseGroup.remove("127");
            licenseGroup.remove("222");
            licenseGroup.remove("402");
            licenseGroup.remove("403");
            licenseGroup.remove("404");
            licenseGroup.remove("406");
            licenseGroup.remove("407");
            licenseGroup.remove("408");
            licenseGroup.remove("409");
            licenseGroup.remove("410");
            licenseGroup.remove("411");
            licenseGroup.remove("413");
            licenseGroup.remove("414");
            licenseGroup.remove("415");
            licenseGroup.remove("416");
            licenseGroup.remove("417");
            licenseGroup.remove("418");
            licenseGroup.remove("419");
            licenseGroup.remove("420");
            licenseGroup.remove("421");
            licenseGroup.remove("422");
            licenseGroup.remove("423");
            licenseGroup.remove("252");
            licenseGroup.remove("425");
            licenseGroup.remove("427");
            licenseGroup.remove("428");
            licenseGroup.remove("429");
            licenseGroup.remove("430");
            licenseGroup.remove("431");
            licenseGroup.remove("432");
            licenseGroup.remove("433");
            licenseGroup.remove("434");
            licenseGroup.remove("435");
            licenseGroup.remove("436");
            licenseGroup.remove("437");
            licenseGroup.remove("438");
            licenseGroup.remove("441");
        } else if ("2".equals(groupType)) {
            licenseGroup.remove("2");
            licenseGroup.remove("4");
            licenseGroup.remove("5");
            licenseGroup.remove("9");
            licenseGroup.remove("10");
            licenseGroup.remove("12");
            licenseGroup.remove("13");
            licenseGroup.remove("17");
            licenseGroup.remove("18");
            licenseGroup.remove("23");
            licenseGroup.remove("25");
            licenseGroup.remove("38");
            licenseGroup.remove("39");
            licenseGroup.remove("40");
            licenseGroup.remove("48");
            licenseGroup.remove("89");
            licenseGroup.remove("104");
            licenseGroup.remove("111");
            licenseGroup.remove("116");
            licenseGroup.remove("117");
            licenseGroup.remove("118");
            licenseGroup.remove("120");
            licenseGroup.remove("203");
            licenseGroup.remove("204");
            licenseGroup.remove("223");
            licenseGroup.remove("224");
            licenseGroup.remove("301");
            licenseGroup.remove("302");
            licenseGroup.remove("303");
            licenseGroup.remove("304");
            licenseGroup.remove("401");
            licenseGroup.remove("412");
            licenseGroup.remove("424");
            licenseGroup.remove("426");
            licenseGroup.remove("442");
        }
        return licenseGroup;
    }

    public static Map<String, String> getLicenseGroupV5(String groupType) {
        Map<String, String> licenseGroupV4 = LicenseGroupUtil.getLicenseGroupV4(groupType);
        LicenseGroupUtil.addLicenseGroupChangV5(licenseGroupV4, groupType);
        return licenseGroupV4;
    }

    public static Map<String, String> getLicenseGroupV6(String groupType) {
        Map<String, String> licenseGroupV6 = LicenseGroupUtil.getLicenseGroupV5(groupType);
        LicenseGroupUtil.addLicenseGroupChangV6(licenseGroupV6, groupType);
        return licenseGroupV6;
    }

    private static void addLicenseGroupChangV6(Map<String, String> licenseGroupV6, String groupType) {
        licenseGroupV6.put("16", ResManager.loadKDString((String)"\u77ed\u4fe1\u670d\u52a1\u5206\u7ec4", (String)"LicenseGroupUtil_14", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroupV6.put("420", ResManager.loadKDString((String)"\u670d\u52a1\u5f00\u53d1\u5206\u7ec4", (String)"LicenseGroupUtil_204", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroupV6.put("26", ResManager.loadKDString((String)"\u8fde\u63a5\u7535\u5546", (String)"LicenseGroupUtil_205", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroupV6.put("27", ResManager.loadKDString((String)"\u91c7\u8d2d\u5546\u57ce", (String)"LicenseGroupUtil_206", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroupV6.put("425", ResManager.loadKDString((String)"\u7269\u6599\u591a\u5c5e\u6027\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_207", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroupV6.put("601", ResManager.loadKDString((String)"\u4e91\u6253\u5370", (String)"LicenseGroupUtil_208", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroupV6.put("602", ResManager.loadKDString((String)"GPT\u8f7b\u5206\u6790\u52a9\u624b", (String)"LicenseGroupUtil_209", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroupV6.put("603", ResManager.loadKDString((String)"\u8f7b\u5efa\u6a21\u5206\u7ec4", (String)"LicenseGroupUtil_210", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroupV6.put("604", ResManager.loadKDString((String)"\u6d41\u5f0f\u96c6\u6210", (String)"LicenseGroupUtil_211", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroupV6.put("605", ResManager.loadKDString((String)"GPT\u9884\u6d4b\u5f15\u64ce", (String)"LicenseGroupUtil_212", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroupV6.put("606", ResManager.loadKDString((String)"GPT\u5f00\u53d1\u5e73\u53f0", (String)"LicenseGroupUtil_213", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroupV6.put("607", ResManager.loadKDString((String)"\u9690\u79c1\u7ba1\u7406", (String)"LicenseGroupUtil_214", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroupV6.put("608", ResManager.loadKDString((String)"\u592e\u56fd\u4f01\u62db\u5f85/\u4f1a\u8bae\u8d39\u7ba1\u7406\u5206\u7ec4", (String)"LicenseGroupUtil_215", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroupV6.put("609", ResManager.loadKDString((String)"\u9ad8\u7ea7\u5b9a\u4ef7", (String)"LicenseGroupUtil_216", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroupV6.put("610", ResManager.loadKDString((String)"\u8d28\u91cf\u4e91\u8f7b\u5e94\u7528", (String)"LicenseGroupUtil_217", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroupV6.put("611", ResManager.loadKDString((String)"\u9ad8\u7ea7\u8ba1\u5212", (String)"LicenseGroupUtil_218", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroupV6.put("612", ResManager.loadKDString((String)"\u4ea7\u54c1\u9009\u914d", (String)"LicenseGroupUtil_219", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroupV6.put("613", ResManager.loadKDString((String)"\u8d22\u52a1\u4e8c\u7ea7\u6838\u7b97", (String)"LicenseGroupUtil_220", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroupV6.put("614", ResManager.loadKDString((String)"\u9884\u7b97\u4f1a\u8ba1", (String)"LicenseGroupUtil_221", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroupV6.put("615", ResManager.loadKDString((String)"\u7535\u5b50\u51ed\u8bc1\u6c60\u5f02\u6784\u7cfb\u7edf\u63a5\u5165", (String)"LicenseGroupUtil_222", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroupV6.put("616", ResManager.loadKDString((String)"\u56fd\u8d44\u59d4\u8d44\u91d1\u6570\u636e\u4e0a\u62a5", (String)"LicenseGroupUtil_223", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroupV6.put("617", ResManager.loadKDString((String)"GPT\u5458\u5de5\u670d\u52a1\u52a9\u624b", (String)"LicenseGroupUtil_224", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroupV6.put("618", ResManager.loadKDString((String)"GPT\u8d22\u52a1\u52a9\u624b", (String)"LicenseGroupUtil_225", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroupV6.put("619", ResManager.loadKDString((String)"\u6570\u5b57\u5458\u5de5\u7ba1\u7406\u5e73\u53f0", (String)"LicenseGroupUtil_226", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroupV6.put("620", ResManager.loadKDString((String)"\u865a\u62df\u4eba\u96c6\u6210", (String)"LicenseGroupUtil_227", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroupV6.put("621", ResManager.loadKDString((String)"\u8bed\u97f3\u5305\u96c6\u6210", (String)"LicenseGroupUtil_228", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroupV6.put("622", ResManager.loadKDString((String)"\u6570\u5b57\u5458\u5de5\u667a\u6167\u5927\u5c4f", (String)"LicenseGroupUtil_229", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroupV6.put("623", ResManager.loadKDString((String)"\u5f02\u6784\u7cfb\u7edf\u6280\u80fd\u63a5\u5165", (String)"LicenseGroupUtil_230", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroupV6.put("624", ResManager.loadKDString((String)"\u5343\u6237\u53ca\u91cd\u70b9\u7a0e\u6e90", (String)"LicenseGroupUtil_231", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroupV6.put("625", ResManager.loadKDString((String)"\u7a0e\u52a1\u7edf\u8ba1\u5206\u6790", (String)"LicenseGroupUtil_232", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroupV6.put("626", ResManager.loadKDString((String)"\u62a5\u7a0e\u5de5\u4f5c\u53f0", (String)"LicenseGroupUtil_233", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroupV6.put("627", ResManager.loadKDString((String)"\u4e91\u90ae\u670d\u52a1", (String)"LicenseGroupUtil_234", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroupV6.put("628", ResManager.loadKDString((String)"\u6536\u53d1\u6587\u653f\u52a1\u79c1\u6709\u90e8\u7f72", (String)"LicenseGroupUtil_235", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroupV6.put("629", ResManager.loadKDString((String)"\u5173\u8054\u7ec4\u7ec7", (String)"LicenseGroupUtil_236", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroupV6.put("630", ResManager.loadKDString((String)"\u6d41\u7a0b\u5206\u6790\u63d2\u4ef6", (String)"LicenseGroupUtil_237", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroupV6.put("631", ResManager.loadKDString((String)"\u4fe1\u606f\u5b89\u5168\u5e73\u53f0", (String)"LicenseGroupUtil_238", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroupV6.put("632", ResManager.loadKDString((String)"Exchange\u5bf9\u63a5\u670d\u52a1", (String)"LicenseGroupUtil_239", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroupV6.put("633", ResManager.loadKDString((String)"\u7535\u5b50\u7b7e\u7ae0\u7cfb\u7edf", (String)"LicenseGroupUtil_240", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroupV6.put("634", ResManager.loadKDString((String)"\u7535\u5b50\u7b7e\u7ae0U-Key", (String)"LicenseGroupUtil_241", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroupV6.put("635", ResManager.loadKDString((String)"\u94a2\u94c1\u4ea7\u54c1\u5927\u7eb2\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_242", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroupV6.put("636", ResManager.loadKDString((String)"\u94a2\u94c1\u4ef7\u683c\u7ba1\u7406\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_243", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroupV6.put("637", ResManager.loadKDString((String)"\u94a2\u94c1\u5ba2\u6237\u670d\u52a1\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_244", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroupV6.put("638", ResManager.loadKDString((String)"\u94a2\u94c1\u5ba2\u6237\u670d\u52a1\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_244", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroupV6.put("639", ResManager.loadKDString((String)"\u5e73\u8861\u5229\u5e93", (String)"LicenseGroupUtil_245", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroupV6.put("640", ResManager.loadKDString((String)"\u65e0\u4ee3\u7801\u670d\u52a1\u8fd0\u884c\u65f6", (String)"LicenseGroupUtil_246", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroupV6.put("641", ResManager.loadKDString((String)"LLM\u6d41\u91cf\u8d44\u6e90\u5305", (String)"LicenseGroupUtil_247", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroupV6.put("642", ResManager.loadKDString((String)"\u9884\u7b97\u4e45\u5176\u62a5\u8868\u673a\u5668\u4eba", (String)"LicenseGroupUtil_248", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroupV6.put("643", ResManager.loadKDString((String)"\u5de5\u7a0b\u9879\u76ee\u4e91\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_249", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroupV6.put("644", ResManager.loadKDString((String)"\u5de5\u7a0b\u4f9b\u5e94\u5546\u95e8\u6237", (String)"LicenseGroupUtil_250", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroupV6.put("645", ResManager.loadKDString((String)"\u5de5\u7a0b\u4f9b\u5e94\u5546\u5fae\u95e8\u6237", (String)"LicenseGroupUtil_251", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroupV6.put("646", ResManager.loadKDString((String)"\u5de5\u7a0b\u6750\u6599\u516c\u53f8", (String)"LicenseGroupUtil_252", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroupV6.put("647", ResManager.loadKDString((String)"\u5de5\u7a0b\u6e05\u5355", (String)"LicenseGroupUtil_253", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroupV6.put("648", ResManager.loadKDString((String)"\u5de5\u7a0b\u6210\u672c\u6570\u636e\u5e93", (String)"LicenseGroupUtil_254", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroupV6.put("649", ResManager.loadKDString((String)"\u5730\u4ea7\u6210\u672c\u5408\u540c\u5386\u53f2\u6570\u636e\u8fc1\u79fb\u5de5\u5177", (String)"LicenseGroupUtil_255", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroupV6.put("650", ResManager.loadKDString((String)"\u5efa\u7b51\u7269\u8d44\u7ba1\u7406", (String)"LicenseGroupUtil_256", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroupV6.put("651", ResManager.loadKDString((String)"\u5efa\u7b51\u4ea7\u503c\u4e0e\u6536\u5165", (String)"LicenseGroupUtil_257", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroupV6.put("652", ResManager.loadKDString((String)"\u5efa\u7b51\u5ba2\u6237\u4e0e\u5546\u673a", (String)"LicenseGroupUtil_258", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroupV6.put("653", ResManager.loadKDString((String)"\u5efa\u7b51\u7ae3\u5de5\u7ba1\u7406", (String)"LicenseGroupUtil_259", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroupV6.put("654", ResManager.loadKDString((String)"\u5efa\u7b51\u8bc1\u7167\u7ba1\u7406", (String)"LicenseGroupUtil_260", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroupV6.put("655", ResManager.loadKDString((String)"\u5efa\u7b51\u6323\u503c\u6210\u672c", (String)"LicenseGroupUtil_261", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroupV6.put("656", ResManager.loadKDString((String)"\u5de5\u7a0b\u8ba1\u5212\u7ba1\u7406", (String)"LicenseGroupUtil_262", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroupV6.put("657", ResManager.loadKDString((String)"\u5de5\u7a0b\u8bbe\u8ba1\u7ba1\u7406", (String)"LicenseGroupUtil_263", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroupV6.put("658", ResManager.loadKDString((String)"\u5de5\u7a0b\u8d28\u91cf\u7ba1\u7406", (String)"LicenseGroupUtil_264", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroupV6.put("659", ResManager.loadKDString((String)"\u5730\u4ea7\u8425\u9500\u7ba1\u7406", (String)"LicenseGroupUtil_265", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroupV6.put("660", ResManager.loadKDString((String)"\u5730\u4ea7\u552e\u697c\u7ba1\u7406-\u4f01\u4e1a\u7248", (String)"LicenseGroupUtil_267", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroupV6.put("661", ResManager.loadKDString((String)"\u5730\u4ea7\u8425\u9500\u7ba1\u7406-\u4f01\u4e1a\u7248", (String)"LicenseGroupUtil_268", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroupV6.put("662", ResManager.loadKDString((String)"\u76ee\u6807\u4e0e\u7ee9\u6548\u7ba1\u7406\u5e94\u7528\u5206\u7ec4", (String)"LicenseGroupUtil_269", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroupV6.put("663", ResManager.loadKDString((String)"\u7269\u4e1a\u4e91-\u5de5\u5355\u670d\u52a1\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_270", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroupV6.put("664", ResManager.loadKDString((String)"\u8d44\u7ba1\u4e91-\u79fb\u52a8\u8d44\u7ba1\u5c0f\u7a0b\u5e8f\u5206\u7ec4", (String)"LicenseGroupUtil_271", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroupV6.put("665", ResManager.loadKDString((String)"\u8d44\u7ba1\u4e91-\u4f01\u5fae\u63a5\u53e3\u4e13\u5c5e\u5305\u5206\u7ec4", (String)"LicenseGroupUtil_272", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroupV6.put("666", ResManager.loadKDString((String)"\u8d44\u7ba1\u4e91-\u79fb\u52a8\u8d44\u7ba1\u5c0f\u7a0b\u5e8f\u4e13\u5c5e\u670d\u52a1\u5206\u7ec4", (String)"LicenseGroupUtil_273", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroupV6.put("667", ResManager.loadKDString((String)"\u7535\u5b50\u5408\u540c", (String)"LicenseGroupUtil_274", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroupV6.put("668", ResManager.loadKDString((String)"\u667a\u80fd\u9053\u95f8", (String)"LicenseGroupUtil_275", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroupV6.put("669", ResManager.loadKDString((String)"\u7535\u5b50\u6863\u6848\u4e91\u7279\u6027\u5206\u7ec4", (String)"LicenseGroupUtil_276", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroupV6.put("670", ResManager.loadKDString((String)"\u8f7b\u5206\u6790\u5b58\u50a8", (String)"LicenseGroupUtil_283", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroupV6.put("671", ResManager.loadKDString((String)"\u8f7b\u6570\u4ed3\u5b58\u50a8", (String)"LicenseGroupUtil_284", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroupV6.put("672", ResManager.loadKDString((String)"\u592e\u56fd\u4f01\u5e94\u7528\u5206\u7ec4", (String)"LicenseGroupUtil_285", (String)"bos-license-common", (Object[])new Object[0]));
        if ("1".equals(groupType)) {
            licenseGroupV6.remove("16");
            licenseGroupV6.remove("420");
            licenseGroupV6.remove("26");
            licenseGroupV6.remove("27");
            licenseGroupV6.remove("601");
            licenseGroupV6.remove("603");
            licenseGroupV6.remove("604");
            licenseGroupV6.remove("605");
            licenseGroupV6.remove("607");
            licenseGroupV6.remove("608");
            licenseGroupV6.remove("609");
            licenseGroupV6.remove("610");
            licenseGroupV6.remove("611");
            licenseGroupV6.remove("612");
            licenseGroupV6.remove("613");
            licenseGroupV6.remove("614");
            licenseGroupV6.remove("615");
            licenseGroupV6.remove("616");
            licenseGroupV6.remove("619");
            licenseGroupV6.remove("620");
            licenseGroupV6.remove("621");
            licenseGroupV6.remove("622");
            licenseGroupV6.remove("623");
            licenseGroupV6.remove("624");
            licenseGroupV6.remove("625");
            licenseGroupV6.remove("626");
            licenseGroupV6.remove("628");
            licenseGroupV6.remove("629");
            licenseGroupV6.remove("630");
            licenseGroupV6.remove("631");
            licenseGroupV6.remove("632");
            licenseGroupV6.remove("633");
            licenseGroupV6.remove("634");
            licenseGroupV6.remove("635");
            licenseGroupV6.remove("636");
            licenseGroupV6.remove("637");
            licenseGroupV6.remove("638");
            licenseGroupV6.remove("639");
            licenseGroupV6.remove("641");
            licenseGroupV6.remove("642");
            licenseGroupV6.remove("644");
            licenseGroupV6.remove("645");
            licenseGroupV6.remove("646");
            licenseGroupV6.remove("647");
            licenseGroupV6.remove("648");
            licenseGroupV6.remove("649");
            licenseGroupV6.remove("650");
            licenseGroupV6.remove("651");
            licenseGroupV6.remove("652");
            licenseGroupV6.remove("653");
            licenseGroupV6.remove("654");
            licenseGroupV6.remove("655");
            licenseGroupV6.remove("656");
            licenseGroupV6.remove("657");
            licenseGroupV6.remove("658");
            licenseGroupV6.remove("659");
            licenseGroupV6.remove("661");
            licenseGroupV6.remove("662");
            licenseGroupV6.remove("663");
            licenseGroupV6.remove("664");
            licenseGroupV6.remove("665");
            licenseGroupV6.remove("666");
            licenseGroupV6.remove("667");
            licenseGroupV6.remove("668");
            licenseGroupV6.remove("669");
            licenseGroupV6.remove("670");
            licenseGroupV6.remove("671");
            licenseGroupV6.remove("672");
        } else if ("2".equals(groupType)) {
            licenseGroupV6.remove("425");
            licenseGroupV6.remove("602");
            licenseGroupV6.remove("606");
            licenseGroupV6.remove("617");
            licenseGroupV6.remove("618");
            licenseGroupV6.remove("627");
            licenseGroupV6.remove("640");
            licenseGroupV6.remove("643");
            licenseGroupV6.remove("660");
        }
    }

    private static void addLicenseGroupChangV5(Map<String, String> licenseGroup, String groupType) {
        if (licenseGroup == null) {
            return;
        }
        licenseGroup.remove("429");
        licenseGroup.put("11", ResManager.loadKDString((String)"\u5de5\u4f5c\u6d41\u670d\u52a1-\u65e0\u9650\u7248", (String)"LicenseGroupUtil_128", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("441", ResManager.loadKDString((String)"\u5de5\u4f5c\u6d41\u670d\u52a1-\u6d41\u91cf\u7248", (String)"LicenseGroupUtil_129", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("12", ResManager.loadKDString((String)"\u8f7b\u5206\u6790\u5206\u7ec4", (String)"LicenseGroupUtil_125", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("442", ResManager.loadKDString((String)"\u8f7b\u62a5\u8868\u5206\u7ec4", (String)"LicenseGroupUtil_131", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("430", ResManager.loadKDString((String)"\u8d44\u91d1\u4e91\u8f7b\u5e94\u7528", (String)"LicenseGroupUtil_150", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("427", ResManager.loadKDString((String)"\u8d22\u52a1\u4e91\u8f7b\u5e94\u7528", (String)"LicenseGroupUtil_151", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("8", ResManager.loadKDString((String)"\u667a\u80fd\u6838\u7b97\u673a\u5668\u4eba", (String)"LicenseGroupUtil_152", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("21", ResManager.loadKDString((String)"\u6307\u6807\u67e5\u8be2\u673a\u5668\u4eba", (String)"LicenseGroupUtil_153", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("428", ResManager.loadKDString((String)"\u5171\u4eab\u5ba2\u670d\u673a\u5668\u4eba", (String)"LicenseGroupUtil_154", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("501", ResManager.loadKDString((String)"\u7f51\u94f6\u673a\u5668\u4eba", (String)"LicenseGroupUtil_132", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("502", ResManager.loadKDString((String)"\u7535\u5b50\u51ed\u8bc1\u63a5\u53e3", (String)"LicenseGroupUtil_133", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("503", ResManager.loadKDString((String)"\u7535\u5b50\u5546\u4e1a\u6c47\u7968\u670d\u52a1", (String)"LicenseGroupUtil_134", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("504", ResManager.loadKDString((String)"\u4f9b\u5e94\u94fe\u4e91\u8f7b\u5e94\u7528", (String)"LicenseGroupUtil_135", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("505", ResManager.loadKDString((String)"\u94f6\u4f01\u4e91\u5206\u7ec4", (String)"LicenseGroupUtil_136", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("506", ResManager.loadKDString((String)"\u89c6\u89c9\u8bc6\u522b\u670d\u52a1-\u6d41\u91cf\u7248", (String)"LicenseGroupUtil_137", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("507", ResManager.loadKDString((String)"\u4e09\u5458\u7ba1\u7406", (String)"LicenseGroupUtil_138", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("508", ResManager.loadKDString((String)"\u6570\u636e\u5f52\u6863", (String)"LicenseGroupUtil_139", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("509", ResManager.loadKDString((String)"\u5206\u5e93\u5206\u8868", (String)"LicenseGroupUtil_140", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("510", ResManager.loadKDString((String)"RPA\u8fd0\u884c\u7ba1\u7406\u5e73\u53f0", (String)"LicenseGroupUtil_141", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("511", ResManager.loadKDString((String)"RPA\u8bbe\u8ba1\u5668", (String)"LicenseGroupUtil_142", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("512", ResManager.loadKDString((String)"\u6709\u4eba\u503c\u5b88\u673a\u5668\u4eba", (String)"LicenseGroupUtil_143", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("513", ResManager.loadKDString((String)"\u65e0\u4eba\u503c\u5b88\u673a\u5668\u4eba", (String)"LicenseGroupUtil_144", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("521", ResManager.loadKDString((String)"HR\u81ea\u52a9\u670d\u52a1\u4e2d\u5fc3\u5206\u7ec4", (String)"LicenseGroupUtil_266", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("522", ResManager.loadKDString((String)"\u7535\u5b50\u5546\u4e1a\u6c47\u7968\u63a5\u53e3\u5206\u7ec4", (String)"LicenseGroupUtil_155", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("523", ResManager.loadKDString((String)"\u94f6\u4f01\u63a5\u53e3\u5206\u7ec4", (String)"LicenseGroupUtil_156", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("524", ResManager.loadKDString((String)"\u5730\u4ea7\u91c7\u8d2d\u79fb\u52a8\u5e94\u7528\u7279\u6027\u5206\u7ec4", (String)"LicenseGroupUtil_157", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("525", ResManager.loadKDString((String)"\u5730\u4ea7\u6210\u672c\u79fb\u52a8\u5e94\u7528\u7279\u6027\u5206\u7ec4", (String)"LicenseGroupUtil_158", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("526", ResManager.loadKDString((String)"\u5730\u4ea7\u8ba1\u5212\u79fb\u52a8\u5e94\u7528\u7279\u6027\u5206\u7ec4", (String)"LicenseGroupUtil_159", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("527", ResManager.loadKDString((String)"\u5730\u4ea7\u5f00\u76d8\u7279\u6027\u5206\u7ec4", (String)"LicenseGroupUtil_160", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("528", ResManager.loadKDString((String)"\u5730\u4ea7\u4f63\u91d1\u7279\u6027\u5206\u7ec4", (String)"LicenseGroupUtil_161", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("529", ResManager.loadKDString((String)"\u5730\u4ea7\u65fa\u5c0f\u5b9d\u7279\u6027\u5206\u7ec4", (String)"LicenseGroupUtil_162", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("530", ResManager.loadKDString((String)"\u5730\u4ea7\u667a\u80fd\u786c\u4ef6\u7279\u6027\u5206\u7ec4", (String)"LicenseGroupUtil_163", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("531", ResManager.loadKDString((String)"\u5efa\u7b51\u8ba1\u5212\u79fb\u52a8\u5e94\u7528\u7279\u6027\u5206\u7ec4", (String)"LicenseGroupUtil_164", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("532", ResManager.loadKDString((String)"\u53d1\u7968\u4e91\u53d1\u7968\u9884\u8b66\u8bb8\u53ef", (String)"LicenseGroupUtil_165", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("533", ResManager.loadKDString((String)"\u7269\u4e1a\u4e91-\u6536\u5165\u4e2d\u53f0\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_166", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("534", ResManager.loadKDString((String)"\u7269\u4e1a\u4e91-\u6536\u8d39\u7ba1\u7406\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_167", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("535", ResManager.loadKDString((String)"\u7269\u4e1a\u4e91-\u6536\u5165\u5408\u540c\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_168", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("536", ResManager.loadKDString((String)"\u7269\u4e1a\u4e91-\u667a\u80fdPOS\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_169", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("537", ResManager.loadKDString((String)"\u8d44\u7ba1\u4e91-\u62db\u5546\u7ba1\u7406\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_170", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("538", ResManager.loadKDString((String)"\u8d44\u7ba1\u4e91-\u79df\u8d41\u7ba1\u7406\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_171", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("539", ResManager.loadKDString((String)"\u8d44\u7ba1\u4e91-\u8d44\u4ea7\u7ba1\u7406\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_172", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("540", ResManager.loadKDString((String)"\u8d44\u7ba1\u4e91-\u8d44\u4ea7\u5730\u56fe\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_173", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("541", ResManager.loadKDString((String)"\u7269\u4e1a\u4e91-\u7f34\u8d39\u4e91\u5c0f\u7a0b\u5e8f\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_174", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("542", ResManager.loadKDString((String)"\u7269\u4e1a\u4e91-\u7968\u636e\u7ba1\u7406\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_175", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("543", ResManager.loadKDString((String)"\u7269\u4e1a\u4e91-\u5f00\u7968\u670d\u52a1\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_176", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("544", ResManager.loadKDString((String)"\u8d44\u7ba1\u4e91-\u7535\u5b50\u5408\u540c\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_177", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("545", ResManager.loadKDString((String)"\u4e45\u5176\u62a5\u8868\u673a\u5668\u4eba", (String)"LicenseGroupUtil_178", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("546", ResManager.loadKDString((String)"\u5171\u4eab\u667a\u80fd\u5ba1\u6838\u52a9\u624b", (String)"LicenseGroupUtil_179", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("549", ResManager.loadKDString((String)"\u591a\u6d3b\u4e0e\u707e\u5907\u670d\u52a1", (String)"LicenseGroupUtil_180", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("552", ResManager.loadKDString((String)"\u4f01\u4e1a\u5fae\u4fe1\u96c6\u6210\u5206\u7ec4", (String)"LicenseGroupUtil_182", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("553", ResManager.loadKDString((String)"\u7a0e\u4f01\u76f4\u8fde", (String)"LicenseGroupUtil_183", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("554", ResManager.loadKDString((String)"\u667a\u80fd\u534f\u540c\u4e91", (String)"LicenseGroupUtil_184", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("555", ResManager.loadKDString((String)"\u534f\u540c\u5ba1\u6279\u6536\u53d1\u6587", (String)"LicenseGroupUtil_185", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("556", ResManager.loadKDString((String)"APP\u5b9a\u5236\u670d\u52a1", (String)"LicenseGroupUtil_186", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("557", ResManager.loadKDString((String)"\u667a\u80fd\u7ed3\u7b97\u673a\u5668\u4eba", (String)"LicenseGroupUtil_187", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("558", ResManager.loadKDString((String)"\u7ffb\u8bd1\u670d\u52a1\u4e91", (String)"LicenseGroupUtil_188", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("574", ResManager.loadKDString((String)"\u5730\u4ea7\u6210\u672c\u6570\u636e\u8fc1\u79fb\u7279\u6027\u5206\u7ec4", (String)"LicenseGroupUtil_189", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("575", ResManager.loadKDString((String)"\u5730\u4ea7\u751f\u6001\u4e00\u4f53\u673a\u7279\u6027\u5206\u7ec4", (String)"LicenseGroupUtil_190", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("576", ResManager.loadKDString((String)"\u5730\u4ea7\u751f\u6001\u5728\u7ebf\u5f00\u76d8\u7279\u6027\u5206\u7ec4", (String)"LicenseGroupUtil_191", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("577", ResManager.loadKDString((String)"\u5efa\u7b51\u6750\u6599\u516c\u53f8\u91c7\u8d2d\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_192", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("578", ResManager.loadKDString((String)"\u5efa\u7b51\u6323\u503c\u6210\u672c\u7279\u6027\u5206\u7ec4", (String)"LicenseGroupUtil_193", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("579", ResManager.loadKDString((String)"\u5efa\u7b51\u91c7\u8d2d\u79fb\u52a8\u5e94\u7528\u7279\u6027\u5206\u7ec4", (String)"LicenseGroupUtil_194", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("580", ResManager.loadKDString((String)"\u85aa\u916c\u7ba1\u7406\u5e94\u7528\u5206\u7ec4", (String)"LicenseGroupUtil_199", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("582", ResManager.loadKDString((String)"\u4eba\u624d\u53d1\u5c55\u5e94\u7528\u5206\u7ec4", (String)"LicenseGroupUtil_200", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("583", ResManager.loadKDString((String)"\u4eba\u624d\u4f9b\u5e94\u5e94\u7528\u5206\u7ec4", (String)"LicenseGroupUtil_201", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("584", ResManager.loadKDString((String)"\u62db\u8058\u670d\u52a1\u76f4\u901a\u8f66\u9ad8\u7ea7\u7279\u6027\u5206\u7ec4", (String)"LicenseGroupUtil_202", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("517", ResManager.loadKDString((String)"\u6838\u5fc3\u4eba\u529b\u5e94\u7528\u5206\u7ec4", (String)"LicenseGroupUtil_195", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("518", ResManager.loadKDString((String)"\u85aa\u8d44\u6838\u7b97\u5e94\u7528\u5206\u7ec4", (String)"LicenseGroupUtil_196", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("519", ResManager.loadKDString((String)"\u793e\u4fdd\u4e2a\u7a0e\u5e94\u7528\u5206\u7ec4", (String)"LicenseGroupUtil_197", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("550", ResManager.loadKDString((String)"\u8003\u52e4\u4e0e\u5047\u671f\u7ba1\u7406\u5e94\u7528\u5206\u7ec4", (String)"LicenseGroupUtil_198", (String)"bos-license-common", (Object[])new Object[0]));
        licenseGroup.put("585", ResManager.loadKDString((String)"\u8d44\u7ba1\u4e91-\u652f\u51fa\u5408\u540c\u4e13\u4e1a\u5206\u7ec4", (String)"LicenseGroupUtil_203", (String)"bos-license-common", (Object[])new Object[0]));
        if ("1".equals(groupType)) {
            licenseGroup.remove("11");
            licenseGroup.remove("441");
            licenseGroup.remove("501");
            licenseGroup.remove("502");
            licenseGroup.remove("503");
            licenseGroup.remove("504");
            licenseGroup.remove("505");
            licenseGroup.remove("506");
            licenseGroup.remove("507");
            licenseGroup.remove("508");
            licenseGroup.remove("509");
            licenseGroup.remove("510");
            licenseGroup.remove("511");
            licenseGroup.remove("512");
            licenseGroup.remove("513");
            licenseGroup.remove("517");
            licenseGroup.remove("518");
            licenseGroup.remove("519");
            licenseGroup.remove("521");
            licenseGroup.remove("522");
            licenseGroup.remove("523");
            licenseGroup.remove("524");
            licenseGroup.remove("525");
            licenseGroup.remove("526");
            licenseGroup.remove("527");
            licenseGroup.remove("528");
            licenseGroup.remove("529");
            licenseGroup.remove("530");
            licenseGroup.remove("531");
            licenseGroup.remove("532");
            licenseGroup.remove("533");
            licenseGroup.remove("534");
            licenseGroup.remove("535");
            licenseGroup.remove("536");
            licenseGroup.remove("537");
            licenseGroup.remove("538");
            licenseGroup.remove("539");
            licenseGroup.remove("540");
            licenseGroup.remove("541");
            licenseGroup.remove("542");
            licenseGroup.remove("543");
            licenseGroup.remove("544");
            licenseGroup.remove("430");
            licenseGroup.remove("427");
            licenseGroup.remove("8");
            licenseGroup.remove("21");
            licenseGroup.remove("428");
            licenseGroup.remove("545");
            licenseGroup.remove("546");
            licenseGroup.remove("549");
            licenseGroup.remove("550");
            licenseGroup.remove("552");
            licenseGroup.remove("553");
            licenseGroup.remove("555");
            licenseGroup.remove("556");
            licenseGroup.remove("557");
            licenseGroup.remove("558");
            licenseGroup.remove("574");
            licenseGroup.remove("575");
            licenseGroup.remove("576");
            licenseGroup.remove("577");
            licenseGroup.remove("578");
            licenseGroup.remove("579");
            licenseGroup.remove("580");
            licenseGroup.remove("582");
            licenseGroup.remove("583");
            licenseGroup.remove("584");
            licenseGroup.remove("585");
        } else if ("2".equals(groupType)) {
            licenseGroup.remove("12");
            licenseGroup.remove("442");
            licenseGroup.remove("554");
        }
    }

    public static Map<Long, Integer> getCurAccountAssignByGroupIds(List<String> groupIds) {
        if (groupIds == null || groupIds.isEmpty()) {
            Collections.emptyMap();
        }
        StringBuilder sql = new StringBuilder("SELECT fgroupid, count(1) fcount FROM T_LIC_USERLICENSEGROUP WHERE fsyncstatus = '1' AND fgroupid IN ");
        StringBuilder param = new StringBuilder();
        param.append('(');
        param.append(String.join((CharSequence)",", groupIds));
        param.append(')');
        sql.append((CharSequence)param);
        sql.append(" GROUP BY fgroupid");
        return (Map)DB.query((DBRoute)DBRoute.base, (String)sql.toString(), rs -> {
            HashMap<Long, Integer> result = new HashMap<Long, Integer>(16);
            while (rs.next()) {
                result.put(rs.getLong("fgroupid"), rs.getInt("fcount"));
            }
            return result;
        });
    }

    public static List<Long> getAllIsvGroupId() {
        ArrayList<Long> arrayList = new ArrayList<Long>(16);
        try (DataSet isvGroupIds = DB.queryDataSet((String)"QUERY_ISV_GROUP_ID", (DBRoute)DBRoute.base, (String)"select lg.fid groupId from t_lic_group lg join t_lic_isvprod li on lg.fisvprodnumber  = li.fprodnumber where li.fisvnumber not in ('kingdee','kdxk') ");){
            for (Row row : isvGroupIds) {
                Long groupId = row.getLong("groupId");
                if (null == groupId) continue;
                arrayList.add(groupId);
            }
        }
        catch (Exception e) {
            logger.error("getAllIsvGroupId:" + e);
        }
        return arrayList;
    }
}

