/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.license.util;

import java.util.List;
import kd.bos.license.bean.LicenseCheckLog;
import kd.bos.license.bean.LicenseSyncDetailLog;
import kd.bos.license.bean.LicenseSyncLog;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;

public class LicenseLogUtil {
    private static Log logger = LogFactory.getLog(LicenseLogUtil.class);

    public static void addLicSyncLog(LicenseSyncLog log) {
        if (null != log) {
            List<LicenseSyncDetailLog> detailLogs = log.getLogs();
            if (detailLogs == null || detailLogs.isEmpty()) {
                return;
            }
            try (MessagePublisher pub = MQFactory.get().createSimplePublisher("base", "license_service");){
                pub.publish((Object)log);
            }
            logger.info("LicenseLogUtil: publish a LicenseSyncLog to mq");
        } else {
            logger.info("LicenseLogUtil: null LicenseSyncLog do not publish");
        }
    }

    public static void addLicCheckLog(LicenseCheckLog log) {
        if (null != log) {
            try (MessagePublisher pub = MQFactory.get().createSimplePublisher("base", "license_service");){
                pub.publish((Object)log);
            }
            logger.info("LicenseLogUtil: publish a LicenseCheckLog to mq");
        } else {
            logger.info("LicenseLogUtil: null LicenseCheckLog do not publish");
        }
    }
}

