/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.license.util;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dc.mc.LoginMCService;
import kd.bos.encrypt.Encrypters;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.exception.LoginErrorCode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.HttpClientUtils;

public class LicenseMCApiUtil {
    private static Log logger = LogFactory.getLog(LicenseMCApiUtil.class);
    private static final String GETLIC = "/kapi/app/mc/getlicensebytenantid";
    private static final String UPDATELIC = "/kapi/app/mc/updateLicensefromEASCloud";
    private static final String ISVSERVICE = "/kapi/app/mc/dataSaveIsvService";
    private static final String CONTENT_TYPE_APP_JSON = "application/json";
    private static final int OVERTIME = 500;
    private static final String GET_GRAY_LIC = "/kapi/app/mc/getgraylicensebytenantid";
    private static final String UPDATE_GRAY_LIC = "/kapi/app/mc/updateGrayLicense";
    private static final String GET_ACCESS_TOKEN = "/api/upgradeLogin.do";

    public static String notifyMcUpdateLicFile() throws KDException {
        String result = "";
        Map<String, String> header = LicenseMCApiUtil.getHttpRequestJsonHeader();
        Map<String, Object> params = LicenseMCApiUtil.getParams();
        try {
            result = LoginMCService.create().callMcApiService(UPDATELIC, CONTENT_TYPE_APP_JSON, header, params, 500);
        }
        catch (Exception e) {
            String errorStr = String.format("notifyMcUpdateLicFile Fail,header\uff1a%s,params\uff1a%s,e\uff1a%s", header, params, e.getMessage());
            logger.error(errorStr, (Throwable)e);
            throw new KDException(errorStr);
        }
        return result;
    }

    public static String getEncryptLicFileFromMc() throws KDException {
        String result = "";
        Map<String, Object> params = LicenseMCApiUtil.getParams();
        params.remove("envNumber");
        params.put("isEncrypt", true);
        Map<String, String> header = LicenseMCApiUtil.getHttpRequestJsonHeader();
        try {
            result = LoginMCService.create().callMcApiService(GETLIC, CONTENT_TYPE_APP_JSON, header, params, 500);
        }
        catch (Exception e) {
            String errorStr = String.format("notifyMcUpdateLicFile Fail,header\uff1a%s,params\uff1a%s,e\uff1a%s", header, params, e.getMessage());
            logger.error(errorStr, (Throwable)e);
            throw new KDException(errorStr);
        }
        return result;
    }

    public static String getLicFileFromMc() throws KDException {
        String result = "";
        Map<String, Object> params = LicenseMCApiUtil.getParams();
        params.remove("envNumber");
        Map<String, String> header = LicenseMCApiUtil.getHttpRequestJsonHeader();
        try {
            result = LoginMCService.create().callMcApiService(GETLIC, CONTENT_TYPE_APP_JSON, header, params, 500);
        }
        catch (Exception e) {
            String errorStr = String.format("notifyMcUpdateLicFile Fail,header\uff1a%s,params\uff1a%s,e\uff1a%s", header, params, e.getMessage());
            logger.error(errorStr, (Throwable)e);
            throw new KDException(errorStr);
        }
        return result;
    }

    private static Map<String, Object> getParams() {
        HashMap<String, Object> param = new HashMap<String, Object>(2);
        param.put("tenantId", RequestContext.get().getTenantId());
        param.put("envNumber", System.getProperty("clusterName"));
        return param;
    }

    private static Map<String, String> getHttpRequestJsonHeader() {
        HashMap<String, String> header = new HashMap<String, String>(2);
        header.put("Content-type", CONTENT_TYPE_APP_JSON);
        return header;
    }

    public static Map<?, ?> JsonToMap(String postjson) throws Exception {
        Map map;
        try {
            map = (Map)JSONObject.parseObject((String)postjson, Map.class);
        }
        catch (Exception e) {
            throw new KDBizException(postjson);
        }
        return map;
    }

    public static boolean syncISVData() {
        DynamicObjectCollection prodInfoCol = QueryServiceHelper.query((String)"lic_isvprod", (String)"isvnumber", (QFilter[])new QFilter("isvnumber", "<>", (Object)"kingdee").toArray());
        if (prodInfoCol == null || prodInfoCol.isEmpty()) {
            return true;
        }
        HashSet<String> isvSet = new HashSet<String>(prodInfoCol.size());
        for (DynamicObject prodInfo : prodInfoCol) {
            isvSet.add(prodInfo.getString("isvnumber"));
        }
        return LicenseMCApiUtil.syncISVData(isvSet);
    }

    private static boolean syncISVData(Set<String> isvSet) {
        String accountId = RequestContext.get().getAccountId();
        String property = System.getProperty("isv_info_" + accountId);
        Set curIsvSet = StringUtils.isNotBlank((CharSequence)property) ? (Set)SerializationUtils.fromJsonString((String)Encrypters.decode((String)property), Set.class) : new HashSet(16);
        curIsvSet.addAll(isvSet);
        String encode = Encrypters.encode((String)SerializationUtils.toJsonString(curIsvSet));
        HashMap<String, String> params = new HashMap<String, String>(4);
        params.put("tenantId", RequestContext.get().getTenantId());
        params.put("dcId", accountId);
        params.put("info", encode);
        try {
            LoginMCService.create().callMcApiService(ISVSERVICE, CONTENT_TYPE_APP_JSON, LicenseMCApiUtil.getHttpRequestJsonHeader(), params, 500);
        }
        catch (Exception e) {
            logger.error("Invoke dataSaveIsvService exeception.", (Throwable)e);
            return false;
        }
        return true;
    }

    public static String getGrayLicFileFromMc() throws KDException {
        String result;
        Map<String, Object> params = LicenseMCApiUtil.getParams();
        params.remove("envNumber");
        params.put("traceId", RequestContext.get().getTraceId());
        Map<String, String> header = LicenseMCApiUtil.getHttpRequestJsonHeader();
        try {
            header.put("accessToken", LicenseMCApiUtil.getAccessToken());
            result = LoginMCService.create().callMcApiService(GET_GRAY_LIC, CONTENT_TYPE_APP_JSON, header, params, 500);
        }
        catch (Exception e) {
            String errorStr = String.format("getGrayLicFileFromMc Fail,header\uff1a%s,params\uff1a%s,e\uff1a%s", header, params, e.getMessage());
            logger.error(errorStr, (Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u4ece\u7ba1\u7406\u4e2d\u5fc3\u83b7\u53d6\u7070\u5ea6\u8bb8\u53ef\u6587\u4ef6\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"LicenseMCApiUtil_0", (String)"bos-license-common", (Object[])new Object[0]));
        }
        return result;
    }

    public static void notifyMCUpdateGrayLic() throws KDException {
        String result;
        Map<String, Object> params = LicenseMCApiUtil.getParams();
        params.remove("envNumber");
        params.put("traceId", RequestContext.get().getTraceId());
        Map<String, String> header = LicenseMCApiUtil.getHttpRequestJsonHeader();
        try {
            header.put("accessToken", LicenseMCApiUtil.getAccessToken());
            result = LoginMCService.create().callMcApiService(UPDATE_GRAY_LIC, CONTENT_TYPE_APP_JSON, header, params, 500);
        }
        catch (Exception e) {
            String errorStr = String.format("notifyMCUpdateGrayLic Fail,header\uff1a%s,params\uff1a%s,e\uff1a%s", header, params, e.getMessage());
            logger.error(errorStr, (Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u4ece\u7ba1\u7406\u4e2d\u5fc3\u83b7\u53d6\u7070\u5ea6\u8bb8\u53ef\u6587\u4ef6\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"LicenseMCApiUtil_0", (String)"bos-license-common", (Object[])new Object[0]));
        }
        JSONObject jsonResult = JSONObject.parseObject((String)result);
        String errorCode = jsonResult.getString("errorcode");
        if (errorCode == null || Integer.parseInt(errorCode) != 100) {
            throw new KDBizException(jsonResult.getString("description"));
        }
    }

    private static String getAccessToken() throws Exception {
        String mcServer = System.getProperty("mc.server.url");
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("tenantId", "");
        body.put("accountId", "");
        Map<String, String> headerParam = LicenseMCApiUtil.getHttpRequestJsonHeader();
        if (StringUtils.isBlank((CharSequence)mcServer)) {
            throw new KDBizException("");
        }
        String resp = HttpClientUtils.postAppJson((String)(mcServer + GET_ACCESS_TOKEN), headerParam, body, (int)5000, (int)6000);
        if (StringUtils.isBlank((CharSequence)resp)) {
            throw new KDBizException("");
        }
        JSONObject result = JSONObject.parseObject((String)resp);
        if (result.get((Object)"data") == null) {
            logger.info(resp);
            throw new KDBizException(LoginErrorCode.loginBizException, new Object[]{resp});
        }
        JSONObject tokenData = result.getJSONObject("data");
        return tokenData.get((Object)"access_token").toString();
    }
}

