/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.license.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.license.LocalCache.LicenseModuleLocalCache;
import kd.bos.license.bean.LicenseModuleInfo;
import kd.bos.license.bean.ModuleVersionInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;

public class LicenseModuleUtil {
    private static final Log logger = LogFactory.getLog(LicenseModuleUtil.class);
    private static final String ENTITY_LIC_MODULE = "lic_module";
    private static final String MODULE_VERSION = "module_entryentity";
    private static final String MODULE_ID = "id";
    private static final String MODULE_NUMBER = "number";
    private static final String MODULE_NAME = "name";
    private static final String MODULE_GROUPDES = "description";
    private static final String MODULE_NAME_VERSION = "name_version";
    private static final String MODULE_VERSION_VERSION = "version";

    public static Map<String, String> getAllLicenseModuleName() {
        String productVersion = LicenseServiceHelper.getProductVersion();
        HashMap<String, String> moduleInfos = new HashMap<String, String>(128);
        Map<String, LicenseModuleInfo> allLicModuleInfos = LicenseModuleUtil.getAllVersionLicModules();
        if (CollectionUtils.isEmpty(allLicModuleInfos)) {
            return moduleInfos;
        }
        if (null == productVersion) {
            productVersion = "7.0";
        }
        for (Map.Entry<String, LicenseModuleInfo> allLicModuleInfoEntry : allLicModuleInfos.entrySet()) {
            List<ModuleVersionInfo> moduleVersionInfos;
            String number;
            LicenseModuleInfo allLicModuleInfo = allLicModuleInfoEntry.getValue();
            String name = number = allLicModuleInfo.getNumber();
            ILocaleString localName = allLicModuleInfo.getName();
            if (null != localName) {
                String string = StringUtils.isBlank((CharSequence)localName.getLocaleValue()) ? (StringUtils.isBlank((CharSequence)localName.getLocaleValue_zh_CN()) ? name : localName.getLocaleValue_zh_CN()) : (name = localName.getLocaleValue());
            }
            if (CollectionUtils.isEmpty(moduleVersionInfos = allLicModuleInfo.getModuleVersionInfos())) {
                moduleInfos.put(number, name);
                continue;
            }
            for (ModuleVersionInfo info : moduleVersionInfos) {
                ILocaleString nameVersion = info.getName_version();
                String version = info.getVersion();
                if (!productVersion.equals(version) || null == nameVersion) continue;
                name = StringUtils.isBlank((CharSequence)nameVersion.getLocaleValue()) ? (StringUtils.isBlank((CharSequence)nameVersion.getLocaleValue_zh_CN()) ? name : nameVersion.getLocaleValue_zh_CN()) : nameVersion.getLocaleValue();
            }
            moduleInfos.put(number, name);
        }
        return moduleInfos;
    }

    private static Map<String, LicenseModuleInfo> getAllVersionLicModules() {
        Map<String, LicenseModuleInfo> allLicModuleInfo = LicenseModuleLocalCache.getAllLicModuleInfo();
        if (null == allLicModuleInfo) {
            try (DLock dLock = DLock.create((String)"getAllVersionLicModules");){
                dLock.lock();
                if (null == allLicModuleInfo) {
                    allLicModuleInfo = LicenseModuleUtil.reloadAllLicModules();
                }
            }
            catch (Exception e) {
                logger.error("getAllVersionLicModules error.", (Throwable)e);
                allLicModuleInfo = Collections.emptyMap();
            }
        }
        return allLicModuleInfo;
    }

    private static Map<String, LicenseModuleInfo> reloadAllLicModules() {
        HashMap<String, LicenseModuleInfo> allLicModuleInfo = new HashMap<String, LicenseModuleInfo>(16);
        DynamicObject[] licenseModuleInfos = BusinessDataServiceHelper.load((String)ENTITY_LIC_MODULE, (String)"id,number,name,description,module_entryentity.version,module_entryentity.name_version", null);
        if (null == licenseModuleInfos) {
            return allLicModuleInfo;
        }
        for (DynamicObject licenseModuleInfo : licenseModuleInfos) {
            try {
                DynamicObjectCollection versionInfos = licenseModuleInfo.getDynamicObjectCollection(MODULE_VERSION);
                ArrayList<ModuleVersionInfo> moduleVersionInfos = null;
                if (null != versionInfos && !versionInfos.isEmpty()) {
                    moduleVersionInfos = new ArrayList<ModuleVersionInfo>(16);
                    for (DynamicObject versionInfo : versionInfos) {
                        moduleVersionInfos.add(new ModuleVersionInfo(versionInfo.getLocaleString(MODULE_NAME_VERSION), versionInfo.getString(MODULE_VERSION_VERSION)));
                    }
                }
                allLicModuleInfo.put(licenseModuleInfo.getString(MODULE_NUMBER), new LicenseModuleInfo(licenseModuleInfo.getString(MODULE_ID), licenseModuleInfo.getString(MODULE_NUMBER), licenseModuleInfo.getLocaleString(MODULE_NAME), licenseModuleInfo.getString(MODULE_GROUPDES), moduleVersionInfos));
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
        }
        LicenseModuleLocalCache.putAllLicModuleInfo(allLicModuleInfo);
        return allLicModuleInfo;
    }
}

