/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.license.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.drew.lang.StringUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.encrypt.Encrypters;
import kd.bos.license.bean.LicenseSyncLog;
import kd.bos.license.util.BigCollHandleUtil;
import kd.bos.license.util.LicenseUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.bos.util.HttpClientUtils;

public class LicenseUpdateUtil {
    private static Log logger = LogFactory.getLog(LicenseUpdateUtil.class);
    private static final String ENTITY_USER_TIAL = "lic_userlicgroup_trial";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isNeedShowUpdateWindows() {
        if (!LicenseUtil.isHighAvailabilityMode()) {
            return false;
        }
        StringBuilder licenseNow = new StringBuilder();
        DB.query((DBRoute)DBRoute.base, (String)"select fproductversion from t_lic_license order by fproductversion ", rs -> {
            while (rs.next()) {
                licenseNow.append(rs.getString("fproductversion"));
            }
            return null;
        });
        StringBuilder licenseNew = new StringBuilder();
        DB.query((DBRoute)DBRoute.base, (String)"select fproductversion from t_lic_license_trial order by fproductversion ", rs -> {
            while (rs.next()) {
                licenseNew.append(rs.getString("fproductversion"));
            }
            return null;
        });
        if (StringUtil.compare((String)licenseNow.toString(), (String)licenseNew.toString()) != 0) {
            logger.debug("\u8bb8\u53ef\u4e3a\u7a7a\u6216\u7248\u672c\u53d8\u5316\u8f83\u5927\u9700\u8981\u5f3a\u5236\u786e\u8ba4\u66f4\u65b0\u3002");
            return true;
        }
        try (DataSet queryLicenseDetailNow = DB.queryDataSet((String)"querylicense_detail_now", (DBRoute)DBRoute.base, (String)"select fgroupid ,ftotalcount ,fbegindate ,fenddate from t_lic_licensedetail ");
             DataSet queryLicenseDetailNew = DB.queryDataSet((String)"querylicense_detail_new", (DBRoute)DBRoute.base, (String)"select fgroupid ,ftotalcount ,fbegindate ,fenddate from t_lic_licdetail_trial ");
             DataSet queryLicenseDetail = queryLicenseDetailNow.fullJoin(queryLicenseDetailNew).on("fgroupid", "fgroupid").select(new String[]{"ftotalcount totalCountNow", "fbegindate beginDateNow", "fenddate endDateNow"}, new String[]{"ftotalcount totalCountNew", "fbegindate beginDateNew", "fenddate endDateNew"}).finish();){
            Row row;
            Iterator iterator = queryLicenseDetail.iterator();
            do {
                if (!iterator.hasNext()) return false;
            } while (StringUtil.compare((String)((row = (Row)iterator.next()).getString("totalCountNow") + row.getString("beginDateNow") + row.getString("endDateNow")), (String)(row.getString("totalCountNew") + row.getString("beginDateNew") + row.getString("endDateNew"))) == 0);
            boolean bl = !LicenseUtil.isEnableAutoUpdateLicense();
            return bl;
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u662f\u5426\u5347\u7ea7\u51fa\u9519\uff0c\u6309\u7167\u81ea\u52a8\u66f4\u65b0\u8bb8\u53ef\u5f00\u5173\u5f39\u7a97", (Throwable)e);
            if (LicenseUtil.isEnableAutoUpdateLicense()) return false;
            return true;
        }
    }

    public static void initTrialTable() {
        try (TXHandle h = TX.requiresNew((String)"initTrialTable");){
            LicenseUpdateUtil.clearTrialTable();
            DB.execute((DBRoute)DBRoute.base, (String)"insert into t_lic_license_trial (fid,ftype,fprodinstcode,fproductid,fproductno,fsoftwarecode,findustry,fproductversion,fsoftwarename,factivedate,fexpdate,fprodid,fname) select fid,ftype,fprodinstcode,fproductid,fproductno,fsoftwarecode,findustry,fproductversion,fsoftwarename,factivedate,fexpdate,fprodid,fname from t_lic_license ");
            DB.execute((DBRoute)DBRoute.base, (String)"insert into t_lic_licdetail_trial (fentryid,fid,fseq,fgroupid,ftotalcount,fassignedcount,fremaincount,fbegindate,fenddate) select fentryid,fid,fseq,fgroupid,ftotalcount,fassignedcount,fremaincount,fbegindate,fenddate from t_lic_licensedetail");
            DB.execute((DBRoute)DBRoute.base, (String)"insert into T_LIC_LicGroupApps_trial (fdetailid,fentryid,fseq,fbizappid) select fdetailid,fentryid,fseq,fbizappid from T_LIC_LicenseGroupApps");
            DB.execute((DBRoute)DBRoute.base, (String)"insert into T_LIC_UserlicGroup_Trial (fid,fuserid,fgroupid,fsyncstatus,forgid,fmainorgname,fmainorgfullname,fassigntime,flicensesource,fstatus) select fid,fuserid,fgroupid,'1',forgid,fmainorgname,fmainorgfullname,fassigntime,flicensesource,'1' from T_LIC_UserLicenseGroup WHERE fsyncstatus  in('1','2')");
        }
    }

    public static LicenseSyncLog initLicenseSyncLog(LicenseSyncLog licenseSyncLog) {
        if (null == licenseSyncLog) {
            licenseSyncLog = new LicenseSyncLog();
            licenseSyncLog.setPkId(DB.genGlobalLongId());
        }
        if (null == licenseSyncLog.getPkId()) {
            licenseSyncLog.setPkId(DB.genGlobalLongId());
        }
        return licenseSyncLog;
    }

    public static void clearTrialTable() {
        try (TXHandle h = TX.required((String)"lic_clearTrialTable");){
            try {
                DB.execute((DBRoute)DBRoute.base, (String)"truncate table  t_lic_license_trial");
                DB.execute((DBRoute)DBRoute.base, (String)"truncate table t_lic_licdetail_trial");
                DB.execute((DBRoute)DBRoute.base, (String)"truncate table t_lic_licgroupapps_trial");
                DB.execute((DBRoute)DBRoute.base, (String)"truncate table t_lic_userlicgroup_trial ");
                logger.info("\u6e05\u7a7a\u8bd5\u7b97\u8868");
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                h.markRollback();
            }
        }
    }

    public static boolean restoreSnapAllAccount() {
        try {
            String tenantId = RequestContext.get().getTenantId();
            String curAccountId = RequestContext.get().getAccountId();
            String contextPath = RequestContext.get().getClientFullContextPath();
            if (contextPath.lastIndexOf("/") != contextPath.length() - 1) {
                contextPath = contextPath + "/";
            }
            Map<String, String> header = LicenseUpdateUtil.getHttpRequestJsonHeader();
            List accounts = AccountUtils.getAllAccounts((String)tenantId);
            for (Account account : accounts) {
                String accountId = account.getAccountId();
                if (accountId.equals(curAccountId)) continue;
                String accessToken = LicenseUtil.getAccessToken4LicApi(contextPath, tenantId, accountId);
                header.put("access_token", accessToken);
                String url = String.format("%skapi/app/base/UpdateLicense?accountId=%s", contextPath, accountId);
                HttpClientUtils.postjson((String)url, header, (String)JSONObject.toJSONString(new HashMap(0)), (int)300000, (int)500000);
            }
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528openapi\u8bb8\u53ef\u8bd5\u7b97\u5931\u8d25", (Throwable)e);
            return false;
        }
        return true;
    }

    private static Map<String, String> getHttpRequestJsonHeader() {
        HashMap<String, String> header = new HashMap<String, String>(4);
        header.put("Content-type", "application/json");
        header.put("charset", "utf-8");
        return header;
    }

    public static void updateLicAssignDataError(Long logId, List<Object> errorUserGroupPkIds) {
        if (CollectionUtils.isEmpty(errorUserGroupPkIds)) {
            return;
        }
        int batchCount = BigCollHandleUtil.getBatchCount(5000, errorUserGroupPkIds.size());
        List<List<Object>> subList = BigCollHandleUtil.averageAssign(errorUserGroupPkIds, batchCount);
        for (List<Object> subErrorIds : subList) {
            SqlBuilder updateExceptionStatus = new SqlBuilder().append("UPDATE t_lic_userlicensegroup SET FSYNCSTATUS = '3', FSTATUS = '0',fsynclogid = " + logId + ",fassigntime = now() ", new Object[0]).append(" where ", new Object[0]).appendIn("FID", subErrorIds);
            DB.execute((DBRoute)DBRoute.base, (SqlBuilder)updateExceptionStatus);
        }
    }

    public static boolean isPublicType(String data) {
        if (StringUtils.isBlank((CharSequence)data)) {
            return false;
        }
        try {
            JSONObject jsonResponse = JSONObject.parseObject((String)data);
            String licenseData = jsonResponse.getString("data");
            if (Encrypters.isEncrypted((String)licenseData)) {
                licenseData = Encrypters.decode((String)licenseData);
            }
            JSONArray licenses = JSONArray.parseArray((String)licenseData);
            JSONObject license = licenses.getJSONObject(0);
            JSONObject content = license.getJSONObject("content");
            String tenantType = content.getString("tenantType");
            return "public".equals(tenantType);
        }
        catch (Exception e) {
            logger.error("parseLicenseType error.", (Throwable)e);
            return false;
        }
    }

    public static boolean isBlankLicense() {
        return (Boolean)DB.query((DBRoute)DBRoute.base, (String)"select fid from t_lic_license ", rs -> rs.next()) == false;
    }

    public static boolean isBlankSnapshot() {
        return (Boolean)DB.query((DBRoute)DBRoute.base, (String)"select FDATA from T_LIC_Snapshot where fsnapshottype = '0' ", rs -> rs.next()) == false;
    }
}

