/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.license.util;

import com.tongtech.backport.java.util.Collections;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.license.LocalCache.UserIndexLocalCache;
import kd.bos.license.LocalCache.limit.FixedSizeMap;
import kd.bos.license.bean.UserIndex;
import kd.bos.license.callable.QueryUserIdByIndex;
import kd.bos.license.callable.QueryUserIndex;
import kd.bos.license.util.BigCollHandleUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;

public class UserIndexUtil {
    private static Log logger = LogFactory.getLog(UserIndexUtil.class);
    private static ThreadPool pool = ThreadPools.newFixedThreadPool((String)"Lic_UserIndex_Pool", (int)5);

    public static Map<Long, UserIndex> getUserIndexListBySet(Set<Long> userIdSet) {
        if (CollectionUtils.isEmpty(userIdSet)) {
            return Collections.emptyMap();
        }
        int size = userIdSet.size();
        HashMap<Long, UserIndex> map = new HashMap<Long, UserIndex>(size);
        FixedSizeMap<Long, UserIndex> allUserIndexs = UserIndexLocalCache.getAllUserIndexs();
        HashSet<Long> realUserIdSet = new HashSet<Long>(userIdSet);
        if (null != allUserIndexs && !CollectionUtils.isEmpty(allUserIndexs)) {
            for (Long userId : userIdSet) {
                UserIndex userIndex = (UserIndex)allUserIndexs.get(userId);
                if (null == userIndex) continue;
                realUserIdSet.remove(userId);
                map.put(userId, userIndex);
            }
        }
        if (realUserIdSet.size() == 0) {
            return map;
        }
        if (null == allUserIndexs) {
            allUserIndexs = new FixedSizeMap(size);
        }
        try {
            int subSize = BigCollHandleUtil.getBatchCount(5000, realUserIdSet.size());
            CountDownLatch countwnLatch = new CountDownLatch(subSize);
            ArrayList<Future> futureList = new ArrayList<Future>(subSize);
            List<List<Long>> listAvg = BigCollHandleUtil.averageAssign(new ArrayList<Long>(realUserIdSet), subSize);
            for (int i = 0; i < listAvg.size(); ++i) {
                List<Long> userIds = listAvg.get(i);
                Future oneList = pool.submit((Callable)new QueryUserIndex(new HashSet<Long>(userIds), countwnLatch));
                futureList.add(oneList);
            }
            countwnLatch.await();
            for (Future listFuture : futureList) {
                Map longUserIndexMap = (Map)listFuture.get();
                map.putAll(longUserIndexMap);
                allUserIndexs.putAll(longUserIndexMap);
            }
            UserIndexLocalCache.putAllUserIndexInfo(allUserIndexs);
        }
        catch (Exception var12) {
            Exception e = var12;
            logger.warn("UserIndexUtil.getUserIndexListBySet error", (Throwable)e);
            return Collections.emptyMap();
        }
        return map;
    }

    public static Map<Long, UserIndex> getUserIndexInfoByIds(Set<Long> userIdSet) {
        if (CollectionUtils.isEmpty(userIdSet)) {
            return Collections.emptyMap();
        }
        HashMap<Long, UserIndex> map = new HashMap<Long, UserIndex>(userIdSet.size());
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fid id,fbitmapindex bitmapindex,fciphertext  ciphertext from t_lic_userbitmapindex where ", new Object[0]);
        sqlBuilder.appendIn("fid", new ArrayList<Long>(userIdSet));
        try (DataSet dataSet = DB.queryDataSet((String)"UserIndexUtil.getUserIndexInfoByIds", (DBRoute)DBRoute.base, (SqlBuilder)sqlBuilder);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                map.put(row.getLong("id"), new UserIndex(row.getLong("id"), row.getInteger("bitmapindex"), row.getString("ciphertext")));
            }
        }
        return map;
    }

    public static Map<Long, UserIndex> getUserIdInfoByIndexs(Set<Integer> userIndex) {
        if (CollectionUtils.isEmpty(userIndex)) {
            return Collections.emptyMap();
        }
        HashMap<Long, UserIndex> map = new HashMap<Long, UserIndex>(userIndex.size());
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fid id,fbitmapindex bitmapindex,fciphertext  ciphertext from t_lic_userbitmapindex where ", new Object[0]);
        sqlBuilder.appendIn("fbitmapindex", new ArrayList<Integer>(userIndex));
        try (DataSet dataSet = DB.queryDataSet((String)"UserIndexUtil.getUserIndexInfoByIds", (DBRoute)DBRoute.base, (SqlBuilder)sqlBuilder);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                map.put(row.getLong("id"), new UserIndex(row.getLong("id"), row.getInteger("bitmapindex"), row.getString("ciphertext")));
            }
        }
        return map;
    }

    public static Map<Integer, Long> getUserIdListBySet(Set<Integer> userIndexs) {
        if (CollectionUtils.isEmpty(userIndexs)) {
            return Collections.emptyMap();
        }
        int size = userIndexs.size();
        HashMap<Integer, Long> map = new HashMap<Integer, Long>(size);
        HashMap results = new HashMap(size);
        FixedSizeMap<Long, UserIndex> allUserIndexs = UserIndexLocalCache.getAllUserIndexs();
        HashSet<Integer> realUserIndexSet = new HashSet<Integer>(userIndexs);
        if (null != allUserIndexs && !CollectionUtils.isEmpty(allUserIndexs)) {
            for (UserIndex userIndex : allUserIndexs.values()) {
                int index = userIndex.getIndex();
                if (!userIndexs.contains(index)) continue;
                map.put(index, userIndex.getUserId());
                realUserIndexSet.remove(index);
            }
        }
        if (realUserIndexSet.size() == 0) {
            return map;
        }
        if (null == allUserIndexs) {
            allUserIndexs = new FixedSizeMap(size);
        }
        try {
            int subSize = BigCollHandleUtil.getBatchCount(5000, userIndexs.size());
            CountDownLatch countwnLatch = new CountDownLatch(subSize);
            ArrayList<Future> futureList = new ArrayList<Future>(subSize);
            List<List<Integer>> listAvg = BigCollHandleUtil.averageAssign(new ArrayList<Integer>(userIndexs), subSize);
            for (int i = 0; i < listAvg.size(); ++i) {
                Object userIndex = listAvg.get(i);
                Future oneList = pool.submit((Callable)new QueryUserIdByIndex(new HashSet<Integer>((Collection<Integer>)userIndex), countwnLatch));
                futureList.add(oneList);
            }
            countwnLatch.await();
            for (Future listFuture : futureList) {
                Map longUserIndexMap = (Map)listFuture.get();
                results.putAll(longUserIndexMap);
                allUserIndexs.putAll(longUserIndexMap);
            }
            UserIndexLocalCache.putAllUserIndexInfo(allUserIndexs);
            if (!CollectionUtils.isEmpty(results)) {
                for (Object userIndex : results.values()) {
                    map.put(((UserIndex)userIndex).getIndex(), ((UserIndex)userIndex).getUserId());
                }
            }
        }
        catch (Exception var12) {
            Exception e = var12;
            logger.warn("UserIndexUtil.getUserIdListBySet error", (Throwable)e);
            return Collections.emptyMap();
        }
        return map;
    }
}

