/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.license.util;

import com.tongtech.backport.java.util.Collections;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.license.bean.User;
import kd.bos.license.callable.QueryUserInfo;
import kd.bos.license.util.BigCollHandleUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;

public class UserUtil {
    private static Log logger = LogFactory.getLog(UserUtil.class);
    private static ThreadPool pool = ThreadPools.newFixedThreadPool((String)"Lic_UserUtil_Pool", (int)5);

    public static List<User> getUserListBySet(Set<Long> userIdSet) {
        if (CollectionUtils.isEmpty(userIdSet)) {
            return Collections.emptyList();
        }
        int size = userIdSet.size();
        ArrayList<User> list = new ArrayList<User>(size);
        try {
            int subSize = BigCollHandleUtil.getBatchCount(5000, size);
            CountDownLatch countwnLatch = new CountDownLatch(subSize);
            ArrayList<Future> futureList = new ArrayList<Future>(subSize);
            List<List<Long>> listAvg = BigCollHandleUtil.averageAssign(new ArrayList<Long>(userIdSet), subSize);
            for (int i = 0; i < listAvg.size(); ++i) {
                List<Long> userIds = listAvg.get(i);
                Future oneList = pool.submit((Callable)new QueryUserInfo(new HashSet<Long>(userIds), countwnLatch));
                futureList.add(oneList);
            }
            countwnLatch.await();
            for (Future listFuture : futureList) {
                list.addAll((Collection)listFuture.get());
            }
        }
        catch (Exception var12) {
            Exception e = var12;
            logger.warn("UserUtil.getUserListBySet error", (Throwable)e);
            return Collections.emptyList();
        }
        return list;
    }

    public static List<User> getUserInfoByIds(Set<Long> userIdSet) {
        if (CollectionUtils.isEmpty(userIdSet)) {
            return Collections.emptyList();
        }
        ArrayList<User> list = new ArrayList<User>(userIdSet.size());
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"UserUtil.getUserInfoByIds", (String)"bos_user", (String)"id, number, phone, email, username,name, isforbidden,enable", (QFilter[])new QFilter[]{new QFilter("id", "in", userIdSet)}, (String)"");){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                list.add(new User(row.getLong("id"), row.getString("number"), row.getString("username"), row.getString("name"), row.getString("email"), row.getString("phone"), row.getBoolean("enable"), row.getBoolean("isforbidden")));
            }
        }
        return list;
    }
}

