/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.operate.webapi;

import java.util.Map;
import java.util.function.Supplier;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.Operations;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.operate.webapi.AbstractSave;
import kd.bos.entity.operate.webapi.SingleBillResult;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.operate.webapi.OperateDataConverter;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;

public class AppendEntryRows
extends AbstractSave {
    public ApiResult execute() {
        Map<String, Object> sourceDatas = this.getSourceDatas();
        IDataModel model = this.getView().getModel();
        Map<String, Object> sourceData = sourceDatas;
        OperationResult convResult = this.resolve(model, sourceData);
        SingleBillResult billResult = new SingleBillResult();
        billResult.setDIndex(0);
        OperationResult saveResult = null;
        if (convResult.isSuccess()) {
            DynamicObject billObj = model.getDataEntity(true);
            OperateOption option = OperateOption.create();
            option.setVariableValue("ignorewarn", String.valueOf(true));
            option.setVariableValue("ignoreinteraction", String.valueOf(true));
            option.setVariableValue("updateModifyDate", "false");
            option.setVariableValue("bos_save_appendentryrows", String.valueOf(true));
            option.setVariableValue("updateEntrySummaryEnable", String.valueOf(true));
            Operations ops = this.getSystemOpeations(this.getView().getFormShowParameter().getFormId());
            saveResult = OperationServiceHelper.executeOperate((String)ops.getSave(), (String)model.getDataEntityType().getName(), (DynamicObject[])new DynamicObject[]{billObj}, (OperateOption)option);
        } else {
            billResult.setSuccess(false);
            billResult.setMessage(convResult.getMessage());
        }
        return this.buildApiResult(model, billResult, saveResult);
    }

    private ApiResult buildApiResult(IDataModel model, SingleBillResult convResult, OperationResult saveResult) {
        if (saveResult != null && saveResult.isSuccess()) {
            return ApiResult.success((Object)saveResult);
        }
        ApiResult apiResult = new ApiResult();
        apiResult.setSuccess(false);
        if (saveResult != null) {
            apiResult.setMessage(AppendEntryRows.getFirstErrorMessage(saveResult));
            apiResult.setData((Object)saveResult);
        } else {
            apiResult.setMessage(convResult.getMessage());
            apiResult.setData(SingleBillResult.toMap(convResult));
        }
        return apiResult;
    }

    private Operations getSystemOpeations(String formId) {
        String entityTypeId = FormMetadataCache.getFormConfig((String)formId).getEntityTypeId();
        return EntityMetadataCache.getDataEntityOperations((String)entityTypeId);
    }

    private Map<String, Object> getSourceDatas() {
        Map dataObject = (Map)this.requestData.get("data");
        return dataObject;
    }

    @Override
    protected OperateDataConverter getDataConverter(IDataModel model) {
        Object requestStartIndex = this.requestData.get("starRowIndex");
        if (StringUtils.isBlank(requestStartIndex)) {
            requestStartIndex = this.requestData.get("startRowIndex");
        }
        String entryName = (String)this.requestData.get("entryName");
        DynamicObject root = ((IBillModel)model).getDataEntity();
        int startIndex = 0;
        startIndex = StringUtils.isBlank(requestStartIndex) ? this.getDBCurrentMaxSeq(model, entryName) : Integer.parseInt(String.valueOf(requestStartIndex));
        root.getDataEntityState().setEntryStartRowIndex(entryName, startIndex);
        root.getDataEntityState().setEntryRowCount(entryName, startIndex);
        return super.getDataConverter(model);
    }

    @Override
    protected OperationResult prepareDataEntity(IDataModel model, Map<String, Object> dataObject, Supplier<OperationResult> initializer) {
        OperationResult result = new OperationResult();
        if (dataObject == null) {
            return null;
        }
        Map option = (Map)this.requestData.get("option");
        Object pkId = dataObject.remove("id");
        if (null != pkId) {
            if (!this.isFirePropChanged()) {
                model.beginInit();
            }
            model.putContextVariable("MODEL_INIT_LOADHEADONLY", (Object)Boolean.TRUE);
            ((IBillModel)model).load(pkId, initializer);
            if (!this.isFirePropChanged()) {
                model.endInit();
            }
        }
        return result;
    }

    private int getDBCurrentMaxSeq(IDataModel model, String entryKey) {
        IDataEntityProperty property = model.getProperty(entryKey);
        String entryTableName = ((EntryProp)property).getItemType().getAlias();
        String dbRouteKey = model.getDataEntityType().getDBRouteKey();
        String fid = String.valueOf(model.getDataEntity().getPkValue());
        return DBServiceHelper.getDBCurrentMaxSeq((String)dbRouteKey, (String)entryTableName, (String)fid);
    }
}

